/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyNilClass;

@NodeChild(value="value")
public abstract class AssertConstantNode
extends RubyNode {
    private static volatile boolean[] sideEffect;

    public AssertConstantNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public AssertConstantNode(AssertConstantNode prev) {
        super(prev);
    }

    @Specialization
    public RubyNilClass assertCompilationConstant(Object value) {
        boolean[] compilationConstant = new boolean[]{CompilerDirectives.isCompilationConstant((Object)value) || CompilerDirectives.inInterpreter()};
        sideEffect = compilationConstant;
        if (!compilationConstant[0]) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new RaiseException(this.getContext().getCoreLibrary().internalError("Value was not constant", this));
        }
        return this.nil();
    }
}

