/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.UnboundMethodNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;

@GeneratedBy(value=UnboundMethodNodes.class)
public final class UnboundMethodNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(EqualNodeFactory.getInstance(), ArityNodeFactory.getInstance(), BindNodeFactory.getInstance(), NameNodeFactory.getInstance(), OriginNodeFactory.getInstance(), OwnerNodeFactory.getInstance(), SourceLocationNodeFactory.getInstance());
    }

    @GeneratedBy(value=UnboundMethodNodes.SourceLocationNode.class)
    public static final class SourceLocationNodeFactory
    extends NodeFactoryBase<UnboundMethodNodes.SourceLocationNode> {
        private static SourceLocationNodeFactory sourceLocationNodeFactoryInstance;

        private SourceLocationNodeFactory() {
            super(UnboundMethodNodes.SourceLocationNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public UnboundMethodNodes.SourceLocationNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SourceLocationNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static UnboundMethodNodes.SourceLocationNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SourceLocationUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<UnboundMethodNodes.SourceLocationNode> getInstance() {
            if (sourceLocationNodeFactoryInstance == null) {
                sourceLocationNodeFactoryInstance = new SourceLocationNodeFactory();
            }
            return sourceLocationNodeFactoryInstance;
        }

        @GeneratedBy(value=UnboundMethodNodes.SourceLocationNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SourceLocationPolymorphicNode
        extends SourceLocationBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SourceLocationPolymorphicNode(SourceLocationBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.SourceLocationNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SourceLocationRubyUnboundMethodNode
        extends SourceLocationBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SourceLocationRubyUnboundMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyUnboundMethod.class}, 0, 0);

            SourceLocationRubyUnboundMethodNode(SourceLocationBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyUnboundMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyUnboundMethod");
                }
                return super.sourceLocation(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    RubyUnboundMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(arguments0Value);
                    return super.sourceLocation(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.SourceLocationNode create0(UnboundMethodNodes.SourceLocationNode current) {
                return new SourceLocationRubyUnboundMethodNode((SourceLocationBaseNode)current);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.SourceLocationNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SourceLocationUninitializedNode
        extends SourceLocationBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SourceLocationUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SourceLocationUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SourceLocationUninitializedNode(SourceLocationBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SourceLocationBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SourceLocationBaseNode rootNode = (SourceLocationBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SourceLocationBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.SourceLocationNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SourceLocationUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.SourceLocationNode.class)
        private static abstract class SourceLocationBaseNode
        extends UnboundMethodNodes.SourceLocationNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SourceLocationBaseNode next0;

            SourceLocationBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SourceLocationBaseNode(SourceLocationBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SourceLocationBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SourceLocationBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SourceLocationUninitializedNode(this);
                    ((SourceLocationUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SourceLocationBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SourceLocationBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SourceLocationBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SourceLocationUninitializedNode(this), (Node)new SourceLocationPolymorphicNode(this), (DSLNode)((SourceLocationBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SourceLocationBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    return (SourceLocationBaseNode)SourceLocationRubyUnboundMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SourceLocationBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SourceLocationBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=UnboundMethodNodes.OwnerNode.class)
    public static final class OwnerNodeFactory
    extends NodeFactoryBase<UnboundMethodNodes.OwnerNode> {
        private static OwnerNodeFactory ownerNodeFactoryInstance;

        private OwnerNodeFactory() {
            super(UnboundMethodNodes.OwnerNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public UnboundMethodNodes.OwnerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OwnerNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static UnboundMethodNodes.OwnerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return OwnerUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<UnboundMethodNodes.OwnerNode> getInstance() {
            if (ownerNodeFactoryInstance == null) {
                ownerNodeFactoryInstance = new OwnerNodeFactory();
            }
            return ownerNodeFactoryInstance;
        }

        @GeneratedBy(value=UnboundMethodNodes.OwnerNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class OwnerPolymorphicNode
        extends OwnerBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            OwnerPolymorphicNode(OwnerBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.OwnerNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class OwnerRubyUnboundMethodNode
        extends OwnerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OwnerRubyUnboundMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyUnboundMethod.class}, 0, 0);

            OwnerRubyUnboundMethodNode(OwnerBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyUnboundMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyUnboundMethod");
                }
                return super.owner(arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    RubyUnboundMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(arguments0Value);
                    return super.owner(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.OwnerNode create0(UnboundMethodNodes.OwnerNode current) {
                return new OwnerRubyUnboundMethodNode((OwnerBaseNode)current);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.OwnerNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class OwnerUninitializedNode
        extends OwnerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OwnerUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            OwnerUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            OwnerUninitializedNode(OwnerBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                OwnerBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    OwnerBaseNode rootNode = (OwnerBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((OwnerBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.OwnerNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new OwnerUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.OwnerNode.class)
        private static abstract class OwnerBaseNode
        extends UnboundMethodNodes.OwnerNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected OwnerBaseNode next0;

            OwnerBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            OwnerBaseNode(OwnerBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                OwnerBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                OwnerBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new OwnerUninitializedNode(this);
                    ((OwnerUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (OwnerBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = OwnerBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (OwnerBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new OwnerUninitializedNode(this), (Node)new OwnerPolymorphicNode(this), (DSLNode)((OwnerBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final OwnerBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    return (OwnerBaseNode)OwnerRubyUnboundMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((OwnerBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (OwnerBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=UnboundMethodNodes.OriginNode.class)
    public static final class OriginNodeFactory
    extends NodeFactoryBase<UnboundMethodNodes.OriginNode> {
        private static OriginNodeFactory originNodeFactoryInstance;

        private OriginNodeFactory() {
            super(UnboundMethodNodes.OriginNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public UnboundMethodNodes.OriginNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return OriginNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static UnboundMethodNodes.OriginNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return OriginUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<UnboundMethodNodes.OriginNode> getInstance() {
            if (originNodeFactoryInstance == null) {
                originNodeFactoryInstance = new OriginNodeFactory();
            }
            return originNodeFactoryInstance;
        }

        @GeneratedBy(value=UnboundMethodNodes.OriginNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class OriginPolymorphicNode
        extends OriginBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            OriginPolymorphicNode(OriginBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.OriginNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class OriginRubyUnboundMethodNode
        extends OriginBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OriginRubyUnboundMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyUnboundMethod.class}, 0, 0);

            OriginRubyUnboundMethodNode(OriginBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyUnboundMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyUnboundMethod");
                }
                return super.origin(arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    RubyUnboundMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(arguments0Value);
                    return super.origin(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.OriginNode create0(UnboundMethodNodes.OriginNode current) {
                return new OriginRubyUnboundMethodNode((OriginBaseNode)current);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.OriginNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class OriginUninitializedNode
        extends OriginBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(OriginUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            OriginUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            OriginUninitializedNode(OriginBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyModule value;
                try {
                    value = this.executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyModule executeRubyModule(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyModule executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyModule executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                OriginBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    OriginBaseNode rootNode = (OriginBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((OriginBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.OriginNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new OriginUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.OriginNode.class)
        private static abstract class OriginBaseNode
        extends UnboundMethodNodes.OriginNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected OriginBaseNode next0;

            OriginBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            OriginBaseNode(OriginBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyModule executeChained0(VirtualFrame var1, Object var2);

            protected final RubyModule rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                OriginBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                OriginBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new OriginUninitializedNode(this);
                    ((OriginUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (OriginBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = OriginBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (OriginBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new OriginUninitializedNode(this), (Node)new OriginPolymorphicNode(this), (DSLNode)((OriginBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final OriginBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    return (OriginBaseNode)OriginRubyUnboundMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((OriginBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (OriginBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=UnboundMethodNodes.NameNode.class)
    public static final class NameNodeFactory
    extends NodeFactoryBase<UnboundMethodNodes.NameNode> {
        private static NameNodeFactory nameNodeFactoryInstance;

        private NameNodeFactory() {
            super(UnboundMethodNodes.NameNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public UnboundMethodNodes.NameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NameNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static UnboundMethodNodes.NameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NameUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<UnboundMethodNodes.NameNode> getInstance() {
            if (nameNodeFactoryInstance == null) {
                nameNodeFactoryInstance = new NameNodeFactory();
            }
            return nameNodeFactoryInstance;
        }

        @GeneratedBy(value=UnboundMethodNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NamePolymorphicNode
        extends NameBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            NamePolymorphicNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NameRubyUnboundMethodNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameRubyUnboundMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyUnboundMethod.class}, 0, 0);

            NameRubyUnboundMethodNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyUnboundMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyUnboundMethod");
                }
                return super.name(arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    RubyUnboundMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(arguments0Value);
                    return super.name(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.NameNode create0(UnboundMethodNodes.NameNode current) {
                return new NameRubyUnboundMethodNode((NameBaseNode)current);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.NameNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NameUninitializedNode
        extends NameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NameUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NameUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            NameUninitializedNode(NameBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubySymbol executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubySymbol executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NameBaseNode rootNode = (NameBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((NameBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.NameNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NameUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.NameNode.class)
        private static abstract class NameBaseNode
        extends UnboundMethodNodes.NameNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected NameBaseNode next0;

            NameBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            NameBaseNode(NameBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubySymbol executeChained0(VirtualFrame var1, Object var2);

            protected final RubySymbol rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                NameBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NameBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new NameUninitializedNode(this);
                    ((NameUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (NameBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = NameBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (NameBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NameUninitializedNode(this), (Node)new NamePolymorphicNode(this), (DSLNode)((NameBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NameBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    return (NameBaseNode)NameRubyUnboundMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((NameBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (NameBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=UnboundMethodNodes.BindNode.class)
    public static final class BindNodeFactory
    extends NodeFactoryBase<UnboundMethodNodes.BindNode> {
        private static BindNodeFactory bindNodeFactoryInstance;

        private BindNodeFactory() {
            super(UnboundMethodNodes.BindNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public UnboundMethodNodes.BindNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BindNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static UnboundMethodNodes.BindNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BindUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<UnboundMethodNodes.BindNode> getInstance() {
            if (bindNodeFactoryInstance == null) {
                bindNodeFactoryInstance = new BindNodeFactory();
            }
            return bindNodeFactoryInstance;
        }

        @GeneratedBy(value=UnboundMethodNodes.BindNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BindPolymorphicNode
        extends BindBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            BindPolymorphicNode(BindBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMethod value;
                try {
                    value = this.executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyMethod executeRubyMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.BindNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BindRubyUnboundMethodNode
        extends BindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BindRubyUnboundMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyUnboundMethod.class, Object.class}, 0, 0);

            BindRubyUnboundMethodNode(BindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMethod value;
                try {
                    value = this.executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyMethod executeRubyMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyUnboundMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyUnboundMethod");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.bind(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    RubyUnboundMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(arguments0Value);
                    return super.bind(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static UnboundMethodNodes.BindNode create0(UnboundMethodNodes.BindNode current) {
                return new BindRubyUnboundMethodNode((BindBaseNode)current);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.BindNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BindUninitializedNode
        extends BindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BindUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BindUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BindUninitializedNode(BindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMethod value;
                try {
                    value = this.executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyMethod executeRubyMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyMethod executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                BindBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BindBaseNode rootNode = (BindBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BindBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static UnboundMethodNodes.BindNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BindUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.BindNode.class)
        private static abstract class BindBaseNode
        extends UnboundMethodNodes.BindNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BindBaseNode next0;

            BindBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BindBaseNode(BindBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyMethod executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyMethod rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                BindBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BindBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new BindUninitializedNode(this);
                    ((BindUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BindBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = BindBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (BindBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BindUninitializedNode(this), (Node)new BindPolymorphicNode(this), (DSLNode)((BindBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BindBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    return (BindBaseNode)BindRubyUnboundMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    BindBaseNode otherCast = (BindBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (BindBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=UnboundMethodNodes.ArityNode.class)
    public static final class ArityNodeFactory
    extends NodeFactoryBase<UnboundMethodNodes.ArityNode> {
        private static ArityNodeFactory arityNodeFactoryInstance;

        private ArityNodeFactory() {
            super(UnboundMethodNodes.ArityNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public UnboundMethodNodes.ArityNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ArityNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static UnboundMethodNodes.ArityNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ArityUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<UnboundMethodNodes.ArityNode> getInstance() {
            if (arityNodeFactoryInstance == null) {
                arityNodeFactoryInstance = new ArityNodeFactory();
            }
            return arityNodeFactoryInstance;
        }

        @GeneratedBy(value=UnboundMethodNodes.ArityNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ArityPolymorphicNode
        extends ArityBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ArityPolymorphicNode(ArityBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.ArityNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ArityRubyUnboundMethodNode
        extends ArityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ArityRubyUnboundMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyUnboundMethod.class}, 0, 0);

            ArityRubyUnboundMethodNode(ArityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyUnboundMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyUnboundMethod");
                }
                return super.arity(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    RubyUnboundMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(arguments0Value);
                    return super.arity(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.ArityNode create0(UnboundMethodNodes.ArityNode current) {
                return new ArityRubyUnboundMethodNode((ArityBaseNode)current);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.ArityNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ArityUninitializedNode
        extends ArityBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ArityUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ArityUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ArityUninitializedNode(ArityBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ArityBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ArityBaseNode rootNode = (ArityBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ArityBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static UnboundMethodNodes.ArityNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ArityUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.ArityNode.class)
        private static abstract class ArityBaseNode
        extends UnboundMethodNodes.ArityNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ArityBaseNode next0;

            ArityBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ArityBaseNode(ArityBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ArityBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ArityBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ArityUninitializedNode(this);
                    ((ArityUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ArityBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ArityBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ArityBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ArityUninitializedNode(this), (Node)new ArityPolymorphicNode(this), (DSLNode)((ArityBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ArityBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    return (ArityBaseNode)ArityRubyUnboundMethodNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ArityBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ArityBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=UnboundMethodNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<UnboundMethodNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(UnboundMethodNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public UnboundMethodNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static UnboundMethodNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EqualUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<UnboundMethodNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=UnboundMethodNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyUnboundMethod.class ? this.arguments[1].executeRubyUnboundMethod(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyUnboundMethodObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyUnboundMethodObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyUnboundMethod.class, Object.class}, 0, 0);

            EqualRubyUnboundMethodObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyUnboundMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyUnboundMethod");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyUnboundMethod(arguments1Value)) {
                    return super.equal(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyUnboundMethod] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value) && !super.isRubyUnboundMethod(arguments1Value)) {
                    RubyUnboundMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(arguments0Value);
                    return super.equal(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static UnboundMethodNodes.EqualNode create0(UnboundMethodNodes.EqualNode current) {
                return new EqualRubyUnboundMethodObjectNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyUnboundMethodNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyUnboundMethodNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyUnboundMethod.class, RubyUnboundMethod.class}, 0, 0);

            EqualRubyUnboundMethodNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyUnboundMethod arguments1Value;
                RubyUnboundMethod arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyUnboundMethod");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyUnboundMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyUnboundMethod");
                }
                return super.equal(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments1Value)) {
                    RubyUnboundMethod arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(arguments0Value);
                    RubyUnboundMethod arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyUnboundMethod(arguments1Value);
                    return super.equal(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static UnboundMethodNodes.EqualNode create0(UnboundMethodNodes.EqualNode current) {
                return new EqualRubyUnboundMethodNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static UnboundMethodNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EqualUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=UnboundMethodNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends UnboundMethodNodes.EqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EqualBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyUnboundMethod(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyUnboundMethodNode.create0(this);
                    }
                    if (!super.isRubyUnboundMethod(arguments1Value)) {
                        return (EqualBaseNode)EqualRubyUnboundMethodObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

