/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeFactory;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;

@CoreClass(name="UnboundMethod")
public abstract class UnboundMethodNodes {

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodNode {
        public SourceLocationNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SourceLocationNode(SourceLocationNode prev) {
            super(prev);
        }

        @Specialization
        public Object sourceLocation(RubyUnboundMethod unboundMethod) {
            SourceLocationNode.notDesignedForCompilation();
            SourceSection sourceSection = unboundMethod.getMethod().getSharedMethodInfo().getSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.nil();
            }
            RubyString file = this.getContext().makeString(sourceSection.getSource().getName());
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), file, sourceSection.getStartLine());
        }
    }

    @CoreMethod(names={"owner"})
    public static abstract class OwnerNode
    extends CoreMethodNode {
        public OwnerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public OwnerNode(OwnerNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule owner(RubyUnboundMethod unboundMethod) {
            return unboundMethod.getMethod().getDeclaringModule();
        }
    }

    @CoreMethod(names={"origin"}, visibility=Visibility.PRIVATE)
    public static abstract class OriginNode
    extends CoreMethodNode {
        public OriginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public OriginNode(OriginNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule origin(RubyUnboundMethod unboundMethod) {
            return unboundMethod.getOrigin();
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodNode {
        public NameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NameNode(NameNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol name(RubyUnboundMethod unboundMethod) {
            NameNode.notDesignedForCompilation();
            return this.getContext().getSymbol(unboundMethod.getMethod().getName());
        }
    }

    @CoreMethod(names={"bind"}, required=1)
    public static abstract class BindNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public BindNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BindNode(BindNode prev) {
            super(prev);
            this.metaClassNode = prev.metaClassNode;
        }

        private RubyClass metaClass(VirtualFrame frame, Object object) {
            if (this.metaClassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.metaClassNode = (MetaClassNode)this.insert(MetaClassNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.metaClassNode.executeMetaClass(frame, object);
        }

        @Specialization
        public RubyMethod bind(VirtualFrame frame, RubyUnboundMethod unboundMethod, Object object) {
            BindNode.notDesignedForCompilation();
            RubyModule module = unboundMethod.getMethod().getDeclaringModule();
            if (module instanceof RubyClass && !ModuleOperations.canBindMethodTo(module, this.metaClass(frame, object))) {
                CompilerDirectives.transferToInterpreter();
                if (((RubyClass)module).isSingleton()) {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeError("singleton method called for a different object", this));
                }
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("bind argument must be an instance of " + module.getName(), this));
            }
            return new RubyMethod(this.getContext().getCoreLibrary().getMethodClass(), object, unboundMethod.getMethod());
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodNode {
        public ArityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ArityNode(ArityNode prev) {
            super(prev);
        }

        @Specialization
        public int arity(RubyUnboundMethod method) {
            return method.getMethod().getSharedMethodInfo().getArity().getArityNumber();
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        boolean equal(RubyUnboundMethod self, RubyUnboundMethod other) {
            return self.getMethod() == other.getMethod() && self.getOrigin() == other.getOrigin();
        }

        @Specialization(guards={"!isRubyUnboundMethod(arguments[1])"})
        boolean equal(RubyUnboundMethod self, Object other) {
            return false;
        }
    }
}

