/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.RubyGC;
import org.jruby.ast.Node;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.subsystems.SimpleShell;
import org.jruby.util.Memo;

@CoreClass(name="Truffle::Primitive")
public abstract class TrufflePrimitiveNodes {

    @CoreMethod(names={"debug_print"}, onSingleton=true, required=1)
    public static abstract class DebugPrintNode
    extends CoreMethodNode {
        public DebugPrintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DebugPrintNode(DebugPrintNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyNilClass debugPrint(RubyString string) {
            System.err.println(string.toString());
            return this.nil();
        }
    }

    @CoreMethod(names={"simple_shell"}, onSingleton=true)
    public static abstract class SimpleShellNode
    extends CoreMethodNode {
        public SimpleShellNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SimpleShellNode(SimpleShellNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyNilClass simpleShell() {
            new SimpleShell(this.getContext()).run(Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, true).materialize(), this);
            return this.nil();
        }
    }

    @CoreMethod(names={"graal_version"}, onSingleton=true)
    public static abstract class GraalVersionNode
    extends CoreMethodNode {
        public GraalVersionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GraalVersionNode(GraalVersionNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString graalVersion() {
            return this.getContext().makeString(System.getProperty("graal.version", "unknown"));
        }
    }

    @CoreMethod(names={"substrate?"}, onSingleton=true)
    public static abstract class SubstrateNode
    extends CoreMethodNode {
        public SubstrateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SubstrateNode(SubstrateNode prev) {
            super(prev);
        }

        @Specialization
        public boolean substrate() {
            this.getContext().getRuntime();
            return Ruby.isSubstrateVM();
        }
    }

    @CoreMethod(names={"graal?"}, onSingleton=true)
    public static abstract class GraalNode
    extends CoreMethodNode {
        public GraalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GraalNode(GraalNode prev) {
            super(prev);
        }

        @Specialization
        public boolean graal() {
            return Truffle.getRuntime().getName().toLowerCase(Locale.ENGLISH).contains("graal");
        }
    }

    @CoreMethod(names={"tree"}, onSingleton=true)
    public static abstract class TreeNode
    extends CoreMethodNode {
        public TreeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TreeNode(TreeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString tree() {
            TreeNode.notDesignedForCompilation();
            return this.getContext().makeString(NodeUtil.printCompactTreeToString((com.oracle.truffle.api.nodes.Node)Truffle.getRuntime().getCallerFrame().getCallNode().getRootNode()));
        }
    }

    @CoreMethod(names={"parse_tree"}, onSingleton=true)
    public static abstract class ParseTreeNode
    extends CoreMethodNode {
        public ParseTreeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ParseTreeNode(ParseTreeNode prev) {
            super(prev);
        }

        @Specialization
        public Object parseTree(VirtualFrame frame) {
            ParseTreeNode.notDesignedForCompilation();
            Node parseTree = RubyCallStack.getCallingMethod(frame).getSharedMethodInfo().getParseTree();
            if (parseTree == null) {
                return this.nil();
            }
            return this.getContext().makeString(parseTree.toString(true, 0));
        }
    }

    @CoreMethod(names={"panic"}, onSingleton=true)
    public static abstract class PanicNode
    extends CoreMethodNode {
        public PanicNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PanicNode(PanicNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass doPanic() {
            DebugOperations.panic(this.getContext(), this, null);
            return this.nil();
        }
    }

    @CoreMethod(names={"storage_class"}, onSingleton=true, required=1)
    public static abstract class StorageClassNode
    extends CoreMethodNode {
        public StorageClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StorageClassNode(StorageClassNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString storageClass(RubyArray array) {
            StorageClassNode.notDesignedForCompilation();
            if (array.getStore() == null) {
                return this.getContext().makeString("null");
            }
            return this.getContext().makeString(array.getStore().getClass().getName());
        }

        @Specialization
        public RubyString storageClass(RubyHash hash) {
            StorageClassNode.notDesignedForCompilation();
            if (hash.getStore() == null) {
                return this.getContext().makeString("null");
            }
            return this.getContext().makeString(hash.getStore().getClass().getName());
        }
    }

    @CoreMethod(names={"source_attribution_tree"}, onSingleton=true)
    public static abstract class SourceAttributionTreeNode
    extends CoreMethodNode {
        public SourceAttributionTreeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SourceAttributionTreeNode(SourceAttributionTreeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString sourceAttributionTree() {
            SourceAttributionTreeNode.notDesignedForCompilation();
            return this.getContext().makeString(NodeUtil.printSourceAttributionTree((com.oracle.truffle.api.nodes.Node)Truffle.getRuntime().getCallerFrame().getCallNode().getRootNode()));
        }
    }

    @CoreMethod(names={"dump_string"}, onSingleton=true, required=1)
    public static abstract class DumpStringNode
    extends CoreMethodNode {
        public DumpStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DumpStringNode(DumpStringNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString dumpString(RubyString string) {
            DumpStringNode.notDesignedForCompilation();
            StringBuilder builder = new StringBuilder();
            builder.append("\"");
            for (byte b : string.getBytes().unsafeBytes()) {
                builder.append(String.format("\\x%02x", b));
            }
            builder.append("\"");
            return this.getContext().makeString(builder.toString());
        }
    }

    @CoreMethod(names={"java_class_of"}, onSingleton=true, required=1)
    public static abstract class JavaClassOfNode
    extends CoreMethodNode {
        public JavaClassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public JavaClassOfNode(JavaClassOfNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString javaClassOf(Object value) {
            JavaClassOfNode.notDesignedForCompilation();
            return this.getContext().makeString(value.getClass().getName());
        }
    }

    @CoreMethod(names={"full_tree"}, onSingleton=true)
    public static abstract class FullTreeNode
    extends CoreMethodNode {
        public FullTreeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FullTreeNode(FullTreeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString fullTree() {
            FullTreeNode.notDesignedForCompilation();
            return this.getContext().makeString(NodeUtil.printTreeToString((com.oracle.truffle.api.nodes.Node)Truffle.getRuntime().getCallerFrame().getCallNode().getRootNode()));
        }
    }

    @CoreMethod(names={"flush_stdout"}, onSingleton=true)
    public static abstract class FlushStdoutNode
    extends CoreMethodNode {
        public FlushStdoutNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FlushStdoutNode(FlushStdoutNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass flush() {
            this.getContext().getRuntime().getOut().flush();
            return this.nil();
        }
    }

    @CoreMethod(names={"dump_call_stack"}, onSingleton=true)
    public static abstract class DumpCallStackNode
    extends CoreMethodNode {
        public DumpCallStackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DumpCallStackNode(DumpCallStackNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass dumpCallStack() {
            DumpCallStackNode.notDesignedForCompilation();
            for (String line : Backtrace.DEBUG_FORMATTER.format(this.getContext(), null, RubyCallStack.getBacktrace(this))) {
                System.err.println(line);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"assert_not_compiled"}, onSingleton=true)
    public static abstract class AssertNotCompiledNode
    extends CoreMethodNode {
        public AssertNotCompiledNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AssertNotCompiledNode(AssertNotCompiledNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass assertNotCompiled() {
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError("Truffle::Primitive.assert_not_compiled can only be called lexically", this));
        }
    }

    @CoreMethod(names={"assert_constant"}, onSingleton=true, required=1)
    public static abstract class AssertConstantNode
    extends CoreMethodNode {
        public AssertConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AssertConstantNode(AssertConstantNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass assertConstant(Object value) {
            throw new RaiseException(this.getContext().getCoreLibrary().runtimeError("Truffle::Primitive.assert_constant can only be called lexically", this));
        }
    }

    @CoreMethod(names={"gc_time"}, onSingleton=true)
    public static abstract class GCTimeNode
    extends CoreMethodNode {
        public GCTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GCTimeNode(GCTimeNode prev) {
            super(prev);
        }

        @Specialization
        public long gcTime() {
            return RubyGC.getCollectionTime();
        }
    }

    @CoreMethod(names={"gc_count"}, onSingleton=true)
    public static abstract class GCCountNode
    extends CoreMethodNode {
        public GCCountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GCCountNode(GCCountNode prev) {
            super(prev);
        }

        @Specialization
        public int gcCount() {
            return RubyGC.getCollectionCount();
        }
    }

    @CoreMethod(names={"source_of_caller"}, onSingleton=true)
    public static abstract class SourceOfCallerNode
    extends CoreMethodNode {
        public SourceOfCallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SourceOfCallerNode(SourceOfCallerNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString sourceOfCaller() {
            SourceOfCallerNode.notDesignedForCompilation();
            final Memo frameCount = new Memo((Object)0);
            String source = (String)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<String>(){

                public String visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getCallNode().getEncapsulatingSourceSection().getSource().getName();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            return this.getContext().makeString(source);
        }
    }

    @CoreMethod(names={"binding_of_caller"}, onSingleton=true)
    public static abstract class BindingOfCallerNode
    extends CoreMethodNode {
        public BindingOfCallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BindingOfCallerNode(BindingOfCallerNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBinding bindingOfCaller() {
            BindingOfCallerNode.notDesignedForCompilation();
            final Memo frameCount = new Memo((Object)0);
            MaterializedFrame frame = (MaterializedFrame)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<MaterializedFrame>(){

                public MaterializedFrame visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE, false).materialize();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            return new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(frame.getArguments()), frame);
        }
    }
}

