/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ThreadNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubyThread;

@GeneratedBy(value=ThreadNodes.class)
public final class ThreadNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AliveNodeFactory.getInstance(), CurrentNodeFactory.getInstance(), KillNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), JoinNodeFactory.getInstance(), MainNodeFactory.getInstance(), PassNodeFactory.getInstance(), RaiseNodeFactory.getInstance(), StatusNodeFactory.getInstance(), StopNodeFactory.getInstance(), ValueNodeFactory.getInstance(), WakeupNodeFactory.getInstance());
    }

    @GeneratedBy(value=ThreadNodes.WakeupNode.class)
    public static final class WakeupNodeFactory
    extends NodeFactoryBase<ThreadNodes.WakeupNode> {
        private static WakeupNodeFactory wakeupNodeFactoryInstance;

        private WakeupNodeFactory() {
            super(ThreadNodes.WakeupNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.WakeupNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return WakeupNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.WakeupNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return WakeupUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.WakeupNode> getInstance() {
            if (wakeupNodeFactoryInstance == null) {
                wakeupNodeFactoryInstance = new WakeupNodeFactory();
            }
            return wakeupNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.WakeupNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class WakeupPolymorphicNode
        extends WakeupBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            WakeupPolymorphicNode(WakeupBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyThread executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ThreadNodes.WakeupNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class WakeupRubyThreadNode
        extends WakeupBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(WakeupRubyThreadNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class}, 0, 0);

            WakeupRubyThreadNode(WakeupBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyThread");
                }
                return super.wakeup(arguments0Value);
            }

            @Override
            protected RubyThread executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    return super.wakeup(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.WakeupNode create0(ThreadNodes.WakeupNode current) {
                return new WakeupRubyThreadNode((WakeupBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.WakeupNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class WakeupUninitializedNode
        extends WakeupBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(WakeupUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            WakeupUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            WakeupUninitializedNode(WakeupBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyThread executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyThread executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                WakeupBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    WakeupBaseNode rootNode = (WakeupBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((WakeupBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.WakeupNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new WakeupUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.WakeupNode.class)
        private static abstract class WakeupBaseNode
        extends ThreadNodes.WakeupNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected WakeupBaseNode next0;

            WakeupBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            WakeupBaseNode(WakeupBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyThread executeChained0(VirtualFrame var1, Object var2);

            protected final RubyThread rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                WakeupBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                WakeupBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new WakeupUninitializedNode(this);
                    ((WakeupUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (WakeupBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = WakeupBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (WakeupBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new WakeupUninitializedNode(this), (Node)new WakeupPolymorphicNode(this), (DSLNode)((WakeupBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final WakeupBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    return (WakeupBaseNode)WakeupRubyThreadNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((WakeupBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (WakeupBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.ValueNode.class)
    public static final class ValueNodeFactory
    extends NodeFactoryBase<ThreadNodes.ValueNode> {
        private static ValueNodeFactory valueNodeFactoryInstance;

        private ValueNodeFactory() {
            super(ThreadNodes.ValueNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.ValueNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ValueNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.ValueNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ValueUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.ValueNode> getInstance() {
            if (valueNodeFactoryInstance == null) {
                valueNodeFactoryInstance = new ValueNodeFactory();
            }
            return valueNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.ValueNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ValuePolymorphicNode
        extends ValueBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ValuePolymorphicNode(ValueBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ThreadNodes.ValueNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ValueRubyThreadNode
        extends ValueBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValueRubyThreadNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class}, 0, 0);

            ValueRubyThreadNode(ValueBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyThread");
                }
                return super.value(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    return super.value(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.ValueNode create0(ThreadNodes.ValueNode current) {
                return new ValueRubyThreadNode((ValueBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.ValueNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ValueUninitializedNode
        extends ValueBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ValueUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ValueUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ValueUninitializedNode(ValueBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ValueBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ValueBaseNode rootNode = (ValueBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ValueBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.ValueNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ValueUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.ValueNode.class)
        private static abstract class ValueBaseNode
        extends ThreadNodes.ValueNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ValueBaseNode next0;

            ValueBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ValueBaseNode(ValueBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ValueBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ValueBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ValueUninitializedNode(this);
                    ((ValueUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ValueBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ValueBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ValueBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ValueUninitializedNode(this), (Node)new ValuePolymorphicNode(this), (DSLNode)((ValueBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ValueBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    return (ValueBaseNode)ValueRubyThreadNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ValueBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ValueBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.StopNode.class)
    public static final class StopNodeFactory
    extends NodeFactoryBase<ThreadNodes.StopNode> {
        private static StopNodeFactory stopNodeFactoryInstance;

        private StopNodeFactory() {
            super(ThreadNodes.StopNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.StopNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StopNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.StopNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StopUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.StopNode> getInstance() {
            if (stopNodeFactoryInstance == null) {
                stopNodeFactoryInstance = new StopNodeFactory();
            }
            return stopNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.StopNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StopPolymorphicNode
        extends StopBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            StopPolymorphicNode(StopBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ThreadNodes.StopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StopRubyThreadNode
        extends StopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StopRubyThreadNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class}, 0, 0);

            StopRubyThreadNode(StopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyThread");
                }
                return super.stop(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    return super.stop(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.StopNode create0(ThreadNodes.StopNode current) {
                return new StopRubyThreadNode((StopBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.StopNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StopUninitializedNode
        extends StopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StopUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StopUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StopUninitializedNode(StopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                StopBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StopBaseNode rootNode = (StopBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StopBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.StopNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StopUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.StopNode.class)
        private static abstract class StopBaseNode
        extends ThreadNodes.StopNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StopBaseNode next0;

            StopBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StopBaseNode(StopBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                StopBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StopBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new StopUninitializedNode(this);
                    ((StopUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StopBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StopBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (StopBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StopUninitializedNode(this), (Node)new StopPolymorphicNode(this), (DSLNode)((StopBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StopBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    return (StopBaseNode)StopRubyThreadNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((StopBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (StopBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.StatusNode.class)
    public static final class StatusNodeFactory
    extends NodeFactoryBase<ThreadNodes.StatusNode> {
        private static StatusNodeFactory statusNodeFactoryInstance;

        private StatusNodeFactory() {
            super(ThreadNodes.StatusNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.StatusNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StatusNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.StatusNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StatusUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.StatusNode> getInstance() {
            if (statusNodeFactoryInstance == null) {
                statusNodeFactoryInstance = new StatusNodeFactory();
            }
            return statusNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.StatusNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StatusPolymorphicNode
        extends StatusBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            StatusPolymorphicNode(StatusBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ThreadNodes.StatusNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StatusRubyThreadNode
        extends StatusBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StatusRubyThreadNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class}, 0, 0);

            StatusRubyThreadNode(StatusBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyThread");
                }
                return super.status(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    return super.status(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.StatusNode create0(ThreadNodes.StatusNode current) {
                return new StatusRubyThreadNode((StatusBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.StatusNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StatusUninitializedNode
        extends StatusBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StatusUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StatusUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StatusUninitializedNode(StatusBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                StatusBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StatusBaseNode rootNode = (StatusBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StatusBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.StatusNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StatusUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.StatusNode.class)
        private static abstract class StatusBaseNode
        extends ThreadNodes.StatusNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StatusBaseNode next0;

            StatusBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StatusBaseNode(StatusBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                StatusBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StatusBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new StatusUninitializedNode(this);
                    ((StatusUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StatusBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StatusBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (StatusBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StatusUninitializedNode(this), (Node)new StatusPolymorphicNode(this), (DSLNode)((StatusBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StatusBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    return (StatusBaseNode)StatusRubyThreadNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((StatusBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (StatusBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.RaiseNode.class)
    public static final class RaiseNodeFactory
    extends NodeFactoryBase<ThreadNodes.RaiseNode> {
        private static RaiseNodeFactory raiseNodeFactoryInstance;

        private RaiseNodeFactory() {
            super(ThreadNodes.RaiseNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.RaiseNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RaiseNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.RaiseNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RaiseUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.RaiseNode> getInstance() {
            if (raiseNodeFactoryInstance == null) {
                raiseNodeFactoryInstance = new RaiseNodeFactory();
            }
            return raiseNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.RaiseNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RaisePolymorphicNode
        extends RaiseBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            RaisePolymorphicNode(RaiseBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyClass.class ? this.arguments[1].executeRubyClass(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyString.class ? this.arguments[2].executeRubyString(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ThreadNodes.RaiseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RaiseRubyThreadRubyClassRubyStringNode
        extends RaiseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RaiseRubyThreadRubyClassRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class, RubyClass.class, RubyString.class}, 0, 0);

            RaiseRubyThreadRubyClassRubyStringNode(RaiseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments2Value;
                RubyClass arguments1Value;
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyThread");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyClass");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyString");
                }
                return super.raise(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyClass(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    RubyClass arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments1Value);
                    RubyString arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments2Value);
                    return super.raise(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ThreadNodes.RaiseNode create0(ThreadNodes.RaiseNode current) {
                return new RaiseRubyThreadRubyClassRubyStringNode((RaiseBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.RaiseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RaiseRubyThreadRubyClassUndefinedPlaceholderNode
        extends RaiseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RaiseRubyThreadRubyClassUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class, RubyClass.class, UndefinedPlaceholder.class}, 0, 0);

            RaiseRubyThreadRubyClassUndefinedPlaceholderNode(RaiseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyClass arguments1Value;
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyThread");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyClass");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.raise(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyClass(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    RubyClass arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.raise(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ThreadNodes.RaiseNode create0(ThreadNodes.RaiseNode current) {
                return new RaiseRubyThreadRubyClassUndefinedPlaceholderNode((RaiseBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.RaiseNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RaiseRubyThreadRubyStringUndefinedPlaceholderNode
        extends RaiseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RaiseRubyThreadRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            RaiseRubyThreadRubyStringUndefinedPlaceholderNode(RaiseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyThread");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.raise(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.raise(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ThreadNodes.RaiseNode create0(ThreadNodes.RaiseNode current) {
                return new RaiseRubyThreadRubyStringUndefinedPlaceholderNode((RaiseBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.RaiseNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RaiseUninitializedNode
        extends RaiseBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RaiseUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RaiseUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RaiseUninitializedNode(RaiseBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RaiseBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RaiseBaseNode rootNode = (RaiseBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RaiseBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ThreadNodes.RaiseNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RaiseUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.RaiseNode.class)
        private static abstract class RaiseBaseNode
        extends ThreadNodes.RaiseNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RaiseBaseNode next0;

            RaiseBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RaiseBaseNode(RaiseBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                RaiseBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RaiseBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new RaiseUninitializedNode(this);
                    ((RaiseUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RaiseBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RaiseBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (RaiseBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RaiseUninitializedNode(this), (Node)new RaisePolymorphicNode(this), (DSLNode)((RaiseBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RaiseBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                            return (RaiseBaseNode)RaiseRubyThreadRubyStringUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments1Value)) {
                            return (RaiseBaseNode)RaiseRubyThreadRubyClassUndefinedPlaceholderNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments2Value)) {
                        return (RaiseBaseNode)RaiseRubyThreadRubyClassRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    RaiseBaseNode otherCast = (RaiseBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (RaiseBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.PassNode.class)
    public static final class PassNodeFactory
    extends NodeFactoryBase<ThreadNodes.PassNode> {
        private static PassNodeFactory passNodeFactoryInstance;

        private PassNodeFactory() {
            super(ThreadNodes.PassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.PassNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PassNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.PassNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PassDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.PassNode> getInstance() {
            if (passNodeFactoryInstance == null) {
                passNodeFactoryInstance = new PassNodeFactory();
            }
            return passNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.PassNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PassDefaultNode
        extends PassBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PassDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            PassDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.pass(frameValue);
            }

            static ThreadNodes.PassNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PassDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.PassNode.class)
        private static abstract class PassBaseNode
        extends ThreadNodes.PassNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            PassBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.MainNode.class)
    public static final class MainNodeFactory
    extends NodeFactoryBase<ThreadNodes.MainNode> {
        private static MainNodeFactory mainNodeFactoryInstance;

        private MainNodeFactory() {
            super(ThreadNodes.MainNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.MainNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MainNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.MainNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MainDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.MainNode> getInstance() {
            if (mainNodeFactoryInstance == null) {
                mainNodeFactoryInstance = new MainNodeFactory();
            }
            return mainNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.MainNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MainDefaultNode
        extends MainBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MainDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            MainDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.main();
            }

            static ThreadNodes.MainNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MainDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.MainNode.class)
        private static abstract class MainBaseNode
        extends ThreadNodes.MainNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            MainBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.JoinNode.class)
    public static final class JoinNodeFactory
    extends NodeFactoryBase<ThreadNodes.JoinNode> {
        private static JoinNodeFactory joinNodeFactoryInstance;

        private JoinNodeFactory() {
            super(ThreadNodes.JoinNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.JoinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return JoinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.JoinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return JoinUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.JoinNode> getInstance() {
            if (joinNodeFactoryInstance == null) {
                joinNodeFactoryInstance = new JoinNodeFactory();
            }
            return joinNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class JoinPolymorphicNode
        extends JoinBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            JoinPolymorphicNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[1].executeFloat(frameValue)) : (this.arguments1PolymorphicType == RubyNilClass.class ? this.arguments[1].executeRubyNilClass(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class JoinObjectDoubleNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinObjectDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class, Double.TYPE}, 0, 0);

            JoinObjectDoubleNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments1Value;
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyThread");
                }
                try {
                    arguments1Value = this.arguments[1].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof double");
                }
                return super.join(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    double arguments1ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments1Value);
                    return super.join(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ThreadNodes.JoinNode create0(ThreadNodes.JoinNode current) {
                return new JoinObjectDoubleNode((JoinBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class JoinObjectIntNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinObjectIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class, Integer.TYPE}, 0, 0);

            JoinObjectIntNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyThread");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.join(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.join(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ThreadNodes.JoinNode create0(ThreadNodes.JoinNode current) {
                return new JoinObjectIntNode((JoinBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class JoinRubyThreadRubyNilClassNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinRubyThreadRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class, RubyNilClass.class}, 0, 0);

            JoinRubyThreadRubyNilClassNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyNilClass arguments1Value;
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyThread(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyThread"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyThread(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyNilClass"));
                }
                return super.join(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments1Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    RubyNilClass arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(arguments1Value);
                    return super.join(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ThreadNodes.JoinNode create0(ThreadNodes.JoinNode current) {
                return new JoinRubyThreadRubyNilClassNode((JoinBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class JoinRubyThreadUndefinedPlaceholderNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinRubyThreadUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class, UndefinedPlaceholder.class}, 0, 0);

            JoinRubyThreadUndefinedPlaceholderNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyThread(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyThread"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyThread(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                return super.join(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.join(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ThreadNodes.JoinNode create0(ThreadNodes.JoinNode current) {
                return new JoinRubyThreadUndefinedPlaceholderNode((JoinBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class JoinUninitializedNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            JoinUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            JoinUninitializedNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                JoinBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    JoinBaseNode rootNode = (JoinBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((JoinBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ThreadNodes.JoinNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new JoinUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.JoinNode.class)
        private static abstract class JoinBaseNode
        extends ThreadNodes.JoinNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected JoinBaseNode next0;

            JoinBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            JoinBaseNode(JoinBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                JoinBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                JoinBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new JoinUninitializedNode(this);
                    ((JoinUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (JoinBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = JoinBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (JoinBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new JoinUninitializedNode(this), (Node)new JoinPolymorphicNode(this), (DSLNode)((JoinBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final JoinBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (JoinBaseNode)JoinRubyThreadUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments1Value)) {
                        return (JoinBaseNode)JoinRubyThreadRubyNilClassNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        return (JoinBaseNode)JoinObjectIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(arguments1Value)) {
                        return (JoinBaseNode)JoinObjectDoubleNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    JoinBaseNode otherCast = (JoinBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (JoinBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<ThreadNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(ThreadNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ThreadNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyThreadNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyThreadNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class, RubyProc.class}, 0, 0);

            InitializeRubyThreadNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyThread");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.initialize(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ThreadNodes.InitializeNode create0(ThreadNodes.InitializeNode current) {
                return new InitializeRubyThreadNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = (InitializeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ThreadNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends ThreadNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeUninitializedNode(this), (Node)new InitializePolymorphicNode(this), (DSLNode)((InitializeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    return (InitializeBaseNode)InitializeRubyThreadNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.KillNode.class)
    public static final class KillNodeFactory
    extends NodeFactoryBase<ThreadNodes.KillNode> {
        private static KillNodeFactory killNodeFactoryInstance;

        private KillNodeFactory() {
            super(ThreadNodes.KillNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.KillNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KillNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.KillNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return KillUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.KillNode> getInstance() {
            if (killNodeFactoryInstance == null) {
                killNodeFactoryInstance = new KillNodeFactory();
            }
            return killNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.KillNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class KillPolymorphicNode
        extends KillBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            KillPolymorphicNode(KillBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyThread executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ThreadNodes.KillNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KillRubyThreadNode
        extends KillBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KillRubyThreadNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class}, 0, 0);

            KillRubyThreadNode(KillBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyThread");
                }
                return super.kill(arguments0Value);
            }

            @Override
            protected RubyThread executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    return super.kill(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.KillNode create0(ThreadNodes.KillNode current) {
                return new KillRubyThreadNode((KillBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.KillNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class KillUninitializedNode
        extends KillBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KillUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            KillUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            KillUninitializedNode(KillBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyThread executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyThread executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                KillBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    KillBaseNode rootNode = (KillBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((KillBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.KillNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new KillUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.KillNode.class)
        private static abstract class KillBaseNode
        extends ThreadNodes.KillNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected KillBaseNode next0;

            KillBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            KillBaseNode(KillBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyThread executeChained0(VirtualFrame var1, Object var2);

            protected final RubyThread rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                KillBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                KillBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new KillUninitializedNode(this);
                    ((KillUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (KillBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = KillBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (KillBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new KillUninitializedNode(this), (Node)new KillPolymorphicNode(this), (DSLNode)((KillBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final KillBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    return (KillBaseNode)KillRubyThreadNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((KillBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (KillBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.CurrentNode.class)
    public static final class CurrentNodeFactory
    extends NodeFactoryBase<ThreadNodes.CurrentNode> {
        private static CurrentNodeFactory currentNodeFactoryInstance;

        private CurrentNodeFactory() {
            super(ThreadNodes.CurrentNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.CurrentNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CurrentNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.CurrentNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CurrentDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.CurrentNode> getInstance() {
            if (currentNodeFactoryInstance == null) {
                currentNodeFactoryInstance = new CurrentNodeFactory();
            }
            return currentNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.CurrentNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CurrentDefaultNode
        extends CurrentBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CurrentDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            CurrentDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyThread value;
                try {
                    value = this.executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyThread executeRubyThread(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.current();
            }

            static ThreadNodes.CurrentNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CurrentDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.CurrentNode.class)
        private static abstract class CurrentBaseNode
        extends ThreadNodes.CurrentNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            CurrentBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ThreadNodes.AliveNode.class)
    public static final class AliveNodeFactory
    extends NodeFactoryBase<ThreadNodes.AliveNode> {
        private static AliveNodeFactory aliveNodeFactoryInstance;

        private AliveNodeFactory() {
            super(ThreadNodes.AliveNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ThreadNodes.AliveNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AliveNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ThreadNodes.AliveNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AliveUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ThreadNodes.AliveNode> getInstance() {
            if (aliveNodeFactoryInstance == null) {
                aliveNodeFactoryInstance = new AliveNodeFactory();
            }
            return aliveNodeFactoryInstance;
        }

        @GeneratedBy(value=ThreadNodes.AliveNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AlivePolymorphicNode
        extends AliveBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            AlivePolymorphicNode(AliveBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ThreadNodes.AliveNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AliveRubyThreadNode
        extends AliveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AliveRubyThreadNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyThread.class}, 0, 0);

            AliveRubyThreadNode(AliveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyThread arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyThread(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyThread");
                }
                return super.alive(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    RubyThread arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyThread(arguments0Value);
                    return super.alive(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.AliveNode create0(ThreadNodes.AliveNode current) {
                return new AliveRubyThreadNode((AliveBaseNode)current);
            }
        }

        @GeneratedBy(value=ThreadNodes.AliveNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AliveUninitializedNode
        extends AliveBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AliveUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AliveUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AliveUninitializedNode(AliveBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                AliveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AliveBaseNode rootNode = (AliveBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AliveBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ThreadNodes.AliveNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AliveUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ThreadNodes.AliveNode.class)
        private static abstract class AliveBaseNode
        extends ThreadNodes.AliveNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AliveBaseNode next0;

            AliveBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AliveBaseNode(AliveBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                AliveBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AliveBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new AliveUninitializedNode(this);
                    ((AliveUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AliveBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AliveBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (AliveBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AliveUninitializedNode(this), (Node)new AlivePolymorphicNode(this), (DSLNode)((AliveBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AliveBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyThread(arguments0Value)) {
                    return (AliveBaseNode)AliveRubyThreadNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((AliveBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (AliveBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

