/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.util.ByteList;

@CoreClass(name="Symbol")
public abstract class SymbolNodes {

    public static class SymbolNodesHelper {
        @CompilerDirectives.TruffleBoundary
        public static ByteList downcase(ByteList originalByteList) {
            ByteList byteList = originalByteList.dup();
            int length = byteList.length();
            for (int i = 0; i < length; ++i) {
                char c = byteList.charAt(i);
                if (c < 'A' || c > 'Z') continue;
                byteList.set(i, c ^ 0x20);
            }
            return byteList;
        }

        @CompilerDirectives.TruffleBoundary
        public static ByteList upcase(ByteList originalByteList) {
            ByteList byteList = originalByteList.dup();
            int length = byteList.length();
            for (int i = 0; i < length; ++i) {
                char c = byteList.charAt(i);
                if (c < 'a' || c > 'z') continue;
                byteList.set(i, c & 0x5F);
            }
            return byteList;
        }

        @CompilerDirectives.TruffleBoundary
        public static ByteList swapcase(ByteList originalByteList) {
            ByteList byteList = originalByteList.dup();
            int length = byteList.length();
            for (int i = 0; i < length; ++i) {
                char c = byteList.charAt(i);
                if (c >= 'a' && c <= 'z') {
                    byteList.set(i, c & 0x5F);
                    continue;
                }
                if (c < 'A' || c > 'Z') continue;
                byteList.set(i, c ^ 0x20);
            }
            return byteList;
        }

        @CompilerDirectives.TruffleBoundary
        public static ByteList capitalize(ByteList originalByteList) {
            char c;
            ByteList byteList = originalByteList.dup();
            int length = byteList.length();
            if (length > 0 && (c = byteList.charAt(0)) >= 'a' && c <= 'z') {
                byteList.set(0, c & 0x5F);
            }
            for (int i = 1; i < length; ++i) {
                char c2 = byteList.charAt(i);
                if (c2 < 'A' || c2 > 'Z') continue;
                byteList.set(i, c2 ^ 0x20);
            }
            return byteList;
        }
    }

    @CoreMethod(names={"upcase"})
    public static abstract class UpcaseNode
    extends CoreMethodNode {
        public UpcaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UpcaseNode(UpcaseNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol upcase(RubySymbol symbol) {
            UpcaseNode.notDesignedForCompilation();
            ByteList byteList = SymbolNodesHelper.upcase(symbol.getByteList());
            return this.getContext().getSymbol(byteList);
        }
    }

    @CoreMethod(names={"swapcase"})
    public static abstract class SwapcaseNode
    extends CoreMethodNode {
        public SwapcaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SwapcaseNode(SwapcaseNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol swapcase(RubySymbol symbol) {
            SwapcaseNode.notDesignedForCompilation();
            ByteList byteList = SymbolNodesHelper.swapcase(symbol.getByteList());
            return this.getContext().getSymbol(byteList);
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends CoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization
        public int size(RubySymbol symbol) {
            return symbol.getByteList().lengthEnc();
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString inspect(RubySymbol symbol) {
            InspectNode.notDesignedForCompilation();
            return this.getContext().makeString(symbol.getJRubySymbol().inspect(this.getContext().getRuntime().getCurrentContext()).asString().decodeString());
        }
    }

    @CoreMethod(names={"to_s", "id2name"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString toS(RubySymbol symbol) {
            return this.getContext().makeString(symbol.getSymbolBytes().dup());
        }
    }

    @CoreMethod(names={"to_sym"})
    public static abstract class ToSymNode
    extends CoreMethodNode {
        public ToSymNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSymNode(ToSymNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol toSym(RubySymbol symbol) {
            return symbol;
        }
    }

    @CoreMethod(names={"to_proc"})
    public static abstract class ToProcNode
    extends CoreMethodNode {
        public ToProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToProcNode(ToProcNode prev) {
            super(prev);
        }

        @Specialization
        public RubyProc toProc(RubySymbol symbol) {
            ToProcNode.notDesignedForCompilation();
            return symbol.toProc(Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection(), this);
        }
    }

    @CoreMethod(names={"intern"})
    public static abstract class InternNode
    extends CoreMethodNode {
        public InternNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InternNode(InternNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol intern(RubySymbol symbol) {
            return symbol;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public HashNode(HashNode prev) {
            super(prev);
        }

        @Specialization
        public int hash(RubySymbol symbol) {
            return symbol.toString().hashCode();
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodNode {
        public EncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodingNode(EncodingNode prev) {
            super(prev);
        }

        @Specialization
        public RubyEncoding encoding(RubySymbol symbol) {
            EncodingNode.notDesignedForCompilation();
            return RubyEncoding.getEncoding(symbol.getByteList().getEncoding());
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EmptyNode(EmptyNode prev) {
            super(prev);
        }

        @Specialization
        public boolean empty(RubySymbol symbol) {
            EmptyNode.notDesignedForCompilation();
            return symbol.toString().isEmpty();
        }
    }

    @CoreMethod(names={"downcase"})
    public static abstract class DowncaseNode
    extends CoreMethodNode {
        public DowncaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DowncaseNode(DowncaseNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol downcase(RubySymbol symbol) {
            DowncaseNode.notDesignedForCompilation();
            ByteList byteList = SymbolNodesHelper.downcase(symbol.getByteList());
            return this.getContext().getSymbol(byteList);
        }
    }

    @CoreMethod(names={"casecmp"}, required=1)
    public static abstract class CaseCompareNode
    extends CoreMethodNode {
        public CaseCompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CaseCompareNode(CaseCompareNode prev) {
            super(prev);
        }

        @Specialization
        public int caseCompare(RubySymbol symbol, RubySymbol other) {
            CaseCompareNode.notDesignedForCompilation();
            return symbol.getByteList().caseInsensitiveCmp(other.getByteList());
        }

        @Specialization(guards={"!isRubySymbol(arguments[1])"})
        public RubyNilClass caseCompare(RubySymbol symbol, Object other) {
            CaseCompareNode.notDesignedForCompilation();
            return this.nil();
        }
    }

    @CoreMethod(names={"capitalize"})
    public static abstract class CapitalizeNode
    extends CoreMethodNode {
        public CapitalizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CapitalizeNode(CapitalizeNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol capitalize(RubySymbol symbol) {
            CapitalizeNode.notDesignedForCompilation();
            ByteList byteList = SymbolNodesHelper.capitalize(symbol.getByteList());
            return this.getContext().getSymbol(byteList);
        }
    }

    @CoreMethod(names={"all_symbols"}, onSingleton=true)
    public static abstract class AllSymbolsNode
    extends CoreMethodNode {
        public AllSymbolsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AllSymbolsNode(AllSymbolsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray allSymbols() {
            AllSymbolsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            for (RubySymbol s : this.getContext().getSymbolTable().allSymbols()) {
                array.slowPush(s);
            }
            return array;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        @Specialization
        public int compare(RubySymbol a, RubySymbol b) {
            CompareNode.notDesignedForCompilation();
            return a.getByteList().cmp(b.getByteList());
        }

        @Specialization(guards={"!isRubySymbol(arguments[1])"})
        public RubyNilClass compare(RubySymbol symbol, Object other) {
            CompareNode.notDesignedForCompilation();
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(RubySymbol a, RubySymbol b) {
            return a == b;
        }

        @Specialization(guards={"!isRubySymbol(arguments[1])"})
        public boolean equal(RubySymbol a, Object b) {
            return false;
        }
    }
}

