/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import jnr.posix.POSIX;
import org.jcodings.Encoding;
import org.jcodings.exception.EncodingException;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.joni.Matcher;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.CmpIntNode;
import org.jruby.truffle.nodes.cast.CmpIntNodeFactory;
import org.jruby.truffle.nodes.cast.TaintResultNode;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeFactory;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.nodes.coerce.ToStrNodeFactory;
import org.jruby.truffle.nodes.core.ArrayCoreMethodNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumLowerNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.StringGuards;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeFactory;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.StringPrimitiveNodesFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.StringFormatter;
import org.jruby.truffle.runtime.rubinius.RubiniusByteArray;
import org.jruby.util.ByteList;
import org.jruby.util.ByteListHolder;
import org.jruby.util.CodeRangeable;
import org.jruby.util.ConvertDouble;
import org.jruby.util.Pack;
import org.jruby.util.StringSupport;
import org.jruby.util.io.EncodingUtils;

@CoreClass(name="String")
public abstract class StringNodes {

    public static class StringNodesHelper {
        @CompilerDirectives.TruffleBoundary
        public static ByteList upcase(Ruby runtime, ByteList string) {
            return runtime.newString(string).upcase(runtime.getCurrentContext()).getByteList();
        }

        @CompilerDirectives.TruffleBoundary
        public static ByteList downcase(Ruby runtime, ByteList string) {
            return runtime.newString(string).downcase(runtime.getCurrentContext()).getByteList();
        }

        public static int checkIndex(org.jruby.truffle.runtime.core.RubyString string, int index, RubyNode node) {
            if (index > string.length()) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > string.length()) {
                    CompilerDirectives.transferToInterpreter();
                    throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
                }
                index += string.length();
            }
            return index;
        }

        public static int checkIndexForRef(org.jruby.truffle.runtime.core.RubyString string, int index, RubyNode node) {
            int length = string.getByteList().getRealSize();
            if (index >= length) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
            }
            if (index < 0) {
                if (-index > length) {
                    CompilerDirectives.transferToInterpreter();
                    throw new org.jruby.truffle.runtime.control.RaiseException(node.getContext().getCoreLibrary().indexError(String.format("index %d out of string", index), node));
                }
                index += length;
            }
            return index;
        }

        @CompilerDirectives.TruffleBoundary
        public static void replaceInternal(org.jruby.truffle.runtime.core.RubyString string, int start, int length, org.jruby.truffle.runtime.core.RubyString replacement) {
            StringSupport.replaceInternal19((int)start, (int)length, (CodeRangeable)string, (CodeRangeable)replacement);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object trTransHelper(RubyContext context, org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString fromStr, org.jruby.truffle.runtime.core.RubyString toStr, boolean sFlag) {
            CodeRangeable ret = StringSupport.trTransHelper((Ruby)context.getRuntime(), (CodeRangeable)self, (CodeRangeable)fromStr, (CodeRangeable)toStr, (boolean)sFlag);
            if (ret == null) {
                return context.getCoreLibrary().getNilObject();
            }
            return ret;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends CoreMethodNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClearNode(ClearNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString clear(org.jruby.truffle.runtime.core.RubyString string) {
            ClearNode.notDesignedForCompilation();
            ByteList empty = ByteList.EMPTY_BYTELIST;
            empty.setEncoding(string.getBytes().getEncoding());
            string.set(empty);
            return string;
        }
    }

    @CoreMethod(names={"capitalize"}, taintFromSelf=true)
    public static abstract class CapitalizeNode
    extends CoreMethodNode {
        @Node.Child
        CallDispatchHeadNode capitalizeBangNode;
        @Node.Child
        CallDispatchHeadNode dupNode;

        public CapitalizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.capitalizeBangNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.dupNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public CapitalizeNode(CapitalizeNode prev) {
            super(prev);
            this.capitalizeBangNode = prev.capitalizeBangNode;
            this.dupNode = prev.dupNode;
        }

        @Specialization
        public Object capitalize(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string) {
            Object duped = this.dupNode.call(frame, string, "dup", null, new Object[0]);
            this.capitalizeBangNode.call(frame, duped, "capitalize!", null, new Object[0]);
            return duped;
        }
    }

    @CoreMethod(names={"capitalize!"}, raiseIfFrozenSelf=true)
    public static abstract class CapitalizeBangNode
    extends CoreMethodNode {
        private final ConditionProfile dummyEncodingProfile = ConditionProfile.createBinaryProfile();

        public CapitalizeBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CapitalizeBangNode(CapitalizeBangNode prev) {
            super(prev);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public RubyBasicObject capitalizeBang(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList value = string.getByteList();
            Encoding enc = value.getEncoding();
            if (this.dummyEncodingProfile.profile(enc.isDummy())) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (value.getRealSize() == 0) {
                return this.nil();
            }
            string.modifyAndKeepCodeRange();
            int s = value.getBegin();
            int end = s + value.getRealSize();
            byte[] bytes = value.getUnsafeBytes();
            boolean modify = false;
            int c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end);
            if (enc.isLower(c)) {
                enc.codeToMbc(StringSupport.toUpper((Encoding)enc, (int)c), bytes, s);
                modify = true;
            }
            s += StringSupport.codeLength((Encoding)enc, (int)c);
            while (s < end) {
                c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end);
                if (enc.isUpper(c)) {
                    enc.codeToMbc(StringSupport.toLower((Encoding)enc, (int)c), bytes, s);
                    modify = true;
                }
                s += StringSupport.codeLength((Encoding)enc, (int)c);
            }
            return modify ? string : this.nil();
        }
    }

    @CoreMethod(names={"valid_encoding?"})
    public static abstract class ValidEncodingQueryNode
    extends CoreMethodNode {
        public ValidEncodingQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ValidEncodingQueryNode(ValidEncodingQueryNode prev) {
            super(prev);
        }

        @Specialization
        public boolean validEncodingQuery(org.jruby.truffle.runtime.core.RubyString string) {
            return string.scanForCodeRange() != 48;
        }
    }

    @CoreMethod(names={"upcase!"}, raiseIfFrozenSelf=true)
    public static abstract class UpcaseBangNode
    extends CoreMethodNode {
        public UpcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UpcaseBangNode(UpcaseBangNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject upcaseBang(org.jruby.truffle.runtime.core.RubyString string) {
            UpcaseBangNode.notDesignedForCompilation();
            ByteList byteListString = StringNodesHelper.upcase(this.getContext().getRuntime(), string.getByteList());
            if (byteListString.equal(string.getByteList())) {
                return this.nil();
            }
            string.set(byteListString);
            return string;
        }
    }

    @CoreMethod(names={"upcase"}, taintFromSelf=true)
    public static abstract class UpcaseNode
    extends CoreMethodNode {
        public UpcaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UpcaseNode(UpcaseNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString upcase(org.jruby.truffle.runtime.core.RubyString string) {
            UpcaseNode.notDesignedForCompilation();
            ByteList byteListString = StringNodesHelper.upcase(this.getContext().getRuntime(), string.getByteList());
            return string.getContext().makeString(string.getLogicalClass(), byteListString);
        }
    }

    @CoreMethod(names={"unpack"}, required=1)
    public static abstract class UnpackNode
    extends ArrayCoreMethodNode {
        public UnpackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UnpackNode(UnpackNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray unpack(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString format) {
            RubyArray jrubyArray = Pack.unpack((Ruby)this.getContext().getRuntime(), (ByteList)string.getBytes(), (ByteList)format.getBytes());
            return org.jruby.truffle.runtime.core.RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), jrubyArray.toArray());
        }
    }

    @CoreMethod(names={"tr_s!"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(value="self"), @NodeChild(value="fromStr"), @NodeChild(value="toStrNode")})
    public static abstract class TrSBangNode
    extends RubyNode {
        @Node.Child
        private DeleteBangNode deleteBangNode;

        public TrSBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TrSBangNode(TrSBangNode prev) {
            super(prev);
            this.deleteBangNode = prev.deleteBangNode;
        }

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), toStr);
        }

        @Specialization
        public Object trSBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString fromStr, org.jruby.truffle.runtime.core.RubyString toStr) {
            if (self.getByteList().getRealSize() == 0) {
                return this.nil();
            }
            if (toStr.getByteList().getRealSize() == 0) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.deleteBangNode = (DeleteBangNode)this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.deleteBang(frame, self, fromStr);
            }
            return StringNodesHelper.trTransHelper(this.getContext(), self, fromStr, toStr, true);
        }
    }

    @CoreMethod(names={"tr!"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(value="self"), @NodeChild(value="fromStr"), @NodeChild(value="toStrNode")})
    public static abstract class TrBangNode
    extends RubyNode {
        @Node.Child
        private DeleteBangNode deleteBangNode;

        public TrBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public TrBangNode(TrBangNode prev) {
            super(prev);
            this.deleteBangNode = prev.deleteBangNode;
        }

        @CreateCast(value={"fromStr"})
        public RubyNode coerceFromStrToString(RubyNode fromStr) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), fromStr);
        }

        @CreateCast(value={"toStrNode"})
        public RubyNode coerceToStrToString(RubyNode toStr) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), toStr);
        }

        @Specialization
        public Object trBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString fromStr, org.jruby.truffle.runtime.core.RubyString toStr) {
            if (self.getByteList().getRealSize() == 0) {
                return this.nil();
            }
            if (toStr.getByteList().getRealSize() == 0) {
                if (this.deleteBangNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.deleteBangNode = (DeleteBangNode)this.insert(StringNodesFactory.DeleteBangNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
                }
                return this.deleteBangNode.deleteBang(frame, self, fromStr);
            }
            return StringNodesHelper.trTransHelper(this.getContext(), self, fromStr, toStr, false);
        }
    }

    @CoreMethod(names={"reverse!"}, raiseIfFrozenSelf=true)
    @ImportGuards(value={StringGuards.class})
    public static abstract class ReverseBangNode
    extends CoreMethodNode {
        public ReverseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReverseBangNode(ReverseBangNode prev) {
            super(prev);
        }

        @Specialization(guards={"reverseIsEqualToSelf"})
        public org.jruby.truffle.runtime.core.RubyString reverseNoOp(org.jruby.truffle.runtime.core.RubyString string) {
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf", "isSingleByteOptimizable"})
        public org.jruby.truffle.runtime.core.RubyString reverseSingleByteOptimizable(org.jruby.truffle.runtime.core.RubyString string) {
            string.modify();
            byte[] bytes = string.getByteList().getUnsafeBytes();
            int p = string.getByteList().getBegin();
            int len = string.getByteList().getRealSize();
            for (int i = 0; i < len >> 1; ++i) {
                byte b = bytes[p + i];
                bytes[p + i] = bytes[p + len - i - 1];
                bytes[p + len - i - 1] = b;
            }
            return string;
        }

        @Specialization(guards={"!reverseIsEqualToSelf", "!isSingleByteOptimizable"})
        public org.jruby.truffle.runtime.core.RubyString reverse(org.jruby.truffle.runtime.core.RubyString string) {
            string.modify();
            byte[] bytes = string.getByteList().getUnsafeBytes();
            int p = string.getByteList().getBegin();
            int len = string.getByteList().getRealSize();
            Encoding enc = string.getByteList().getEncoding();
            int end = p + len;
            int op = len;
            byte[] obytes = new byte[len];
            boolean single = true;
            while (p < end) {
                int cl = StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
                if (cl > 1 || (bytes[p] & 0x80) != 0) {
                    single = false;
                    System.arraycopy(bytes, p, obytes, op -= cl, cl);
                    p += cl;
                    continue;
                }
                obytes[--op] = bytes[p++];
            }
            string.getByteList().setUnsafeBytes(obytes);
            if (string.getCodeRange() == 0) {
                string.setCodeRange(single ? 16 : 32);
            }
            return string;
        }

        public static boolean reverseIsEqualToSelf(org.jruby.truffle.runtime.core.RubyString string) {
            return string.getByteList().getRealSize() <= 1;
        }
    }

    @CoreMethod(names={"to_sym", "intern"})
    public static abstract class ToSymNode
    extends CoreMethodNode {
        public ToSymNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSymNode(ToSymNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol toSym(org.jruby.truffle.runtime.core.RubyString string) {
            ToSymNode.notDesignedForCompilation();
            return this.getContext().getSymbol(string.getByteList());
        }
    }

    @CoreMethod(names={"to_s", "to_str"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization(guards={"!isStringSubclass"})
        public org.jruby.truffle.runtime.core.RubyString toS(org.jruby.truffle.runtime.core.RubyString string) {
            return string;
        }

        @Specialization(guards={"isStringSubclass"})
        public Object toSOnSubclass(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string) {
            return this.ruby(frame, "''.replace(self)", "self", string);
        }

        public boolean isStringSubclass(org.jruby.truffle.runtime.core.RubyString string) {
            return string.getLogicalClass() != this.getContext().getCoreLibrary().getStringClass();
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToFNode(ToFNode prev) {
            super(prev);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public double toF(org.jruby.truffle.runtime.core.RubyString string) {
            try {
                return this.convertToDouble(string);
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private double convertToDouble(org.jruby.truffle.runtime.core.RubyString string) {
            return ConvertDouble.byteListToDouble19((ByteList)string.getByteList(), (boolean)false);
        }
    }

    @CoreMethod(names={"sum"}, optional=1)
    public static abstract class SumNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode addNode;
        @Node.Child
        private CallDispatchHeadNode subNode;
        @Node.Child
        private CallDispatchHeadNode shiftNode;
        @Node.Child
        private CallDispatchHeadNode andNode;

        public SumNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.addNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.subNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.shiftNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.andNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public SumNode(SumNode prev) {
            super(prev);
            this.addNode = prev.addNode;
            this.subNode = prev.subNode;
            this.shiftNode = prev.shiftNode;
            this.andNode = prev.andNode;
        }

        @Specialization
        public Object sum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int bits) {
            return this.sum(frame, string, (long)bits);
        }

        @Specialization
        public Object sum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, long bits) {
            byte[] bytes = string.getByteList().getUnsafeBytes();
            int p = string.getByteList().getBegin();
            int len = string.getByteList().getRealSize();
            int end = p + len;
            if (bits >= 64L) {
                Object sum = 0;
                while (p < end) {
                    sum = this.addNode.call(frame, sum, "+", null, bytes[p++] & 0xFF);
                }
                if (bits != 0L) {
                    Object mod = this.shiftNode.call(frame, 1, "<<", null, bits);
                    sum = this.andNode.call(frame, sum, "&", null, this.subNode.call(frame, mod, "-", null, 1));
                }
                return sum;
            }
            long sum = 0L;
            while (p < end) {
                sum += (long)(bytes[p++] & 0xFF);
            }
            return bits == 0L ? sum : sum & (1L << (int)bits) - 1L;
        }

        @Specialization
        public Object sum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, UndefinedPlaceholder bits) {
            return this.sum(frame, string, 16);
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object sum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object bits) {
            return this.ruby(frame, "sum Rubinius::Type.coerce_to(bits, Fixnum, :to_int)", "bits", bits);
        }
    }

    @CoreMethod(names={"succ!"}, raiseIfFrozenSelf=true)
    public static abstract class SuccBangNode
    extends CoreMethodNode {
        public SuccBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SuccBangNode(SuccBangNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString succBang(org.jruby.truffle.runtime.core.RubyString string) {
            SuccBangNode.notDesignedForCompilation();
            if (string.getByteList().getRealSize() > 0) {
                string.set(StringSupport.succCommon((Ruby)this.getContext().getRuntime(), (ByteList)string.getBytes()));
            }
            return string;
        }
    }

    @CoreMethod(names={"succ"}, taintFromSelf=true)
    public static abstract class SuccNode
    extends CoreMethodNode {
        public SuccNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SuccNode(SuccNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString succ(org.jruby.truffle.runtime.core.RubyString string) {
            SuccNode.notDesignedForCompilation();
            if (string.length() > 0) {
                return this.getContext().makeString(string.getLogicalClass(), StringSupport.succCommon((Ruby)this.getContext().getRuntime(), (ByteList)string.getBytes()));
            }
            return this.getContext().makeString(string.getLogicalClass(), "");
        }
    }

    @CoreMethod(names={"squeeze!"}, argumentsAsArray=true, raiseIfFrozenSelf=true)
    public static abstract class SqueezeBangNode
    extends CoreMethodNode {
        private ConditionProfile singleByteOptimizableProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private ToStrNode toStrNode;

        public SqueezeBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SqueezeBangNode(SqueezeBangNode prev) {
            super(prev);
            this.toStrNode = prev.toStrNode;
        }

        @Specialization(guards={"zeroArgs"})
        public Object squeezeBangZeroArgs(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object ... args) {
            if (string.getBytes().length() == 0) {
                return this.nil();
            }
            boolean[] squeeze = new boolean[256];
            for (int i = 0; i < 256; ++i) {
                squeeze[i] = true;
            }
            string.modifyAndKeepCodeRange();
            if (this.singleByteOptimizableProfile.profile(string.singleByteOptimizable()) ? !StringSupport.singleByteSqueeze((ByteList)string.getByteList(), (boolean[])squeeze) : !this.squeezeCommonMultiByte(string.getByteList(), squeeze, null, string.getByteList().getEncoding(), false)) {
                return this.nil();
            }
            return string;
        }

        @Specialization(guards={"!zeroArgs"})
        public Object squeezeBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object ... args) {
            if (string.getBytes().length() == 0) {
                return this.nil();
            }
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            org.jruby.truffle.runtime.core.RubyString[] otherStrings = new org.jruby.truffle.runtime.core.RubyString[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStrNode.executeRubyString(frame, args[i]);
            }
            org.jruby.truffle.runtime.core.RubyString otherStr = otherStrings[0];
            Encoding enc = string.checkEncoding(otherStr, this);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)otherStr.getByteList(), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            boolean singlebyte = string.singleByteOptimizable() && otherStr.singleByteOptimizable();
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                enc = string.checkEncoding(otherStr);
                singlebyte = singlebyte && otherStr.singleByteOptimizable();
                tables = StringSupport.trSetupTable((ByteList)otherStr.getByteList(), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            string.modifyAndKeepCodeRange();
            if (this.singleByteOptimizableProfile.profile(singlebyte) ? !StringSupport.singleByteSqueeze((ByteList)string.getByteList(), (boolean[])squeeze) : !StringSupport.multiByteSqueeze((Ruby)this.getContext().getRuntime(), (ByteList)string.getByteList(), (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)true)) {
                return this.nil();
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean squeezeCommonMultiByte(ByteList value, boolean[] squeeze, StringSupport.TrTables tables, Encoding enc, boolean isArg) {
            return StringSupport.multiByteSqueeze((Ruby)this.getContext().getRuntime(), (ByteList)value, (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc, (boolean)isArg);
        }

        public static boolean zeroArgs(org.jruby.truffle.runtime.core.RubyString string, Object ... args) {
            return args.length == 0;
        }
    }

    @CoreMethod(names={"size", "length"})
    @ImportGuards(value={StringGuards.class})
    public static abstract class SizeNode
    extends CoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        public abstract int executeIntegerFixnum(VirtualFrame var1, org.jruby.truffle.runtime.core.RubyString var2);

        @Specialization(guards={"isSingleByteOptimizable"})
        public int sizeSingleByte(org.jruby.truffle.runtime.core.RubyString string) {
            return string.getByteList().getRealSize();
        }

        @Specialization(guards={"!isSingleByteOptimizable"})
        public int size(org.jruby.truffle.runtime.core.RubyString string) {
            return StringSupport.strLengthFromRubyString((CodeRangeable)string);
        }
    }

    @CoreMethod(names={"setbyte"}, required=2, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(value="string"), @NodeChild(value="index"), @NodeChild(value="value")})
    public static abstract class SetByteNode
    extends RubyNode {
        public SetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetByteNode(SetByteNode prev) {
            super(prev);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return new FixnumLowerNode(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), index));
        }

        @CreateCast(value={"value"})
        public RubyNode coerceValueToInt(RubyNode value) {
            return new FixnumLowerNode(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), value));
        }

        @Specialization
        public int setByte(org.jruby.truffle.runtime.core.RubyString string, int index, int value) {
            int normalizedIndex = StringNodesHelper.checkIndexForRef(string, index, this);
            string.modify();
            string.clearCodeRange();
            string.getByteList().getUnsafeBytes()[normalizedIndex] = (byte)value;
            return value;
        }
    }

    @CoreMethod(names={"scan"}, required=1, needsBlock=true, taintFromParameter=0)
    public static abstract class ScanNode
    extends YieldingCoreMethodNode {
        public ScanNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ScanNode(ScanNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray scan(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString regexpString, UndefinedPlaceholder block) {
            ScanNode.notDesignedForCompilation();
            RubyRegexp regexp = new RubyRegexp((Node)this, this.getContext().getCoreLibrary().getRegexpClass(), regexpString.getBytes(), 0);
            return this.scan(string, regexp, block);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString scan(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString regexpString, RubyProc block) {
            ScanNode.notDesignedForCompilation();
            RubyRegexp regexp = new RubyRegexp((Node)this, this.getContext().getCoreLibrary().getRegexpClass(), regexpString.getBytes(), 0);
            return this.scan(frame, string, regexp, block);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray scan(org.jruby.truffle.runtime.core.RubyString string, RubyRegexp regexp, UndefinedPlaceholder block) {
            ScanNode.notDesignedForCompilation();
            return org.jruby.truffle.runtime.core.RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), (Object[])regexp.scan(string));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString scan(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRegexp regexp, RubyProc block) {
            ScanNode.notDesignedForCompilation();
            RubyContext context = this.getContext();
            byte[] stringBytes = string.getBytes().bytes();
            Encoding encoding = string.getBytes().getEncoding();
            Matcher matcher = regexp.getRegex().matcher(stringBytes);
            int p = string.getBytes().getBegin();
            int end = 0;
            int range = p + string.getBytes().getRealSize();
            Object lastGoodMatchData = this.nil();
            if (regexp.getRegex().numberOfCaptures() == 0) {
                Object matchData;
                while ((matchData = regexp.matchCommon(string, false, true, matcher, p + end, range)) != context.getCoreLibrary().getNilObject()) {
                    RubyMatchData md = (RubyMatchData)matchData;
                    Object[] values = md.getValues();
                    assert (values.length == 1);
                    this.yield(frame, block, values[0]);
                    lastGoodMatchData = matchData;
                    end = StringSupport.positionEndForScan((ByteList)string.getBytes(), (Matcher)matcher, (Encoding)encoding, (int)p, (int)range);
                }
                regexp.setThread("$~", lastGoodMatchData);
            } else {
                Object matchData;
                while ((matchData = regexp.matchCommon(string, false, true, matcher, p + end, stringBytes.length)) != context.getCoreLibrary().getNilObject()) {
                    Object[] captures = ((RubyMatchData)matchData).getCaptures();
                    this.yield(frame, block, new org.jruby.truffle.runtime.core.RubyArray(context.getCoreLibrary().getArrayClass(), captures, captures.length));
                    lastGoodMatchData = matchData;
                    end = StringSupport.positionEndForScan((ByteList)string.getBytes(), (Matcher)matcher, (Encoding)encoding, (int)p, (int)range);
                }
                regexp.setThread("$~", lastGoodMatchData);
            }
            return string;
        }
    }

    @CoreMethod(names={"dump"}, taintFromSelf=true)
    @ImportGuards(value={StringGuards.class})
    public static abstract class DumpNode
    extends CoreMethodNode {
        public DumpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DumpNode(DumpNode prev) {
            super(prev);
        }

        @Specialization(guards={"isAsciiCompatible"})
        public org.jruby.truffle.runtime.core.RubyString dumpAsciiCompatible(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList outputBytes = this.dumpCommon(string);
            org.jruby.truffle.runtime.core.RubyString result = this.getContext().makeString(string.getLogicalClass(), outputBytes);
            result.getByteList().setEncoding(string.getByteList().getEncoding());
            result.setCodeRange(16);
            return result;
        }

        @Specialization(guards={"!isAsciiCompatible"})
        public org.jruby.truffle.runtime.core.RubyString dump(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList outputBytes = this.dumpCommon(string);
            try {
                outputBytes.append(".force_encoding(\"".getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
            outputBytes.append(string.getByteList().getEncoding().getName());
            outputBytes.append((byte)34);
            outputBytes.append((byte)41);
            org.jruby.truffle.runtime.core.RubyString result = this.getContext().makeString(string.getLogicalClass(), outputBytes);
            result.getByteList().setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            result.setCodeRange(16);
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private ByteList dumpCommon(org.jruby.truffle.runtime.core.RubyString string) {
            return StringSupport.dumpCommon((Ruby)this.getContext().getRuntime(), (ByteList)string.getByteList());
        }
    }

    @CoreMethod(names={"swapcase!"}, raiseIfFrozenSelf=true)
    @ImportGuards(value={StringGuards.class})
    public static abstract class SwapcaseBangNode
    extends CoreMethodNode {
        private final ConditionProfile dummyEncodingProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile singleByteOptimizableProfile = ConditionProfile.createBinaryProfile();

        public SwapcaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SwapcaseBangNode(SwapcaseBangNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject swapcaseSingleByte(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList value = string.getByteList();
            Encoding enc = value.getEncoding();
            if (this.dummyEncodingProfile.profile(enc.isDummy())) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(String.format("incompatible encoding with this operation: %s", enc), this));
            }
            if (value.getRealSize() == 0) {
                return this.nil();
            }
            string.modifyAndKeepCodeRange();
            int s = value.getBegin();
            int end = s + value.getRealSize();
            byte[] bytes = value.getUnsafeBytes();
            if (this.singleByteOptimizableProfile.profile(StringSupport.isSingleByteOptimizable((CodeRangeable)string, (Encoding)enc)) ? StringSupport.singleByteSwapcase((byte[])bytes, (int)s, (int)end) : StringSupport.multiByteSwapcase((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)s, (int)end)) {
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"rstrip!"}, raiseIfFrozenSelf=true)
    @ImportGuards(value={StringGuards.class})
    public static abstract class RstripBangNode
    extends CoreMethodNode {
        public RstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RstripBangNode(RstripBangNode prev) {
            super(prev);
        }

        @Specialization(guards={"isSingleByteOptimizable"})
        public Object rstripBangSingleByte(org.jruby.truffle.runtime.core.RubyString string) {
            int endp;
            if (string.getByteList().getRealSize() == 0) {
                return this.nil();
            }
            byte[] bytes = string.getByteList().getUnsafeBytes();
            int start = string.getByteList().getBegin();
            int end = start + string.getByteList().getRealSize();
            for (endp = end - 1; endp >= start && (bytes[endp] == 0 || ASCIIEncoding.INSTANCE.isSpace(bytes[endp] & 0xFF)); --endp) {
            }
            if (endp < end - 1) {
                string.getByteList().view(0, endp - start + 1);
                string.keepCodeRange();
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable"})
        public Object rstripBang(org.jruby.truffle.runtime.core.RubyString string) {
            int point;
            int prev;
            int end;
            if (string.getByteList().getRealSize() == 0) {
                return this.nil();
            }
            Encoding enc = EncodingUtils.STR_ENC_GET((ByteListHolder)string);
            byte[] bytes = string.getByteList().getUnsafeBytes();
            int start = string.getByteList().getBegin();
            int endp = end = start + string.getByteList().getRealSize();
            while ((prev = this.prevCharHead(enc, bytes, start, endp, end)) != -1 && ((point = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)prev, (int)end)) == 0 || ASCIIEncoding.INSTANCE.isSpace(point))) {
                endp = prev;
            }
            if (endp < end) {
                string.getByteList().view(0, endp - start);
                string.keepCodeRange();
                return string;
            }
            return this.nil();
        }

        @CompilerDirectives.TruffleBoundary
        private int prevCharHead(Encoding enc, byte[] bytes, int p, int s, int end) {
            return enc.prevCharHead(bytes, p, s, end);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true, taintFromParameter=0)
    @NodeChildren(value={@NodeChild(value="string"), @NodeChild(value="other")})
    public static abstract class ReplaceNode
    extends RubyNode {
        public ReplaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReplaceNode(ReplaceNode prev) {
            super(prev);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString replace(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            if (string == other) {
                return string;
            }
            string.getByteList().replace(other.getByteList().bytes());
            string.getByteList().setEncoding(other.getByteList().getEncoding());
            string.setCodeRange(other.getCodeRange());
            return string;
        }
    }

    @CoreMethod(names={"ord"})
    public static abstract class OrdNode
    extends CoreMethodNode {
        public OrdNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public OrdNode(OrdNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int ord(org.jruby.truffle.runtime.core.RubyString string) {
            return ((RubyFixnum)this.getContext().toJRuby(string).ord(this.getContext().getRuntime().getCurrentContext())).getIntValue();
        }
    }

    @CoreMethod(names={"num_bytes="}, lowerFixnumParameters={0}, required=1)
    public static abstract class SetNumBytesNode
    extends CoreMethodNode {
        public SetNumBytesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetNumBytesNode(SetNumBytesNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString setNumBytes(org.jruby.truffle.runtime.core.RubyString string, int count) {
            string.getByteList().view(0, count);
            return string;
        }
    }

    @CoreMethod(names={"modify!"}, raiseIfFrozenSelf=true)
    public static abstract class ModifyBangNode
    extends CoreMethodNode {
        public ModifyBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ModifyBangNode(ModifyBangNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString modifyBang(org.jruby.truffle.runtime.core.RubyString string) {
            string.modify();
            return string;
        }
    }

    @CoreMethod(names={"match"}, required=1, taintFromSelf=true)
    public static abstract class MatchNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode regexpMatchNode;

        public MatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.regexpMatchNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public MatchNode(MatchNode prev) {
            super(prev);
            this.regexpMatchNode = prev.regexpMatchNode;
        }

        @Specialization
        public Object match(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString regexpString) {
            MatchNode.notDesignedForCompilation();
            RubyRegexp regexp = new RubyRegexp((Node)this, this.getContext().getCoreLibrary().getRegexpClass(), regexpString.getBytes(), 0);
            return this.regexpMatchNode.call(frame, regexp, "match", null, string);
        }

        @Specialization
        public Object match(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRegexp regexp) {
            return this.regexpMatchNode.call(frame, regexp, "match", null, string);
        }
    }

    @CoreMethod(names={"lstrip!"}, raiseIfFrozenSelf=true)
    @ImportGuards(value={StringGuards.class})
    public static abstract class LstripBangNode
    extends CoreMethodNode {
        public LstripBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LstripBangNode(LstripBangNode prev) {
            super(prev);
        }

        @Specialization(guards={"isSingleByteOptimizable"})
        public Object lstripBangSingleByte(org.jruby.truffle.runtime.core.RubyString string) {
            int p;
            if (string.getByteList().getRealSize() == 0) {
                return this.nil();
            }
            int s = string.getByteList().getBegin();
            int end = s + string.getByteList().getRealSize();
            byte[] bytes = string.getByteList().getUnsafeBytes();
            for (p = s; p < end && ASCIIEncoding.INSTANCE.isSpace(bytes[p] & 0xFF); ++p) {
            }
            if (p > s) {
                string.getByteList().view(p - s, end - p);
                string.keepCodeRange();
                return string;
            }
            return this.nil();
        }

        @Specialization(guards={"!isSingleByteOptimizable"})
        public Object lstripBang(org.jruby.truffle.runtime.core.RubyString string) {
            int p;
            int c;
            if (string.getByteList().getRealSize() == 0) {
                return this.nil();
            }
            Encoding enc = EncodingUtils.STR_ENC_GET((ByteListHolder)string);
            int s = string.getByteList().getBegin();
            int end = s + string.getByteList().getRealSize();
            byte[] bytes = string.getByteList().getUnsafeBytes();
            for (p = s; p < end && ASCIIEncoding.INSTANCE.isSpace(c = StringSupport.codePoint((Ruby)this.getContext().getRuntime(), (Encoding)enc, (byte[])bytes, (int)p, (int)end)); p += StringSupport.codeLength((Encoding)enc, (int)c)) {
            }
            if (p > s) {
                string.getByteList().view(p - s, end - p);
                string.keepCodeRange();
                return string;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"insert"}, required=2, lowerFixnumParameters={0}, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(value="string"), @NodeChild(value="index"), @NodeChild(value="otherString")})
    public static abstract class InsertNode
    extends RubyNode {
        @Node.Child
        private CallDispatchHeadNode concatNode;
        @Node.Child
        private TaintResultNode taintResultNode;

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.concatNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.taintResultNode = new TaintResultNode(context, sourceSection);
        }

        public InsertNode(InsertNode prev) {
            super(prev);
            this.concatNode = prev.concatNode;
            this.taintResultNode = prev.taintResultNode;
        }

        @CreateCast(value={"index"})
        public RubyNode coerceIndexToInt(RubyNode index) {
            return ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), index);
        }

        @CreateCast(value={"otherString"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization
        public Object insert(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int index, org.jruby.truffle.runtime.core.RubyString otherString) {
            if (index == -1) {
                return this.concatNode.call(frame, string, "<<", null, otherString);
            }
            if (index < 0) {
                ++index;
            }
            StringNodesHelper.replaceInternal(string, StringNodesHelper.checkIndex(string, index, this), 0, otherString);
            return this.taintResultNode.maybeTaint(otherString, string);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization
        public Object initializeCopy(org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString from) {
            if (self == from) {
                return self;
            }
            self.getByteList().replace(from.getByteList().bytes());
            self.getByteList().setEncoding(from.getByteList().getEncoding());
            self.setCodeRange(from.getCodeRange());
            return self;
        }
    }

    @CoreMethod(names={"initialize"}, optional=1, taintFromParameter=0)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private ToStrNode toStrNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
            this.isFrozenNode = prev.isFrozenNode;
            this.toStrNode = prev.toStrNode;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString initialize(org.jruby.truffle.runtime.core.RubyString self, UndefinedPlaceholder from) {
            return self;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString initialize(org.jruby.truffle.runtime.core.RubyString self, org.jruby.truffle.runtime.core.RubyString from) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if (this.isFrozenNode.executeIsFrozen(self)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().frozenError(self.getLogicalClass().getName(), this));
            }
            self.set(from.getBytes().dup());
            self.setCodeRange(from.getCodeRange());
            return self;
        }

        @Specialization(guards={"!isRubyString(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public org.jruby.truffle.runtime.core.RubyString initialize(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString self, Object from) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.initialize(self, this.toStrNode.executeRubyString(frame, from));
        }
    }

    @CoreMethod(names={"inspect"}, taintFromSelf=true)
    public static abstract class InspectNode
    extends CoreMethodNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public org.jruby.truffle.runtime.core.RubyString inspect(org.jruby.truffle.runtime.core.RubyString string) {
            InspectNode.notDesignedForCompilation();
            RubyString inspected = (RubyString)RubyString.inspect19((Ruby)this.getContext().getRuntime(), (ByteList)string.getBytes());
            return this.getContext().makeString(inspected.getByteList());
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public HashNode(HashNode prev) {
            super(prev);
        }

        @Specialization
        public int hash(org.jruby.truffle.runtime.core.RubyString string) {
            return string.getBytes().hashCode();
        }
    }

    @CoreMethod(names={"getbyte"}, required=1)
    public static abstract class GetByteNode
    extends CoreMethodNode {
        private final ConditionProfile negativeIndexProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile indexOutOfBoundsProfile = ConditionProfile.createBinaryProfile();

        public GetByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetByteNode(GetByteNode prev) {
            super(prev);
        }

        @Specialization
        public Object getByte(org.jruby.truffle.runtime.core.RubyString string, int index) {
            ByteList bytes = string.getByteList();
            if (this.negativeIndexProfile.profile(index < 0)) {
                index += bytes.getRealSize();
            }
            if (this.indexOutOfBoundsProfile.profile(index < 0 || index >= bytes.getRealSize())) {
                return this.nil();
            }
            return string.getBytes().get(index) & 0xFF;
        }
    }

    @CoreMethod(names={"force_encoding"}, required=1)
    public static abstract class ForceEncodingNode
    extends CoreMethodNode {
        @Node.Child
        private ToStrNode toStrNode;

        public ForceEncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ForceEncodingNode(ForceEncodingNode prev) {
            super(prev);
            this.toStrNode = prev.toStrNode;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public org.jruby.truffle.runtime.core.RubyString forceEncoding(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString encodingName) {
            RubyEncoding encoding = RubyEncoding.getEncoding(encodingName.toString());
            return this.forceEncoding(string, encoding);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString forceEncoding(org.jruby.truffle.runtime.core.RubyString string, RubyEncoding encoding) {
            string.forceEncoding(encoding.getEncoding());
            return string;
        }

        @Specialization(guards={"!isRubyString(arguments[1])", "!isRubyEncoding(arguments[1])"})
        public org.jruby.truffle.runtime.core.RubyString forceEncoding(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object encoding) {
            if (this.toStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStrNode = (ToStrNode)this.insert(ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.forceEncoding(string, this.toStrNode.executeRubyString(frame, encoding));
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodNode {
        public EncodingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EncodingNode(EncodingNode prev) {
            super(prev);
        }

        @Specialization
        public RubyEncoding encoding(org.jruby.truffle.runtime.core.RubyString string) {
            EncodingNode.notDesignedForCompilation();
            return RubyEncoding.getEncoding(string.getBytes().getEncoding());
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends CoreMethodNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EmptyNode(EmptyNode prev) {
            super(prev);
        }

        @Specialization
        public boolean empty(org.jruby.truffle.runtime.core.RubyString string) {
            return string.getBytes().length() == 0;
        }
    }

    @CoreMethod(names={"each_char"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportGuards(value={StringGuards.class})
    public static abstract class EachCharNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public EachCharNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachCharNode(EachCharNode prev) {
            super(prev);
            this.taintResultNode = prev.taintResultNode;
        }

        @Specialization(guards={"isValidOr7BitEncoding"})
        public org.jruby.truffle.runtime.core.RubyString eachChar(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyProc block) {
            int n;
            ByteList strByteList = string.getByteList();
            byte[] ptrBytes = strByteList.unsafeBytes();
            int ptr = strByteList.begin();
            int len = strByteList.getRealSize();
            Encoding enc = string.getBytes().getEncoding();
            for (int i = 0; i < len; i += n) {
                n = StringSupport.encFastMBCLen((byte[])ptrBytes, (int)(ptr + i), (int)(ptr + len), (Encoding)enc);
                this.yield(frame, block, this.substr(string, i, n));
            }
            return string;
        }

        @Specialization(guards={"!isValidOr7BitEncoding"})
        public org.jruby.truffle.runtime.core.RubyString eachCharMultiByteEncoding(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyProc block) {
            int n;
            ByteList strByteList = string.getByteList();
            byte[] ptrBytes = strByteList.unsafeBytes();
            int ptr = strByteList.begin();
            int len = strByteList.getRealSize();
            Encoding enc = string.getBytes().getEncoding();
            for (int i = 0; i < len; i += n) {
                n = this.multiByteStringLength(enc, ptrBytes, ptr + i, ptr + len);
                this.yield(frame, block, this.substr(string, i, n));
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteStringLength(Encoding enc, byte[] bytes, int p, int end) {
            return StringSupport.length((Encoding)enc, (byte[])bytes, (int)p, (int)end);
        }

        private Object substr(org.jruby.truffle.runtime.core.RubyString string, int beg, int len) {
            ByteList bytes = string.getBytes();
            int length = bytes.length();
            if (len < 0 || beg > length) {
                return this.nil();
            }
            if (beg < 0 && (beg += length) < 0) {
                return this.nil();
            }
            int end = Math.min(length, beg + len);
            ByteList substringBytes = new ByteList(bytes, beg, end - beg);
            substringBytes.setEncoding(bytes.getEncoding());
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            org.jruby.truffle.runtime.core.RubyString ret = this.getContext().makeString(string.getLogicalClass(), substringBytes);
            return this.taintResultNode.maybeTaint(string, ret);
        }
    }

    @CoreMethod(names={"each_byte"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachByteNode
    extends YieldingCoreMethodNode {
        public EachByteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachByteNode(EachByteNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString eachByte(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyProc block) {
            ByteList bytes = string.getBytes();
            for (int i = 0; i < bytes.getRealSize(); ++i) {
                this.yield(frame, block, bytes.get(i) & 0xFF);
            }
            return string;
        }
    }

    @CoreMethod(names={"downcase!"}, raiseIfFrozenSelf=true)
    public static abstract class DowncaseBangNode
    extends CoreMethodNode {
        public DowncaseBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DowncaseBangNode(DowncaseBangNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject downcase(org.jruby.truffle.runtime.core.RubyString string) {
            DowncaseBangNode.notDesignedForCompilation();
            ByteList newByteList = StringNodesHelper.downcase(this.getContext().getRuntime(), string.getByteList());
            if (newByteList.equal(string.getBytes())) {
                return this.nil();
            }
            string.set(newByteList);
            return string;
        }
    }

    @CoreMethod(names={"downcase"}, taintFromSelf=true)
    public static abstract class DowncaseNode
    extends CoreMethodNode {
        public DowncaseNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DowncaseNode(DowncaseNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString downcase(org.jruby.truffle.runtime.core.RubyString string) {
            DowncaseNode.notDesignedForCompilation();
            ByteList newByteList = StringNodesHelper.downcase(this.getContext().getRuntime(), string.getByteList());
            return string.getContext().makeString(string.getLogicalClass(), newByteList);
        }
    }

    @CoreMethod(names={"delete!"}, argumentsAsArray=true, raiseIfFrozenSelf=true)
    public static abstract class DeleteBangNode
    extends CoreMethodNode {
        @Node.Child
        private ToStrNode toStr;

        public DeleteBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = ToStrNodeFactory.create(context, sourceSection, null);
        }

        public DeleteBangNode(DeleteBangNode prev) {
            super(prev);
            this.toStr = prev.toStr;
        }

        @Specialization
        public Object deleteBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object ... otherStrings) {
            if (string.getBytes().length() == 0) {
                return this.nil();
            }
            if (otherStrings.length == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentErrorEmptyVarargs(this));
            }
            return this.deleteBangSlow(frame, string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private Object deleteBangSlow(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object ... args) {
            org.jruby.truffle.runtime.core.RubyString[] otherStrings = new org.jruby.truffle.runtime.core.RubyString[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeRubyString(frame, args[i]);
            }
            org.jruby.truffle.runtime.core.RubyString otherString = otherStrings[0];
            Encoding enc = string.checkEncoding(otherString, this);
            boolean[] squeeze = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)otherString.getBytes(), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                enc = string.checkEncoding(otherStrings[i], this);
                tables = StringSupport.trSetupTable((ByteList)otherStrings[i].getBytes(), (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            if (StringSupport.delete_bangCommon19((CodeRangeable)string, (Ruby)this.getContext().getRuntime(), (boolean[])squeeze, (StringSupport.TrTables)tables, (Encoding)enc) == null) {
                return this.nil();
            }
            return string;
        }
    }

    @CoreMethod(names={"data"})
    public static abstract class DataNode
    extends CoreMethodNode {
        public DataNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DataNode(DataNode prev) {
            super(prev);
        }

        @Specialization
        public RubiniusByteArray data(org.jruby.truffle.runtime.core.RubyString string) {
            return new RubiniusByteArray(this.getContext().getCoreLibrary().getByteArrayClass(), string.getBytes());
        }
    }

    @CoreMethod(names={"crypt"}, required=1, taintFromSelf=true, taintFromParameter=0)
    @NodeChildren(value={@NodeChild(value="string"), @NodeChild(value="salt")})
    public static abstract class CryptNode
    extends RubyNode {
        public CryptNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CryptNode(CryptNode prev) {
            super(prev);
        }

        @CreateCast(value={"salt"})
        public RubyNode coerceSaltToString(RubyNode other) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization
        public Object crypt(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString salt) {
            ByteList value = string.getByteList();
            Encoding ascii8bit = this.getContext().getRuntime().getEncodingService().getAscii8bitEncoding();
            ByteList otherBL = salt.getByteList().dup();
            org.jruby.truffle.runtime.core.RubyString otherStr = this.getContext().makeString(otherBL);
            otherStr.modify();
            StringSupport.associateEncoding((CodeRangeable)otherStr, (Encoding)ascii8bit);
            if (otherBL.length() < 2) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("salt too short (need >= 2 bytes)", this));
            }
            POSIX posix = this.posix();
            byte[] keyBytes = Arrays.copyOfRange(value.unsafeBytes(), value.begin(), value.realSize());
            byte[] saltBytes = Arrays.copyOfRange(otherBL.unsafeBytes(), otherBL.begin(), otherBL.realSize());
            if (saltBytes[0] == 0 || saltBytes[1] == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("salt too short (need >= 2 bytes)", this));
            }
            byte[] cryptedString = posix.crypt(keyBytes, saltBytes);
            if (cryptedString == null) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().errnoError(posix.errno(), this));
            }
            org.jruby.truffle.runtime.core.RubyString result = this.getContext().makeString(new ByteList(cryptedString, 0, cryptedString.length - 1));
            StringSupport.associateEncoding((CodeRangeable)result, (Encoding)ascii8bit);
            return result;
        }
    }

    @CoreMethod(names={"count"}, argumentsAsArray=true)
    public static abstract class CountNode
    extends CoreMethodNode {
        @Node.Child
        private ToStrNode toStr;

        public CountNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toStr = ToStrNodeFactory.create(context, sourceSection, null);
        }

        public CountNode(CountNode prev) {
            super(prev);
            this.toStr = prev.toStr;
        }

        @Specialization
        public int count(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object[] otherStrings) {
            CountNode.notDesignedForCompilation();
            if (string.getByteList().getRealSize() == 0) {
                return 0;
            }
            if (otherStrings.length == 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentErrorEmptyVarargs(this));
            }
            return this.countSlow(frame, string, otherStrings);
        }

        @CompilerDirectives.TruffleBoundary
        private int countSlow(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object[] args) {
            org.jruby.truffle.runtime.core.RubyString[] otherStrings = new org.jruby.truffle.runtime.core.RubyString[args.length];
            for (int i = 0; i < args.length; ++i) {
                otherStrings[i] = this.toStr.executeRubyString(frame, args[i]);
            }
            org.jruby.truffle.runtime.core.RubyString otherStr = otherStrings[0];
            Encoding enc = otherStr.getBytes().getEncoding();
            boolean[] table = new boolean[257];
            StringSupport.TrTables tables = StringSupport.trSetupTable((ByteList)otherStr.getBytes(), (Ruby)this.getContext().getRuntime(), (boolean[])table, null, (boolean)true, (Encoding)enc);
            for (int i = 1; i < otherStrings.length; ++i) {
                otherStr = otherStrings[i];
                enc = string.checkEncoding(otherStr, this);
                tables = StringSupport.trSetupTable((ByteList)otherStr.getBytes(), (Ruby)this.getContext().getRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (boolean)false, (Encoding)enc);
            }
            return StringSupport.countCommon19((ByteList)string.getByteList(), (Ruby)this.getContext().getRuntime(), (boolean[])table, (StringSupport.TrTables)tables, (Encoding)enc);
        }
    }

    @CoreMethod(names={"chop!"}, raiseIfFrozenSelf=true)
    public static abstract class ChopBangNode
    extends CoreMethodNode {
        @Node.Child
        private SizeNode sizeNode;

        public ChopBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.sizeNode = StringNodesFactory.SizeNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        public ChopBangNode(ChopBangNode prev) {
            super(prev);
            this.sizeNode = prev.sizeNode;
        }

        @Specialization
        public Object chopBang(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string) {
            ChopBangNode.notDesignedForCompilation();
            if (this.sizeNode.executeIntegerFixnum(frame, string) == 0) {
                return this.nil();
            }
            int newLength = this.choppedLength(string);
            string.getByteList().view(0, newLength);
            if (string.getCodeRange() != 16) {
                string.clearCodeRange();
            }
            return string;
        }

        @CompilerDirectives.TruffleBoundary
        private int choppedLength(org.jruby.truffle.runtime.core.RubyString string) {
            return StringSupport.choppedLength19((CodeRangeable)string, (Ruby)this.getContext().getRuntime());
        }
    }

    @CoreMethod(names={"casecmp"}, required=1)
    @NodeChildren(value={@NodeChild(value="string"), @NodeChild(value="other")})
    public static abstract class CaseCmpNode
    extends RubyNode {
        public CaseCmpNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CaseCmpNode(CaseCmpNode prev) {
            super(prev);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"bothSingleByteOptimizable"})
        public Object caseCmpSingleByte(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            if (StringSupport.areCompatible((CodeRangeable)string, (CodeRangeable)other) == null) {
                return this.nil();
            }
            return string.getByteList().caseInsensitiveCmp(other.getByteList());
        }

        @Specialization(guards={"!bothSingleByteOptimizable"})
        public Object caseCmp(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            Encoding encoding = StringSupport.areCompatible((CodeRangeable)string, (CodeRangeable)other);
            if (encoding == null) {
                return this.nil();
            }
            return this.multiByteCasecmp(encoding, string.getByteList(), other.getByteList());
        }

        @CompilerDirectives.TruffleBoundary
        private int multiByteCasecmp(Encoding enc, ByteList value, ByteList otherValue) {
            return StringSupport.multiByteCasecmp((Encoding)enc, (ByteList)value, (ByteList)otherValue);
        }

        public static boolean bothSingleByteOptimizable(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            boolean stringSingleByteOptimizable = StringSupport.isSingleByteOptimizable((CodeRangeable)string, (Encoding)string.getByteList().getEncoding());
            boolean otherSingleByteOptimizable = StringSupport.isSingleByteOptimizable((CodeRangeable)other, (Encoding)other.getByteList().getEncoding());
            return stringSingleByteOptimizable && otherSingleByteOptimizable;
        }
    }

    @CoreMethod(names={"bytesize"})
    public static abstract class ByteSizeNode
    extends CoreMethodNode {
        public ByteSizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ByteSizeNode(ByteSizeNode prev) {
            super(prev);
        }

        @Specialization
        public int byteSize(org.jruby.truffle.runtime.core.RubyString string) {
            return string.getBytes().length();
        }
    }

    @CoreMethod(names={"bytes"})
    public static abstract class BytesNode
    extends CoreMethodNode {
        public BytesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BytesNode(BytesNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray bytes(org.jruby.truffle.runtime.core.RubyString string) {
            byte[] bytes = string.getBytes().bytes();
            int[] store = new int[bytes.length];
            for (int n = 0; n < store.length; ++n) {
                store[n] = bytes[n] & 0xFF;
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), store, bytes.length);
        }
    }

    @CoreMethod(names={"b"}, taintFromSelf=true)
    public static abstract class BNode
    extends CoreMethodNode {
        public BNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BNode(BNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString b(org.jruby.truffle.runtime.core.RubyString string) {
            ByteList bytes = string.getBytes().dup();
            bytes.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
            return this.getContext().makeString(bytes);
        }
    }

    @CoreMethod(names={"ascii_only?"})
    public static abstract class ASCIIOnlyNode
    extends CoreMethodNode {
        public ASCIIOnlyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ASCIIOnlyNode(ASCIIOnlyNode prev) {
            super(prev);
        }

        @Specialization
        public boolean asciiOnly(org.jruby.truffle.runtime.core.RubyString string) {
            ASCIIOnlyNode.notDesignedForCompilation();
            if (!string.getBytes().getEncoding().isAsciiCompatible()) {
                return false;
            }
            for (byte b : string.getBytes().unsafeBytes()) {
                if ((b & 0x80) == 0) continue;
                return false;
            }
            return true;
        }
    }

    @CoreMethod(names={"=~"}, required=1)
    public static abstract class MatchOperatorNode
    extends CoreMethodNode {
        public MatchOperatorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchOperatorNode(MatchOperatorNode prev) {
            super(prev);
        }

        @Specialization
        public Object match(org.jruby.truffle.runtime.core.RubyString string, RubyRegexp regexp) {
            return regexp.matchCommon(string, true, false);
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1}, taintFromSelf=true)
    public static abstract class GetIndexNode
    extends CoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private CallDispatchHeadNode includeNode;
        @Node.Child
        private CallDispatchHeadNode dupNode;
        @Node.Child
        private SizeNode sizeNode;
        @Node.Child
        private StringPrimitiveNodes.StringSubstringPrimitiveNode substringNode;
        private final BranchProfile outOfBounds = BranchProfile.create();

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetIndexNode(GetIndexNode prev) {
            super(prev);
            this.toIntNode = prev.toIntNode;
            this.includeNode = prev.includeNode;
            this.dupNode = prev.dupNode;
            this.sizeNode = prev.sizeNode;
            this.substringNode = prev.substringNode;
        }

        @Specialization
        public Object getIndex(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int index, UndefinedPlaceholder undefined) {
            int normalizedIndex = string.normalizeIndex(index);
            ByteList bytes = string.getBytes();
            if (normalizedIndex < 0 || normalizedIndex >= bytes.length()) {
                this.outOfBounds.enter();
                return this.nil();
            }
            return this.getSubstringNode().execute(frame, string, index, 1);
        }

        @Specialization(guards={"!isRubyRange(arguments[1])", "!isRubyRegexp(arguments[1])", "!isRubyString(arguments[1])"})
        public Object getIndex(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object index, UndefinedPlaceholder undefined) {
            return this.getIndex(frame, string, this.getToIntNode().executeInt(frame, index), undefined);
        }

        @Specialization
        public Object sliceIntegerRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRange.IntegerFixnumRange range, UndefinedPlaceholder undefined) {
            return this.sliceRange(frame, string, range.getBegin(), range.getEnd(), range.doesExcludeEnd());
        }

        @Specialization
        public Object sliceLongRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRange.LongFixnumRange range, UndefinedPlaceholder undefined) {
            return this.sliceRange(frame, string, (int)range.getBegin(), (int)range.getEnd(), range.doesExcludeEnd());
        }

        @Specialization
        public Object sliceObjectRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRange.ObjectRange range, UndefinedPlaceholder undefined) {
            int coercedBegin = this.getToIntNode().executeInt(frame, range.getBegin());
            int coercedEnd = this.getToIntNode().executeInt(frame, range.getEnd());
            return this.sliceRange(frame, string, coercedBegin, coercedEnd, range.doesExcludeEnd());
        }

        private Object sliceRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int begin, int end, boolean doesExcludeEnd) {
            int stringLength;
            if (this.sizeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.sizeNode = (SizeNode)this.insert(StringNodesFactory.SizeNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null}));
            }
            if ((begin = string.normalizeIndex(stringLength = this.sizeNode.executeIntegerFixnum(frame, string), begin)) < 0 || begin > stringLength) {
                this.outOfBounds.enter();
                return this.nil();
            }
            if (begin == stringLength) {
                return this.getContext().makeString(string.getLogicalClass(), "", string.getByteList().getEncoding());
            }
            end = string.normalizeIndex(stringLength, end);
            int length = string.clampExclusiveIndex(doesExcludeEnd ? end : end + 1);
            if (length > stringLength) {
                length = stringLength;
            }
            if ((length -= begin) < 0) {
                length = 0;
            }
            return this.getSubstringNode().execute(frame, string, begin, length);
        }

        @Specialization
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int start, int length) {
            return this.getSubstringNode().execute(frame, string, start, length);
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[2])"})
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, int start, Object length) {
            return this.slice(frame, string, start, this.getToIntNode().executeInt(frame, length));
        }

        @Specialization(guards={"!isRubyRange(arguments[1])", "!isRubyRegexp(arguments[1])", "!isRubyString(arguments[1])", "!isUndefinedPlaceholder(arguments[2])"})
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object start, Object length) {
            return this.slice(frame, string, this.getToIntNode().executeInt(frame, start), this.getToIntNode().executeInt(frame, length));
        }

        @Specialization
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRegexp regexp, UndefinedPlaceholder capture) {
            return this.slice(frame, string, regexp, (Object)0);
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[2])"})
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, RubyRegexp regexp, Object capture) {
            return this.ruby(frame, "match, str = subpattern(index, other); Regexp.last_match = match; str", "index", regexp, "other", capture);
        }

        @Specialization
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString matchStr, UndefinedPlaceholder undefined) {
            boolean result;
            GetIndexNode.notDesignedForCompilation();
            if (this.includeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.includeNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            if (result = this.includeNode.callBoolean(frame, string, "include?", null, matchStr)) {
                if (this.dupNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.dupNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                throw new TaintResultNode.DoNotTaint(this.dupNode.call(frame, matchStr, "dup", null, new Object[0]));
            }
            return this.nil();
        }

        private ToIntNode getToIntNode() {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.toIntNode;
        }

        private StringPrimitiveNodes.StringSubstringPrimitiveNode getSubstringNode() {
            if (this.substringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.substringNode = (StringPrimitiveNodes.StringSubstringPrimitiveNode)this.insert(StringPrimitiveNodesFactory.StringSubstringPrimitiveNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            return this.substringNode;
        }
    }

    @CoreMethod(names={"%"}, required=1, argumentsAsArray=true)
    public static abstract class FormatNode
    extends CoreMethodNode {
        private final BranchProfile singleArrayProfile = BranchProfile.create();
        private final BranchProfile multipleArgumentsProfile = BranchProfile.create();

        public FormatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FormatNode(FormatNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString format(org.jruby.truffle.runtime.core.RubyString format, Object[] args) {
            return this.formatSlow(format, args);
        }

        @CompilerDirectives.TruffleBoundary
        private org.jruby.truffle.runtime.core.RubyString formatSlow(org.jruby.truffle.runtime.core.RubyString format, Object[] args) {
            RubyContext context = this.getContext();
            if (args.length == 1 && args[0] instanceof org.jruby.truffle.runtime.core.RubyArray) {
                this.singleArrayProfile.enter();
                return context.makeString(StringFormatter.format(this.getContext(), format.toString(), Arrays.asList(((org.jruby.truffle.runtime.core.RubyArray)args[0]).slowToArray())), format.getByteList().getEncoding());
            }
            this.multipleArgumentsProfile.enter();
            return context.makeString(StringFormatter.format(this.getContext(), format.toString(), Arrays.asList(args)), format.getByteList().getEncoding());
        }
    }

    @CoreMethod(names={"<<", "concat"}, required=1, taintFromParameter=0, raiseIfFrozenSelf=true)
    @NodeChildren(value={@NodeChild(value="string"), @NodeChild(value="other")})
    public static abstract class ConcatNode
    extends RubyNode {
        public ConcatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConcatNode(ConcatNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString concat(org.jruby.truffle.runtime.core.RubyString string, int other) {
            if (other < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(other));
            }
            return this.concatNumeric(string, other);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString concat(org.jruby.truffle.runtime.core.RubyString string, long other) {
            if (other < 0L) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(other));
            }
            return this.concatNumeric(string, (int)other);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString concat(org.jruby.truffle.runtime.core.RubyString string, RubyBignum other) {
            if (other.bigIntegerValue().signum() < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError("bignum out of char range", (Node)this));
            }
            return this.concatNumeric(string, other.bigIntegerValue().intValue());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public org.jruby.truffle.runtime.core.RubyString concat(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            int codeRange = other.getCodeRange();
            int[] ptr_cr_ret = new int[]{codeRange};
            try {
                EncodingUtils.encCrStrBufCat((Ruby)this.getContext().getRuntime(), (CodeRangeable)string, (ByteList)other.getByteList(), (Encoding)other.getByteList().getEncoding(), (int)codeRange, (int[])ptr_cr_ret);
            }
            catch (RaiseException e) {
                if (e.getException().getMetaClass() == this.getContext().getRuntime().getEncodingCompatibilityError()) {
                    CompilerDirectives.transferToInterpreter();
                    throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().encodingCompatibilityError(e.getException().message.asJavaString(), this));
                }
                throw e;
            }
            other.setCodeRange(ptr_cr_ret[0]);
            return string;
        }

        @Specialization(guards={"!isInteger(other)", "!isLong(other)", "!isRubyBignum(other)", "!isRubyString(other)"})
        public Object concat(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object other) {
            ConcatNode.notDesignedForCompilation();
            return this.ruby(frame, "concat StringValue(other)", "other", other);
        }

        @CompilerDirectives.TruffleBoundary
        private org.jruby.truffle.runtime.core.RubyString concatNumeric(org.jruby.truffle.runtime.core.RubyString string, int c) {
            int cl;
            ByteList value = string.getByteList();
            Encoding enc = value.getEncoding();
            try {
                cl = StringSupport.codeLength((Encoding)enc, (int)c);
                string.modify(value.getRealSize() + cl);
                string.clearCodeRange();
                if (enc == USASCIIEncoding.INSTANCE) {
                    if (c > 255) {
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(c));
                    }
                    if (c > 121) {
                        value.setEncoding((Encoding)ASCIIEncoding.INSTANCE);
                        enc = value.getEncoding();
                    }
                }
                enc.codeToMbc(c, value.getUnsafeBytes(), value.getBegin() + value.getRealSize());
            }
            catch (EncodingException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.charRangeException(c));
            }
            value.setRealSize(value.getRealSize() + cl);
            return string;
        }

        private RubyException charRangeException(Number value) {
            return this.getContext().getCoreLibrary().rangeError(String.format("%d out of char range", value), (Node)this);
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode cmpNode;
        @Node.Child
        private CmpIntNode cmpIntNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToCmpNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToStrNode toStrNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
            this.cmpNode = prev.cmpNode;
            this.cmpIntNode = prev.cmpIntNode;
            this.respondToCmpNode = prev.respondToCmpNode;
            this.respondToToStrNode = prev.respondToToStrNode;
            this.toStrNode = prev.toStrNode;
        }

        @Specialization
        public int compare(org.jruby.truffle.runtime.core.RubyString a, org.jruby.truffle.runtime.core.RubyString b) {
            int ret = a.getByteList().cmp(b.getByteList());
            if (ret == 0 && !StringSupport.areComparable((CodeRangeable)a, (CodeRangeable)b)) {
                return a.getByteList().getEncoding().getIndex() > b.getByteList().getEncoding().getIndex() ? 1 : -1;
            }
            return ret;
        }

        @Specialization(guards={"!isRubyString(arguments[1])"})
        public Object compare(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString a, Object b) {
            CompareNode.notDesignedForCompilation();
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToStrNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            if (this.respondToToStrNode.doesRespondTo(frame, b, this.getContext().makeString("to_str"), false)) {
                if (this.toStrNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toStrNode = (ToStrNode)this.insert(ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), null));
                }
                try {
                    org.jruby.truffle.runtime.core.RubyString coerced = this.toStrNode.executeRubyString(frame, b);
                    return this.compare(a, coerced);
                }
                catch (org.jruby.truffle.runtime.control.RaiseException e) {
                    if (e.getRubyException().getLogicalClass() == this.getContext().getCoreLibrary().getTypeErrorClass()) {
                        return this.nil();
                    }
                    throw e;
                }
            }
            if (this.respondToCmpNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToCmpNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            if (this.respondToCmpNode.doesRespondTo(frame, b, this.getContext().makeString("<=>"), false)) {
                Object cmpResult;
                if (this.cmpNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.cmpNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                if ((cmpResult = this.cmpNode.call(frame, b, "<=>", null, a)) == this.nil()) {
                    return this.nil();
                }
                if (this.cmpIntNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.cmpIntNode = (CmpIntNode)this.insert(CmpIntNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                return -this.cmpIntNode.executeCmpInt(frame, cmpResult, a, b);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"==", "===", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        @Node.Child
        private StringPrimitiveNodes.StringEqualPrimitiveNode stringEqualNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToNode;
        @Node.Child
        private CallDispatchHeadNode objectEqualNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.stringEqualNode = StringPrimitiveNodesFactory.StringEqualPrimitiveNodeFactory.create(context, sourceSection, new RubyNode[0]);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
            this.stringEqualNode = prev.stringEqualNode;
        }

        @Specialization
        public boolean equal(org.jruby.truffle.runtime.core.RubyString a, org.jruby.truffle.runtime.core.RubyString b) {
            return this.stringEqualNode.stringEqual(a, b);
        }

        @Specialization(guards={"!isRubyString(arguments[1])"})
        public boolean equal(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString a, Object b) {
            if (this.respondToNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            if (this.respondToNode.doesRespondTo(frame, b, this.getContext().makeString("to_str"), false)) {
                if (this.objectEqualNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.objectEqualNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
                }
                return this.objectEqualNode.callBoolean(frame, b, "==", null, a);
            }
            return false;
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class MulNode
    extends CoreMethodNode {
        private final ConditionProfile negativeTimesProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private ToIntNode toIntNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
            this.toIntNode = prev.toIntNode;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString multiply(org.jruby.truffle.runtime.core.RubyString string, int times) {
            if (this.negativeTimesProfile.profile(times < 0)) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            ByteList inputBytes = string.getBytes();
            ByteList outputBytes = new ByteList(string.getBytes().length() * times);
            for (int n = 0; n < times; ++n) {
                outputBytes.append(inputBytes);
            }
            outputBytes.setEncoding(inputBytes.getEncoding());
            org.jruby.truffle.runtime.core.RubyString ret = this.getContext().makeString(string.getLogicalClass(), outputBytes);
            ret.setCodeRange(string.getCodeRange());
            return ret;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString multiply(org.jruby.truffle.runtime.core.RubyString string, RubyBignum times) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError("bignum too big to convert into `long'", (Node)this));
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])", "!isInteger(arguments[1])"})
        public org.jruby.truffle.runtime.core.RubyString multiply(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyString string, Object times) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.multiply(string, this.toIntNode.executeInt(frame, times));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @NodeChildren(value={@NodeChild(value="string"), @NodeChild(value="other")})
    public static abstract class AddNode
    extends RubyNode {
        @Node.Child
        private TaintResultNode taintResultNode;

        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
            this.taintResultNode = prev.taintResultNode;
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToString(RubyNode other) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyString add(org.jruby.truffle.runtime.core.RubyString string, org.jruby.truffle.runtime.core.RubyString other) {
            Encoding enc = string.checkEncoding(other, this);
            org.jruby.truffle.runtime.core.RubyString ret = this.getContext().makeString(this.getContext().getCoreLibrary().getStringClass(), StringSupport.addByteLists((ByteList)string.getByteList(), (ByteList)other.getByteList()));
            if (this.taintResultNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintResultNode = (TaintResultNode)this.insert(new TaintResultNode(this.getContext(), this.getSourceSection()));
            }
            ret.getByteList().setEncoding(enc);
            this.taintResultNode.maybeTaint(string, ret);
            this.taintResultNode.maybeTaint(other, ret);
            return ret;
        }
    }
}

