/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.RangeNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;

@GeneratedBy(value=RangeNodes.class)
public final class RangeNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(CollectNodeFactory.getInstance(), EachNodeFactory.getInstance(), ExcludeEndNodeFactory.getInstance(), BeginNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), EndNodeFactory.getInstance(), StepNodeFactory.getInstance(), ToANodeFactory.getInstance());
    }

    @GeneratedBy(value=RangeNodes.ToANode.class)
    public static final class ToANodeFactory
    extends NodeFactoryBase<RangeNodes.ToANode> {
        private static ToANodeFactory toANodeFactoryInstance;

        private ToANodeFactory() {
            super(RangeNodes.ToANode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.ToANode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToANodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.ToANode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToAUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.ToANode> getInstance() {
            if (toANodeFactoryInstance == null) {
                toANodeFactoryInstance = new ToANodeFactory();
            }
            return toANodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToAPolymorphicNode
        extends ToABaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToAPolymorphicNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToAObjectObjectRangeNode
        extends ToABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToAObjectObjectRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class}, 0, 0);

            ToAObjectObjectRangeNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof ObjectRange");
                }
                return super.toA(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    return super.toA(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ToANode create0(RangeNodes.ToANode current) {
                return new ToAObjectObjectRangeNode((ToABaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToARubyArrayIntegerFixnumRangeNode
        extends ToABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToARubyArrayIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class}, 0, 0);

            ToARubyArrayIntegerFixnumRangeNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof IntegerFixnumRange"));
                }
                return super.toA(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    return super.toA(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ToANode create0(RangeNodes.ToANode current) {
                return new ToARubyArrayIntegerFixnumRangeNode((ToABaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToAUninitializedNode
        extends ToABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToAUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToAUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToAUninitializedNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToABaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToABaseNode rootNode = (ToABaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToABaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ToANode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToAUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.ToANode.class)
        private static abstract class ToABaseNode
        extends RangeNodes.ToANode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToABaseNode next0;

            ToABaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToABaseNode(ToABaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToABaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToABaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToAUninitializedNode(this);
                    ((ToAUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToABaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToABaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToABaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToAUninitializedNode(this), (Node)new ToAPolymorphicNode(this), (DSLNode)((ToABaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToABaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    return (ToABaseNode)ToARubyArrayIntegerFixnumRangeNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    return (ToABaseNode)ToAObjectObjectRangeNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToABaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToABaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.StepNode.class)
    public static final class StepNodeFactory
    extends NodeFactoryBase<RangeNodes.StepNode> {
        private static StepNodeFactory stepNodeFactoryInstance;

        private StepNodeFactory() {
            super(RangeNodes.StepNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.StepNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StepNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.StepNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StepUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.StepNode> getInstance() {
            if (stepNodeFactoryInstance == null) {
                stepNodeFactoryInstance = new StepNodeFactory();
            }
            return stepNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StepPolymorphicNode
        extends StepBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            StepPolymorphicNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.LongFixnumRange.class ? this.arguments[0].executeLongFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value3);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepObjectRangeObjectUndefinedPlaceholderNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepObjectRangeObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, Object.class, UndefinedPlaceholder.class}, 0, 0);

            StepObjectRangeObjectUndefinedPlaceholderNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof ObjectRange");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                if (!super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepObjectRangeObjectUndefinedPlaceholderNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepObjectRangeUndefinedPlaceholderRubyProcNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepObjectRangeUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            StepObjectRangeUndefinedPlaceholderRubyProcNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof ObjectRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepObjectRangeUndefinedPlaceholderRubyProcNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepObjectRangeUndefinedPlaceholderUndefinedPlaceholderNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepObjectRangeUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            StepObjectRangeUndefinedPlaceholderUndefinedPlaceholderNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof ObjectRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepObjectRangeUndefinedPlaceholderUndefinedPlaceholderNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepObjectRangeObjectRubyProcNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepObjectRangeObjectRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, Object.class, RubyProc.class}, 0, 0);

            StepObjectRangeObjectRubyProcNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof ObjectRange");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (!super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepObjectRangeObjectRubyProcNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepLongFixnumRangeObjectUndefinedPlaceholderNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepLongFixnumRangeObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class, Object.class, UndefinedPlaceholder.class}, 0, 0);

            StepLongFixnumRangeObjectUndefinedPlaceholderNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof LongFixnumRange");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                if (!super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    RubyRange.LongFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepLongFixnumRangeObjectUndefinedPlaceholderNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepLongFixnumRangeUndefinedPlaceholderRubyProcNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepLongFixnumRangeUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            StepLongFixnumRangeUndefinedPlaceholderRubyProcNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof LongFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyRange.LongFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepLongFixnumRangeUndefinedPlaceholderRubyProcNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepLongFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepLongFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            StepLongFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof LongFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyRange.LongFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepLongFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepIntegerFixnumRangeObjectUndefinedPlaceholderNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepIntegerFixnumRangeObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, Object.class, UndefinedPlaceholder.class}, 0, 0);

            StepIntegerFixnumRangeObjectUndefinedPlaceholderNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isUndefinedPlaceholder(arguments1Value))) {
                    return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isInteger, !isLong, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && !super.isInteger(arguments1Value) && !super.isLong(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepIntegerFixnumRangeObjectUndefinedPlaceholderNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepIntegerFixnumRangeUndefinedPlaceholderRubyProcNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepIntegerFixnumRangeUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            StepIntegerFixnumRangeUndefinedPlaceholderRubyProcNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepIntegerFixnumRangeUndefinedPlaceholderRubyProcNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepIntegerFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepIntegerFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            StepIntegerFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepIntegerFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepLongFixnumRangeObjectRubyProcNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepLongFixnumRangeObjectRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class, Object.class, RubyProc.class}, 0, 0);

            StepLongFixnumRangeObjectRubyProcNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof LongFixnumRange");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (!StepBaseNode.isStepValidInt(arguments0Value, arguments1Value, arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.stepFallback(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isStepValidInt, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyProc arguments2ValueCast;
                RubyRange.LongFixnumRange arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value) && !StepBaseNode.isStepValidInt(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value), arguments1Value, arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value))) {
                    return super.stepFallback(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepLongFixnumRangeObjectRubyProcNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepIntegerFixnumRangeObjectRubyProcNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepIntegerFixnumRangeObjectRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, Object.class, RubyProc.class}, 0, 0);

            StepIntegerFixnumRangeObjectRubyProcNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (!StepBaseNode.isStepValidInt(arguments0Value, arguments1Value, arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.stepFallback(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [!isStepValidInt, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyProc arguments2ValueCast;
                RubyRange.IntegerFixnumRange arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value) && !StepBaseNode.isStepValidInt(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value), arguments1Value, arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value))) {
                    return super.stepFallback(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepIntegerFixnumRangeObjectRubyProcNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepLongFixnumRangeIntRubyProcNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepLongFixnumRangeIntRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class, Integer.TYPE, RubyProc.class}, 0, 0);

            StepLongFixnumRangeIntRubyProcNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                int arguments1Value;
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof LongFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (StepBaseNode.isStepValid(arguments0Value, arguments1Value, arguments2Value)) {
                    return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isStepValid] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyProc arguments2ValueCast;
                int arguments1ValueCast;
                RubyRange.LongFixnumRange arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && StepBaseNode.isStepValid(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value), arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value))) {
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepLongFixnumRangeIntRubyProcNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StepIntegerFixnumRangeIntRubyProcNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepIntegerFixnumRangeIntRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, Integer.TYPE, RubyProc.class}, 0, 0);

            StepIntegerFixnumRangeIntRubyProcNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                int arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (StepBaseNode.isStepValid(arguments0Value, arguments1Value, arguments2Value)) {
                    return super.step(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isStepValid] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RubyProc arguments2ValueCast;
                int arguments1ValueCast;
                RubyRange.IntegerFixnumRange arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && StepBaseNode.isStepValid(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value), arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value))) {
                    return super.step(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RangeNodes.StepNode current) {
                return new StepIntegerFixnumRangeIntRubyProcNode((StepBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StepUninitializedNode
        extends StepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StepUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StepUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StepUninitializedNode(StepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                StepBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StepBaseNode rootNode = (StepBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StepBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static RangeNodes.StepNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StepUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.StepNode.class)
        private static abstract class StepBaseNode
        extends RangeNodes.StepNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StepBaseNode next0;

            StepBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StepBaseNode(StepBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                StepBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StepBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new StepUninitializedNode(this);
                    ((StepUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StepBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StepBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (StepBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StepUninitializedNode(this), (Node)new StepPolymorphicNode(this), (DSLNode)((StepBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StepBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast;
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        RubyRange arguments0ValueCast2;
                        int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                        if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RangeNodes.StepNode.isStepValid(arguments0ValueCast2 = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value), arguments1ValueCast, arguments2ValueCast)) {
                            return (StepBaseNode)StepIntegerFixnumRangeIntRubyProcNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RangeNodes.StepNode.isStepValid((RubyRange.LongFixnumRange)(arguments0ValueCast2 = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value)), arguments1ValueCast, arguments2ValueCast)) {
                            return (StepBaseNode)StepLongFixnumRangeIntRubyProcNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value) && !RangeNodes.StepNode.isStepValidInt(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value), arguments1Value, arguments2ValueCast)) {
                        return (StepBaseNode)StepIntegerFixnumRangeObjectRubyProcNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value) && !RangeNodes.StepNode.isStepValidInt(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value), arguments1Value, arguments2ValueCast)) {
                        return (StepBaseNode)StepLongFixnumRangeObjectRubyProcNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (StepBaseNode)StepIntegerFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (StepBaseNode)StepIntegerFixnumRangeUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && !super.isInteger(arguments1Value) && !super.isLong(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        return (StepBaseNode)StepIntegerFixnumRangeObjectUndefinedPlaceholderNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (StepBaseNode)StepLongFixnumRangeUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (StepBaseNode)StepLongFixnumRangeUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        return (StepBaseNode)StepLongFixnumRangeObjectUndefinedPlaceholderNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        return (StepBaseNode)StepObjectRangeObjectRubyProcNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (StepBaseNode)StepObjectRangeUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                            return (StepBaseNode)StepObjectRangeUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        return (StepBaseNode)StepObjectRangeObjectUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    StepBaseNode otherCast = (StepBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (StepBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.EndNode.class)
    public static final class EndNodeFactory
    extends NodeFactoryBase<RangeNodes.EndNode> {
        private static EndNodeFactory endNodeFactoryInstance;

        private EndNodeFactory() {
            super(RangeNodes.EndNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.EndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EndNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.EndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EndUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.EndNode> getInstance() {
            if (endNodeFactoryInstance == null) {
                endNodeFactoryInstance = new EndNodeFactory();
            }
            return endNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.EndNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EndPolymorphicNode
        extends EndBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EndPolymorphicNode(EndBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.LongFixnumRange.class ? this.arguments[0].executeLongFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=RangeNodes.EndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EndObjectObjectRangeNode
        extends EndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EndObjectObjectRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class}, 0, 0);

            EndObjectObjectRangeNode(EndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof ObjectRange");
                }
                return super.last(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    return super.last(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.EndNode create0(RangeNodes.EndNode current) {
                return new EndObjectObjectRangeNode((EndBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.EndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EndLongLongFixnumRangeNode
        extends EndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EndLongLongFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class}, 0, 0);

            EndLongLongFixnumRangeNode(EndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof LongFixnumRange"));
                }
                return super.last(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value)) {
                    RubyRange.LongFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value);
                    return super.last(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.EndNode create0(RangeNodes.EndNode current) {
                return new EndLongLongFixnumRangeNode((EndBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.EndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EndIntIntegerFixnumRangeNode
        extends EndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EndIntIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class}, 0, 0);

            EndIntIntegerFixnumRangeNode(EndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof IntegerFixnumRange"));
                }
                return super.last(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    return super.last(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.EndNode create0(RangeNodes.EndNode current) {
                return new EndIntIntegerFixnumRangeNode((EndBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.EndNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EndUninitializedNode
        extends EndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EndUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EndUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EndUninitializedNode(EndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EndBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EndBaseNode rootNode = (EndBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EndBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.EndNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EndUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.EndNode.class)
        private static abstract class EndBaseNode
        extends RangeNodes.EndNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EndBaseNode next0;

            EndBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EndBaseNode(EndBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                EndBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EndBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EndUninitializedNode(this);
                    ((EndUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EndBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EndBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (EndBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EndUninitializedNode(this), (Node)new EndPolymorphicNode(this), (DSLNode)((EndBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EndBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    return (EndBaseNode)EndIntIntegerFixnumRangeNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value)) {
                    return (EndBaseNode)EndLongLongFixnumRangeNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    return (EndBaseNode)EndObjectObjectRangeNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EndBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EndBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<RangeNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(RangeNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.ObjectRange value;
                try {
                    value = this.executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyRange.ObjectRange executeObjectRange(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments3Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments3PolymorphicType == UndefinedPlaceholder.class ? this.arguments[3].executeUndefinedPlaceholder(frameValue) : (this.arguments3PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[3].executeBoolean(frameValue)) : this.arguments[3].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments3PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
            }

            @Override
            protected RubyRange.ObjectRange executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }
        }

        @GeneratedBy(value=RangeNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeObjectRangeObjectBooleanNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeObjectRangeObjectBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, Object.class, Object.class, Boolean.TYPE}, 0, 0);

            InitializeObjectRangeObjectBooleanNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.ObjectRange value;
                try {
                    value = this.executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyRange.ObjectRange executeObjectRange(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments3Value;
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof ObjectRange");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof boolean");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyRange.ObjectRange executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments3Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    boolean arguments3ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1Value, arguments2Value, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static RangeNodes.InitializeNode create0(RangeNodes.InitializeNode current) {
                return new InitializeObjectRangeObjectBooleanNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeObjectRangeObjectUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeObjectRangeObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, Object.class, Object.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeObjectRangeObjectUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.ObjectRange value;
                try {
                    value = this.executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyRange.ObjectRange executeObjectRange(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof ObjectRange");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyRange.ObjectRange executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1Value, arguments2Value, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static RangeNodes.InitializeNode create0(RangeNodes.InitializeNode current) {
                return new InitializeObjectRangeObjectUndefinedPlaceholderNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.ObjectRange value;
                try {
                    value = this.executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyRange.ObjectRange executeObjectRange(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyRange.ObjectRange executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            protected RubyRange.ObjectRange executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = (InitializeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3]}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static RangeNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends RangeNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyRange.ObjectRange executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final RubyRange.ObjectRange rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, String reason) {
                String message;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value, arguments3Value)))) == null) {
                    returnNode = (InitializeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeUninitializedNode(this), (Node)new InitializePolymorphicNode(this), (DSLNode)((InitializeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                        return (InitializeBaseNode)InitializeObjectRangeObjectUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments3Value)) {
                        return (InitializeBaseNode)InitializeObjectRangeObjectBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.BeginNode.class)
    public static final class BeginNodeFactory
    extends NodeFactoryBase<RangeNodes.BeginNode> {
        private static BeginNodeFactory beginNodeFactoryInstance;

        private BeginNodeFactory() {
            super(RangeNodes.BeginNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.BeginNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BeginNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.BeginNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BeginUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.BeginNode> getInstance() {
            if (beginNodeFactoryInstance == null) {
                beginNodeFactoryInstance = new BeginNodeFactory();
            }
            return beginNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.BeginNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BeginPolymorphicNode
        extends BeginBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            BeginPolymorphicNode(BeginBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.LongFixnumRange.class ? this.arguments[0].executeLongFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=RangeNodes.BeginNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BeginObjectObjectRangeNode
        extends BeginBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BeginObjectObjectRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class}, 0, 0);

            BeginObjectObjectRangeNode(BeginBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof ObjectRange");
                }
                return super.each(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    return super.each(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.BeginNode create0(RangeNodes.BeginNode current) {
                return new BeginObjectObjectRangeNode((BeginBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.BeginNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BeginLongLongFixnumRangeNode
        extends BeginBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BeginLongLongFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class}, 0, 0);

            BeginLongLongFixnumRangeNode(BeginBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof LongFixnumRange"));
                }
                return super.each(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value)) {
                    RubyRange.LongFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value);
                    return super.each(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.BeginNode create0(RangeNodes.BeginNode current) {
                return new BeginLongLongFixnumRangeNode((BeginBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.BeginNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BeginIntIntegerFixnumRangeNode
        extends BeginBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BeginIntIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class}, 0, 0);

            BeginIntIntegerFixnumRangeNode(BeginBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof IntegerFixnumRange"));
                }
                return super.each(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    return super.each(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.BeginNode create0(RangeNodes.BeginNode current) {
                return new BeginIntIntegerFixnumRangeNode((BeginBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.BeginNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BeginUninitializedNode
        extends BeginBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BeginUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BeginUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BeginUninitializedNode(BeginBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                BeginBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BeginBaseNode rootNode = (BeginBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BeginBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.BeginNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BeginUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.BeginNode.class)
        private static abstract class BeginBaseNode
        extends RangeNodes.BeginNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BeginBaseNode next0;

            BeginBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BeginBaseNode(BeginBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                BeginBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BeginBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new BeginUninitializedNode(this);
                    ((BeginUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BeginBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = BeginBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (BeginBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BeginUninitializedNode(this), (Node)new BeginPolymorphicNode(this), (DSLNode)((BeginBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BeginBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                    return (BeginBaseNode)BeginIntIntegerFixnumRangeNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value)) {
                    return (BeginBaseNode)BeginLongLongFixnumRangeNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                    return (BeginBaseNode)BeginObjectObjectRangeNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((BeginBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (BeginBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
    public static final class ExcludeEndNodeFactory
    extends NodeFactoryBase<RangeNodes.ExcludeEndNode> {
        private static ExcludeEndNodeFactory excludeEndNodeFactoryInstance;

        private ExcludeEndNodeFactory() {
            super(RangeNodes.ExcludeEndNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.ExcludeEndNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExcludeEndNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.ExcludeEndNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExcludeEndUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.ExcludeEndNode> getInstance() {
            if (excludeEndNodeFactoryInstance == null) {
                excludeEndNodeFactoryInstance = new ExcludeEndNodeFactory();
            }
            return excludeEndNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExcludeEndPolymorphicNode
        extends ExcludeEndBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ExcludeEndPolymorphicNode(ExcludeEndBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExcludeEndRubyRangeNode
        extends ExcludeEndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExcludeEndRubyRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.class}, 0, 0);

            ExcludeEndRubyRangeNode(ExcludeEndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyRange");
                }
                return super.excludeEnd(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyRange(arguments0Value)) {
                    RubyRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyRange(arguments0Value);
                    return super.excludeEnd(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ExcludeEndNode create0(RangeNodes.ExcludeEndNode current) {
                return new ExcludeEndRubyRangeNode((ExcludeEndBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExcludeEndUninitializedNode
        extends ExcludeEndBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExcludeEndUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExcludeEndUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExcludeEndUninitializedNode(ExcludeEndBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ExcludeEndBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ExcludeEndBaseNode rootNode = (ExcludeEndBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ExcludeEndBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static RangeNodes.ExcludeEndNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExcludeEndUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.ExcludeEndNode.class)
        private static abstract class ExcludeEndBaseNode
        extends RangeNodes.ExcludeEndNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExcludeEndBaseNode next0;

            ExcludeEndBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExcludeEndBaseNode(ExcludeEndBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ExcludeEndBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExcludeEndBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ExcludeEndUninitializedNode(this);
                    ((ExcludeEndUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ExcludeEndBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ExcludeEndBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ExcludeEndBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ExcludeEndUninitializedNode(this), (Node)new ExcludeEndPolymorphicNode(this), (DSLNode)((ExcludeEndBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExcludeEndBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyRange(arguments0Value)) {
                    return (ExcludeEndBaseNode)ExcludeEndRubyRangeNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ExcludeEndBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ExcludeEndBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<RangeNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(RangeNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachPolymorphicNode
        extends EachBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachPolymorphicNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[0].executeIntegerFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.LongFixnumRange.class ? this.arguments[0].executeLongFixnumRange(frameValue) : (this.arguments0PolymorphicType == RubyRange.ObjectRange.class ? this.arguments[0].executeObjectRange(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyProc.class ? this.arguments[1].executeRubyProc(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachObjectRangeRubyProcNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachObjectRangeRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, RubyProc.class}, 0, 0);

            EachObjectRangeRubyProcNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof ObjectRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.each(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.each(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EachNode create0(RangeNodes.EachNode current) {
                return new EachObjectRangeRubyProcNode((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachObjectRangeUndefinedPlaceholderNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachObjectRangeUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.ObjectRange.class, UndefinedPlaceholder.class}, 0, 0);

            EachObjectRangeUndefinedPlaceholderNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyRange.ObjectRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof ObjectRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.each(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyRange.ObjectRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectRange(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.each(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EachNode create0(RangeNodes.EachNode current) {
                return new EachObjectRangeUndefinedPlaceholderNode((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachLongFixnumRangeUndefinedPlaceholderNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachLongFixnumRangeUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class, UndefinedPlaceholder.class}, 0, 0);

            EachLongFixnumRangeUndefinedPlaceholderNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof LongFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.each(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyRange.LongFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.each(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EachNode create0(RangeNodes.EachNode current) {
                return new EachLongFixnumRangeUndefinedPlaceholderNode((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachLongFixnumRangeRubyProcNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachLongFixnumRangeRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.LongFixnumRange.class, RubyProc.class}, 0, 0);

            EachLongFixnumRangeRubyProcNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyRange.LongFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof LongFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.each(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyRange.LongFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLongFixnumRange(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.each(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EachNode create0(RangeNodes.EachNode current) {
                return new EachLongFixnumRangeRubyProcNode((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachIntegerFixnumRangeRubyProcNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachIntegerFixnumRangeRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, RubyProc.class}, 0, 0);

            EachIntegerFixnumRangeRubyProcNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.each(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.each(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EachNode create0(RangeNodes.EachNode current) {
                return new EachIntegerFixnumRangeRubyProcNode((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachUninitializedNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachUninitializedNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachBaseNode rootNode = (EachBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.EachNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.EachNode.class)
        private static abstract class EachBaseNode
        extends RangeNodes.EachNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachBaseNode next0;

            EachBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachBaseNode(EachBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EachBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachUninitializedNode(this);
                    ((EachUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EachBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachUninitializedNode(this), (Node)new EachPolymorphicNode(this), (DSLNode)((EachBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value)) {
                        return (EachBaseNode)EachIntegerFixnumRangeRubyProcNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value)) {
                        return (EachBaseNode)EachLongFixnumRangeRubyProcNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isLongFixnumRange(arguments0Value)) {
                        return (EachBaseNode)EachLongFixnumRangeUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value)) {
                        return (EachBaseNode)EachObjectRangeUndefinedPlaceholderNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isObjectRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    return (EachBaseNode)EachObjectRangeRubyProcNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachBaseNode otherCast = (EachBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=RangeNodes.CollectNode.class)
    public static final class CollectNodeFactory
    extends NodeFactoryBase<RangeNodes.CollectNode> {
        private static CollectNodeFactory collectNodeFactoryInstance;

        private CollectNodeFactory() {
            super(RangeNodes.CollectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public RangeNodes.CollectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CollectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static RangeNodes.CollectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CollectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<RangeNodes.CollectNode> getInstance() {
            if (collectNodeFactoryInstance == null) {
                collectNodeFactoryInstance = new CollectNodeFactory();
            }
            return collectNodeFactoryInstance;
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CollectPolymorphicNode
        extends CollectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            CollectPolymorphicNode(CollectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CollectIntegerFixnumRangeNode
        extends CollectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CollectIntegerFixnumRangeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyRange.IntegerFixnumRange.class, RubyProc.class}, 0, 0);

            CollectIntegerFixnumRangeNode(CollectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyRange.IntegerFixnumRange arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.collect(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyRange.IntegerFixnumRange arguments0ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.collect(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.CollectNode create0(RangeNodes.CollectNode current) {
                return new CollectIntegerFixnumRangeNode((CollectBaseNode)current);
            }
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CollectUninitializedNode
        extends CollectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CollectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CollectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CollectUninitializedNode(CollectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                CollectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CollectBaseNode rootNode = (CollectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CollectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static RangeNodes.CollectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CollectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=RangeNodes.CollectNode.class)
        private static abstract class CollectBaseNode
        extends RangeNodes.CollectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CollectBaseNode next0;

            CollectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CollectBaseNode(CollectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                CollectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CollectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new CollectUninitializedNode(this);
                    ((CollectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CollectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CollectBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (CollectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CollectUninitializedNode(this), (Node)new CollectPolymorphicNode(this), (DSLNode)((CollectBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CollectBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    return (CollectBaseNode)CollectIntegerFixnumRangeNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CollectBaseNode otherCast = (CollectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (CollectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

