/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import org.jruby.truffle.nodes.core.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.NextException;
import org.jruby.truffle.runtime.control.RedoException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;

@CoreClass(name="Range")
public abstract class RangeNodes {

    @CoreMethod(names={"to_a"}, lowerFixnumSelf=true)
    public static abstract class ToANode
    extends CoreMethodNode {
        public ToANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToANode(ToANode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray toA(RubyRange.IntegerFixnumRange range) {
            int begin = range.getBegin();
            int length = range.getExclusiveEnd() - begin;
            if (length < 0) {
                return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            }
            int[] values = new int[length];
            for (int n = 0; n < length; ++n) {
                values[n] = begin + n;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), values, length);
        }

        @Specialization
        public Object toA(VirtualFrame frame, RubyRange.ObjectRange range) {
            return this.ruby(frame, "to_a_internal", new Object[0]);
        }
    }

    @CoreMethod(names={"step"}, needsBlock=true, optional=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class StepNode
    extends YieldingCoreMethodNode {
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public StepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public StepNode(StepNode prev) {
            super(prev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isStepValid"})
        public Object step(VirtualFrame frame, RubyRange.IntegerFixnumRange range, int step, RubyProc block) {
            int count = 0;
            try {
                block6: for (int n = range.getBegin(); n < range.getExclusiveEnd(); n += step) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isStepValid"})
        public Object step(VirtualFrame frame, RubyRange.LongFixnumRange range, int step, RubyProc block) {
            int count = 0;
            try {
                block6: for (long n = range.getBegin(); n < range.getExclusiveEnd(); n += (long)step) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        @Specialization(guards={"!isStepValidInt", "!isUndefinedPlaceholder(arguments[1])"})
        public Object stepFallback(VirtualFrame frame, RubyRange.IntegerFixnumRange range, Object step, RubyProc block) {
            return this.ruby(frame, "step_internal(step, &block)", "step", step, "block", block);
        }

        @Specialization(guards={"!isStepValidInt", "!isUndefinedPlaceholder(arguments[1])"})
        public Object stepFallback(VirtualFrame frame, RubyRange.LongFixnumRange range, Object step, RubyProc block) {
            return this.ruby(frame, "step_internal(step, &block)", "step", step, "block", block);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.IntegerFixnumRange range, UndefinedPlaceholder step, UndefinedPlaceholder block) {
            return this.ruby(frame, "step_internal", new Object[0]);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.IntegerFixnumRange range, UndefinedPlaceholder step, RubyProc block) {
            return this.ruby(frame, "step_internal(&block)", "block", block);
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object step(VirtualFrame frame, RubyRange.IntegerFixnumRange range, Object step, UndefinedPlaceholder block) {
            return this.ruby(frame, "step_internal(step)", "step", step);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.LongFixnumRange range, UndefinedPlaceholder step, UndefinedPlaceholder block) {
            return this.ruby(frame, "step_internal", new Object[0]);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.LongFixnumRange range, UndefinedPlaceholder step, RubyProc block) {
            return this.ruby(frame, "step_internal(&block)", "block", block);
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[1])"})
        public Object step(VirtualFrame frame, RubyRange.LongFixnumRange range, Object step, UndefinedPlaceholder block) {
            return this.ruby(frame, "step_internal(step)", "step", step);
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[1])"})
        public Object step(VirtualFrame frame, RubyRange.ObjectRange range, Object step, RubyProc block) {
            return this.ruby(frame, "step_internal(step, &block)", "step", step, "block", block);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.ObjectRange range, UndefinedPlaceholder step, UndefinedPlaceholder block) {
            return this.ruby(frame, "step_internal", new Object[0]);
        }

        @Specialization
        public Object step(VirtualFrame frame, RubyRange.ObjectRange range, UndefinedPlaceholder step, RubyProc block) {
            return this.ruby(frame, "step_internal(&block)", "block", block);
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[1])"})
        public Object step(VirtualFrame frame, RubyRange.ObjectRange range, Object step, UndefinedPlaceholder block) {
            return this.ruby(frame, "step_internal(step)", "step", step);
        }

        public static boolean isStepValidInt(RubyRange.IntegerFixnumRange fixnumRange, Object step, RubyProc proc) {
            return step instanceof Integer && (Integer)step > 0;
        }

        public static boolean isStepValidInt(RubyRange.LongFixnumRange fixnumRange, Object step, RubyProc proc) {
            return step instanceof Integer && (Integer)step > 0;
        }

        public static boolean isStepValid(RubyRange.IntegerFixnumRange fixnumRange, int step, RubyProc proc) {
            return step > 0;
        }

        public static boolean isStepValid(RubyRange.LongFixnumRange fixnumRange, int step, RubyProc proc) {
            return step > 0;
        }
    }

    @CoreMethod(names={"end"})
    public static abstract class EndNode
    extends CoreMethodNode {
        public EndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EndNode(EndNode prev) {
            super(prev);
        }

        @Specialization
        public int last(RubyRange.IntegerFixnumRange range) {
            return range.getEnd();
        }

        @Specialization
        public long last(RubyRange.LongFixnumRange range) {
            return range.getEnd();
        }

        @Specialization
        public Object last(RubyRange.ObjectRange range) {
            return range.getEnd();
        }
    }

    @CoreMethod(names={"initialize_internal"}, required=2, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyRange.ObjectRange initialize(RubyRange.ObjectRange range, Object begin, Object end, UndefinedPlaceholder undefined) {
            return this.initialize(range, begin, end, false);
        }

        @Specialization
        public RubyRange.ObjectRange initialize(RubyRange.ObjectRange range, Object begin, Object end, boolean excludeEnd) {
            range.initialize(begin, end, excludeEnd);
            return range;
        }
    }

    @CoreMethod(names={"begin"})
    public static abstract class BeginNode
    extends CoreMethodNode {
        public BeginNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BeginNode(BeginNode prev) {
            super(prev);
        }

        @Specialization
        public int each(RubyRange.IntegerFixnumRange range) {
            return range.getBegin();
        }

        @Specialization
        public long each(RubyRange.LongFixnumRange range) {
            return range.getBegin();
        }

        @Specialization
        public Object each(RubyRange.ObjectRange range) {
            return range.getBegin();
        }
    }

    @CoreMethod(names={"exclude_end?"})
    public static abstract class ExcludeEndNode
    extends CoreMethodNode {
        public ExcludeEndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExcludeEndNode(ExcludeEndNode prev) {
            super(prev);
        }

        @Specialization
        public boolean excludeEnd(RubyRange range) {
            return range.doesExcludeEnd();
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true, lowerFixnumSelf=true, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachNode(EachNode prev) {
            super(prev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object each(VirtualFrame frame, RubyRange.IntegerFixnumRange range, RubyProc block) {
            int exclusiveEnd = range.getExclusiveEnd();
            int count = 0;
            try {
                block6: for (int n = range.getBegin(); n < exclusiveEnd; ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object each(VirtualFrame frame, RubyRange.LongFixnumRange range, RubyProc block) {
            long exclusiveEnd = range.getExclusiveEnd();
            int count = 0;
            try {
                block6: for (long n = range.getBegin(); n < exclusiveEnd; ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return range;
        }

        @Specialization
        public Object each(VirtualFrame frame, RubyRange.LongFixnumRange range, UndefinedPlaceholder proc) {
            return this.ruby(frame, "each_internal(&block)", "block", this.nil());
        }

        @Specialization
        public Object each(VirtualFrame frame, RubyRange.ObjectRange range, UndefinedPlaceholder proc) {
            return this.ruby(frame, "each_internal(&block)", "block", this.nil());
        }

        @Specialization
        public Object each(VirtualFrame frame, RubyRange.ObjectRange range, RubyProc proc) {
            return this.ruby(frame, "each_internal(&block)", "block", proc);
        }
    }

    @CoreMethod(names={"collect", "map"}, needsBlock=true, lowerFixnumSelf=true)
    public static abstract class CollectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public CollectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public CollectNode(CollectNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public RubyArray collect(VirtualFrame frame, RubyRange.IntegerFixnumRange range, RubyProc block) {
            int begin = range.getBegin();
            int exclusiveEnd = range.getExclusiveEnd();
            int length = exclusiveEnd - begin;
            Object store = this.arrayBuilder.start(length);
            int count = 0;
            try {
                for (int n = 0; n < length; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    store = this.arrayBuilder.append(store, n, this.yield(frame, block, n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(store, length), length);
        }
    }
}

