/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.signal.SignalOperations;
import sun.misc.Signal;

@CoreClass(name="Process")
public abstract class ProcessNodes {
    public static final int CLOCK_MONOTONIC = 1;
    public static final int CLOCK_REALTIME = 2;

    @CoreMethod(names={"pid"}, onSingleton=true)
    public static abstract class PidNode
    extends CoreMethodNode {
        public PidNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PidNode(PidNode prev) {
            super(prev);
        }

        @Specialization
        public int pid() {
            PidNode.notDesignedForCompilation();
            return this.posix().getpid();
        }
    }

    @CoreMethod(names={"kill"}, onSingleton=true, required=2)
    public static abstract class KillNode
    extends CoreMethodNode {
        public KillNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public KillNode(KillNode prev) {
            super(prev);
        }

        @Specialization
        public int kill(RubySymbol signalName, int pid) {
            KillNode.notDesignedForCompilation();
            int self = this.posix().getpid();
            if (self == pid) {
                Signal signal = new Signal(signalName.toString());
                SignalOperations.raise(signal);
                return 1;
            }
            throw new UnsupportedOperationException();
        }
    }

    @CoreMethod(names={"clock_gettime"}, onSingleton=true, required=1, optional=1)
    public static abstract class ClockGetTimeNode
    extends CoreMethodNode {
        private final RubySymbol floatSecondSymbol;
        private final RubySymbol nanosecondSymbol;

        public ClockGetTimeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.floatSecondSymbol = context.getSymbol("float_second");
            this.nanosecondSymbol = context.getSymbol("nanosecond");
        }

        public ClockGetTimeNode(ClockGetTimeNode prev) {
            super(prev);
            this.floatSecondSymbol = prev.floatSecondSymbol;
            this.nanosecondSymbol = prev.nanosecondSymbol;
        }

        @Specialization(guards={"isMonotonic(arguments[0])"})
        Object clock_gettime_monotonic(int clock_id, UndefinedPlaceholder unit) {
            return this.clock_gettime_monotonic(1, this.floatSecondSymbol);
        }

        @Specialization(guards={"isRealtime(arguments[0])"})
        Object clock_gettime_realtime(int clock_id, UndefinedPlaceholder unit) {
            return this.clock_gettime_realtime(2, this.floatSecondSymbol);
        }

        @Specialization(guards={"isMonotonic(arguments[0])"})
        Object clock_gettime_monotonic(int clock_id, RubySymbol unit) {
            long time = System.nanoTime();
            return this.timeToUnit(time, unit);
        }

        @Specialization(guards={"isRealtime(arguments[0])"})
        Object clock_gettime_realtime(int clock_id, RubySymbol unit) {
            long time = System.currentTimeMillis() * 1000000L;
            return this.timeToUnit(time, unit);
        }

        Object timeToUnit(long time, RubySymbol unit) {
            if (unit == this.nanosecondSymbol) {
                return time;
            }
            if (unit == this.floatSecondSymbol) {
                return (double)time / 1.0E9;
            }
            throw new UnsupportedOperationException(unit.toString());
        }

        static boolean isMonotonic(int clock_id) {
            return clock_id == 1;
        }

        static boolean isRealtime(int clock_id) {
            return clock_id == 2;
        }
    }
}

