/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameInstanceVisitor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.util.Memo;

@CoreClass(name="Proc")
public abstract class ProcNodes {

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodNode {
        public SourceLocationNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SourceLocationNode(SourceLocationNode prev) {
            super(prev);
        }

        @Specialization
        public Object sourceLocation(RubyProc proc) {
            SourceLocationNode.notDesignedForCompilation();
            SourceSection sourceSection = proc.getSharedMethodInfo().getSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.nil();
            }
            RubyString file = this.getContext().makeString(sourceSection.getSource().getName());
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), file, sourceSection.getStartLine());
        }
    }

    @CoreMethod(names={"parameters"})
    public static abstract class ParametersNode
    extends CoreMethodNode {
        public ParametersNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ParametersNode(ParametersNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyArray parameters(RubyProc proc) {
            ArgsNode argsNode = (ArgsNode)proc.getSharedMethodInfo().getParseTree().findFirstChild(ArgsNode.class);
            String[] parameters = Helpers.encodeParameterList((ArgsNode)argsNode).split(";");
            return (RubyArray)this.getContext().toTruffle((IRubyObject)Helpers.parameterListToParameters((Ruby)this.getContext().getRuntime(), (String[])parameters, (proc.getType() == RubyProc.Type.LAMBDA ? 1 : 0) != 0));
        }
    }

    @CoreMethod(names={"lambda?"})
    public static abstract class LambdaNode
    extends CoreMethodNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LambdaNode(LambdaNode prev) {
            super(prev);
        }

        @Specialization
        public boolean lambda(RubyProc proc) {
            return proc.getType() == RubyProc.Type.LAMBDA;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize(RubyProc proc, RubyProc block) {
            proc.initialize(block.getSharedMethodInfo(), block.getCallTargetForProcs(), block.getCallTargetForProcs(), block.getCallTargetForMethods(), block.getDeclarationFrame(), block.getMethod(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope());
            return this.nil();
        }

        @Specialization
        public RubyNilClass initialize(VirtualFrame frame, RubyProc proc, UndefinedPlaceholder block) {
            InitializeNode.notDesignedForCompilation();
            final Memo frameCount = new Memo((Object)0);
            MaterializedFrame grandparentFrame = (MaterializedFrame)Truffle.getRuntime().iterateFrames((FrameInstanceVisitor)new FrameInstanceVisitor<MaterializedFrame>(){

                public MaterializedFrame visitFrame(FrameInstance frameInstance) {
                    if ((Integer)frameCount.get() == 1) {
                        return frameInstance.getFrame(FrameInstance.FrameAccess.READ_WRITE, false).materialize();
                    }
                    frameCount.set((Object)((Integer)frameCount.get() + 1));
                    return null;
                }
            });
            RubyProc grandparentBlock = RubyArguments.getBlock(grandparentFrame.getArguments());
            if (grandparentBlock == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("tried to create Proc object without a block", this));
            }
            return this.initialize(proc, grandparentBlock);
        }
    }

    @CoreMethod(names={"call", "[]", "yield"}, argumentsAsArray=true, needsBlock=true)
    public static abstract class CallNode
    extends CoreMethodNode {
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public CallNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        public CallNode(CallNode prev) {
            super(prev);
            this.yieldNode = prev.yieldNode;
        }

        @Specialization
        public Object call(VirtualFrame frame, RubyProc proc, Object[] args, UndefinedPlaceholder block) {
            return this.yieldNode.dispatch(frame, proc, args);
        }

        @Specialization
        public Object call(VirtualFrame frame, RubyProc proc, Object[] args, RubyProc block) {
            return this.yieldNode.dispatchWithModifiedBlock(frame, proc, block, args);
        }
    }

    @CoreMethod(names={"binding"})
    public static abstract class BindingNode
    extends CoreMethodNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BindingNode(BindingNode prev) {
            super(prev);
        }

        @Specialization
        public Object binding(RubyProc proc) {
            MaterializedFrame frame = proc.getDeclarationFrame();
            return new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(frame.getArguments()), frame);
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodNode {
        public ArityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ArityNode(ArityNode prev) {
            super(prev);
        }

        @Specialization
        public int arity(RubyProc proc) {
            return proc.getSharedMethodInfo().getArity().getArityNumber();
        }
    }
}

