/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.ObjectSpaceNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;

@GeneratedBy(value=ObjectSpaceNodes.class)
public final class ObjectSpaceNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ID2RefNodeFactory.getInstance(), EachObjectNodeFactory.getInstance(), DefineFinalizerNodeFactory.getInstance(), UndefineFinalizerNodeFactory.getInstance());
    }

    @GeneratedBy(value=ObjectSpaceNodes.UndefineFinalizerNode.class)
    public static final class UndefineFinalizerNodeFactory
    extends NodeFactoryBase<ObjectSpaceNodes.UndefineFinalizerNode> {
        private static UndefineFinalizerNodeFactory undefineFinalizerNodeFactoryInstance;

        private UndefineFinalizerNodeFactory() {
            super(ObjectSpaceNodes.UndefineFinalizerNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ObjectSpaceNodes.UndefineFinalizerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UndefineFinalizerNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ObjectSpaceNodes.UndefineFinalizerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UndefineFinalizerObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ObjectSpaceNodes.UndefineFinalizerNode> getInstance() {
            if (undefineFinalizerNodeFactoryInstance == null) {
                undefineFinalizerNodeFactoryInstance = new UndefineFinalizerNodeFactory();
            }
            return undefineFinalizerNodeFactoryInstance;
        }

        @GeneratedBy(value=ObjectSpaceNodes.UndefineFinalizerNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UndefineFinalizerObjectNode
        extends UndefineFinalizerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UndefineFinalizerObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            UndefineFinalizerObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.undefineFinalizer(arguments0Value);
            }

            static ObjectSpaceNodes.UndefineFinalizerNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UndefineFinalizerObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.UndefineFinalizerNode.class)
        private static abstract class UndefineFinalizerBaseNode
        extends ObjectSpaceNodes.UndefineFinalizerNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            UndefineFinalizerBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UndefineFinalizerBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
    public static final class DefineFinalizerNodeFactory
    extends NodeFactoryBase<ObjectSpaceNodes.DefineFinalizerNode> {
        private static DefineFinalizerNodeFactory defineFinalizerNodeFactoryInstance;

        private DefineFinalizerNodeFactory() {
            super(ObjectSpaceNodes.DefineFinalizerNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ObjectSpaceNodes.DefineFinalizerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DefineFinalizerNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ObjectSpaceNodes.DefineFinalizerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DefineFinalizerUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ObjectSpaceNodes.DefineFinalizerNode> getInstance() {
            if (defineFinalizerNodeFactoryInstance == null) {
                defineFinalizerNodeFactoryInstance = new DefineFinalizerNodeFactory();
            }
            return defineFinalizerNodeFactoryInstance;
        }

        @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DefineFinalizerPolymorphicNode
        extends DefineFinalizerBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DefineFinalizerPolymorphicNode(DefineFinalizerBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DefineFinalizerObjectNode
        extends DefineFinalizerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineFinalizerObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyProc.class}, 0, 0);

            DefineFinalizerObjectNode(DefineFinalizerBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.defineFinalizer(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.defineFinalizer(arguments0Value, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ObjectSpaceNodes.DefineFinalizerNode create0(ObjectSpaceNodes.DefineFinalizerNode current) {
                return new DefineFinalizerObjectNode((DefineFinalizerBaseNode)current);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DefineFinalizerUninitializedNode
        extends DefineFinalizerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DefineFinalizerUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DefineFinalizerUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DefineFinalizerUninitializedNode(DefineFinalizerBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DefineFinalizerBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DefineFinalizerBaseNode rootNode = (DefineFinalizerBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DefineFinalizerBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ObjectSpaceNodes.DefineFinalizerNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DefineFinalizerUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.DefineFinalizerNode.class)
        private static abstract class DefineFinalizerBaseNode
        extends ObjectSpaceNodes.DefineFinalizerNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DefineFinalizerBaseNode next0;

            DefineFinalizerBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DefineFinalizerBaseNode(DefineFinalizerBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                DefineFinalizerBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DefineFinalizerBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DefineFinalizerUninitializedNode(this);
                    ((DefineFinalizerUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DefineFinalizerBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DefineFinalizerBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DefineFinalizerBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DefineFinalizerUninitializedNode(this), (Node)new DefineFinalizerPolymorphicNode(this), (DSLNode)((DefineFinalizerBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DefineFinalizerBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    return (DefineFinalizerBaseNode)DefineFinalizerObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DefineFinalizerBaseNode otherCast = (DefineFinalizerBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DefineFinalizerBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
    public static final class EachObjectNodeFactory
    extends NodeFactoryBase<ObjectSpaceNodes.EachObjectNode> {
        private static EachObjectNodeFactory eachObjectNodeFactoryInstance;

        private EachObjectNodeFactory() {
            super(ObjectSpaceNodes.EachObjectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ObjectSpaceNodes.EachObjectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachObjectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ObjectSpaceNodes.EachObjectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachObjectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ObjectSpaceNodes.EachObjectNode> getInstance() {
            if (eachObjectNodeFactoryInstance == null) {
                eachObjectNodeFactoryInstance = new EachObjectNodeFactory();
            }
            return eachObjectNodeFactoryInstance;
        }

        @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachObjectPolymorphicNode
        extends EachObjectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachObjectPolymorphicNode(EachObjectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == UndefinedPlaceholder.class ? this.arguments[0].executeUndefinedPlaceholder(frameValue) : (this.arguments0PolymorphicType == RubyClass.class ? this.arguments[0].executeRubyClass(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value);
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachObjectRubyClassNode
        extends EachObjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachObjectRubyClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyClass.class, RubyProc.class}, 0, 0);

            EachObjectRubyClassNode(EachObjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyClass");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.eachObject(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.eachObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ObjectSpaceNodes.EachObjectNode create0(ObjectSpaceNodes.EachObjectNode current) {
                return new EachObjectRubyClassNode((EachObjectBaseNode)current);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachObjectUndefinedPlaceholderNode
        extends EachObjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            EachObjectUndefinedPlaceholderNode(EachObjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                UndefinedPlaceholder arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.eachObject(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    UndefinedPlaceholder arguments0ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.eachObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ObjectSpaceNodes.EachObjectNode create0(ObjectSpaceNodes.EachObjectNode current) {
                return new EachObjectUndefinedPlaceholderNode((EachObjectBaseNode)current);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachObjectUninitializedNode
        extends EachObjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachObjectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachObjectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachObjectUninitializedNode(EachObjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachObjectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachObjectBaseNode rootNode = (EachObjectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachObjectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ObjectSpaceNodes.EachObjectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachObjectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.EachObjectNode.class)
        private static abstract class EachObjectBaseNode
        extends ObjectSpaceNodes.EachObjectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachObjectBaseNode next0;

            EachObjectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachObjectBaseNode(EachObjectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EachObjectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachObjectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachObjectUninitializedNode(this);
                    ((EachObjectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachObjectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EachObjectBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachObjectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachObjectUninitializedNode(this), (Node)new EachObjectPolymorphicNode(this), (DSLNode)((EachObjectBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachObjectBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                        return (EachObjectBaseNode)EachObjectUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments0Value)) {
                        return (EachObjectBaseNode)EachObjectRubyClassNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachObjectBaseNode otherCast = (EachObjectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachObjectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
    public static final class ID2RefNodeFactory
    extends NodeFactoryBase<ObjectSpaceNodes.ID2RefNode> {
        private static ID2RefNodeFactory iD2RefNodeFactoryInstance;

        private ID2RefNodeFactory() {
            super(ObjectSpaceNodes.ID2RefNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ObjectSpaceNodes.ID2RefNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ID2RefNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ObjectSpaceNodes.ID2RefNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ID2RefUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ObjectSpaceNodes.ID2RefNode> getInstance() {
            if (iD2RefNodeFactoryInstance == null) {
                iD2RefNodeFactoryInstance = new ID2RefNodeFactory();
            }
            return iD2RefNodeFactoryInstance;
        }

        @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ID2RefPolymorphicNode
        extends ID2RefBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ID2RefPolymorphicNode(ID2RefBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ID2RefDoubleRubyBignumNode
        extends ID2RefBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ID2RefDoubleRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ID2RefDoubleRubyBignumNode(ID2RefBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum"));
                }
                if (super.isFloatID(arguments0Value)) {
                    return super.id2RefFloat(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, "One of guards [isFloatID] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyBignum arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && super.isFloatID(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value))) {
                    return super.id2RefFloat(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ObjectSpaceNodes.ID2RefNode create0(ObjectSpaceNodes.ID2RefNode current) {
                return new ID2RefDoubleRubyBignumNode((ID2RefBaseNode)current);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ID2RefObjectRubyBignumNode
        extends ID2RefBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ID2RefObjectRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ID2RefObjectRubyBignumNode(ID2RefBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                if (super.isLargeFixnumID(arguments0Value)) {
                    return super.id2RefLargeFixnum(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isLargeFixnumID] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyBignum arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value) && super.isLargeFixnumID(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value))) {
                    return super.id2RefLargeFixnum(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ObjectSpaceNodes.ID2RefNode create0(ObjectSpaceNodes.ID2RefNode current) {
                return new ID2RefObjectRubyBignumNode((ID2RefBaseNode)current);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ID2RefObjectLongNode
        extends ID2RefBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ID2RefObjectLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ID2RefObjectLongNode(ID2RefBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.id2Ref(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.id2Ref(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ObjectSpaceNodes.ID2RefNode create0(ObjectSpaceNodes.ID2RefNode current) {
                return new ID2RefObjectLongNode((ID2RefBaseNode)current);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ID2RefObjectIntNode
        extends ID2RefBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ID2RefObjectIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ID2RefObjectIntNode(ID2RefBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.id2Ref(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.id2Ref(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ObjectSpaceNodes.ID2RefNode create0(ObjectSpaceNodes.ID2RefNode current) {
                return new ID2RefObjectIntNode((ID2RefBaseNode)current);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ID2RefUninitializedNode
        extends ID2RefBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ID2RefUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ID2RefUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ID2RefUninitializedNode(ID2RefBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ID2RefBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ID2RefBaseNode rootNode = (ID2RefBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ID2RefBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ObjectSpaceNodes.ID2RefNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ID2RefUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ObjectSpaceNodes.ID2RefNode.class)
        private static abstract class ID2RefBaseNode
        extends ObjectSpaceNodes.ID2RefNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ID2RefBaseNode next0;

            ID2RefBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ID2RefBaseNode(ID2RefBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ID2RefBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ID2RefBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ID2RefUninitializedNode(this);
                    ((ID2RefUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ID2RefBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ID2RefBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ID2RefBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ID2RefUninitializedNode(this), (Node)new ID2RefPolymorphicNode(this), (DSLNode)((ID2RefBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ID2RefBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ID2RefBaseNode)ID2RefObjectIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ID2RefBaseNode)ID2RefObjectLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    if (super.isLargeFixnumID(arguments0ValueCast)) {
                        return (ID2RefBaseNode)ID2RefObjectRubyBignumNode.create0(this);
                    }
                    if (super.isFloatID(arguments0ValueCast)) {
                        return (ID2RefBaseNode)ID2RefDoubleRubyBignumNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ID2RefBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ID2RefBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

