/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.ObjectIDOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyProc;

@CoreClass(name="ObjectSpace")
public abstract class ObjectSpaceNodes {

    @CoreMethod(names={"undefine_finalizer"}, isModuleFunction=true, required=1)
    public static abstract class UndefineFinalizerNode
    extends CoreMethodNode {
        public UndefineFinalizerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UndefineFinalizerNode(UndefineFinalizerNode prev) {
            super(prev);
        }

        @Specialization
        public Object undefineFinalizer(Object object) {
            UndefineFinalizerNode.notDesignedForCompilation();
            this.getContext().getObjectSpaceManager().undefineFinalizer((RubyBasicObject)object);
            return object;
        }
    }

    @CoreMethod(names={"define_finalizer"}, isModuleFunction=true, required=2)
    public static abstract class DefineFinalizerNode
    extends CoreMethodNode {
        public DefineFinalizerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DefineFinalizerNode(DefineFinalizerNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray defineFinalizer(Object object, RubyProc finalizer) {
            DefineFinalizerNode.notDesignedForCompilation();
            this.getContext().getObjectSpaceManager().defineFinalizer((RubyBasicObject)object, finalizer);
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), 0, finalizer);
        }
    }

    @CoreMethod(names={"each_object"}, isModuleFunction=true, needsBlock=true, optional=1, returnsEnumeratorIfNoBlock=true)
    public static abstract class EachObjectNode
    extends YieldingCoreMethodNode {
        public EachObjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachObjectNode(EachObjectNode prev) {
            super(prev);
        }

        @Specialization
        public int eachObject(VirtualFrame frame, UndefinedPlaceholder ofClass, RubyProc block) {
            EachObjectNode.notDesignedForCompilation();
            int count = 0;
            for (RubyBasicObject object : this.getContext().getObjectSpaceManager().collectLiveObjects().values()) {
                if (this.isHidden(object)) continue;
                this.yield(frame, block, object);
                ++count;
            }
            return count;
        }

        @Specialization
        public int eachObject(VirtualFrame frame, RubyClass ofClass, RubyProc block) {
            EachObjectNode.notDesignedForCompilation();
            int count = 0;
            for (RubyBasicObject object : this.getContext().getObjectSpaceManager().collectLiveObjects().values()) {
                if (this.isHidden(object) || !ModuleOperations.assignableTo(object.getLogicalClass(), ofClass)) continue;
                this.yield(frame, block, object);
                ++count;
            }
            return count;
        }

        private boolean isHidden(RubyBasicObject object) {
            return object instanceof RubyClass && ((RubyClass)object).isSingleton();
        }
    }

    @CoreMethod(names={"_id2ref"}, isModuleFunction=true, required=1)
    public static abstract class ID2RefNode
    extends CoreMethodNode {
        public ID2RefNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ID2RefNode(ID2RefNode prev) {
            super(prev);
        }

        @Specialization
        public Object id2Ref(int id) {
            return this.id2Ref((long)id);
        }

        @Specialization
        public Object id2Ref(long id) {
            ID2RefNode.notDesignedForCompilation();
            if (id == 4L) {
                return this.nil();
            }
            if (id == 2L) {
                return true;
            }
            if (id == 0L) {
                return false;
            }
            if (ObjectIDOperations.isSmallFixnumID(id)) {
                return ObjectIDOperations.toFixnum(id);
            }
            RubyBasicObject object = this.getContext().getObjectSpaceManager().collectLiveObjects().get(id);
            if (object == null) {
                return this.nil();
            }
            return object;
        }

        @Specialization(guards={"isLargeFixnumID"})
        public Object id2RefLargeFixnum(RubyBignum id) {
            return ObjectIDOperations.toFixnum(id);
        }

        @Specialization(guards={"isFloatID"})
        public double id2RefFloat(RubyBignum id) {
            return ObjectIDOperations.toFloat(id);
        }

        protected boolean isLargeFixnumID(RubyBignum id) {
            return ObjectIDOperations.isLargeFixnumID(id.bigIntegerValue());
        }

        protected boolean isFloatID(RubyBignum id) {
            return ObjectIDOperations.isFloatID(id.bigIntegerValue());
        }
    }
}

