/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.ArrayList;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.coerce.SymbolOrToStrNode;
import org.jruby.truffle.nodes.coerce.SymbolOrToStrNodeFactory;
import org.jruby.truffle.nodes.coerce.ToStrNodeFactory;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.core.StringNodes;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.methods.SetMethodDeclarationContext;
import org.jruby.truffle.nodes.methods.arguments.CheckArityNode;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.objects.MetaClassNode;
import org.jruby.truffle.nodes.objects.MetaClassNodeFactory;
import org.jruby.truffle.nodes.objects.ReadInstanceVariableNode;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.nodes.objects.WriteInstanceVariableNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.IdUtil;

@CoreClass(name="Module")
public abstract class ModuleNodes {

    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="names")})
    public static abstract class SetVisibilityNode
    extends RubyNode {
        @Node.Child
        SymbolOrToStrNode symbolOrToStrNode;
        private final Visibility visibility;

        public SetVisibilityNode(RubyContext context, SourceSection sourceSection, Visibility visibility) {
            super(context, sourceSection);
            this.visibility = visibility;
            this.symbolOrToStrNode = SymbolOrToStrNodeFactory.create(context, sourceSection, null);
        }

        public SetVisibilityNode(SetVisibilityNode prev) {
            super(prev);
            this.visibility = prev.visibility;
            this.symbolOrToStrNode = prev.symbolOrToStrNode;
        }

        public abstract RubyModule executeSetVisibility(VirtualFrame var1, RubyModule var2, Object[] var3);

        @Specialization
        RubyModule setVisibility(VirtualFrame frame, RubyModule module, Object[] names) {
            SetVisibilityNode.notDesignedForCompilation();
            if (names.length == 0) {
                this.setCurrentVisibility(this.visibility);
            } else {
                for (Object name : names) {
                    String methodName = this.symbolOrToStrNode.executeToJavaString(frame, name);
                    this.setMethodVisibility(module, methodName);
                }
            }
            return module;
        }

        private void setMethodVisibility(RubyModule module, String methodName) {
            InternalMethod method = module.deepMethodSearch(methodName);
            if (method == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(methodName, module, this));
            }
            if (this.visibility == Visibility.MODULE_FUNCTION) {
                module.addMethod(this, method.withVisibility(Visibility.PRIVATE));
                module.getSingletonClass(this).addMethod(this, method.withVisibility(Visibility.PUBLIC));
            } else {
                module.addMethod(this, method.withVisibility(this.visibility));
            }
        }

        private void setCurrentVisibility(Visibility visibility) {
            SetVisibilityNode.notDesignedForCompilation();
            Frame callerFrame = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
            assert (callerFrame != null);
            assert (callerFrame.getFrameDescriptor() != null);
            FrameSlot visibilitySlot = callerFrame.getFrameDescriptor().findOrAddFrameSlot(RubyModule.VISIBILITY_FRAME_SLOT_ID, (Object)"visibility for frame", FrameSlotKind.Object);
            callerFrame.setObject(visibilitySlot, (Object)visibility);
        }
    }

    @CoreMethod(names={"undef_method"}, required=1)
    public static abstract class UndefMethodNode
    extends CoreMethodNode {
        public UndefMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UndefMethodNode(UndefMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule undefMethod(RubyModule module, RubyString name) {
            return this.undefMethod(module, name.toString());
        }

        @Specialization
        public RubyModule undefMethod(RubyModule module, RubySymbol name) {
            return this.undefMethod(module, name.toString());
        }

        private RubyModule undefMethod(RubyModule module, String name) {
            UndefMethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().noMethodErrorOnModule(name, module, this));
            }
            module.undefMethod((Node)this, method);
            return module;
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString toS(RubyModule module) {
            ToSNode.notDesignedForCompilation();
            return this.getContext().makeString(module.getName());
        }
    }

    @CoreMethod(names={"remove_method"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class RemoveMethodNode
    extends CoreMethodNode {
        public RemoveMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RemoveMethodNode(RemoveMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule removeMethod(RubyModule module, Object[] args) {
            RemoveMethodNode.notDesignedForCompilation();
            for (Object arg : args) {
                String name;
                if (arg instanceof RubySymbol) {
                    name = ((RubySymbol)arg).toString();
                } else if (arg instanceof RubyString) {
                    name = ((RubyString)arg).toString();
                } else {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().typeError(" is not a symbol", this));
                }
                module.removeMethod(this, name);
            }
            return module;
        }
    }

    @CoreMethod(names={"remove_const"}, required=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class RemoveConstNode
    extends RubyNode {
        public RemoveConstNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RemoveConstNode(RemoveConstNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        Object removeConstant(RubyModule module, String name) {
            RubyConstant oldConstant = module.removeConstant(this, name);
            if (oldConstant == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorConstantNotDefined(module, name, this));
            }
            return oldConstant.getValue();
        }
    }

    @CoreMethod(names={"remove_class_variable"}, required=1)
    public static abstract class RemoveClassVariableNode
    extends CoreMethodNode {
        public RemoveClassVariableNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RemoveClassVariableNode(RemoveClassVariableNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule removeClassVariable(RubyModule module, RubyString name) {
            RemoveClassVariableNode.notDesignedForCompilation();
            module.removeClassVariable(this, name.toString());
            return module;
        }

        @Specialization
        public RubyModule removeClassVariable(RubyModule module, RubySymbol name) {
            RemoveClassVariableNode.notDesignedForCompilation();
            module.removeClassVariable(this, name.toString());
            return module;
        }
    }

    @CoreMethod(names={"protected"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class ProtectedNode
    extends CoreMethodNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public ProtectedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeFactory.create(context, sourceSection, Visibility.PROTECTED, null, null);
        }

        public ProtectedNode(ProtectedNode prev) {
            super(prev);
            this.setVisibilityNode = prev.setVisibilityNode;
        }

        @Specialization
        public RubyModule doProtected(VirtualFrame frame, RubyModule module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"public_constant"}, argumentsAsArray=true)
    public static abstract class PublicConstantNode
    extends CoreMethodNode {
        public PublicConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicConstantNode(PublicConstantNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule publicConstant(RubyModule module, Object[] args) {
            PublicConstantNode.notDesignedForCompilation();
            for (Object name : args) {
                if (!(name instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                module.changeConstantVisibility(this, name.toString(), false);
            }
            return module;
        }
    }

    @CoreMethod(names={"private_constant"}, argumentsAsArray=true)
    public static abstract class PrivateConstantNode
    extends CoreMethodNode {
        public PrivateConstantNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateConstantNode(PrivateConstantNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule privateConstant(RubyModule module, Object[] args) {
            PrivateConstantNode.notDesignedForCompilation();
            for (Object name : args) {
                if (!(name instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                module.changeConstantVisibility(this, name.toString(), true);
            }
            return module;
        }
    }

    @CoreMethod(names={"instance_method"}, required=1)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class InstanceMethodNode
    extends RubyNode {
        public InstanceMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceMethodNode(InstanceMethodNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public RubyUnboundMethod instanceMethod(RubyModule module, String name) {
            InstanceMethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null || method.isUndefined()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(name, module, this));
            }
            return new RubyUnboundMethod(this.getContext().getCoreLibrary().getUnboundMethodClass(), module, method);
        }
    }

    @CoreMethod(names={"instance_methods"}, optional=1)
    public static abstract class InstanceMethodsNode
    extends CoreMethodNode {
        public InstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceMethodsNode(InstanceMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray instanceMethods(RubyModule module, UndefinedPlaceholder argument) {
            InstanceMethodsNode.notDesignedForCompilation();
            return this.instanceMethods(module, true);
        }

        @Specialization
        public RubyArray instanceMethods(RubyModule module, boolean includeAncestors) {
            InstanceMethodsNode.notDesignedForCompilation();
            Map<String, InternalMethod> methods = includeAncestors ? ModuleOperations.getAllMethods(module) : module.getMethods();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            for (InternalMethod method : methods.values()) {
                if (method.getVisibility() == Visibility.PRIVATE || method.isUndefined()) continue;
                array.slowPush(this.getContext().getSymbol(method.getName()));
            }
            return array;
        }
    }

    @CoreMethod(names={"public_method_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class PublicMethodDefinedNode
    extends RubyNode {
        public PublicMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicMethodDefinedNode(PublicMethodDefinedNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isPublicMethodDefined(RubyModule module, String name) {
            PublicMethodDefinedNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            return method != null && method.getVisibility() == Visibility.PUBLIC;
        }
    }

    @CoreMethod(names={"public_instance_methods"}, optional=1)
    public static abstract class PublicInstanceMethodsNode
    extends CoreMethodNode {
        public PublicInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicInstanceMethodsNode(PublicInstanceMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray publicInstanceMethods(RubyModule module, UndefinedPlaceholder argument) {
            return this.publicInstanceMethods(module, true);
        }

        @Specialization
        public RubyArray publicInstanceMethods(RubyModule module, boolean includeAncestors) {
            PublicInstanceMethodsNode.notDesignedForCompilation();
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), module.filterMethods(includeAncestors, new RubyModule.MethodFilter(){

                @Override
                public boolean filter(InternalMethod method) {
                    return method.getVisibility() == Visibility.PUBLIC;
                }
            }).toArray());
        }
    }

    @CoreMethod(names={"public_instance_method"}, required=1)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class PublicInstanceMethodNode
    extends RubyNode {
        public PublicInstanceMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicInstanceMethodNode(PublicInstanceMethodNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public RubyUnboundMethod publicInstanceMethod(RubyModule module, String name) {
            PublicInstanceMethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            if (method == null || method.isUndefined()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(name, module, this));
            }
            if (method.getVisibility() != Visibility.PUBLIC) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorPrivateMethod(name, module, this));
            }
            return new RubyUnboundMethod(this.getContext().getCoreLibrary().getUnboundMethodClass(), module, method);
        }
    }

    @CoreMethod(names={"private_instance_methods"}, optional=1)
    public static abstract class PrivateInstanceMethodsNode
    extends CoreMethodNode {
        public PrivateInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateInstanceMethodsNode(PrivateInstanceMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray privateInstanceMethods(RubyModule module, UndefinedPlaceholder argument) {
            return this.privateInstanceMethods(module, true);
        }

        @Specialization
        public RubyArray privateInstanceMethods(RubyModule module, boolean includeAncestors) {
            PrivateInstanceMethodsNode.notDesignedForCompilation();
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), module.filterMethods(includeAncestors, new RubyModule.MethodFilter(){

                @Override
                public boolean filter(InternalMethod method) {
                    return method.getVisibility() == Visibility.PRIVATE;
                }
            }).toArray());
        }
    }

    @CoreMethod(names={"protected_method_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class ProtectedMethodDefinedNode
    extends RubyNode {
        public ProtectedMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ProtectedMethodDefinedNode(ProtectedMethodDefinedNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isProtectedMethodDefined(RubyModule module, String name) {
            ProtectedMethodDefinedNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            return method != null && method.getVisibility().isProtected();
        }
    }

    @CoreMethod(names={"protected_instance_methods"}, optional=1)
    public static abstract class ProtectedInstanceMethodsNode
    extends CoreMethodNode {
        public ProtectedInstanceMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ProtectedInstanceMethodsNode(ProtectedInstanceMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray protectedInstanceMethods(RubyModule module, UndefinedPlaceholder argument) {
            return this.protectedInstanceMethods(module, true);
        }

        @Specialization
        public RubyArray protectedInstanceMethods(RubyModule module, boolean includeAncestors) {
            ProtectedInstanceMethodsNode.notDesignedForCompilation();
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), module.filterMethods(includeAncestors, new RubyModule.MethodFilter(){

                @Override
                public boolean filter(InternalMethod method) {
                    return method.getVisibility() == Visibility.PROTECTED;
                }
            }).toArray());
        }
    }

    @CoreMethod(names={"private_method_defined?"}, required=1)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class PrivateMethodDefinedNode
    extends RubyNode {
        public PrivateMethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateMethodDefinedNode(PrivateMethodDefinedNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isPrivateMethodDefined(RubyModule module, String name) {
            PrivateMethodDefinedNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(module, name);
            return method != null && method.getVisibility().isPrivate();
        }
    }

    @CoreMethod(names={"private_class_method"}, argumentsAsArray=true)
    public static abstract class PrivateClassMethodNode
    extends CoreMethodNode {
        public PrivateClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateClassMethodNode(PrivateClassMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule privateClassMethod(RubyModule module, Object ... args) {
            PrivateClassMethodNode.notDesignedForCompilation();
            RubyClass moduleSingleton = module.getSingletonClass(this);
            for (Object arg : args) {
                String methodName;
                if (arg instanceof RubySymbol) {
                    methodName = arg.toString();
                } else if (arg instanceof RubyString) {
                    methodName = ((RubyString)arg).toString();
                } else {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().typeError(" is not a symbol", this));
                }
                InternalMethod method = ModuleOperations.lookupMethod(moduleSingleton, methodName);
                if (method == null) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(methodName, module, this));
                }
                moduleSingleton.addMethod(this, method.withVisibility(Visibility.PRIVATE));
            }
            return module;
        }
    }

    @CoreMethod(names={"private"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class PrivateNode
    extends CoreMethodNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public PrivateNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeFactory.create(context, sourceSection, Visibility.PRIVATE, null, null);
        }

        public PrivateNode(PrivateNode prev) {
            super(prev);
            this.setVisibilityNode = prev.setVisibilityNode;
        }

        public abstract RubyModule executePrivate(VirtualFrame var1, RubyModule var2, Object[] var3);

        @Specialization
        public RubyModule doPrivate(VirtualFrame frame, RubyModule module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"public_class_method"}, argumentsAsArray=true)
    public static abstract class PublicClassMethodNode
    extends CoreMethodNode {
        public PublicClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicClassMethodNode(PublicClassMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule publicClassMethod(RubyModule module, Object ... args) {
            PublicClassMethodNode.notDesignedForCompilation();
            RubyClass moduleSingleton = module.getSingletonClass(this);
            for (Object arg : args) {
                if (!(arg instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                String methodName = arg.toString();
                InternalMethod method = ModuleOperations.lookupMethod(moduleSingleton, methodName);
                if (method == null) {
                    throw new RuntimeException("Couldn't find method " + arg.toString());
                }
                moduleSingleton.addMethod(this, method.withVisibility(Visibility.PUBLIC));
            }
            return module;
        }
    }

    @CoreMethod(names={"public"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class PublicNode
    extends CoreMethodNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public PublicNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeFactory.create(context, sourceSection, Visibility.PUBLIC, null, null);
        }

        public PublicNode(PublicNode prev) {
            super(prev);
            this.setVisibilityNode = prev.setVisibilityNode;
        }

        public abstract RubyModule executePublic(VirtualFrame var1, RubyModule var2, Object[] var3);

        @Specialization
        public RubyModule doPublic(VirtualFrame frame, RubyModule module, Object[] names) {
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"nesting"}, onSingleton=true)
    public static abstract class NestingNode
    extends CoreMethodNode {
        public NestingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NestingNode(NestingNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray nesting(VirtualFrame frame) {
            RubyModule enclosing;
            NestingNode.notDesignedForCompilation();
            ArrayList<RubyModule> modules = new ArrayList<RubyModule>();
            InternalMethod method = RubyCallStack.getCallingMethod(frame);
            RubyClass object = this.getContext().getCoreLibrary().getObjectClass();
            for (LexicalScope lexicalScope = method == null ? null : method.getSharedMethodInfo().getLexicalScope(); lexicalScope != null && (enclosing = lexicalScope.getLiveModule()) != object; lexicalScope = lexicalScope.getParent()) {
                modules.add(enclosing);
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), modules.toArray(new Object[modules.size()]));
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodNode {
        public NameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NameNode(NameNode prev) {
            super(prev);
        }

        @Specialization
        public Object name(RubyModule module) {
            NameNode.notDesignedForCompilation();
            if (!module.hasName()) {
                return this.nil();
            }
            return this.getContext().makeString(module.getName());
        }
    }

    @CoreMethod(names={"module_function"}, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class ModuleFunctionNode
    extends CoreMethodNode {
        @Node.Child
        SetVisibilityNode setVisibilityNode;

        public ModuleFunctionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.setVisibilityNode = ModuleNodesFactory.SetVisibilityNodeFactory.create(context, sourceSection, Visibility.MODULE_FUNCTION, null, null);
        }

        public ModuleFunctionNode(ModuleFunctionNode prev) {
            super(prev);
            this.setVisibilityNode = prev.setVisibilityNode;
        }

        @Specialization
        public RubyModule moduleFunction(VirtualFrame frame, RubyModule module, Object[] names) {
            if (module instanceof RubyClass && !this.getContext().getCoreLibrary().isLoadingRubyCore()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("module_function must be called for modules", this));
            }
            return this.setVisibilityNode.executeSetVisibility(frame, module, names);
        }
    }

    @CoreMethod(names={"method_defined?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name"), @NodeChild(value="inherit")})
    public static abstract class MethodDefinedNode
    extends RubyNode {
        public MethodDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MethodDefinedNode(MethodDefinedNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isMethodDefined(RubyModule module, String name, UndefinedPlaceholder inherit) {
            return this.isMethodDefined(module, name, true);
        }

        @Specialization
        public boolean isMethodDefined(RubyModule module, String name, boolean inherit) {
            MethodDefinedNode.notDesignedForCompilation();
            InternalMethod method = inherit ? ModuleOperations.lookupMethod(module, name) : module.getMethods().get(name);
            return method != null && !method.getVisibility().isPrivate();
        }
    }

    @CoreMethod(names={"included_modules"})
    public static abstract class IncludedModulesNode
    extends CoreMethodNode {
        public IncludedModulesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IncludedModulesNode(IncludedModulesNode prev) {
            super(prev);
        }

        @Specialization
        RubyArray includedModules(RubyModule module) {
            IncludedModulesNode.notDesignedForCompilation();
            ArrayList<RubyModule> modules = new ArrayList<RubyModule>();
            for (RubyModule included : module.parentAncestors()) {
                if (!included.isOnlyAModule()) continue;
                modules.add(included);
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), modules.toArray(new Object[modules.size()]));
        }
    }

    @CoreMethod(names={"included"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class IncludedNode
    extends CoreMethodNode {
        public IncludedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IncludedNode(IncludedNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass included(Object subclass) {
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization(guards={"!isRubyClass(arguments[0])", "!isRubyClass(arguments[1])"})
        public Object initializeCopy(RubyModule self, RubyModule from) {
            InitializeCopyNode.notDesignedForCompilation();
            self.initCopy(from);
            return this.nil();
        }

        @Specialization
        public Object initializeCopy(RubyClass self, RubyClass from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (from == this.getContext().getCoreLibrary().getBasicObjectClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't copy the root class", this));
            }
            if (from.isSingleton()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("can't copy singleton class", this));
            }
            self.initCopy(from);
            return this.nil();
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        @Node.Child
        private ClassExecNode classExecNode;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        public abstract RubyModule executeInitialize(VirtualFrame var1, RubyModule var2, RubyProc var3);

        void classEval(VirtualFrame frame, RubyModule module, RubyProc block) {
            if (this.classExecNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.classExecNode = (ClassExecNode)this.insert(ModuleNodesFactory.ClassExecNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            this.classExecNode.executeClassExec(frame, module, new Object[0], block);
        }

        @Specialization
        public RubyModule initialize(RubyModule module, UndefinedPlaceholder block) {
            return module;
        }

        @Specialization
        public RubyModule initialize(VirtualFrame frame, RubyModule module, RubyProc block) {
            this.classEval(frame, module, block);
            return module;
        }
    }

    @CoreMethod(names={"extend_object"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class ExtendObjectNode
    extends CoreMethodNode {
        public ExtendObjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExtendObjectNode(ExtendObjectNode prev) {
            super(prev);
        }

        @Specialization
        public RubyBasicObject extendObject(RubyModule module, RubyBasicObject object) {
            ExtendObjectNode.notDesignedForCompilation();
            if (module instanceof RubyClass) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeErrorWrongArgumentType(module, "Module", this));
            }
            object.getSingletonClass(this).include(this, module);
            return module;
        }
    }

    @CoreMethod(names={"define_method"}, needsBlock=true, required=1, optional=1, visibility=Visibility.PRIVATE)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name"), @NodeChild(value="proc"), @NodeChild(value="block")})
    public static abstract class DefineMethodNode
    extends RubyNode {
        public DefineMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DefineMethodNode(DefineMethodNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public RubySymbol defineMethod(RubyModule module, String name, UndefinedPlaceholder proc, UndefinedPlaceholder block) {
            DefineMethodNode.notDesignedForCompilation();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("needs either proc or block", this));
        }

        @Specialization
        public RubySymbol defineMethod(RubyModule module, String name, UndefinedPlaceholder proc, RubyProc block) {
            DefineMethodNode.notDesignedForCompilation();
            return this.defineMethod(module, name, block, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public RubySymbol defineMethod(RubyModule module, String name, RubyProc proc, UndefinedPlaceholder block) {
            return this.defineMethod(module, name, proc);
        }

        @Specialization
        public RubySymbol defineMethod(RubyModule module, String name, RubyMethod method, UndefinedPlaceholder block) {
            DefineMethodNode.notDesignedForCompilation();
            return this.addMethod(module, name, method.getMethod());
        }

        @Specialization
        public RubySymbol defineMethod(VirtualFrame frame, RubyModule module, String name, RubyUnboundMethod method, UndefinedPlaceholder block) {
            DefineMethodNode.notDesignedForCompilation();
            RubyModule origin = method.getOrigin();
            if (!ModuleOperations.canBindMethodTo(origin, module)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("bind argument must be a subclass of " + origin.getName(), this));
            }
            return this.addMethod(module, name, method.getMethod());
        }

        private RubySymbol defineMethod(RubyModule module, String name, RubyProc proc) {
            DefineMethodNode.notDesignedForCompilation();
            CallTarget modifiedCallTarget = proc.getCallTargetForMethods();
            SharedMethodInfo info = proc.getSharedMethodInfo().withName(name);
            InternalMethod modifiedMethod = new InternalMethod(info, name, module, Visibility.PUBLIC, false, modifiedCallTarget, proc.getDeclarationFrame());
            return this.addMethod(module, name, modifiedMethod);
        }

        private RubySymbol addMethod(RubyModule module, String name, InternalMethod method) {
            method = method.withName(name);
            if (ModuleOperations.isMethodPrivateFromName(name)) {
                method = method.withVisibility(Visibility.PRIVATE);
            }
            module.addMethod(this, method);
            return this.getContext().getSymbolTable().getSymbol(name);
        }
    }

    @CoreMethod(names={"const_set"}, required=2)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name"), @NodeChild(value="value")})
    public static abstract class ConstSetNode
    extends RubyNode {
        public ConstSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstSetNode(ConstSetNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public Object setConstant(RubyModule module, String name, Object value) {
            ConstSetNode.notDesignedForCompilation();
            if (!IdUtil.isValidConstantName19((String)name)) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("wrong constant name %s", name), name, this));
            }
            module.setConstant(this, name, value);
            return value;
        }
    }

    @CoreMethod(names={"const_missing"}, required=1)
    public static abstract class ConstMissingNode
    extends CoreMethodNode {
        public ConstMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstMissingNode(ConstMissingNode prev) {
            super(prev);
        }

        @Specialization
        public Object methodMissing(RubyModule module, RubySymbol name) {
            throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, name.toString(), this));
        }
    }

    @CoreMethod(names={"const_get"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name"), @NodeChild(value="inherit")})
    public static abstract class ConstGetNode
    extends RubyNode {
        @Node.Child
        private DispatchHeadNode dispatch;

        public ConstGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = new DispatchHeadNode(context, false, false, MissingBehavior.CALL_CONST_MISSING, null, DispatchAction.READ_CONSTANT);
        }

        public ConstGetNode(ConstGetNode prev) {
            super(prev);
            this.dispatch = prev.dispatch;
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization(guards={"!isScoped(name)"})
        public Object getConstant(VirtualFrame frame, RubyModule module, String name, UndefinedPlaceholder inherit) {
            return this.getConstant(frame, module, name, true);
        }

        @Specialization(guards={"isScoped(name)"})
        public Object getConstantScoped(VirtualFrame frame, RubyModule module, String name, UndefinedPlaceholder inherit) {
            return this.getConstantScoped(frame, module, name, true);
        }

        @Specialization(guards={"isTrue(inherit)", "!isScoped(name)"})
        public Object getConstant(VirtualFrame frame, RubyModule module, String name, boolean inherit) {
            return this.dispatch.dispatch(frame, module, name, null, new Object[0]);
        }

        @Specialization(guards={"!isTrue(inherit)", "!isScoped(name)"})
        public Object getConstantNoInherit(VirtualFrame frame, RubyModule module, String name, boolean inherit) {
            ConstGetNode.notDesignedForCompilation();
            RubyConstant constant = module.getConstants().get(name);
            if (constant == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, name, this));
            }
            return constant.getValue();
        }

        @Specialization(guards={"isScoped(name)"})
        public Object getConstantScoped(VirtualFrame frame, RubyModule module, String fullName, boolean inherit) {
            ConstGetNode.notDesignedForCompilation();
            Object fullNameObject = RubyArguments.getUserArgument(frame.getArguments(), 0);
            if (fullNameObject instanceof RubySymbol && !IdUtil.isValidConstantName19((String)fullName)) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("wrong constant name %s", fullName), fullName, this));
            }
            RubyConstant constant = ModuleOperations.lookupScopedConstant(this.getContext(), module, fullName, inherit, this);
            if (constant == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedConstant(module, fullName, this));
            }
            return constant.getValue();
        }

        boolean isScoped(String name) {
            return name.contains("::");
        }
    }

    @CoreMethod(names={"const_defined?"}, required=1, optional=1)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name"), @NodeChild(value="inherit")})
    public static abstract class ConstDefinedNode
    extends RubyNode {
        public ConstDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstDefinedNode(ConstDefinedNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public boolean isConstDefined(RubyModule module, String name, UndefinedPlaceholder inherit) {
            return this.isConstDefined(module, name, true);
        }

        @Specialization
        public boolean isConstDefined(RubyModule module, String fullName, boolean inherit) {
            ConstDefinedNode.notDesignedForCompilation();
            return ModuleOperations.lookupScopedConstant(this.getContext(), module, fullName, inherit, this) != null;
        }
    }

    @CoreMethod(names={"constants"}, optional=1)
    public static abstract class ConstantsNode
    extends CoreMethodNode {
        @Node.Child
        BooleanCastNode booleanCastNode;

        public ConstantsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstantsNode(ConstantsNode prev) {
            super(prev);
        }

        private boolean booleanCast(VirtualFrame frame, Object value) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.booleanCastNode.executeBoolean(frame, value);
        }

        @Specialization
        public RubyArray constants(RubyModule module, UndefinedPlaceholder inherit) {
            return this.constants(module, true);
        }

        @Specialization
        public RubyArray constants(RubyModule module, boolean inherit) {
            ConstantsNode.notDesignedForCompilation();
            ArrayList<RubySymbol> constantsArray = new ArrayList<RubySymbol>();
            Map<String, RubyConstant> constants = inherit ? ModuleOperations.getAllConstants(module) : module.getConstants();
            for (Map.Entry<String, RubyConstant> constant : constants.entrySet()) {
                if (constant.getValue().isPrivate()) continue;
                constantsArray.add(this.getContext().getSymbol(constant.getKey()));
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), constantsArray.toArray(new Object[constantsArray.size()]));
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[1])"})
        public RubyArray constants(VirtualFrame frame, RubyModule module, Object inherit) {
            return this.constants(module, this.booleanCast(frame, inherit));
        }
    }

    @CoreMethod(names={"class_variables"})
    public static abstract class ClassVariablesNode
    extends CoreMethodNode {
        public ClassVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClassVariablesNode(ClassVariablesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray getClassVariables(RubyModule module) {
            ClassVariablesNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(module.getContext().getCoreLibrary().getArrayClass());
            for (String variable : ModuleOperations.getAllClassVariables(module).keySet()) {
                array.slowPush(RubySymbol.newSymbol(module.getContext(), variable));
            }
            return array;
        }
    }

    @CoreMethod(names={"class_variable_get"}, required=1)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name")})
    public static abstract class ClassVariableGetNode
    extends RubyNode {
        public ClassVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClassVariableGetNode(ClassVariableGetNode prev) {
            super(prev);
        }

        @CreateCast(value={"name"})
        public RubyNode coerceToString(RubyNode name) {
            return SymbolOrToStrNodeFactory.create(this.getContext(), this.getSourceSection(), name);
        }

        @Specialization
        public Object getClassVariable(RubyModule module, String name) {
            ClassVariableGetNode.notDesignedForCompilation();
            RubyContext.checkClassVariableName(this.getContext(), name, this);
            Object value = ModuleOperations.lookupClassVariable(module, name);
            if (value == null) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUninitializedClassVariable(module, name, this));
            }
            return value;
        }
    }

    @CoreMethod(names={"class_variable_defined?"}, required=1)
    public static abstract class ClassVariableDefinedNode
    extends CoreMethodNode {
        public ClassVariableDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClassVariableDefinedNode(ClassVariableDefinedNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isClassVariableDefined(RubyModule module, RubyString name) {
            ClassVariableDefinedNode.notDesignedForCompilation();
            return module.getClassVariables().containsKey(name.toString());
        }

        @Specialization
        public boolean isClassVariableDefined(RubyModule module, RubySymbol name) {
            ClassVariableDefinedNode.notDesignedForCompilation();
            return module.getClassVariables().containsKey(name.toString());
        }
    }

    @CoreMethod(names={"class_exec", "module_exec"}, argumentsAsArray=true, needsBlock=true)
    public static abstract class ClassExecNode
    extends CoreMethodNode {
        @Node.Child
        private YieldDispatchHeadNode yield;

        public ClassExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context);
        }

        public ClassExecNode(ClassExecNode prev) {
            super(prev);
            this.yield = prev.yield;
        }

        public abstract Object executeClassExec(VirtualFrame var1, RubyModule var2, Object[] var3, RubyProc var4);

        @Specialization
        public Object classExec(VirtualFrame frame, RubyModule self, Object[] args, RubyProc block) {
            ClassExecNode.notDesignedForCompilation();
            return this.yield.dispatchWithModifiedSelf(frame, block, self, new Object[0]);
        }
    }

    @CoreMethod(names={"class_eval", "module_eval"}, optional=3, needsBlock=true)
    public static abstract class ClassEvalNode
    extends CoreMethodNode {
        @Node.Child
        private YieldDispatchHeadNode yield;
        @Node.Child
        private KernelNodes.BindingNode bindingNode;

        public ClassEvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context);
        }

        public ClassEvalNode(ClassEvalNode prev) {
            super(prev);
            this.yield = prev.yield;
        }

        protected RubyBinding getCallerBinding(VirtualFrame frame) {
            if (this.bindingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bindingNode = (KernelNodes.BindingNode)this.insert(KernelNodesFactory.BindingNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            return this.bindingNode.executeRubyBinding(frame);
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, UndefinedPlaceholder file, UndefinedPlaceholder line, UndefinedPlaceholder block) {
            ClassEvalNode.notDesignedForCompilation();
            Source source = Source.fromText((CharSequence)code.toString(), (String)"(eval)");
            return this.classEvalSource(frame, module, source, code.getBytes().getEncoding());
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, RubyString file, UndefinedPlaceholder line, UndefinedPlaceholder block) {
            ClassEvalNode.notDesignedForCompilation();
            Source source = Source.asPseudoFile((CharSequence)code.toString(), (String)file.toString());
            return this.classEvalSource(frame, module, source, code.getBytes().getEncoding());
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule module, RubyString code, RubyString file, int line, UndefinedPlaceholder block) {
            ClassEvalNode.notDesignedForCompilation();
            Source source = Source.asPseudoFile((CharSequence)code.toString(), (String)file.toString());
            return this.classEvalSource(frame, module, source, code.getBytes().getEncoding());
        }

        private Object classEvalSource(VirtualFrame frame, RubyModule module, Source source, Encoding encoding) {
            RubyBinding binding = this.getCallerBinding(frame);
            return this.getContext().execute(source, encoding, TranslatorDriver.ParserContext.MODULE, module, binding.getFrame(), this, new NodeWrapper(){

                @Override
                public RubyNode wrap(RubyNode node) {
                    return new SetMethodDeclarationContext(node.getContext(), node.getSourceSection(), Visibility.PUBLIC, "class_eval", node);
                }
            });
        }

        @Specialization
        public Object classEval(VirtualFrame frame, RubyModule self, UndefinedPlaceholder code, UndefinedPlaceholder file, UndefinedPlaceholder line, RubyProc block) {
            ClassEvalNode.notDesignedForCompilation();
            return this.yield.dispatchWithModifiedSelf(frame, block, self, new Object[0]);
        }

        @Specialization
        public Object classEval(RubyModule self, UndefinedPlaceholder code, UndefinedPlaceholder file, UndefinedPlaceholder line, UndefinedPlaceholder block) {
            ClassEvalNode.notDesignedForCompilation();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError(0, 1, 2, this));
        }
    }

    @CoreMethod(names={"autoload?"}, required=1)
    public static abstract class AutoloadQueryNode
    extends CoreMethodNode {
        public AutoloadQueryNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AutoloadQueryNode(AutoloadQueryNode prev) {
            super(prev);
        }

        @Specialization
        public Object autoloadQuery(RubyModule module, RubySymbol name) {
            return this.autoloadQuery(module, name.toString());
        }

        @Specialization
        public Object autoloadQuery(RubyModule module, RubyString name) {
            return this.autoloadQuery(module, name.toString());
        }

        private Object autoloadQuery(RubyModule module, String name) {
            RubyConstant constant = ModuleOperations.lookupConstant(this.getContext(), LexicalScope.NONE, module, name);
            if (constant == null || !constant.isAutoload()) {
                return this.nil();
            }
            return constant.getValue();
        }
    }

    @CoreMethod(names={"autoload"}, required=2)
    @NodeChildren(value={@NodeChild(value="module"), @NodeChild(value="name"), @NodeChild(value="filename")})
    public static abstract class AutoloadNode
    extends RubyNode {
        @Node.Child
        private StringNodes.EmptyNode emptyNode;
        private final ConditionProfile invalidConstantName = ConditionProfile.createBinaryProfile();
        private final ConditionProfile emptyFilename = ConditionProfile.createBinaryProfile();

        public AutoloadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.emptyNode = StringNodesFactory.EmptyNodeFactory.create(context, sourceSection, new RubyNode[0]);
        }

        public AutoloadNode(AutoloadNode prev) {
            super(prev);
            this.emptyNode = prev.emptyNode;
        }

        @CreateCast(value={"filename"})
        public RubyNode coerceFilenameToString(RubyNode filename) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), filename);
        }

        @Specialization
        public RubyNilClass autoload(RubyModule module, RubySymbol name, RubyString filename) {
            return this.autoload(module, name.toString(), filename);
        }

        @Specialization
        public RubyNilClass autoload(RubyModule module, RubyString name, RubyString filename) {
            return this.autoload(module, name.toString(), filename);
        }

        private RubyNilClass autoload(RubyModule module, String name, RubyString filename) {
            if (this.invalidConstantName.profile(!IdUtil.isValidConstantName19((String)name))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().nameError(String.format("autoload must be constant name: %s", name), name, this));
            }
            if (this.emptyFilename.profile(this.emptyNode.empty(filename))) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("empty file name", this));
            }
            module.setAutoloadConstant(this, name, filename);
            return this.nil();
        }
    }

    @CoreMethod(names={"attr_accessor", "attr"}, argumentsAsArray=true)
    public static abstract class AttrAccessorNode
    extends CoreMethodNode {
        public AttrAccessorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AttrAccessorNode(AttrAccessorNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass attrAccessor(RubyModule module, Object[] args) {
            AttrAccessorNode.notDesignedForCompilation();
            SourceSection sourceSection = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection();
            for (Object arg : args) {
                String accessorName;
                if (arg instanceof RubySymbol) {
                    accessorName = ((RubySymbol)arg).toString();
                } else if (arg instanceof RubyString) {
                    accessorName = ((RubyString)arg).toString();
                } else {
                    throw new RaiseException(this.getContext().getCoreLibrary().typeError(" is not a symbol or string", this));
                }
                AttrAccessorNode.attrAccessor(this, this.getContext(), sourceSection, module, accessorName);
            }
            return this.nil();
        }

        public static void attrAccessor(Node currentNode, RubyContext context, SourceSection sourceSection, RubyModule module, String name) {
            CompilerDirectives.transferToInterpreter();
            AttrReaderNode.attrReader(currentNode, context, sourceSection, module, name);
            AttrWriterNode.attrWriter(currentNode, context, sourceSection, module, name);
        }
    }

    @CoreMethod(names={"attr_writer"}, argumentsAsArray=true)
    public static abstract class AttrWriterNode
    extends CoreMethodNode {
        public AttrWriterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AttrWriterNode(AttrWriterNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass attrWriter(RubyModule module, Object[] args) {
            AttrWriterNode.notDesignedForCompilation();
            SourceSection sourceSection = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection();
            for (Object arg : args) {
                if (!(arg instanceof RubySymbol)) {
                    throw new UnsupportedOperationException();
                }
                String accessorName = ((RubySymbol)arg).toString();
                AttrWriterNode.attrWriter(this, this.getContext(), sourceSection, module, accessorName);
            }
            return this.nil();
        }

        public static void attrWriter(Node currentNode, RubyContext context, SourceSection sourceSection, RubyModule module, String name) {
            CompilerDirectives.transferToInterpreter();
            CheckArityNode checkArity = new CheckArityNode(context, sourceSection, new Arity(1, 0, false, false, false, 0));
            SelfNode self = new SelfNode(context, sourceSection);
            ReadPreArgumentNode readArgument = new ReadPreArgumentNode(context, sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR);
            WriteInstanceVariableNode writeInstanceVariable = new WriteInstanceVariableNode(context, sourceSection, "@" + name, self, readArgument, false);
            RubyNode block = SequenceNode.sequence(context, sourceSection, checkArity, writeInstanceVariable);
            String indicativeName = name + "(attr_writer)";
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, Arity.ONE_REQUIRED, indicativeName, false, null, false);
            RubyRootNode rootNode = new RubyRootNode(context, sourceSection, null, sharedMethodInfo, block);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
            InternalMethod method = new InternalMethod(sharedMethodInfo, name + "=", module, Visibility.PUBLIC, false, (CallTarget)callTarget, null);
            module.addMethod(currentNode, method);
        }
    }

    @CoreMethod(names={"attr_reader"}, argumentsAsArray=true)
    public static abstract class AttrReaderNode
    extends CoreMethodNode {
        public AttrReaderNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AttrReaderNode(AttrReaderNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass attrReader(RubyModule module, Object[] args) {
            AttrReaderNode.notDesignedForCompilation();
            SourceSection sourceSection = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection();
            for (Object arg : args) {
                String accessorName;
                if (arg instanceof RubySymbol) {
                    accessorName = ((RubySymbol)arg).toString();
                } else if (arg instanceof RubyString) {
                    accessorName = ((RubyString)arg).toString();
                } else {
                    throw new UnsupportedOperationException();
                }
                AttrReaderNode.attrReader(this, this.getContext(), sourceSection, module, accessorName);
            }
            return this.nil();
        }

        public static void attrReader(Node currentNode, RubyContext context, SourceSection sourceSection, RubyModule module, String name) {
            CompilerDirectives.transferToInterpreter();
            CheckArityNode checkArity = new CheckArityNode(context, sourceSection, new Arity(0, 0, false, false, false, 0));
            SelfNode self = new SelfNode(context, sourceSection);
            ReadInstanceVariableNode readInstanceVariable = new ReadInstanceVariableNode(context, sourceSection, "@" + name, self, false);
            RubyNode block = SequenceNode.sequence(context, sourceSection, checkArity, readInstanceVariable);
            String indicativeName = name + "(attr_reader)";
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, Arity.NO_ARGUMENTS, indicativeName, false, null, false);
            RubyRootNode rootNode = new RubyRootNode(context, sourceSection, null, sharedMethodInfo, block);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget((RootNode)rootNode);
            InternalMethod method = new InternalMethod(sharedMethodInfo, name, module, Visibility.PUBLIC, false, (CallTarget)callTarget, null);
            module.addMethod(currentNode, method);
        }
    }

    @CoreMethod(names={"append_features"}, required=1, visibility=Visibility.PRIVATE)
    public static abstract class AppendFeaturesNode
    extends CoreMethodNode {
        public AppendFeaturesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AppendFeaturesNode(AppendFeaturesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass appendFeatures(RubyModule module, RubyModule other) {
            AppendFeaturesNode.notDesignedForCompilation();
            module.appendFeatures(this, other);
            return this.nil();
        }
    }

    @CoreMethod(names={"ancestors"})
    public static abstract class AncestorsNode
    extends CoreMethodNode {
        public AncestorsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AncestorsNode(AncestorsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray ancestors(RubyModule self) {
            AncestorsNode.notDesignedForCompilation();
            ArrayList<RubyModule> ancestors = new ArrayList<RubyModule>();
            for (RubyModule module : self.ancestors()) {
                ancestors.add(module);
            }
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), ancestors.toArray(new Object[ancestors.size()]));
        }
    }

    @CoreMethod(names={"alias_method"}, required=2)
    public static abstract class AliasMethodNode
    extends CoreMethodNode {
        public AliasMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AliasMethodNode(AliasMethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule aliasMethod(RubyModule module, RubySymbol newName, RubySymbol oldName) {
            AliasMethodNode.notDesignedForCompilation();
            module.alias(this, newName.toString(), oldName.toString());
            return module;
        }

        @Specialization
        public RubyModule aliasMethod(RubyModule module, RubyString newName, RubyString oldName) {
            AliasMethodNode.notDesignedForCompilation();
            module.alias(this, newName.toString(), oldName.toString());
            return module;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        @Node.Child
        private IsSubclassOfOrEqualToNode subclassNode;
        @Node.Child
        private BooleanCastNode booleanCastNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        private Object isSubclass(VirtualFrame frame, RubyModule self, RubyModule other) {
            if (this.subclassNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.subclassNode = (IsSubclassOfOrEqualToNode)this.insert(ModuleNodesFactory.IsSubclassOfOrEqualToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.subclassNode.executeIsSubclassOfOrEqualTo(frame, self, other);
        }

        private boolean booleanCast(VirtualFrame frame, Object value) {
            if (this.booleanCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.booleanCastNode = (BooleanCastNode)this.insert(BooleanCastNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.booleanCastNode.executeBoolean(frame, value);
        }

        @Specialization
        public Object compare(VirtualFrame frame, RubyModule self, RubyModule other) {
            CompareNode.notDesignedForCompilation();
            if (self == other) {
                return 0;
            }
            Object isSubclass = this.isSubclass(frame, self, other);
            if (isSubclass instanceof RubyNilClass) {
                return this.nil();
            }
            if (this.booleanCast(frame, isSubclass)) {
                return -1;
            }
            return 1;
        }

        @Specialization
        public Object compare(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            CompareNode.notDesignedForCompilation();
            return this.nil();
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class IsSuperclassOfOrEqualToNode
    extends CoreMethodNode {
        public IsSuperclassOfOrEqualToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IsSuperclassOfOrEqualToNode(IsSuperclassOfOrEqualToNode prev) {
            super(prev);
        }

        public abstract Object executeIsSuperclassOfOrEqualTo(VirtualFrame var1, RubyModule var2, RubyModule var3);

        @Specialization
        public Object isSuperclassOfOrEqualTo(VirtualFrame frame, RubyModule self, RubyModule other) {
            IsSuperclassOfOrEqualToNode.notDesignedForCompilation();
            if (self == other || ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return this.nil();
        }

        @Specialization
        public Object isSuperclassOfOrEqualTo(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            IsSuperclassOfOrEqualToNode.notDesignedForCompilation();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class IsSuperclassOfNode
    extends CoreMethodNode {
        public IsSuperclassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IsSuperclassOfNode(IsSuperclassOfNode prev) {
            super(prev);
        }

        public abstract Object executeIsSuperclassOf(VirtualFrame var1, RubyModule var2, RubyModule var3);

        @Specialization
        public Object isSuperclassOf(VirtualFrame frame, RubyModule self, RubyModule other) {
            IsSuperclassOfNode.notDesignedForCompilation();
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return true;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return false;
            }
            return this.nil();
        }

        @Specialization
        public Object isSuperclassOf(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            IsSuperclassOfNode.notDesignedForCompilation();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class IsSubclassOfOrEqualToNode
    extends CoreMethodNode {
        public IsSubclassOfOrEqualToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IsSubclassOfOrEqualToNode(IsSubclassOfOrEqualToNode prev) {
            super(prev);
        }

        public abstract Object executeIsSubclassOfOrEqualTo(VirtualFrame var1, RubyModule var2, RubyModule var3);

        @Specialization
        public Object isSubclassOfOrEqualTo(VirtualFrame frame, RubyModule self, RubyModule other) {
            IsSubclassOfOrEqualToNode.notDesignedForCompilation();
            if (self == other || ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return this.nil();
        }

        @Specialization
        public Object isSubclassOfOrEqualTo(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            IsSubclassOfOrEqualToNode.notDesignedForCompilation();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class IsSubclassOfNode
    extends CoreMethodNode {
        public IsSubclassOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IsSubclassOfNode(IsSubclassOfNode prev) {
            super(prev);
        }

        public abstract Object executeIsSubclassOf(VirtualFrame var1, RubyModule var2, RubyModule var3);

        @Specialization
        public Object isSubclassOf(VirtualFrame frame, RubyModule self, RubyModule other) {
            IsSubclassOfNode.notDesignedForCompilation();
            if (self == other) {
                return false;
            }
            if (ModuleOperations.includesModule(self, other)) {
                return true;
            }
            if (ModuleOperations.includesModule(other, self)) {
                return false;
            }
            return this.nil();
        }

        @Specialization
        public Object isSubclassOf(VirtualFrame frame, RubyModule self, RubyBasicObject other) {
            IsSubclassOfNode.notDesignedForCompilation();
            throw new RaiseException(this.getContext().getCoreLibrary().typeError("compared with non class/module", this));
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class ContainsInstanceNode
    extends CoreMethodNode {
        @Node.Child
        private MetaClassNode metaClassNode;

        public ContainsInstanceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.metaClassNode = MetaClassNodeFactory.create(context, sourceSection, null);
        }

        public ContainsInstanceNode(ContainsInstanceNode prev) {
            super(prev);
            this.metaClassNode = prev.metaClassNode;
        }

        @Specialization
        public boolean containsInstance(RubyModule module, RubyBasicObject instance) {
            return this.includes(instance.getMetaClass(), module);
        }

        @Specialization(guards={"!isRubyBasicObject(arguments[1])"})
        public boolean containsInstance(VirtualFrame frame, RubyModule module, Object instance) {
            return this.includes(this.metaClassNode.executeMetaClass(frame, instance), module);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean includes(RubyModule metaClass, RubyModule module) {
            return ModuleOperations.includesModule(metaClass, module);
        }
    }
}

