/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.NullSourceSection;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.objects.ClassNode;
import org.jruby.truffle.nodes.objects.ClassNodeFactory;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;
import org.jruby.truffle.runtime.methods.InternalMethod;

@CoreClass(name="Method")
public abstract class MethodNodes {

    @CoreMethod(names={"to_proc"})
    public static abstract class ToProcNode
    extends CoreMethodNode {
        public ToProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToProcNode(ToProcNode prev) {
            super(prev);
        }

        @Specialization
        public RubyProc toProc(RubyMethod method) {
            return new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.LAMBDA, method.getMethod().getSharedMethodInfo(), method.getMethod().getCallTarget(), method.getMethod().getCallTarget(), method.getMethod().getCallTarget(), method.getMethod().getDeclarationFrame(), method.getMethod(), method.getReceiver(), null);
        }
    }

    @CoreMethod(names={"unbind"})
    public static abstract class UnbindNode
    extends CoreMethodNode {
        @Node.Child
        private ClassNode classNode;

        public UnbindNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeFactory.create(context, sourceSection, null);
        }

        public UnbindNode(UnbindNode prev) {
            super(prev);
            this.classNode = prev.classNode;
        }

        @Specialization
        public RubyUnboundMethod unbind(RubyMethod method) {
            UnbindNode.notDesignedForCompilation();
            RubyClass receiverClass = this.classNode.executeGetClass(method.getReceiver());
            return new RubyUnboundMethod(this.getContext().getCoreLibrary().getUnboundMethodClass(), (RubyModule)receiverClass, method.getMethod());
        }
    }

    @CoreMethod(names={"source_location"})
    public static abstract class SourceLocationNode
    extends CoreMethodNode {
        public SourceLocationNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SourceLocationNode(SourceLocationNode prev) {
            super(prev);
        }

        @Specialization
        public Object sourceLocation(RubyMethod method) {
            SourceLocationNode.notDesignedForCompilation();
            SourceSection sourceSection = method.getMethod().getSharedMethodInfo().getSourceSection();
            if (sourceSection instanceof NullSourceSection) {
                return this.nil();
            }
            RubyString file = this.getContext().makeString(sourceSection.getSource().getName());
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), file, sourceSection.getStartLine());
        }
    }

    @CoreMethod(names={"receiver"})
    public static abstract class ReceiverNode
    extends CoreMethodNode {
        public ReceiverNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReceiverNode(ReceiverNode prev) {
            super(prev);
        }

        @Specialization
        public Object receiver(RubyMethod method) {
            return method.getReceiver();
        }
    }

    @CoreMethod(names={"owner"})
    public static abstract class OwnerNode
    extends CoreMethodNode {
        public OwnerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public OwnerNode(OwnerNode prev) {
            super(prev);
        }

        @Specialization
        public RubyModule owner(RubyMethod method) {
            return method.getMethod().getDeclaringModule();
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class NameNode
    extends CoreMethodNode {
        public NameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NameNode(NameNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol name(RubyMethod method) {
            NameNode.notDesignedForCompilation();
            return this.getContext().getSymbol(method.getMethod().getName());
        }
    }

    @CoreMethod(names={"call"}, needsBlock=true, argumentsAsArray=true)
    public static abstract class CallNode
    extends CoreMethodNode {
        @Node.Child
        private IndirectCallNode callNode;

        public CallNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.callNode = Truffle.getRuntime().createIndirectCallNode();
        }

        public CallNode(CallNode prev) {
            super(prev);
            this.callNode = prev.callNode;
        }

        @Specialization
        public Object call(VirtualFrame frame, RubyMethod method, Object[] arguments, UndefinedPlaceholder block) {
            return this.doCall(frame, method, arguments, null);
        }

        @Specialization
        public Object doCall(VirtualFrame frame, RubyMethod method, Object[] arguments, RubyProc block) {
            InternalMethod internalMethod = method.getMethod();
            return this.callNode.call(frame, method.getMethod().getCallTarget(), RubyArguments.pack(internalMethod, internalMethod.getDeclarationFrame(), method.getReceiver(), block, arguments));
        }
    }

    @CoreMethod(names={"arity"})
    public static abstract class ArityNode
    extends CoreMethodNode {
        public ArityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ArityNode(ArityNode prev) {
            super(prev);
        }

        @Specialization
        public int arity(RubyMethod method) {
            return method.getMethod().getSharedMethodInfo().getArity().getArityNumber();
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        @Node.Child
        protected BasicObjectNodes.ReferenceEqualNode referenceEqualNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        protected boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        @Specialization
        public boolean equal(VirtualFrame frame, RubyMethod a, RubyMethod b) {
            return this.areSame(frame, a.getReceiver(), b.getReceiver()) && a.getMethod() == b.getMethod();
        }

        @Specialization(guards={"!isRubyMethod(arguments[1])"})
        public boolean equal(RubyMethod a, Object b) {
            return false;
        }
    }
}

