/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=KernelNodes.class)
public final class KernelNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(BacktickNodeFactory.getInstance(), SameOrEqualNodeFactory.getInstance(), MatchNodeFactory.getInstance(), NotMatchNodeFactory.getInstance(), CompareNodeFactory.getInstance(), AbortNodeFactory.getInstance(), AtExitNodeFactory.getInstance(), BindingNodeFactory.getInstance(), BlockGivenNodeFactory.getInstance(), CalleeNameNodeFactory.getInstance(), CallerNodeFactory.getInstance(), KernelClassNodeFactory.getInstance(), CopyNodeFactory.getInstance(), CloneNodeFactory.getInstance(), DupNodeFactory.getInstance(), EvalNodeFactory.getInstance(), ExecNodeFactory.getInstance(), ExitNodeFactory.getInstance(), ExitBangNodeFactory.getInstance(), ForkNodeFactory.getInstance(), KernelFreezeNodeFactory.getInstance(), KernelFrozenNodeFactory.getInstance(), GetsNodeFactory.getInstance(), HashNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InitializeDupCloneNodeFactory.getInstance(), InstanceOfNodeFactory.getInstance(), InstanceVariableDefinedNodeFactory.getInstance(), InstanceVariableGetNodeFactory.getInstance(), InstanceVariableSetNodeFactory.getInstance(), InstanceVariablesNodeFactory.getInstance(), IsANodeFactory.getInstance(), LambdaNodeFactory.getInstance(), LoadNodeFactory.getInstance(), LocalVariablesNodeFactory.getInstance(), MethodNameNodeFactory.getInstance(), MethodNodeFactory.getInstance(), MethodsNodeFactory.getInstance(), NilNodeFactory.getInstance(), PrivateMethodsNodeFactory.getInstance(), ProcNodeFactory.getInstance(), PublicMethodsNodeFactory.getInstance(), RandNodeFactory.getInstance(), RequireNodeFactory.getInstance(), RequireRelativeNodeFactory.getInstance(), RespondToNodeFactory.getInstance(), RespondToMissingNodeFactory.getInstance(), SetTraceFuncNodeFactory.getInstance(), SingletonClassMethodNodeFactory.getInstance(), SingletonMethodsNodeFactory.getInstance(), StringNodeFactory.getInstance(), SleepNodeFactory.getInstance(), SPrintfNodeFactory.getInstance(), SystemNodeFactory.getInstance(), KernelTaintNodeFactory.getInstance(), KernelIsTaintedNodeFactory.getInstance(), ToHexStringNodeFactory.getInstance(), ToSNodeFactory.getInstance(), UntaintNodeFactory.getInstance());
    }

    @GeneratedBy(value=KernelNodes.UntaintNode.class)
    public static final class UntaintNodeFactory
    extends NodeFactoryBase<KernelNodes.UntaintNode> {
        private static UntaintNodeFactory untaintNodeFactoryInstance;

        private UntaintNodeFactory() {
            super(KernelNodes.UntaintNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.UntaintNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UntaintNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.UntaintNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UntaintUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.UntaintNode> getInstance() {
            if (untaintNodeFactoryInstance == null) {
                untaintNodeFactoryInstance = new UntaintNodeFactory();
            }
            return untaintNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UntaintPolymorphicNode
        extends UntaintBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            UntaintPolymorphicNode(UntaintBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[0].executeBoolean(frameValue)) : (this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBasicObject.class ? this.arguments[0].executeRubyBasicObject(frameValue) : this.arguments[0].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UntaintRubyBasicObjectNode
        extends UntaintBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UntaintRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            UntaintRubyBasicObjectNode(UntaintBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBasicObject");
                }
                return super.taint(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    return super.taint(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.UntaintNode create0(KernelNodes.UntaintNode current) {
                return new UntaintRubyBasicObjectNode((UntaintBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UntaintDoubleNode
        extends UntaintBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UntaintDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            UntaintDoubleNode(UntaintBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.taint(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.taint(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.UntaintNode create0(KernelNodes.UntaintNode current) {
                return new UntaintDoubleNode((UntaintBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UntaintLongNode
        extends UntaintBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UntaintLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            UntaintLongNode(UntaintBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.taint(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.taint(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.UntaintNode create0(KernelNodes.UntaintNode current) {
                return new UntaintLongNode((UntaintBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UntaintIntNode
        extends UntaintBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UntaintIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            UntaintIntNode(UntaintBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.taint(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.taint(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.UntaintNode create0(KernelNodes.UntaintNode current) {
                return new UntaintIntNode((UntaintBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UntaintBooleanNode
        extends UntaintBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UntaintBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

            UntaintBooleanNode(UntaintBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof boolean");
                }
                return super.taint(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(arguments0Value)) {
                    boolean arguments0ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments0Value);
                    return super.taint(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.UntaintNode create0(KernelNodes.UntaintNode current) {
                return new UntaintBooleanNode((UntaintBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UntaintUninitializedNode
        extends UntaintBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UntaintUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UntaintUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UntaintUninitializedNode(UntaintBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                UntaintBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UntaintBaseNode rootNode = (UntaintBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UntaintBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.UntaintNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UntaintUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.UntaintNode.class)
        private static abstract class UntaintBaseNode
        extends KernelNodes.UntaintNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UntaintBaseNode next0;

            UntaintBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UntaintBaseNode(UntaintBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                UntaintBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UntaintBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new UntaintUninitializedNode(this);
                    ((UntaintUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UntaintBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UntaintBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (UntaintBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UntaintUninitializedNode(this), (Node)new UntaintPolymorphicNode(this), (DSLNode)((UntaintBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UntaintBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(arguments0Value)) {
                    return (UntaintBaseNode)UntaintBooleanNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (UntaintBaseNode)UntaintIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (UntaintBaseNode)UntaintLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (UntaintBaseNode)UntaintDoubleNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    return (UntaintBaseNode)UntaintRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UntaintBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (UntaintBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<KernelNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(KernelNodes.ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ToSNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToSObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.ToSNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToSObjectNode
        extends ToSBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToSObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            ToSObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.toS(frameValue, arguments0Value);
            }

            @Override
            public RubyString executeToS(VirtualFrame frameValue, Object arguments0ValueEvaluated) {
                Object arguments0Value = arguments0ValueEvaluated;
                return super.toS(frameValue, arguments0Value);
            }

            static KernelNodes.ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToSObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.ToSNode.class)
        private static abstract class ToSBaseNode
        extends KernelNodes.ToSNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToSBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
    public static final class ToHexStringNodeFactory
    extends NodeFactoryBase<KernelNodes.ToHexStringNode> {
        private static ToHexStringNodeFactory toHexStringNodeFactoryInstance;

        private ToHexStringNodeFactory() {
            super(KernelNodes.ToHexStringNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ToHexStringNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToHexStringNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.ToHexStringNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToHexStringUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.ToHexStringNode> getInstance() {
            if (toHexStringNodeFactoryInstance == null) {
                toHexStringNodeFactoryInstance = new ToHexStringNodeFactory();
            }
            return toHexStringNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToHexStringPolymorphicNode
        extends ToHexStringBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToHexStringPolymorphicNode(ToHexStringBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String value;
                try {
                    value = this.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == RubyBignum.class ? this.arguments[0].executeBignum(frameValue) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public String executeToHexString(VirtualFrame frameValue, Object arguments0ValueEvaluated) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(arguments0ValueEvaluated)) : (this.arguments0PolymorphicType == RubyBignum.class ? RubyTypesGen.RUBYTYPES.expectRubyBignum(arguments0ValueEvaluated) : arguments0ValueEvaluated));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected String executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToHexStringRubyBignumNode
        extends ToHexStringBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToHexStringRubyBignumNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBignum.class}, 0, 0);

            ToHexStringRubyBignumNode(ToHexStringBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String value;
                try {
                    value = this.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBignum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.toHexString(arguments0Value);
            }

            @Override
            public String executeToHexString(VirtualFrame frameValue, Object arguments0ValueEvaluated) {
                RubyBignum arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectRubyBignum(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBignum");
                }
                return super.toHexString(arguments0Value);
            }

            @Override
            protected String executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    RubyBignum arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBignum(arguments0Value);
                    return super.toHexString(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ToHexStringNode create0(KernelNodes.ToHexStringNode current) {
                return new ToHexStringRubyBignumNode((ToHexStringBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToHexStringLongNode
        extends ToHexStringBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToHexStringLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            ToHexStringLongNode(ToHexStringBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String value;
                try {
                    value = this.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.toHexString(arguments0Value);
            }

            @Override
            public String executeToHexString(VirtualFrame frameValue, Object arguments0ValueEvaluated) {
                long arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectLong(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.toHexString(arguments0Value);
            }

            @Override
            protected String executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.toHexString(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ToHexStringNode create0(KernelNodes.ToHexStringNode current) {
                return new ToHexStringLongNode((ToHexStringBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToHexStringIntNode
        extends ToHexStringBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToHexStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ToHexStringIntNode(ToHexStringBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String value;
                try {
                    value = this.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.toHexString(arguments0Value);
            }

            @Override
            public String executeToHexString(VirtualFrame frameValue, Object arguments0ValueEvaluated) {
                int arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.toHexString(arguments0Value);
            }

            @Override
            protected String executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.toHexString(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ToHexStringNode create0(KernelNodes.ToHexStringNode current) {
                return new ToHexStringIntNode((ToHexStringBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToHexStringUninitializedNode
        extends ToHexStringBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToHexStringUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToHexStringUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToHexStringUninitializedNode(ToHexStringBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                String value;
                try {
                    value = this.executeString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public String executeString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            public String executeToHexString(VirtualFrame frameValue, Object arguments0ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = arguments0ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected String executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected String executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToHexStringBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToHexStringBaseNode rootNode = (ToHexStringBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToHexStringBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ToHexStringNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToHexStringUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.ToHexStringNode.class)
        private static abstract class ToHexStringBaseNode
        extends KernelNodes.ToHexStringNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToHexStringBaseNode next0;

            ToHexStringBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToHexStringBaseNode(ToHexStringBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract String executeChained0(VirtualFrame var1, Object var2);

            protected final String rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ToHexStringBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToHexStringBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToHexStringUninitializedNode(this);
                    ((ToHexStringUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToHexStringBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToHexStringBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ToHexStringBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToHexStringUninitializedNode(this), (Node)new ToHexStringPolymorphicNode(this), (DSLNode)((ToHexStringBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToHexStringBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ToHexStringBaseNode)ToHexStringIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (ToHexStringBaseNode)ToHexStringLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBignum(arguments0Value)) {
                    return (ToHexStringBaseNode)ToHexStringRubyBignumNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToHexStringBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToHexStringBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelIsTaintedNode.class)
    public static final class KernelIsTaintedNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelIsTaintedNode> {
        private static KernelIsTaintedNodeFactory kernelIsTaintedNodeFactoryInstance;

        private KernelIsTaintedNodeFactory() {
            super(KernelNodes.KernelIsTaintedNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelIsTaintedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelIsTaintedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.KernelIsTaintedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return KernelIsTaintedObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.KernelIsTaintedNode> getInstance() {
            if (kernelIsTaintedNodeFactoryInstance == null) {
                kernelIsTaintedNodeFactoryInstance = new KernelIsTaintedNodeFactory();
            }
            return kernelIsTaintedNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.KernelIsTaintedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KernelIsTaintedObjectNode
        extends KernelIsTaintedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KernelIsTaintedObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            KernelIsTaintedObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.isTainted(arguments0Value);
            }

            static KernelNodes.KernelIsTaintedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new KernelIsTaintedObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.KernelIsTaintedNode.class)
        private static abstract class KernelIsTaintedBaseNode
        extends KernelNodes.KernelIsTaintedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            KernelIsTaintedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((KernelIsTaintedBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelTaintNode.class)
    public static final class KernelTaintNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelTaintNode> {
        private static KernelTaintNodeFactory kernelTaintNodeFactoryInstance;

        private KernelTaintNodeFactory() {
            super(KernelNodes.KernelTaintNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelTaintNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelTaintNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.KernelTaintNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return KernelTaintObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.KernelTaintNode> getInstance() {
            if (kernelTaintNodeFactoryInstance == null) {
                kernelTaintNodeFactoryInstance = new KernelTaintNodeFactory();
            }
            return kernelTaintNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.KernelTaintNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KernelTaintObjectNode
        extends KernelTaintBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KernelTaintObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            KernelTaintObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.taint(arguments0Value);
            }

            static KernelNodes.KernelTaintNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new KernelTaintObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.KernelTaintNode.class)
        private static abstract class KernelTaintBaseNode
        extends KernelNodes.KernelTaintNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            KernelTaintBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((KernelTaintBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SystemNode.class)
    public static final class SystemNodeFactory
    extends NodeFactoryBase<KernelNodes.SystemNode> {
        private static SystemNodeFactory systemNodeFactoryInstance;

        private SystemNodeFactory() {
            super(KernelNodes.SystemNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SystemNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SystemNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.SystemNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SystemUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.SystemNode> getInstance() {
            if (systemNodeFactoryInstance == null) {
                systemNodeFactoryInstance = new SystemNodeFactory();
            }
            return systemNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.SystemNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SystemPolymorphicNode
        extends SystemBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SystemPolymorphicNode(SystemBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.SystemNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SystemRubyStringNode
        extends SystemBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SystemRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            SystemRubyStringNode(SystemBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.system(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.system(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SystemNode create0(KernelNodes.SystemNode current) {
                return new SystemRubyStringNode((SystemBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SystemNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SystemUninitializedNode
        extends SystemBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SystemUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SystemUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SystemUninitializedNode(SystemBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SystemBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SystemBaseNode rootNode = (SystemBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SystemBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SystemNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SystemUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.SystemNode.class)
        private static abstract class SystemBaseNode
        extends KernelNodes.SystemNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SystemBaseNode next0;

            SystemBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SystemBaseNode(SystemBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SystemBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SystemBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SystemUninitializedNode(this);
                    ((SystemUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SystemBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SystemBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SystemBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SystemUninitializedNode(this), (Node)new SystemPolymorphicNode(this), (DSLNode)((SystemBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SystemBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (SystemBaseNode)SystemRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SystemBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SystemBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SPrintfNode.class)
    public static final class SPrintfNodeFactory
    extends NodeFactoryBase<KernelNodes.SPrintfNode> {
        private static SPrintfNodeFactory sPrintfNodeFactoryInstance;

        private SPrintfNodeFactory() {
            super(KernelNodes.SPrintfNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SPrintfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SPrintfNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.SPrintfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SPrintfUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.SPrintfNode> getInstance() {
            if (sPrintfNodeFactoryInstance == null) {
                sPrintfNodeFactoryInstance = new SPrintfNodeFactory();
            }
            return sPrintfNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.SPrintfNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SPrintfPolymorphicNode
        extends SPrintfBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SPrintfPolymorphicNode(SPrintfBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.SPrintfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SPrintfObjectArrayNode
        extends SPrintfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SPrintfObjectArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

            SPrintfObjectArrayNode(SPrintfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof Object[]");
                }
                return super.sprintf(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    Object[] arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments0Value);
                    return super.sprintf(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SPrintfNode create0(KernelNodes.SPrintfNode current) {
                return new SPrintfObjectArrayNode((SPrintfBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SPrintfNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SPrintfUninitializedNode
        extends SPrintfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SPrintfUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SPrintfUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SPrintfUninitializedNode(SPrintfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SPrintfBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SPrintfBaseNode rootNode = (SPrintfBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SPrintfBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SPrintfNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SPrintfUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.SPrintfNode.class)
        private static abstract class SPrintfBaseNode
        extends KernelNodes.SPrintfNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SPrintfBaseNode next0;

            SPrintfBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SPrintfBaseNode(SPrintfBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SPrintfBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SPrintfBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SPrintfUninitializedNode(this);
                    ((SPrintfUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SPrintfBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SPrintfBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SPrintfBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SPrintfUninitializedNode(this), (Node)new SPrintfPolymorphicNode(this), (DSLNode)((SPrintfBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SPrintfBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    return (SPrintfBaseNode)SPrintfObjectArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SPrintfBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SPrintfBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SleepNode.class)
    public static final class SleepNodeFactory
    extends NodeFactoryBase<KernelNodes.SleepNode> {
        private static SleepNodeFactory sleepNodeFactoryInstance;

        private SleepNodeFactory() {
            super(KernelNodes.SleepNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SleepNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SleepNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.SleepNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SleepUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.SleepNode> getInstance() {
            if (sleepNodeFactoryInstance == null) {
                sleepNodeFactoryInstance = new SleepNodeFactory();
            }
            return sleepNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SleepPolymorphicNode
        extends SleepBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SleepPolymorphicNode(SleepBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == UndefinedPlaceholder.class ? this.arguments[0].executeUndefinedPlaceholder(frameValue) : (this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBasicObject.class ? this.arguments[0].executeRubyBasicObject(frameValue) : this.arguments[0].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SleepRubyBasicObject1Node
        extends SleepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SleepRubyBasicObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            SleepRubyBasicObject1Node(SleepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBasicObject");
                }
                if (!super.isRubiniusUndefined(arguments0Value)) {
                    return super.sleep(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isRubiniusUndefined] failed");
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    if (!super.isRubiniusUndefined(arguments0Value)) {
                        return super.sleep(frameValue, arguments0ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SleepNode create0(KernelNodes.SleepNode current) {
                return new SleepRubyBasicObject1Node((SleepBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SleepRubyBasicObject0Node
        extends SleepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SleepRubyBasicObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            SleepRubyBasicObject0Node(SleepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBasicObject");
                }
                if (super.isRubiniusUndefined(arguments0Value)) {
                    return super.sleep(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isRubiniusUndefined] failed");
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    if (super.isRubiniusUndefined(arguments0Value)) {
                        return super.sleep(arguments0ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SleepNode create0(KernelNodes.SleepNode current) {
                return new SleepRubyBasicObject0Node((SleepBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SleepDoubleNode
        extends SleepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SleepDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            SleepDoubleNode(SleepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.sleep(arguments0Value);
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.sleep(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SleepNode create0(KernelNodes.SleepNode current) {
                return new SleepDoubleNode((SleepBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SleepLongNode
        extends SleepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SleepLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            SleepLongNode(SleepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.sleep(arguments0Value);
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.sleep(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SleepNode create0(KernelNodes.SleepNode current) {
                return new SleepLongNode((SleepBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SleepIntNode
        extends SleepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SleepIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            SleepIntNode(SleepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.sleep(arguments0Value);
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.sleep(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SleepNode create0(KernelNodes.SleepNode current) {
                return new SleepIntNode((SleepBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SleepUndefinedPlaceholderNode
        extends SleepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SleepUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{UndefinedPlaceholder.class}, 0, 0);

            SleepUndefinedPlaceholderNode(SleepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof UndefinedPlaceholder");
                }
                return super.sleep(arguments0Value);
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    UndefinedPlaceholder arguments0ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments0Value);
                    return super.sleep(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SleepNode create0(KernelNodes.SleepNode current) {
                return new SleepUndefinedPlaceholderNode((SleepBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SleepUninitializedNode
        extends SleepBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SleepUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SleepUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SleepUninitializedNode(SleepBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected long executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SleepBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SleepBaseNode rootNode = (SleepBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SleepBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SleepNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SleepUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.SleepNode.class)
        private static abstract class SleepBaseNode
        extends KernelNodes.SleepNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SleepBaseNode next0;

            SleepBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SleepBaseNode(SleepBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract long executeChained0(VirtualFrame var1, Object var2);

            protected final long rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SleepBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SleepBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SleepUninitializedNode(this);
                    ((SleepUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SleepBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SleepBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SleepBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SleepUninitializedNode(this), (Node)new SleepPolymorphicNode(this), (DSLNode)((SleepBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SleepBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    return (SleepBaseNode)SleepUndefinedPlaceholderNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (SleepBaseNode)SleepIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (SleepBaseNode)SleepLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (SleepBaseNode)SleepDoubleNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    if (super.isRubiniusUndefined(arguments0Value)) {
                        return (SleepBaseNode)SleepRubyBasicObject0Node.create0(this);
                    }
                    return (SleepBaseNode)SleepRubyBasicObject1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SleepBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SleepBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.StringNode.class)
    public static final class StringNodeFactory
    extends NodeFactoryBase<KernelNodes.StringNode> {
        private static StringNodeFactory stringNodeFactoryInstance;

        private StringNodeFactory() {
            super(KernelNodes.StringNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.StringNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return StringNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.StringNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return StringUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.StringNode> getInstance() {
            if (stringNodeFactoryInstance == null) {
                stringNodeFactoryInstance = new StringNodeFactory();
            }
            return stringNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.StringNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class StringPolymorphicNode
        extends StringBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            StringPolymorphicNode(StringBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyString.class ? this.arguments[0].executeRubyString(frameValue) : this.arguments[0].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.StringNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringObjectNode
        extends StringBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            StringObjectNode(StringBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                if (!super.isRubyString(arguments0Value)) {
                    return super.string(frameValue, arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isRubyString] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!super.isRubyString(arguments0Value)) {
                    return super.string(frameValue, arguments0Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.StringNode create0(KernelNodes.StringNode current) {
                return new StringObjectNode((StringBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.StringNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class StringRubyStringNode
        extends StringBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            StringRubyStringNode(StringBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyString(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString"));
                }
                return super.string(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.string(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.StringNode create0(KernelNodes.StringNode current) {
                return new StringRubyStringNode((StringBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.StringNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class StringUninitializedNode
        extends StringBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(StringUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            StringUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            StringUninitializedNode(StringBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                StringBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    StringBaseNode rootNode = (StringBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((StringBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.StringNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new StringUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.StringNode.class)
        private static abstract class StringBaseNode
        extends KernelNodes.StringNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected StringBaseNode next0;

            StringBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            StringBaseNode(StringBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                StringBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                StringBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new StringUninitializedNode(this);
                    ((StringUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (StringBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = StringBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (StringBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new StringUninitializedNode(this), (Node)new StringPolymorphicNode(this), (DSLNode)((StringBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final StringBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (StringBaseNode)StringRubyStringNode.create0(this);
                }
                if (!super.isRubyString(arguments0Value)) {
                    return (StringBaseNode)StringObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((StringBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (StringBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
    public static final class SingletonMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.SingletonMethodsNode> {
        private static SingletonMethodsNodeFactory singletonMethodsNodeFactoryInstance;

        private SingletonMethodsNodeFactory() {
            super(KernelNodes.SingletonMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SingletonMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SingletonMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.SingletonMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SingletonMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.SingletonMethodsNode> getInstance() {
            if (singletonMethodsNodeFactoryInstance == null) {
                singletonMethodsNodeFactoryInstance = new SingletonMethodsNodeFactory();
            }
            return singletonMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SingletonMethodsPolymorphicNode
        extends SingletonMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SingletonMethodsPolymorphicNode(SingletonMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SingletonMethodsRubyBasicObjectUndefinedPlaceholderNode
        extends SingletonMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SingletonMethodsRubyBasicObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, UndefinedPlaceholder.class}, 0, 0);

            SingletonMethodsRubyBasicObjectUndefinedPlaceholderNode(SingletonMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.singletonMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.singletonMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.SingletonMethodsNode create0(KernelNodes.SingletonMethodsNode current) {
                return new SingletonMethodsRubyBasicObjectUndefinedPlaceholderNode((SingletonMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SingletonMethodsRubyBasicObjectBooleanNode
        extends SingletonMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SingletonMethodsRubyBasicObjectBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, Boolean.TYPE}, 0, 0);

            SingletonMethodsRubyBasicObjectBooleanNode(SingletonMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.singletonMethods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.singletonMethods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.SingletonMethodsNode create0(KernelNodes.SingletonMethodsNode current) {
                return new SingletonMethodsRubyBasicObjectBooleanNode((SingletonMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SingletonMethodsUninitializedNode
        extends SingletonMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SingletonMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SingletonMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SingletonMethodsUninitializedNode(SingletonMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SingletonMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SingletonMethodsBaseNode rootNode = (SingletonMethodsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SingletonMethodsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.SingletonMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SingletonMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.SingletonMethodsNode.class)
        private static abstract class SingletonMethodsBaseNode
        extends KernelNodes.SingletonMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SingletonMethodsBaseNode next0;

            SingletonMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SingletonMethodsBaseNode(SingletonMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                SingletonMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SingletonMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SingletonMethodsUninitializedNode(this);
                    ((SingletonMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SingletonMethodsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SingletonMethodsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SingletonMethodsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SingletonMethodsUninitializedNode(this), (Node)new SingletonMethodsPolymorphicNode(this), (DSLNode)((SingletonMethodsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SingletonMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (SingletonMethodsBaseNode)SingletonMethodsRubyBasicObjectBooleanNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (SingletonMethodsBaseNode)SingletonMethodsRubyBasicObjectUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SingletonMethodsBaseNode otherCast = (SingletonMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SingletonMethodsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SingletonClassMethodNode.class)
    public static final class SingletonClassMethodNodeFactory
    extends NodeFactoryBase<KernelNodes.SingletonClassMethodNode> {
        private static SingletonClassMethodNodeFactory singletonClassMethodNodeFactoryInstance;

        private SingletonClassMethodNodeFactory() {
            super(KernelNodes.SingletonClassMethodNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SingletonClassMethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SingletonClassMethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.SingletonClassMethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SingletonClassMethodObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.SingletonClassMethodNode> getInstance() {
            if (singletonClassMethodNodeFactoryInstance == null) {
                singletonClassMethodNodeFactoryInstance = new SingletonClassMethodNodeFactory();
            }
            return singletonClassMethodNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.SingletonClassMethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SingletonClassMethodObjectNode
        extends SingletonClassMethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SingletonClassMethodObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            SingletonClassMethodObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyClass value;
                try {
                    value = this.executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.singletonClass(frameValue, arguments0Value);
            }

            static KernelNodes.SingletonClassMethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SingletonClassMethodObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.SingletonClassMethodNode.class)
        private static abstract class SingletonClassMethodBaseNode
        extends KernelNodes.SingletonClassMethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            SingletonClassMethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SingletonClassMethodBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
    public static final class SetTraceFuncNodeFactory
    extends NodeFactoryBase<KernelNodes.SetTraceFuncNode> {
        private static SetTraceFuncNodeFactory setTraceFuncNodeFactoryInstance;

        private SetTraceFuncNodeFactory() {
            super(KernelNodes.SetTraceFuncNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SetTraceFuncNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SetTraceFuncNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.SetTraceFuncNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SetTraceFuncUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.SetTraceFuncNode> getInstance() {
            if (setTraceFuncNodeFactoryInstance == null) {
                setTraceFuncNodeFactoryInstance = new SetTraceFuncNodeFactory();
            }
            return setTraceFuncNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SetTraceFuncPolymorphicNode
        extends SetTraceFuncBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SetTraceFuncPolymorphicNode(SetTraceFuncBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyNilClass.class ? this.arguments[0].executeRubyNilClass(frameValue) : (this.arguments0PolymorphicType == RubyProc.class ? this.arguments[0].executeRubyProc(frameValue) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetTraceFuncRubyProcNode
        extends SetTraceFuncBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetTraceFuncRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyProc.class}, 0, 0);

            SetTraceFuncRubyProcNode(SetTraceFuncBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyProc(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyProc"));
                }
                return super.setTraceFunc(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments0Value)) {
                    RubyProc arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments0Value);
                    return super.setTraceFunc(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SetTraceFuncNode create0(KernelNodes.SetTraceFuncNode current) {
                return new SetTraceFuncRubyProcNode((SetTraceFuncBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SetTraceFuncRubyNilClassNode
        extends SetTraceFuncBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetTraceFuncRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class}, 0, 0);

            SetTraceFuncRubyNilClassNode(SetTraceFuncBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyNilClass arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyNilClass"));
                }
                return super.setTraceFunc(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments0Value)) {
                    RubyNilClass arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(arguments0Value);
                    return super.setTraceFunc(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SetTraceFuncNode create0(KernelNodes.SetTraceFuncNode current) {
                return new SetTraceFuncRubyNilClassNode((SetTraceFuncBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SetTraceFuncUninitializedNode
        extends SetTraceFuncBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SetTraceFuncUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SetTraceFuncUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SetTraceFuncUninitializedNode(SetTraceFuncBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SetTraceFuncBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SetTraceFuncBaseNode rootNode = (SetTraceFuncBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SetTraceFuncBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.SetTraceFuncNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SetTraceFuncUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.SetTraceFuncNode.class)
        private static abstract class SetTraceFuncBaseNode
        extends KernelNodes.SetTraceFuncNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SetTraceFuncBaseNode next0;

            SetTraceFuncBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SetTraceFuncBaseNode(SetTraceFuncBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SetTraceFuncBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SetTraceFuncBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SetTraceFuncUninitializedNode(this);
                    ((SetTraceFuncUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SetTraceFuncBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SetTraceFuncBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SetTraceFuncBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SetTraceFuncUninitializedNode(this), (Node)new SetTraceFuncPolymorphicNode(this), (DSLNode)((SetTraceFuncBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SetTraceFuncBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments0Value)) {
                    return (SetTraceFuncBaseNode)SetTraceFuncRubyNilClassNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments0Value)) {
                    return (SetTraceFuncBaseNode)SetTraceFuncRubyProcNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SetTraceFuncBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SetTraceFuncBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
    public static final class RespondToMissingNodeFactory
    extends NodeFactoryBase<KernelNodes.RespondToMissingNode> {
        private static RespondToMissingNodeFactory respondToMissingNodeFactoryInstance;

        private RespondToMissingNodeFactory() {
            super(KernelNodes.RespondToMissingNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.RespondToMissingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RespondToMissingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.RespondToMissingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RespondToMissingUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.RespondToMissingNode> getInstance() {
            if (respondToMissingNodeFactoryInstance == null) {
                respondToMissingNodeFactoryInstance = new RespondToMissingNodeFactory();
            }
            return respondToMissingNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RespondToMissingPolymorphicNode
        extends RespondToMissingBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            RespondToMissingPolymorphicNode(RespondToMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[2].executeBoolean(frameValue)) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToMissingObjectRubyStringBooleanNode
        extends RespondToMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToMissingObjectRubyStringBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyString.class, Boolean.TYPE}, 0, 0);

            RespondToMissingObjectRubyStringBooleanNode(RespondToMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments2Value;
                RubyString arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof boolean");
                }
                return super.doesRespondToMissing(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    boolean arguments2ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments2Value);
                    return super.doesRespondToMissing(arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToMissingNode create0(KernelNodes.RespondToMissingNode current) {
                return new RespondToMissingObjectRubyStringBooleanNode((RespondToMissingBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToMissingObjectRubySymbolBooleanNode
        extends RespondToMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToMissingObjectRubySymbolBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubySymbol.class, Boolean.TYPE}, 0, 0);

            RespondToMissingObjectRubySymbolBooleanNode(RespondToMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments2Value;
                RubySymbol arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof boolean");
                }
                return super.doesRespondToMissing(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    boolean arguments2ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments2Value);
                    return super.doesRespondToMissing(arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToMissingNode create0(KernelNodes.RespondToMissingNode current) {
                return new RespondToMissingObjectRubySymbolBooleanNode((RespondToMissingBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToMissingObjectRubySymbolUndefinedPlaceholderNode
        extends RespondToMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToMissingObjectRubySymbolUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubySymbol.class, UndefinedPlaceholder.class}, 0, 0);

            RespondToMissingObjectRubySymbolUndefinedPlaceholderNode(RespondToMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubySymbol arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.doesRespondToMissing(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.doesRespondToMissing(arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToMissingNode create0(KernelNodes.RespondToMissingNode current) {
                return new RespondToMissingObjectRubySymbolUndefinedPlaceholderNode((RespondToMissingBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToMissingObjectRubyStringUndefinedPlaceholderNode
        extends RespondToMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToMissingObjectRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            RespondToMissingObjectRubyStringUndefinedPlaceholderNode(RespondToMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.doesRespondToMissing(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.doesRespondToMissing(arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToMissingNode create0(KernelNodes.RespondToMissingNode current) {
                return new RespondToMissingObjectRubyStringUndefinedPlaceholderNode((RespondToMissingBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RespondToMissingUninitializedNode
        extends RespondToMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToMissingUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RespondToMissingUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RespondToMissingUninitializedNode(RespondToMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RespondToMissingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RespondToMissingBaseNode rootNode = (RespondToMissingBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RespondToMissingBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToMissingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RespondToMissingUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToMissingNode.class)
        private static abstract class RespondToMissingBaseNode
        extends KernelNodes.RespondToMissingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RespondToMissingBaseNode next0;

            RespondToMissingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RespondToMissingBaseNode(RespondToMissingBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                RespondToMissingBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RespondToMissingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new RespondToMissingUninitializedNode(this);
                    ((RespondToMissingUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RespondToMissingBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RespondToMissingBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (RespondToMissingBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RespondToMissingUninitializedNode(this), (Node)new RespondToMissingPolymorphicNode(this), (DSLNode)((RespondToMissingBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RespondToMissingBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (RespondToMissingBaseNode)RespondToMissingObjectRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (RespondToMissingBaseNode)RespondToMissingObjectRubySymbolUndefinedPlaceholderNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (RespondToMissingBaseNode)RespondToMissingObjectRubySymbolBooleanNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (RespondToMissingBaseNode)RespondToMissingObjectRubyStringBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    RespondToMissingBaseNode otherCast = (RespondToMissingBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (RespondToMissingBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RespondToNode.class)
    public static final class RespondToNodeFactory
    extends NodeFactoryBase<KernelNodes.RespondToNode> {
        private static RespondToNodeFactory respondToNodeFactoryInstance;

        private RespondToNodeFactory() {
            super(KernelNodes.RespondToNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.RespondToNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RespondToNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.RespondToNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RespondToUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.RespondToNode> getInstance() {
            if (respondToNodeFactoryInstance == null) {
                respondToNodeFactoryInstance = new RespondToNodeFactory();
            }
            return respondToNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RespondToPolymorphicNode
        extends RespondToBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            RespondToPolymorphicNode(RespondToBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[2].executeBoolean(frameValue)) : (this.arguments2PolymorphicType == RubyBasicObject.class ? this.arguments[2].executeRubyBasicObject(frameValue) : this.arguments[2].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated, boolean arguments2ValueEvaluated) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? RubyTypesGen.RUBYTYPES.expectRubyString(arguments1ValueEvaluated) : (this.arguments1PolymorphicType == RubySymbol.class ? RubyTypesGen.RUBYTYPES.expectRubySymbol(arguments1ValueEvaluated) : arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Boolean arguments2Value2 = arguments2ValueEvaluated;
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments2ValueEvaluated) : (this.arguments2PolymorphicType == Boolean.TYPE ? Boolean.valueOf(arguments2ValueEvaluated) : (this.arguments2PolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(arguments2ValueEvaluated) : Boolean.valueOf(arguments2ValueEvaluated)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToObjectRubySymbolBooleanNode
        extends RespondToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToObjectRubySymbolBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubySymbol.class, Boolean.TYPE}, 0, 0);

            RespondToObjectRubySymbolBooleanNode(RespondToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments2Value;
                RubySymbol arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof boolean");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated, boolean arguments2ValueEvaluated) {
                RubySymbol arguments1Value;
                Object arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectRubySymbol(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Boolean arguments2Value = arguments2ValueEvaluated;
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubySymbol");
                }
                boolean arguments2Value = arguments2ValueEvaluated;
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    boolean arguments2ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments2Value);
                    return super.doesRespondTo(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToNode create0(KernelNodes.RespondToNode current) {
                return new RespondToObjectRubySymbolBooleanNode((RespondToBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToObjectRubySymbolRubyBasicObjectNode
        extends RespondToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToObjectRubySymbolRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubySymbol.class, RubyBasicObject.class}, 0, 0);

            RespondToObjectRubySymbolRubyBasicObjectNode(RespondToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments2Value;
                RubySymbol arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyBasicObject");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated, boolean arguments2ValueEvaluated) {
                RubyBasicObject arguments2Value;
                RubySymbol arguments1Value;
                Object arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectRubySymbol(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Boolean arguments2Value2 = arguments2ValueEvaluated;
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(arguments2ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyBasicObject");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments2Value)) {
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    RubyBasicObject arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments2Value);
                    return super.doesRespondTo(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToNode create0(KernelNodes.RespondToNode current) {
                return new RespondToObjectRubySymbolRubyBasicObjectNode((RespondToBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToObjectRubySymbolUndefinedPlaceholderNode
        extends RespondToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToObjectRubySymbolUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubySymbol.class, UndefinedPlaceholder.class}, 0, 0);

            RespondToObjectRubySymbolUndefinedPlaceholderNode(RespondToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubySymbol arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated, boolean arguments2ValueEvaluated) {
                UndefinedPlaceholder arguments2Value;
                RubySymbol arguments1Value;
                Object arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectRubySymbol(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Boolean arguments2Value2 = arguments2ValueEvaluated;
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments2ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.doesRespondTo(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToNode create0(KernelNodes.RespondToNode current) {
                return new RespondToObjectRubySymbolUndefinedPlaceholderNode((RespondToBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToObjectRubyStringBooleanNode
        extends RespondToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToObjectRubyStringBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyString.class, Boolean.TYPE}, 0, 0);

            RespondToObjectRubyStringBooleanNode(RespondToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments2Value;
                RubyString arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof boolean");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated, boolean arguments2ValueEvaluated) {
                RubyString arguments1Value;
                Object arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectRubyString(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Boolean arguments2Value = arguments2ValueEvaluated;
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubyString");
                }
                boolean arguments2Value = arguments2ValueEvaluated;
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    boolean arguments2ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments2Value);
                    return super.doesRespondTo(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToNode create0(KernelNodes.RespondToNode current) {
                return new RespondToObjectRubyStringBooleanNode((RespondToBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToObjectRubyStringRubyBasicObjectNode
        extends RespondToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToObjectRubyStringRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyString.class, RubyBasicObject.class}, 0, 0);

            RespondToObjectRubyStringRubyBasicObjectNode(RespondToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments2Value;
                RubyString arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyBasicObject");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated, boolean arguments2ValueEvaluated) {
                RubyBasicObject arguments2Value;
                RubyString arguments1Value;
                Object arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectRubyString(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Boolean arguments2Value2 = arguments2ValueEvaluated;
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(arguments2ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyBasicObject");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments2Value)) {
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    RubyBasicObject arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments2Value);
                    return super.doesRespondTo(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToNode create0(KernelNodes.RespondToNode current) {
                return new RespondToObjectRubyStringRubyBasicObjectNode((RespondToBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RespondToObjectRubyStringUndefinedPlaceholderNode
        extends RespondToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToObjectRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            RespondToObjectRubyStringUndefinedPlaceholderNode(RespondToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated, boolean arguments2ValueEvaluated) {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                Object arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectRubyString(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Boolean arguments2Value2 = arguments2ValueEvaluated;
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments2ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.doesRespondTo(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.doesRespondTo(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToNode create0(KernelNodes.RespondToNode current) {
                return new RespondToObjectRubyStringUndefinedPlaceholderNode((RespondToBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RespondToUninitializedNode
        extends RespondToBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RespondToUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RespondToUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RespondToUninitializedNode(RespondToBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public boolean executeDoesRespondTo(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated, boolean arguments2ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                Boolean arguments2Value = arguments2ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                RespondToBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RespondToBaseNode rootNode = (RespondToBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RespondToBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.RespondToNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RespondToUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.RespondToNode.class)
        private static abstract class RespondToBaseNode
        extends KernelNodes.RespondToNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RespondToBaseNode next0;

            RespondToBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RespondToBaseNode(RespondToBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                RespondToBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RespondToBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new RespondToUninitializedNode(this);
                    ((RespondToUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RespondToBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RespondToBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (RespondToBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RespondToUninitializedNode(this), (Node)new RespondToPolymorphicNode(this), (DSLNode)((RespondToBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RespondToBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (RespondToBaseNode)RespondToObjectRubyStringUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments2Value)) {
                        return (RespondToBaseNode)RespondToObjectRubyStringRubyBasicObjectNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                        return (RespondToBaseNode)RespondToObjectRubyStringBooleanNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (RespondToBaseNode)RespondToObjectRubySymbolUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments2Value)) {
                        return (RespondToBaseNode)RespondToObjectRubySymbolRubyBasicObjectNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments2Value)) {
                        return (RespondToBaseNode)RespondToObjectRubySymbolBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    RespondToBaseNode otherCast = (RespondToBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (RespondToBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RequireRelativeNode.class)
    public static final class RequireRelativeNodeFactory
    extends NodeFactoryBase<KernelNodes.RequireRelativeNode> {
        private static RequireRelativeNodeFactory requireRelativeNodeFactoryInstance;

        private RequireRelativeNodeFactory() {
            super(KernelNodes.RequireRelativeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.RequireRelativeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RequireRelativeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.RequireRelativeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RequireRelativeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.RequireRelativeNode> getInstance() {
            if (requireRelativeNodeFactoryInstance == null) {
                requireRelativeNodeFactoryInstance = new RequireRelativeNodeFactory();
            }
            return requireRelativeNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.RequireRelativeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RequireRelativePolymorphicNode
        extends RequireRelativeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            RequireRelativePolymorphicNode(RequireRelativeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.RequireRelativeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RequireRelativeRubyStringNode
        extends RequireRelativeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RequireRelativeRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            RequireRelativeRubyStringNode(RequireRelativeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.requireRelative(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.requireRelative(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RequireRelativeNode create0(KernelNodes.RequireRelativeNode current) {
                return new RequireRelativeRubyStringNode((RequireRelativeBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RequireRelativeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RequireRelativeUninitializedNode
        extends RequireRelativeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RequireRelativeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RequireRelativeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RequireRelativeUninitializedNode(RequireRelativeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                RequireRelativeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RequireRelativeBaseNode rootNode = (RequireRelativeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RequireRelativeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RequireRelativeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RequireRelativeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.RequireRelativeNode.class)
        private static abstract class RequireRelativeBaseNode
        extends KernelNodes.RequireRelativeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RequireRelativeBaseNode next0;

            RequireRelativeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RequireRelativeBaseNode(RequireRelativeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                RequireRelativeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RequireRelativeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new RequireRelativeUninitializedNode(this);
                    ((RequireRelativeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RequireRelativeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RequireRelativeBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (RequireRelativeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RequireRelativeUninitializedNode(this), (Node)new RequireRelativePolymorphicNode(this), (DSLNode)((RequireRelativeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RequireRelativeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (RequireRelativeBaseNode)RequireRelativeRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((RequireRelativeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (RequireRelativeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RequireNode.class)
    public static final class RequireNodeFactory
    extends NodeFactoryBase<KernelNodes.RequireNode> {
        private static RequireNodeFactory requireNodeFactoryInstance;

        private RequireNodeFactory() {
            super(KernelNodes.RequireNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.RequireNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RequireNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.RequireNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RequireUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.RequireNode> getInstance() {
            if (requireNodeFactoryInstance == null) {
                requireNodeFactoryInstance = new RequireNodeFactory();
            }
            return requireNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.RequireNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RequirePolymorphicNode
        extends RequireBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            RequirePolymorphicNode(RequireBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.RequireNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RequireRubyStringNode
        extends RequireBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RequireRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            RequireRubyStringNode(RequireBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.require(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.require(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RequireNode create0(KernelNodes.RequireNode current) {
                return new RequireRubyStringNode((RequireBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RequireNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RequireUninitializedNode
        extends RequireBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RequireUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RequireUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RequireUninitializedNode(RequireBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                RequireBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RequireBaseNode rootNode = (RequireBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RequireBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RequireNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RequireUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.RequireNode.class)
        private static abstract class RequireBaseNode
        extends KernelNodes.RequireNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RequireBaseNode next0;

            RequireBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RequireBaseNode(RequireBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                RequireBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RequireBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new RequireUninitializedNode(this);
                    ((RequireUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RequireBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RequireBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (RequireBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RequireUninitializedNode(this), (Node)new RequirePolymorphicNode(this), (DSLNode)((RequireBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RequireBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (RequireBaseNode)RequireRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((RequireBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (RequireBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.RandNode.class)
    public static final class RandNodeFactory
    extends NodeFactoryBase<KernelNodes.RandNode> {
        private static RandNodeFactory randNodeFactoryInstance;

        private RandNodeFactory() {
            super(KernelNodes.RandNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.RandNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RandNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.RandNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RandUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.RandNode> getInstance() {
            if (randNodeFactoryInstance == null) {
                randNodeFactoryInstance = new RandNodeFactory();
            }
            return randNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RandPolymorphicNode
        extends RandBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            RandPolymorphicNode(RandBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == UndefinedPlaceholder.class ? this.arguments[0].executeUndefinedPlaceholder(frameValue) : (this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RandLongNode
        extends RandBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RandLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            RandLongNode(RandBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                if (super.isNonZero(arguments0Value)) {
                    return super.randNonZero(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, "One of guards [isNonZero] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                long arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && super.isNonZero(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value))) {
                    return super.randNonZero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RandNode create0(KernelNodes.RandNode current) {
                return new RandLongNode((RandBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RandDoubleLongNode
        extends RandBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RandDoubleLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            RandDoubleLongNode(RandBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long"));
                }
                if (super.isZero(arguments0Value)) {
                    return super.randZero(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, "One of guards [isZero] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                long arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value) && super.isZero(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value))) {
                    return super.randZero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RandNode create0(KernelNodes.RandNode current) {
                return new RandDoubleLongNode((RandBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RandIntNode
        extends RandBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RandIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            RandIntNode(RandBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                if (super.isNonZero(arguments0Value)) {
                    return super.randNonZero(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, "One of guards [isNonZero] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                int arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && super.isNonZero(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value))) {
                    return super.randNonZero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RandNode create0(KernelNodes.RandNode current) {
                return new RandIntNode((RandBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RandDoubleIntNode
        extends RandBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RandDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            RandDoubleIntNode(RandBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int"));
                }
                if (super.isZero(arguments0Value)) {
                    return super.randZero(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, "One of guards [isZero] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                int arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value) && super.isZero(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value))) {
                    return super.randZero(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RandNode create0(KernelNodes.RandNode current) {
                return new RandDoubleIntNode((RandBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RandDoubleUndefinedPlaceholderNode
        extends RandBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RandDoubleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{UndefinedPlaceholder.class}, 0, 0);

            RandDoubleUndefinedPlaceholderNode(RandBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof UndefinedPlaceholder"));
                }
                return super.rand(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    UndefinedPlaceholder arguments0ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments0Value);
                    return super.rand(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RandNode create0(KernelNodes.RandNode current) {
                return new RandDoubleUndefinedPlaceholderNode((RandBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RandUninitializedNode
        extends RandBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RandUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RandUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RandUninitializedNode(RandBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                RandBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RandBaseNode rootNode = (RandBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RandBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.RandNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RandUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.RandNode.class)
        private static abstract class RandBaseNode
        extends KernelNodes.RandNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RandBaseNode next0;

            RandBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RandBaseNode(RandBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                RandBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RandBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new RandUninitializedNode(this);
                    ((RandUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RandBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RandBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (RandBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RandUninitializedNode(this), (Node)new RandPolymorphicNode(this), (DSLNode)((RandBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RandBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    return (RandBaseNode)RandDoubleUndefinedPlaceholderNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    if (super.isZero(arguments0ValueCast)) {
                        return (RandBaseNode)RandDoubleIntNode.create0(this);
                    }
                    if (super.isNonZero(arguments0ValueCast)) {
                        return (RandBaseNode)RandIntNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    if (super.isZero(arguments0ValueCast)) {
                        return (RandBaseNode)RandDoubleLongNode.create0(this);
                    }
                    if (super.isNonZero(arguments0ValueCast)) {
                        return (RandBaseNode)RandLongNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((RandBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (RandBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
    public static final class PublicMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.PublicMethodsNode> {
        private static PublicMethodsNodeFactory publicMethodsNodeFactoryInstance;

        private PublicMethodsNodeFactory() {
            super(KernelNodes.PublicMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.PublicMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PublicMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.PublicMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PublicMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.PublicMethodsNode> getInstance() {
            if (publicMethodsNodeFactoryInstance == null) {
                publicMethodsNodeFactoryInstance = new PublicMethodsNodeFactory();
            }
            return publicMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PublicMethodsPolymorphicNode
        extends PublicMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PublicMethodsPolymorphicNode(PublicMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicMethodsRubyBasicObjectUndefinedPlaceholderNode
        extends PublicMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicMethodsRubyBasicObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, UndefinedPlaceholder.class}, 0, 0);

            PublicMethodsRubyBasicObjectUndefinedPlaceholderNode(PublicMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.methods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.methods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.PublicMethodsNode create0(KernelNodes.PublicMethodsNode current) {
                return new PublicMethodsRubyBasicObjectUndefinedPlaceholderNode((PublicMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PublicMethodsRubyBasicObjectBooleanNode
        extends PublicMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicMethodsRubyBasicObjectBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, Boolean.TYPE}, 0, 0);

            PublicMethodsRubyBasicObjectBooleanNode(PublicMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.methods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.methods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.PublicMethodsNode create0(KernelNodes.PublicMethodsNode current) {
                return new PublicMethodsRubyBasicObjectBooleanNode((PublicMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PublicMethodsUninitializedNode
        extends PublicMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PublicMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PublicMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PublicMethodsUninitializedNode(PublicMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PublicMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PublicMethodsBaseNode rootNode = (PublicMethodsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PublicMethodsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.PublicMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PublicMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.PublicMethodsNode.class)
        private static abstract class PublicMethodsBaseNode
        extends KernelNodes.PublicMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PublicMethodsBaseNode next0;

            PublicMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PublicMethodsBaseNode(PublicMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PublicMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PublicMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PublicMethodsUninitializedNode(this);
                    ((PublicMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PublicMethodsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PublicMethodsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PublicMethodsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PublicMethodsUninitializedNode(this), (Node)new PublicMethodsPolymorphicNode(this), (DSLNode)((PublicMethodsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PublicMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (PublicMethodsBaseNode)PublicMethodsRubyBasicObjectBooleanNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (PublicMethodsBaseNode)PublicMethodsRubyBasicObjectUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PublicMethodsBaseNode otherCast = (PublicMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PublicMethodsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ProcNode.class)
    public static final class ProcNodeFactory
    extends NodeFactoryBase<KernelNodes.ProcNode> {
        private static ProcNodeFactory procNodeFactoryInstance;

        private ProcNodeFactory() {
            super(KernelNodes.ProcNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ProcNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ProcNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.ProcNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ProcUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.ProcNode> getInstance() {
            if (procNodeFactoryInstance == null) {
                procNodeFactoryInstance = new ProcNodeFactory();
            }
            return procNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.ProcNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ProcPolymorphicNode
        extends ProcBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ProcPolymorphicNode(ProcBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.ProcNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ProcRubyProcNode
        extends ProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProcRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyProc.class}, 0, 0);

            ProcRubyProcNode(ProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyProc");
                }
                return super.proc(arguments0Value);
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments0Value)) {
                    RubyProc arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments0Value);
                    return super.proc(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ProcNode create0(KernelNodes.ProcNode current) {
                return new ProcRubyProcNode((ProcBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ProcNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ProcUninitializedNode
        extends ProcBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProcUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ProcUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ProcUninitializedNode(ProcBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyProc executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ProcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ProcBaseNode rootNode = (ProcBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ProcBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ProcNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ProcUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.ProcNode.class)
        private static abstract class ProcBaseNode
        extends KernelNodes.ProcNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ProcBaseNode next0;

            ProcBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ProcBaseNode(ProcBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyProc executeChained0(VirtualFrame var1, Object var2);

            protected final RubyProc rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ProcBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ProcBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ProcUninitializedNode(this);
                    ((ProcUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ProcBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ProcBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ProcBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ProcUninitializedNode(this), (Node)new ProcPolymorphicNode(this), (DSLNode)((ProcBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ProcBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments0Value)) {
                    return (ProcBaseNode)ProcRubyProcNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ProcBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ProcBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
    public static final class PrivateMethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.PrivateMethodsNode> {
        private static PrivateMethodsNodeFactory privateMethodsNodeFactoryInstance;

        private PrivateMethodsNodeFactory() {
            super(KernelNodes.PrivateMethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.PrivateMethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PrivateMethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.PrivateMethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PrivateMethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.PrivateMethodsNode> getInstance() {
            if (privateMethodsNodeFactoryInstance == null) {
                privateMethodsNodeFactoryInstance = new PrivateMethodsNodeFactory();
            }
            return privateMethodsNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PrivateMethodsPolymorphicNode
        extends PrivateMethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PrivateMethodsPolymorphicNode(PrivateMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateMethodsRubyBasicObjectBooleanNode
        extends PrivateMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateMethodsRubyBasicObjectBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, Boolean.TYPE}, 0, 0);

            PrivateMethodsRubyBasicObjectBooleanNode(PrivateMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.private_methods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.private_methods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.PrivateMethodsNode create0(KernelNodes.PrivateMethodsNode current) {
                return new PrivateMethodsRubyBasicObjectBooleanNode((PrivateMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PrivateMethodsRubyBasicObjectUndefinedPlaceholderNode
        extends PrivateMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateMethodsRubyBasicObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, UndefinedPlaceholder.class}, 0, 0);

            PrivateMethodsRubyBasicObjectUndefinedPlaceholderNode(PrivateMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.private_methods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.private_methods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.PrivateMethodsNode create0(KernelNodes.PrivateMethodsNode current) {
                return new PrivateMethodsRubyBasicObjectUndefinedPlaceholderNode((PrivateMethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PrivateMethodsUninitializedNode
        extends PrivateMethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PrivateMethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PrivateMethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PrivateMethodsUninitializedNode(PrivateMethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PrivateMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PrivateMethodsBaseNode rootNode = (PrivateMethodsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PrivateMethodsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.PrivateMethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PrivateMethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.PrivateMethodsNode.class)
        private static abstract class PrivateMethodsBaseNode
        extends KernelNodes.PrivateMethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PrivateMethodsBaseNode next0;

            PrivateMethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PrivateMethodsBaseNode(PrivateMethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PrivateMethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PrivateMethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PrivateMethodsUninitializedNode(this);
                    ((PrivateMethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PrivateMethodsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PrivateMethodsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PrivateMethodsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PrivateMethodsUninitializedNode(this), (Node)new PrivateMethodsPolymorphicNode(this), (DSLNode)((PrivateMethodsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PrivateMethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (PrivateMethodsBaseNode)PrivateMethodsRubyBasicObjectUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (PrivateMethodsBaseNode)PrivateMethodsRubyBasicObjectBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PrivateMethodsBaseNode otherCast = (PrivateMethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PrivateMethodsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.NilNode.class)
    public static final class NilNodeFactory
    extends NodeFactoryBase<KernelNodes.NilNode> {
        private static NilNodeFactory nilNodeFactoryInstance;

        private NilNodeFactory() {
            super(KernelNodes.NilNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.NilNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NilNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.NilNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NilDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.NilNode> getInstance() {
            if (nilNodeFactoryInstance == null) {
                nilNodeFactoryInstance = new NilNodeFactory();
            }
            return nilNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.NilNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NilDefaultNode
        extends NilBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NilDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            NilDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.isNil();
            }

            static KernelNodes.NilNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NilDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.NilNode.class)
        private static abstract class NilBaseNode
        extends KernelNodes.NilNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            NilBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MethodsNode.class)
    public static final class MethodsNodeFactory
    extends NodeFactoryBase<KernelNodes.MethodsNode> {
        private static MethodsNodeFactory methodsNodeFactoryInstance;

        private MethodsNodeFactory() {
            super(KernelNodes.MethodsNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.MethodsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MethodsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.MethodsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MethodsUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.MethodsNode> getInstance() {
            if (methodsNodeFactoryInstance == null) {
                methodsNodeFactoryInstance = new MethodsNodeFactory();
            }
            return methodsNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.MethodsNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MethodsPolymorphicNode
        extends MethodsBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MethodsPolymorphicNode(MethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[1].executeBoolean(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.MethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodsRubyBasicObjectBooleanNode
        extends MethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodsRubyBasicObjectBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, Boolean.TYPE}, 0, 0);

            MethodsRubyBasicObjectBooleanNode(MethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof boolean");
                }
                return super.methods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    boolean arguments1ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments1Value);
                    return super.methods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.MethodsNode create0(KernelNodes.MethodsNode current) {
                return new MethodsRubyBasicObjectBooleanNode((MethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.MethodsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodsRubyBasicObjectUndefinedPlaceholderNode
        extends MethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodsRubyBasicObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, UndefinedPlaceholder.class}, 0, 0);

            MethodsRubyBasicObjectUndefinedPlaceholderNode(MethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.methods(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.methods(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.MethodsNode create0(KernelNodes.MethodsNode current) {
                return new MethodsRubyBasicObjectUndefinedPlaceholderNode((MethodsBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.MethodsNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MethodsUninitializedNode
        extends MethodsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodsUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MethodsUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MethodsUninitializedNode(MethodsBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MethodsBaseNode rootNode = (MethodsBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MethodsBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.MethodsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MethodsUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.MethodsNode.class)
        private static abstract class MethodsBaseNode
        extends KernelNodes.MethodsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MethodsBaseNode next0;

            MethodsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MethodsBaseNode(MethodsBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MethodsBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MethodsBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MethodsUninitializedNode(this);
                    ((MethodsUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MethodsBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MethodsBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MethodsBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MethodsUninitializedNode(this), (Node)new MethodsPolymorphicNode(this), (DSLNode)((MethodsBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MethodsBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (MethodsBaseNode)MethodsRubyBasicObjectUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isBoolean(arguments1Value)) {
                        return (MethodsBaseNode)MethodsRubyBasicObjectBooleanNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MethodsBaseNode otherCast = (MethodsBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MethodsBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MethodNode.class)
    public static final class MethodNodeFactory
    extends NodeFactoryBase<KernelNodes.MethodNode> {
        private static MethodNodeFactory methodNodeFactoryInstance;

        private MethodNodeFactory() {
            super(KernelNodes.MethodNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.MethodNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MethodNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.MethodNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MethodUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.MethodNode> getInstance() {
            if (methodNodeFactoryInstance == null) {
                methodNodeFactoryInstance = new MethodNodeFactory();
            }
            return methodNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.MethodNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MethodPolymorphicNode
        extends MethodBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MethodPolymorphicNode(MethodBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMethod value;
                try {
                    value = this.executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyMethod executeRubyMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.MethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodObjectRubyStringNode
        extends MethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodObjectRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyString.class}, 0, 0);

            MethodObjectRubyStringNode(MethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMethod value;
                try {
                    value = this.executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyMethod executeRubyMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.method(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.method(arguments0Value, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.MethodNode create0(KernelNodes.MethodNode current) {
                return new MethodObjectRubyStringNode((MethodBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.MethodNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodObjectRubySymbolNode
        extends MethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodObjectRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubySymbol.class}, 0, 0);

            MethodObjectRubySymbolNode(MethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMethod value;
                try {
                    value = this.executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyMethod executeRubyMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.method(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.method(arguments0Value, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.MethodNode create0(KernelNodes.MethodNode current) {
                return new MethodObjectRubySymbolNode((MethodBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.MethodNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MethodUninitializedNode
        extends MethodBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MethodUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MethodUninitializedNode(MethodBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyMethod value;
                try {
                    value = this.executeRubyMethod(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyMethod executeRubyMethod(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyMethod executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyMethod executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MethodBaseNode rootNode = (MethodBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MethodBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.MethodNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MethodUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.MethodNode.class)
        private static abstract class MethodBaseNode
        extends KernelNodes.MethodNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MethodBaseNode next0;

            MethodBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MethodBaseNode(MethodBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyMethod executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyMethod rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MethodBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MethodBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MethodUninitializedNode(this);
                    ((MethodUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MethodBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MethodBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MethodBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MethodUninitializedNode(this), (Node)new MethodPolymorphicNode(this), (DSLNode)((MethodBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MethodBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    return (MethodBaseNode)MethodObjectRubySymbolNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (MethodBaseNode)MethodObjectRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MethodBaseNode otherCast = (MethodBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MethodBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MethodNameNode.class)
    public static final class MethodNameNodeFactory
    extends NodeFactoryBase<KernelNodes.MethodNameNode> {
        private static MethodNameNodeFactory methodNameNodeFactoryInstance;

        private MethodNameNodeFactory() {
            super(KernelNodes.MethodNameNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.MethodNameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MethodNameNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.MethodNameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MethodNameDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.MethodNameNode> getInstance() {
            if (methodNameNodeFactoryInstance == null) {
                methodNameNodeFactoryInstance = new MethodNameNodeFactory();
            }
            return methodNameNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.MethodNameNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodNameDefaultNode
        extends MethodNameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodNameDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            MethodNameDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.methodName(frameValue);
            }

            static KernelNodes.MethodNameNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MethodNameDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.MethodNameNode.class)
        private static abstract class MethodNameBaseNode
        extends KernelNodes.MethodNameNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            MethodNameBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.LocalVariablesNode.class)
    public static final class LocalVariablesNodeFactory
    extends NodeFactoryBase<KernelNodes.LocalVariablesNode> {
        private static LocalVariablesNodeFactory localVariablesNodeFactoryInstance;

        private LocalVariablesNodeFactory() {
            super(KernelNodes.LocalVariablesNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.LocalVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LocalVariablesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.LocalVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LocalVariablesDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.LocalVariablesNode> getInstance() {
            if (localVariablesNodeFactoryInstance == null) {
                localVariablesNodeFactoryInstance = new LocalVariablesNodeFactory();
            }
            return localVariablesNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.LocalVariablesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LocalVariablesDefaultNode
        extends LocalVariablesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LocalVariablesDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            LocalVariablesDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.localVariables();
            }

            static KernelNodes.LocalVariablesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LocalVariablesDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.LocalVariablesNode.class)
        private static abstract class LocalVariablesBaseNode
        extends KernelNodes.LocalVariablesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            LocalVariablesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.LoadNode.class)
    public static final class LoadNodeFactory
    extends NodeFactoryBase<KernelNodes.LoadNode> {
        private static LoadNodeFactory loadNodeFactoryInstance;

        private LoadNodeFactory() {
            super(KernelNodes.LoadNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.LoadNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LoadNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.LoadNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LoadUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.LoadNode> getInstance() {
            if (loadNodeFactoryInstance == null) {
                loadNodeFactoryInstance = new LoadNodeFactory();
            }
            return loadNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.LoadNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LoadPolymorphicNode
        extends LoadBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            LoadPolymorphicNode(LoadBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.LoadNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LoadRubyStringNode
        extends LoadBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LoadRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            LoadRubyStringNode(LoadBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.load(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.load(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.LoadNode create0(KernelNodes.LoadNode current) {
                return new LoadRubyStringNode((LoadBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.LoadNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LoadUninitializedNode
        extends LoadBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LoadUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LoadUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LoadUninitializedNode(LoadBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                LoadBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LoadBaseNode rootNode = (LoadBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LoadBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.LoadNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LoadUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.LoadNode.class)
        private static abstract class LoadBaseNode
        extends KernelNodes.LoadNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LoadBaseNode next0;

            LoadBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LoadBaseNode(LoadBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                LoadBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LoadBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new LoadUninitializedNode(this);
                    ((LoadUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LoadBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LoadBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (LoadBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LoadUninitializedNode(this), (Node)new LoadPolymorphicNode(this), (DSLNode)((LoadBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LoadBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (LoadBaseNode)LoadRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((LoadBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (LoadBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.LambdaNode.class)
    public static final class LambdaNodeFactory
    extends NodeFactoryBase<KernelNodes.LambdaNode> {
        private static LambdaNodeFactory lambdaNodeFactoryInstance;

        private LambdaNodeFactory() {
            super(KernelNodes.LambdaNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.LambdaNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LambdaNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.LambdaNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LambdaUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.LambdaNode> getInstance() {
            if (lambdaNodeFactoryInstance == null) {
                lambdaNodeFactoryInstance = new LambdaNodeFactory();
            }
            return lambdaNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.LambdaNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LambdaPolymorphicNode
        extends LambdaBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            LambdaPolymorphicNode(LambdaBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.LambdaNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LambdaRubyProcNode
        extends LambdaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LambdaRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyProc.class}, 0, 0);

            LambdaRubyProcNode(LambdaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyProc");
                }
                return super.proc(arguments0Value);
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments0Value)) {
                    RubyProc arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments0Value);
                    return super.proc(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.LambdaNode create0(KernelNodes.LambdaNode current) {
                return new LambdaRubyProcNode((LambdaBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.LambdaNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LambdaUninitializedNode
        extends LambdaBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LambdaUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LambdaUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LambdaUninitializedNode(LambdaBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc value;
                try {
                    value = this.executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyProc executeRubyProc(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyProc executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyProc executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                LambdaBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LambdaBaseNode rootNode = (LambdaBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LambdaBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.LambdaNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LambdaUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.LambdaNode.class)
        private static abstract class LambdaBaseNode
        extends KernelNodes.LambdaNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LambdaBaseNode next0;

            LambdaBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LambdaBaseNode(LambdaBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyProc executeChained0(VirtualFrame var1, Object var2);

            protected final RubyProc rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                LambdaBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LambdaBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new LambdaUninitializedNode(this);
                    ((LambdaUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LambdaBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LambdaBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (LambdaBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LambdaUninitializedNode(this), (Node)new LambdaPolymorphicNode(this), (DSLNode)((LambdaBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LambdaBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments0Value)) {
                    return (LambdaBaseNode)LambdaRubyProcNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((LambdaBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (LambdaBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.IsANode.class)
    public static final class IsANodeFactory
    extends NodeFactoryBase<KernelNodes.IsANode> {
        private static IsANodeFactory isANodeFactoryInstance;

        private IsANodeFactory() {
            super(KernelNodes.IsANode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.IsANode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IsANodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.IsANode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IsAUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.IsANode> getInstance() {
            if (isANodeFactoryInstance == null) {
                isANodeFactoryInstance = new IsANodeFactory();
            }
            return isANodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.IsANode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IsAPolymorphicNode
        extends IsABaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IsAPolymorphicNode(IsABaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyBasicObject.class ? this.arguments[0].executeRubyBasicObject(frameValue) : this.arguments[0].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? this.arguments[1].executeRubyModule(frameValue) : (this.arguments1PolymorphicType == RubyNilClass.class ? this.arguments[1].executeRubyNilClass(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public boolean executeIsA(VirtualFrame frameValue, Object arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyBasicObject arguments1Value;
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(arguments0ValueEvaluated) : arguments0ValueEvaluated;
                }
                catch (UnexpectedResultException ex) {
                    RubyModule arguments1Value2 = arguments1ValueEvaluated;
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), arguments1Value2);
                }
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyModule.class ? arguments1ValueEvaluated : (this.arguments1PolymorphicType == RubyNilClass.class ? RubyTypesGen.RUBYTYPES.expectRubyNilClass(arguments1ValueEvaluated) : arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.IsANode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsAObjectRubyModuleNode
        extends IsABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsAObjectRubyModuleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyModule.class}, 0, 0);

            IsAObjectRubyModuleNode(IsABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyModule arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyModule(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyModule");
                }
                return super.isA(arguments0Value, arguments1Value);
            }

            @Override
            public boolean executeIsA(VirtualFrame frameValue, Object arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                Object arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return super.isA(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    RubyModule arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyModule(arguments1Value);
                    return super.isA(arguments0Value, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.IsANode create0(KernelNodes.IsANode current) {
                return new IsAObjectRubyModuleNode((IsABaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.IsANode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IsARubyBasicObjectRubyNilClassNode
        extends IsABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsARubyBasicObjectRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyNilClass.class}, 0, 0);

            IsARubyBasicObjectRubyNilClassNode(IsABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyNilClass arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyNilClass");
                }
                return super.isA(arguments0Value, arguments1Value);
            }

            @Override
            public boolean executeIsA(VirtualFrame frameValue, Object arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                RubyNilClass arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(arguments0ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    RubyModule arguments1Value2 = arguments1ValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectRubyNilClass(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyNilClass");
                }
                return super.isA(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubyNilClass arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(arguments1Value);
                    return super.isA(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.IsANode create0(KernelNodes.IsANode current) {
                return new IsARubyBasicObjectRubyNilClassNode((IsABaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.IsANode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IsAUninitializedNode
        extends IsABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IsAUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IsAUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IsAUninitializedNode(IsABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public boolean executeIsA(VirtualFrame frameValue, Object arguments0ValueEvaluated, RubyModule arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = arguments0ValueEvaluated;
                RubyModule arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IsABaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IsABaseNode rootNode = (IsABaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IsABaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.IsANode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IsAUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.IsANode.class)
        private static abstract class IsABaseNode
        extends KernelNodes.IsANode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IsABaseNode next0;

            IsABaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IsABaseNode(IsABaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                IsABaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IsABaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IsAUninitializedNode(this);
                    ((IsAUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IsABaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IsABaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (IsABaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IsAUninitializedNode(this), (Node)new IsAPolymorphicNode(this), (DSLNode)((IsABaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IsABaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyNilClass(arguments1Value)) {
                    return (IsABaseNode)IsARubyBasicObjectRubyNilClassNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyModule(arguments1Value)) {
                    return (IsABaseNode)IsAObjectRubyModuleNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IsABaseNode otherCast = (IsABaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IsABaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariablesNode.class)
    public static final class InstanceVariablesNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariablesNode> {
        private static InstanceVariablesNodeFactory instanceVariablesNodeFactoryInstance;

        private InstanceVariablesNodeFactory() {
            super(KernelNodes.InstanceVariablesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceVariablesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.InstanceVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceVariablesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.InstanceVariablesNode> getInstance() {
            if (instanceVariablesNodeFactoryInstance == null) {
                instanceVariablesNodeFactoryInstance = new InstanceVariablesNodeFactory();
            }
            return instanceVariablesNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.InstanceVariablesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceVariablesPolymorphicNode
        extends InstanceVariablesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InstanceVariablesPolymorphicNode(InstanceVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariablesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceVariablesRubyBasicObjectNode
        extends InstanceVariablesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariablesRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            InstanceVariablesRubyBasicObjectNode(InstanceVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBasicObject");
                }
                return super.instanceVariables(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    return super.instanceVariables(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.InstanceVariablesNode create0(KernelNodes.InstanceVariablesNode current) {
                return new InstanceVariablesRubyBasicObjectNode((InstanceVariablesBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariablesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceVariablesUninitializedNode
        extends InstanceVariablesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariablesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceVariablesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceVariablesUninitializedNode(InstanceVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InstanceVariablesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceVariablesBaseNode rootNode = (InstanceVariablesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InstanceVariablesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.InstanceVariablesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceVariablesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariablesNode.class)
        private static abstract class InstanceVariablesBaseNode
        extends KernelNodes.InstanceVariablesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceVariablesBaseNode next0;

            InstanceVariablesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceVariablesBaseNode(InstanceVariablesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                InstanceVariablesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceVariablesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InstanceVariablesUninitializedNode(this);
                    ((InstanceVariablesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InstanceVariablesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InstanceVariablesBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (InstanceVariablesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InstanceVariablesUninitializedNode(this), (Node)new InstanceVariablesPolymorphicNode(this), (DSLNode)((InstanceVariablesBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceVariablesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    return (InstanceVariablesBaseNode)InstanceVariablesRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InstanceVariablesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InstanceVariablesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
    public static final class InstanceVariableSetNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariableSetNode> {
        private static InstanceVariableSetNodeFactory instanceVariableSetNodeFactoryInstance;

        private InstanceVariableSetNodeFactory() {
            super(KernelNodes.InstanceVariableSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceVariableSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceVariableSetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.InstanceVariableSetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceVariableSetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.InstanceVariableSetNode> getInstance() {
            if (instanceVariableSetNodeFactoryInstance == null) {
                instanceVariableSetNodeFactoryInstance = new InstanceVariableSetNodeFactory();
            }
            return instanceVariableSetNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceVariableSetPolymorphicNode
        extends InstanceVariableSetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InstanceVariableSetPolymorphicNode(InstanceVariableSetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value);
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceVariableSetRubyBasicObjectRubySymbolNode
        extends InstanceVariableSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariableSetRubyBasicObjectRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubySymbol.class, Object.class}, 0, 0);

            InstanceVariableSetRubyBasicObjectRubySymbolNode(InstanceVariableSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubySymbol");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return super.instanceVariableSet(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.instanceVariableSet(arguments0ValueCast, arguments1ValueCast, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.InstanceVariableSetNode create0(KernelNodes.InstanceVariableSetNode current) {
                return new InstanceVariableSetRubyBasicObjectRubySymbolNode((InstanceVariableSetBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceVariableSetRubyBasicObjectRubyStringNode
        extends InstanceVariableSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariableSetRubyBasicObjectRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyString.class, Object.class}, 0, 0);

            InstanceVariableSetRubyBasicObjectRubyStringNode(InstanceVariableSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubyString");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return super.instanceVariableSet(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.instanceVariableSet(arguments0ValueCast, arguments1ValueCast, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.InstanceVariableSetNode create0(KernelNodes.InstanceVariableSetNode current) {
                return new InstanceVariableSetRubyBasicObjectRubyStringNode((InstanceVariableSetBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceVariableSetUninitializedNode
        extends InstanceVariableSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariableSetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceVariableSetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceVariableSetUninitializedNode(InstanceVariableSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InstanceVariableSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceVariableSetBaseNode rootNode = (InstanceVariableSetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InstanceVariableSetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static KernelNodes.InstanceVariableSetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceVariableSetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableSetNode.class)
        private static abstract class InstanceVariableSetBaseNode
        extends KernelNodes.InstanceVariableSetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceVariableSetBaseNode next0;

            InstanceVariableSetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceVariableSetBaseNode(InstanceVariableSetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                InstanceVariableSetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceVariableSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InstanceVariableSetUninitializedNode(this);
                    ((InstanceVariableSetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InstanceVariableSetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InstanceVariableSetBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (InstanceVariableSetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InstanceVariableSetUninitializedNode(this), (Node)new InstanceVariableSetPolymorphicNode(this), (DSLNode)((InstanceVariableSetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceVariableSetBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (InstanceVariableSetBaseNode)InstanceVariableSetRubyBasicObjectRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (InstanceVariableSetBaseNode)InstanceVariableSetRubyBasicObjectRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InstanceVariableSetBaseNode otherCast = (InstanceVariableSetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InstanceVariableSetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
    public static final class InstanceVariableGetNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariableGetNode> {
        private static InstanceVariableGetNodeFactory instanceVariableGetNodeFactoryInstance;

        private InstanceVariableGetNodeFactory() {
            super(KernelNodes.InstanceVariableGetNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceVariableGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceVariableGetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.InstanceVariableGetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceVariableGetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.InstanceVariableGetNode> getInstance() {
            if (instanceVariableGetNodeFactoryInstance == null) {
                instanceVariableGetNodeFactoryInstance = new InstanceVariableGetNodeFactory();
            }
            return instanceVariableGetNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceVariableGetPolymorphicNode
        extends InstanceVariableGetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InstanceVariableGetPolymorphicNode(InstanceVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceVariableGetRubyBasicObjectRubySymbolNode
        extends InstanceVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariableGetRubyBasicObjectRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubySymbol.class}, 0, 0);

            InstanceVariableGetRubyBasicObjectRubySymbolNode(InstanceVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.instanceVariableGet(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.instanceVariableGet(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InstanceVariableGetNode create0(KernelNodes.InstanceVariableGetNode current) {
                return new InstanceVariableGetRubyBasicObjectRubySymbolNode((InstanceVariableGetBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceVariableGetRubyBasicObjectRubyStringNode
        extends InstanceVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariableGetRubyBasicObjectRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyString.class}, 0, 0);

            InstanceVariableGetRubyBasicObjectRubyStringNode(InstanceVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.instanceVariableGet(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.instanceVariableGet(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InstanceVariableGetNode create0(KernelNodes.InstanceVariableGetNode current) {
                return new InstanceVariableGetRubyBasicObjectRubyStringNode((InstanceVariableGetBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceVariableGetUninitializedNode
        extends InstanceVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariableGetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceVariableGetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceVariableGetUninitializedNode(InstanceVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InstanceVariableGetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceVariableGetBaseNode rootNode = (InstanceVariableGetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InstanceVariableGetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InstanceVariableGetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceVariableGetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableGetNode.class)
        private static abstract class InstanceVariableGetBaseNode
        extends KernelNodes.InstanceVariableGetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceVariableGetBaseNode next0;

            InstanceVariableGetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceVariableGetBaseNode(InstanceVariableGetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InstanceVariableGetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceVariableGetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InstanceVariableGetUninitializedNode(this);
                    ((InstanceVariableGetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InstanceVariableGetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InstanceVariableGetBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InstanceVariableGetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InstanceVariableGetUninitializedNode(this), (Node)new InstanceVariableGetPolymorphicNode(this), (DSLNode)((InstanceVariableGetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceVariableGetBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (InstanceVariableGetBaseNode)InstanceVariableGetRubyBasicObjectRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (InstanceVariableGetBaseNode)InstanceVariableGetRubyBasicObjectRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InstanceVariableGetBaseNode otherCast = (InstanceVariableGetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InstanceVariableGetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
    public static final class InstanceVariableDefinedNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceVariableDefinedNode> {
        private static InstanceVariableDefinedNodeFactory instanceVariableDefinedNodeFactoryInstance;

        private InstanceVariableDefinedNodeFactory() {
            super(KernelNodes.InstanceVariableDefinedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceVariableDefinedNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceVariableDefinedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.InstanceVariableDefinedNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceVariableDefinedUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.InstanceVariableDefinedNode> getInstance() {
            if (instanceVariableDefinedNodeFactoryInstance == null) {
                instanceVariableDefinedNodeFactoryInstance = new InstanceVariableDefinedNodeFactory();
            }
            return instanceVariableDefinedNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceVariableDefinedPolymorphicNode
        extends InstanceVariableDefinedBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InstanceVariableDefinedPolymorphicNode(InstanceVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : (this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceVariableDefinedRubyBasicObjectRubySymbolNode
        extends InstanceVariableDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariableDefinedRubyBasicObjectRubySymbolNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubySymbol.class}, 0, 0);

            InstanceVariableDefinedRubyBasicObjectRubySymbolNode(InstanceVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubySymbol arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.isInstanceVariableDefined(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.isInstanceVariableDefined(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InstanceVariableDefinedNode create0(KernelNodes.InstanceVariableDefinedNode current) {
                return new InstanceVariableDefinedRubyBasicObjectRubySymbolNode((InstanceVariableDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceVariableDefinedRubyBasicObjectRubyStringNode
        extends InstanceVariableDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariableDefinedRubyBasicObjectRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyString.class}, 0, 0);

            InstanceVariableDefinedRubyBasicObjectRubyStringNode(InstanceVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.isInstanceVariableDefined(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.isInstanceVariableDefined(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InstanceVariableDefinedNode create0(KernelNodes.InstanceVariableDefinedNode current) {
                return new InstanceVariableDefinedRubyBasicObjectRubyStringNode((InstanceVariableDefinedBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceVariableDefinedUninitializedNode
        extends InstanceVariableDefinedBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceVariableDefinedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceVariableDefinedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceVariableDefinedUninitializedNode(InstanceVariableDefinedBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InstanceVariableDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceVariableDefinedBaseNode rootNode = (InstanceVariableDefinedBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InstanceVariableDefinedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InstanceVariableDefinedNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceVariableDefinedUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceVariableDefinedNode.class)
        private static abstract class InstanceVariableDefinedBaseNode
        extends KernelNodes.InstanceVariableDefinedNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceVariableDefinedBaseNode next0;

            InstanceVariableDefinedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceVariableDefinedBaseNode(InstanceVariableDefinedBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InstanceVariableDefinedBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceVariableDefinedBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InstanceVariableDefinedUninitializedNode(this);
                    ((InstanceVariableDefinedUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InstanceVariableDefinedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InstanceVariableDefinedBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InstanceVariableDefinedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InstanceVariableDefinedUninitializedNode(this), (Node)new InstanceVariableDefinedPolymorphicNode(this), (DSLNode)((InstanceVariableDefinedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceVariableDefinedBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (InstanceVariableDefinedBaseNode)InstanceVariableDefinedRubyBasicObjectRubyStringNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                        return (InstanceVariableDefinedBaseNode)InstanceVariableDefinedRubyBasicObjectRubySymbolNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InstanceVariableDefinedBaseNode otherCast = (InstanceVariableDefinedBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InstanceVariableDefinedBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InstanceOfNode.class)
    public static final class InstanceOfNodeFactory
    extends NodeFactoryBase<KernelNodes.InstanceOfNode> {
        private static InstanceOfNodeFactory instanceOfNodeFactoryInstance;

        private InstanceOfNodeFactory() {
            super(KernelNodes.InstanceOfNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InstanceOfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceOfNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.InstanceOfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceOfUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.InstanceOfNode> getInstance() {
            if (instanceOfNodeFactoryInstance == null) {
                instanceOfNodeFactoryInstance = new InstanceOfNodeFactory();
            }
            return instanceOfNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.InstanceOfNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceOfPolymorphicNode
        extends InstanceOfBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InstanceOfPolymorphicNode(InstanceOfBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceOfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceOfObjectNode
        extends InstanceOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceOfObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyClass.class}, 0, 0);

            InstanceOfObjectNode(InstanceOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyClass arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyClass");
                }
                return super.instanceOf(arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments1Value)) {
                    RubyClass arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyClass(arguments1Value);
                    return super.instanceOf(arguments0Value, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InstanceOfNode create0(KernelNodes.InstanceOfNode current) {
                return new InstanceOfObjectNode((InstanceOfBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceOfNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceOfUninitializedNode
        extends InstanceOfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceOfUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceOfUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceOfUninitializedNode(InstanceOfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InstanceOfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceOfBaseNode rootNode = (InstanceOfBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InstanceOfBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InstanceOfNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceOfUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.InstanceOfNode.class)
        private static abstract class InstanceOfBaseNode
        extends KernelNodes.InstanceOfNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceOfBaseNode next0;

            InstanceOfBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceOfBaseNode(InstanceOfBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InstanceOfBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceOfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InstanceOfUninitializedNode(this);
                    ((InstanceOfUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InstanceOfBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InstanceOfBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InstanceOfBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InstanceOfUninitializedNode(this), (Node)new InstanceOfPolymorphicNode(this), (DSLNode)((InstanceOfBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceOfBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyClass(arguments1Value)) {
                    return (InstanceOfBaseNode)InstanceOfObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InstanceOfBaseNode otherCast = (InstanceOfBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InstanceOfBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InitializeDupCloneNode.class)
    public static final class InitializeDupCloneNodeFactory
    extends NodeFactoryBase<KernelNodes.InitializeDupCloneNode> {
        private static InitializeDupCloneNodeFactory initializeDupCloneNodeFactoryInstance;

        private InitializeDupCloneNodeFactory() {
            super(KernelNodes.InitializeDupCloneNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InitializeDupCloneNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeDupCloneNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.InitializeDupCloneNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeDupCloneUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.InitializeDupCloneNode> getInstance() {
            if (initializeDupCloneNodeFactoryInstance == null) {
                initializeDupCloneNodeFactoryInstance = new InitializeDupCloneNodeFactory();
            }
            return initializeDupCloneNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.InitializeDupCloneNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeDupClonePolymorphicNode
        extends InitializeDupCloneBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeDupClonePolymorphicNode(InitializeDupCloneBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.InitializeDupCloneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeDupCloneRubyBasicObjectNode
        extends InitializeDupCloneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeDupCloneRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyBasicObject.class}, 0, 0);

            InitializeDupCloneRubyBasicObjectNode(InitializeDupCloneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.initializeDup(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.initializeDup(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InitializeDupCloneNode create0(KernelNodes.InitializeDupCloneNode current) {
                return new InitializeDupCloneRubyBasicObjectNode((InitializeDupCloneBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InitializeDupCloneNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeDupCloneUninitializedNode
        extends InitializeDupCloneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeDupCloneUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeDupCloneUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeDupCloneUninitializedNode(InitializeDupCloneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeDupCloneBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeDupCloneBaseNode rootNode = (InitializeDupCloneBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeDupCloneBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InitializeDupCloneNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeDupCloneUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.InitializeDupCloneNode.class)
        private static abstract class InitializeDupCloneBaseNode
        extends KernelNodes.InitializeDupCloneNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeDupCloneBaseNode next0;

            InitializeDupCloneBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeDupCloneBaseNode(InitializeDupCloneBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InitializeDupCloneBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeDupCloneBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeDupCloneUninitializedNode(this);
                    ((InitializeDupCloneUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeDupCloneBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeDupCloneBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeDupCloneBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeDupCloneUninitializedNode(this), (Node)new InitializeDupClonePolymorphicNode(this), (DSLNode)((InitializeDupCloneBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeDupCloneBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    return (InitializeDupCloneBaseNode)InitializeDupCloneRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeDupCloneBaseNode otherCast = (InitializeDupCloneBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeDupCloneBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<KernelNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(KernelNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=KernelNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyBasicObjectNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyBasicObject.class}, 0, 0);

            InitializeCopyRubyBasicObjectNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject arguments1Value;
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBasicObject");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBasicObject");
                }
                return super.initializeCopy(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    RubyBasicObject arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments1Value);
                    return super.initializeCopy(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InitializeCopyNode create0(KernelNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyBasicObjectNode((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = (InitializeCopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeCopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeCopyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends KernelNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeCopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeCopyBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeCopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeCopyUninitializedNode(this), (Node)new InitializeCopyPolymorphicNode(this), (DSLNode)((InitializeCopyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments1Value)) {
                    return (InitializeCopyBaseNode)InitializeCopyRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<KernelNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(KernelNodes.HashNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return HashUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class HashPolymorphicNode
        extends HashBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            HashPolymorphicNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[0].executeBoolean(frameValue)) : (this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : (this.arguments0PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[0].executeLongFixnum(frameValue)) : (this.arguments0PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[0].executeFloat(frameValue)) : (this.arguments0PolymorphicType == RubyBasicObject.class ? this.arguments[0].executeRubyBasicObject(frameValue) : this.arguments[0].execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HashRubyBasicObjectNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            HashRubyBasicObjectNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBasicObject");
                }
                return super.hash(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    return super.hash(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.HashNode create0(KernelNodes.HashNode current) {
                return new HashRubyBasicObjectNode((HashBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HashBooleanNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

            HashBooleanNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof boolean");
                }
                return super.hash(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(arguments0Value)) {
                    boolean arguments0ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments0Value);
                    return super.hash(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.HashNode create0(KernelNodes.HashNode current) {
                return new HashBooleanNode((HashBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HashDoubleNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

            HashDoubleNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                double arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof double");
                }
                return super.hash(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    double arguments0ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments0Value);
                    return super.hash(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.HashNode create0(KernelNodes.HashNode current) {
                return new HashDoubleNode((HashBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HashLongNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

            HashLongNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                long arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof long");
                }
                return super.hash(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    long arguments0ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments0Value);
                    return super.hash(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.HashNode create0(KernelNodes.HashNode current) {
                return new HashLongNode((HashBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HashIntNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            HashIntNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.hash(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.hash(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.HashNode create0(KernelNodes.HashNode current) {
                return new HashIntNode((HashBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class HashUninitializedNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            HashUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            HashUninitializedNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    HashBaseNode rootNode = (HashBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((HashBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.HashNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new HashUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.HashNode.class)
        private static abstract class HashBaseNode
        extends KernelNodes.HashNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected HashBaseNode next0;

            HashBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            HashBaseNode(HashBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                HashBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new HashUninitializedNode(this);
                    ((HashUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (HashBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = HashBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (HashBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new HashUninitializedNode(this), (Node)new HashPolymorphicNode(this), (DSLNode)((HashBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final HashBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (HashBaseNode)HashIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(arguments0Value)) {
                    return (HashBaseNode)HashLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(arguments0Value)) {
                    return (HashBaseNode)HashDoubleNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isBoolean(arguments0Value)) {
                    return (HashBaseNode)HashBooleanNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    return (HashBaseNode)HashRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((HashBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (HashBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.GetsNode.class)
    public static final class GetsNodeFactory
    extends NodeFactoryBase<KernelNodes.GetsNode> {
        private static GetsNodeFactory getsNodeFactoryInstance;

        private GetsNodeFactory() {
            super(KernelNodes.GetsNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.GetsNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return GetsNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.GetsNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return GetsDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.GetsNode> getInstance() {
            if (getsNodeFactoryInstance == null) {
                getsNodeFactoryInstance = new GetsNodeFactory();
            }
            return getsNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.GetsNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class GetsDefaultNode
        extends GetsBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(GetsDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            GetsDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.gets(frameValue);
            }

            static KernelNodes.GetsNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new GetsDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.GetsNode.class)
        private static abstract class GetsBaseNode
        extends KernelNodes.GetsNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            GetsBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelFrozenNode.class)
    public static final class KernelFrozenNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelFrozenNode> {
        private static KernelFrozenNodeFactory kernelFrozenNodeFactoryInstance;

        private KernelFrozenNodeFactory() {
            super(KernelNodes.KernelFrozenNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelFrozenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelFrozenNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.KernelFrozenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return KernelFrozenObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.KernelFrozenNode> getInstance() {
            if (kernelFrozenNodeFactoryInstance == null) {
                kernelFrozenNodeFactoryInstance = new KernelFrozenNodeFactory();
            }
            return kernelFrozenNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.KernelFrozenNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KernelFrozenObjectNode
        extends KernelFrozenBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KernelFrozenObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            KernelFrozenObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.isFrozen(arguments0Value);
            }

            static KernelNodes.KernelFrozenNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new KernelFrozenObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.KernelFrozenNode.class)
        private static abstract class KernelFrozenBaseNode
        extends KernelNodes.KernelFrozenNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            KernelFrozenBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((KernelFrozenBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelFreezeNode.class)
    public static final class KernelFreezeNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelFreezeNode> {
        private static KernelFreezeNodeFactory kernelFreezeNodeFactoryInstance;

        private KernelFreezeNodeFactory() {
            super(KernelNodes.KernelFreezeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelFreezeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelFreezeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.KernelFreezeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return KernelFreezeObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.KernelFreezeNode> getInstance() {
            if (kernelFreezeNodeFactoryInstance == null) {
                kernelFreezeNodeFactoryInstance = new KernelFreezeNodeFactory();
            }
            return kernelFreezeNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.KernelFreezeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KernelFreezeObjectNode
        extends KernelFreezeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KernelFreezeObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            KernelFreezeObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.freeze(arguments0Value);
            }

            static KernelNodes.KernelFreezeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new KernelFreezeObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.KernelFreezeNode.class)
        private static abstract class KernelFreezeBaseNode
        extends KernelNodes.KernelFreezeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            KernelFreezeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((KernelFreezeBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ForkNode.class)
    public static final class ForkNodeFactory
    extends NodeFactoryBase<KernelNodes.ForkNode> {
        private static ForkNodeFactory forkNodeFactoryInstance;

        private ForkNodeFactory() {
            super(KernelNodes.ForkNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ForkNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ForkNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.ForkNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ForkUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.ForkNode> getInstance() {
            if (forkNodeFactoryInstance == null) {
                forkNodeFactoryInstance = new ForkNodeFactory();
            }
            return forkNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.ForkNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ForkPolymorphicNode
        extends ForkBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ForkPolymorphicNode(ForkBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.ForkNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ForkObjectArrayNode
        extends ForkBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ForkObjectArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

            ForkObjectArrayNode(ForkBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof Object[]");
                }
                return super.fork(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    Object[] arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments0Value);
                    return super.fork(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ForkNode create0(KernelNodes.ForkNode current) {
                return new ForkObjectArrayNode((ForkBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ForkNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ForkUninitializedNode
        extends ForkBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ForkUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ForkUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ForkUninitializedNode(ForkBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ForkBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ForkBaseNode rootNode = (ForkBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ForkBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ForkNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ForkUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.ForkNode.class)
        private static abstract class ForkBaseNode
        extends KernelNodes.ForkNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ForkBaseNode next0;

            ForkBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ForkBaseNode(ForkBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ForkBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ForkBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ForkUninitializedNode(this);
                    ((ForkUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ForkBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ForkBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ForkBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ForkUninitializedNode(this), (Node)new ForkPolymorphicNode(this), (DSLNode)((ForkBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ForkBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    return (ForkBaseNode)ForkObjectArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ForkBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ForkBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ExitBangNode.class)
    public static final class ExitBangNodeFactory
    extends NodeFactoryBase<KernelNodes.ExitBangNode> {
        private static ExitBangNodeFactory exitBangNodeFactoryInstance;

        private ExitBangNodeFactory() {
            super(KernelNodes.ExitBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ExitBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExitBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.ExitBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExitBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.ExitBangNode> getInstance() {
            if (exitBangNodeFactoryInstance == null) {
                exitBangNodeFactoryInstance = new ExitBangNodeFactory();
            }
            return exitBangNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.ExitBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExitBangPolymorphicNode
        extends ExitBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ExitBangPolymorphicNode(ExitBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == UndefinedPlaceholder.class ? this.arguments[0].executeUndefinedPlaceholder(frameValue) : (this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.ExitBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExitBangIntNode
        extends ExitBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExitBangIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ExitBangIntNode(ExitBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.exit(arguments0Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.exit(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ExitBangNode create0(KernelNodes.ExitBangNode current) {
                return new ExitBangIntNode((ExitBangBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ExitBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExitBangUndefinedPlaceholderNode
        extends ExitBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExitBangUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{UndefinedPlaceholder.class}, 0, 0);

            ExitBangUndefinedPlaceholderNode(ExitBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof UndefinedPlaceholder");
                }
                return super.exit(arguments0Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    UndefinedPlaceholder arguments0ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments0Value);
                    return super.exit(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ExitBangNode create0(KernelNodes.ExitBangNode current) {
                return new ExitBangUndefinedPlaceholderNode((ExitBangBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ExitBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExitBangUninitializedNode
        extends ExitBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExitBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExitBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExitBangUninitializedNode(ExitBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyNilClass executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyNilClass executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ExitBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ExitBangBaseNode rootNode = (ExitBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ExitBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ExitBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExitBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.ExitBangNode.class)
        private static abstract class ExitBangBaseNode
        extends KernelNodes.ExitBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExitBangBaseNode next0;

            ExitBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExitBangBaseNode(ExitBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyNilClass executeChained0(VirtualFrame var1, Object var2);

            protected final RubyNilClass rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ExitBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExitBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ExitBangUninitializedNode(this);
                    ((ExitBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ExitBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ExitBangBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ExitBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ExitBangUninitializedNode(this), (Node)new ExitBangPolymorphicNode(this), (DSLNode)((ExitBangBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExitBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    return (ExitBangBaseNode)ExitBangUndefinedPlaceholderNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ExitBangBaseNode)ExitBangIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ExitBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ExitBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ExitNode.class)
    public static final class ExitNodeFactory
    extends NodeFactoryBase<KernelNodes.ExitNode> {
        private static ExitNodeFactory exitNodeFactoryInstance;

        private ExitNodeFactory() {
            super(KernelNodes.ExitNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ExitNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExitNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.ExitNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExitUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.ExitNode> getInstance() {
            if (exitNodeFactoryInstance == null) {
                exitNodeFactoryInstance = new ExitNodeFactory();
            }
            return exitNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.ExitNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExitPolymorphicNode
        extends ExitBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ExitPolymorphicNode(ExitBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == UndefinedPlaceholder.class ? this.arguments[0].executeUndefinedPlaceholder(frameValue) : (this.arguments0PolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.arguments[0].executeBoolean(frameValue)) : (this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : this.arguments[0].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.ExitNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExitBooleanNode
        extends ExitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExitBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

            ExitBooleanNode(ExitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof boolean");
                }
                return super.exit(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(arguments0Value)) {
                    boolean arguments0ValueCast = RubyTypesGen.RUBYTYPES.asBoolean(arguments0Value);
                    return super.exit(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ExitNode create0(KernelNodes.ExitNode current) {
                return new ExitBooleanNode((ExitBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ExitNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExitIntNode
        extends ExitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExitIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            ExitIntNode(ExitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.exit(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.exit(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ExitNode create0(KernelNodes.ExitNode current) {
                return new ExitIntNode((ExitBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ExitNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExitUndefinedPlaceholderNode
        extends ExitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExitUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{UndefinedPlaceholder.class}, 0, 0);

            ExitUndefinedPlaceholderNode(ExitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof UndefinedPlaceholder");
                }
                return super.exit(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    UndefinedPlaceholder arguments0ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments0Value);
                    return super.exit(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ExitNode create0(KernelNodes.ExitNode current) {
                return new ExitUndefinedPlaceholderNode((ExitBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ExitNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExitUninitializedNode
        extends ExitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExitUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExitUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExitUninitializedNode(ExitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ExitBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ExitBaseNode rootNode = (ExitBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ExitBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ExitNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExitUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.ExitNode.class)
        private static abstract class ExitBaseNode
        extends KernelNodes.ExitNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExitBaseNode next0;

            ExitBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExitBaseNode(ExitBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ExitBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExitBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ExitUninitializedNode(this);
                    ((ExitUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ExitBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ExitBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ExitBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ExitUninitializedNode(this), (Node)new ExitPolymorphicNode(this), (DSLNode)((ExitBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExitBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    return (ExitBaseNode)ExitUndefinedPlaceholderNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (ExitBaseNode)ExitIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isBoolean(arguments0Value)) {
                    return (ExitBaseNode)ExitBooleanNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ExitBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ExitBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.ExecNode.class)
    public static final class ExecNodeFactory
    extends NodeFactoryBase<KernelNodes.ExecNode> {
        private static ExecNodeFactory execNodeFactoryInstance;

        private ExecNodeFactory() {
            super(KernelNodes.ExecNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.ExecNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ExecNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.ExecNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ExecUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.ExecNode> getInstance() {
            if (execNodeFactoryInstance == null) {
                execNodeFactoryInstance = new ExecNodeFactory();
            }
            return execNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.ExecNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ExecPolymorphicNode
        extends ExecBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ExecPolymorphicNode(ExecBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.ExecNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ExecObjectArrayNode
        extends ExecBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExecObjectArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

            ExecObjectArrayNode(ExecBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof Object[]");
                }
                return super.require(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    Object[] arguments0ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments0Value);
                    return super.require(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ExecNode create0(KernelNodes.ExecNode current) {
                return new ExecObjectArrayNode((ExecBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.ExecNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ExecUninitializedNode
        extends ExecBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ExecUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ExecUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ExecUninitializedNode(ExecBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ExecBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ExecBaseNode rootNode = (ExecBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ExecBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.ExecNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ExecUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.ExecNode.class)
        private static abstract class ExecBaseNode
        extends KernelNodes.ExecNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ExecBaseNode next0;

            ExecBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ExecBaseNode(ExecBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                ExecBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ExecBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ExecUninitializedNode(this);
                    ((ExecUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ExecBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ExecBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (ExecBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ExecUninitializedNode(this), (Node)new ExecPolymorphicNode(this), (DSLNode)((ExecBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ExecBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments0Value)) {
                    return (ExecBaseNode)ExecObjectArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ExecBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ExecBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.EvalNode.class)
    public static final class EvalNodeFactory
    extends NodeFactoryBase<KernelNodes.EvalNode> {
        private static EvalNodeFactory evalNodeFactoryInstance;

        private EvalNodeFactory() {
            super(KernelNodes.EvalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        public KernelNodes.EvalNode createNode(Object ... arguments) {
            if (!(arguments.length != 6 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode) || arguments[5] != null && !(arguments[5] instanceof RubyNode))) {
                return EvalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]), (RubyNode)((Object)arguments[5]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.EvalNode create(RubyContext context, SourceSection sourceSection, RubyNode source, RubyNode binding, RubyNode filename, RubyNode lineNumber) {
            return EvalUninitializedNode.create0(context, sourceSection, source, binding, filename, lineNumber);
        }

        public static NodeFactory<KernelNodes.EvalNode> getInstance() {
            if (evalNodeFactoryInstance == null) {
                evalNodeFactoryInstance = new EvalNodeFactory();
            }
            return evalNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EvalPolymorphicNode
        extends EvalBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> sourcePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> bindingPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> filenamePolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> lineNumberPolymorphicType;

            EvalPolymorphicNode(EvalBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object lineNumberValue;
                Object filenameValue;
                Object bindingValue;
                Object sourceValue = this.source.execute(frameValue);
                try {
                    bindingValue = this.bindingPolymorphicType == UndefinedPlaceholder.class ? this.binding.executeUndefinedPlaceholder(frameValue) : (this.bindingPolymorphicType == RubyBinding.class ? this.binding.executeRubyBinding(frameValue) : (this.bindingPolymorphicType == RubyNilClass.class ? this.binding.executeRubyNilClass(frameValue) : (this.bindingPolymorphicType == RubyBasicObject.class ? this.binding.executeRubyBasicObject(frameValue) : this.binding.execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue2 = this.filename.execute(frameValue);
                    Object lineNumberValue2 = this.lineNumber.execute(frameValue);
                    this.bindingPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, sourceValue, ex.getResult(), filenameValue2, lineNumberValue2);
                }
                try {
                    filenameValue = this.filenamePolymorphicType == UndefinedPlaceholder.class ? this.filename.executeUndefinedPlaceholder(frameValue) : (this.filenamePolymorphicType == RubyString.class ? this.filename.executeRubyString(frameValue) : this.filename.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object lineNumberValue3 = this.lineNumber.execute(frameValue);
                    this.filenamePolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, sourceValue, bindingValue, ex.getResult(), lineNumberValue3);
                }
                try {
                    lineNumberValue = this.lineNumberPolymorphicType == UndefinedPlaceholder.class ? this.lineNumber.executeUndefinedPlaceholder(frameValue) : (this.lineNumberPolymorphicType == Integer.TYPE ? Integer.valueOf(this.lineNumber.executeIntegerFixnum(frameValue)) : this.lineNumber.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.lineNumberPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.sourcePolymorphicType = types[0];
                this.bindingPolymorphicType = types[1];
                this.filenamePolymorphicType = types[2];
                this.lineNumberPolymorphicType = types[3];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                return this.next0.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EvalRubyStringRubyBasicObjectUndefinedPlaceholderUndefinedPlaceholderNode
        extends EvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EvalRubyStringRubyBasicObjectUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyBasicObject.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            EvalRubyStringRubyBasicObjectUndefinedPlaceholderUndefinedPlaceholderNode(EvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder lineNumberValue;
                UndefinedPlaceholder filenameValue;
                RubyBasicObject bindingValue;
                RubyString sourceValue;
                try {
                    sourceValue = this.source.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object bindingValue2 = this.binding.execute(frameValue);
                    Object filenameValue2 = this.filename.execute(frameValue);
                    Object lineNumberValue2 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), bindingValue2, filenameValue2, lineNumberValue2, "Expected sourceValue instanceof RubyString");
                }
                try {
                    bindingValue = this.binding.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue3 = this.filename.execute(frameValue);
                    Object lineNumberValue3 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, ex.getResult(), filenameValue3, lineNumberValue3, "Expected bindingValue instanceof RubyBasicObject");
                }
                try {
                    filenameValue = this.filename.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object lineNumberValue4 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, bindingValue, ex.getResult(), lineNumberValue4, "Expected filenameValue instanceof UndefinedPlaceholder");
                }
                try {
                    lineNumberValue = this.lineNumber.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, sourceValue, bindingValue, filenameValue, ex.getResult(), "Expected lineNumberValue instanceof UndefinedPlaceholder");
                }
                if (!super.isRubyBinding(bindingValue)) {
                    return super.eval(sourceValue, bindingValue, filenameValue, lineNumberValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue, "One of guards [!isRubyBinding] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(sourceValue) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(bindingValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(filenameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(lineNumberValue)) {
                    RubyString sourceValueCast = RubyTypesGen.RUBYTYPES.asRubyString(sourceValue);
                    RubyBasicObject bindingValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(bindingValue);
                    UndefinedPlaceholder filenameValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(filenameValue);
                    UndefinedPlaceholder lineNumberValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(lineNumberValue);
                    if (!super.isRubyBinding(bindingValue)) {
                        return super.eval(sourceValueCast, bindingValueCast, filenameValueCast, lineNumberValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            static KernelNodes.EvalNode create0(KernelNodes.EvalNode current) {
                return new EvalRubyStringRubyBasicObjectUndefinedPlaceholderUndefinedPlaceholderNode((EvalBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EvalRubyStringRubyBindingRubyStringIntNode
        extends EvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EvalRubyStringRubyBindingRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyBinding.class, RubyString.class, Integer.TYPE}, 0, 0);

            EvalRubyStringRubyBindingRubyStringIntNode(EvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int lineNumberValue;
                RubyString filenameValue;
                RubyBinding bindingValue;
                RubyString sourceValue;
                try {
                    sourceValue = this.source.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object bindingValue2 = this.binding.execute(frameValue);
                    Object filenameValue2 = this.filename.execute(frameValue);
                    Object lineNumberValue2 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), bindingValue2, filenameValue2, lineNumberValue2, "Expected sourceValue instanceof RubyString");
                }
                try {
                    bindingValue = this.binding.executeRubyBinding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue3 = this.filename.execute(frameValue);
                    Object lineNumberValue3 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, ex.getResult(), filenameValue3, lineNumberValue3, "Expected bindingValue instanceof RubyBinding");
                }
                try {
                    filenameValue = this.filename.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object lineNumberValue4 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, bindingValue, ex.getResult(), lineNumberValue4, "Expected filenameValue instanceof RubyString");
                }
                try {
                    lineNumberValue = this.lineNumber.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, sourceValue, bindingValue, filenameValue, ex.getResult(), "Expected lineNumberValue instanceof int");
                }
                return super.eval(sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(sourceValue) && RubyTypesGen.RUBYTYPES.isRubyBinding(bindingValue) && RubyTypesGen.RUBYTYPES.isRubyString(filenameValue) && RubyTypesGen.RUBYTYPES.isInteger(lineNumberValue)) {
                    RubyString sourceValueCast = RubyTypesGen.RUBYTYPES.asRubyString(sourceValue);
                    RubyBinding bindingValueCast = RubyTypesGen.RUBYTYPES.asRubyBinding(bindingValue);
                    RubyString filenameValueCast = RubyTypesGen.RUBYTYPES.asRubyString(filenameValue);
                    int lineNumberValueCast = RubyTypesGen.RUBYTYPES.asInteger(lineNumberValue);
                    return super.eval(sourceValueCast, bindingValueCast, filenameValueCast, lineNumberValueCast);
                }
                return this.next0.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            static KernelNodes.EvalNode create0(KernelNodes.EvalNode current) {
                return new EvalRubyStringRubyBindingRubyStringIntNode((EvalBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EvalRubyStringRubyBindingRubyStringUndefinedPlaceholderNode
        extends EvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EvalRubyStringRubyBindingRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyBinding.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            EvalRubyStringRubyBindingRubyStringUndefinedPlaceholderNode(EvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder lineNumberValue;
                RubyString filenameValue;
                RubyBinding bindingValue;
                RubyString sourceValue;
                try {
                    sourceValue = this.source.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object bindingValue2 = this.binding.execute(frameValue);
                    Object filenameValue2 = this.filename.execute(frameValue);
                    Object lineNumberValue2 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), bindingValue2, filenameValue2, lineNumberValue2, "Expected sourceValue instanceof RubyString");
                }
                try {
                    bindingValue = this.binding.executeRubyBinding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue3 = this.filename.execute(frameValue);
                    Object lineNumberValue3 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, ex.getResult(), filenameValue3, lineNumberValue3, "Expected bindingValue instanceof RubyBinding");
                }
                try {
                    filenameValue = this.filename.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object lineNumberValue4 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, bindingValue, ex.getResult(), lineNumberValue4, "Expected filenameValue instanceof RubyString");
                }
                try {
                    lineNumberValue = this.lineNumber.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, sourceValue, bindingValue, filenameValue, ex.getResult(), "Expected lineNumberValue instanceof UndefinedPlaceholder");
                }
                return super.eval(sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(sourceValue) && RubyTypesGen.RUBYTYPES.isRubyBinding(bindingValue) && RubyTypesGen.RUBYTYPES.isRubyString(filenameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(lineNumberValue)) {
                    RubyString sourceValueCast = RubyTypesGen.RUBYTYPES.asRubyString(sourceValue);
                    RubyBinding bindingValueCast = RubyTypesGen.RUBYTYPES.asRubyBinding(bindingValue);
                    RubyString filenameValueCast = RubyTypesGen.RUBYTYPES.asRubyString(filenameValue);
                    UndefinedPlaceholder lineNumberValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(lineNumberValue);
                    return super.eval(sourceValueCast, bindingValueCast, filenameValueCast, lineNumberValueCast);
                }
                return this.next0.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            static KernelNodes.EvalNode create0(KernelNodes.EvalNode current) {
                return new EvalRubyStringRubyBindingRubyStringUndefinedPlaceholderNode((EvalBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EvalRubyStringRubyBindingUndefinedPlaceholderUndefinedPlaceholderNode
        extends EvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EvalRubyStringRubyBindingUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyBinding.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            EvalRubyStringRubyBindingUndefinedPlaceholderUndefinedPlaceholderNode(EvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder lineNumberValue;
                UndefinedPlaceholder filenameValue;
                RubyBinding bindingValue;
                RubyString sourceValue;
                try {
                    sourceValue = this.source.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object bindingValue2 = this.binding.execute(frameValue);
                    Object filenameValue2 = this.filename.execute(frameValue);
                    Object lineNumberValue2 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), bindingValue2, filenameValue2, lineNumberValue2, "Expected sourceValue instanceof RubyString");
                }
                try {
                    bindingValue = this.binding.executeRubyBinding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue3 = this.filename.execute(frameValue);
                    Object lineNumberValue3 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, ex.getResult(), filenameValue3, lineNumberValue3, "Expected bindingValue instanceof RubyBinding");
                }
                try {
                    filenameValue = this.filename.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object lineNumberValue4 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, bindingValue, ex.getResult(), lineNumberValue4, "Expected filenameValue instanceof UndefinedPlaceholder");
                }
                try {
                    lineNumberValue = this.lineNumber.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, sourceValue, bindingValue, filenameValue, ex.getResult(), "Expected lineNumberValue instanceof UndefinedPlaceholder");
                }
                return super.eval(sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(sourceValue) && RubyTypesGen.RUBYTYPES.isRubyBinding(bindingValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(filenameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(lineNumberValue)) {
                    RubyString sourceValueCast = RubyTypesGen.RUBYTYPES.asRubyString(sourceValue);
                    RubyBinding bindingValueCast = RubyTypesGen.RUBYTYPES.asRubyBinding(bindingValue);
                    UndefinedPlaceholder filenameValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(filenameValue);
                    UndefinedPlaceholder lineNumberValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(lineNumberValue);
                    return super.eval(sourceValueCast, bindingValueCast, filenameValueCast, lineNumberValueCast);
                }
                return this.next0.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            static KernelNodes.EvalNode create0(KernelNodes.EvalNode current) {
                return new EvalRubyStringRubyBindingUndefinedPlaceholderUndefinedPlaceholderNode((EvalBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EvalRubyStringRubyNilClassRubyStringIntNode
        extends EvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EvalRubyStringRubyNilClassRubyStringIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, RubyNilClass.class, RubyString.class, Integer.TYPE}, 0, 0);

            EvalRubyStringRubyNilClassRubyStringIntNode(EvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int lineNumberValue;
                RubyString filenameValue;
                RubyNilClass bindingValue;
                RubyString sourceValue;
                try {
                    sourceValue = this.source.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object bindingValue2 = this.binding.execute(frameValue);
                    Object filenameValue2 = this.filename.execute(frameValue);
                    Object lineNumberValue2 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), bindingValue2, filenameValue2, lineNumberValue2, "Expected sourceValue instanceof RubyString");
                }
                try {
                    bindingValue = this.binding.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue3 = this.filename.execute(frameValue);
                    Object lineNumberValue3 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, ex.getResult(), filenameValue3, lineNumberValue3, "Expected bindingValue instanceof RubyNilClass");
                }
                try {
                    filenameValue = this.filename.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object lineNumberValue4 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, bindingValue, ex.getResult(), lineNumberValue4, "Expected filenameValue instanceof RubyString");
                }
                try {
                    lineNumberValue = this.lineNumber.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, sourceValue, bindingValue, filenameValue, ex.getResult(), "Expected lineNumberValue instanceof int");
                }
                return super.eval(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(sourceValue) && RubyTypesGen.RUBYTYPES.isRubyNilClass(bindingValue) && RubyTypesGen.RUBYTYPES.isRubyString(filenameValue) && RubyTypesGen.RUBYTYPES.isInteger(lineNumberValue)) {
                    RubyString sourceValueCast = RubyTypesGen.RUBYTYPES.asRubyString(sourceValue);
                    RubyNilClass bindingValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(bindingValue);
                    RubyString filenameValueCast = RubyTypesGen.RUBYTYPES.asRubyString(filenameValue);
                    int lineNumberValueCast = RubyTypesGen.RUBYTYPES.asInteger(lineNumberValue);
                    return super.eval(frameValue, sourceValueCast, bindingValueCast, filenameValueCast, lineNumberValueCast);
                }
                return this.next0.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            static KernelNodes.EvalNode create0(KernelNodes.EvalNode current) {
                return new EvalRubyStringRubyNilClassRubyStringIntNode((EvalBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EvalRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode
        extends EvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EvalRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            EvalRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode(EvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder lineNumberValue;
                UndefinedPlaceholder filenameValue;
                UndefinedPlaceholder bindingValue;
                RubyString sourceValue;
                try {
                    sourceValue = this.source.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object bindingValue2 = this.binding.execute(frameValue);
                    Object filenameValue2 = this.filename.execute(frameValue);
                    Object lineNumberValue2 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), bindingValue2, filenameValue2, lineNumberValue2, "Expected sourceValue instanceof RubyString");
                }
                try {
                    bindingValue = this.binding.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object filenameValue3 = this.filename.execute(frameValue);
                    Object lineNumberValue3 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, ex.getResult(), filenameValue3, lineNumberValue3, "Expected bindingValue instanceof UndefinedPlaceholder");
                }
                try {
                    filenameValue = this.filename.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object lineNumberValue4 = this.lineNumber.execute(frameValue);
                    return this.rewrite0(frameValue, sourceValue, bindingValue, ex.getResult(), lineNumberValue4, "Expected filenameValue instanceof UndefinedPlaceholder");
                }
                try {
                    lineNumberValue = this.lineNumber.executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, sourceValue, bindingValue, filenameValue, ex.getResult(), "Expected lineNumberValue instanceof UndefinedPlaceholder");
                }
                return super.eval(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(sourceValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(bindingValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(filenameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(lineNumberValue)) {
                    RubyString sourceValueCast = RubyTypesGen.RUBYTYPES.asRubyString(sourceValue);
                    UndefinedPlaceholder bindingValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(bindingValue);
                    UndefinedPlaceholder filenameValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(filenameValue);
                    UndefinedPlaceholder lineNumberValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(lineNumberValue);
                    return super.eval(frameValue, sourceValueCast, bindingValueCast, filenameValueCast, lineNumberValueCast);
                }
                return this.next0.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            static KernelNodes.EvalNode create0(KernelNodes.EvalNode current) {
                return new EvalRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode((EvalBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EvalUninitializedNode
        extends EvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EvalUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EvalUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode source, RubyNode binding, RubyNode filename, RubyNode lineNumber) {
                super(context, sourceSection, source, binding, filename, lineNumber);
            }

            EvalUninitializedNode(EvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object sourceValue = this.source.execute(frameValue);
                Object bindingValue = this.binding.execute(frameValue);
                Object filenameValue = this.filename.execute(frameValue);
                Object lineNumberValue = this.lineNumber.execute(frameValue);
                return this.executeUninitialized0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                EvalBaseNode newNode = this.specialize0(sourceValue, bindingValue, filenameValue, lineNumberValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EvalBaseNode rootNode = (EvalBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.source, rootNode.binding, rootNode.filename, rootNode.lineNumber}, new Object[]{sourceValue, bindingValue, filenameValue, lineNumberValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EvalBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            static KernelNodes.EvalNode create0(RubyContext context, SourceSection sourceSection, RubyNode source, RubyNode binding, RubyNode filename, RubyNode lineNumber) {
                return new EvalUninitializedNode(context, sourceSection, source, binding, filename, lineNumber);
            }
        }

        @GeneratedBy(value=KernelNodes.EvalNode.class)
        private static abstract class EvalBaseNode
        extends KernelNodes.EvalNode
        implements DSLNode {
            @Node.Child
            protected RubyNode source;
            @Node.Child
            protected RubyNode binding;
            @Node.Child
            protected RubyNode filename;
            @Node.Child
            protected RubyNode lineNumber;
            @Node.Child
            protected EvalBaseNode next0;

            EvalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode source, RubyNode binding, RubyNode filename, RubyNode lineNumber) {
                super(context, sourceSection);
                this.source = super.coerceSourceToString(source);
                this.binding = binding;
                this.filename = filename;
                this.lineNumber = lineNumber;
            }

            EvalBaseNode(EvalBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final Object rewrite0(VirtualFrame frameValue, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue, String reason) {
                String message;
                EvalBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EvalBaseNode newNode = this.specialize0(sourceValue, bindingValue, filenameValue, lineNumberValue);
                if (newNode == null) {
                    newNode = new EvalUninitializedNode(this);
                    ((EvalUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EvalBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EvalBaseNode.createInfo0(reason, sourceValue, bindingValue, filenameValue, lineNumberValue)))) == null) {
                    returnNode = (EvalBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EvalUninitializedNode(this), (Node)new EvalPolymorphicNode(this), (DSLNode)((EvalBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, sourceValue, bindingValue, filenameValue, lineNumberValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EvalBaseNode specialize0(Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(sourceValue)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(bindingValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(filenameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(lineNumberValue)) {
                        return (EvalBaseNode)EvalRubyStringUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyNilClass(bindingValue) && RubyTypesGen.RUBYTYPES.isRubyString(filenameValue) && RubyTypesGen.RUBYTYPES.isInteger(lineNumberValue)) {
                        return (EvalBaseNode)EvalRubyStringRubyNilClassRubyStringIntNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBinding(bindingValue)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(lineNumberValue)) {
                            if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(filenameValue)) {
                                return (EvalBaseNode)EvalRubyStringRubyBindingUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isRubyString(filenameValue)) {
                                return (EvalBaseNode)EvalRubyStringRubyBindingRubyStringUndefinedPlaceholderNode.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyString(filenameValue) && RubyTypesGen.RUBYTYPES.isInteger(lineNumberValue)) {
                            return (EvalBaseNode)EvalRubyStringRubyBindingRubyStringIntNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(bindingValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(filenameValue) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(lineNumberValue) && !super.isRubyBinding(bindingValue)) {
                        return (EvalBaseNode)EvalRubyStringRubyBasicObjectUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.source = null;
                    this.binding = null;
                    this.filename = null;
                    this.lineNumber = null;
                } else {
                    EvalBaseNode otherCast = (EvalBaseNode)other;
                    this.source = otherCast.source;
                    this.binding = otherCast.binding;
                    this.filename = otherCast.filename;
                    this.lineNumber = otherCast.lineNumber;
                }
                this.next0 = newNext == null ? null : (EvalBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object sourceValue, Object bindingValue, Object filenameValue, Object lineNumberValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("sourceValue").append(" = ").append(sourceValue);
                    if (sourceValue != null) {
                        builder.append(" (").append(sourceValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("bindingValue").append(" = ").append(bindingValue);
                    if (bindingValue != null) {
                        builder.append(" (").append(bindingValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("filenameValue").append(" = ").append(filenameValue);
                    if (filenameValue != null) {
                        builder.append(" (").append(filenameValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("lineNumberValue").append(" = ").append(lineNumberValue);
                    if (lineNumberValue != null) {
                        builder.append(" (").append(lineNumberValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.DupNode.class)
    public static final class DupNodeFactory
    extends NodeFactoryBase<KernelNodes.DupNode> {
        private static DupNodeFactory dupNodeFactoryInstance;

        private DupNodeFactory() {
            super(KernelNodes.DupNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.DupNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DupNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.DupNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DupUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.DupNode> getInstance() {
            if (dupNodeFactoryInstance == null) {
                dupNodeFactoryInstance = new DupNodeFactory();
            }
            return dupNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.DupNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DupPolymorphicNode
        extends DupBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            DupPolymorphicNode(DupBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.DupNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DupRubyBasicObjectNode
        extends DupBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DupRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            DupRubyBasicObjectNode(DupBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBasicObject");
                }
                return super.dup(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    return super.dup(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.DupNode create0(KernelNodes.DupNode current) {
                return new DupRubyBasicObjectNode((DupBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.DupNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DupUninitializedNode
        extends DupBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DupUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DupUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DupUninitializedNode(DupBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                DupBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DupBaseNode rootNode = (DupBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DupBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.DupNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DupUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.DupNode.class)
        private static abstract class DupBaseNode
        extends KernelNodes.DupNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DupBaseNode next0;

            DupBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DupBaseNode(DupBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                DupBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DupBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new DupUninitializedNode(this);
                    ((DupUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DupBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DupBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (DupBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DupUninitializedNode(this), (Node)new DupPolymorphicNode(this), (DSLNode)((DupBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DupBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    return (DupBaseNode)DupRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((DupBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (DupBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CloneNode.class)
    public static final class CloneNodeFactory
    extends NodeFactoryBase<KernelNodes.CloneNode> {
        private static CloneNodeFactory cloneNodeFactoryInstance;

        private CloneNodeFactory() {
            super(KernelNodes.CloneNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.CloneNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CloneNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.CloneNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CloneUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.CloneNode> getInstance() {
            if (cloneNodeFactoryInstance == null) {
                cloneNodeFactoryInstance = new CloneNodeFactory();
            }
            return cloneNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.CloneNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClonePolymorphicNode
        extends CloneBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ClonePolymorphicNode(CloneBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.CloneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CloneRubyBasicObjectNode
        extends CloneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CloneRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            CloneRubyBasicObjectNode(CloneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBasicObject");
                }
                return super.clone(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    RubyBasicObject arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(arguments0Value);
                    return super.clone(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.CloneNode create0(KernelNodes.CloneNode current) {
                return new CloneRubyBasicObjectNode((CloneBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.CloneNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CloneUninitializedNode
        extends CloneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CloneUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CloneUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CloneUninitializedNode(CloneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CloneBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CloneBaseNode rootNode = (CloneBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CloneBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.CloneNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CloneUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.CloneNode.class)
        private static abstract class CloneBaseNode
        extends KernelNodes.CloneNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CloneBaseNode next0;

            CloneBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CloneBaseNode(CloneBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                CloneBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CloneBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CloneUninitializedNode(this);
                    ((CloneUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CloneBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CloneBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (CloneBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CloneUninitializedNode(this), (Node)new ClonePolymorphicNode(this), (DSLNode)((CloneBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CloneBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(arguments0Value)) {
                    return (CloneBaseNode)CloneRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CloneBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CloneBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CopyNode.class)
    public static final class CopyNodeFactory
    extends NodeFactoryBase<KernelNodes.CopyNode> {
        private static CopyNodeFactory copyNodeFactoryInstance;

        private CopyNodeFactory() {
            super(KernelNodes.CopyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public KernelNodes.CopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return CopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.CopyNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return CopyUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<KernelNodes.CopyNode> getInstance() {
            if (copyNodeFactoryInstance == null) {
                copyNodeFactoryInstance = new CopyNodeFactory();
            }
            return copyNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.CopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CopyPolymorphicNode
        extends CopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            CopyPolymorphicNode(CopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public RubyBasicObject executeCopy(VirtualFrame frameValue, RubyBasicObject operandValueEvaluated) {
                RubyBasicObject operandValue = operandValueEvaluated;
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=KernelNodes.CopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CopyRubyBasicObjectNode
        extends CopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CopyRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

            CopyRubyBasicObjectNode(CopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject operandValue;
                try {
                    operandValue = this.operand.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof RubyBasicObject");
                }
                return super.copy(frameValue, operandValue);
            }

            @Override
            public RubyBasicObject executeCopy(VirtualFrame frameValue, RubyBasicObject operandValueEvaluated) {
                RubyBasicObject operandValue = operandValueEvaluated;
                return super.copy(frameValue, operandValue);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    RubyBasicObject operandValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(operandValue);
                    return super.copy(frameValue, operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static KernelNodes.CopyNode create0(KernelNodes.CopyNode current) {
                return new CopyRubyBasicObjectNode((CopyBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.CopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CopyUninitializedNode
        extends CopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            CopyUninitializedNode(CopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBasicObject value;
                try {
                    value = this.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            public RubyBasicObject executeCopy(VirtualFrame frameValue, RubyBasicObject operandValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyBasicObject operandValue = operandValueEvaluated;
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected RubyBasicObject executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected RubyBasicObject executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                CopyBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CopyBaseNode rootNode = (CopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.operand}, new Object[]{operandValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, operandValue);
            }

            static KernelNodes.CopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new CopyUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=KernelNodes.CopyNode.class)
        private static abstract class CopyBaseNode
        extends KernelNodes.CopyNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected CopyBaseNode next0;

            CopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = operand;
            }

            CopyBaseNode(CopyBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract RubyBasicObject executeChained0(VirtualFrame var1, Object var2);

            protected final RubyBasicObject rewrite0(VirtualFrame frameValue, Object operandValue, String reason) {
                String message;
                CopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CopyBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new CopyUninitializedNode(this);
                    ((CopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CopyBaseNode.createInfo0(reason, operandValue)))) == null) {
                    returnNode = (CopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CopyUninitializedNode(this), (Node)new CopyPolymorphicNode(this), (DSLNode)((CopyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CopyBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(operandValue)) {
                    return (CopyBaseNode)CopyRubyBasicObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((CopyBaseNode)other).operand;
                this.next0 = newNext == null ? null : (CopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.KernelClassNode.class)
    public static final class KernelClassNodeFactory
    extends NodeFactoryBase<KernelNodes.KernelClassNode> {
        private static KernelClassNodeFactory kernelClassNodeFactoryInstance;

        private KernelClassNodeFactory() {
            super(KernelNodes.KernelClassNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.KernelClassNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return KernelClassNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.KernelClassNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return KernelClassObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.KernelClassNode> getInstance() {
            if (kernelClassNodeFactoryInstance == null) {
                kernelClassNodeFactoryInstance = new KernelClassNodeFactory();
            }
            return kernelClassNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.KernelClassNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class KernelClassObjectNode
        extends KernelClassBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(KernelClassObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            KernelClassObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyClass value;
                try {
                    value = this.executeRubyClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyClass executeRubyClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.getClass(arguments0Value);
            }

            static KernelNodes.KernelClassNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new KernelClassObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.KernelClassNode.class)
        private static abstract class KernelClassBaseNode
        extends KernelNodes.KernelClassNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            KernelClassBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((KernelClassBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CallerNode.class)
    public static final class CallerNodeFactory
    extends NodeFactoryBase<KernelNodes.CallerNode> {
        private static CallerNodeFactory callerNodeFactoryInstance;

        private CallerNodeFactory() {
            super(KernelNodes.CallerNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.CallerNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CallerNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.CallerNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CallerUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.CallerNode> getInstance() {
            if (callerNodeFactoryInstance == null) {
                callerNodeFactoryInstance = new CallerNodeFactory();
            }
            return callerNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.CallerNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CallerPolymorphicNode
        extends CallerBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CallerPolymorphicNode(CallerBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value;
                try {
                    arguments0Value = this.arguments0PolymorphicType == UndefinedPlaceholder.class ? this.arguments[0].executeUndefinedPlaceholder(frameValue) : (this.arguments0PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[0].executeIntegerFixnum(frameValue)) : this.arguments[0].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments0PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.CallerNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CallerIntNode
        extends CallerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CallerIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

            CallerIntNode(CallerBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof int");
                }
                return super.caller(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    int arguments0ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments0Value);
                    return super.caller(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.CallerNode create0(KernelNodes.CallerNode current) {
                return new CallerIntNode((CallerBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.CallerNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CallerUndefinedPlaceholderNode
        extends CallerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CallerUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{UndefinedPlaceholder.class}, 0, 0);

            CallerUndefinedPlaceholderNode(CallerBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof UndefinedPlaceholder");
                }
                return super.caller(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    UndefinedPlaceholder arguments0ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments0Value);
                    return super.caller(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.CallerNode create0(KernelNodes.CallerNode current) {
                return new CallerUndefinedPlaceholderNode((CallerBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.CallerNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CallerUninitializedNode
        extends CallerBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CallerUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CallerUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CallerUninitializedNode(CallerBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CallerBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CallerBaseNode rootNode = (CallerBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CallerBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.CallerNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CallerUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.CallerNode.class)
        private static abstract class CallerBaseNode
        extends KernelNodes.CallerNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CallerBaseNode next0;

            CallerBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CallerBaseNode(CallerBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                CallerBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CallerBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CallerUninitializedNode(this);
                    ((CallerUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CallerBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = CallerBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (CallerBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CallerUninitializedNode(this), (Node)new CallerPolymorphicNode(this), (DSLNode)((CallerBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CallerBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments0Value)) {
                    return (CallerBaseNode)CallerUndefinedPlaceholderNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(arguments0Value)) {
                    return (CallerBaseNode)CallerIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CallerBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CallerBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CalleeNameNode.class)
    public static final class CalleeNameNodeFactory
    extends NodeFactoryBase<KernelNodes.CalleeNameNode> {
        private static CalleeNameNodeFactory calleeNameNodeFactoryInstance;

        private CalleeNameNodeFactory() {
            super(KernelNodes.CalleeNameNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.CalleeNameNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CalleeNameNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.CalleeNameNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CalleeNameDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.CalleeNameNode> getInstance() {
            if (calleeNameNodeFactoryInstance == null) {
                calleeNameNodeFactoryInstance = new CalleeNameNodeFactory();
            }
            return calleeNameNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.CalleeNameNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CalleeNameDefaultNode
        extends CalleeNameBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CalleeNameDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            CalleeNameDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol value;
                try {
                    value = this.executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubySymbol executeRubySymbol(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.calleeName(frameValue);
            }

            static KernelNodes.CalleeNameNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CalleeNameDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.CalleeNameNode.class)
        private static abstract class CalleeNameBaseNode
        extends KernelNodes.CalleeNameNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            CalleeNameBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
    public static final class BlockGivenNodeFactory
    extends NodeFactoryBase<KernelNodes.BlockGivenNode> {
        private static BlockGivenNodeFactory blockGivenNodeFactoryInstance;

        private BlockGivenNodeFactory() {
            super(KernelNodes.BlockGivenNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.BlockGivenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BlockGivenNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.BlockGivenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BlockGivenDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.BlockGivenNode> getInstance() {
            if (blockGivenNodeFactoryInstance == null) {
                blockGivenNodeFactoryInstance = new BlockGivenNodeFactory();
            }
            return blockGivenNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BlockGivenDefaultNode
        extends BlockGivenBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BlockGivenDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            BlockGivenDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.blockGiven();
            }

            static KernelNodes.BlockGivenNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BlockGivenDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.BlockGivenNode.class)
        private static abstract class BlockGivenBaseNode
        extends KernelNodes.BlockGivenNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            BlockGivenBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.BindingNode.class)
    public static final class BindingNodeFactory
    extends NodeFactoryBase<KernelNodes.BindingNode> {
        private static BindingNodeFactory bindingNodeFactoryInstance;

        private BindingNodeFactory() {
            super(KernelNodes.BindingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.BindingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BindingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.BindingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BindingDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.BindingNode> getInstance() {
            if (bindingNodeFactoryInstance == null) {
                bindingNodeFactoryInstance = new BindingNodeFactory();
            }
            return bindingNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.BindingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BindingDefaultNode
        extends BindingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BindingDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            BindingDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeRubyBinding(frameValue);
            }

            @Override
            public RubyBinding executeRubyBinding(VirtualFrame frameValue) {
                return super.binding();
            }

            static KernelNodes.BindingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BindingDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.BindingNode.class)
        private static abstract class BindingBaseNode
        extends KernelNodes.BindingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            BindingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.AtExitNode.class)
    public static final class AtExitNodeFactory
    extends NodeFactoryBase<KernelNodes.AtExitNode> {
        private static AtExitNodeFactory atExitNodeFactoryInstance;

        private AtExitNodeFactory() {
            super(KernelNodes.AtExitNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.AtExitNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AtExitNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.AtExitNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AtExitUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.AtExitNode> getInstance() {
            if (atExitNodeFactoryInstance == null) {
                atExitNodeFactoryInstance = new AtExitNodeFactory();
            }
            return atExitNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.AtExitNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AtExitPolymorphicNode
        extends AtExitBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            AtExitPolymorphicNode(AtExitBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.AtExitNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AtExitRubyProcNode
        extends AtExitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AtExitRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyProc.class}, 0, 0);

            AtExitRubyProcNode(AtExitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyProc");
                }
                return super.atExit(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments0Value)) {
                    RubyProc arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments0Value);
                    return super.atExit(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.AtExitNode create0(KernelNodes.AtExitNode current) {
                return new AtExitRubyProcNode((AtExitBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.AtExitNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AtExitUninitializedNode
        extends AtExitBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AtExitUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AtExitUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AtExitUninitializedNode(AtExitBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                AtExitBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AtExitBaseNode rootNode = (AtExitBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AtExitBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.AtExitNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AtExitUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.AtExitNode.class)
        private static abstract class AtExitBaseNode
        extends KernelNodes.AtExitNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AtExitBaseNode next0;

            AtExitBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AtExitBaseNode(AtExitBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                AtExitBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AtExitBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new AtExitUninitializedNode(this);
                    ((AtExitUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AtExitBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = AtExitBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (AtExitBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AtExitUninitializedNode(this), (Node)new AtExitPolymorphicNode(this), (DSLNode)((AtExitBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AtExitBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments0Value)) {
                    return (AtExitBaseNode)AtExitRubyProcNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((AtExitBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (AtExitBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.AbortNode.class)
    public static final class AbortNodeFactory
    extends NodeFactoryBase<KernelNodes.AbortNode> {
        private static AbortNodeFactory abortNodeFactoryInstance;

        private AbortNodeFactory() {
            super(KernelNodes.AbortNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.AbortNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AbortNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.AbortNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AbortDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.AbortNode> getInstance() {
            if (abortNodeFactoryInstance == null) {
                abortNodeFactoryInstance = new AbortNodeFactory();
            }
            return abortNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.AbortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AbortDefaultNode
        extends AbortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AbortDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            AbortDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.abort();
            }

            static KernelNodes.AbortNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AbortDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.AbortNode.class)
        private static abstract class AbortBaseNode
        extends KernelNodes.AbortNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            AbortBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.CompareNode.class)
    public static final class CompareNodeFactory
    extends NodeFactoryBase<KernelNodes.CompareNode> {
        private static CompareNodeFactory compareNodeFactoryInstance;

        private CompareNodeFactory() {
            super(KernelNodes.CompareNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.CompareNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompareNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.CompareNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompareObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.CompareNode> getInstance() {
            if (compareNodeFactoryInstance == null) {
                compareNodeFactoryInstance = new CompareNodeFactory();
            }
            return compareNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.CompareNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompareObjectNode
        extends CompareBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompareObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            CompareObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.compare(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.CompareNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompareObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.CompareNode.class)
        private static abstract class CompareBaseNode
        extends KernelNodes.CompareNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            CompareBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    CompareBaseNode otherCast = (CompareBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.NotMatchNode.class)
    public static final class NotMatchNodeFactory
    extends NodeFactoryBase<KernelNodes.NotMatchNode> {
        private static NotMatchNodeFactory notMatchNodeFactoryInstance;

        private NotMatchNodeFactory() {
            super(KernelNodes.NotMatchNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.NotMatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NotMatchNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.NotMatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NotMatchObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.NotMatchNode> getInstance() {
            if (notMatchNodeFactoryInstance == null) {
                notMatchNodeFactoryInstance = new NotMatchNodeFactory();
            }
            return notMatchNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.NotMatchNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NotMatchObjectNode
        extends NotMatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NotMatchObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            NotMatchObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.notMatch(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.NotMatchNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NotMatchObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.NotMatchNode.class)
        private static abstract class NotMatchBaseNode
        extends KernelNodes.NotMatchNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            NotMatchBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    NotMatchBaseNode otherCast = (NotMatchBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.MatchNode.class)
    public static final class MatchNodeFactory
    extends NodeFactoryBase<KernelNodes.MatchNode> {
        private static MatchNodeFactory matchNodeFactoryInstance;

        private MatchNodeFactory() {
            super(KernelNodes.MatchNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.MatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MatchNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.MatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MatchObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.MatchNode> getInstance() {
            if (matchNodeFactoryInstance == null) {
                matchNodeFactoryInstance = new MatchNodeFactory();
            }
            return matchNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.MatchNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MatchObjectNode
        extends MatchBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MatchObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

            MatchObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return super.equal(arguments0Value);
            }

            static KernelNodes.MatchNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MatchObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.MatchNode.class)
        private static abstract class MatchBaseNode
        extends KernelNodes.MatchNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            MatchBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((MatchBaseNode)other).arguments[0];
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.SameOrEqualNode.class)
    public static final class SameOrEqualNodeFactory
    extends NodeFactoryBase<KernelNodes.SameOrEqualNode> {
        private static SameOrEqualNodeFactory sameOrEqualNodeFactoryInstance;

        private SameOrEqualNodeFactory() {
            super(KernelNodes.SameOrEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.SameOrEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SameOrEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.SameOrEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SameOrEqualObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.SameOrEqualNode> getInstance() {
            if (sameOrEqualNodeFactoryInstance == null) {
                sameOrEqualNodeFactoryInstance = new SameOrEqualNodeFactory();
            }
            return sameOrEqualNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.SameOrEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SameOrEqualObjectNode
        extends SameOrEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SameOrEqualObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            SameOrEqualObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.sameOrEqual(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public boolean executeSameOrEqual(VirtualFrame frameValue, Object arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                Object arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                return super.sameOrEqual(frameValue, arguments0Value, arguments1Value);
            }

            static KernelNodes.SameOrEqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SameOrEqualObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.SameOrEqualNode.class)
        private static abstract class SameOrEqualBaseNode
        extends KernelNodes.SameOrEqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            SameOrEqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SameOrEqualBaseNode otherCast = (SameOrEqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=KernelNodes.BacktickNode.class)
    public static final class BacktickNodeFactory
    extends NodeFactoryBase<KernelNodes.BacktickNode> {
        private static BacktickNodeFactory backtickNodeFactoryInstance;

        private BacktickNodeFactory() {
            super(KernelNodes.BacktickNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public KernelNodes.BacktickNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return BacktickNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static KernelNodes.BacktickNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return BacktickUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<KernelNodes.BacktickNode> getInstance() {
            if (backtickNodeFactoryInstance == null) {
                backtickNodeFactoryInstance = new BacktickNodeFactory();
            }
            return backtickNodeFactoryInstance;
        }

        @GeneratedBy(value=KernelNodes.BacktickNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class BacktickPolymorphicNode
        extends BacktickBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            BacktickPolymorphicNode(BacktickBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=KernelNodes.BacktickNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class BacktickRubyStringNode
        extends BacktickBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BacktickRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

            BacktickRubyStringNode(BacktickBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyString");
                }
                return super.backtick(arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    RubyString arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments0Value);
                    return super.backtick(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.BacktickNode create0(KernelNodes.BacktickNode current) {
                return new BacktickRubyStringNode((BacktickBaseNode)current);
            }
        }

        @GeneratedBy(value=KernelNodes.BacktickNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class BacktickUninitializedNode
        extends BacktickBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(BacktickUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            BacktickUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            BacktickUninitializedNode(BacktickBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                BacktickBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    BacktickBaseNode rootNode = (BacktickBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((BacktickBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static KernelNodes.BacktickNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new BacktickUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=KernelNodes.BacktickNode.class)
        private static abstract class BacktickBaseNode
        extends KernelNodes.BacktickNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected BacktickBaseNode next0;

            BacktickBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            BacktickBaseNode(BacktickBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                BacktickBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                BacktickBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new BacktickUninitializedNode(this);
                    ((BacktickUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (BacktickBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = BacktickBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (BacktickBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BacktickUninitializedNode(this), (Node)new BacktickPolymorphicNode(this), (DSLNode)((BacktickBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final BacktickBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments0Value)) {
                    return (BacktickBaseNode)BacktickRubyStringNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((BacktickBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (BacktickBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

