/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jcodings.Encoding;
import org.jruby.RubyThread;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.NumericToFloatNode;
import org.jruby.truffle.nodes.cast.NumericToFloatNodeFactory;
import org.jruby.truffle.nodes.coerce.ToStrNodeFactory;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.globals.WrapInThreadLocalNode;
import org.jruby.truffle.nodes.objects.ClassNode;
import org.jruby.truffle.nodes.objects.ClassNodeFactory;
import org.jruby.truffle.nodes.objects.FreezeNode;
import org.jruby.truffle.nodes.objects.FreezeNodeFactory;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeFactory;
import org.jruby.truffle.nodes.objects.IsTaintedNode;
import org.jruby.truffle.nodes.objects.IsTaintedNodeFactory;
import org.jruby.truffle.nodes.objects.SingletonClassNode;
import org.jruby.truffle.nodes.objects.SingletonClassNodeFactory;
import org.jruby.truffle.nodes.objects.TaintNode;
import org.jruby.truffle.nodes.objects.TaintNodeFactory;
import org.jruby.truffle.nodes.objectstorage.WriteHeadObjectFieldNode;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodes;
import org.jruby.truffle.nodes.rubinius.ObjectPrimitiveNodesFactory;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.backtrace.Activation;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.backtrace.MRIBacktraceFormatter;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.core.StringFormatter;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.subsystems.FeatureManager;
import org.jruby.truffle.runtime.subsystems.ThreadManager;
import org.jruby.util.ByteList;
import org.jruby.util.cli.Options;

@CoreClass(name="Kernel")
public abstract class KernelNodes {

    @CoreMethod(names={"untaint"})
    public static abstract class UntaintNode
    extends CoreMethodNode {
        @Node.Child
        private WriteHeadObjectFieldNode writeTaintNode;

        public UntaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.writeTaintNode = new WriteHeadObjectFieldNode(RubyBasicObject.TAINTED_IDENTIFIER);
        }

        public UntaintNode(UntaintNode prev) {
            super(prev);
            this.writeTaintNode = prev.writeTaintNode;
        }

        @Specialization
        public Object taint(boolean object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(int object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(long object) {
            return this.frozen(object);
        }

        @Specialization
        public Object taint(double object) {
            return this.frozen(object);
        }

        private Object frozen(Object object) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().frozenError(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), this));
        }

        @Specialization
        public Object taint(RubyBasicObject object) {
            this.writeTaintNode.execute(object, false);
            return object;
        }
    }

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        @Node.Child
        private ClassNode classNode;
        @Node.Child
        private ObjectPrimitiveNodes.ObjectIDPrimitiveNode objectIDNode;
        @Node.Child
        private ToHexStringNode toHexStringNode;

        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeFactory.create(context, sourceSection, null);
            this.objectIDNode = ObjectPrimitiveNodesFactory.ObjectIDPrimitiveNodeFactory.create(context, sourceSection, new RubyNode[]{null});
            this.toHexStringNode = KernelNodesFactory.ToHexStringNodeFactory.create(context, sourceSection, new RubyNode[]{null});
        }

        public abstract RubyString executeToS(VirtualFrame var1, Object var2);

        @Specialization
        public RubyString toS(VirtualFrame frame, Object self) {
            ToSNode.notDesignedForCompilation();
            String className = this.classNode.executeGetClass(self).getName();
            Object id = this.objectIDNode.executeObjectID(frame, self);
            String hexID = this.toHexStringNode.executeToHexString(frame, id);
            return this.getContext().makeString("#<" + className + ":0x" + hexID + ">");
        }
    }

    public static abstract class ToHexStringNode
    extends CoreMethodNode {
        public ToHexStringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToHexStringNode(ToHexStringNode prev) {
            super(prev);
        }

        public abstract String executeToHexString(VirtualFrame var1, Object var2);

        @Specialization
        public String toHexString(int value) {
            return this.toHexString((long)value);
        }

        @Specialization
        public String toHexString(long value) {
            return Long.toHexString(value);
        }

        @Specialization
        public String toHexString(RubyBignum value) {
            return value.bigIntegerValue().toString(16);
        }
    }

    @CoreMethod(names={"tainted?"})
    public static abstract class KernelIsTaintedNode
    extends CoreMethodNode {
        @Node.Child
        private IsTaintedNode isTaintedNode;

        public KernelIsTaintedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public KernelIsTaintedNode(KernelIsTaintedNode prev) {
            super(prev);
            this.isTaintedNode = prev.isTaintedNode;
        }

        @Specialization
        public boolean isTainted(Object object) {
            if (this.isTaintedNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isTaintedNode = (IsTaintedNode)this.insert(IsTaintedNodeFactory.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isTaintedNode.executeIsTainted(object);
        }
    }

    @CoreMethod(names={"taint"})
    public static abstract class KernelTaintNode
    extends CoreMethodNode {
        @Node.Child
        private TaintNode taintNode;

        public KernelTaintNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public KernelTaintNode(KernelTaintNode prev) {
            super(prev);
        }

        @Specialization
        public Object taint(Object object) {
            if (this.taintNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.taintNode = (TaintNode)this.insert(TaintNodeFactory.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.taintNode.executeTaint(object);
        }
    }

    @CoreMethod(names={"system"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class SystemNode
    extends CoreMethodNode {
        public SystemNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SystemNode(SystemNode prev) {
            super(prev);
        }

        @Specialization
        public boolean system(RubyString command) {
            SystemNode.notDesignedForCompilation();
            RubyHash env = this.getContext().getCoreLibrary().getENV();
            ArrayList<String> envp = new ArrayList<String>();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(env)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    @CoreMethod(names={"sprintf", "format"}, isModuleFunction=true, argumentsAsArray=true)
    public static abstract class SPrintfNode
    extends CoreMethodNode {
        public SPrintfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SPrintfNode(SPrintfNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString sprintf(Object[] args) {
            PrintStream printStream;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                printStream = new PrintStream((OutputStream)outputStream, true, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            if (args.length > 0) {
                String format = args[0].toString();
                List<Object> values = Arrays.asList(args).subList(1, args.length);
                StringFormatter.format(this.getContext(), printStream, format, values);
            }
            return this.getContext().makeString(new ByteList(outputStream.toByteArray()));
        }
    }

    @CoreMethod(names={"sleep"}, isModuleFunction=true, optional=1)
    public static abstract class SleepNode
    extends CoreMethodNode {
        @Node.Child
        NumericToFloatNode floatCastNode;

        public SleepNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SleepNode(SleepNode prev) {
            super(prev);
        }

        @Specialization
        public long sleep(UndefinedPlaceholder duration) {
            return this.doSleepMillis(Long.MAX_VALUE);
        }

        @Specialization
        public long sleep(int duration) {
            return this.doSleepMillis((long)duration * 1000L);
        }

        @Specialization
        public long sleep(long duration) {
            return this.doSleepMillis(duration * 1000L);
        }

        @Specialization
        public long sleep(double duration) {
            return this.doSleepMillis((long)(duration * 1000.0));
        }

        @Specialization(guards={"isRubiniusUndefined"})
        public long sleep(RubyBasicObject duration) {
            return this.sleep(UndefinedPlaceholder.INSTANCE);
        }

        @Specialization(guards={"!isRubiniusUndefined"})
        public long sleep(VirtualFrame frame, RubyBasicObject duration) {
            if (this.floatCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.floatCastNode = (NumericToFloatNode)this.insert(NumericToFloatNodeFactory.create(this.getContext(), this.getSourceSection(), "to_f", null));
            }
            return this.sleep(this.floatCastNode.executeFloat(frame, duration));
        }

        @CompilerDirectives.TruffleBoundary
        private long doSleepMillis(final long durationInMillis) {
            if (durationInMillis < 0L) {
                throw new RaiseException(this.getContext().getCoreLibrary().argumentError("time interval must be positive", this));
            }
            final long start = System.currentTimeMillis();
            final RubyThread thread = this.getContext().getThreadManager().getCurrentThread();
            long slept = this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Long>(){
                boolean shouldWakeUp = false;

                @Override
                public Long block() throws InterruptedException {
                    long now = System.currentTimeMillis();
                    long slept = now - start;
                    if (this.shouldWakeUp || slept >= durationInMillis) {
                        return slept;
                    }
                    try {
                        Thread.sleep(durationInMillis - slept);
                        return System.currentTimeMillis() - start;
                    }
                    catch (InterruptedException e) {
                        if (thread.getStatus() == RubyThread.Status.RUN) {
                            this.shouldWakeUp = true;
                        }
                        throw e;
                    }
                }
            });
            return slept / 1000L;
        }
    }

    @CoreMethod(names={"String"}, isModuleFunction=true, required=1)
    public static abstract class StringNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toS;

        public StringNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.toS = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public StringNode(StringNode prev) {
            super(prev);
            this.toS = prev.toS;
        }

        @Specialization
        public RubyString string(RubyString value) {
            return value;
        }

        @Specialization(guards={"!isRubyString"})
        public Object string(VirtualFrame frame, Object value) {
            return this.toS.call(frame, value, "to_s", null, new Object[0]);
        }
    }

    @CoreMethod(names={"singleton_methods"}, optional=1)
    public static abstract class SingletonMethodsNode
    extends CoreMethodNode {
        public SingletonMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SingletonMethodsNode(SingletonMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray singletonMethods(RubyBasicObject self, boolean includeInherited) {
            SingletonMethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(self.getContext().getCoreLibrary().getArrayClass());
            Collection<InternalMethod> methods = includeInherited ? ModuleOperations.getAllMethods(self.getSingletonClass(this)).values() : self.getSingletonClass(this).getMethods().values();
            for (InternalMethod method : methods) {
                array.slowPush(RubySymbol.newSymbol(self.getContext(), method.getName()));
            }
            return array;
        }

        @Specialization
        public RubyArray singletonMethods(RubyBasicObject self, UndefinedPlaceholder includeInherited) {
            return this.singletonMethods(self, false);
        }
    }

    @CoreMethod(names={"singleton_class"})
    public static abstract class SingletonClassMethodNode
    extends CoreMethodNode {
        @Node.Child
        private SingletonClassNode singletonClassNode;

        public SingletonClassMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.singletonClassNode = SingletonClassNodeFactory.create(context, sourceSection, null);
        }

        public SingletonClassMethodNode(SingletonClassMethodNode prev) {
            super(prev);
            this.singletonClassNode = prev.singletonClassNode;
        }

        @Specialization
        public RubyClass singletonClass(VirtualFrame frame, Object self) {
            return this.singletonClassNode.executeSingletonClass(frame, self);
        }
    }

    @CoreMethod(names={"set_trace_func"}, isModuleFunction=true, required=1)
    public static abstract class SetTraceFuncNode
    extends CoreMethodNode {
        public SetTraceFuncNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetTraceFuncNode(SetTraceFuncNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass setTraceFunc(RubyNilClass nil) {
            SetTraceFuncNode.notDesignedForCompilation();
            this.getContext().getTraceManager().setTraceFunc(null);
            return nil;
        }

        @Specialization
        public RubyProc setTraceFunc(RubyProc traceFunc) {
            SetTraceFuncNode.notDesignedForCompilation();
            this.getContext().getTraceManager().setTraceFunc(traceFunc);
            return traceFunc;
        }
    }

    @CoreMethod(names={"respond_to_missing?"}, required=1, optional=1)
    public static abstract class RespondToMissingNode
    extends CoreMethodNode {
        public RespondToMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RespondToMissingNode(RespondToMissingNode prev) {
            super(prev);
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubyString name, UndefinedPlaceholder includeAll) {
            return false;
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubySymbol name, UndefinedPlaceholder includeAll) {
            return false;
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubySymbol name, boolean includeAll) {
            return false;
        }

        @Specialization
        public boolean doesRespondToMissing(Object object, RubyString name, boolean includeAll) {
            return false;
        }
    }

    @CoreMethod(names={"respond_to?"}, required=1, optional=1)
    public static abstract class RespondToNode
    extends CoreMethodNode {
        @Node.Child
        private DoesRespondDispatchHeadNode dispatch;
        @Node.Child
        private DoesRespondDispatchHeadNode dispatchIgnoreVisibility;

        public RespondToNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = new DoesRespondDispatchHeadNode(context, false, false, MissingBehavior.RETURN_MISSING, null);
            this.dispatchIgnoreVisibility = new DoesRespondDispatchHeadNode(context, true, false, MissingBehavior.RETURN_MISSING, null);
            if (((Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED.load()).booleanValue()) {
                this.dispatch.forceUncached();
                this.dispatchIgnoreVisibility.forceUncached();
            }
        }

        public RespondToNode(RespondToNode prev) {
            super(prev);
            this.dispatch = prev.dispatch;
            this.dispatchIgnoreVisibility = prev.dispatchIgnoreVisibility;
        }

        public abstract boolean executeDoesRespondTo(VirtualFrame var1, Object var2, Object var3, boolean var4);

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubyString name, UndefinedPlaceholder checkVisibility) {
            return this.doesRespondTo(frame, object, name, false);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubyString name, RubyBasicObject checkVisibility) {
            return this.doesRespondTo(frame, object, name, false);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubyString name, boolean ignoreVisibility) {
            if (ignoreVisibility) {
                return this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object);
            }
            return this.dispatch.doesRespondTo(frame, name, object);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubySymbol name, UndefinedPlaceholder checkVisibility) {
            return this.doesRespondTo(frame, object, name, false);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubySymbol name, RubyBasicObject checkVisibility) {
            return this.doesRespondTo(frame, object, name, false);
        }

        @Specialization
        public boolean doesRespondTo(VirtualFrame frame, Object object, RubySymbol name, boolean ignoreVisibility) {
            if (ignoreVisibility) {
                return this.dispatchIgnoreVisibility.doesRespondTo(frame, name, object);
            }
            return this.dispatch.doesRespondTo(frame, name, object);
        }
    }

    @CoreMethod(names={"require_relative"}, isModuleFunction=true, required=1)
    public static abstract class RequireRelativeNode
    extends CoreMethodNode {
        public RequireRelativeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RequireRelativeNode(RequireRelativeNode prev) {
            super(prev);
        }

        @Specialization
        public boolean requireRelative(RubyString feature) {
            String featurePath;
            RequireRelativeNode.notDesignedForCompilation();
            FeatureManager featureManager = this.getContext().getFeatureManager();
            String featureString = feature.toString();
            if (featureManager.isAbsolutePath(featureString)) {
                featurePath = featureString;
            } else {
                Source source = Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getSource();
                String sourcePath = featureManager.getSourcePath(source);
                if (sourcePath == null) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().loadError("cannot infer basepath", this));
                }
                featurePath = this.dirname(sourcePath) + "/" + featureString;
            }
            try {
                featureManager.require(featurePath, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }

        private String dirname(String path) {
            int lastSlash = path.lastIndexOf(47);
            assert (lastSlash > 0);
            return path.substring(0, lastSlash);
        }
    }

    @CoreMethod(names={"require"}, isModuleFunction=true, required=1)
    public static abstract class RequireNode
    extends CoreMethodNode {
        public RequireNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RequireNode(RequireNode prev) {
            super(prev);
        }

        @Specialization
        public boolean require(RubyString feature) {
            RequireNode.notDesignedForCompilation();
            if (feature.toString().equals("strscan") && Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getSource().getName().endsWith("erb.rb")) {
                throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(feature.toString(), this));
            }
            try {
                this.getContext().getFeatureManager().require(feature.toString(), this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return true;
        }
    }

    @CoreMethod(names={"rand"}, isModuleFunction=true, optional=1)
    public static abstract class RandNode
    extends CoreMethodNode {
        public RandNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RandNode(RandNode prev) {
            super(prev);
        }

        @Specialization
        public double rand(UndefinedPlaceholder undefined) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isZero"})
        public double randZero(int max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isNonZero"})
        public int randNonZero(int max) {
            return this.getContext().getRandom().nextInt(max);
        }

        @Specialization(guards={"isZero"})
        public double randZero(long max) {
            return this.getContext().getRandom().nextDouble();
        }

        @Specialization(guards={"isNonZero"})
        public long randNonZero(long max) {
            return this.getContext().getRandom().nextLong() % max;
        }

        protected boolean isZero(int max) {
            return max == 0;
        }

        protected boolean isNonZero(int max) {
            return max != 0;
        }

        protected boolean isZero(long max) {
            return max == 0L;
        }

        protected boolean isNonZero(long max) {
            return max != 0L;
        }
    }

    @CoreMethod(names={"public_methods"}, optional=1)
    public static abstract class PublicMethodsNode
    extends CoreMethodNode {
        public PublicMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PublicMethodsNode(PublicMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray methods(RubyBasicObject self, boolean includeInherited) {
            PublicMethodsNode.notDesignedForCompilation();
            if (!includeInherited) {
                this.getContext().getRuntime().getWarnings().warn(IRubyWarnings.ID.TRUFFLE, Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getSource().getName(), Truffle.getRuntime().getCallerFrame().getCallNode().getEncapsulatingSourceSection().getStartLine(), "Object#methods always returns inherited methods at the moment");
            }
            return this.methods(self, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public RubyArray methods(RubyBasicObject self, UndefinedPlaceholder includeInherited) {
            PublicMethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(self.getContext().getCoreLibrary().getArrayClass());
            Map<String, InternalMethod> methods = self.getMetaClass().getMethods();
            for (InternalMethod method : methods.values()) {
                if (method.getVisibility() != Visibility.PUBLIC) continue;
                array.slowPush(self.getContext().getSymbol(method.getName()));
            }
            return array;
        }
    }

    @CoreMethod(names={"proc"}, isModuleFunction=true, needsBlock=true)
    public static abstract class ProcNode
    extends CoreMethodNode {
        public ProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ProcNode(ProcNode prev) {
            super(prev);
        }

        @Specialization
        public RubyProc proc(RubyProc block) {
            ProcNode.notDesignedForCompilation();
            return new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, block.getSharedMethodInfo(), block.getCallTargetForProcs(), block.getCallTargetForProcs(), block.getCallTargetForMethods(), block.getDeclarationFrame(), block.getMethod(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope());
        }
    }

    @CoreMethod(names={"private_methods"}, optional=1)
    public static abstract class PrivateMethodsNode
    extends CoreMethodNode {
        public PrivateMethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PrivateMethodsNode(PrivateMethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray private_methods(RubyBasicObject self, UndefinedPlaceholder unused) {
            return this.private_methods(self, true);
        }

        @Specialization
        public RubyArray private_methods(RubyBasicObject self, boolean includeInherited) {
            PrivateMethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(self.getContext().getCoreLibrary().getArrayClass());
            Map<String, InternalMethod> methods = includeInherited ? ModuleOperations.getAllMethods(self.getMetaClass()) : self.getMetaClass().getMethods();
            for (InternalMethod method : methods.values()) {
                if (method.getVisibility() != Visibility.PRIVATE) continue;
                array.slowPush(self.getContext().getSymbol(method.getName()));
            }
            return array;
        }
    }

    @CoreMethod(names={"nil?"}, needsSelf=false)
    public static abstract class NilNode
    extends CoreMethodNode {
        public NilNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NilNode(NilNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isNil() {
            return false;
        }
    }

    @CoreMethod(names={"methods"}, optional=1)
    public static abstract class MethodsNode
    extends CoreMethodNode {
        public MethodsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MethodsNode(MethodsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray methods(RubyBasicObject self, UndefinedPlaceholder unused) {
            return this.methods(self, true);
        }

        @Specialization
        public RubyArray methods(RubyBasicObject self, boolean includeInherited) {
            MethodsNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(self.getContext().getCoreLibrary().getArrayClass());
            Map<String, InternalMethod> methods = includeInherited ? ModuleOperations.getAllMethods(self.getMetaClass()) : self.getMetaClass().getMethods();
            for (InternalMethod method : methods.values()) {
                if (method.getVisibility() != Visibility.PUBLIC && method.getVisibility() != Visibility.PROTECTED) continue;
                array.slowPush(self.getContext().getSymbol(method.getName()));
            }
            return array;
        }
    }

    @CoreMethod(names={"method"}, required=1)
    public static abstract class MethodNode
    extends CoreMethodNode {
        public MethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MethodNode(MethodNode prev) {
            super(prev);
        }

        @Specialization
        public RubyMethod method(Object object, RubySymbol name) {
            return this.method(object, name.toString());
        }

        @Specialization
        public RubyMethod method(Object object, RubyString name) {
            return this.method(object, name.toString());
        }

        private RubyMethod method(Object object, String name) {
            MethodNode.notDesignedForCompilation();
            InternalMethod method = ModuleOperations.lookupMethod(this.getContext().getCoreLibrary().getMetaClass(object), name);
            if (method == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedMethod(name, this.getContext().getCoreLibrary().getLogicalClass(object), this));
            }
            return new RubyMethod(this.getContext().getCoreLibrary().getMethodClass(), object, method);
        }
    }

    @CoreMethod(names={"__method__"}, needsSelf=false)
    public static abstract class MethodNameNode
    extends CoreMethodNode {
        public MethodNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MethodNameNode(MethodNameNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol methodName(VirtualFrame frame) {
            MethodNameNode.notDesignedForCompilation();
            return this.getContext().getSymbolTable().getSymbol(RubyCallStack.getCallingMethod(frame).getSharedMethodInfo().getName());
        }
    }

    @CoreMethod(names={"local_variables"}, needsSelf=false)
    public static abstract class LocalVariablesNode
    extends CoreMethodNode {
        public LocalVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LocalVariablesNode(LocalVariablesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray localVariables() {
            LocalVariablesNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            for (Object name : Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getFrameDescriptor().getIdentifiers()) {
                if (!(name instanceof String)) continue;
                array.slowPush(this.getContext().getSymbol((String)name));
            }
            return array;
        }
    }

    @CoreMethod(names={"load"}, isModuleFunction=true, required=1)
    public static abstract class LoadNode
    extends CoreMethodNode {
        public LoadNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LoadNode(LoadNode prev) {
            super(prev);
        }

        @Specialization
        public boolean load(RubyString file) {
            LoadNode.notDesignedForCompilation();
            try {
                this.getContext().loadFile(file.toString(), this);
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().loadErrorCannotLoad(file.toString(), this));
                }
                throw e;
            }
            return true;
        }
    }

    @CoreMethod(names={"lambda"}, isModuleFunction=true, needsBlock=true)
    public static abstract class LambdaNode
    extends CoreMethodNode {
        public LambdaNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LambdaNode(LambdaNode prev) {
            super(prev);
        }

        @Specialization
        public RubyProc proc(RubyProc block) {
            LambdaNode.notDesignedForCompilation();
            return new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.LAMBDA, block.getSharedMethodInfo(), block.getCallTargetForMethods(), block.getCallTargetForMethods(), block.getCallTargetForMethods(), block.getDeclarationFrame(), block.getMethod(), block.getSelfCapturedInScope(), block.getBlockCapturedInScope());
        }
    }

    @CoreMethod(names={"is_a?", "kind_of?"}, required=1)
    public static abstract class IsANode
    extends CoreMethodNode {
        public IsANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IsANode(IsANode prev) {
            super(prev);
        }

        public abstract boolean executeIsA(VirtualFrame var1, Object var2, RubyModule var3);

        @Specialization
        public boolean isA(RubyBasicObject self, RubyNilClass nil) {
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean isA(Object self, RubyModule rubyClass) {
            IsANode.notDesignedForCompilation();
            return ModuleOperations.assignableTo(this.getContext().getCoreLibrary().getMetaClass(self), rubyClass);
        }
    }

    @CoreMethod(names={"instance_variables", "__instance_variables__"})
    public static abstract class InstanceVariablesNode
    extends CoreMethodNode {
        public InstanceVariablesNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceVariablesNode(InstanceVariablesNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray instanceVariables(RubyBasicObject self) {
            InstanceVariablesNode.notDesignedForCompilation();
            Object[] instanceVariableNames = self.getOperations().getFieldNames(self);
            Arrays.sort(instanceVariableNames);
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            for (Object name : instanceVariableNames) {
                if (!(name instanceof String)) continue;
                array.slowPush(this.getContext().getSymbolTable().getSymbol((String)name));
            }
            return array;
        }
    }

    @CoreMethod(names={"instance_variable_set", "__instance_variable_set__"}, raiseIfFrozenSelf=true, required=2)
    public static abstract class InstanceVariableSetNode
    extends CoreMethodNode {
        public InstanceVariableSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceVariableSetNode(InstanceVariableSetNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object instanceVariableSet(RubyBasicObject object, RubyString name, Object value) {
            object.getOperations().setInstanceVariable(object, RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this), value);
            return value;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object instanceVariableSet(RubyBasicObject object, RubySymbol name, Object value) {
            object.getOperations().setInstanceVariable(object, RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this), value);
            return value;
        }
    }

    @CoreMethod(names={"instance_variable_get"}, required=1)
    public static abstract class InstanceVariableGetNode
    extends CoreMethodNode {
        public InstanceVariableGetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceVariableGetNode(InstanceVariableGetNode prev) {
            super(prev);
        }

        @Specialization
        public Object instanceVariableGet(RubyBasicObject object, RubyString name) {
            return this.instanceVariableGet(object, name.toString());
        }

        @Specialization
        public Object instanceVariableGet(RubyBasicObject object, RubySymbol name) {
            return this.instanceVariableGet(object, name.toString());
        }

        private Object instanceVariableGet(RubyBasicObject object, String name) {
            InstanceVariableGetNode.notDesignedForCompilation();
            return object.getInstanceVariable(RubyContext.checkInstanceVariableName(this.getContext(), name, this));
        }
    }

    @CoreMethod(names={"instance_variable_defined?"}, required=1)
    public static abstract class InstanceVariableDefinedNode
    extends CoreMethodNode {
        public InstanceVariableDefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceVariableDefinedNode(InstanceVariableDefinedNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isInstanceVariableDefined(RubyBasicObject object, RubyString name) {
            InstanceVariableDefinedNode.notDesignedForCompilation();
            return object.isFieldDefined(RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this));
        }

        @Specialization
        public boolean isInstanceVariableDefined(RubyBasicObject object, RubySymbol name) {
            InstanceVariableDefinedNode.notDesignedForCompilation();
            return object.isFieldDefined(RubyContext.checkInstanceVariableName(this.getContext(), name.toString(), this));
        }
    }

    @CoreMethod(names={"instance_of?"}, required=1)
    public static abstract class InstanceOfNode
    extends CoreMethodNode {
        @Node.Child
        private ClassNode classNode;

        public InstanceOfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeFactory.create(context, sourceSection, null);
        }

        public InstanceOfNode(InstanceOfNode prev) {
            super(prev);
            this.classNode = prev.classNode;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean instanceOf(Object self, RubyClass rubyClass) {
            return this.classNode.executeGetClass(self) == rubyClass;
        }
    }

    @CoreMethod(names={"initialize_dup", "initialize_clone"}, required=1)
    public static abstract class InitializeDupCloneNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode initializeCopyNode;

        public InitializeDupCloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.initializeCopyNode = DispatchHeadNodeFactory.createMethodCallOnSelf(context);
        }

        public InitializeDupCloneNode(InitializeDupCloneNode prev) {
            super(prev);
            this.initializeCopyNode = prev.initializeCopyNode;
        }

        @Specialization
        public Object initializeDup(VirtualFrame frame, RubyBasicObject self, RubyBasicObject from) {
            return this.initializeCopyNode.call(frame, self, "initialize_copy", null, from);
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1)
    public static abstract class InitializeCopyNode
    extends CoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization
        public Object initializeCopy(RubyBasicObject self, RubyBasicObject from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self.getLogicalClass() != from.getLogicalClass()) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().typeError("initialize_copy should take same class object", this));
            }
            return self;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public HashNode(HashNode prev) {
            super(prev);
        }

        @Specialization
        public int hash(int value) {
            return value;
        }

        @Specialization
        public int hash(long value) {
            return Long.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(double value) {
            return Double.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(boolean value) {
            return Boolean.valueOf(value).hashCode();
        }

        @Specialization
        public int hash(RubyBasicObject self) {
            return System.identityHashCode(self);
        }
    }

    @CoreMethod(names={"gets"}, isModuleFunction=true)
    public static abstract class GetsNode
    extends CoreMethodNode {
        public GetsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GetsNode(GetsNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString gets(VirtualFrame frame) {
            GetsNode.notDesignedForCompilation();
            InputStream in = this.getContext().getRuntime().getInstanceConfig().getInput();
            Encoding encoding = this.getContext().getRuntime().getDefaultExternalEncoding();
            final BufferedReader reader = new BufferedReader(new InputStreamReader(in, encoding.getCharset()));
            String line = this.getContext().getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<String>(){

                @Override
                public String block() throws InterruptedException {
                    return GetsNode.gets(reader);
                }
            });
            RubyString rubyLine = this.getContext().makeString(line);
            Frame caller = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_WRITE, false);
            FrameSlot slot = caller.getFrameDescriptor().findFrameSlot((Object)"$_");
            if (slot != null) {
                caller.setObject(slot, WrapInThreadLocalNode.wrap(this.getContext(), rubyLine));
            }
            return rubyLine;
        }

        @CompilerDirectives.TruffleBoundary
        private static String gets(BufferedReader reader) throws InterruptedException {
            try {
                return reader.readLine() + "\n";
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CoreMethod(names={"frozen?"})
    public static abstract class KernelFrozenNode
    extends CoreMethodNode {
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public KernelFrozenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public KernelFrozenNode(KernelFrozenNode prev) {
            super(prev);
            this.isFrozenNode = prev.isFrozenNode;
        }

        @Specialization
        public boolean isFrozen(Object self) {
            if (this.isFrozenNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeFactory.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.isFrozenNode.executeIsFrozen(self);
        }
    }

    @CoreMethod(names={"freeze"})
    public static abstract class KernelFreezeNode
    extends CoreMethodNode {
        @Node.Child
        private FreezeNode freezeNode;

        public KernelFreezeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public KernelFreezeNode(KernelFreezeNode prev) {
            super(prev);
            this.freezeNode = prev.freezeNode;
        }

        @Specialization
        public Object freeze(Object self) {
            if (this.freezeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.freezeNode = (FreezeNode)this.insert(FreezeNodeFactory.create(this.getContext(), this.getEncapsulatingSourceSection(), null));
            }
            return this.freezeNode.executeFreeze(self);
        }
    }

    @CoreMethod(names={"fork"}, isModuleFunction=true, argumentsAsArray=true)
    public static abstract class ForkNode
    extends CoreMethodNode {
        public ForkNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ForkNode(ForkNode prev) {
            super(prev);
        }

        @Specialization
        public Object fork(Object[] args) {
            ForkNode.notDesignedForCompilation();
            this.getContext().getWarnings().warn("Kernel#fork not implemented - defined to satisfy some metaprogramming in RubySpec");
            return this.nil();
        }
    }

    @CoreMethod(names={"exit!"}, isModuleFunction=true, optional=1)
    public static abstract class ExitBangNode
    extends CoreMethodNode {
        public ExitBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExitBangNode(ExitBangNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass exit(UndefinedPlaceholder exitCode) {
            return this.exit(1);
        }

        @Specialization
        public RubyNilClass exit(int exitCode) {
            CompilerDirectives.transferToInterpreter();
            System.exit(exitCode);
            return this.nil();
        }
    }

    @CoreMethod(names={"exit"}, isModuleFunction=true, optional=1, lowerFixnumParameters={0})
    public static abstract class ExitNode
    extends CoreMethodNode {
        public ExitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExitNode(ExitNode prev) {
            super(prev);
        }

        @Specialization
        public Object exit(UndefinedPlaceholder exitCode) {
            return this.exit(0);
        }

        @Specialization
        public Object exit(int exitCode) {
            ExitNode.notDesignedForCompilation();
            this.getContext().shutdown();
            System.exit(exitCode);
            return null;
        }

        @Specialization
        public Object exit(boolean status) {
            ExitNode.notDesignedForCompilation();
            this.getContext().shutdown();
            System.exit(status ? 0 : -1);
            return null;
        }
    }

    @CoreMethod(names={"exec"}, isModuleFunction=true, required=1, argumentsAsArray=true)
    public static abstract class ExecNode
    extends CoreMethodNode {
        public ExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExecNode(ExecNode prev) {
            super(prev);
        }

        @Specialization
        public Object require(Object[] args) {
            ExecNode.notDesignedForCompilation();
            String[] commandLine = new String[args.length];
            for (int n = 0; n < args.length; ++n) {
                commandLine[n] = args[n].toString();
            }
            ExecNode.exec(this.getContext(), commandLine);
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static void exec(RubyContext context, String[] commandLine) {
            Process process;
            ProcessBuilder builder = new ProcessBuilder(commandLine);
            builder.inheritIO();
            RubyHash env = context.getCoreLibrary().getENV();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(env)) {
                builder.environment().put(keyValue.getKey().toString(), keyValue.getValue().toString());
            }
            try {
                process = builder.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            int exitCode = context.getThreadManager().runUntilResult(new ThreadManager.BlockingActionWithoutGlobalLock<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    return process.waitFor();
                }
            });
            System.exit(exitCode);
        }
    }

    @CoreMethod(names={"eval"}, isModuleFunction=true, required=1, optional=3, lowerFixnumParameters={3})
    @NodeChildren(value={@NodeChild(value="source", type=RubyNode.class), @NodeChild(value="binding", type=RubyNode.class), @NodeChild(value="filename", type=RubyNode.class), @NodeChild(value="lineNumber", type=RubyNode.class)})
    public static abstract class EvalNode
    extends RubyNode {
        @Node.Child
        private CallDispatchHeadNode toStr;
        @Node.Child
        private BindingNode bindingNode;

        public EvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EvalNode(EvalNode prev) {
            super(prev);
        }

        @CreateCast(value={"source"})
        public RubyNode coerceSourceToString(RubyNode source) {
            return ToStrNodeFactory.create(this.getContext(), this.getSourceSection(), source);
        }

        protected RubyBinding getCallerBinding(VirtualFrame frame) {
            if (this.bindingNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.bindingNode = (BindingNode)this.insert(KernelNodesFactory.BindingNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[0]));
            }
            return this.bindingNode.executeRubyBinding(frame);
        }

        @Specialization
        public Object eval(VirtualFrame frame, RubyString source, UndefinedPlaceholder binding, UndefinedPlaceholder filename, UndefinedPlaceholder lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.getContext().eval(source.getBytes(), this.getCallerBinding(frame), true, this);
        }

        @Specialization
        public Object eval(VirtualFrame frame, RubyString source, RubyNilClass noBinding, RubyString filename, int lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.eval(frame, source, UndefinedPlaceholder.INSTANCE, UndefinedPlaceholder.INSTANCE, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public Object eval(RubyString source, RubyBinding binding, UndefinedPlaceholder filename, UndefinedPlaceholder lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.getContext().eval(source.getBytes(), binding, false, this);
        }

        @Specialization
        public Object eval(RubyString source, RubyBinding binding, RubyString filename, UndefinedPlaceholder lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.getContext().eval(source.getBytes(), binding, false, filename.toString(), (Node)this);
        }

        @Specialization
        public Object eval(RubyString source, RubyBinding binding, RubyString filename, int lineNumber) {
            EvalNode.notDesignedForCompilation();
            return this.getContext().eval(source.getBytes(), binding, false, filename.toString(), (Node)this);
        }

        @Specialization(guards={"!isRubyBinding(binding)"})
        public Object eval(RubyString source, RubyBasicObject badBinding, UndefinedPlaceholder filename, UndefinedPlaceholder lineNumber) {
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorWrongArgumentType(badBinding, "binding", this));
        }
    }

    @CoreMethod(names={"dup"}, taintFromSelf=true)
    public static abstract class DupNode
    extends CoreMethodNode {
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeDupNode;

        public DupNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeDupNode = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.CALL_METHOD_MISSING);
        }

        public DupNode(DupNode prev) {
            super(prev);
            this.copyNode = prev.copyNode;
            this.initializeDupNode = prev.initializeDupNode;
        }

        @Specialization
        public RubyBasicObject dup(VirtualFrame frame, RubyBasicObject self) {
            RubyBasicObject newObject = this.copyNode.executeCopy(frame, self);
            this.initializeDupNode.call(frame, newObject, "initialize_dup", null, self);
            return newObject;
        }
    }

    @CoreMethod(names={"clone"}, taintFromSelf=true)
    public static abstract class CloneNode
    extends CoreMethodNode {
        private final ConditionProfile frozenProfile = ConditionProfile.createBinaryProfile();
        @Node.Child
        private CopyNode copyNode;
        @Node.Child
        private CallDispatchHeadNode initializeCloneNode;
        @Node.Child
        private IsFrozenNode isFrozenNode;
        @Node.Child
        private FreezeNode freezeNode;

        public CloneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.copyNode = KernelNodesFactory.CopyNodeFactory.create(context, sourceSection, null);
            this.initializeCloneNode = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.CALL_METHOD_MISSING);
            this.isFrozenNode = IsFrozenNodeFactory.create(context, sourceSection, null);
            this.freezeNode = FreezeNodeFactory.create(context, sourceSection, null);
        }

        public CloneNode(CloneNode prev) {
            super(prev);
            this.copyNode = prev.copyNode;
            this.initializeCloneNode = prev.initializeCloneNode;
            this.isFrozenNode = prev.isFrozenNode;
            this.freezeNode = prev.freezeNode;
        }

        @Specialization
        public RubyBasicObject clone(VirtualFrame frame, RubyBasicObject self) {
            CloneNode.notDesignedForCompilation();
            RubyBasicObject newObject = this.copyNode.executeCopy(frame, self);
            if (self.getMetaClass().isSingleton()) {
                newObject.getSingletonClass(this).initCopy(self.getMetaClass());
            }
            this.initializeCloneNode.call(frame, newObject, "initialize_clone", null, self);
            if (this.frozenProfile.profile(this.isFrozenNode.executeIsFrozen(self))) {
                this.freezeNode.executeFreeze(newObject);
            }
            return newObject;
        }
    }

    public static abstract class CopyNode
    extends UnaryCoreMethodNode {
        public CopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CopyNode(CopyNode prev) {
            super(prev);
        }

        public abstract RubyBasicObject executeCopy(VirtualFrame var1, RubyBasicObject var2);

        @Specialization
        public RubyBasicObject copy(VirtualFrame frame, RubyBasicObject self) {
            RubyBasicObject newObject = self.getLogicalClass().allocate(this);
            newObject.getOperations().setInstanceVariables(newObject, self.getOperations().getInstanceVariables(self));
            return newObject;
        }
    }

    @CoreMethod(names={"class"})
    public static abstract class KernelClassNode
    extends CoreMethodNode {
        @Node.Child
        private ClassNode classNode;

        public KernelClassNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.classNode = ClassNodeFactory.create(context, sourceSection, null);
        }

        public KernelClassNode(KernelClassNode prev) {
            super(prev);
            this.classNode = prev.classNode;
        }

        @Specialization
        public RubyClass getClass(Object self) {
            return this.classNode.executeGetClass(self);
        }
    }

    @CoreMethod(names={"caller"}, isModuleFunction=true, optional=1)
    public static abstract class CallerNode
    extends CoreMethodNode {
        public CallerNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CallerNode(CallerNode prev) {
            super(prev);
        }

        @Specialization
        public Object caller(UndefinedPlaceholder omit) {
            return this.caller(1);
        }

        @Specialization
        public Object caller(int omit) {
            CallerNode.notDesignedForCompilation();
            Backtrace backtrace = RubyCallStack.getBacktrace(this);
            List<Activation> activations = backtrace.getActivations();
            int size = activations.size() - ++omit;
            if (size < 0) {
                return this.nil();
            }
            Object[] callers = new Object[size];
            for (int n = 0; n < size; ++n) {
                callers[n] = this.getContext().makeString(MRIBacktraceFormatter.formatCallerLine(activations, n + omit));
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), callers, callers.length);
        }
    }

    @CoreMethod(names={"__callee__"}, needsSelf=false)
    public static abstract class CalleeNameNode
    extends CoreMethodNode {
        public CalleeNameNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CalleeNameNode(CalleeNameNode prev) {
            super(prev);
        }

        @Specialization
        public RubySymbol calleeName(VirtualFrame frame) {
            CalleeNameNode.notDesignedForCompilation();
            return this.getContext().getSymbolTable().getSymbol(RubyCallStack.getCallingMethod(frame).getName());
        }
    }

    @CoreMethod(names={"block_given?"}, isModuleFunction=true)
    public static abstract class BlockGivenNode
    extends CoreMethodNode {
        public BlockGivenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BlockGivenNode(BlockGivenNode prev) {
            super(prev);
        }

        @Specialization
        public boolean blockGiven() {
            return RubyArguments.getBlock(Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.READ_ONLY, false).getArguments()) != null;
        }
    }

    @CoreMethod(names={"binding"}, isModuleFunction=true)
    public static abstract class BindingNode
    extends CoreMethodNode {
        public BindingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        @Override
        public abstract RubyBinding executeRubyBinding(VirtualFrame var1);

        @Specialization
        public RubyBinding binding() {
            MaterializedFrame callerFrame = Truffle.getRuntime().getCallerFrame().getFrame(FrameInstance.FrameAccess.MATERIALIZE, false).materialize();
            return new RubyBinding(this.getContext().getCoreLibrary().getBindingClass(), RubyArguments.getSelf(callerFrame.getArguments()), callerFrame);
        }
    }

    @CoreMethod(names={"at_exit"}, isModuleFunction=true, needsBlock=true)
    public static abstract class AtExitNode
    extends CoreMethodNode {
        public AtExitNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AtExitNode(AtExitNode prev) {
            super(prev);
        }

        @Specialization
        public Object atExit(RubyProc block) {
            AtExitNode.notDesignedForCompilation();
            this.getContext().getAtExitManager().add(block);
            return this.nil();
        }
    }

    @CoreMethod(names={"abort"}, isModuleFunction=true)
    public static abstract class AbortNode
    extends CoreMethodNode {
        public AbortNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AbortNode(AbortNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass abort() {
            CompilerDirectives.transferToInterpreter();
            System.exit(1);
            return this.nil();
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        @Node.Child
        private SameOrEqualNode equalNode;

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        public CompareNode(CompareNode prev) {
            super(prev);
            this.equalNode = prev.equalNode;
        }

        @Specialization
        public Object compare(VirtualFrame frame, Object self, Object other) {
            if (this.equalNode.executeSameOrEqual(frame, self, other)) {
                return 0;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"!~"}, required=1)
    public static abstract class NotMatchNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode matchNode;

        public NotMatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.matchNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public NotMatchNode(NotMatchNode prev) {
            super(prev);
            this.matchNode = prev.matchNode;
        }

        @Specialization
        public boolean notMatch(VirtualFrame frame, Object self, Object other) {
            return !this.matchNode.callBoolean(frame, self, "=~", null, other);
        }
    }

    @CoreMethod(names={"=~"}, required=1, needsSelf=false)
    public static abstract class MatchNode
    extends CoreMethodNode {
        public MatchNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MatchNode(MatchNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass equal(Object other) {
            return this.nil();
        }
    }

    @CoreMethod(names={"==="}, required=1)
    public static abstract class SameOrEqualNode
    extends CoreMethodNode {
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode referenceEqualNode;
        @Node.Child
        private CallDispatchHeadNode equalNode;
        private final ConditionProfile sameProfile = ConditionProfile.createBinaryProfile();

        public SameOrEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SameOrEqualNode(SameOrEqualNode prev) {
            super(prev);
        }

        public abstract boolean executeSameOrEqual(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public boolean sameOrEqual(VirtualFrame frame, Object a, Object b) {
            if (this.sameProfile.profile(this.areSame(frame, a, b))) {
                return true;
            }
            return this.areEqual(frame, a, b);
        }

        private boolean areSame(VirtualFrame frame, Object left, Object right) {
            if (this.referenceEqualNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.referenceEqualNode = (BasicObjectNodes.ReferenceEqualNode)this.insert(BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.referenceEqualNode.executeReferenceEqual(frame, left, right);
        }

        private boolean areEqual(VirtualFrame frame, Object left, Object right) {
            if (this.equalNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.equalNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), false, false, null));
            }
            return this.equalNode.callBoolean(frame, left, "==", null, right);
        }
    }

    @CoreMethod(names={"`"}, isModuleFunction=true, needsSelf=false, required=1)
    public static abstract class BacktickNode
    extends CoreMethodNode {
        public BacktickNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BacktickNode(BacktickNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString backtick(RubyString command) {
            Process process;
            BacktickNode.notDesignedForCompilation();
            RubyContext context = this.getContext();
            RubyHash env = context.getCoreLibrary().getENV();
            ArrayList<String> envp = new ArrayList<String>();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(env)) {
                envp.add(keyValue.getKey().toString() + "=" + keyValue.getValue().toString());
            }
            try {
                process = Runtime.getRuntime().exec(new String[]{"bash", "-c", command.toString()}, envp.toArray(new String[envp.size()]));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            InputStream stdout = process.getInputStream();
            InputStreamReader reader = new InputStreamReader(stdout, StandardCharsets.UTF_8);
            StringBuilder resultBuilder = new StringBuilder();
            try {
                int c;
                while ((c = reader.read()) != -1) {
                    resultBuilder.append((char)c);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return context.makeString(resultBuilder.toString(), RubyEncoding.getEncoding("UTF-8").getEncoding());
        }
    }
}

