/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.HashCoreMethodNode;
import org.jruby.truffle.nodes.core.HashGuards;
import org.jruby.truffle.nodes.core.HashNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.hash.FindEntryNode;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.hash.Entry;
import org.jruby.truffle.runtime.hash.HashOperations;
import org.jruby.truffle.runtime.hash.HashSearchResult;
import org.jruby.truffle.runtime.hash.KeyValue;
import org.jruby.truffle.runtime.methods.InternalMethod;

@CoreClass(name="Hash")
public abstract class HashNodes {

    @NodeChildren(value={@NodeChild(value="self"), @NodeChild(value="defaultProc")})
    public static abstract class SetDefaultProcNode
    extends RubyNode {
        public SetDefaultProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetDefaultProcNode(SetDefaultProcNode prev) {
            super(prev);
        }

        @Specialization
        public RubyProc setDefaultProc(RubyHash hash, RubyProc defaultProc) {
            hash.setDefaultValue(null);
            hash.setDefaultBlock(defaultProc);
            return defaultProc;
        }

        @Specialization
        public RubyNilClass setDefaultProc(RubyHash hash, RubyNilClass nil) {
            hash.setDefaultValue(null);
            hash.setDefaultBlock(null);
            return this.nil();
        }
    }

    @NodeChildren(value={@NodeChild(value="self"), @NodeChild(value="defaultValue")})
    public static abstract class SetDefaultValueNode
    extends RubyNode {
        public SetDefaultValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetDefaultValueNode(SetDefaultValueNode prev) {
            super(prev);
        }

        @Specialization
        public Object setDefaultValue(RubyHash hash, Object defaultValue) {
            hash.setDefaultValue(defaultValue);
            return defaultValue;
        }
    }

    @NodeChild(value="self")
    public static abstract class DefaultValueNode
    extends RubyNode {
        public DefaultValueNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DefaultValueNode(DefaultValueNode prev) {
            super(prev);
        }

        @Specialization
        public Object defaultValue(RubyHash hash) {
            Object value = hash.getDefaultValue();
            if (value == null) {
                return this.nil();
            }
            return value;
        }
    }

    @CoreMethod(names={"rehash"}, raiseIfFrozenSelf=true)
    public static abstract class RehashNode
    extends HashCoreMethodNode {
        public RehashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RehashNode(RehashNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyHash rehashNull(RubyHash hash) {
            return hash;
        }

        @Specialization(guards={"!isNull", "!isBuckets"})
        public RubyHash rehashPackedArray(RubyHash hash) {
            return hash;
        }

        @Specialization(guards={"isBuckets"})
        public RubyHash rehashBuckets(RubyHash hash) {
            RehashNode.notDesignedForCompilation();
            HashOperations.verySlowSetKeyValues(hash, HashOperations.verySlowToKeyValues(hash), hash.isCompareByIdentity());
            return hash;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends HashCoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public int sizeNull(RubyHash hash) {
            return 0;
        }

        @Specialization(guards={"!isNull"})
        public int sizePackedArray(RubyHash hash) {
            return hash.getSize();
        }
    }

    @CoreMethod(names={"shift"}, raiseIfFrozenSelf=true)
    public static abstract class ShiftNode
    extends HashCoreMethodNode {
        public ShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ShiftNode(ShiftNode prev) {
            super(prev);
        }

        @Specialization(guards={"isEmpty", "!hasDefaultValue", "!hasDefaultBlock"})
        public RubyNilClass shiftEmpty(RubyHash hash) {
            return this.nil();
        }

        @Specialization(guards={"isEmpty", "hasDefaultValue", "!hasDefaultBlock"})
        public Object shiftEmpyDefaultValue(RubyHash hash) {
            return hash.getDefaultValue();
        }

        @Specialization(guards={"isEmpty", "!hasDefaultValue", "hasDefaultBlock"})
        public Object shiftEmptyDefaultProc(RubyHash hash) {
            ShiftNode.notDesignedForCompilation();
            return hash.getDefaultBlock().rootCall(hash, this.nil());
        }

        @Specialization(guards={"!isEmpty", "!isNull", "!isBuckets"})
        public RubyArray shiftPackedArray(RubyHash hash) {
            ShiftNode.notDesignedForCompilation();
            Object[] store = (Object[])hash.getStore();
            Object key = store[0];
            Object value = store[1];
            System.arraycopy(store, 2, store, 0, HashOperations.SMALL_HASH_SIZE * 2 - 2);
            hash.setSize(hash.getSize() - 1);
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), key, value);
        }

        @Specialization(guards={"!isEmpty", "isBuckets"})
        public RubyArray shiftBuckets(RubyHash hash) {
            ShiftNode.notDesignedForCompilation();
            Entry first = hash.getFirstInSequence();
            Object key = first.getKey();
            Object value = first.getValue();
            hash.setFirstInSequence(first.getNextInSequence());
            if (first.getPreviousInSequence() != null) {
                first.getPreviousInSequence().setNextInSequence(null);
            }
            if (first.getNextInSequence() != null) {
                first.getNextInSequence().setPreviousInSequence(null);
            }
            if (hash.getLastInSequence() == first) {
                hash.setLastInSequence(null);
            }
            Entry[] store = (Entry[])hash.getStore();
            block0: for (int n = 0; n < store.length; ++n) {
                Entry previous = null;
                for (Entry entry = store[n]; entry != null; entry = entry.getNextInLookup()) {
                    if (entry == first) {
                        if (previous == null) {
                            store[n] = first.getNextInLookup();
                            break block0;
                        }
                        previous.setNextInLookup(first.getNextInLookup());
                        break block0;
                    }
                    previous = entry;
                }
            }
            hash.setSize(hash.getSize() - 1);
            return RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), key, value);
        }
    }

    @CoreMethod(names={"default="}, required=1)
    public static abstract class SetDefaultNode
    extends HashCoreMethodNode {
        public SetDefaultNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SetDefaultNode(SetDefaultNode prev) {
            super(prev);
        }

        @Specialization
        public Object setDefault(VirtualFrame frame, RubyHash hash, Object defaultValue) {
            SetDefaultNode.notDesignedForCompilation();
            this.ruby(frame, "Rubinius.check_frozen", new Object[0]);
            hash.setDefaultValue(defaultValue);
            hash.setDefaultBlock(null);
            return defaultValue;
        }
    }

    @ImportGuards(value={HashGuards.class})
    @CoreMethod(names={"merge"}, required=1, needsBlock=true)
    public static abstract class MergeNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;
        private final BranchProfile nothingFromFirstProfile = BranchProfile.create();
        private final BranchProfile considerNothingFromSecondProfile = BranchProfile.create();
        private final BranchProfile nothingFromSecondProfile = BranchProfile.create();
        private final BranchProfile considerResultIsSmallProfile = BranchProfile.create();
        private final BranchProfile resultIsSmallProfile = BranchProfile.create();
        private final int smallHashSize = HashOperations.SMALL_HASH_SIZE;

        public MergeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public MergeNode(MergeNode prev) {
            super(prev);
            this.eqlNode = prev.eqlNode;
            this.fallbackCallNode = prev.fallbackCallNode;
        }

        @Specialization(guards={"!isNull", "!isBuckets", "isNull(arguments[1])", "!isCompareByIdentity(arguments[0])"})
        public RubyHash mergePackedArrayNull(RubyHash hash, RubyHash other, UndefinedPlaceholder block) {
            Object[] store = (Object[])hash.getStore();
            Object[] copy = Arrays.copyOf(store, HashOperations.SMALL_HASH_SIZE * 2);
            return new RubyHash(hash.getLogicalClass(), hash.getDefaultBlock(), hash.getDefaultValue(), copy, hash.getSize(), null);
        }

        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets", "!isNull(arguments[1])", "!isBuckets(arguments[1])", "!isCompareByIdentity(arguments[0])"})
        public RubyHash mergePackedArrayPackedArray(VirtualFrame frame, RubyHash hash, RubyHash other, UndefinedPlaceholder block) {
            Object[] storeA = (Object[])hash.getStore();
            int storeASize = hash.getSize();
            Object[] storeB = (Object[])other.getStore();
            int storeBSize = other.getSize();
            boolean[] mergeFromA = new boolean[storeASize];
            int mergeFromACount = 0;
            int conflictsCount = 0;
            for (int a = 0; a < HashOperations.SMALL_HASH_SIZE; ++a) {
                if (a >= storeASize) continue;
                boolean merge = true;
                for (int b = 0; b < HashOperations.SMALL_HASH_SIZE; ++b) {
                    if (b >= storeBSize || !this.eqlNode.callBoolean(frame, storeA[a * 2], "eql?", null, storeB[b * 2])) continue;
                    ++conflictsCount;
                    merge = false;
                    break;
                }
                if (merge) {
                    ++mergeFromACount;
                }
                mergeFromA[a] = merge;
            }
            if (mergeFromACount == 0) {
                this.nothingFromFirstProfile.enter();
                return new RubyHash(hash.getLogicalClass(), hash.getDefaultBlock(), hash.getDefaultValue(), Arrays.copyOf(storeB, HashOperations.SMALL_HASH_SIZE * 2), storeBSize, null);
            }
            this.considerNothingFromSecondProfile.enter();
            if (conflictsCount == storeBSize) {
                this.nothingFromSecondProfile.enter();
                return new RubyHash(hash.getLogicalClass(), hash.getDefaultBlock(), hash.getDefaultValue(), Arrays.copyOf(storeA, HashOperations.SMALL_HASH_SIZE * 2), storeASize, null);
            }
            this.considerResultIsSmallProfile.enter();
            int mergedSize = storeBSize + mergeFromACount;
            if (storeBSize + mergeFromACount <= this.smallHashSize) {
                int n;
                this.resultIsSmallProfile.enter();
                Object[] merged = new Object[HashOperations.SMALL_HASH_SIZE * 2];
                int index = 0;
                for (n = 0; n < storeASize; ++n) {
                    if (!mergeFromA[n]) continue;
                    merged[index] = storeA[n * 2];
                    merged[index + 1] = storeA[n * 2 + 1];
                    index += 2;
                }
                for (n = 0; n < storeBSize; ++n) {
                    merged[index] = storeB[n * 2];
                    merged[index + 1] = storeB[n * 2 + 1];
                    index += 2;
                }
                return new RubyHash(hash.getLogicalClass(), hash.getDefaultBlock(), hash.getDefaultValue(), merged, mergedSize, null);
            }
            CompilerDirectives.transferToInterpreter();
            return this.mergeBucketsBuckets(hash, other, block);
        }

        @Specialization(guards={"!isCompareByIdentity(arguments[0])"})
        public RubyHash mergeBucketsBuckets(RubyHash hash, RubyHash other, UndefinedPlaceholder block) {
            MergeNode.notDesignedForCompilation();
            RubyHash merged = new RubyHash(hash.getLogicalClass(), null, null, new Entry[HashOperations.capacityGreaterThan(hash.getSize() + other.getSize())], 0, null);
            int size = 0;
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash)) {
                HashOperations.verySlowSetInBuckets(merged, keyValue.getKey(), keyValue.getValue(), false);
                ++size;
            }
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(other)) {
                if (!HashOperations.verySlowSetInBuckets(merged, keyValue.getKey(), keyValue.getValue(), false)) continue;
                ++size;
            }
            merged.setSize(size);
            return merged;
        }

        @Specialization(guards={"!isCompareByIdentity(arguments[0])"})
        public RubyHash merge(VirtualFrame frame, RubyHash hash, RubyHash other, RubyProc block) {
            MergeNode.notDesignedForCompilation();
            RubyHash merged = new RubyHash(hash.getLogicalClass(), null, null, new Entry[HashOperations.capacityGreaterThan(hash.getSize() + other.getSize())], 0, null);
            int size = 0;
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash)) {
                HashOperations.verySlowSetInBuckets(merged, keyValue.getKey(), keyValue.getValue(), false);
                ++size;
            }
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(other)) {
                HashSearchResult searchResult = HashOperations.verySlowFindBucket(merged, keyValue.getKey(), false);
                if (searchResult.getEntry() == null) {
                    HashOperations.verySlowSetInBuckets(merged, keyValue.getKey(), keyValue.getValue(), false);
                    ++size;
                    continue;
                }
                Object oldValue = searchResult.getEntry().getValue();
                Object newValue = keyValue.getValue();
                Object mergedValue = this.yield(frame, block, keyValue.getKey(), oldValue, newValue);
                HashOperations.verySlowSetInBuckets(merged, keyValue.getKey(), mergedValue, false);
            }
            merged.setSize(size);
            return merged;
        }

        @Specialization(guards={"!isRubyHash(arguments[1])", "!isCompareByIdentity(arguments[0])"})
        public Object merge(VirtualFrame frame, RubyHash hash, Object other, Object block) {
            MergeNode.notDesignedForCompilation();
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            RubyProc blockProc = block == UndefinedPlaceholder.INSTANCE ? null : (RubyProc)block;
            return this.fallbackCallNode.call(frame, hash, "merge_fallback", blockProc, other);
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true)
    @ImportGuards(value={HashGuards.class})
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        public MapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MapNode(MapNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyArray mapNull(VirtualFrame frame, RubyHash hash, RubyProc block) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets"})
        public RubyArray mapPackedArray(VirtualFrame frame, RubyHash hash, RubyProc block) {
            Object[] store = (Object[])hash.getStore();
            int size = hash.getSize();
            Object[] result = new Object[size];
            int count = 0;
            try {
                for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                    if (n >= size) continue;
                    Object key = store[n * 2];
                    Object value = store[n * 2 + 1];
                    result[n] = this.yield(frame, block, key, value);
                    if (!CompilerDirectives.inInterpreter()) continue;
                    ++count;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), result, size);
        }

        @Specialization(guards={"isBuckets"})
        public RubyArray mapBuckets(VirtualFrame frame, RubyHash hash, RubyProc block) {
            MapNode.notDesignedForCompilation();
            RubyArray array = new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash)) {
                array.slowPush(this.yield(frame, block, keyValue.getKey(), keyValue.getValue()));
            }
            return array;
        }
    }

    @CoreMethod(names={"initialize_copy", "replace"}, required=1, raiseIfFrozenSelf=true)
    public static abstract class InitializeCopyNode
    extends HashCoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull(arguments[1])"})
        public RubyHash dupNull(RubyHash self, RubyHash from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self == from) {
                return self;
            }
            self.setStore(null, 0, null, null);
            this.copyOther(self, from);
            return self;
        }

        @Specialization(guards={"!isNull(arguments[1])", "!isBuckets(arguments[1])"})
        public RubyHash dupPackedArray(RubyHash self, RubyHash from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self == from) {
                return self;
            }
            Object[] store = (Object[])from.getStore();
            self.setStore(Arrays.copyOf(store, HashOperations.SMALL_HASH_SIZE * 2), from.getSize(), null, null);
            this.copyOther(self, from);
            return self;
        }

        @Specialization(guards={"isBuckets(arguments[1])"})
        public RubyHash dupBuckets(RubyHash self, RubyHash from) {
            InitializeCopyNode.notDesignedForCompilation();
            if (self == from) {
                return self;
            }
            HashOperations.verySlowSetKeyValues(self, HashOperations.verySlowToKeyValues(from), from.isCompareByIdentity());
            this.copyOther(self, from);
            return self;
        }

        @Specialization(guards={"!isRubyHash(arguments[1])"})
        public Object dupBuckets(VirtualFrame frame, RubyHash self, Object other) {
            return this.ruby(frame, "replace(Rubinius::Type.coerce_to other, Hash, :to_hash)", "other", other);
        }

        private void copyOther(RubyHash self, RubyHash from) {
            self.setDefaultBlock(from.getDefaultBlock());
            self.setDefaultValue(from.getDefaultValue());
            self.setCompareByIdentity(from.isCompareByIdentity());
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=1, raiseIfFrozenSelf=true)
    public static abstract class InitializeNode
    extends HashCoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyHash initialize(RubyHash hash, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            hash.setStore(null, 0, null, null);
            hash.setDefaultValue(null);
            hash.setDefaultBlock(null);
            return hash;
        }

        @Specialization
        public RubyHash initialize(RubyHash hash, UndefinedPlaceholder defaultValue, RubyProc block) {
            hash.setStore(null, 0, null, null);
            hash.setDefaultValue(null);
            hash.setDefaultBlock(block);
            return hash;
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[1])"})
        public RubyHash initialize(RubyHash hash, Object defaultValue, UndefinedPlaceholder block) {
            hash.setStore(null, 0, null, null);
            hash.setDefaultValue(defaultValue);
            hash.setDefaultBlock(null);
            return hash;
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[1])"})
        public Object initialize(RubyHash hash, Object defaultValue, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().argumentError("wrong number of arguments (1 for 0)", this));
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends HashCoreMethodNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EmptyNode(EmptyNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public boolean emptyNull(RubyHash hash) {
            return true;
        }

        @Specialization(guards={"!isNull"})
        public boolean emptyPackedArray(RubyHash hash) {
            return hash.getSize() == 0;
        }
    }

    @CoreMethod(names={"each", "each_pair"}, needsBlock=true)
    @ImportGuards(value={HashGuards.class})
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toEnumNode;

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachNode(EachNode prev) {
            super(prev);
            this.toEnumNode = prev.toEnumNode;
        }

        @Specialization(guards={"isNull"})
        public RubyHash eachNull(RubyHash hash, RubyProc block) {
            return hash;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets"})
        public RubyHash eachPackedArray(VirtualFrame frame, RubyHash hash, RubyProc block) {
            Object[] store = (Object[])hash.getStore();
            int size = hash.getSize();
            int count = 0;
            try {
                for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    if (n >= size) continue;
                    this.yield(frame, block, new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{store[n * 2], store[n * 2 + 1]}, 2));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return hash;
        }

        @Specialization(guards={"isBuckets"})
        public RubyHash eachBuckets(VirtualFrame frame, RubyHash hash, RubyProc block) {
            EachNode.notDesignedForCompilation();
            for (KeyValue keyValue : HashOperations.verySlowToKeyValues(hash)) {
                this.yield(frame, block, RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), keyValue.getKey(), keyValue.getValue()));
            }
            return hash;
        }

        @Specialization
        public Object each(VirtualFrame frame, RubyHash hash, UndefinedPlaceholder block) {
            EachNode.notDesignedForCompilation();
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toEnumNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            InternalMethod method = RubyArguments.getMethod(frame.getArguments());
            return this.toEnumNode.call(frame, hash, "to_enum", null, this.getContext().getSymbolTable().getSymbol(method.getName()));
        }
    }

    @CoreMethod(names={"delete"}, required=1, needsBlock=true, raiseIfFrozenSelf=true)
    public static abstract class DeleteNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private FindEntryNode findEntryNode;
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
            this.findEntryNode = new FindEntryNode(context, sourceSection);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        public DeleteNode(DeleteNode prev) {
            super(prev);
            this.eqlNode = prev.eqlNode;
            this.findEntryNode = prev.findEntryNode;
            this.yieldNode = prev.yieldNode;
        }

        @Specialization(guards={"isNull"})
        public Object deleteNull(VirtualFrame frame, RubyHash hash, Object key, Object block) {
            if (block == UndefinedPlaceholder.INSTANCE) {
                return this.nil();
            }
            return this.yieldNode.dispatch(frame, (RubyProc)block, key);
        }

        @Specialization(guards={"!isNull", "!isBuckets", "!isCompareByIdentity(arguments[0])"})
        public Object deletePackedArray(VirtualFrame frame, RubyHash hash, Object key, Object block) {
            Object[] store = (Object[])hash.getStore();
            int size = hash.getSize();
            for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                if (n >= size || !this.eqlNode.callBoolean(frame, store[n * 2], "eql?", null, key)) continue;
                Object value = store[n * 2 + 1];
                int k = n * 2;
                System.arraycopy(store, k + 2, store, k, (size - n - 1) * 2);
                hash.setSize(size - 1);
                return value;
            }
            if (block == UndefinedPlaceholder.INSTANCE) {
                return this.nil();
            }
            return this.yieldNode.dispatch(frame, (RubyProc)block, key);
        }

        @Specialization(guards={"isBuckets"})
        public Object delete(VirtualFrame frame, RubyHash hash, Object key, Object block) {
            DeleteNode.notDesignedForCompilation();
            HashSearchResult hashSearchResult = this.findEntryNode.search(frame, hash, key);
            if (hashSearchResult.getEntry() == null) {
                if (block == UndefinedPlaceholder.INSTANCE) {
                    return this.nil();
                }
                return this.yieldNode.dispatch(frame, (RubyProc)block, key);
            }
            Entry entry = hashSearchResult.getEntry();
            if (entry.getPreviousInSequence() == null) {
                hash.setFirstInSequence(entry.getNextInSequence());
            } else {
                entry.getPreviousInSequence().setNextInSequence(entry.getNextInSequence());
            }
            if (entry.getNextInSequence() == null) {
                hash.setLastInSequence(entry.getPreviousInSequence());
            } else {
                entry.getNextInSequence().setPreviousInSequence(entry.getPreviousInSequence());
            }
            if (hashSearchResult.getPreviousEntry() == null) {
                ((Entry[])hash.getStore())[hashSearchResult.getIndex()] = entry.getNextInLookup();
            } else {
                hashSearchResult.getPreviousEntry().setNextInLookup(entry.getNextInLookup());
            }
            hash.setSize(hash.getSize() - 1);
            return entry.getValue();
        }
    }

    @CoreMethod(names={"default_proc"})
    public static abstract class DefaultProcNode
    extends HashCoreMethodNode {
        public DefaultProcNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DefaultProcNode(DefaultProcNode prev) {
            super(prev);
        }

        @Specialization
        public Object defaultProc(RubyHash hash) {
            if (hash.getDefaultBlock() == null) {
                return this.nil();
            }
            return hash.getDefaultBlock();
        }
    }

    @CoreMethod(names={"compare_by_identity?"})
    public static abstract class IsCompareByIdentityNode
    extends HashCoreMethodNode {
        private final ConditionProfile profile = ConditionProfile.createBinaryProfile();

        public IsCompareByIdentityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IsCompareByIdentityNode(IsCompareByIdentityNode prev) {
            super(prev);
        }

        @Specialization
        public boolean compareByIdentity(RubyHash hash) {
            return this.profile.profile(hash.isCompareByIdentity());
        }
    }

    @CoreMethod(names={"compare_by_identity"}, raiseIfFrozenSelf=true)
    public static abstract class CompareByIdentityNode
    extends HashCoreMethodNode {
        public CompareByIdentityNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareByIdentityNode(CompareByIdentityNode prev) {
            super(prev);
        }

        @Specialization
        public RubyHash compareByIdentity(RubyHash hash) {
            hash.setCompareByIdentity(true);
            return hash;
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends HashCoreMethodNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClearNode(ClearNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyHash emptyNull(RubyHash hash) {
            return hash;
        }

        @Specialization(guards={"!isNull"})
        public RubyHash empty(RubyHash hash) {
            hash.setStore(null, 0, null, null);
            return hash;
        }
    }

    @CoreMethod(names={"[]="}, required=2, raiseIfFrozenSelf=true)
    public static abstract class SetIndexNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode hashNode;
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode equalNode;
        private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile considerExtendProfile = BranchProfile.create();
        private final BranchProfile extendProfile = BranchProfile.create();

        public SetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = DispatchHeadNodeFactory.createMethodCall(context, true);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
            this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
        }

        public SetIndexNode(SetIndexNode prev) {
            super(prev);
            this.hashNode = prev.hashNode;
            this.eqlNode = prev.eqlNode;
            this.equalNode = prev.equalNode;
        }

        @Specialization(guards={"isNull", "!isRubyString(arguments[1])"})
        public Object setNull(VirtualFrame frame, RubyHash hash, Object key, Object value) {
            Object[] store = new Object[HashOperations.SMALL_HASH_SIZE * 2];
            this.hashNode.call(frame, key, "hash", null, new Object[0]);
            store[0] = key;
            store[1] = value;
            hash.setStore(store, 1, null, null);
            return value;
        }

        @Specialization(guards={"isNull"})
        public Object setNull(VirtualFrame frame, RubyHash hash, RubyString key, Object value) {
            SetIndexNode.notDesignedForCompilation();
            if (hash.isCompareByIdentity()) {
                return this.setNull(frame, hash, (Object)key, value);
            }
            return this.setNull(frame, hash, this.ruby(frame, "key.frozen? ? key : key.dup.freeze", "key", key), value);
        }

        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets", "!isRubyString(arguments[1])"})
        public Object setPackedArray(VirtualFrame frame, RubyHash hash, Object key, Object value) {
            this.hashNode.call(frame, key, "hash", null, new Object[0]);
            Object[] store = (Object[])hash.getStore();
            int size = hash.getSize();
            for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                boolean equal;
                if (n >= size || !(equal = this.byIdentityProfile.profile(hash.isCompareByIdentity()) ? this.equalNode.executeReferenceEqual(frame, key, store[n * 2]) : this.eqlNode.callBoolean(frame, key, "eql?", null, store[n * 2]))) continue;
                store[n * 2 + 1] = value;
                return value;
            }
            this.considerExtendProfile.enter();
            int newSize = size + 1;
            if (newSize <= HashOperations.SMALL_HASH_SIZE) {
                this.extendProfile.enter();
                store[size * 2] = key;
                store[size * 2 + 1] = value;
                hash.setSize(newSize);
                return value;
            }
            CompilerDirectives.transferToInterpreter();
            List<KeyValue> entries = HashOperations.verySlowToKeyValues(hash);
            hash.setStore(new Entry[HashOperations.capacityGreaterThan(newSize)], newSize, null, null);
            for (KeyValue keyValue : entries) {
                HashOperations.verySlowSetInBuckets(hash, keyValue.getKey(), keyValue.getValue(), hash.isCompareByIdentity());
            }
            HashOperations.verySlowSetInBuckets(hash, key, value, false);
            return value;
        }

        @Specialization(guards={"!isNull", "!isBuckets"})
        public Object setPackedArray(VirtualFrame frame, RubyHash hash, RubyString key, Object value) {
            SetIndexNode.notDesignedForCompilation();
            if (hash.isCompareByIdentity()) {
                return this.setPackedArray(frame, hash, (Object)key, value);
            }
            return this.setPackedArray(frame, hash, this.ruby(frame, "key.frozen? ? key : key.dup.freeze", "key", key), value);
        }

        @Specialization(guards={"isBuckets", "!isRubyString(arguments[1])"})
        public Object setBuckets(RubyHash hash, Object key, Object value) {
            SetIndexNode.notDesignedForCompilation();
            if (HashOperations.verySlowSetInBuckets(hash, key, value, hash.isCompareByIdentity())) {
                hash.setSize(hash.getSize() + 1);
            }
            return value;
        }

        @Specialization(guards={"isBuckets"})
        public Object setBuckets(VirtualFrame frame, RubyHash hash, RubyString key, Object value) {
            SetIndexNode.notDesignedForCompilation();
            if (hash.isCompareByIdentity()) {
                return this.setBuckets(hash, key, value);
            }
            return this.setBuckets(hash, this.ruby(frame, "key.frozen? ? key : key.dup.freeze", "key", key), value);
        }
    }

    @CoreMethod(names={"_get_or_undefined"}, required=1)
    public static abstract class GetOrUndefinedNode
    extends HashCoreMethodNode {
        @Node.Child
        private GetIndexNode getIndexNode;

        public GetOrUndefinedNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.getIndexNode = HashNodesFactory.GetIndexNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
            this.getIndexNode.setUndefinedValue(context.getCoreLibrary().getRubiniusUndefined());
        }

        public GetOrUndefinedNode(GetOrUndefinedNode prev) {
            super(prev);
            this.getIndexNode = prev.getIndexNode;
        }

        @Specialization
        public Object getOrUndefined(VirtualFrame frame, RubyHash hash, Object key) {
            return this.getIndexNode.executeGet(frame, hash, key);
        }
    }

    @CoreMethod(names={"[]"}, required=1)
    public static abstract class GetIndexNode
    extends HashCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode hashNode;
        @Node.Child
        private CallDispatchHeadNode eqlNode;
        @Node.Child
        private BasicObjectNodes.ReferenceEqualNode equalNode;
        @Node.Child
        private CallDispatchHeadNode callDefaultNode;
        @Node.Child
        private FindEntryNode findEntryNode;
        private final ConditionProfile byIdentityProfile = ConditionProfile.createBinaryProfile();
        private final BranchProfile notInHashProfile = BranchProfile.create();
        private final BranchProfile useDefaultProfile = BranchProfile.create();
        @CompilerDirectives.CompilationFinal
        private Object undefinedValue;

        public GetIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.hashNode = DispatchHeadNodeFactory.createMethodCall(context, true);
            this.eqlNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
            this.equalNode = BasicObjectNodesFactory.ReferenceEqualNodeFactory.create(context, sourceSection, null, null);
            this.callDefaultNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.findEntryNode = new FindEntryNode(context, sourceSection);
        }

        public GetIndexNode(GetIndexNode prev) {
            super(prev);
            this.hashNode = prev.hashNode;
            this.eqlNode = prev.eqlNode;
            this.equalNode = prev.equalNode;
            this.callDefaultNode = prev.callDefaultNode;
            this.findEntryNode = prev.findEntryNode;
            this.undefinedValue = prev.undefinedValue;
        }

        public abstract Object executeGet(VirtualFrame var1, RubyHash var2, Object var3);

        @Specialization(guards={"isNull"})
        public Object getNull(VirtualFrame frame, RubyHash hash, Object key) {
            this.hashNode.call(frame, key, "hash", null, new Object[0]);
            if (this.undefinedValue != null) {
                return this.undefinedValue;
            }
            return this.callDefaultNode.call(frame, hash, "default", null, key);
        }

        @ExplodeLoop
        @Specialization(guards={"!isNull", "!isBuckets"})
        public Object getPackedArray(VirtualFrame frame, RubyHash hash, Object key) {
            this.hashNode.call(frame, key, "hash", null, new Object[0]);
            Object[] store = (Object[])hash.getStore();
            int size = hash.getSize();
            for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                boolean equal;
                if (n >= size || !(equal = this.byIdentityProfile.profile(hash.isCompareByIdentity()) ? this.equalNode.executeReferenceEqual(frame, key, store[n * 2]) : this.eqlNode.callBoolean(frame, key, "eql?", null, store[n * 2]))) continue;
                return store[n * 2 + 1];
            }
            this.notInHashProfile.enter();
            if (this.undefinedValue != null) {
                return this.undefinedValue;
            }
            this.useDefaultProfile.enter();
            return this.callDefaultNode.call(frame, hash, "default", null, key);
        }

        @Specialization(guards={"isBuckets"})
        public Object getBuckets(VirtualFrame frame, RubyHash hash, Object key) {
            HashSearchResult hashSearchResult = this.findEntryNode.search(frame, hash, key);
            if (hashSearchResult.getEntry() != null) {
                return hashSearchResult.getEntry().getValue();
            }
            this.notInHashProfile.enter();
            if (this.undefinedValue != null) {
                return this.undefinedValue;
            }
            this.useDefaultProfile.enter();
            return this.callDefaultNode.call(frame, hash, "default", null, key);
        }

        public void setUndefinedValue(Object undefinedValue) {
            this.undefinedValue = undefinedValue;
        }
    }

    @CoreMethod(names={"[]"}, onSingleton=true, argumentsAsArray=true, reallyDoesNeedSelf=true)
    public static abstract class ConstructNode
    extends HashCoreMethodNode {
        public ConstructNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConstructNode(ConstructNode prev) {
            super(prev);
        }

        @ExplodeLoop
        @Specialization(guards={"isSmallArrayOfPairs"})
        public Object construct(VirtualFrame frame, RubyClass hashClass, Object[] args) {
            RubyArray array = (RubyArray)args[0];
            Object[] store = (Object[])array.getStore();
            int size = array.getSize();
            Object[] newStore = new Object[HashOperations.SMALL_HASH_SIZE * 2];
            for (int n = 0; n < HashOperations.SMALL_HASH_SIZE; ++n) {
                if (n >= size) continue;
                Object pair = store[n];
                if (!(pair instanceof RubyArray)) {
                    CompilerDirectives.transferToInterpreter();
                    return this.constructFallback(frame, hashClass, args);
                }
                RubyArray pairArray = (RubyArray)pair;
                if (!(pairArray.getStore() instanceof Object[])) {
                    CompilerDirectives.transferToInterpreter();
                    return this.constructFallback(frame, hashClass, args);
                }
                Object[] pairStore = (Object[])pairArray.getStore();
                newStore[n * 2] = pairStore[0];
                newStore[n * 2 + 1] = pairStore[1];
            }
            return new RubyHash(hashClass, null, null, newStore, size, null);
        }

        @Specialization
        public Object constructFallback(VirtualFrame frame, RubyClass hashClass, Object[] args) {
            return this.ruby(frame, "_constructor_fallback(*args)", "args", RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), args));
        }

        public static boolean isSmallArrayOfPairs(RubyClass hashClass, Object[] args) {
            if (args.length != 1) {
                return false;
            }
            Object arg = args[0];
            if (!(arg instanceof RubyArray)) {
                return false;
            }
            RubyArray array = (RubyArray)arg;
            if (!(array.getStore() instanceof Object[])) {
                return false;
            }
            Object[] store = (Object[])array.getStore();
            return store.length <= HashOperations.SMALL_HASH_SIZE;
        }
    }
}

