/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ExactMath;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.math.BigInteger;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.BignumNodes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumNodesFactory;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.GeneralDivModNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Fixnum")
public abstract class FixnumNodes {
    private static final int BITS = 64;

    @CoreMethod(names={"zero?"})
    public static abstract class ZeroNode
    extends CoreMethodNode {
        public ZeroNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ZeroNode(ZeroNode prev) {
            super(prev);
        }

        @Specialization
        public boolean zero(int n) {
            return n == 0;
        }

        @Specialization
        public boolean zero(long n) {
            return n == 0L;
        }
    }

    @CoreMethod(names={"to_s"}, optional=1)
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(int n, UndefinedPlaceholder undefined) {
            return this.getContext().makeString(Integer.toString(n));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(long n, UndefinedPlaceholder undefined) {
            return this.getContext().makeString(Long.toString(n));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(int n, int base) {
            return this.toS((long)n, base);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(long n, int base) {
            if (base < 2 || base > 36) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorInvalidRadix(base, this));
            }
            return this.getContext().makeString(Long.toString(n, base));
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToFNode(ToFNode prev) {
            super(prev);
        }

        @Specialization
        public double toF(int n) {
            return n;
        }

        @Specialization
        public double toF(long n) {
            return n;
        }
    }

    @CoreMethod(names={"size"}, needsSelf=false)
    public static abstract class SizeNode
    extends CoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization
        public int size() {
            return 8;
        }
    }

    @CoreMethod(names={"inspect"})
    public static abstract class InspectNode
    extends CoreMethodNode {
        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString inspect(int n) {
            return this.getContext().makeString(Integer.toString(n));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString inspect(long n) {
            return this.getContext().makeString(Long.toString(n));
        }
    }

    @CoreMethod(names={"floor"})
    public static abstract class FloorNode
    extends CoreMethodNode {
        public FloorNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FloorNode(FloorNode prev) {
            super(prev);
        }

        @Specialization
        public int floor(int n) {
            return n;
        }

        @Specialization
        public long floor(long n) {
            return n;
        }
    }

    @CoreMethod(names={"bit_length"})
    public static abstract class BitLengthNode
    extends CoreMethodNode {
        private static final int INTEGER_BITS = Integer.numberOfLeadingZeros(0);
        private static final int LONG_BITS = Long.numberOfLeadingZeros(0L);

        public BitLengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitLengthNode(BitLengthNode prev) {
            super(prev);
        }

        @Specialization
        public int bitLength(int n) {
            return this.bitLength((long)n);
        }

        @Specialization
        public int bitLength(long n) {
            if (n < 0L) {
                n ^= 0xFFFFFFFFFFFFFFFFL;
            }
            if (n == Long.MAX_VALUE) {
                return LONG_BITS - 1;
            }
            return LONG_BITS - Long.numberOfLeadingZeros(n);
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends CoreMethodNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AbsNode(AbsNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int absIntInBounds(int n) {
            return n < 0 ? ExactMath.subtractExact((int)0, (int)n) : n;
        }

        @Specialization(contains={"absIntInBounds"})
        public Object abs(int n) {
            if (n == Integer.MIN_VALUE) {
                return -((long)n);
            }
            return n < 0 ? -n : n;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long absInBounds(long n) {
            return n < 0L ? ExactMath.subtractExact((long)0L, (long)n) : n;
        }

        @Specialization(contains={"absInBounds"})
        public Object abs(long n) {
            if (n == Long.MIN_VALUE) {
                return new RubyBignum(this.getContext().getCoreLibrary().getBignumClass(), BigInteger.valueOf(n).abs());
            }
            return n < 0L ? -n : n;
        }
    }

    @CoreMethod(names={">>"}, required=1)
    public static abstract class RightShiftNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;
        @Node.Child
        private LeftShiftNode leftShiftNode;

        public RightShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RightShiftNode(RightShiftNode prev) {
            super(prev);
            this.fallbackCallNode = prev.fallbackCallNode;
            this.leftShiftNode = prev.leftShiftNode;
        }

        protected abstract Object executeRightShift(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public Object rightShift(VirtualFrame frame, int a, int b) {
            if (b > 0) {
                if (b >= 63) {
                    if (a < 0) {
                        return -1;
                    }
                    return 0;
                }
                return a >> b;
            }
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = (LeftShiftNode)this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, -b);
        }

        @Specialization
        public Object rightShift(VirtualFrame frame, int a, long b) {
            if (b > 0L) {
                if (b >= 63L) {
                    if (a < 0) {
                        return -1;
                    }
                    return 0;
                }
                return a >> (int)b;
            }
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = (LeftShiftNode)this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, -b);
        }

        @Specialization
        public Object rightShift(VirtualFrame frame, long a, int b) {
            if (b > 0) {
                if (b >= 63) {
                    if (a < 0L) {
                        return -1;
                    }
                    return 0;
                }
                return a >> b;
            }
            if (this.leftShiftNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.leftShiftNode = (LeftShiftNode)this.insert(FixnumNodesFactory.LeftShiftNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            return this.leftShiftNode.executeLeftShift(frame, a, -b);
        }

        @Specialization
        public int rightShift(int a, RubyBignum b) {
            return 0;
        }

        @Specialization
        public int rightShift(long a, RubyBignum b) {
            return 0;
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])"})
        public Object rightShiftFallback(VirtualFrame frame, Object a, Object b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.fallbackCallNode.call(frame, a, "right_shift_fallback", null, b);
        }
    }

    @CoreMethod(names={"<<"}, required=1)
    public static abstract class LeftShiftNode
    extends BignumNodes.BignumCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode fallbackCallNode;

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LeftShiftNode(LeftShiftNode prev) {
            super(prev);
            this.fallbackCallNode = prev.fallbackCallNode;
        }

        protected Object lower(BigInteger value) {
            return this.fixnumOrBignum(value);
        }

        public abstract Object executeLeftShift(VirtualFrame var1, Object var2, Object var3);

        @Specialization(guards={"isPositive(arguments[1])", "canShiftIntoInt"})
        public int leftShift(int a, int b) {
            return a << b;
        }

        @Specialization(guards={"isPositive(arguments[1])", "canShiftIntoInt"})
        public int leftShift(int a, long b) {
            return a << (int)b;
        }

        @Specialization(guards={"isPositive(arguments[1])", "canShiftIntoLong"})
        public long leftShiftToLong(int a, int b) {
            return this.leftShiftToLong((long)a, b);
        }

        @Specialization(guards={"isPositive(arguments[1])"})
        public Object leftShiftWithOverflow(int a, int b) {
            return this.leftShiftWithOverflow((long)a, b);
        }

        @Specialization(guards={"isStrictlyNegative(arguments[1])"})
        public int leftShiftNeg(int a, int b) {
            if (-b >= 32) {
                return 0;
            }
            if (b == Integer.MIN_VALUE) {
                return 0;
            }
            return a >> -b;
        }

        @Specialization(guards={"isPositive(arguments[1])", "canShiftIntoLong"})
        public long leftShiftToLong(long a, int b) {
            return a << b;
        }

        @Specialization(guards={"isPositive(arguments[1])"})
        public Object leftShiftWithOverflow(long a, int b) {
            if (LeftShiftNode.canShiftIntoLong(a, b)) {
                return this.leftShiftToLong(a, b);
            }
            return this.lower(BigInteger.valueOf(a).shiftLeft(b));
        }

        @Specialization(guards={"isStrictlyNegative(arguments[1])"})
        public long leftShiftNeg(long a, int b) {
            if (-b >= 32) {
                return 0L;
            }
            return a >> -b;
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])"})
        public Object leftShiftFallback(VirtualFrame frame, Object a, Object b) {
            if (this.fallbackCallNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackCallNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
            }
            return this.fallbackCallNode.call(frame, a, "left_shift_fallback", null, b);
        }

        static boolean canShiftIntoInt(int a, int b) {
            return Integer.numberOfLeadingZeros(a) - b > 0;
        }

        static boolean canShiftIntoInt(int a, long b) {
            return (long)Integer.numberOfLeadingZeros(a) - b > 0L;
        }

        static boolean canShiftIntoLong(int a, int b) {
            return LeftShiftNode.canShiftIntoLong((long)a, b);
        }

        static boolean canShiftIntoLong(long a, int b) {
            return Long.numberOfLeadingZeros(a) - b > 0;
        }

        static boolean isPositive(int value) {
            return value >= 0;
        }

        static boolean isPositive(long value) {
            return value >= 0L;
        }

        static boolean isStrictlyNegative(int value) {
            return value < 0;
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends BignumNodes.BignumCoreMethodNode {
        public BitXOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitXOrNode(BitXOrNode prev) {
            super(prev);
        }

        @Specialization
        public int bitXOr(int a, int b) {
            return a ^ b;
        }

        @Specialization
        public long bitXOr(int a, long b) {
            return (long)a ^ b;
        }

        @Specialization
        public Object bitXOr(int a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).xor(b.bigIntegerValue()));
        }

        @Specialization
        public long bitXOr(long a, int b) {
            return a ^ (long)b;
        }

        @Specialization
        public long bitXOr(long a, long b) {
            return a ^ b;
        }

        @Specialization
        public Object bitXOr(long a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).xor(b.bigIntegerValue()));
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object bitXOr(VirtualFrame frame, Object a, RubyBasicObject b) {
            return this.ruby(frame, "a ^ Rubinius::Type.coerce_to_bitwise_operand(b)", "a", a, "b", b);
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends BignumNodes.BignumCoreMethodNode {
        public BitOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitOrNode(BitOrNode prev) {
            super(prev);
        }

        @Specialization
        public int bitOr(int a, int b) {
            return a | b;
        }

        @Specialization
        public long bitOr(int a, long b) {
            return (long)a | b;
        }

        @Specialization
        public Object bitOr(int a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).or(b.bigIntegerValue()));
        }

        @Specialization
        public long bitOr(long a, int b) {
            return a | (long)b;
        }

        @Specialization
        public long bitOr(long a, long b) {
            return a | b;
        }

        @Specialization
        public Object bitOr(long a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).or(b.bigIntegerValue()));
        }
    }

    @CoreMethod(names={"&"}, required=1)
    public static abstract class BitAndNode
    extends BignumNodes.BignumCoreMethodNode {
        public BitAndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitAndNode(BitAndNode prev) {
            super(prev);
        }

        @Specialization
        public int bitAnd(int a, int b) {
            return a & b;
        }

        @Specialization
        public long bitAnd(int a, long b) {
            return (long)a & b;
        }

        @Specialization
        public Object bitAnd(int a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).and(b.bigIntegerValue()));
        }

        @Specialization
        public long bitAnd(long a, int b) {
            return a & (long)b;
        }

        @Specialization
        public long bitAnd(long a, long b) {
            return a & b;
        }

        @Specialization
        public Object bitAnd(long a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).and(b.bigIntegerValue()));
        }
    }

    @CoreMethod(names={"~"})
    public static abstract class ComplementNode
    extends CoreMethodNode {
        public ComplementNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ComplementNode(ComplementNode prev) {
            super(prev);
        }

        @Specialization
        public int complement(int n) {
            return ~n;
        }

        @Specialization
        public long complement(long n) {
            return n ^ 0xFFFFFFFFFFFFFFFFL;
        }
    }

    @CoreMethod(names={">"}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class GreaterNode
    extends CoreMethodNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterNode(GreaterNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greater(int a, int b) {
            return a > b;
        }

        @Specialization
        public boolean greater(int a, long b) {
            return (long)a > b;
        }

        @Specialization
        public boolean greater(int a, double b) {
            return (double)a > b;
        }

        @Specialization
        public boolean greater(int a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue()) > 0;
        }

        @Specialization
        public boolean greater(long a, int b) {
            return a > (long)b;
        }

        @Specialization
        public boolean greater(long a, long b) {
            return a > b;
        }

        @Specialization
        public boolean greater(long a, double b) {
            return (double)a > b;
        }

        @Specialization
        public boolean greater(long a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue()) > 0;
        }
    }

    @CoreMethod(names={">="}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class GreaterEqualNode
    extends CoreMethodNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterEqualNode(GreaterEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greaterEqual(int a, int b) {
            return a >= b;
        }

        @Specialization
        public boolean greaterEqual(int a, long b) {
            return (long)a >= b;
        }

        @Specialization
        public boolean greaterEqual(int a, double b) {
            return (double)a >= b;
        }

        @Specialization
        public boolean greaterEqual(int a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue()) >= 0;
        }

        @Specialization
        public boolean greaterEqual(long a, int b) {
            return a >= (long)b;
        }

        @Specialization
        public boolean greaterEqual(long a, long b) {
            return a >= b;
        }

        @Specialization
        public boolean greaterEqual(long a, double b) {
            return (double)a >= b;
        }

        @Specialization
        public boolean greaterEqual(long a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue()) >= 0;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        @Specialization
        public int compare(int a, int b) {
            return Integer.compare(a, b);
        }

        @Specialization
        public int compare(int a, long b) {
            return Long.compare(a, b);
        }

        @Specialization
        public int compare(int a, double b) {
            return Double.compare(a, b);
        }

        @Specialization
        public int compare(int a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue());
        }

        @Specialization
        public int compare(long a, int b) {
            return Long.compare(a, b);
        }

        @Specialization
        public int compare(long a, long b) {
            return Long.compare(a, b);
        }

        @Specialization
        public int compare(long a, double b) {
            return Double.compare(a, b);
        }

        @Specialization
        public int compare(long a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue());
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isDouble(arguments[1])", "!isRubyBignum(arguments[1])"})
        public Object compare(VirtualFrame frame, Object a, Object b) {
            return this.ruby(frame, "begin; b, a = math_coerce(other, :compare_error); a <=> b; rescue ArgumentError; nil; end", "other", b);
        }
    }

    @CoreMethod(names={"==", "==="}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode reverseCallNode;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.reverseCallNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
            this.reverseCallNode = prev.reverseCallNode;
        }

        @Specialization
        public boolean equal(int a, int b) {
            return a == b;
        }

        @Specialization
        public boolean equal(int a, long b) {
            return (long)a == b;
        }

        @Specialization
        public boolean equal(int a, double b) {
            return (double)a == b;
        }

        @Specialization
        public boolean equal(int a, RubyBignum b) {
            return BigInteger.valueOf(a).equals(b.bigIntegerValue());
        }

        @Specialization
        public boolean equal(long a, int b) {
            return a == (long)b;
        }

        @Specialization
        public boolean equal(long a, long b) {
            return a == b;
        }

        @Specialization
        public boolean equal(long a, double b) {
            return (double)a == b;
        }

        @Specialization
        public boolean equal(long a, RubyBignum b) {
            return BigInteger.valueOf(a).equals(b.bigIntegerValue());
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isRubyBignum(arguments[1])"})
        public Object equal(VirtualFrame frame, Object a, Object b) {
            return this.reverseCallNode.call(frame, b, "==", null, a);
        }
    }

    @CoreMethod(names={"<="}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class LessEqualNode
    extends CoreMethodNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessEqualNode(LessEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean lessEqual(int a, int b) {
            return a <= b;
        }

        @Specialization
        public boolean lessEqual(int a, long b) {
            return (long)a <= b;
        }

        @Specialization
        public boolean lessEqual(int a, double b) {
            return (double)a <= b;
        }

        @Specialization
        public boolean lessEqual(int a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue()) <= 0;
        }

        @Specialization
        public boolean lessEqual(long a, int b) {
            return a <= (long)b;
        }

        @Specialization
        public boolean lessEqual(long a, long b) {
            return a <= b;
        }

        @Specialization
        public boolean lessEqual(long a, double b) {
            return (double)a <= b;
        }

        @Specialization
        public boolean lessEqual(long a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue()) <= 0;
        }
    }

    @CoreMethod(names={"<"}, required=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class LessNode
    extends CoreMethodNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessNode(LessNode prev) {
            super(prev);
        }

        @Specialization
        public boolean less(int a, int b) {
            return a < b;
        }

        @Specialization
        public boolean less(int a, long b) {
            return (long)a < b;
        }

        @Specialization
        public boolean less(int a, double b) {
            return (double)a < b;
        }

        @Specialization
        public boolean less(int a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue()) < 0;
        }

        @Specialization
        public boolean less(long a, int b) {
            return a < (long)b;
        }

        @Specialization
        public boolean less(long a, long b) {
            return a < b;
        }

        @Specialization
        public boolean less(long a, double b) {
            return (double)a < b;
        }

        @Specialization
        public boolean less(long a, RubyBignum b) {
            return BigInteger.valueOf(a).compareTo(b.bigIntegerValue()) < 0;
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])", "!isInteger(arguments[1])", "!isLong(arguments[1])", "!isDouble(arguments[1])"})
        public Object less(VirtualFrame frame, int a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a < b", "other", b);
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])", "!isInteger(arguments[1])", "!isLong(arguments[1])", "!isDouble(arguments[1])"})
        public Object less(VirtualFrame frame, long a, Object b) {
            return this.ruby(frame, "b, a = math_coerce other, :compare_error; a < b", "other", b);
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        public DivModNode(DivModNode prev) {
            super(prev);
            this.divModNode = prev.divModNode;
        }

        @Specialization
        public RubyArray divMod(int a, int b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(int a, long b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(int a, RubyBignum b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(int a, double b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(long a, int b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(long a, long b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(long a, RubyBignum b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(long a, double b) {
            return this.divModNode.execute(a, b);
        }
    }

    @CoreMethod(names={"%"}, required=1)
    public static abstract class ModNode
    extends BignumNodes.BignumCoreMethodNode {
        private final BranchProfile adjustProfile = BranchProfile.create();

        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ModNode(ModNode prev) {
            super(prev);
        }

        @Specialization
        public int mod(int a, int b) {
            int mod = a % b;
            if (mod < 0 && b > 0 || mod > 0 && b < 0) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization
        public long mod(int a, long b) {
            return this.mod((long)a, b);
        }

        @Specialization
        public double mod(int a, double b) {
            return this.mod((long)a, b);
        }

        @Specialization
        public double mod(long a, double b) {
            if (b == 0.0) {
                throw new ArithmeticException("divide by zero");
            }
            double mod = (double)a % b;
            if (mod < 0.0 && b > 0.0 || mod > 0.0 && b < 0.0) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization
        public long mod(long a, int b) {
            return this.mod(a, (long)b);
        }

        @Specialization
        public long mod(long a, long b) {
            long mod = a % b;
            if (mod < 0L && b > 0L || mod > 0L && b < 0L) {
                this.adjustProfile.enter();
                mod += b;
            }
            return mod;
        }

        @Specialization
        public Object mod(int a, RubyBignum b) {
            return this.mod((long)a, b);
        }

        @Specialization
        public Object mod(long a, RubyBignum b) {
            ModNode.notDesignedForCompilation();
            long mod = BigInteger.valueOf(a).mod(b.bigIntegerValue()).longValue();
            if (mod < 0L && b.bigIntegerValue().compareTo(BigInteger.ZERO) > 0 || mod > 0L && b.bigIntegerValue().compareTo(BigInteger.ZERO) < 0) {
                this.adjustProfile.enter();
                return new RubyBignum(this.getContext().getCoreLibrary().getBignumClass(), BigInteger.valueOf(mod).add(b.bigIntegerValue()));
            }
            return mod;
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends CoreMethodNode {
        private final BranchProfile bGreaterZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroAGreaterEqualZero = BranchProfile.create();
        private final BranchProfile bGreaterZeroALessZero = BranchProfile.create();
        private final BranchProfile aGreaterZero = BranchProfile.create();
        private final BranchProfile bMinusOne = BranchProfile.create();
        private final BranchProfile bMinusOneAMinimum = BranchProfile.create();
        private final BranchProfile bMinusOneANotMinimum = BranchProfile.create();
        private final BranchProfile finalCase = BranchProfile.create();

        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DivNode(DivNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public int div(int a, int b) throws UnexpectedResultException {
            if (b > 0) {
                this.bGreaterZero.enter();
                if (a >= 0) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1) / b - 1;
            }
            if (a > 0) {
                this.aGreaterZero.enter();
                return (a - 1) / b - 1;
            }
            if (b == -1) {
                this.bMinusOne.enter();
                if (a == Integer.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    throw new UnexpectedResultException((Object)BigInteger.valueOf(a).negate());
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        public Object divEdgeCase(int a, int b) {
            if (b > 0) {
                this.bGreaterZero.enter();
                if (a >= 0) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1) / b - 1;
            }
            if (a > 0) {
                this.aGreaterZero.enter();
                return (a - 1) / b - 1;
            }
            if (b == -1) {
                this.bMinusOne.enter();
                if (a == Integer.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return BigInteger.valueOf(a).negate();
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public long div(int a, long b) throws UnexpectedResultException {
            return this.div((long)a, b);
        }

        @Specialization
        public Object divEdgeCase(int a, long b) {
            return this.divEdgeCase((long)a, b);
        }

        @Specialization
        public double div(int a, double b) {
            return (double)a / b;
        }

        @Specialization
        public int div(int a, RubyBignum b) {
            return 0;
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object divCoerced(VirtualFrame frame, int a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :/, b", "b", b);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public long div(long a, int b) throws UnexpectedResultException {
            return this.div(a, (long)b);
        }

        @Specialization
        public Object divEdgeCase(long a, int b) {
            return this.divEdgeCase(a, (long)b);
        }

        @Specialization(rewriteOn={UnexpectedResultException.class})
        public long div(long a, long b) throws UnexpectedResultException {
            if (b > 0L) {
                this.bGreaterZero.enter();
                if (a >= 0L) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1L) / b - 1L;
            }
            if (a > 0L) {
                this.aGreaterZero.enter();
                return (a - 1L) / b - 1L;
            }
            if (b == -1L) {
                this.bMinusOne.enter();
                if (a == Long.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    throw new UnexpectedResultException((Object)BigInteger.valueOf(a).negate());
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        public Object divEdgeCase(long a, long b) {
            if (b > 0L) {
                this.bGreaterZero.enter();
                if (a >= 0L) {
                    this.bGreaterZeroAGreaterEqualZero.enter();
                    return a / b;
                }
                this.bGreaterZeroALessZero.enter();
                return (a + 1L) / b - 1L;
            }
            if (a > 0L) {
                this.aGreaterZero.enter();
                return (a - 1L) / b - 1L;
            }
            if (b == -1L) {
                this.bMinusOne.enter();
                if (a == Long.MIN_VALUE) {
                    this.bMinusOneAMinimum.enter();
                    return BigInteger.valueOf(a).negate();
                }
                this.bMinusOneANotMinimum.enter();
                return -a;
            }
            this.finalCase.enter();
            return a / b;
        }

        @Specialization
        public double div(long a, double b) {
            return (double)a / b;
        }

        @Specialization
        public int div(long a, RubyBignum b) {
            return 0;
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object divCoerced(VirtualFrame frame, long a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :/, b", "b", b);
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends BignumNodes.BignumCoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int mul(int a, int b) {
            return ExactMath.multiplyExact((int)a, (int)b);
        }

        @Specialization
        public long mulWithOverflow(int a, int b) {
            return (long)a * (long)b;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public Object mul(int a, long b) {
            return ExactMath.multiplyExact((long)a, (long)b);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mulWithOverflow(int a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).multiply(BigInteger.valueOf(b)));
        }

        @Specialization
        public double mul(int a, double b) {
            return (double)a * b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mul(int a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).multiply(b.bigIntegerValue()));
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object mulCoerced(VirtualFrame frame, int a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :*, b", "b", b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long mul(long a, int b) {
            return ExactMath.multiplyExact((long)a, (long)b);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mulWithOverflow(long a, int b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).multiply(BigInteger.valueOf(b)));
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long mul(long a, long b) {
            return ExactMath.multiplyExact((long)a, (long)b);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mulWithOverflow(long a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).multiply(BigInteger.valueOf(b)));
        }

        @Specialization
        public double mul(long a, double b) {
            return (double)a * b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mul(long a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).multiply(b.bigIntegerValue()));
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object mulCoerced(VirtualFrame frame, long a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :*, b", "b", b);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends BignumNodes.BignumCoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SubNode(SubNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int sub(int a, int b) {
            return ExactMath.subtractExact((int)a, (int)b);
        }

        @Specialization
        public long subWithOverflow(int a, int b) {
            return (long)a - (long)b;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long sub(int a, long b) {
            return ExactMath.subtractExact((long)a, (long)b);
        }

        @Specialization
        public Object subWithOverflow(int a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).subtract(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object sub(int a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).subtract(b.bigIntegerValue()));
        }

        @Specialization
        public double sub(int a, double b) {
            return (double)a - b;
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object subCoerced(VirtualFrame frame, int a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :-, b", "b", b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long sub(long a, int b) {
            return ExactMath.subtractExact((long)a, (long)b);
        }

        @Specialization
        public Object subWithOverflow(long a, int b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).subtract(BigInteger.valueOf(b)));
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long sub(long a, long b) {
            return ExactMath.subtractExact((long)a, (long)b);
        }

        @Specialization
        public Object subWithOverflow(long a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).subtract(BigInteger.valueOf(b)));
        }

        @Specialization
        public double sub(long a, double b) {
            return (double)a - b;
        }

        @Specialization
        public Object sub(long a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).subtract(b.bigIntegerValue()));
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object subCoerced(VirtualFrame frame, long a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :-, b", "b", b);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends BignumNodes.BignumCoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int add(int a, int b) {
            return ExactMath.addExact((int)a, (int)b);
        }

        @Specialization
        public long addWithOverflow(int a, int b) {
            return (long)a + (long)b;
        }

        @Specialization
        public double add(int a, double b) {
            return (double)a + b;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long add(int a, long b) {
            return ExactMath.addExact((long)a, (long)b);
        }

        @Specialization
        public Object addWithOverflow(int a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).add(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object add(int a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).add(b.bigIntegerValue()));
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object addCoerced(VirtualFrame frame, int a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :+, b", "b", b);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long add(long a, int b) {
            return ExactMath.addExact((long)a, (long)b);
        }

        @Specialization
        public Object addWithOverflow(long a, int b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).add(BigInteger.valueOf(b)));
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long add(long a, long b) {
            return ExactMath.addExact((long)a, (long)b);
        }

        @Specialization
        public Object addWithOverflow(long a, long b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).add(BigInteger.valueOf(b)));
        }

        @Specialization
        public double add(long a, double b) {
            return (double)a + b;
        }

        @Specialization
        public Object add(long a, RubyBignum b) {
            return this.fixnumOrBignum(BigInteger.valueOf(a).add(b.bigIntegerValue()));
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object addCoerced(VirtualFrame frame, long a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :+, b", "b", b);
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignumNode;

        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NegNode(NegNode prev) {
            super(prev);
            this.fixnumOrBignumNode = prev.fixnumOrBignumNode;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public int neg(int value) {
            return ExactMath.subtractExact((int)0, (int)value);
        }

        @Specialization(contains={"neg"})
        public Object negWithOverflow(int value) {
            if (value == Integer.MIN_VALUE) {
                return -((long)value);
            }
            return -value;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long neg(long value) {
            return ExactMath.subtractExact((long)0L, (long)value);
        }

        @Specialization
        public Object negWithOverflow(long value) {
            if (this.fixnumOrBignumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fixnumOrBignumNode = (FixnumOrBignumNode)this.insert(new FixnumOrBignumNode(this.getContext(), this.getSourceSection()));
            }
            return this.fixnumOrBignumNode.fixnumOrBignum(BigInteger.valueOf(value).negate());
        }
    }
}

