/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.SingleValueCastNode;
import org.jruby.truffle.nodes.cast.SingleValueCastNodeFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FiberNodesFactory;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyFiber;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyThread;

@CoreClass(name="Fiber")
public abstract class FiberNodes {

    @CoreMethod(names={"yield"}, onSingleton=true, argumentsAsArray=true)
    public static abstract class YieldNode
    extends CoreMethodNode {
        @Node.Child
        FiberTransferNode fiberTransferNode;

        public YieldNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fiberTransferNode = FiberNodesFactory.FiberTransferNodeFactory.create(context, sourceSection, new RubyNode[]{null, null, null});
        }

        public YieldNode(YieldNode prev) {
            super(prev);
            this.fiberTransferNode = prev.fiberTransferNode;
        }

        @Specialization
        public Object yield(Object[] args) {
            RubyThread currentThread = this.getContext().getThreadManager().getCurrentThread();
            RubyFiber yieldingFiber = currentThread.getFiberManager().getCurrentFiber();
            RubyFiber fiberYieldedTo = yieldingFiber.getLastResumedByFiber();
            if (yieldingFiber.isRootFiber() || fiberYieldedTo == null) {
                throw new RaiseException(this.getContext().getCoreLibrary().yieldFromRootFiberError(this));
            }
            return this.fiberTransferNode.executeTransferControlTo(fiberYieldedTo, true, args);
        }
    }

    @CoreMethod(names={"resume"}, argumentsAsArray=true)
    public static abstract class ResumeNode
    extends CoreMethodNode {
        @Node.Child
        FiberTransferNode fiberTransferNode;

        public ResumeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fiberTransferNode = FiberNodesFactory.FiberTransferNodeFactory.create(context, sourceSection, new RubyNode[]{null, null, null});
        }

        public ResumeNode(ResumeNode prev) {
            super(prev);
            this.fiberTransferNode = prev.fiberTransferNode;
        }

        @Specialization
        public Object resume(RubyFiber fiberBeingResumed, Object[] args) {
            return this.fiberTransferNode.executeTransferControlTo(fiberBeingResumed, false, args);
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize(RubyFiber fiber, RubyProc block) {
            InitializeNode.notDesignedForCompilation();
            fiber.initialize(block);
            return this.nil();
        }
    }

    public static abstract class FiberTransferNode
    extends CoreMethodNode {
        @Node.Child
        SingleValueCastNode singleValueCastNode;

        public FiberTransferNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FiberTransferNode(FiberTransferNode prev) {
            super(prev);
        }

        protected Object singleValue(Object[] args) {
            if (this.singleValueCastNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.singleValueCastNode = (SingleValueCastNode)this.insert(SingleValueCastNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            return this.singleValueCastNode.executeSingleValue(args);
        }

        public abstract Object executeTransferControlTo(RubyFiber var1, boolean var2, Object[] var3);

        @Specialization
        protected Object transfer(RubyFiber fiber, boolean isYield, Object[] args) {
            FiberTransferNode.notDesignedForCompilation();
            if (!fiber.isAlive()) {
                throw new RaiseException(this.getContext().getCoreLibrary().deadFiberCalledError(this));
            }
            RubyThread currentThread = this.getContext().getThreadManager().getCurrentThread();
            if (fiber.getRubyThread() != currentThread) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().fiberError("fiber called across threads", this));
            }
            RubyFiber sendingFiber = currentThread.getFiberManager().getCurrentFiber();
            return this.singleValue(sendingFiber.transferControlTo(fiber, isYield, args));
        }
    }
}

