/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyCallStack;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Exception")
public abstract class ExceptionNodes {

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString toS(RubyException exception) {
            if (exception.getMessage().length() == 0) {
                return this.getContext().makeString(exception.getLogicalClass().getName());
            }
            return this.getContext().makeString(exception.getMessage().getBytes());
        }
    }

    @CoreMethod(names={"message"})
    public static abstract class MessageNode
    extends CoreMethodNode {
        public MessageNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MessageNode(MessageNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString message(RubyException exception) {
            return exception.getMessage();
        }
    }

    @CoreMethod(names={"capture_backtrace!"}, optional=1)
    public static abstract class CaptureBacktraceNode
    extends CoreMethodNode {
        public CaptureBacktraceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CaptureBacktraceNode(CaptureBacktraceNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass captureBacktrace(RubyException exception, UndefinedPlaceholder offset) {
            return this.captureBacktrace(exception, 1);
        }

        @Specialization
        public RubyNilClass captureBacktrace(RubyException exception, int offset) {
            Backtrace backtrace = RubyCallStack.getBacktrace(this, offset);
            exception.setBacktrace(backtrace);
            return this.nil();
        }
    }

    @CoreMethod(names={"backtrace"})
    public static abstract class BacktraceNode
    extends CoreMethodNode {
        public BacktraceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BacktraceNode(BacktraceNode prev) {
            super(prev);
        }

        @Specialization
        public Object backtrace(RubyException exception) {
            if (exception.getBacktrace() == null) {
                return this.nil();
            }
            return exception.asRubyStringArray();
        }
    }

    @CoreMethod(names={"initialize"}, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize(RubyException exception, UndefinedPlaceholder message) {
            InitializeNode.notDesignedForCompilation();
            exception.initialize(this.getContext().makeString(""));
            return this.nil();
        }

        @Specialization
        public RubyNilClass initialize(RubyException exception, RubyString message) {
            InitializeNode.notDesignedForCompilation();
            exception.initialize(message);
            return this.nil();
        }
    }
}

