/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.BindingNodes;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=BindingNodes.class)
public final class BindingNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(InitializeCopyNodeFactory.getInstance(), LocalVariableGetNodeFactory.getInstance(), LocalVariableSetNodeFactory.getInstance(), LocalVariablesNodeFactory.getInstance());
    }

    @GeneratedBy(value=BindingNodes.LocalVariablesNode.class)
    public static final class LocalVariablesNodeFactory
    extends NodeFactoryBase<BindingNodes.LocalVariablesNode> {
        private static LocalVariablesNodeFactory localVariablesNodeFactoryInstance;

        private LocalVariablesNodeFactory() {
            super(BindingNodes.LocalVariablesNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BindingNodes.LocalVariablesNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LocalVariablesNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BindingNodes.LocalVariablesNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LocalVariablesUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BindingNodes.LocalVariablesNode> getInstance() {
            if (localVariablesNodeFactoryInstance == null) {
                localVariablesNodeFactoryInstance = new LocalVariablesNodeFactory();
            }
            return localVariablesNodeFactoryInstance;
        }

        @GeneratedBy(value=BindingNodes.LocalVariablesNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LocalVariablesPolymorphicNode
        extends LocalVariablesBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            LocalVariablesPolymorphicNode(LocalVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=BindingNodes.LocalVariablesNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LocalVariablesRubyBindingNode
        extends LocalVariablesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LocalVariablesRubyBindingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBinding.class}, 0, 0);

            LocalVariablesRubyBindingNode(LocalVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBinding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBinding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyBinding");
                }
                return super.localVariables(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBinding(arguments0Value)) {
                    RubyBinding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBinding(arguments0Value);
                    return super.localVariables(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static BindingNodes.LocalVariablesNode create0(BindingNodes.LocalVariablesNode current) {
                return new LocalVariablesRubyBindingNode((LocalVariablesBaseNode)current);
            }
        }

        @GeneratedBy(value=BindingNodes.LocalVariablesNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LocalVariablesUninitializedNode
        extends LocalVariablesBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LocalVariablesUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LocalVariablesUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LocalVariablesUninitializedNode(LocalVariablesBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                LocalVariablesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LocalVariablesBaseNode rootNode = (LocalVariablesBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LocalVariablesBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static BindingNodes.LocalVariablesNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LocalVariablesUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BindingNodes.LocalVariablesNode.class)
        private static abstract class LocalVariablesBaseNode
        extends BindingNodes.LocalVariablesNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LocalVariablesBaseNode next0;

            LocalVariablesBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LocalVariablesBaseNode(LocalVariablesBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                LocalVariablesBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LocalVariablesBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new LocalVariablesUninitializedNode(this);
                    ((LocalVariablesUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LocalVariablesBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LocalVariablesBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (LocalVariablesBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LocalVariablesUninitializedNode(this), (Node)new LocalVariablesPolymorphicNode(this), (DSLNode)((LocalVariablesBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LocalVariablesBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBinding(arguments0Value)) {
                    return (LocalVariablesBaseNode)LocalVariablesRubyBindingNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((LocalVariablesBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (LocalVariablesBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
    public static final class LocalVariableSetNodeFactory
    extends NodeFactoryBase<BindingNodes.LocalVariableSetNode> {
        private static LocalVariableSetNodeFactory localVariableSetNodeFactoryInstance;

        private LocalVariableSetNodeFactory() {
            super(BindingNodes.LocalVariableSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BindingNodes.LocalVariableSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LocalVariableSetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BindingNodes.LocalVariableSetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LocalVariableSetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BindingNodes.LocalVariableSetNode> getInstance() {
            if (localVariableSetNodeFactoryInstance == null) {
                localVariableSetNodeFactoryInstance = new LocalVariableSetNodeFactory();
            }
            return localVariableSetNodeFactoryInstance;
        }

        @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LocalVariableSetPolymorphicNode
        extends LocalVariableSetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            LocalVariableSetPolymorphicNode(LocalVariableSetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LocalVariableSetRubyBindingObjectNode
        extends LocalVariableSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LocalVariableSetRubyBindingObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBinding.class, RubySymbol.class, Object.class}, 0, 0);

            LocalVariableSetRubyBindingObjectNode(LocalVariableSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyBinding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBinding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyBinding");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof RubySymbol");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return super.localVariableSetNode(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBinding(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyBinding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBinding(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.localVariableSetNode(arguments0ValueCast, arguments1ValueCast, arguments2Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BindingNodes.LocalVariableSetNode create0(BindingNodes.LocalVariableSetNode current) {
                return new LocalVariableSetRubyBindingObjectNode((LocalVariableSetBaseNode)current);
            }
        }

        @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LocalVariableSetUninitializedNode
        extends LocalVariableSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LocalVariableSetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LocalVariableSetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LocalVariableSetUninitializedNode(LocalVariableSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                LocalVariableSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LocalVariableSetBaseNode rootNode = (LocalVariableSetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LocalVariableSetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BindingNodes.LocalVariableSetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LocalVariableSetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BindingNodes.LocalVariableSetNode.class)
        private static abstract class LocalVariableSetBaseNode
        extends BindingNodes.LocalVariableSetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LocalVariableSetBaseNode next0;

            LocalVariableSetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LocalVariableSetBaseNode(LocalVariableSetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                LocalVariableSetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LocalVariableSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new LocalVariableSetUninitializedNode(this);
                    ((LocalVariableSetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LocalVariableSetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LocalVariableSetBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (LocalVariableSetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LocalVariableSetUninitializedNode(this), (Node)new LocalVariableSetPolymorphicNode(this), (DSLNode)((LocalVariableSetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LocalVariableSetBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBinding(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    return (LocalVariableSetBaseNode)LocalVariableSetRubyBindingObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    LocalVariableSetBaseNode otherCast = (LocalVariableSetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (LocalVariableSetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
    public static final class LocalVariableGetNodeFactory
    extends NodeFactoryBase<BindingNodes.LocalVariableGetNode> {
        private static LocalVariableGetNodeFactory localVariableGetNodeFactoryInstance;

        private LocalVariableGetNodeFactory() {
            super(BindingNodes.LocalVariableGetNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BindingNodes.LocalVariableGetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LocalVariableGetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BindingNodes.LocalVariableGetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LocalVariableGetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BindingNodes.LocalVariableGetNode> getInstance() {
            if (localVariableGetNodeFactoryInstance == null) {
                localVariableGetNodeFactoryInstance = new LocalVariableGetNodeFactory();
            }
            return localVariableGetNodeFactoryInstance;
        }

        @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LocalVariableGetPolymorphicNode
        extends LocalVariableGetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            LocalVariableGetPolymorphicNode(LocalVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LocalVariableGetRubyBindingNode
        extends LocalVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LocalVariableGetRubyBindingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBinding.class, RubySymbol.class}, 0, 0);

            LocalVariableGetRubyBindingNode(LocalVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubySymbol arguments1Value;
                RubyBinding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBinding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBinding");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubySymbol");
                }
                return super.localVariableGet(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBinding(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    RubyBinding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBinding(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    return super.localVariableGet(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BindingNodes.LocalVariableGetNode create0(BindingNodes.LocalVariableGetNode current) {
                return new LocalVariableGetRubyBindingNode((LocalVariableGetBaseNode)current);
            }
        }

        @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LocalVariableGetUninitializedNode
        extends LocalVariableGetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LocalVariableGetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LocalVariableGetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LocalVariableGetUninitializedNode(LocalVariableGetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                LocalVariableGetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LocalVariableGetBaseNode rootNode = (LocalVariableGetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LocalVariableGetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BindingNodes.LocalVariableGetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LocalVariableGetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BindingNodes.LocalVariableGetNode.class)
        private static abstract class LocalVariableGetBaseNode
        extends BindingNodes.LocalVariableGetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LocalVariableGetBaseNode next0;

            LocalVariableGetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LocalVariableGetBaseNode(LocalVariableGetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                LocalVariableGetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LocalVariableGetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new LocalVariableGetUninitializedNode(this);
                    ((LocalVariableGetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LocalVariableGetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = LocalVariableGetBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (LocalVariableGetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LocalVariableGetUninitializedNode(this), (Node)new LocalVariableGetPolymorphicNode(this), (DSLNode)((LocalVariableGetBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LocalVariableGetBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBinding(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value)) {
                    return (LocalVariableGetBaseNode)LocalVariableGetRubyBindingNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    LocalVariableGetBaseNode otherCast = (LocalVariableGetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (LocalVariableGetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=BindingNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<BindingNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(BindingNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BindingNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BindingNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BindingNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=BindingNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=BindingNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyBindingNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyBindingNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBinding.class, RubyBinding.class}, 0, 0);

            InitializeCopyRubyBindingNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyBinding arguments1Value;
                RubyBinding arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeRubyBinding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyBinding");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyBinding(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyBinding");
                }
                return super.initializeCopy(arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBinding(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBinding(arguments1Value)) {
                    RubyBinding arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyBinding(arguments0Value);
                    RubyBinding arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyBinding(arguments1Value);
                    return super.initializeCopy(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BindingNodes.InitializeCopyNode create0(BindingNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyBindingNode((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=BindingNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = (InitializeCopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeCopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static BindingNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeCopyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BindingNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends BindingNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeCopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeCopyBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeCopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeCopyUninitializedNode(this), (Node)new InitializeCopyPolymorphicNode(this), (DSLNode)((InitializeCopyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyBinding(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyBinding(arguments1Value)) {
                    return (InitializeCopyBaseNode)InitializeCopyRubyBindingNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

