/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import com.oracle.truffle.api.utilities.ConditionProfile;
import java.math.BigInteger;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumOrBignumNode;
import org.jruby.truffle.nodes.core.GeneralDivModNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Bignum")
public abstract class BignumNodes {

    @CoreMethod(names={"to_s", "inspect"}, optional=1)
    public static abstract class ToSNode
    extends CoreMethodNode {
        public ToSNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToSNode(ToSNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(RubyBignum value, UndefinedPlaceholder undefined) {
            return this.getContext().makeString(value.bigIntegerValue().toString());
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString toS(RubyBignum value, int base) {
            if (base < 2 || base > 36) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().argumentErrorInvalidRadix(base, this));
            }
            return this.getContext().makeString(value.bigIntegerValue().toString(base));
        }
    }

    @CoreMethod(names={"to_f"})
    public static abstract class ToFNode
    extends CoreMethodNode {
        public ToFNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToFNode(ToFNode prev) {
            super(prev);
        }

        @Specialization
        public double toF(RubyBignum value) {
            return value.bigIntegerValue().doubleValue();
        }
    }

    @CoreMethod(names={"size"})
    public static abstract class SizeNode
    extends CoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization
        public int size(RubyBignum value) {
            return (value.bigIntegerValue().bitLength() + 7) / 8;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public HashNode(HashNode prev) {
            super(prev);
        }

        @Specialization
        public int hash(RubyBignum self) {
            return self.bigIntegerValue().hashCode();
        }
    }

    @CoreMethod(names={"even?"})
    public static abstract class EvenNode
    extends BignumCoreMethodNode {
        public EvenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EvenNode(EvenNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public boolean even(RubyBignum value) {
            return value.bigIntegerValue().getLowestSetBit() != 0;
        }
    }

    @CoreMethod(names={"divmod"}, required=1)
    public static abstract class DivModNode
    extends CoreMethodNode {
        @Node.Child
        private GeneralDivModNode divModNode;

        public DivModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.divModNode = new GeneralDivModNode(context, sourceSection);
        }

        public DivModNode(DivModNode prev) {
            super(prev);
            this.divModNode = prev.divModNode;
        }

        @Specialization
        public RubyArray divMod(RubyBignum a, int b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(RubyBignum a, long b) {
            return this.divModNode.execute(a, b);
        }

        @Specialization
        public RubyArray divMod(RubyBignum a, RubyBignum b) {
            return this.divModNode.execute(a, b);
        }
    }

    @CoreMethod(names={"coerce"}, required=1)
    public static abstract class CoerceNode
    extends CoreMethodNode {
        public CoerceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CoerceNode(CoerceNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray coerce(RubyBignum a, int b) {
            CoerceNode.notDesignedForCompilation();
            Object[] store = new Object[]{b, a};
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), store, store.length);
        }

        @Specialization
        public RubyArray coerce(RubyBignum a, long b) {
            CoerceNode.notDesignedForCompilation();
            Object[] store = new Object[]{b, a};
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), store, store.length);
        }

        @Specialization
        public RubyArray coerce(RubyBignum a, RubyBignum b) {
            CoerceNode.notDesignedForCompilation();
            Object[] store = new Object[]{b, a};
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), store, store.length);
        }
    }

    @CoreMethod(names={"bit_length"})
    public static abstract class BitLengthNode
    extends CoreMethodNode {
        public BitLengthNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitLengthNode(BitLengthNode prev) {
            super(prev);
        }

        @Specialization
        public int bitLength(RubyBignum value) {
            return value.bigIntegerValue().bitLength();
        }
    }

    @CoreMethod(names={"abs", "magnitude"})
    public static abstract class AbsNode
    extends BignumCoreMethodNode {
        public AbsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AbsNode(AbsNode prev) {
            super(prev);
        }

        @Specialization
        public Object abs(RubyBignum value) {
            return this.fixnumOrBignum(value.bigIntegerValue().abs());
        }
    }

    @CoreMethod(names={">>"}, required=1)
    public static abstract class RightShiftNode
    extends BignumCoreMethodNode {
        private final BranchProfile bLessThanZero = BranchProfile.create();

        public RightShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RightShiftNode(RightShiftNode prev) {
            super(prev);
        }

        @Specialization
        public Object leftShift(RubyBignum a, int b) {
            if (b >= 0) {
                return this.fixnumOrBignum(a.bigIntegerValue().shiftRight(b));
            }
            this.bLessThanZero.enter();
            return this.fixnumOrBignum(a.bigIntegerValue().shiftLeft(-b));
        }
    }

    @CoreMethod(names={"<<"}, required=1)
    public static abstract class LeftShiftNode
    extends BignumCoreMethodNode {
        private final BranchProfile bLessThanZero = BranchProfile.create();

        public LeftShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LeftShiftNode(LeftShiftNode prev) {
            super(prev);
        }

        @Specialization
        public Object leftShift(RubyBignum a, int b) {
            if (b >= 0) {
                return this.fixnumOrBignum(a.bigIntegerValue().shiftLeft(b));
            }
            this.bLessThanZero.enter();
            return this.fixnumOrBignum(a.bigIntegerValue().shiftRight(-b));
        }
    }

    @CoreMethod(names={"^"}, required=1)
    public static abstract class BitXOrNode
    extends BignumCoreMethodNode {
        public BitXOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitXOrNode(BitXOrNode prev) {
            super(prev);
        }

        @Specialization
        public Object bitXOr(RubyBignum a, int b) {
            return this.fixnumOrBignum(a.bigIntegerValue().xor(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object bitXOr(RubyBignum a, long b) {
            return this.fixnumOrBignum(a.bigIntegerValue().xor(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object bitXOr(RubyBignum a, RubyBignum b) {
            return this.fixnumOrBignum(a.bigIntegerValue().xor(b.bigIntegerValue()));
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class BitOrNode
    extends BignumCoreMethodNode {
        public BitOrNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitOrNode(BitOrNode prev) {
            super(prev);
        }

        @Specialization
        public Object bitOr(RubyBignum a, int b) {
            return this.fixnumOrBignum(a.bigIntegerValue().or(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object bitOr(RubyBignum a, long b) {
            return this.fixnumOrBignum(a.bigIntegerValue().or(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object bitOr(RubyBignum a, RubyBignum b) {
            return this.fixnumOrBignum(a.bigIntegerValue().or(a.bigIntegerValue()));
        }
    }

    @CoreMethod(names={"&"}, required=1)
    public static abstract class BitAndNode
    extends BignumCoreMethodNode {
        public BitAndNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public BitAndNode(BitAndNode prev) {
            super(prev);
        }

        @Specialization
        public Object bitAnd(RubyBignum a, int b) {
            return this.fixnumOrBignum(a.bigIntegerValue().and(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object bitAnd(RubyBignum a, long b) {
            return this.fixnumOrBignum(a.bigIntegerValue().and(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object bitAnd(RubyBignum a, RubyBignum b) {
            return this.fixnumOrBignum(a.bigIntegerValue().and(b.bigIntegerValue()));
        }
    }

    @CoreMethod(names={">"}, required=1)
    public static abstract class GreaterNode
    extends CoreMethodNode {
        public GreaterNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterNode(GreaterNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greater(RubyBignum a, int b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b)) > 0;
        }

        @Specialization
        public boolean greater(RubyBignum a, long b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b)) > 0;
        }

        @Specialization
        public boolean greater(RubyBignum a, double b) {
            return Double.compare(a.bigIntegerValue().doubleValue(), b) > 0;
        }

        @Specialization
        public boolean greater(RubyBignum a, RubyBignum b) {
            return a.bigIntegerValue().compareTo(b.bigIntegerValue()) > 0;
        }
    }

    @CoreMethod(names={">="}, required=1)
    public static abstract class GreaterEqualNode
    extends CoreMethodNode {
        public GreaterEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GreaterEqualNode(GreaterEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean greaterEqual(RubyBignum a, int b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b)) >= 0;
        }

        @Specialization
        public boolean greaterEqual(RubyBignum a, long b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b)) >= 0;
        }

        @Specialization
        public boolean greaterEqual(RubyBignum a, double b) {
            return Double.compare(a.bigIntegerValue().doubleValue(), b) >= 0;
        }

        @Specialization
        public boolean greaterEqual(RubyBignum a, RubyBignum b) {
            return a.bigIntegerValue().compareTo(b.bigIntegerValue()) >= 0;
        }
    }

    @CoreMethod(names={"<=>"}, required=1)
    public static abstract class CompareNode
    extends CoreMethodNode {
        private final ConditionProfile negativeInfinityProfile = ConditionProfile.createBinaryProfile();

        public CompareNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompareNode(CompareNode prev) {
            super(prev);
        }

        @Specialization
        public int compare(RubyBignum a, int b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b));
        }

        @Specialization
        public int compare(RubyBignum a, long b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b));
        }

        @Specialization
        public int compare(RubyBignum a, double b) {
            if (this.negativeInfinityProfile.profile(Double.isInfinite(b) && b < 0.0)) {
                return 1;
            }
            return Double.compare(a.bigIntegerValue().doubleValue(), b);
        }

        @Specialization
        public int compare(RubyBignum a, RubyBignum b) {
            return a.bigIntegerValue().compareTo(b.bigIntegerValue());
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends CoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(RubyBignum a, int b) {
            return a.bigIntegerValue().equals(BigInteger.valueOf(b));
        }

        @Specialization
        public boolean equal(RubyBignum a, long b) {
            return a.bigIntegerValue().equals(BigInteger.valueOf(b));
        }

        @Specialization
        public boolean equal(RubyBignum a, double b) {
            return a.bigIntegerValue().doubleValue() == b;
        }

        @Specialization
        public boolean equal(RubyBignum a, RubyBignum b) {
            return a.bigIntegerValue().equals(b.bigIntegerValue());
        }
    }

    @CoreMethod(names={"<="}, required=1)
    public static abstract class LessEqualNode
    extends CoreMethodNode {
        public LessEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessEqualNode(LessEqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean lessEqual(RubyBignum a, int b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b)) <= 0;
        }

        @Specialization
        public boolean lessEqual(RubyBignum a, long b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b)) <= 0;
        }

        @Specialization
        public boolean lessEqual(RubyBignum a, double b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf((long)b)) <= 0;
        }

        @Specialization
        public boolean lessEqual(RubyBignum a, RubyBignum b) {
            return a.bigIntegerValue().compareTo(b.bigIntegerValue()) <= 0;
        }
    }

    @CoreMethod(names={"<"}, required=1)
    public static abstract class LessNode
    extends CoreMethodNode {
        public LessNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LessNode(LessNode prev) {
            super(prev);
        }

        @Specialization
        public boolean less(RubyBignum a, int b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b)) < 0;
        }

        @Specialization
        public boolean less(RubyBignum a, long b) {
            return a.bigIntegerValue().compareTo(BigInteger.valueOf(b)) < 0;
        }

        @Specialization
        public boolean less(RubyBignum a, double b) {
            return Double.compare(a.bigIntegerValue().doubleValue(), b) < 0;
        }

        @Specialization
        public boolean less(RubyBignum a, RubyBignum b) {
            return a.bigIntegerValue().compareTo(b.bigIntegerValue()) < 0;
        }

        @Specialization(guards={"!isRubyBignum(arguments[1])"})
        public Object lessCoerced(VirtualFrame frame, RubyBignum a, RubyBasicObject b) {
            return this.ruby(frame, "redo_coerced :<, b", "b", b);
        }
    }

    @CoreMethod(names={"%", "modulo"}, required=1)
    public static abstract class ModNode
    extends BignumCoreMethodNode {
        public ModNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ModNode(ModNode prev) {
            super(prev);
        }

        @Specialization
        public Object mod(RubyBignum a, int b) {
            if (b == 0) {
                throw new ArithmeticException("divide by zero");
            }
            if (b < 0) {
                BigInteger bigint = BigInteger.valueOf(b);
                BigInteger mod = a.bigIntegerValue().mod(bigint.negate());
                return this.fixnumOrBignum(mod.add(bigint));
            }
            return this.fixnumOrBignum(a.bigIntegerValue().mod(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object mod(RubyBignum a, long b) {
            if (b == 0L) {
                throw new ArithmeticException("divide by zero");
            }
            if (b < 0L) {
                BigInteger bigint = BigInteger.valueOf(b);
                BigInteger mod = a.bigIntegerValue().mod(bigint.negate());
                return this.fixnumOrBignum(mod.add(bigint));
            }
            return this.fixnumOrBignum(a.bigIntegerValue().mod(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object mod(RubyBignum a, RubyBignum b) {
            BigInteger bigint = b.bigIntegerValue();
            int compare = bigint.compareTo(BigInteger.ZERO);
            if (compare == 0) {
                throw new ArithmeticException("divide by zero");
            }
            if (compare < 0) {
                BigInteger mod = a.bigIntegerValue().mod(bigint.negate());
                return this.fixnumOrBignum(mod.add(bigint));
            }
            return this.fixnumOrBignum(a.bigIntegerValue().mod(b.bigIntegerValue()));
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isRubyBignum(arguments[1])"})
        public Object mod(VirtualFrame frame, RubyBignum a, Object b) {
            return this.ruby(frame, "redo_coerced :%, other", "other", b);
        }
    }

    @CoreMethod(names={"/", "__slash__"}, required=1)
    public static abstract class DivNode
    extends BignumCoreMethodNode {
        public DivNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DivNode(DivNode prev) {
            super(prev);
        }

        @Specialization
        public Object div(RubyBignum a, int b) {
            return this.fixnumOrBignum(a.bigIntegerValue().divide(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object div(RubyBignum a, long b) {
            return this.fixnumOrBignum(a.bigIntegerValue().divide(BigInteger.valueOf(b)));
        }

        @Specialization
        public double div(RubyBignum a, double b) {
            return a.bigIntegerValue().doubleValue() / b;
        }

        @Specialization
        public Object div(RubyBignum a, RubyBignum b) {
            return this.fixnumOrBignum(a.bigIntegerValue().divide(b.bigIntegerValue()));
        }
    }

    @CoreMethod(names={"*"}, required=1)
    public static abstract class MulNode
    extends BignumCoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mul(RubyBignum a, int b) {
            return this.fixnumOrBignum(a.bigIntegerValue().multiply(BigInteger.valueOf(b)));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mul(RubyBignum a, long b) {
            return this.fixnumOrBignum(a.bigIntegerValue().multiply(BigInteger.valueOf(b)));
        }

        @Specialization
        public double mul(RubyBignum a, double b) {
            return a.bigIntegerValue().doubleValue() * b;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object mul(RubyBignum a, RubyBignum b) {
            return this.fixnumOrBignum(a.bigIntegerValue().multiply(b.bigIntegerValue()));
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends BignumCoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SubNode(SubNode prev) {
            super(prev);
        }

        @Specialization
        public Object sub(RubyBignum a, int b) {
            return this.fixnumOrBignum(a.bigIntegerValue().subtract(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object sub(RubyBignum a, long b) {
            return this.fixnumOrBignum(a.bigIntegerValue().subtract(BigInteger.valueOf(b)));
        }

        @Specialization
        public double sub(RubyBignum a, double b) {
            return a.bigIntegerValue().doubleValue() - b;
        }

        @Specialization
        public Object sub(RubyBignum a, RubyBignum b) {
            return this.fixnumOrBignum(a.bigIntegerValue().subtract(b.bigIntegerValue()));
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends BignumCoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
        }

        @Specialization
        public Object add(RubyBignum a, int b) {
            return this.fixnumOrBignum(a.bigIntegerValue().add(BigInteger.valueOf(b)));
        }

        @Specialization
        public Object add(RubyBignum a, long b) {
            return this.fixnumOrBignum(a.bigIntegerValue().add(BigInteger.valueOf(b)));
        }

        @Specialization
        public double add(RubyBignum a, double b) {
            return a.bigIntegerValue().doubleValue() + b;
        }

        @Specialization
        public Object add(RubyBignum a, RubyBignum b) {
            return this.fixnumOrBignum(a.bigIntegerValue().add(b.bigIntegerValue()));
        }
    }

    @CoreMethod(names={"-@"})
    public static abstract class NegNode
    extends BignumCoreMethodNode {
        public NegNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NegNode(NegNode prev) {
            super(prev);
        }

        @Specialization
        public Object neg(RubyBignum value) {
            return this.fixnumOrBignum(value.bigIntegerValue().negate());
        }
    }

    public static abstract class BignumCoreMethodNode
    extends CoreMethodNode {
        @Node.Child
        private FixnumOrBignumNode fixnumOrBignum;

        public BignumCoreMethodNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.fixnumOrBignum = new FixnumOrBignumNode(context, sourceSection);
        }

        public BignumCoreMethodNode(BignumCoreMethodNode prev) {
            super(prev);
            this.fixnumOrBignum = prev.fixnumOrBignum;
        }

        public Object fixnumOrBignum(BigInteger value) {
            return this.fixnumOrBignum.fixnumOrBignum(value);
        }
    }
}

