/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.BasicObjectNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=BasicObjectNodes.class)
public final class BasicObjectNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(NotNodeFactory.getInstance(), EqualNodeFactory.getInstance(), NotEqualNodeFactory.getInstance(), ReferenceEqualNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InstanceEvalNodeFactory.getInstance(), InstanceExecNodeFactory.getInstance(), MethodMissingNodeFactory.getInstance(), SendNodeFactory.getInstance());
    }

    @GeneratedBy(value=BasicObjectNodes.SendNode.class)
    public static final class SendNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.SendNode> {
        private static SendNodeFactory sendNodeFactoryInstance;

        private SendNodeFactory() {
            super(BasicObjectNodes.SendNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BasicObjectNodes.SendNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SendNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BasicObjectNodes.SendNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SendUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BasicObjectNodes.SendNode> getInstance() {
            if (sendNodeFactoryInstance == null) {
                sendNodeFactoryInstance = new SendNodeFactory();
            }
            return sendNodeFactoryInstance;
        }

        @GeneratedBy(value=BasicObjectNodes.SendNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SendPolymorphicNode
        extends SendBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            SendPolymorphicNode(SendBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.SendNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SendObjectRubyProcNode
        extends SendBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SendObjectRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object[].class, RubyProc.class}, 0, 0);

            SendObjectRubyProcNode(SendBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                Object[] arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.send(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.send(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.SendNode create0(BasicObjectNodes.SendNode current) {
                return new SendObjectRubyProcNode((SendBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.SendNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SendObjectUndefinedPlaceholderNode
        extends SendBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SendObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object[].class, UndefinedPlaceholder.class}, 0, 0);

            SendObjectUndefinedPlaceholderNode(SendBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                Object[] arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.send(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.send(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.SendNode create0(BasicObjectNodes.SendNode current) {
                return new SendObjectUndefinedPlaceholderNode((SendBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.SendNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SendUninitializedNode
        extends SendBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SendUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SendUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SendUninitializedNode(SendBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                SendBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SendBaseNode rootNode = (SendBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SendBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.SendNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SendUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.SendNode.class)
        private static abstract class SendBaseNode
        extends BasicObjectNodes.SendNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SendBaseNode next0;

            SendBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SendBaseNode(SendBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                SendBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SendBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new SendUninitializedNode(this);
                    ((SendUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SendBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SendBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (SendBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SendUninitializedNode(this), (Node)new SendPolymorphicNode(this), (DSLNode)((SendBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SendBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (SendBaseNode)SendObjectUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                        return (SendBaseNode)SendObjectRubyProcNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    SendBaseNode otherCast = (SendBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (SendBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
    public static final class MethodMissingNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.MethodMissingNode> {
        private static MethodMissingNodeFactory methodMissingNodeFactoryInstance;

        private MethodMissingNodeFactory() {
            super(BasicObjectNodes.MethodMissingNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BasicObjectNodes.MethodMissingNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MethodMissingNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BasicObjectNodes.MethodMissingNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MethodMissingUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BasicObjectNodes.MethodMissingNode> getInstance() {
            if (methodMissingNodeFactoryInstance == null) {
                methodMissingNodeFactoryInstance = new MethodMissingNodeFactory();
            }
            return methodMissingNodeFactoryInstance;
        }

        @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MethodMissingPolymorphicNode
        extends MethodMissingBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            MethodMissingPolymorphicNode(MethodMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodMissingObjectRubyProcNode
        extends MethodMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodMissingObjectRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object[].class, RubyProc.class}, 0, 0);

            MethodMissingObjectRubyProcNode(MethodMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                Object[] arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.methodMissing(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.methodMissing(arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.MethodMissingNode create0(BasicObjectNodes.MethodMissingNode current) {
                return new MethodMissingObjectRubyProcNode((MethodMissingBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MethodMissingObjectUndefinedPlaceholderNode
        extends MethodMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodMissingObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object[].class, UndefinedPlaceholder.class}, 0, 0);

            MethodMissingObjectUndefinedPlaceholderNode(MethodMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                Object[] arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.methodMissing(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.methodMissing(arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.MethodMissingNode create0(BasicObjectNodes.MethodMissingNode current) {
                return new MethodMissingObjectUndefinedPlaceholderNode((MethodMissingBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MethodMissingUninitializedNode
        extends MethodMissingBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MethodMissingUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MethodMissingUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MethodMissingUninitializedNode(MethodMissingBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                MethodMissingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MethodMissingBaseNode rootNode = (MethodMissingBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MethodMissingBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.MethodMissingNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MethodMissingUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.MethodMissingNode.class)
        private static abstract class MethodMissingBaseNode
        extends BasicObjectNodes.MethodMissingNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MethodMissingBaseNode next0;

            MethodMissingBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MethodMissingBaseNode(MethodMissingBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                MethodMissingBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MethodMissingBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new MethodMissingUninitializedNode(this);
                    ((MethodMissingUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MethodMissingBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MethodMissingBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (MethodMissingBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MethodMissingUninitializedNode(this), (Node)new MethodMissingPolymorphicNode(this), (DSLNode)((MethodMissingBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MethodMissingBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (MethodMissingBaseNode)MethodMissingObjectUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                        return (MethodMissingBaseNode)MethodMissingObjectRubyProcNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    MethodMissingBaseNode otherCast = (MethodMissingBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (MethodMissingBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
    public static final class InstanceExecNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InstanceExecNode> {
        private static InstanceExecNodeFactory instanceExecNodeFactoryInstance;

        private InstanceExecNodeFactory() {
            super(BasicObjectNodes.InstanceExecNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BasicObjectNodes.InstanceExecNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceExecNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BasicObjectNodes.InstanceExecNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceExecUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BasicObjectNodes.InstanceExecNode> getInstance() {
            if (instanceExecNodeFactoryInstance == null) {
                instanceExecNodeFactoryInstance = new InstanceExecNodeFactory();
            }
            return instanceExecNodeFactoryInstance;
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceExecPolymorphicNode
        extends InstanceExecBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InstanceExecPolymorphicNode(InstanceExecBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceExecObjectUndefinedPlaceholderNode
        extends InstanceExecBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceExecObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object[].class, UndefinedPlaceholder.class}, 0, 0);

            InstanceExecObjectUndefinedPlaceholderNode(InstanceExecBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                Object[] arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.instanceExec(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.instanceExec(arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.InstanceExecNode create0(BasicObjectNodes.InstanceExecNode current) {
                return new InstanceExecObjectUndefinedPlaceholderNode((InstanceExecBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceExecObjectRubyProcNode
        extends InstanceExecBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceExecObjectRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object[].class, RubyProc.class}, 0, 0);

            InstanceExecObjectRubyProcNode(InstanceExecBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                Object[] arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof Object[]");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.instanceExec(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.instanceExec(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.InstanceExecNode create0(BasicObjectNodes.InstanceExecNode current) {
                return new InstanceExecObjectRubyProcNode((InstanceExecBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceExecUninitializedNode
        extends InstanceExecBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceExecUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceExecUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceExecUninitializedNode(InstanceExecBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InstanceExecBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceExecBaseNode rootNode = (InstanceExecBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InstanceExecBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.InstanceExecNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceExecUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceExecNode.class)
        private static abstract class InstanceExecBaseNode
        extends BasicObjectNodes.InstanceExecNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceExecBaseNode next0;

            InstanceExecBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceExecBaseNode(InstanceExecBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                InstanceExecBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceExecBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InstanceExecUninitializedNode(this);
                    ((InstanceExecUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InstanceExecBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InstanceExecBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (InstanceExecBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InstanceExecUninitializedNode(this), (Node)new InstanceExecPolymorphicNode(this), (DSLNode)((InstanceExecBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceExecBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                        return (InstanceExecBaseNode)InstanceExecObjectRubyProcNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (InstanceExecBaseNode)InstanceExecObjectUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InstanceExecBaseNode otherCast = (InstanceExecBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InstanceExecBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
    public static final class InstanceEvalNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InstanceEvalNode> {
        private static InstanceEvalNodeFactory instanceEvalNodeFactoryInstance;

        private InstanceEvalNodeFactory() {
            super(BasicObjectNodes.InstanceEvalNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BasicObjectNodes.InstanceEvalNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InstanceEvalNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BasicObjectNodes.InstanceEvalNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InstanceEvalUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BasicObjectNodes.InstanceEvalNode> getInstance() {
            if (instanceEvalNodeFactoryInstance == null) {
                instanceEvalNodeFactoryInstance = new InstanceEvalNodeFactory();
            }
            return instanceEvalNodeFactoryInstance;
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InstanceEvalPolymorphicNode
        extends InstanceEvalBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InstanceEvalPolymorphicNode(InstanceEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceEvalObjectUndefinedPlaceholderRubyProcNode
        extends InstanceEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceEvalObjectUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            InstanceEvalObjectUndefinedPlaceholderRubyProcNode(InstanceEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                UndefinedPlaceholder arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.instanceEval(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.instanceEval(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.InstanceEvalNode create0(BasicObjectNodes.InstanceEvalNode current) {
                return new InstanceEvalObjectUndefinedPlaceholderRubyProcNode((InstanceEvalBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InstanceEvalObjectRubyStringUndefinedPlaceholderNode
        extends InstanceEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceEvalObjectRubyStringUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyString.class, UndefinedPlaceholder.class}, 0, 0);

            InstanceEvalObjectRubyStringUndefinedPlaceholderNode(InstanceEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyString arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, "Expected arguments1Value instanceof RubyString");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.instanceEval(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.instanceEval(frameValue, arguments0Value, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.InstanceEvalNode create0(BasicObjectNodes.InstanceEvalNode current) {
                return new InstanceEvalObjectRubyStringUndefinedPlaceholderNode((InstanceEvalBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InstanceEvalUninitializedNode
        extends InstanceEvalBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InstanceEvalUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InstanceEvalUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InstanceEvalUninitializedNode(InstanceEvalBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InstanceEvalBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InstanceEvalBaseNode rootNode = (InstanceEvalBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InstanceEvalBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static BasicObjectNodes.InstanceEvalNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InstanceEvalUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.InstanceEvalNode.class)
        private static abstract class InstanceEvalBaseNode
        extends BasicObjectNodes.InstanceEvalNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InstanceEvalBaseNode next0;

            InstanceEvalBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InstanceEvalBaseNode(InstanceEvalBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                InstanceEvalBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InstanceEvalBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InstanceEvalUninitializedNode(this);
                    ((InstanceEvalUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InstanceEvalBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InstanceEvalBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (InstanceEvalBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InstanceEvalUninitializedNode(this), (Node)new InstanceEvalPolymorphicNode(this), (DSLNode)((InstanceEvalBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InstanceEvalBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    return (InstanceEvalBaseNode)InstanceEvalObjectRubyStringUndefinedPlaceholderNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    return (InstanceEvalBaseNode)InstanceEvalObjectUndefinedPlaceholderRubyProcNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InstanceEvalBaseNode otherCast = (InstanceEvalBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InstanceEvalBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(BasicObjectNodes.InitializeNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BasicObjectNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BasicObjectNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeDefaultNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BasicObjectNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=BasicObjectNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeDefaultNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeDefaultNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, 0, 0);

            InitializeDefaultNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                return super.initialize();
            }

            static BasicObjectNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeDefaultNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends BasicObjectNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
    public static final class ReferenceEqualNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.ReferenceEqualNode> {
        private static ReferenceEqualNodeFactory referenceEqualNodeFactoryInstance;

        private ReferenceEqualNodeFactory() {
            super(BasicObjectNodes.ReferenceEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BasicObjectNodes.ReferenceEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ReferenceEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BasicObjectNodes.ReferenceEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
            return ReferenceEqualUninitializedNode.create0(context, sourceSection, left, right);
        }

        public static NodeFactory<BasicObjectNodes.ReferenceEqualNode> getInstance() {
            if (referenceEqualNodeFactoryInstance == null) {
                referenceEqualNodeFactoryInstance = new ReferenceEqualNodeFactory();
            }
            return referenceEqualNodeFactoryInstance;
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReferenceEqualPolymorphicNode
        extends ReferenceEqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> leftPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> rightPolymorphicType;

            ReferenceEqualPolymorphicNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object rightValue;
                Object leftValue;
                try {
                    leftValue = this.leftPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.left.executeBoolean(frameValue)) : (this.leftPolymorphicType == Integer.TYPE ? Integer.valueOf(this.left.executeIntegerFixnum(frameValue)) : (this.leftPolymorphicType == Long.TYPE ? Long.valueOf(this.left.executeLongFixnum(frameValue)) : (this.leftPolymorphicType == Double.TYPE ? Double.valueOf(this.left.executeFloat(frameValue)) : (this.leftPolymorphicType == RubyBasicObject.class ? this.left.executeRubyBasicObject(frameValue) : this.left.execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    this.leftPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), rightValue2);
                }
                try {
                    rightValue = this.rightPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.right.executeBoolean(frameValue)) : (this.rightPolymorphicType == Integer.TYPE ? Integer.valueOf(this.right.executeIntegerFixnum(frameValue)) : (this.rightPolymorphicType == Long.TYPE ? Long.valueOf(this.right.executeLongFixnum(frameValue)) : (this.rightPolymorphicType == Double.TYPE ? Double.valueOf(this.right.executeFloat(frameValue)) : (this.rightPolymorphicType == RubyBasicObject.class ? this.right.executeRubyBasicObject(frameValue) : this.right.execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.rightPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, leftValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                Object rightValue;
                Object leftValue;
                try {
                    leftValue = this.leftPolymorphicType == Boolean.TYPE ? Boolean.valueOf(RubyTypesGen.RUBYTYPES.expectBoolean(leftValueEvaluated)) : (this.leftPolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(leftValueEvaluated)) : (this.leftPolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(leftValueEvaluated)) : (this.leftPolymorphicType == Double.TYPE ? Double.valueOf(RubyTypesGen.RUBYTYPES.expectDouble(leftValueEvaluated)) : (this.leftPolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(leftValueEvaluated) : leftValueEvaluated))));
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = rightValueEvaluated;
                    this.leftPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), rightValue2);
                }
                try {
                    rightValue = this.rightPolymorphicType == Boolean.TYPE ? Boolean.valueOf(RubyTypesGen.RUBYTYPES.expectBoolean(rightValueEvaluated)) : (this.rightPolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(rightValueEvaluated)) : (this.rightPolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(rightValueEvaluated)) : (this.rightPolymorphicType == Double.TYPE ? Double.valueOf(RubyTypesGen.RUBYTYPES.expectDouble(rightValueEvaluated)) : (this.rightPolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(rightValueEvaluated) : rightValueEvaluated))));
                }
                catch (UnexpectedResultException ex) {
                    this.rightPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, leftValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.leftPolymorphicType = types[0];
                this.rightPolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReferenceEqualRubyBasicObjectObjectNode
        extends ReferenceEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReferenceEqualRubyBasicObjectObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, Object.class}, 0, 0);

            ReferenceEqualRubyBasicObjectObjectNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject leftValue;
                try {
                    leftValue = this.left.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue, "Expected leftValue instanceof RubyBasicObject");
                }
                Object rightValue = this.right.execute(frameValue);
                if (super.isNotRubyBasicObject(rightValue)) {
                    return super.equal(leftValue, rightValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, leftValue, rightValue, "One of guards [isNotRubyBasicObject] failed");
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                RubyBasicObject leftValue;
                try {
                    leftValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(leftValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue = rightValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), rightValue, "Expected leftValue instanceof RubyBasicObject");
                }
                Object rightValue = rightValueEvaluated;
                if (super.isNotRubyBasicObject(rightValue)) {
                    return super.equal(leftValue, rightValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, leftValue, rightValue, "One of guards [isNotRubyBasicObject] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(leftValue) && super.isNotRubyBasicObject(rightValue)) {
                    RubyBasicObject leftValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(leftValue);
                    return super.equal(leftValueCast, rightValue);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.ReferenceEqualNode create0(BasicObjectNodes.ReferenceEqualNode current) {
                return new ReferenceEqualRubyBasicObjectObjectNode((ReferenceEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReferenceEqualObjectRubyBasicObjectNode
        extends ReferenceEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReferenceEqualObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyBasicObject.class}, 0, 0);

            ReferenceEqualObjectRubyBasicObjectNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject rightValue;
                Object leftValue = this.left.execute(frameValue);
                try {
                    rightValue = this.right.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof RubyBasicObject");
                }
                if (super.isNotRubyBasicObject(leftValue)) {
                    return super.equal(leftValue, rightValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, leftValue, rightValue, "One of guards [isNotRubyBasicObject] failed");
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                RubyBasicObject rightValue;
                Object leftValue = leftValueEvaluated;
                try {
                    rightValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(rightValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof RubyBasicObject");
                }
                if (super.isNotRubyBasicObject(leftValue)) {
                    return super.equal(leftValue, rightValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, leftValue, rightValue, "One of guards [isNotRubyBasicObject] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(rightValue) && super.isNotRubyBasicObject(leftValue)) {
                    RubyBasicObject rightValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(rightValue);
                    return super.equal(leftValue, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.ReferenceEqualNode create0(BasicObjectNodes.ReferenceEqualNode current) {
                return new ReferenceEqualObjectRubyBasicObjectNode((ReferenceEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReferenceEqualObjectNode
        extends ReferenceEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReferenceEqualObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            ReferenceEqualObjectNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object leftValue = this.left.execute(frameValue);
                Object rightValue = this.right.execute(frameValue);
                if (super.isNotRubyBasicObject(leftValue) && super.isNotRubyBasicObject(rightValue) && super.notSameClass(leftValue, rightValue)) {
                    return super.equal(leftValue, rightValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, leftValue, rightValue, "One of guards [isNotRubyBasicObject, isNotRubyBasicObject, notSameClass] failed");
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                Object leftValue = leftValueEvaluated;
                Object rightValue = rightValueEvaluated;
                if (super.isNotRubyBasicObject(leftValue) && super.isNotRubyBasicObject(rightValue) && super.notSameClass(leftValue, rightValue)) {
                    return super.equal(leftValue, rightValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, leftValue, rightValue, "One of guards [isNotRubyBasicObject, isNotRubyBasicObject, notSameClass] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (super.isNotRubyBasicObject(leftValue) && super.isNotRubyBasicObject(rightValue) && super.notSameClass(leftValue, rightValue)) {
                    return super.equal(leftValue, rightValue);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.ReferenceEqualNode create0(BasicObjectNodes.ReferenceEqualNode current) {
                return new ReferenceEqualObjectNode((ReferenceEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReferenceEqualRubyBasicObjectNode
        extends ReferenceEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReferenceEqualRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyBasicObject.class}, 0, 0);

            ReferenceEqualRubyBasicObjectNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject rightValue;
                RubyBasicObject leftValue;
                try {
                    leftValue = this.left.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof RubyBasicObject");
                }
                try {
                    rightValue = this.right.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof RubyBasicObject");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                RubyBasicObject rightValue;
                RubyBasicObject leftValue;
                try {
                    leftValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(leftValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = rightValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof RubyBasicObject");
                }
                try {
                    rightValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(rightValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof RubyBasicObject");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(leftValue) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(rightValue)) {
                    RubyBasicObject leftValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(leftValue);
                    RubyBasicObject rightValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.ReferenceEqualNode create0(BasicObjectNodes.ReferenceEqualNode current) {
                return new ReferenceEqualRubyBasicObjectNode((ReferenceEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReferenceEqualDoubleNode
        extends ReferenceEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReferenceEqualDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            ReferenceEqualDoubleNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double rightValue;
                double leftValue;
                try {
                    leftValue = this.left.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof double");
                }
                try {
                    rightValue = this.right.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof double");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                double rightValue;
                double leftValue;
                try {
                    leftValue = RubyTypesGen.RUBYTYPES.expectDouble(leftValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = rightValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof double");
                }
                try {
                    rightValue = RubyTypesGen.RUBYTYPES.expectDouble(rightValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof double");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isDouble(leftValue) && RubyTypesGen.RUBYTYPES.isDouble(rightValue)) {
                    double leftValueCast = RubyTypesGen.RUBYTYPES.asDouble(leftValue);
                    double rightValueCast = RubyTypesGen.RUBYTYPES.asDouble(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.ReferenceEqualNode create0(BasicObjectNodes.ReferenceEqualNode current) {
                return new ReferenceEqualDoubleNode((ReferenceEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReferenceEqualLongNode
        extends ReferenceEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReferenceEqualLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            ReferenceEqualLongNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long rightValue;
                long leftValue;
                try {
                    leftValue = this.left.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof long");
                }
                try {
                    rightValue = this.right.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof long");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                long rightValue;
                long leftValue;
                try {
                    leftValue = RubyTypesGen.RUBYTYPES.expectLong(leftValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = rightValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof long");
                }
                try {
                    rightValue = RubyTypesGen.RUBYTYPES.expectLong(rightValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof long");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isLong(leftValue) && RubyTypesGen.RUBYTYPES.isLong(rightValue)) {
                    long leftValueCast = RubyTypesGen.RUBYTYPES.asLong(leftValue);
                    long rightValueCast = RubyTypesGen.RUBYTYPES.asLong(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.ReferenceEqualNode create0(BasicObjectNodes.ReferenceEqualNode current) {
                return new ReferenceEqualLongNode((ReferenceEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReferenceEqualIntNode
        extends ReferenceEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReferenceEqualIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            ReferenceEqualIntNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int rightValue;
                int leftValue;
                try {
                    leftValue = this.left.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof int");
                }
                try {
                    rightValue = this.right.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof int");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                int rightValue;
                int leftValue;
                try {
                    leftValue = RubyTypesGen.RUBYTYPES.expectInteger(leftValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = rightValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof int");
                }
                try {
                    rightValue = RubyTypesGen.RUBYTYPES.expectInteger(rightValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof int");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isInteger(leftValue) && RubyTypesGen.RUBYTYPES.isInteger(rightValue)) {
                    int leftValueCast = RubyTypesGen.RUBYTYPES.asInteger(leftValue);
                    int rightValueCast = RubyTypesGen.RUBYTYPES.asInteger(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.ReferenceEqualNode create0(BasicObjectNodes.ReferenceEqualNode current) {
                return new ReferenceEqualIntNode((ReferenceEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReferenceEqualBooleanNode
        extends ReferenceEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReferenceEqualBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE, Boolean.TYPE}, 0, 0);

            ReferenceEqualBooleanNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean rightValue;
                boolean leftValue;
                try {
                    leftValue = this.left.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof boolean");
                }
                try {
                    rightValue = this.right.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof boolean");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                boolean rightValue;
                boolean leftValue;
                try {
                    leftValue = RubyTypesGen.RUBYTYPES.expectBoolean(leftValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = rightValueEvaluated;
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof boolean");
                }
                try {
                    rightValue = RubyTypesGen.RUBYTYPES.expectBoolean(rightValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof boolean");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(leftValue) && RubyTypesGen.RUBYTYPES.isBoolean(rightValue)) {
                    boolean leftValueCast = RubyTypesGen.RUBYTYPES.asBoolean(leftValue);
                    boolean rightValueCast = RubyTypesGen.RUBYTYPES.asBoolean(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.ReferenceEqualNode create0(BasicObjectNodes.ReferenceEqualNode current) {
                return new ReferenceEqualBooleanNode((ReferenceEqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReferenceEqualUninitializedNode
        extends ReferenceEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReferenceEqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReferenceEqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
                super(context, sourceSection, left, right);
            }

            ReferenceEqualUninitializedNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object leftValue = this.left.execute(frameValue);
                Object rightValue = this.right.execute(frameValue);
                return this.executeUninitialized0(frameValue, leftValue, rightValue);
            }

            @Override
            public boolean executeReferenceEqual(VirtualFrame frameValue, Object leftValueEvaluated, Object rightValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object leftValue = leftValueEvaluated;
                Object rightValue = rightValueEvaluated;
                return this.executeUninitialized0(frameValue, leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, leftValue, rightValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                ReferenceEqualBaseNode newNode = this.specialize0(leftValue, rightValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReferenceEqualBaseNode rootNode = (ReferenceEqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.left, rootNode.right}, new Object[]{leftValue, rightValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReferenceEqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.ReferenceEqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
                return new ReferenceEqualUninitializedNode(context, sourceSection, left, right);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.ReferenceEqualNode.class)
        private static abstract class ReferenceEqualBaseNode
        extends BasicObjectNodes.ReferenceEqualNode
        implements DSLNode {
            @Node.Child
            protected RubyNode left;
            @Node.Child
            protected RubyNode right;
            @Node.Child
            protected ReferenceEqualBaseNode next0;

            ReferenceEqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
                super(context, sourceSection);
                this.left = left;
                this.right = right;
            }

            ReferenceEqualBaseNode(ReferenceEqualBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getLeft() {
                return this.left;
            }

            @Override
            public RubyNode getRight() {
                return this.right;
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object leftValue, Object rightValue, String reason) {
                String message;
                ReferenceEqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReferenceEqualBaseNode newNode = this.specialize0(leftValue, rightValue);
                if (newNode == null) {
                    newNode = new ReferenceEqualUninitializedNode(this);
                    ((ReferenceEqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReferenceEqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ReferenceEqualBaseNode.createInfo0(reason, leftValue, rightValue)))) == null) {
                    returnNode = (ReferenceEqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReferenceEqualUninitializedNode(this), (Node)new ReferenceEqualPolymorphicNode(this), (DSLNode)((ReferenceEqualBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, leftValue, rightValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReferenceEqualBaseNode specialize0(Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(leftValue) && RubyTypesGen.RUBYTYPES.isBoolean(rightValue)) {
                    return (ReferenceEqualBaseNode)ReferenceEqualBooleanNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(leftValue) && RubyTypesGen.RUBYTYPES.isInteger(rightValue)) {
                    return (ReferenceEqualBaseNode)ReferenceEqualIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(leftValue) && RubyTypesGen.RUBYTYPES.isLong(rightValue)) {
                    return (ReferenceEqualBaseNode)ReferenceEqualLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(leftValue) && RubyTypesGen.RUBYTYPES.isDouble(rightValue)) {
                    return (ReferenceEqualBaseNode)ReferenceEqualDoubleNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(leftValue) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(rightValue)) {
                    return (ReferenceEqualBaseNode)ReferenceEqualRubyBasicObjectNode.create0(this);
                }
                if (super.isNotRubyBasicObject(leftValue)) {
                    if (super.isNotRubyBasicObject(rightValue) && super.notSameClass(leftValue, rightValue)) {
                        return (ReferenceEqualBaseNode)ReferenceEqualObjectNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(rightValue)) {
                        return (ReferenceEqualBaseNode)ReferenceEqualObjectRubyBasicObjectNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(leftValue) && super.isNotRubyBasicObject(rightValue)) {
                    return (ReferenceEqualBaseNode)ReferenceEqualRubyBasicObjectObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.left = null;
                    this.right = null;
                } else {
                    ReferenceEqualBaseNode otherCast = (ReferenceEqualBaseNode)other;
                    this.left = otherCast.left;
                    this.right = otherCast.right;
                }
                this.next0 = newNext == null ? null : (ReferenceEqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object leftValue, Object rightValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("leftValue").append(" = ").append(leftValue);
                    if (leftValue != null) {
                        builder.append(" (").append(leftValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("rightValue").append(" = ").append(rightValue);
                    if (rightValue != null) {
                        builder.append(" (").append(rightValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.NotEqualNode.class)
    public static final class NotEqualNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.NotEqualNode> {
        private static NotEqualNodeFactory notEqualNodeFactoryInstance;

        private NotEqualNodeFactory() {
            super(BasicObjectNodes.NotEqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public BasicObjectNodes.NotEqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return NotEqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BasicObjectNodes.NotEqualNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return NotEqualObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<BasicObjectNodes.NotEqualNode> getInstance() {
            if (notEqualNodeFactoryInstance == null) {
                notEqualNodeFactoryInstance = new NotEqualNodeFactory();
            }
            return notEqualNodeFactoryInstance;
        }

        @GeneratedBy(value=BasicObjectNodes.NotEqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NotEqualObjectNode
        extends NotEqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NotEqualObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            NotEqualObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.equal(frameValue, arguments0Value, arguments1Value);
            }

            static BasicObjectNodes.NotEqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new NotEqualObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.NotEqualNode.class)
        private static abstract class NotEqualBaseNode
        extends BasicObjectNodes.NotEqualNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            NotEqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    NotEqualBaseNode otherCast = (NotEqualBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
    public static final class EqualNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.EqualNode> {
        private static EqualNodeFactory equalNodeFactoryInstance;

        private EqualNodeFactory() {
            super(BasicObjectNodes.EqualNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public BasicObjectNodes.EqualNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return EqualNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BasicObjectNodes.EqualNode create(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
            return EqualUninitializedNode.create0(context, sourceSection, left, right);
        }

        public static NodeFactory<BasicObjectNodes.EqualNode> getInstance() {
            if (equalNodeFactoryInstance == null) {
                equalNodeFactoryInstance = new EqualNodeFactory();
            }
            return equalNodeFactoryInstance;
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EqualPolymorphicNode
        extends EqualBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> leftPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> rightPolymorphicType;

            EqualPolymorphicNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object rightValue;
                Object leftValue;
                try {
                    leftValue = this.leftPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.left.executeBoolean(frameValue)) : (this.leftPolymorphicType == Integer.TYPE ? Integer.valueOf(this.left.executeIntegerFixnum(frameValue)) : (this.leftPolymorphicType == Long.TYPE ? Long.valueOf(this.left.executeLongFixnum(frameValue)) : (this.leftPolymorphicType == Double.TYPE ? Double.valueOf(this.left.executeFloat(frameValue)) : (this.leftPolymorphicType == RubyBasicObject.class ? this.left.executeRubyBasicObject(frameValue) : this.left.execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    this.leftPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, ex.getResult(), rightValue2);
                }
                try {
                    rightValue = this.rightPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.right.executeBoolean(frameValue)) : (this.rightPolymorphicType == Integer.TYPE ? Integer.valueOf(this.right.executeIntegerFixnum(frameValue)) : (this.rightPolymorphicType == Long.TYPE ? Long.valueOf(this.right.executeLongFixnum(frameValue)) : (this.rightPolymorphicType == Double.TYPE ? Double.valueOf(this.right.executeFloat(frameValue)) : (this.rightPolymorphicType == RubyBasicObject.class ? this.right.executeRubyBasicObject(frameValue) : this.right.execute(frameValue)))));
                }
                catch (UnexpectedResultException ex) {
                    this.rightPolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, leftValue, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.leftPolymorphicType = types[0];
                this.rightPolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyBasicObjectObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyBasicObjectObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, Object.class}, 0, 0);

            EqualRubyBasicObjectObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject leftValue;
                try {
                    leftValue = this.left.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue, "Expected leftValue instanceof RubyBasicObject");
                }
                Object rightValue = this.right.execute(frameValue);
                if (super.isNotRubyBasicObject(rightValue)) {
                    return super.equal(leftValue, rightValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, leftValue, rightValue, "One of guards [isNotRubyBasicObject] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(leftValue) && super.isNotRubyBasicObject(rightValue)) {
                    RubyBasicObject leftValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(leftValue);
                    return super.equal(leftValueCast, rightValue);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.EqualNode create0(BasicObjectNodes.EqualNode current) {
                return new EqualRubyBasicObjectObjectNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualObjectRubyBasicObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualObjectRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, RubyBasicObject.class}, 0, 0);

            EqualObjectRubyBasicObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject rightValue;
                Object leftValue = this.left.execute(frameValue);
                try {
                    rightValue = this.right.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof RubyBasicObject");
                }
                if (super.isNotRubyBasicObject(leftValue)) {
                    return super.equal(leftValue, rightValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, leftValue, rightValue, "One of guards [isNotRubyBasicObject] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(rightValue) && super.isNotRubyBasicObject(leftValue)) {
                    RubyBasicObject rightValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(rightValue);
                    return super.equal(leftValue, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.EqualNode create0(BasicObjectNodes.EqualNode current) {
                return new EqualObjectRubyBasicObjectNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            EqualObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object leftValue = this.left.execute(frameValue);
                Object rightValue = this.right.execute(frameValue);
                if (super.isNotRubyBasicObject(leftValue) && super.isNotRubyBasicObject(rightValue) && super.notSameClass(leftValue, rightValue)) {
                    return super.equal(leftValue, rightValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, leftValue, rightValue, "One of guards [isNotRubyBasicObject, isNotRubyBasicObject, notSameClass] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (super.isNotRubyBasicObject(leftValue) && super.isNotRubyBasicObject(rightValue) && super.notSameClass(leftValue, rightValue)) {
                    return super.equal(leftValue, rightValue);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.EqualNode create0(BasicObjectNodes.EqualNode current) {
                return new EqualObjectNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualRubyBasicObjectNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class, RubyBasicObject.class}, 0, 0);

            EqualRubyBasicObjectNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyBasicObject rightValue;
                RubyBasicObject leftValue;
                try {
                    leftValue = this.left.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof RubyBasicObject");
                }
                try {
                    rightValue = this.right.executeRubyBasicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof RubyBasicObject");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(leftValue) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(rightValue)) {
                    RubyBasicObject leftValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(leftValue);
                    RubyBasicObject rightValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.EqualNode create0(BasicObjectNodes.EqualNode current) {
                return new EqualRubyBasicObjectNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualDoubleNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE, Double.TYPE}, 0, 0);

            EqualDoubleNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                double rightValue;
                double leftValue;
                try {
                    leftValue = this.left.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof double");
                }
                try {
                    rightValue = this.right.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof double");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isDouble(leftValue) && RubyTypesGen.RUBYTYPES.isDouble(rightValue)) {
                    double leftValueCast = RubyTypesGen.RUBYTYPES.asDouble(leftValue);
                    double rightValueCast = RubyTypesGen.RUBYTYPES.asDouble(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.EqualNode create0(BasicObjectNodes.EqualNode current) {
                return new EqualDoubleNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualLongNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE, Long.TYPE}, 0, 0);

            EqualLongNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                long rightValue;
                long leftValue;
                try {
                    leftValue = this.left.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof long");
                }
                try {
                    rightValue = this.right.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof long");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isLong(leftValue) && RubyTypesGen.RUBYTYPES.isLong(rightValue)) {
                    long leftValueCast = RubyTypesGen.RUBYTYPES.asLong(leftValue);
                    long rightValueCast = RubyTypesGen.RUBYTYPES.asLong(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.EqualNode create0(BasicObjectNodes.EqualNode current) {
                return new EqualLongNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualIntNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE, Integer.TYPE}, 0, 0);

            EqualIntNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                int rightValue;
                int leftValue;
                try {
                    leftValue = this.left.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof int");
                }
                try {
                    rightValue = this.right.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof int");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isInteger(leftValue) && RubyTypesGen.RUBYTYPES.isInteger(rightValue)) {
                    int leftValueCast = RubyTypesGen.RUBYTYPES.asInteger(leftValue);
                    int rightValueCast = RubyTypesGen.RUBYTYPES.asInteger(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.EqualNode create0(BasicObjectNodes.EqualNode current) {
                return new EqualIntNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EqualBooleanNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE, Boolean.TYPE}, 0, 0);

            EqualBooleanNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean rightValue;
                boolean leftValue;
                try {
                    leftValue = this.left.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object rightValue2 = this.right.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), rightValue2, "Expected leftValue instanceof boolean");
                }
                try {
                    rightValue = this.right.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, leftValue, ex.getResult(), "Expected rightValue instanceof boolean");
                }
                return super.equal(leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(leftValue) && RubyTypesGen.RUBYTYPES.isBoolean(rightValue)) {
                    boolean leftValueCast = RubyTypesGen.RUBYTYPES.asBoolean(leftValue);
                    boolean rightValueCast = RubyTypesGen.RUBYTYPES.asBoolean(rightValue);
                    return super.equal(leftValueCast, rightValueCast);
                }
                return this.next0.executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.EqualNode create0(BasicObjectNodes.EqualNode current) {
                return new EqualBooleanNode((EqualBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EqualUninitializedNode
        extends EqualBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EqualUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EqualUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
                super(context, sourceSection, left, right);
            }

            EqualUninitializedNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object leftValue = this.left.execute(frameValue);
                Object rightValue = this.right.execute(frameValue);
                return this.executeUninitialized0(frameValue, leftValue, rightValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, leftValue, rightValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object leftValue, Object rightValue) {
                EqualBaseNode newNode = this.specialize0(leftValue, rightValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EqualBaseNode rootNode = (EqualBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.left, rootNode.right}, new Object[]{leftValue, rightValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EqualBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, leftValue, rightValue);
            }

            static BasicObjectNodes.EqualNode create0(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
                return new EqualUninitializedNode(context, sourceSection, left, right);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.EqualNode.class)
        private static abstract class EqualBaseNode
        extends BasicObjectNodes.EqualNode
        implements DSLNode {
            @Node.Child
            protected RubyNode left;
            @Node.Child
            protected RubyNode right;
            @Node.Child
            protected EqualBaseNode next0;

            EqualBaseNode(RubyContext context, SourceSection sourceSection, RubyNode left, RubyNode right) {
                super(context, sourceSection);
                this.left = left;
                this.right = right;
            }

            EqualBaseNode(EqualBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getLeft() {
                return this.left;
            }

            @Override
            public RubyNode getRight() {
                return this.right;
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object leftValue, Object rightValue, String reason) {
                String message;
                EqualBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EqualBaseNode newNode = this.specialize0(leftValue, rightValue);
                if (newNode == null) {
                    newNode = new EqualUninitializedNode(this);
                    ((EqualUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EqualBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EqualBaseNode.createInfo0(reason, leftValue, rightValue)))) == null) {
                    returnNode = (EqualBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EqualUninitializedNode(this), (Node)new EqualPolymorphicNode(this), (DSLNode)((EqualBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, leftValue, rightValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EqualBaseNode specialize0(Object leftValue, Object rightValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(leftValue) && RubyTypesGen.RUBYTYPES.isBoolean(rightValue)) {
                    return (EqualBaseNode)EqualBooleanNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(leftValue) && RubyTypesGen.RUBYTYPES.isInteger(rightValue)) {
                    return (EqualBaseNode)EqualIntNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isLong(leftValue) && RubyTypesGen.RUBYTYPES.isLong(rightValue)) {
                    return (EqualBaseNode)EqualLongNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(leftValue) && RubyTypesGen.RUBYTYPES.isDouble(rightValue)) {
                    return (EqualBaseNode)EqualDoubleNode.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(leftValue) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(rightValue)) {
                    return (EqualBaseNode)EqualRubyBasicObjectNode.create0(this);
                }
                if (super.isNotRubyBasicObject(leftValue)) {
                    if (super.isNotRubyBasicObject(rightValue) && super.notSameClass(leftValue, rightValue)) {
                        return (EqualBaseNode)EqualObjectNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(rightValue)) {
                        return (EqualBaseNode)EqualObjectRubyBasicObjectNode.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(leftValue) && super.isNotRubyBasicObject(rightValue)) {
                    return (EqualBaseNode)EqualRubyBasicObjectObjectNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.left = null;
                    this.right = null;
                } else {
                    EqualBaseNode otherCast = (EqualBaseNode)other;
                    this.left = otherCast.left;
                    this.right = otherCast.right;
                }
                this.next0 = newNext == null ? null : (EqualBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object leftValue, Object rightValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("leftValue").append(" = ").append(leftValue);
                    if (leftValue != null) {
                        builder.append(" (").append(leftValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("rightValue").append(" = ").append(rightValue);
                    if (rightValue != null) {
                        builder.append(" (").append(rightValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=BasicObjectNodes.NotNode.class)
    public static final class NotNodeFactory
    extends NodeFactoryBase<BasicObjectNodes.NotNode> {
        private static NotNodeFactory notNodeFactoryInstance;

        private NotNodeFactory() {
            super(BasicObjectNodes.NotNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
        }

        public BasicObjectNodes.NotNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return NotNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static BasicObjectNodes.NotNode create(RubyContext context, SourceSection sourceSection, RubyNode operand) {
            return NotUninitializedNode.create0(context, sourceSection, operand);
        }

        public static NodeFactory<BasicObjectNodes.NotNode> getInstance() {
            if (notNodeFactoryInstance == null) {
                notNodeFactoryInstance = new NotNodeFactory();
            }
            return notNodeFactoryInstance;
        }

        @GeneratedBy(value=BasicObjectNodes.NotNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class NotPolymorphicNode
        extends NotBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> operandPolymorphicType;

            NotPolymorphicNode(NotBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object operandValue = this.operand.execute(frameValue);
                return this.next0.executeChained0(frameValue, operandValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.operandPolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                return this.next0.executeChained0(frameValue, operandValue);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.NotNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class NotBooleanNode
        extends NotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NotBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

            NotBooleanNode(NotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                boolean operandValue;
                try {
                    operandValue = this.operand.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected operandValue instanceof boolean");
                }
                return super.not(operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(operandValue)) {
                    boolean operandValueCast = RubyTypesGen.RUBYTYPES.asBoolean(operandValue);
                    return super.not(operandValueCast);
                }
                return this.next0.executeChained0(frameValue, operandValue);
            }

            static BasicObjectNodes.NotNode create0(BasicObjectNodes.NotNode current) {
                return new NotBooleanNode((NotBaseNode)current);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.NotNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class NotUninitializedNode
        extends NotBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(NotUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            NotUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection, operand);
            }

            NotUninitializedNode(NotBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object operandValue = this.operand.execute(frameValue);
                return this.executeUninitialized0(frameValue, operandValue);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object operandValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, operandValue);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object operandValue) {
                NotBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    NotBaseNode rootNode = (NotBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.operand}, new Object[]{operandValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((NotBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, operandValue);
            }

            static BasicObjectNodes.NotNode create0(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                return new NotUninitializedNode(context, sourceSection, operand);
            }
        }

        @GeneratedBy(value=BasicObjectNodes.NotNode.class)
        private static abstract class NotBaseNode
        extends BasicObjectNodes.NotNode
        implements DSLNode {
            @Node.Child
            protected RubyNode operand;
            @Node.Child
            protected NotBaseNode next0;

            NotBaseNode(RubyContext context, SourceSection sourceSection, RubyNode operand) {
                super(context, sourceSection);
                this.operand = super.createCast(operand);
            }

            NotBaseNode(NotBaseNode copy) {
                super(copy);
            }

            @Override
            public RubyNode getOperand() {
                return this.operand;
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object operandValue, String reason) {
                String message;
                NotBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                NotBaseNode newNode = this.specialize0(operandValue);
                if (newNode == null) {
                    newNode = new NotUninitializedNode(this);
                    ((NotUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (NotBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = NotBaseNode.createInfo0(reason, operandValue)))) == null) {
                    returnNode = (NotBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NotUninitializedNode(this), (Node)new NotPolymorphicNode(this), (DSLNode)((NotBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, operandValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final NotBaseNode specialize0(Object operandValue) {
                if (RubyTypesGen.RUBYTYPES.isBoolean(operandValue)) {
                    return (NotBaseNode)NotBooleanNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.operand = other == null ? null : ((NotBaseNode)other).operand;
                this.next0 = newNext == null ? null : (NotBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object operandValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("operandValue").append(" = ").append(operandValue);
                    if (operandValue != null) {
                        builder.append(" (").append(operandValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }
}

