/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyCallNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.core.BinaryCoreMethodNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.methods.UnsupportedOperationBehavior;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.util.ArrayUtils;
import org.jruby.util.cli.Options;

@CoreClass(name="BasicObject")
public abstract class BasicObjectNodes {

    @CoreMethod(names={"__send__"}, needsBlock=true, required=1, argumentsAsArray=true)
    public static abstract class SendNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode dispatchNode;

        public SendNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatchNode = DispatchHeadNodeFactory.createMethodCall(context, true, (Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT.load(), MissingBehavior.CALL_METHOD_MISSING);
            if (((Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED.load()).booleanValue()) {
                this.dispatchNode.forceUncached();
            }
        }

        public SendNode(SendNode prev) {
            super(prev);
            this.dispatchNode = prev.dispatchNode;
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object[] args, UndefinedPlaceholder block) {
            return this.send(frame, self, args, (RubyProc)null);
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self, Object[] args, RubyProc block) {
            Object name = args[0];
            Object[] sendArgs = ArrayUtils.extractRange(args, 1, args.length);
            return this.dispatchNode.call(frame, self, name, block, sendArgs);
        }
    }

    @CoreMethod(names={"method_missing"}, needsBlock=true, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class MethodMissingNode
    extends CoreMethodNode {
        public MethodMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MethodMissingNode(MethodMissingNode prev) {
            super(prev);
        }

        @Specialization
        public Object methodMissing(Object self, Object[] args, UndefinedPlaceholder block) {
            MethodMissingNode.notDesignedForCompilation();
            return this.methodMissing(self, args, (RubyProc)null);
        }

        @Specialization
        public Object methodMissing(Object self, Object[] args, RubyProc block) {
            MethodMissingNode.notDesignedForCompilation();
            RubySymbol name = (RubySymbol)args[0];
            Object[] sentArgs = ArrayUtils.extractRange(args, 1, args.length);
            return this.methodMissing(self, name, sentArgs, block);
        }

        private Object methodMissing(Object self, RubySymbol name, Object[] args, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            if (this.lastCallWasVCall()) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedLocalVariableOrMethod(name.toString(), this.getContext().getCoreLibrary().getLogicalClass(self).getName(), this));
            }
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodErrorOnReceiver(name.toString(), self, this));
        }

        private boolean lastCallWasVCall() {
            RubyCallNode callNode = (RubyCallNode)((Object)NodeUtil.findParent((Node)Truffle.getRuntime().getCallerFrame().getCallNode(), RubyCallNode.class));
            if (callNode == null) {
                return false;
            }
            return callNode.isVCall();
        }
    }

    @CoreMethod(names={"instance_exec"}, needsBlock=true, argumentsAsArray=true)
    public static abstract class InstanceExecNode
    extends YieldingCoreMethodNode {
        public InstanceExecNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InstanceExecNode(InstanceExecNode prev) {
            super(prev);
        }

        @Specialization
        public Object instanceExec(VirtualFrame frame, Object receiver, Object[] arguments, RubyProc block) {
            InstanceExecNode.notDesignedForCompilation();
            return this.yieldWithModifiedSelf(frame, block, receiver, arguments);
        }

        @Specialization
        public Object instanceExec(Object receiver, Object[] arguments, UndefinedPlaceholder block) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().localJumpError("no block given", this));
        }
    }

    @CoreMethod(names={"instance_eval"}, needsBlock=true, optional=1, unsupportedOperationBehavior=UnsupportedOperationBehavior.ARGUMENT_ERROR)
    public static abstract class InstanceEvalNode
    extends CoreMethodNode {
        @Node.Child
        private YieldDispatchHeadNode yield;

        public InstanceEvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context);
        }

        public InstanceEvalNode(InstanceEvalNode prev) {
            super(prev);
            this.yield = prev.yield;
        }

        @Specialization
        public Object instanceEval(VirtualFrame frame, Object receiver, RubyString string, UndefinedPlaceholder block) {
            InstanceEvalNode.notDesignedForCompilation();
            return this.getContext().instanceEval(string.getBytes(), receiver, this);
        }

        @Specialization
        public Object instanceEval(VirtualFrame frame, Object receiver, UndefinedPlaceholder string, RubyProc block) {
            InstanceEvalNode.notDesignedForCompilation();
            return this.yield.dispatchWithModifiedSelf(frame, block, receiver, receiver);
        }
    }

    @CoreMethod(names={"initialize"}, needsSelf=false)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize() {
            return this.nil();
        }
    }

    @CoreMethod(names={"equal?"}, required=1)
    public static abstract class ReferenceEqualNode
    extends BinaryCoreMethodNode {
        public ReferenceEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReferenceEqualNode(ReferenceEqualNode prev) {
            super(prev);
        }

        public abstract boolean executeReferenceEqual(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public boolean equal(boolean a, boolean b) {
            return a == b;
        }

        @Specialization
        public boolean equal(int a, int b) {
            return a == b;
        }

        @Specialization
        public boolean equal(long a, long b) {
            return a == b;
        }

        @Specialization
        public boolean equal(double a, double b) {
            return Double.doubleToRawLongBits(a) == Double.doubleToRawLongBits(b);
        }

        @Specialization
        public boolean equal(RubyBasicObject a, RubyBasicObject b) {
            return a == b;
        }

        @Specialization(guards={"isNotRubyBasicObject(left)", "isNotRubyBasicObject(right)", "notSameClass"})
        public boolean equal(Object a, Object b) {
            return false;
        }

        @Specialization(guards={"isNotRubyBasicObject(left)"})
        public boolean equal(Object a, RubyBasicObject b) {
            return false;
        }

        @Specialization(guards={"isNotRubyBasicObject(right)"})
        public boolean equal(RubyBasicObject a, Object b) {
            return false;
        }

        protected boolean isNotRubyBasicObject(Object value) {
            return !(value instanceof RubyBasicObject);
        }

        protected boolean notSameClass(Object a, Object b) {
            return a.getClass() != b.getClass();
        }
    }

    @CoreMethod(names={"!="}, required=1)
    public static abstract class NotEqualNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode equalNode;

        public NotEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public NotEqualNode(NotEqualNode prev) {
            super(prev);
            this.equalNode = prev.equalNode;
        }

        @Specialization
        public boolean equal(VirtualFrame frame, Object a, Object b) {
            return !this.equalNode.callBoolean(frame, a, "==", null, b);
        }
    }

    @CoreMethod(names={"=="}, required=1)
    public static abstract class EqualNode
    extends BinaryCoreMethodNode {
        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
        }

        @Specialization
        public boolean equal(boolean a, boolean b) {
            return a == b;
        }

        @Specialization
        public boolean equal(int a, int b) {
            return a == b;
        }

        @Specialization
        public boolean equal(long a, long b) {
            return a == b;
        }

        @Specialization
        public boolean equal(double a, double b) {
            return a == b;
        }

        @Specialization
        public boolean equal(RubyBasicObject a, RubyBasicObject b) {
            return a == b;
        }

        @Specialization(guards={"isNotRubyBasicObject(left)", "isNotRubyBasicObject(right)", "notSameClass"})
        public boolean equal(Object a, Object b) {
            return false;
        }

        @Specialization(guards={"isNotRubyBasicObject(left)"})
        public boolean equal(Object a, RubyBasicObject b) {
            return false;
        }

        @Specialization(guards={"isNotRubyBasicObject(right)"})
        public boolean equal(RubyBasicObject a, Object b) {
            return false;
        }

        protected boolean isNotRubyBasicObject(Object value) {
            return !(value instanceof RubyBasicObject);
        }

        protected boolean notSameClass(Object a, Object b) {
            return a.getClass() != b.getClass();
        }
    }

    @CoreMethod(names={"!"})
    public static abstract class NotNode
    extends UnaryCoreMethodNode {
        public NotNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NotNode(NotNode prev) {
            super(prev);
        }

        @CreateCast(value={"operand"})
        public RubyNode createCast(RubyNode operand) {
            return BooleanCastNodeFactory.create(this.getContext(), this.getSourceSection(), operand);
        }

        @Specialization
        public boolean not(boolean value) {
            return !value;
        }
    }
}

