/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.nodes.core.ArrayNodes;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=ArrayNodes.class)
public final class ArrayNodesFactory {
    public static List<NodeFactory<? extends RubyNode>> getFactories() {
        return Arrays.asList(AddNodeFactory.getInstance(), MulNodeFactory.getInstance(), IndexNodeFactory.getInstance(), IndexSetNodeFactory.getInstance(), AtNodeFactory.getInstance(), ClearNodeFactory.getInstance(), CompactNodeFactory.getInstance(), CompactBangNodeFactory.getInstance(), ConcatNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), DeleteAtNodeFactory.getInstance(), EachNodeFactory.getInstance(), EachWithIndexNodeFactory.getInstance(), IncludeNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InjectNodeFactory.getInstance(), InsertNodeFactory.getInstance(), MapNodeFactory.getInstance(), MapInPlaceNodeFactory.getInstance(), MaxNodeFactory.getInstance(), MaxBlockNodeFactory.getInstance(), MinNodeFactory.getInstance(), MinBlockNodeFactory.getInstance(), PackNodeFactory.getInstance(), PopNodeFactory.getInstance(), PushNodeFactory.getInstance(), PushOneNodeFactory.getInstance(), RejectNodeFactory.getInstance(), DeleteIfNodeFactory.getInstance(), RejectInPlaceNodeFactory.getInstance(), ReplaceNodeFactory.getInstance(), SelectNodeFactory.getInstance(), ShiftNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SortNodeFactory.getInstance(), UnshiftNodeFactory.getInstance(), ZipNodeFactory.getInstance());
    }

    @GeneratedBy(value=ArrayNodes.ZipNode.class)
    public static final class ZipNodeFactory
    extends NodeFactoryBase<ArrayNodes.ZipNode> {
        private static ZipNodeFactory zipNodeFactoryInstance;

        private ZipNodeFactory() {
            super(ArrayNodes.ZipNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ZipNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ZipNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ZipNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ZipUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.ZipNode> getInstance() {
            if (zipNodeFactoryInstance == null) {
                zipNodeFactoryInstance = new ZipNodeFactory();
            }
            return zipNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ZipPolymorphicNode
        extends ZipBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ZipPolymorphicNode(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ZipObjectObjectArray2Node
        extends ZipBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZipObjectObjectArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            ZipObjectObjectArray2Node(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (!ArrayGuards.isObject(arguments0Value)) {
                    return super.zipObjectObjectNotObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (!ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.zipObjectObjectNotObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ZipNode create0(ArrayNodes.ZipNode current) {
                return new ZipObjectObjectArray2Node((ZipBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ZipObjectObjectArray1Node
        extends ZipBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZipObjectObjectArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            ZipObjectObjectArray1Node(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (!ArrayGuards.isOtherSingleIntegerFixnumArray(arguments0Value, arguments1Value)) {
                    return super.zipObjectObjectNotSingleInteger(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isOtherSingleIntegerFixnumArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                Object[] arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && !ArrayGuards.isOtherSingleIntegerFixnumArray(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value))) {
                    return super.zipObjectObjectNotSingleInteger(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ZipNode create0(ArrayNodes.ZipNode current) {
                return new ZipObjectObjectArray1Node((ZipBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ZipObjectObjectArray0Node
        extends ZipBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZipObjectObjectArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            ZipObjectObjectArray0Node(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (!ArrayGuards.isOtherSingleObjectArray(arguments0Value, arguments1Value)) {
                    return super.zipObjectObjectNotSingleObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isOtherSingleObjectArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                Object[] arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && !ArrayGuards.isOtherSingleObjectArray(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value))) {
                    return super.zipObjectObjectNotSingleObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ZipNode create0(ArrayNodes.ZipNode current) {
                return new ZipObjectObjectArray0Node((ZipBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ZipRubyArrayObjectArray1Node
        extends ZipBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZipRubyArrayObjectArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            ZipRubyArrayObjectArray1Node(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]"));
                }
                if (ArrayGuards.isObject(arguments0Value) && ArrayGuards.isOtherSingleObjectArray(arguments0Value, arguments1Value)) {
                    return super.zipObjectObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, isOtherSingleObjectArray] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast) && ArrayGuards.isOtherSingleObjectArray(arguments0ValueCast, arguments1ValueCast)) {
                        return super.zipObjectObject(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ZipNode create0(ArrayNodes.ZipNode current) {
                return new ZipRubyArrayObjectArray1Node((ZipBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ZipRubyArrayObjectArray0Node
        extends ZipBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZipRubyArrayObjectArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            ZipRubyArrayObjectArray0Node(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]"));
                }
                if (ArrayGuards.isObject(arguments0Value) && ArrayGuards.isOtherSingleIntegerFixnumArray(arguments0Value, arguments1Value)) {
                    return super.zipObjectIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, isOtherSingleIntegerFixnumArray] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast) && ArrayGuards.isOtherSingleIntegerFixnumArray(arguments0ValueCast, arguments1ValueCast)) {
                        return super.zipObjectIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ZipNode create0(ArrayNodes.ZipNode current) {
                return new ZipRubyArrayObjectArray0Node((ZipBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ZipUninitializedNode
        extends ZipBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZipUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ZipUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ZipUninitializedNode(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ZipBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ZipBaseNode rootNode = (ZipBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ZipBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ZipNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ZipUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        private static abstract class ZipBaseNode
        extends ArrayNodes.ZipNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ZipBaseNode next0;

            ZipBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ZipBaseNode(ZipBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ZipBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ZipBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ZipUninitializedNode(this);
                    ((ZipUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ZipBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ZipBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ZipBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ZipUninitializedNode(this), (Node)new ZipPolymorphicNode(this), (DSLNode)((ZipBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ZipBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        if (ArrayGuards.isOtherSingleIntegerFixnumArray(arguments0ValueCast, arguments1ValueCast)) {
                            return (ZipBaseNode)ZipRubyArrayObjectArray0Node.create0(this);
                        }
                        if (ArrayGuards.isOtherSingleObjectArray(arguments0ValueCast, arguments1ValueCast)) {
                            return (ZipBaseNode)ZipRubyArrayObjectArray1Node.create0(this);
                        }
                    }
                    if (!ArrayGuards.isOtherSingleObjectArray(arguments0ValueCast, arguments1ValueCast)) {
                        return (ZipBaseNode)ZipObjectObjectArray0Node.create0(this);
                    }
                    if (!ArrayGuards.isOtherSingleIntegerFixnumArray(arguments0ValueCast, arguments1ValueCast)) {
                        return (ZipBaseNode)ZipObjectObjectArray1Node.create0(this);
                    }
                    if (!ArrayGuards.isObject(arguments0ValueCast)) {
                        return (ZipBaseNode)ZipObjectObjectArray2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ZipBaseNode otherCast = (ZipBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ZipBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
    public static final class UnshiftNodeFactory
    extends NodeFactoryBase<ArrayNodes.UnshiftNode> {
        private static UnshiftNodeFactory unshiftNodeFactoryInstance;

        private UnshiftNodeFactory() {
            super(ArrayNodes.UnshiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.UnshiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnshiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.UnshiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UnshiftUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.UnshiftNode> getInstance() {
            if (unshiftNodeFactoryInstance == null) {
                unshiftNodeFactoryInstance = new UnshiftNodeFactory();
            }
            return unshiftNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UnshiftPolymorphicNode
        extends UnshiftBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            UnshiftPolymorphicNode(UnshiftBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UnshiftRubyArrayNode
        extends UnshiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnshiftRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            UnshiftRubyArrayNode(UnshiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.unshift(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.unshift(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.UnshiftNode create0(ArrayNodes.UnshiftNode current) {
                return new UnshiftRubyArrayNode((UnshiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UnshiftUninitializedNode
        extends UnshiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnshiftUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UnshiftUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UnshiftUninitializedNode(UnshiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                UnshiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UnshiftBaseNode rootNode = (UnshiftBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UnshiftBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.UnshiftNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UnshiftUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
        private static abstract class UnshiftBaseNode
        extends ArrayNodes.UnshiftNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UnshiftBaseNode next0;

            UnshiftBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UnshiftBaseNode(UnshiftBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                UnshiftBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UnshiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new UnshiftUninitializedNode(this);
                    ((UnshiftUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UnshiftBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = UnshiftBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (UnshiftBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UnshiftUninitializedNode(this), (Node)new UnshiftPolymorphicNode(this), (DSLNode)((UnshiftBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UnshiftBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (UnshiftBaseNode)UnshiftRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    UnshiftBaseNode otherCast = (UnshiftBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (UnshiftBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SortNode.class)
    public static final class SortNodeFactory
    extends NodeFactoryBase<ArrayNodes.SortNode> {
        private static SortNodeFactory sortNodeFactoryInstance;

        private SortNodeFactory() {
            super(ArrayNodes.SortNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SortNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SortNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.SortNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SortUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.SortNode> getInstance() {
            if (sortNodeFactoryInstance == null) {
                sortNodeFactoryInstance = new SortNodeFactory();
            }
            return sortNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SortPolymorphicNode
        extends SortBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SortPolymorphicNode(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyProc.class ? this.arguments[1].executeRubyProc(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortObjectNode
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            SortObjectNode(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!ArrayGuards.isNull(arguments0Value) && !SortBaseNode.isSmall(arguments0Value)) {
                    return super.sortUsingRubinius(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, !isSmall] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !ArrayGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value)) && !SortBaseNode.isSmall(arguments0ValueCast)) {
                    return super.sortUsingRubinius(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current) {
                return new SortObjectNode((SortBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortObjectRubyProcNode
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortObjectRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            SortObjectRubyProcNode(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                return super.sortUsingRubinius(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    return super.sortUsingRubinius(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current) {
                return new SortObjectRubyProcNode((SortBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder2Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder2Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isObject(arguments0Value) && SortBaseNode.isSmall(arguments0Value)) {
                    return super.sortVeryShortObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, isSmall] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast) && SortBaseNode.isSmall(arguments0ValueCast)) {
                        return super.sortVeryShortObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current) {
                return new SortRubyArrayUndefinedPlaceholder2Node((SortBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder1Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder1Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isLongFixnum(arguments0Value) && SortBaseNode.isSmall(arguments0Value)) {
                    return super.sortVeryShortLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, isSmall] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast) && SortBaseNode.isSmall(arguments0ValueCast)) {
                        return super.sortVeryShortLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current) {
                return new SortRubyArrayUndefinedPlaceholder1Node((SortBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder0Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder0Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && SortBaseNode.isSmall(arguments0Value)) {
                    return super.sortVeryShortIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, isSmall] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && SortBaseNode.isSmall(arguments0ValueCast)) {
                        return super.sortVeryShortIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current) {
                return new SortRubyArrayUndefinedPlaceholder0Node((SortBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayObjectNode
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            SortRubyArrayObjectNode(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.sortNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.sortNull(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current) {
                return new SortRubyArrayObjectNode((SortBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SortUninitializedNode
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SortUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SortUninitializedNode(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SortBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SortBaseNode rootNode = (SortBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SortBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SortUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        private static abstract class SortBaseNode
        extends ArrayNodes.SortNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SortBaseNode next0;

            SortBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SortBaseNode(SortBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                SortBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SortBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SortUninitializedNode(this);
                    ((SortUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SortBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SortBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SortBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SortUninitializedNode(this), (Node)new SortPolymorphicNode(this), (DSLNode)((SortBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SortBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (SortBaseNode)SortRubyArrayObjectNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && ArrayNodes.SortNode.isSmall(arguments0ValueCast)) {
                            return (SortBaseNode)SortRubyArrayUndefinedPlaceholder0Node.create0(this);
                        }
                        if (ArrayGuards.isLongFixnum(arguments0ValueCast) && ArrayNodes.SortNode.isSmall(arguments0ValueCast)) {
                            return (SortBaseNode)SortRubyArrayUndefinedPlaceholder1Node.create0(this);
                        }
                        if (ArrayGuards.isObject(arguments0ValueCast) && ArrayNodes.SortNode.isSmall(arguments0ValueCast)) {
                            return (SortBaseNode)SortRubyArrayUndefinedPlaceholder2Node.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                        return (SortBaseNode)SortObjectRubyProcNode.create0(this);
                    }
                    if (!ArrayGuards.isNull(arguments0ValueCast) && !ArrayNodes.SortNode.isSmall(arguments0ValueCast)) {
                        return (SortBaseNode)SortObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SortBaseNode otherCast = (SortBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SortBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<ArrayNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(ArrayNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SizePolymorphicNode
        extends SizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SizePolymorphicNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyArrayNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            SizeRubyArrayNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.size(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.size(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.SizeNode create0(ArrayNodes.SizeNode current) {
                return new SizeRubyArrayNode((SizeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SizeUninitializedNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SizeUninitializedNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SizeBaseNode rootNode = (SizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.SizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        private static abstract class SizeBaseNode
        extends ArrayNodes.SizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SizeBaseNode next0;

            SizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SizeBaseNode(SizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                SizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SizeUninitializedNode(this);
                    ((SizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SizeBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (SizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SizeUninitializedNode(this), (Node)new SizePolymorphicNode(this), (DSLNode)((SizeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (SizeBaseNode)SizeRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ShiftNode.class)
    public static final class ShiftNodeFactory
    extends NodeFactoryBase<ArrayNodes.ShiftNode> {
        private static ShiftNodeFactory shiftNodeFactoryInstance;

        private ShiftNodeFactory() {
            super(ArrayNodes.ShiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ShiftUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.ShiftNode> getInstance() {
            if (shiftNodeFactoryInstance == null) {
                shiftNodeFactoryInstance = new ShiftNodeFactory();
            }
            return shiftNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ShiftPolymorphicNode
        extends ShiftBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ShiftPolymorphicNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                Object arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated)) : arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObject4Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObject4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            ShiftObject4Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isObject(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftObjectWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isObject(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftObjectWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.shiftObjectWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObject4Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObject3Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObject3Node.class, new Class[]{ShiftRubyArrayObject2Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            ShiftObject3Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isFloat(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftFloatWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isFloat(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftFloatWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.shiftFloatWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObject3Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyArrayObject2Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyArrayObject2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ShiftObject3Node.class}, new Class[]{RubyArray.class, Object.class}, 0, 0);

            ShiftRubyArrayObject2Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isFloat(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.shiftFloatInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat, !isInteger, !isUndefinedPlaceholder] failed"));
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isFloat(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.shiftFloatInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    try {
                        return super.shiftFloatInBoundsWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftRubyArrayObject2Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObject2Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObject2Node.class, new Class[]{ShiftRubyArrayObject1Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            ShiftObject2Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isLongFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftLongFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isLongFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftLongFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.shiftLongFixnumWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObject2Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyArrayObject1Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyArrayObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ShiftObject2Node.class}, new Class[]{RubyArray.class, Object.class}, 0, 0);

            ShiftRubyArrayObject1Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isLongFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.shiftLongFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, !isInteger, !isUndefinedPlaceholder] failed"));
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isLongFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.shiftLongFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    try {
                        return super.shiftLongFixnumInBoundsWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftRubyArrayObject1Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObject1Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObject1Node.class, new Class[]{ShiftRubyArrayObject0Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            ShiftObject1Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftIntegerFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftIntegerFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.shiftIntegerFixnumWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObject1Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyArrayObject0Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyArrayObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ShiftObject1Node.class}, new Class[]{RubyArray.class, Object.class}, 0, 0);

            ShiftRubyArrayObject0Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.shiftIntegerFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isInteger, !isUndefinedPlaceholder] failed"));
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.shiftIntegerFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    try {
                        return super.shiftIntegerFixnumInBoundsWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftRubyArrayObject0Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObjectInt3Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObjectInt3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            ShiftObjectInt3Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.shiftObjectWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.shiftObjectWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.shiftObjectWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObjectInt3Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObjectInt2Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObjectInt2Node.class, new Class[]{ShiftRubyArrayInt2Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            ShiftObjectInt2Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.shiftFloatWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.shiftFloatWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.shiftFloatWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObjectInt2Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyArrayInt2Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyArrayInt2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ShiftObjectInt2Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            ShiftRubyArrayInt2Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.shiftFloatInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed"));
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.shiftFloatInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        try {
                            return super.shiftFloatInBoundsWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftRubyArrayInt2Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObjectInt1Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObjectInt1Node.class, new Class[]{ShiftRubyArrayInt1Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            ShiftObjectInt1Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.shiftLongFixnumWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.shiftLongFixnumWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.shiftLongFixnumWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObjectInt1Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyArrayInt1Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyArrayInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ShiftObjectInt1Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            ShiftRubyArrayInt1Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    try {
                        return super.shiftLongFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed"));
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    try {
                        return super.shiftLongFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        try {
                            return super.shiftLongFixnumInBoundsWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftRubyArrayInt1Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObjectInt0Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObjectInt0Node.class, new Class[]{ShiftRubyArrayInt0Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            ShiftObjectInt0Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.popIntegerFixnumWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.popIntegerFixnumWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.popIntegerFixnumWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObjectInt0Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyArrayInt0Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyArrayInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ShiftObjectInt0Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            ShiftRubyArrayInt0Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.popIntegerFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.popIntegerFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        try {
                            return super.popIntegerFixnumInBoundsWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftRubyArrayInt0Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObject0Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            ShiftObject0Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isNullOrEmpty(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftNilWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullOrEmpty, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isNullOrEmpty(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.shiftNilWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullOrEmpty, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isNullOrEmpty(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.shiftNilWithNum(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObject0Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObjectUndefinedPlaceholder4Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObjectUndefinedPlaceholder4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            ShiftObjectUndefinedPlaceholder4Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.shiftObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.shiftObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.shiftObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObjectUndefinedPlaceholder4Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObjectUndefinedPlaceholder3Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObjectUndefinedPlaceholder3Node.class, new Class[]{ShiftDoubleUndefinedPlaceholderNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            ShiftObjectUndefinedPlaceholder3Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.shiftFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.shiftFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.shiftFloat(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObjectUndefinedPlaceholder3Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftDoubleUndefinedPlaceholderNode
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftDoubleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ShiftObjectUndefinedPlaceholder3Node.class}, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            ShiftDoubleUndefinedPlaceholderNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.shiftFloatInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed"));
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.shiftFloatInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        try {
                            return super.shiftFloatInBounds(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftDoubleUndefinedPlaceholderNode((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObjectUndefinedPlaceholder2Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObjectUndefinedPlaceholder2Node.class, new Class[]{ShiftLongUndefinedPlaceholderNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            ShiftObjectUndefinedPlaceholder2Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.shiftLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.shiftLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.shiftLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObjectUndefinedPlaceholder2Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftLongUndefinedPlaceholderNode
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftLongUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ShiftObjectUndefinedPlaceholder2Node.class}, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            ShiftLongUndefinedPlaceholderNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    try {
                        return super.shiftLongFixnumInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed"));
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    try {
                        return super.shiftLongFixnumInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        try {
                            return super.shiftLongFixnumInBounds(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftLongUndefinedPlaceholderNode((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObjectUndefinedPlaceholder1Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObjectUndefinedPlaceholder1Node.class, new Class[]{ShiftIntUndefinedPlaceholderNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            ShiftObjectUndefinedPlaceholder1Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.shiftIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.shiftIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.shiftIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObjectUndefinedPlaceholder1Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftIntUndefinedPlaceholderNode
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ShiftObjectUndefinedPlaceholder1Node.class}, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            ShiftIntUndefinedPlaceholderNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.shiftIntegerFixnumInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.shiftIntegerFixnumInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        try {
                            return super.shiftIntegerFixnumInBounds(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftIntUndefinedPlaceholderNode((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftObjectUndefinedPlaceholder0Node
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftObjectUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            ShiftObjectUndefinedPlaceholder0Node(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isNullOrEmpty(arguments0Value)) {
                    return super.shiftNil(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullOrEmpty] failed");
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isNullOrEmpty(arguments0Value)) {
                    return super.shiftNil(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullOrEmpty] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isNullOrEmpty(arguments0ValueCast)) {
                        return super.shiftNil(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current) {
                return new ShiftObjectUndefinedPlaceholder0Node((ShiftBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ShiftUninitializedNode
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ShiftUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ShiftUninitializedNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executeShift(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ShiftBaseNode rootNode = (ShiftBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ShiftBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ShiftNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ShiftUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        private static abstract class ShiftBaseNode
        extends ArrayNodes.ShiftNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ShiftBaseNode next0;

            ShiftBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ShiftBaseNode(ShiftBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                ShiftBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ShiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ShiftUninitializedNode(this);
                    ((ShiftUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ShiftBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ShiftBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ShiftBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ShiftUninitializedNode(this), (Node)new ShiftPolymorphicNode(this), (DSLNode)((ShiftBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ShiftBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (ArrayGuards.isNullOrEmpty(arguments0ValueCast)) {
                            return (ShiftBaseNode)ShiftObjectUndefinedPlaceholder0Node.create0(this);
                        }
                        if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ShiftIntUndefinedPlaceholderNode.METADATA)) {
                                return (ShiftBaseNode)ShiftIntUndefinedPlaceholderNode.create0(this);
                            }
                            return (ShiftBaseNode)ShiftObjectUndefinedPlaceholder1Node.create0(this);
                        }
                        if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ShiftLongUndefinedPlaceholderNode.METADATA)) {
                                return (ShiftBaseNode)ShiftLongUndefinedPlaceholderNode.create0(this);
                            }
                            return (ShiftBaseNode)ShiftObjectUndefinedPlaceholder2Node.create0(this);
                        }
                        if (ArrayGuards.isFloat(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ShiftDoubleUndefinedPlaceholderNode.METADATA)) {
                                return (ShiftBaseNode)ShiftDoubleUndefinedPlaceholderNode.create0(this);
                            }
                            return (ShiftBaseNode)ShiftObjectUndefinedPlaceholder3Node.create0(this);
                        }
                        if (ArrayGuards.isObject(arguments0ValueCast)) {
                            return (ShiftBaseNode)ShiftObjectUndefinedPlaceholder4Node.create0(this);
                        }
                    }
                    if (ArrayGuards.isNullOrEmpty(arguments0ValueCast) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        return (ShiftBaseNode)ShiftObject0Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ShiftRubyArrayInt0Node.METADATA)) {
                                return (ShiftBaseNode)ShiftRubyArrayInt0Node.create0(this);
                            }
                            return (ShiftBaseNode)ShiftObjectInt0Node.create0(this);
                        }
                        if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ShiftRubyArrayInt1Node.METADATA)) {
                                return (ShiftBaseNode)ShiftRubyArrayInt1Node.create0(this);
                            }
                            return (ShiftBaseNode)ShiftObjectInt1Node.create0(this);
                        }
                        if (ArrayGuards.isFloat(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ShiftRubyArrayInt2Node.METADATA)) {
                                return (ShiftBaseNode)ShiftRubyArrayInt2Node.create0(this);
                            }
                            return (ShiftBaseNode)ShiftObjectInt2Node.create0(this);
                        }
                        if (ArrayGuards.isObject(arguments0ValueCast)) {
                            return (ShiftBaseNode)ShiftObjectInt3Node.create0(this);
                        }
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ShiftRubyArrayObject0Node.METADATA)) {
                            return (ShiftBaseNode)ShiftRubyArrayObject0Node.create0(this);
                        }
                        return (ShiftBaseNode)ShiftObject1Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ShiftRubyArrayObject1Node.METADATA)) {
                            return (ShiftBaseNode)ShiftRubyArrayObject1Node.create0(this);
                        }
                        return (ShiftBaseNode)ShiftObject2Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ShiftRubyArrayObject2Node.METADATA)) {
                            return (ShiftBaseNode)ShiftRubyArrayObject2Node.create0(this);
                        }
                        return (ShiftBaseNode)ShiftObject3Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        return (ShiftBaseNode)ShiftObject4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ShiftBaseNode otherCast = (ShiftBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ShiftBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SelectNode.class)
    public static final class SelectNodeFactory
    extends NodeFactoryBase<ArrayNodes.SelectNode> {
        private static SelectNodeFactory selectNodeFactoryInstance;

        private SelectNodeFactory() {
            super(ArrayNodes.SelectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SelectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SelectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.SelectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SelectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.SelectNode> getInstance() {
            if (selectNodeFactoryInstance == null) {
                selectNodeFactoryInstance = new SelectNodeFactory();
            }
            return selectNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SelectPolymorphicNode
        extends SelectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SelectPolymorphicNode(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SelectRubyArray2Node
        extends SelectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SelectRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            SelectRubyArray2Node(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.selectFixnumInteger(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.selectFixnumInteger(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SelectNode create0(ArrayNodes.SelectNode current) {
                return new SelectRubyArray2Node((SelectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SelectRubyArray1Node
        extends SelectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SelectRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            SelectRubyArray1Node(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.selectObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.selectObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SelectNode create0(ArrayNodes.SelectNode current) {
                return new SelectRubyArray1Node((SelectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SelectRubyArray0Node
        extends SelectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SelectRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            SelectRubyArray0Node(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.selectNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.selectNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SelectNode create0(ArrayNodes.SelectNode current) {
                return new SelectRubyArray0Node((SelectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SelectUninitializedNode
        extends SelectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SelectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SelectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SelectUninitializedNode(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SelectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SelectBaseNode rootNode = (SelectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SelectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SelectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SelectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        private static abstract class SelectBaseNode
        extends ArrayNodes.SelectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SelectBaseNode next0;

            SelectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SelectBaseNode(SelectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                SelectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SelectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SelectUninitializedNode(this);
                    ((SelectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SelectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SelectBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SelectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SelectUninitializedNode(this), (Node)new SelectPolymorphicNode(this), (DSLNode)((SelectBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SelectBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (SelectBaseNode)SelectRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (SelectBaseNode)SelectRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (SelectBaseNode)SelectRubyArray2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SelectBaseNode otherCast = (SelectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SelectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
    public static final class ReplaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.ReplaceNode> {
        private static ReplaceNodeFactory replaceNodeFactoryInstance;

        private ReplaceNodeFactory() {
            super(ArrayNodes.ReplaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.ReplaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ReplaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ReplaceNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
            return ReplaceUninitializedNode.create0(context, sourceSection, array, other);
        }

        public static NodeFactory<ArrayNodes.ReplaceNode> getInstance() {
            if (replaceNodeFactoryInstance == null) {
                replaceNodeFactoryInstance = new ReplaceNodeFactory();
            }
            return replaceNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReplacePolymorphicNode
        extends ReplaceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arrayPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> otherPolymorphicType;

            ReplacePolymorphicNode(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arrayValue = this.array.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.next0.executeChained0(frameValue, arrayValue, otherValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arrayPolymorphicType = types[0];
                this.otherPolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                return this.next0.executeChained0(frameValue, arrayValue, otherValue);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray4Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray4Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray otherValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    otherValue = this.other.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected otherValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherObject(arrayValue, otherValue)) {
                    return super.replaceObject(arrayValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, otherValue, "One of guards [isOtherObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                RubyArray otherValueCast;
                RubyArray arrayValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isRubyArray(otherValue) && ArrayGuards.isOtherObject(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), otherValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(otherValue))) {
                    return super.replaceObject(arrayValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, arrayValue, otherValue);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current) {
                return new ReplaceRubyArray4Node((ReplaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray3Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray3Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray otherValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    otherValue = this.other.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected otherValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherFloat(arrayValue, otherValue)) {
                    return super.replaceFloat(arrayValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, otherValue, "One of guards [isOtherFloat] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                RubyArray otherValueCast;
                RubyArray arrayValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isRubyArray(otherValue) && ArrayGuards.isOtherFloat(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), otherValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(otherValue))) {
                    return super.replaceFloat(arrayValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, arrayValue, otherValue);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current) {
                return new ReplaceRubyArray3Node((ReplaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray2Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray2Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray otherValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    otherValue = this.other.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected otherValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherLongFixnum(arrayValue, otherValue)) {
                    return super.replaceLongFixnum(arrayValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, otherValue, "One of guards [isOtherLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                RubyArray otherValueCast;
                RubyArray arrayValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isRubyArray(otherValue) && ArrayGuards.isOtherLongFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), otherValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(otherValue))) {
                    return super.replaceLongFixnum(arrayValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, arrayValue, otherValue);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current) {
                return new ReplaceRubyArray2Node((ReplaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray1Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray1Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray otherValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    otherValue = this.other.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected otherValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherIntegerFixnum(arrayValue, otherValue)) {
                    return super.replaceIntegerFixnum(arrayValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, otherValue, "One of guards [isOtherIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                RubyArray otherValueCast;
                RubyArray arrayValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isRubyArray(otherValue) && ArrayGuards.isOtherIntegerFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), otherValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(otherValue))) {
                    return super.replaceIntegerFixnum(arrayValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, arrayValue, otherValue);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current) {
                return new ReplaceRubyArray1Node((ReplaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray0Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray0Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray otherValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), otherValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    otherValue = this.other.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected otherValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherNull(arrayValue, otherValue)) {
                    return super.replace(arrayValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, otherValue, "One of guards [isOtherNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                RubyArray otherValueCast;
                RubyArray arrayValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isRubyArray(otherValue) && ArrayGuards.isOtherNull(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), otherValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(otherValue))) {
                    return super.replace(arrayValueCast, otherValueCast);
                }
                return this.next0.executeChained0(frameValue, arrayValue, otherValue);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current) {
                return new ReplaceRubyArray0Node((ReplaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReplaceUninitializedNode
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReplaceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
                super(context, sourceSection, array, other);
            }

            ReplaceUninitializedNode(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arrayValue = this.array.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.executeUninitialized0(frameValue, arrayValue, otherValue);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arrayValue, otherValue);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object otherValue) {
                ReplaceBaseNode newNode = this.specialize0(arrayValue, otherValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReplaceBaseNode rootNode = (ReplaceBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.other}, new Object[]{arrayValue, otherValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReplaceBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, otherValue);
            }

            static ArrayNodes.ReplaceNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
                return new ReplaceUninitializedNode(context, sourceSection, array, other);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        private static abstract class ReplaceBaseNode
        extends ArrayNodes.ReplaceNode
        implements DSLNode {
            @Node.Child
            protected RubyNode array;
            @Node.Child
            protected RubyNode other;
            @Node.Child
            protected ReplaceBaseNode next0;

            ReplaceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
                super(context, sourceSection);
                this.array = array;
                this.other = super.coerceOtherToAry(other);
            }

            ReplaceBaseNode(ReplaceBaseNode copy) {
                super(copy);
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arrayValue, Object otherValue, String reason) {
                String message;
                ReplaceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReplaceBaseNode newNode = this.specialize0(arrayValue, otherValue);
                if (newNode == null) {
                    newNode = new ReplaceUninitializedNode(this);
                    ((ReplaceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReplaceBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ReplaceBaseNode.createInfo0(reason, arrayValue, otherValue)))) == null) {
                    returnNode = (ReplaceBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReplaceUninitializedNode(this), (Node)new ReplacePolymorphicNode(this), (DSLNode)((ReplaceBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arrayValue, otherValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReplaceBaseNode specialize0(Object arrayValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isRubyArray(otherValue)) {
                    RubyArray otherValueCast;
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    if (ArrayGuards.isOtherNull(arrayValueCast, otherValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(otherValue))) {
                        return (ReplaceBaseNode)ReplaceRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isOtherIntegerFixnum(arrayValueCast, otherValueCast)) {
                        return (ReplaceBaseNode)ReplaceRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isOtherLongFixnum(arrayValueCast, otherValueCast)) {
                        return (ReplaceBaseNode)ReplaceRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isOtherFloat(arrayValueCast, otherValueCast)) {
                        return (ReplaceBaseNode)ReplaceRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isOtherObject(arrayValueCast, otherValueCast)) {
                        return (ReplaceBaseNode)ReplaceRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.array = null;
                    this.other = null;
                } else {
                    ReplaceBaseNode otherCast = (ReplaceBaseNode)other;
                    this.array = otherCast.array;
                    this.other = otherCast.other;
                }
                this.next0 = newNext == null ? null : (ReplaceBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arrayValue, Object otherValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arrayValue").append(" = ").append(arrayValue);
                    if (arrayValue != null) {
                        builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("otherValue").append(" = ").append(otherValue);
                    if (otherValue != null) {
                        builder.append(" (").append(otherValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
    public static final class RejectInPlaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.RejectInPlaceNode> {
        private static RejectInPlaceNodeFactory rejectInPlaceNodeFactoryInstance;

        private RejectInPlaceNodeFactory() {
            super(ArrayNodes.RejectInPlaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.RejectInPlaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RejectInPlaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.RejectInPlaceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RejectInPlaceUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.RejectInPlaceNode> getInstance() {
            if (rejectInPlaceNodeFactoryInstance == null) {
                rejectInPlaceNodeFactoryInstance = new RejectInPlaceNodeFactory();
            }
            return rejectInPlaceNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RejectInPlacePolymorphicNode
        extends RejectInPlaceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RejectInPlacePolymorphicNode(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectInPlaceRubyArray4Node
        extends RejectInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectInPlaceRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectInPlaceRubyArray4Node(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObjectArray(arguments0Value)) {
                    return super.rejectInPlaceObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObjectArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObjectArray(arguments0ValueCast)) {
                        return super.rejectInPlaceObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectInPlaceNode create0(ArrayNodes.RejectInPlaceNode current) {
                return new RejectInPlaceRubyArray4Node((RejectInPlaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectInPlaceRubyArray3Node
        extends RejectInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectInPlaceRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectInPlaceRubyArray3Node(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isDoubleArray(arguments0Value)) {
                    return super.rejectInPlaceDouble(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isDoubleArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isDoubleArray(arguments0ValueCast)) {
                        return super.rejectInPlaceDouble(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectInPlaceNode create0(ArrayNodes.RejectInPlaceNode current) {
                return new RejectInPlaceRubyArray3Node((RejectInPlaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectInPlaceRubyArray2Node
        extends RejectInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectInPlaceRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectInPlaceRubyArray2Node(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongArray(arguments0Value)) {
                    return super.rejectInPlaceLong(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isLongArray(arguments0ValueCast)) {
                        return super.rejectInPlaceLong(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectInPlaceNode create0(ArrayNodes.RejectInPlaceNode current) {
                return new RejectInPlaceRubyArray2Node((RejectInPlaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectInPlaceRubyArray1Node
        extends RejectInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectInPlaceRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectInPlaceRubyArray1Node(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntArray(arguments0Value)) {
                    return super.rejectInPlaceInt(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntArray(arguments0ValueCast)) {
                        return super.rejectInPlaceInt(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectInPlaceNode create0(ArrayNodes.RejectInPlaceNode current) {
                return new RejectInPlaceRubyArray1Node((RejectInPlaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectInPlaceRubyArray0Node
        extends RejectInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectInPlaceRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectInPlaceRubyArray0Node(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNullArray(arguments0Value)) {
                    return super.rejectInPlaceNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNullArray(arguments0ValueCast)) {
                        return super.rejectInPlaceNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectInPlaceNode create0(ArrayNodes.RejectInPlaceNode current) {
                return new RejectInPlaceRubyArray0Node((RejectInPlaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RejectInPlaceUninitializedNode
        extends RejectInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectInPlaceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RejectInPlaceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RejectInPlaceUninitializedNode(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RejectInPlaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RejectInPlaceBaseNode rootNode = (RejectInPlaceBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RejectInPlaceBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectInPlaceNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RejectInPlaceUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        private static abstract class RejectInPlaceBaseNode
        extends ArrayNodes.RejectInPlaceNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RejectInPlaceBaseNode next0;

            RejectInPlaceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RejectInPlaceBaseNode(RejectInPlaceBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                RejectInPlaceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RejectInPlaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RejectInPlaceUninitializedNode(this);
                    ((RejectInPlaceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RejectInPlaceBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RejectInPlaceBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (RejectInPlaceBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RejectInPlaceUninitializedNode(this), (Node)new RejectInPlacePolymorphicNode(this), (DSLNode)((RejectInPlaceBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RejectInPlaceBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNullArray(arguments0ValueCast)) {
                        return (RejectInPlaceBaseNode)RejectInPlaceRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isIntArray(arguments0ValueCast)) {
                        return (RejectInPlaceBaseNode)RejectInPlaceRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isLongArray(arguments0ValueCast)) {
                        return (RejectInPlaceBaseNode)RejectInPlaceRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isDoubleArray(arguments0ValueCast)) {
                        return (RejectInPlaceBaseNode)RejectInPlaceRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isObjectArray(arguments0ValueCast)) {
                        return (RejectInPlaceBaseNode)RejectInPlaceRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RejectInPlaceBaseNode otherCast = (RejectInPlaceBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RejectInPlaceBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
    public static final class DeleteIfNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteIfNode> {
        private static DeleteIfNodeFactory deleteIfNodeFactoryInstance;

        private DeleteIfNodeFactory() {
            super(ArrayNodes.DeleteIfNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.DeleteIfNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteIfNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.DeleteIfNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DeleteIfUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.DeleteIfNode> getInstance() {
            if (deleteIfNodeFactoryInstance == null) {
                deleteIfNodeFactoryInstance = new DeleteIfNodeFactory();
            }
            return deleteIfNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DeleteIfPolymorphicNode
        extends DeleteIfBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DeleteIfPolymorphicNode(DeleteIfBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteIfRubyArray4Node
        extends DeleteIfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteIfRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            DeleteIfRubyArray4Node(DeleteIfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObjectArray(arguments0Value)) {
                    return super.rejectInPlaceObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObjectArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObjectArray(arguments0ValueCast)) {
                        return super.rejectInPlaceObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteIfNode create0(ArrayNodes.DeleteIfNode current) {
                return new DeleteIfRubyArray4Node((DeleteIfBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteIfRubyArray3Node
        extends DeleteIfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteIfRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            DeleteIfRubyArray3Node(DeleteIfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isDoubleArray(arguments0Value)) {
                    return super.rejectInPlaceDouble(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isDoubleArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isDoubleArray(arguments0ValueCast)) {
                        return super.rejectInPlaceDouble(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteIfNode create0(ArrayNodes.DeleteIfNode current) {
                return new DeleteIfRubyArray3Node((DeleteIfBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteIfRubyArray2Node
        extends DeleteIfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteIfRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            DeleteIfRubyArray2Node(DeleteIfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongArray(arguments0Value)) {
                    return super.rejectInPlaceLong(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isLongArray(arguments0ValueCast)) {
                        return super.rejectInPlaceLong(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteIfNode create0(ArrayNodes.DeleteIfNode current) {
                return new DeleteIfRubyArray2Node((DeleteIfBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteIfRubyArray1Node
        extends DeleteIfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteIfRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            DeleteIfRubyArray1Node(DeleteIfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntArray(arguments0Value)) {
                    return super.rejectInPlaceInt(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntArray(arguments0ValueCast)) {
                        return super.rejectInPlaceInt(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteIfNode create0(ArrayNodes.DeleteIfNode current) {
                return new DeleteIfRubyArray1Node((DeleteIfBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteIfRubyArray0Node
        extends DeleteIfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteIfRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            DeleteIfRubyArray0Node(DeleteIfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNullArray(arguments0Value)) {
                    return super.rejectInPlaceNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNullArray(arguments0ValueCast)) {
                        return super.rejectInPlaceNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteIfNode create0(ArrayNodes.DeleteIfNode current) {
                return new DeleteIfRubyArray0Node((DeleteIfBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DeleteIfUninitializedNode
        extends DeleteIfBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteIfUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DeleteIfUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DeleteIfUninitializedNode(DeleteIfBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DeleteIfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DeleteIfBaseNode rootNode = (DeleteIfBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DeleteIfBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteIfNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DeleteIfUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteIfNode.class)
        private static abstract class DeleteIfBaseNode
        extends ArrayNodes.DeleteIfNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DeleteIfBaseNode next0;

            DeleteIfBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DeleteIfBaseNode(DeleteIfBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                DeleteIfBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DeleteIfBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DeleteIfUninitializedNode(this);
                    ((DeleteIfUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DeleteIfBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DeleteIfBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DeleteIfBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DeleteIfUninitializedNode(this), (Node)new DeleteIfPolymorphicNode(this), (DSLNode)((DeleteIfBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DeleteIfBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNullArray(arguments0ValueCast)) {
                        return (DeleteIfBaseNode)DeleteIfRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isIntArray(arguments0ValueCast)) {
                        return (DeleteIfBaseNode)DeleteIfRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isLongArray(arguments0ValueCast)) {
                        return (DeleteIfBaseNode)DeleteIfRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isDoubleArray(arguments0ValueCast)) {
                        return (DeleteIfBaseNode)DeleteIfRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isObjectArray(arguments0ValueCast)) {
                        return (DeleteIfBaseNode)DeleteIfRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DeleteIfBaseNode otherCast = (DeleteIfBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DeleteIfBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.RejectNode.class)
    public static final class RejectNodeFactory
    extends NodeFactoryBase<ArrayNodes.RejectNode> {
        private static RejectNodeFactory rejectNodeFactoryInstance;

        private RejectNodeFactory() {
            super(ArrayNodes.RejectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.RejectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RejectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.RejectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RejectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.RejectNode> getInstance() {
            if (rejectNodeFactoryInstance == null) {
                rejectNodeFactoryInstance = new RejectNodeFactory();
            }
            return rejectNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RejectPolymorphicNode
        extends RejectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RejectPolymorphicNode(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectRubyArray2Node
        extends RejectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectRubyArray2Node(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.selectFixnumInteger(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.selectFixnumInteger(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectNode create0(ArrayNodes.RejectNode current) {
                return new RejectRubyArray2Node((RejectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectRubyArray1Node
        extends RejectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectRubyArray1Node(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.selectObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.selectObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectNode create0(ArrayNodes.RejectNode current) {
                return new RejectRubyArray1Node((RejectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectRubyArray0Node
        extends RejectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectRubyArray0Node(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.selectNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.selectNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectNode create0(ArrayNodes.RejectNode current) {
                return new RejectRubyArray0Node((RejectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RejectUninitializedNode
        extends RejectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RejectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RejectUninitializedNode(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RejectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RejectBaseNode rootNode = (RejectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RejectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RejectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        private static abstract class RejectBaseNode
        extends ArrayNodes.RejectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RejectBaseNode next0;

            RejectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RejectBaseNode(RejectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                RejectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RejectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RejectUninitializedNode(this);
                    ((RejectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RejectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = RejectBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (RejectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RejectUninitializedNode(this), (Node)new RejectPolymorphicNode(this), (DSLNode)((RejectBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RejectBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (RejectBaseNode)RejectRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (RejectBaseNode)RejectRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (RejectBaseNode)RejectRubyArray2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RejectBaseNode otherCast = (RejectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RejectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PushOneNode.class)
    public static final class PushOneNodeFactory
    extends NodeFactoryBase<ArrayNodes.PushOneNode> {
        private static PushOneNodeFactory pushOneNodeFactoryInstance;

        private PushOneNodeFactory() {
            super(ArrayNodes.PushOneNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PushOneNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PushOneNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.PushOneNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PushOneUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.PushOneNode> getInstance() {
            if (pushOneNodeFactoryInstance == null) {
                pushOneNodeFactoryInstance = new PushOneNodeFactory();
            }
            return pushOneNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PushOnePolymorphicNode
        extends PushOneBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PushOnePolymorphicNode(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushOneRubyArrayObject2Node
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneRubyArrayObject2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PushOneRubyArrayObject2Node(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.pushObjectObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.pushObjectObject(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(ArrayNodes.PushOneNode current) {
                return new PushOneRubyArrayObject2Node((PushOneBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushOneRubyArrayObject1Node
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneRubyArrayObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PushOneRubyArrayObject1Node(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isInteger(arguments1Value)) {
                    return super.pushIntegerFixnumObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isInteger] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.pushIntegerFixnumObject(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(ArrayNodes.PushOneNode current) {
                return new PushOneRubyArrayObject1Node((PushOneBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushOneRubyArrayIntNode
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneRubyArrayIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PushOneRubyArrayIntNode(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.pushIntegerFixnumIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.pushIntegerFixnumIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(ArrayNodes.PushOneNode current) {
                return new PushOneRubyArrayIntNode((PushOneBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushOneRubyArrayObject0Node
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneRubyArrayObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PushOneRubyArrayObject0Node(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.pushEmpty(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.pushEmpty(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(ArrayNodes.PushOneNode current) {
                return new PushOneRubyArrayObject0Node((PushOneBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PushOneUninitializedNode
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PushOneUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PushOneUninitializedNode(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PushOneBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PushOneBaseNode rootNode = (PushOneBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PushOneBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PushOneUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        private static abstract class PushOneBaseNode
        extends ArrayNodes.PushOneNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PushOneBaseNode next0;

            PushOneBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PushOneBaseNode(PushOneBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PushOneBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PushOneBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PushOneUninitializedNode(this);
                    ((PushOneUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PushOneBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PushOneBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PushOneBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PushOneUninitializedNode(this), (Node)new PushOnePolymorphicNode(this), (DSLNode)((PushOneBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PushOneBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (PushOneBaseNode)PushOneRubyArrayObject0Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (PushOneBaseNode)PushOneRubyArrayIntNode.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && !super.isInteger(arguments1Value)) {
                        return (PushOneBaseNode)PushOneRubyArrayObject1Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (PushOneBaseNode)PushOneRubyArrayObject2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PushOneBaseNode otherCast = (PushOneBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PushOneBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PushNode.class)
    public static final class PushNodeFactory
    extends NodeFactoryBase<ArrayNodes.PushNode> {
        private static PushNodeFactory pushNodeFactoryInstance;

        private PushNodeFactory() {
            super(ArrayNodes.PushNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PushNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PushNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.PushNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PushUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.PushNode> getInstance() {
            if (pushNodeFactoryInstance == null) {
                pushNodeFactoryInstance = new PushNodeFactory();
            }
            return pushNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PushPolymorphicNode
        extends PushBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PushPolymorphicNode(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray9Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray9Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray9Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.pushObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.pushObject(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray9Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray8Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray8Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray8Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.pushFloat(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.pushFloat(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray8Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray7Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray7Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray7Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value) && super.isSingleLongFixnum(arguments0Value, arguments1Value)) {
                    return super.pushLongFixnumSingleLongFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, isSingleLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast) && super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushLongFixnumSingleLongFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray7Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray6Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray6Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray6Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value) && super.isSingleIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.pushLongFixnumSingleIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, isSingleIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast) && super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushLongFixnumSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray6Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray5Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray5Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray5Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isSingleIntegerFixnum(arguments0Value, arguments1Value) && !super.isSingleLongFixnum(arguments0Value, arguments1Value)) {
                    return super.pushIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isSingleIntegerFixnum, !isSingleLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && !super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast) && !super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray5Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray4Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray4Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && super.isSingleIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.pushIntegerFixnumSingleIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, isSingleIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushIntegerFixnumSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray4Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray3Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray3Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (!ArrayGuards.isNull(arguments0Value) && ArrayGuards.isEmpty(arguments0Value)) {
                    return super.pushEmptySingleIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isNull, isEmpty] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (!ArrayGuards.isNull(arguments0ValueCast) && ArrayGuards.isEmpty(arguments0ValueCast)) {
                        return super.pushEmptySingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray3Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray2Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray2Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.pushNullEmptyObjects(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.pushNullEmptyObjects(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray2Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray1Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray1Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isNull(arguments0Value) && super.isSingleLongFixnum(arguments0Value, arguments1Value)) {
                    return super.pushNullEmptySingleIntegerLong(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull, isSingleLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast) && super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushNullEmptySingleIntegerLong(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray1Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray0Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray0Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isNull(arguments0Value) && super.isSingleIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.pushNullEmptySingleIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull, isSingleIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast) && super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushNullEmptySingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current) {
                return new PushRubyArray0Node((PushBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PushUninitializedNode
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PushUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PushUninitializedNode(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PushBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PushBaseNode rootNode = (PushBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PushBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PushUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        private static abstract class PushBaseNode
        extends ArrayNodes.PushNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PushBaseNode next0;

            PushBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PushBaseNode(PushBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PushBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PushBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PushUninitializedNode(this);
                    ((PushUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PushBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PushBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PushBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PushUninitializedNode(this), (Node)new PushPolymorphicNode(this), (DSLNode)((PushBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PushBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        if (super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray0Node.create0(this);
                        }
                        if (super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray1Node.create0(this);
                        }
                        return (PushBaseNode)PushRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isEmpty(arguments0ValueCast)) {
                        return (PushBaseNode)PushRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        if (super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray4Node.create0(this);
                        }
                        if (!super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray5Node.create0(this);
                        }
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        if (super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray6Node.create0(this);
                        }
                        if (super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray7Node.create0(this);
                        }
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return (PushBaseNode)PushRubyArray8Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (PushBaseNode)PushRubyArray9Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PushBaseNode otherCast = (PushBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PushBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PopNode.class)
    public static final class PopNodeFactory
    extends NodeFactoryBase<ArrayNodes.PopNode> {
        private static PopNodeFactory popNodeFactoryInstance;

        private PopNodeFactory() {
            super(ArrayNodes.PopNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PopNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PopNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.PopNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PopUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.PopNode> getInstance() {
            if (popNodeFactoryInstance == null) {
                popNodeFactoryInstance = new PopNodeFactory();
            }
            return popNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PopPolymorphicNode
        extends PopBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PopPolymorphicNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                Object arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated)) : arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject4Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PopObject4Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isObject(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popObjectWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isObject(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popObjectWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popObjectWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObject4Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject3Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject3Node.class, new Class[]{PopRubyArrayObject2Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PopObject3Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isFloat(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popFloatWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isFloat(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popFloatWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popFloatWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObject3Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopRubyArrayObject2Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopRubyArrayObject2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObject3Node.class}, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PopRubyArrayObject2Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isFloat(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.popFloatInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat, !isInteger, !isUndefinedPlaceholder] failed"));
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isFloat(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.popFloatInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    try {
                        return super.popFloatInBoundsWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopRubyArrayObject2Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject2Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject2Node.class, new Class[]{PopRubyArrayObject1Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PopObject2Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isLongFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popLongFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isLongFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popLongFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popLongFixnumWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObject2Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopRubyArrayObject1Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopRubyArrayObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObject2Node.class}, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PopRubyArrayObject1Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isLongFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.popLongFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, !isInteger, !isUndefinedPlaceholder] failed"));
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isLongFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.popLongFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    try {
                        return super.popLongFixnumInBoundsWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopRubyArrayObject1Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject1Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject1Node.class, new Class[]{PopRubyArrayObject0Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PopObject1Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popIntegerFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popIntegerFixnumWithNumObj(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popIntegerFixnumWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObject1Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopRubyArrayObject0Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopRubyArrayObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObject1Node.class}, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PopRubyArrayObject0Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.popIntegerFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isInteger, !isUndefinedPlaceholder] failed"));
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    try {
                        return super.popIntegerFixnumInBoundsWithNumObj(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, !isInteger, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    try {
                        return super.popIntegerFixnumInBoundsWithNumObj(frameValue, arguments0ValueCast, arguments1Value);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopRubyArrayObject0Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObjectInt3Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObjectInt3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PopObjectInt3Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.popObjectWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.popObjectWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.popObjectWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObjectInt3Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObjectInt2Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObjectInt2Node.class, new Class[]{PopRubyArrayInt2Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PopObjectInt2Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.popFloatWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.popFloatWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.popFloatWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObjectInt2Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopRubyArrayInt2Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopRubyArrayInt2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObjectInt2Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PopRubyArrayInt2Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.popFloatInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed"));
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.popFloatInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        try {
                            return super.popFloatInBoundsWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopRubyArrayInt2Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObjectInt1Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObjectInt1Node.class, new Class[]{PopRubyArrayInt1Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PopObjectInt1Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.popLongFixnumWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.popLongFixnumWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.popLongFixnumWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObjectInt1Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopRubyArrayInt1Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopRubyArrayInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObjectInt1Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PopRubyArrayInt1Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    try {
                        return super.popLongFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed"));
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    try {
                        return super.popLongFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        try {
                            return super.popLongFixnumInBoundsWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopRubyArrayInt1Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObjectInt0Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObjectInt0Node.class, new Class[]{PopRubyArrayInt0Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PopObjectInt0Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.popIntegerFixnumWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.popIntegerFixnumWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.popIntegerFixnumWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObjectInt0Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopRubyArrayInt0Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopRubyArrayInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObjectInt0Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PopRubyArrayInt0Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.popIntegerFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                int arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectInteger(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.popIntegerFixnumInBoundsWithNum(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        try {
                            return super.popIntegerFixnumInBoundsWithNum(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopRubyArrayInt0Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject0Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PopObject0Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isNullOrEmpty(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popNilWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullOrEmpty, !isUndefinedPlaceholder] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isNullOrEmpty(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                    return super.popNilWithNum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullOrEmpty, !isUndefinedPlaceholder] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isUndefinedPlaceholder(arguments1Value) && ArrayGuards.isNullOrEmpty(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popNilWithNum(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObject0Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObjectUndefinedPlaceholder4Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObjectUndefinedPlaceholder4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            PopObjectUndefinedPlaceholder4Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.popObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.popObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.popObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObjectUndefinedPlaceholder4Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObjectUndefinedPlaceholder3Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObjectUndefinedPlaceholder3Node.class, new Class[]{PopDoubleUndefinedPlaceholderNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            PopObjectUndefinedPlaceholder3Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.popFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.popFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.popFloat(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObjectUndefinedPlaceholder3Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopDoubleUndefinedPlaceholderNode
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopDoubleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObjectUndefinedPlaceholder3Node.class}, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            PopDoubleUndefinedPlaceholderNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.popFloatInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed"));
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.popFloatInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        try {
                            return super.popFloatInBounds(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopDoubleUndefinedPlaceholderNode((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObjectUndefinedPlaceholder2Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObjectUndefinedPlaceholder2Node.class, new Class[]{PopLongUndefinedPlaceholderNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            PopObjectUndefinedPlaceholder2Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.popLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.popLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.popLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObjectUndefinedPlaceholder2Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopLongUndefinedPlaceholderNode
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopLongUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObjectUndefinedPlaceholder2Node.class}, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            PopLongUndefinedPlaceholderNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    try {
                        return super.popLongFixnumInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed"));
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    try {
                        return super.popLongFixnumInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        try {
                            return super.popLongFixnumInBounds(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopLongUndefinedPlaceholderNode((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObjectUndefinedPlaceholder1Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObjectUndefinedPlaceholder1Node.class, new Class[]{PopIntUndefinedPlaceholderNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            PopObjectUndefinedPlaceholder1Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.popIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.popIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.popIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObjectUndefinedPlaceholder1Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopIntUndefinedPlaceholderNode
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObjectUndefinedPlaceholder1Node.class}, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            PopIntUndefinedPlaceholderNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.popIntegerFixnumInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.popIntegerFixnumInBounds(frameValue, arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        try {
                            return super.popIntegerFixnumInBounds(frameValue, arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopIntUndefinedPlaceholderNode((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObjectUndefinedPlaceholder0Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObjectUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            PopObjectUndefinedPlaceholder0Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isNullOrEmpty(arguments0Value)) {
                    return super.popNil(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullOrEmpty] failed");
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value = arguments0ValueEvaluated;
                try {
                    arguments1Value = RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(arguments1ValueEvaluated);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isNullOrEmpty(arguments0Value)) {
                    return super.popNil(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullOrEmpty] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isNullOrEmpty(arguments0ValueCast)) {
                        return super.popNil(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current) {
                return new PopObjectUndefinedPlaceholder0Node((PopBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PopUninitializedNode
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PopUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PopUninitializedNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public Object executePop(VirtualFrame frameValue, RubyArray arguments0ValueEvaluated, Object arguments1ValueEvaluated) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Object arguments1Value = arguments1ValueEvaluated;
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PopBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PopBaseNode rootNode = (PopBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PopBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PopNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PopUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        private static abstract class PopBaseNode
        extends ArrayNodes.PopNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PopBaseNode next0;

            PopBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PopBaseNode(PopBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PopBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PopBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PopUninitializedNode(this);
                    ((PopUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PopBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PopBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PopBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PopUninitializedNode(this), (Node)new PopPolymorphicNode(this), (DSLNode)((PopBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PopBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (ArrayGuards.isNullOrEmpty(arguments0ValueCast)) {
                            return (PopBaseNode)PopObjectUndefinedPlaceholder0Node.create0(this);
                        }
                        if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)PopIntUndefinedPlaceholderNode.METADATA)) {
                                return (PopBaseNode)PopIntUndefinedPlaceholderNode.create0(this);
                            }
                            return (PopBaseNode)PopObjectUndefinedPlaceholder1Node.create0(this);
                        }
                        if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)PopLongUndefinedPlaceholderNode.METADATA)) {
                                return (PopBaseNode)PopLongUndefinedPlaceholderNode.create0(this);
                            }
                            return (PopBaseNode)PopObjectUndefinedPlaceholder2Node.create0(this);
                        }
                        if (ArrayGuards.isFloat(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)PopDoubleUndefinedPlaceholderNode.METADATA)) {
                                return (PopBaseNode)PopDoubleUndefinedPlaceholderNode.create0(this);
                            }
                            return (PopBaseNode)PopObjectUndefinedPlaceholder3Node.create0(this);
                        }
                        if (ArrayGuards.isObject(arguments0ValueCast)) {
                            return (PopBaseNode)PopObjectUndefinedPlaceholder4Node.create0(this);
                        }
                    }
                    if (ArrayGuards.isNullOrEmpty(arguments0ValueCast) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        return (PopBaseNode)PopObject0Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)PopRubyArrayInt0Node.METADATA)) {
                                return (PopBaseNode)PopRubyArrayInt0Node.create0(this);
                            }
                            return (PopBaseNode)PopObjectInt0Node.create0(this);
                        }
                        if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)PopRubyArrayInt1Node.METADATA)) {
                                return (PopBaseNode)PopRubyArrayInt1Node.create0(this);
                            }
                            return (PopBaseNode)PopObjectInt1Node.create0(this);
                        }
                        if (ArrayGuards.isFloat(arguments0ValueCast)) {
                            if (!DSLShare.isExcluded((Node)this, (DSLMetadata)PopRubyArrayInt2Node.METADATA)) {
                                return (PopBaseNode)PopRubyArrayInt2Node.create0(this);
                            }
                            return (PopBaseNode)PopObjectInt2Node.create0(this);
                        }
                        if (ArrayGuards.isObject(arguments0ValueCast)) {
                            return (PopBaseNode)PopObjectInt3Node.create0(this);
                        }
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)PopRubyArrayObject0Node.METADATA)) {
                            return (PopBaseNode)PopRubyArrayObject0Node.create0(this);
                        }
                        return (PopBaseNode)PopObject1Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)PopRubyArrayObject1Node.METADATA)) {
                            return (PopBaseNode)PopRubyArrayObject1Node.create0(this);
                        }
                        return (PopBaseNode)PopObject2Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)PopRubyArrayObject2Node.METADATA)) {
                            return (PopBaseNode)PopRubyArrayObject2Node.create0(this);
                        }
                        return (PopBaseNode)PopObject3Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value)) {
                        return (PopBaseNode)PopObject4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PopBaseNode otherCast = (PopBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PopBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PackNode.class)
    public static final class PackNodeFactory
    extends NodeFactoryBase<ArrayNodes.PackNode> {
        private static PackNodeFactory packNodeFactoryInstance;

        private PackNodeFactory() {
            super(ArrayNodes.PackNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PackNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PackNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.PackNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PackUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.PackNode> getInstance() {
            if (packNodeFactoryInstance == null) {
                packNodeFactoryInstance = new PackNodeFactory();
            }
            return packNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PackPolymorphicNode
        extends PackBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PackPolymorphicNode(PackBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PackRubyArrayObjectNode
        extends PackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PackRubyArrayObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PackRubyArrayObjectNode(PackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (!super.isRubyString(arguments1Value)) {
                    return super.pack(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [!isRubyString] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !super.isRubyString(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.pack(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PackNode create0(ArrayNodes.PackNode current) {
                return new PackRubyArrayObjectNode((PackBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PackRubyArrayRubyString2Node
        extends PackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PackRubyArrayRubyString2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyString.class}, 0, 0);

            PackRubyArrayRubyString2Node(PackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.pack(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.pack(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PackNode create0(ArrayNodes.PackNode current) {
                return new PackRubyArrayRubyString2Node((PackBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PackRubyArrayRubyString1Node
        extends PackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PackRubyArrayRubyString1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyString.class}, 0, 0);

            PackRubyArrayRubyString1Node(PackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                if (super.arrayIsLongs(arguments0Value) && super.formatIsLStar(arguments0Value, arguments1Value)) {
                    return super.packLStar(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [arrayIsLongs, formatIsLStar] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    if (super.arrayIsLongs(arguments0ValueCast) && super.formatIsLStar(arguments0ValueCast, arguments1ValueCast)) {
                        return super.packLStar(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PackNode create0(ArrayNodes.PackNode current) {
                return new PackRubyArrayRubyString1Node((PackBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PackRubyArrayRubyString0Node
        extends PackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PackRubyArrayRubyString0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyString.class}, 0, 0);

            PackRubyArrayRubyString0Node(PackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                if (super.arrayIsInts(arguments0Value) && super.formatIsXN2000(arguments0Value, arguments1Value)) {
                    return super.packXN2000(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [arrayIsInts, formatIsXN2000] failed");
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    if (super.arrayIsInts(arguments0ValueCast) && super.formatIsXN2000(arguments0ValueCast, arguments1ValueCast)) {
                        return super.packXN2000(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PackNode create0(ArrayNodes.PackNode current) {
                return new PackRubyArrayRubyString0Node((PackBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PackUninitializedNode
        extends PackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PackUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PackUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PackUninitializedNode(PackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value;
                try {
                    value = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PackBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PackBaseNode rootNode = (PackBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PackBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PackNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PackUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        private static abstract class PackBaseNode
        extends ArrayNodes.PackNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PackBaseNode next0;

            PackBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PackBaseNode(PackBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                PackBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PackBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PackUninitializedNode(this);
                    ((PackUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PackBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = PackBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PackBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PackUninitializedNode(this), (Node)new PackPolymorphicNode(this), (DSLNode)((PackBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PackBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                        if (super.arrayIsInts(arguments0ValueCast) && super.formatIsXN2000(arguments0ValueCast, arguments1ValueCast)) {
                            return (PackBaseNode)PackRubyArrayRubyString0Node.create0(this);
                        }
                        if (super.arrayIsLongs(arguments0ValueCast) && super.formatIsLStar(arguments0ValueCast, arguments1ValueCast)) {
                            return (PackBaseNode)PackRubyArrayRubyString1Node.create0(this);
                        }
                        return (PackBaseNode)PackRubyArrayRubyString2Node.create0(this);
                    }
                    if (!super.isRubyString(arguments1Value)) {
                        return (PackBaseNode)PackRubyArrayObjectNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PackBaseNode otherCast = (PackBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PackBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
    public static final class MinBlockNodeFactory
    extends NodeFactoryBase<ArrayNodes.MinBlockNode> {
        private static MinBlockNodeFactory minBlockNodeFactoryInstance;

        private MinBlockNodeFactory() {
            super(ArrayNodes.MinBlockNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MinBlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MinBlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MinBlockNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MinBlockObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MinBlockNode> getInstance() {
            if (minBlockNodeFactoryInstance == null) {
                minBlockNodeFactoryInstance = new MinBlockNodeFactory();
            }
            return minBlockNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MinBlockObjectNode
        extends MinBlockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MinBlockObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            MinBlockObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.min(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MinBlockNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MinBlockObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
        private static abstract class MinBlockBaseNode
        extends ArrayNodes.MinBlockNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            MinBlockBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MinBlockBaseNode otherCast = (MinBlockBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MinNode.class)
    public static final class MinNodeFactory
    extends NodeFactoryBase<ArrayNodes.MinNode> {
        private static MinNodeFactory minNodeFactoryInstance;

        private MinNodeFactory() {
            super(ArrayNodes.MinNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MinUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MinNode> getInstance() {
            if (minNodeFactoryInstance == null) {
                minNodeFactoryInstance = new MinNodeFactory();
            }
            return minNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MinPolymorphicNode
        extends MinBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            MinPolymorphicNode(MinBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MinRubyArrayNode
        extends MinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MinRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            MinRubyArrayNode(MinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.min(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.min(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.MinNode create0(ArrayNodes.MinNode current) {
                return new MinRubyArrayNode((MinBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MinUninitializedNode
        extends MinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MinUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MinUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MinUninitializedNode(MinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                MinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MinBaseNode rootNode = (MinBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MinBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.MinNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MinUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        private static abstract class MinBaseNode
        extends ArrayNodes.MinNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MinBaseNode next0;

            MinBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MinBaseNode(MinBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                MinBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new MinUninitializedNode(this);
                    ((MinUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MinBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MinBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (MinBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MinUninitializedNode(this), (Node)new MinPolymorphicNode(this), (DSLNode)((MinBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MinBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (MinBaseNode)MinRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((MinBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (MinBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
    public static final class MaxBlockNodeFactory
    extends NodeFactoryBase<ArrayNodes.MaxBlockNode> {
        private static MaxBlockNodeFactory maxBlockNodeFactoryInstance;

        private MaxBlockNodeFactory() {
            super(ArrayNodes.MaxBlockNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MaxBlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MaxBlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MaxBlockNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MaxBlockObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MaxBlockNode> getInstance() {
            if (maxBlockNodeFactoryInstance == null) {
                maxBlockNodeFactoryInstance = new MaxBlockNodeFactory();
            }
            return maxBlockNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MaxBlockObjectNode
        extends MaxBlockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MaxBlockObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            MaxBlockObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value;
                try {
                    value = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.max(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MaxBlockNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MaxBlockObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
        private static abstract class MaxBlockBaseNode
        extends ArrayNodes.MaxBlockNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            MaxBlockBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MaxBlockBaseNode otherCast = (MaxBlockBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MaxNode.class)
    public static final class MaxNodeFactory
    extends NodeFactoryBase<ArrayNodes.MaxNode> {
        private static MaxNodeFactory maxNodeFactoryInstance;

        private MaxNodeFactory() {
            super(ArrayNodes.MaxNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MaxNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MaxNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MaxNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MaxUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MaxNode> getInstance() {
            if (maxNodeFactoryInstance == null) {
                maxNodeFactoryInstance = new MaxNodeFactory();
            }
            return maxNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MaxPolymorphicNode
        extends MaxBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            MaxPolymorphicNode(MaxBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MaxRubyArrayNode
        extends MaxBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MaxRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            MaxRubyArrayNode(MaxBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.max(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.max(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.MaxNode create0(ArrayNodes.MaxNode current) {
                return new MaxRubyArrayNode((MaxBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MaxUninitializedNode
        extends MaxBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MaxUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MaxUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MaxUninitializedNode(MaxBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                MaxBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MaxBaseNode rootNode = (MaxBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MaxBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.MaxNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MaxUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        private static abstract class MaxBaseNode
        extends ArrayNodes.MaxNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MaxBaseNode next0;

            MaxBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MaxBaseNode(MaxBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason) {
                String message;
                MaxBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MaxBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new MaxUninitializedNode(this);
                    ((MaxUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MaxBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MaxBaseNode.createInfo0(reason, arguments0Value)))) == null) {
                    returnNode = (MaxBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MaxUninitializedNode(this), (Node)new MaxPolymorphicNode(this), (DSLNode)((MaxBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MaxBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (MaxBaseNode)MaxRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((MaxBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (MaxBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
    public static final class MapInPlaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.MapInPlaceNode> {
        private static MapInPlaceNodeFactory mapInPlaceNodeFactoryInstance;

        private MapInPlaceNodeFactory() {
            super(ArrayNodes.MapInPlaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MapInPlaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MapInPlaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MapInPlaceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MapInPlaceUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MapInPlaceNode> getInstance() {
            if (mapInPlaceNodeFactoryInstance == null) {
                mapInPlaceNodeFactoryInstance = new MapInPlaceNodeFactory();
            }
            return mapInPlaceNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MapInPlacePolymorphicNode
        extends MapInPlaceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MapInPlacePolymorphicNode(MapInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapInPlaceObjectRubyProc1Node
        extends MapInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapInPlaceObjectRubyProc1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapInPlaceObjectRubyProc1Node(MapInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.mapInPlaceObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.mapInPlaceObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapInPlaceNode create0(ArrayNodes.MapInPlaceNode current) {
                return new MapInPlaceObjectRubyProc1Node((MapInPlaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapInPlaceObjectRubyProc0Node
        extends MapInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapInPlaceObjectRubyProc0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapInPlaceObjectRubyProc0Node(MapInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.mapInPlaceFixnumInteger(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.mapInPlaceFixnumInteger(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapInPlaceNode create0(ArrayNodes.MapInPlaceNode current) {
                return new MapInPlaceObjectRubyProc0Node((MapInPlaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapInPlaceRubyArrayRubyProcNode
        extends MapInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapInPlaceRubyArrayRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapInPlaceRubyArrayRubyProcNode(MapInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc"));
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.mapInPlaceNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.mapInPlaceNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapInPlaceNode create0(ArrayNodes.MapInPlaceNode current) {
                return new MapInPlaceRubyArrayRubyProcNode((MapInPlaceBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MapInPlaceUninitializedNode
        extends MapInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapInPlaceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MapInPlaceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MapInPlaceUninitializedNode(MapInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MapInPlaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MapInPlaceBaseNode rootNode = (MapInPlaceBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MapInPlaceBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapInPlaceNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MapInPlaceUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        private static abstract class MapInPlaceBaseNode
        extends ArrayNodes.MapInPlaceNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MapInPlaceBaseNode next0;

            MapInPlaceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MapInPlaceBaseNode(MapInPlaceBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MapInPlaceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MapInPlaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MapInPlaceUninitializedNode(this);
                    ((MapInPlaceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MapInPlaceBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MapInPlaceBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MapInPlaceBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MapInPlaceUninitializedNode(this), (Node)new MapInPlacePolymorphicNode(this), (DSLNode)((MapInPlaceBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MapInPlaceBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (MapInPlaceBaseNode)MapInPlaceRubyArrayRubyProcNode.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (MapInPlaceBaseNode)MapInPlaceObjectRubyProc0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (MapInPlaceBaseNode)MapInPlaceObjectRubyProc1Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MapInPlaceBaseNode otherCast = (MapInPlaceBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MapInPlaceBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MapNode.class)
    public static final class MapNodeFactory
    extends NodeFactoryBase<ArrayNodes.MapNode> {
        private static MapNodeFactory mapNodeFactoryInstance;

        private MapNodeFactory() {
            super(ArrayNodes.MapNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MapNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MapNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MapNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MapUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MapNode> getInstance() {
            if (mapNodeFactoryInstance == null) {
                mapNodeFactoryInstance = new MapNodeFactory();
            }
            return mapNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MapPolymorphicNode
        extends MapBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MapPolymorphicNode(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapObjectRubyProc3Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapObjectRubyProc3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapObjectRubyProc3Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.mapObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.mapObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current) {
                return new MapObjectRubyProc3Node((MapBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapObjectRubyProc2Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapObjectRubyProc2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapObjectRubyProc2Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.mapFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.mapFloat(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current) {
                return new MapObjectRubyProc2Node((MapBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapObjectRubyProc1Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapObjectRubyProc1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapObjectRubyProc1Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.mapLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.mapLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current) {
                return new MapObjectRubyProc1Node((MapBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapObjectRubyProc0Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapObjectRubyProc0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapObjectRubyProc0Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.mapIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.mapIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current) {
                return new MapObjectRubyProc0Node((MapBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyArrayRubyProcNode
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyArrayRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapRubyArrayRubyProcNode(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc"));
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.mapNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.mapNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current) {
                return new MapRubyArrayRubyProcNode((MapBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MapUninitializedNode
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MapUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MapUninitializedNode(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MapBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MapBaseNode rootNode = (MapBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MapBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MapUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        private static abstract class MapBaseNode
        extends ArrayNodes.MapNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MapBaseNode next0;

            MapBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MapBaseNode(MapBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                MapBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MapBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MapUninitializedNode(this);
                    ((MapUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MapBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = MapBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MapBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MapUninitializedNode(this), (Node)new MapPolymorphicNode(this), (DSLNode)((MapBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MapBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyArrayRubyProcNode.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (MapBaseNode)MapObjectRubyProc0Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return (MapBaseNode)MapObjectRubyProc1Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return (MapBaseNode)MapObjectRubyProc2Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (MapBaseNode)MapObjectRubyProc3Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MapBaseNode otherCast = (MapBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MapBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InsertNode.class)
    public static final class InsertNodeFactory
    extends NodeFactoryBase<ArrayNodes.InsertNode> {
        private static InsertNodeFactory insertNodeFactoryInstance;

        private InsertNodeFactory() {
            super(ArrayNodes.InsertNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InsertNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InsertNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.InsertNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InsertUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.InsertNode> getInstance() {
            if (insertNodeFactoryInstance == null) {
                insertNodeFactoryInstance = new InsertNodeFactory();
            }
            return insertNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InsertPolymorphicNode
        extends InsertBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InsertPolymorphicNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InsertRubyArray2Node
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertRubyArray2Node.class, new Class[]{InsertRubyArray0Node.class, InsertRubyArray1Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            InsertRubyArray2Node(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.insertBoxed(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.insertBoxed(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InsertNode create0(ArrayNodes.InsertNode current) {
                return new InsertRubyArray2Node((InsertBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InsertRubyArray1Node
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{InsertRubyArray2Node.class}, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            InsertRubyArray1Node(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isArgsLengthTwo(arguments0Value, arguments1Value)) {
                    try {
                        return super.insert(arguments0Value, arguments1Value);
                    }
                    catch (ClassCastException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ClassCastException");
                    }
                    catch (IndexOutOfBoundsException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown IndexOutOfBoundsException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isArgsLengthTwo] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                Object[] arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value) && ArrayGuards.isArgsLengthTwo(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value))) {
                    try {
                        return super.insert(arguments0ValueCast, arguments1ValueCast);
                    }
                    catch (ClassCastException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown ClassCastException");
                    }
                    catch (IndexOutOfBoundsException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown IndexOutOfBoundsException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InsertNode create0(ArrayNodes.InsertNode current) {
                return new InsertRubyArray1Node((InsertBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InsertRubyArray0Node
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            InsertRubyArray0Node(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isNull(arguments0Value) && ArrayGuards.isIntIndexAndOtherSingleObjectArg(arguments0Value, arguments1Value)) {
                    return super.insertNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull, isIntIndexAndOtherSingleObjectArg] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast) && ArrayGuards.isIntIndexAndOtherSingleObjectArg(arguments0ValueCast, arguments1ValueCast)) {
                        return super.insertNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InsertNode create0(ArrayNodes.InsertNode current) {
                return new InsertRubyArray0Node((InsertBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InsertUninitializedNode
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InsertUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InsertUninitializedNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InsertBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InsertBaseNode rootNode = (InsertBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InsertBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InsertNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InsertUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        private static abstract class InsertBaseNode
        extends ArrayNodes.InsertNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InsertBaseNode next0;

            InsertBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InsertBaseNode(InsertBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                InsertBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InsertBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InsertUninitializedNode(this);
                    ((InsertUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InsertBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InsertBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InsertBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InsertUninitializedNode(this), (Node)new InsertPolymorphicNode(this), (DSLNode)((InsertBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InsertBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast) && ArrayGuards.isIntIndexAndOtherSingleObjectArg(arguments0ValueCast, arguments1ValueCast)) {
                        return (InsertBaseNode)InsertRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isArgsLengthTwo(arguments0ValueCast, arguments1ValueCast) && !DSLShare.isExcluded((Node)this, (DSLMetadata)InsertRubyArray1Node.METADATA)) {
                        return (InsertBaseNode)InsertRubyArray1Node.create0(this);
                    }
                    return (InsertBaseNode)InsertRubyArray2Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InsertBaseNode otherCast = (InsertBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InsertBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InjectNode.class)
    public static final class InjectNodeFactory
    extends NodeFactoryBase<ArrayNodes.InjectNode> {
        private static InjectNodeFactory injectNodeFactoryInstance;

        private InjectNodeFactory() {
            super(ArrayNodes.InjectNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InjectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InjectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.InjectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InjectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.InjectNode> getInstance() {
            if (injectNodeFactoryInstance == null) {
                injectNodeFactoryInstance = new InjectNodeFactory();
            }
            return injectNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InjectPolymorphicNode
        extends InjectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InjectPolymorphicNode(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InjectRubyArrayRubySymbolUndefinedPlaceholderNode
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectRubyArrayRubySymbolUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubySymbol.class, UndefinedPlaceholder.class}, 0, 0);

            InjectRubyArrayRubySymbolUndefinedPlaceholderNode(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubySymbol arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.inject(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.inject(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(ArrayNodes.InjectNode current) {
                return new InjectRubyArrayRubySymbolUndefinedPlaceholderNode((InjectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InjectRubyArrayObjectRubyProc4Node
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectRubyArrayObjectRubyProc4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class, RubyProc.class}, 0, 0);

            InjectRubyArrayObjectRubyProc4Node(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (ArrayGuards.isNullArray(arguments0Value)) {
                    return super.injectNull(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isNullArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    if (ArrayGuards.isNullArray(arguments0ValueCast)) {
                        return super.injectNull(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(ArrayNodes.InjectNode current) {
                return new InjectRubyArrayObjectRubyProc4Node((InjectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InjectRubyArrayObjectRubyProc3Node
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectRubyArrayObjectRubyProc3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class, RubyProc.class}, 0, 0);

            InjectRubyArrayObjectRubyProc3Node(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.injectObject(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.injectObject(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(ArrayNodes.InjectNode current) {
                return new InjectRubyArrayObjectRubyProc3Node((InjectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InjectRubyArrayObjectRubyProc2Node
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectRubyArrayObjectRubyProc2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class, RubyProc.class}, 0, 0);

            InjectRubyArrayObjectRubyProc2Node(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.injectFloat(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.injectFloat(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(ArrayNodes.InjectNode current) {
                return new InjectRubyArrayObjectRubyProc2Node((InjectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InjectRubyArrayObjectRubyProc1Node
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectRubyArrayObjectRubyProc1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class, RubyProc.class}, 0, 0);

            InjectRubyArrayObjectRubyProc1Node(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.injectLongFixnum(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.injectLongFixnum(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(ArrayNodes.InjectNode current) {
                return new InjectRubyArrayObjectRubyProc1Node((InjectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InjectRubyArrayObjectRubyProc0Node
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectRubyArrayObjectRubyProc0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class, RubyProc.class}, 0, 0);

            InjectRubyArrayObjectRubyProc0Node(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.injectIntegerFixnum(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.injectIntegerFixnum(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(ArrayNodes.InjectNode current) {
                return new InjectRubyArrayObjectRubyProc0Node((InjectBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InjectUninitializedNode
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InjectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InjectUninitializedNode(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InjectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InjectBaseNode rootNode = (InjectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InjectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InjectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        private static abstract class InjectBaseNode
        extends ArrayNodes.InjectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InjectBaseNode next0;

            InjectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InjectBaseNode(InjectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason) {
                String message;
                InjectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InjectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InjectUninitializedNode(this);
                    ((InjectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InjectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InjectBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (InjectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InjectUninitializedNode(this), (Node)new InjectPolymorphicNode(this), (DSLNode)((InjectBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InjectBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                        if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                            return (InjectBaseNode)InjectRubyArrayObjectRubyProc0Node.create0(this);
                        }
                        if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                            return (InjectBaseNode)InjectRubyArrayObjectRubyProc1Node.create0(this);
                        }
                        if (ArrayGuards.isFloat(arguments0ValueCast)) {
                            return (InjectBaseNode)InjectRubyArrayObjectRubyProc2Node.create0(this);
                        }
                        if (ArrayGuards.isObject(arguments0ValueCast)) {
                            return (InjectBaseNode)InjectRubyArrayObjectRubyProc3Node.create0(this);
                        }
                        if (ArrayGuards.isNullArray(arguments0ValueCast)) {
                            return (InjectBaseNode)InjectRubyArrayObjectRubyProc4Node.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (InjectBaseNode)InjectRubyArrayRubySymbolUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InjectBaseNode otherCast = (InjectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InjectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<ArrayNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(ArrayNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode from) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, self, from);
        }

        public static NodeFactory<ArrayNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> selfPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> fromPolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object selfValue = this.self.execute(frameValue);
                Object fromValue = this.from.execute(frameValue);
                return this.next0.executeChained0(frameValue, selfValue, fromValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.selfPolymorphicType = types[0];
                this.fromPolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                return this.next0.executeChained0(frameValue, selfValue, fromValue);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray4Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray4Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray fromValue;
                RubyArray selfValue;
                try {
                    selfValue = this.self.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object fromValue2 = this.from.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), fromValue2, "Expected selfValue instanceof RubyArray");
                }
                try {
                    fromValue = this.from.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, selfValue, ex.getResult(), "Expected fromValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherObject(selfValue, fromValue)) {
                    return super.initializeCopyObject(selfValue, fromValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, selfValue, fromValue, "One of guards [isOtherObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                RubyArray fromValueCast;
                RubyArray selfValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(selfValue) && RubyTypesGen.RUBYTYPES.isRubyArray(fromValue) && ArrayGuards.isOtherObject(selfValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(selfValue), fromValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(fromValue))) {
                    return super.initializeCopyObject(selfValueCast, fromValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, fromValue);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyArray4Node((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray3Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray3Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray fromValue;
                RubyArray selfValue;
                try {
                    selfValue = this.self.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object fromValue2 = this.from.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), fromValue2, "Expected selfValue instanceof RubyArray");
                }
                try {
                    fromValue = this.from.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, selfValue, ex.getResult(), "Expected fromValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherFloat(selfValue, fromValue)) {
                    return super.initializeCopyFloat(selfValue, fromValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, selfValue, fromValue, "One of guards [isOtherFloat] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                RubyArray fromValueCast;
                RubyArray selfValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(selfValue) && RubyTypesGen.RUBYTYPES.isRubyArray(fromValue) && ArrayGuards.isOtherFloat(selfValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(selfValue), fromValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(fromValue))) {
                    return super.initializeCopyFloat(selfValueCast, fromValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, fromValue);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyArray3Node((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray2Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray2Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray fromValue;
                RubyArray selfValue;
                try {
                    selfValue = this.self.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object fromValue2 = this.from.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), fromValue2, "Expected selfValue instanceof RubyArray");
                }
                try {
                    fromValue = this.from.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, selfValue, ex.getResult(), "Expected fromValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherLongFixnum(selfValue, fromValue)) {
                    return super.initializeCopyLongFixnum(selfValue, fromValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, selfValue, fromValue, "One of guards [isOtherLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                RubyArray fromValueCast;
                RubyArray selfValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(selfValue) && RubyTypesGen.RUBYTYPES.isRubyArray(fromValue) && ArrayGuards.isOtherLongFixnum(selfValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(selfValue), fromValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(fromValue))) {
                    return super.initializeCopyLongFixnum(selfValueCast, fromValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, fromValue);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyArray2Node((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray1Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray1Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray fromValue;
                RubyArray selfValue;
                try {
                    selfValue = this.self.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object fromValue2 = this.from.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), fromValue2, "Expected selfValue instanceof RubyArray");
                }
                try {
                    fromValue = this.from.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, selfValue, ex.getResult(), "Expected fromValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherIntegerFixnum(selfValue, fromValue)) {
                    return super.initializeCopyIntegerFixnum(selfValue, fromValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, selfValue, fromValue, "One of guards [isOtherIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                RubyArray fromValueCast;
                RubyArray selfValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(selfValue) && RubyTypesGen.RUBYTYPES.isRubyArray(fromValue) && ArrayGuards.isOtherIntegerFixnum(selfValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(selfValue), fromValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(fromValue))) {
                    return super.initializeCopyIntegerFixnum(selfValueCast, fromValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, fromValue);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyArray1Node((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray0Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray0Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray fromValue;
                RubyArray selfValue;
                try {
                    selfValue = this.self.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object fromValue2 = this.from.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), fromValue2, "Expected selfValue instanceof RubyArray");
                }
                try {
                    fromValue = this.from.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, selfValue, ex.getResult(), "Expected fromValue instanceof RubyArray");
                }
                if (ArrayGuards.isOtherNull(selfValue, fromValue)) {
                    return super.initializeCopyNull(selfValue, fromValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, selfValue, fromValue, "One of guards [isOtherNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                RubyArray fromValueCast;
                RubyArray selfValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(selfValue) && RubyTypesGen.RUBYTYPES.isRubyArray(fromValue) && ArrayGuards.isOtherNull(selfValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(selfValue), fromValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(fromValue))) {
                    return super.initializeCopyNull(selfValueCast, fromValueCast);
                }
                return this.next0.executeChained0(frameValue, selfValue, fromValue);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current) {
                return new InitializeCopyRubyArray0Node((InitializeCopyBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode from) {
                super(context, sourceSection, self, from);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object selfValue = this.self.execute(frameValue);
                Object fromValue = this.from.execute(frameValue);
                return this.executeUninitialized0(frameValue, selfValue, fromValue);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, selfValue, fromValue);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object selfValue, Object fromValue) {
                InitializeCopyBaseNode newNode = this.specialize0(selfValue, fromValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = (InitializeCopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.self, rootNode.from}, new Object[]{selfValue, fromValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeCopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, selfValue, fromValue);
            }

            static ArrayNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode from) {
                return new InitializeCopyUninitializedNode(context, sourceSection, self, from);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends ArrayNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Child
            protected RubyNode self;
            @Node.Child
            protected RubyNode from;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode self, RubyNode from) {
                super(context, sourceSection);
                this.self = self;
                this.from = super.coerceOtherToAry(from);
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object selfValue, Object fromValue, String reason) {
                String message;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(selfValue, fromValue);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeCopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeCopyBaseNode.createInfo0(reason, selfValue, fromValue)))) == null) {
                    returnNode = (InitializeCopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeCopyUninitializedNode(this), (Node)new InitializeCopyPolymorphicNode(this), (DSLNode)((InitializeCopyBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, selfValue, fromValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object selfValue, Object fromValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(selfValue) && RubyTypesGen.RUBYTYPES.isRubyArray(fromValue)) {
                    RubyArray fromValueCast;
                    RubyArray selfValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(selfValue);
                    if (ArrayGuards.isOtherNull(selfValueCast, fromValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(fromValue))) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isOtherIntegerFixnum(selfValueCast, fromValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isOtherLongFixnum(selfValueCast, fromValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isOtherFloat(selfValueCast, fromValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isOtherObject(selfValueCast, fromValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.self = null;
                    this.from = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.self = otherCast.self;
                    this.from = otherCast.from;
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object selfValue, Object fromValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("selfValue").append(" = ").append(selfValue);
                    if (selfValue != null) {
                        builder.append(" (").append(selfValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("fromValue").append(" = ").append(fromValue);
                    if (fromValue != null) {
                        builder.append(" (").append(fromValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<ArrayNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(ArrayNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments3Value;
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyArray.class ? this.arguments[1].executeArray(frameValue) : this.arguments[1].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, arguments3Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : (this.arguments2PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[2].executeLongFixnum(frameValue)) : (this.arguments2PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[2].executeFloat(frameValue)) : this.arguments[2].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value3);
                }
                try {
                    arguments3Value = this.arguments3PolymorphicType == UndefinedPlaceholder.class ? this.arguments[3].executeUndefinedPlaceholder(frameValue) : (this.arguments3PolymorphicType == RubyProc.class ? this.arguments[3].executeRubyProc(frameValue) : this.arguments[3].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments3PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayRubyArrayUndefinedPlaceholderRubyProcNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayRubyArrayUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            InitializeRubyArrayRubyArrayUndefinedPlaceholderRubyProcNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyArray"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc"));
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyArray arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayRubyArrayUndefinedPlaceholderRubyProcNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyArray"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyArray arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeObjectIntUndefinedPlaceholderRubyProc1Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeObjectIntUndefinedPlaceholderRubyProc1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            InitializeObjectIntUndefinedPlaceholderRubyProc1Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments3Value;
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                if (ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initializeNegative(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isNegative] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    if (ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initializeNegative(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeObjectIntUndefinedPlaceholderRubyProc1Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeObjectIntUndefinedPlaceholderRubyProc0Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeObjectIntUndefinedPlaceholderRubyProc0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            InitializeObjectIntUndefinedPlaceholderRubyProc0Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments3Value;
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                if (!ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initialize(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isNegative] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initialize(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeObjectIntUndefinedPlaceholderRubyProc0Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeObjectIntObjectRubyProc1Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeObjectIntObjectRubyProc1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class, RubyProc.class}, 0, 0);

            InitializeObjectIntObjectRubyProc1Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments3Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                if (!super.isUndefinedPlaceholder(arguments2Value) && ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initializeNegative(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isUndefinedPlaceholder, isNegative] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value) && !super.isUndefinedPlaceholder(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    if (ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initializeNegative(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2Value, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeObjectIntObjectRubyProc1Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeObjectIntObjectRubyProc0Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeObjectIntObjectRubyProc0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class, RubyProc.class}, 0, 0);

            InitializeObjectIntObjectRubyProc0Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments3Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                if (!super.isUndefinedPlaceholder(arguments2Value) && !ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initialize(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isUndefinedPlaceholder, !isNegative] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value) && !super.isUndefinedPlaceholder(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initialize(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2Value, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeObjectIntObjectRubyProc0Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayObjectObjectUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayObjectObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class, Object.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayObjectObjectUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (!super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments2Value)) {
                    return super.initialize(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isInteger, !isUndefinedPlaceholder] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && !super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(frameValue, arguments0ValueCast, arguments1Value, arguments2Value, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayObjectObjectUndefinedPlaceholderNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntObjectUndefinedPlaceholder1Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntObjectUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntObjectUndefinedPlaceholder1Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (!super.isUndefinedPlaceholder(arguments2Value) && ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initializeNegative(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isUndefinedPlaceholder, isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && !super.isUndefinedPlaceholder(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initializeNegative(arguments0ValueCast, arguments1ValueCast, arguments2Value, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntObjectUndefinedPlaceholder1Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntObjectUndefinedPlaceholder0Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntObjectUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntObjectUndefinedPlaceholder0Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (!super.isUndefinedPlaceholder(arguments2Value) && !ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isUndefinedPlaceholder, !isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && !super.isUndefinedPlaceholder(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2Value, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntObjectUndefinedPlaceholder0Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntDoubleUndefinedPlaceholder1Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntDoubleUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Double.TYPE, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntDoubleUndefinedPlaceholder1Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                double arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof double"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initializeNegative(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    double arguments2ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initializeNegative(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntDoubleUndefinedPlaceholder1Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntDoubleUndefinedPlaceholder0Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntDoubleUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Double.TYPE, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntDoubleUndefinedPlaceholder0Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                double arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof double"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (!ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    double arguments2ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntDoubleUndefinedPlaceholder0Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntLongUndefinedPlaceholder1Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntLongUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntLongUndefinedPlaceholder1Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                long arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof long"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initializeNegative(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isLong(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    long arguments2ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initializeNegative(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntLongUndefinedPlaceholder1Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntLongUndefinedPlaceholder0Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntLongUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntLongUndefinedPlaceholder0Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                long arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof long"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (!ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isLong(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    long arguments2ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntLongUndefinedPlaceholder0Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntIntUndefinedPlaceholder1Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntIntUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntIntUndefinedPlaceholder1Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof int"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initializeNegative(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initializeNegative(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntIntUndefinedPlaceholder1Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntIntUndefinedPlaceholder0Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntIntUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntIntUndefinedPlaceholder0Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof int"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (!ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntIntUndefinedPlaceholder0Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder1Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Long.TYPE, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder1Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                long arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof long"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initializeNegative(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initializeNegative(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder1Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder0Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Long.TYPE, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder0Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                long arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof long"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (!ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder0Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder1Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder1Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initializeNegative(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initializeNegative(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder1Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder0Node
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder0Node(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (!ArrayGuards.isNegative(arguments0Value, arguments1Value)) {
                    return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isNegative] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                        return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder0Node((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderRubyProcNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderRubyProcNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc"));
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderRubyProcNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayObjectUndefinedPlaceholderUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayObjectUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayObjectUndefinedPlaceholderUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value3, "Expected arguments2Value instanceof UndefinedPlaceholder"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isUndefinedPlaceholder(arguments1Value) || super.isRubyArray(arguments1Value))) {
                    return super.initialize(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [!isInteger, !isLong, !isUndefinedPlaceholder, !isRubyArray] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && !super.isInteger(arguments1Value) && !super.isLong(arguments1Value) && !super.isUndefinedPlaceholder(arguments1Value) && !super.isRubyArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current) {
                return new InitializeRubyArrayObjectUndefinedPlaceholderUndefinedPlaceholderNode((InitializeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = (InitializeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3]}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends ArrayNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, String reason) {
                String message;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = InitializeBaseNode.createInfo0(reason, arguments0Value, arguments1Value, arguments2Value, arguments3Value)))) == null) {
                    returnNode = (InitializeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeUninitializedNode(this), (Node)new InitializePolymorphicNode(this), (DSLNode)((InitializeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    int arguments1ValueCast;
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            if (!(super.isInteger(arguments1Value) || super.isLong(arguments1Value) || super.isUndefinedPlaceholder(arguments1Value) || super.isRubyArray(arguments1Value))) {
                                return (InitializeBaseNode)InitializeRubyArrayObjectUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                                return (InitializeBaseNode)InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                            return (InitializeBaseNode)InitializeRubyArrayUndefinedPlaceholderUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                                int arguments1ValueCast2 = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                                if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast2)) {
                                    return (InitializeBaseNode)InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder0Node.create0(this);
                                }
                                return (InitializeBaseNode)InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholder1Node.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                                long arguments1ValueCast3 = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                                if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast3)) {
                                    return (InitializeBaseNode)InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder0Node.create0(this);
                                }
                                return (InitializeBaseNode)InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholder1Node.create0(this);
                            }
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                            arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                            if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                                if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                                    return (InitializeBaseNode)InitializeRubyArrayIntIntUndefinedPlaceholder0Node.create0(this);
                                }
                                return (InitializeBaseNode)InitializeRubyArrayIntIntUndefinedPlaceholder1Node.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isLong(arguments2Value)) {
                                if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                                    return (InitializeBaseNode)InitializeRubyArrayIntLongUndefinedPlaceholder0Node.create0(this);
                                }
                                return (InitializeBaseNode)InitializeRubyArrayIntLongUndefinedPlaceholder1Node.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isDouble(arguments2Value)) {
                                if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                                    return (InitializeBaseNode)InitializeRubyArrayIntDoubleUndefinedPlaceholder0Node.create0(this);
                                }
                                return (InitializeBaseNode)InitializeRubyArrayIntDoubleUndefinedPlaceholder1Node.create0(this);
                            }
                            if (!super.isUndefinedPlaceholder(arguments2Value)) {
                                if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                                    return (InitializeBaseNode)InitializeRubyArrayIntObjectUndefinedPlaceholder0Node.create0(this);
                                }
                                return (InitializeBaseNode)InitializeRubyArrayIntObjectUndefinedPlaceholder1Node.create0(this);
                            }
                        }
                        if (!super.isInteger(arguments1Value) && !super.isUndefinedPlaceholder(arguments2Value)) {
                            return (InitializeBaseNode)InitializeRubyArrayObjectObjectUndefinedPlaceholderNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                        arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                        if (!super.isUndefinedPlaceholder(arguments2Value)) {
                            if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                                return (InitializeBaseNode)InitializeObjectIntObjectRubyProc0Node.create0(this);
                            }
                            return (InitializeBaseNode)InitializeObjectIntObjectRubyProc1Node.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            if (!ArrayGuards.isNegative(arguments0ValueCast, arguments1ValueCast)) {
                                return (InitializeBaseNode)InitializeObjectIntUndefinedPlaceholderRubyProc0Node.create0(this);
                            }
                            return (InitializeBaseNode)InitializeObjectIntUndefinedPlaceholderRubyProc1Node.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            return (InitializeBaseNode)InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                            return (InitializeBaseNode)InitializeRubyArrayRubyArrayUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IncludeNode.class)
    public static final class IncludeNodeFactory
    extends NodeFactoryBase<ArrayNodes.IncludeNode> {
        private static IncludeNodeFactory includeNodeFactoryInstance;

        private IncludeNodeFactory() {
            super(ArrayNodes.IncludeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.IncludeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.IncludeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IncludeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.IncludeNode> getInstance() {
            if (includeNodeFactoryInstance == null) {
                includeNodeFactoryInstance = new IncludeNodeFactory();
            }
            return includeNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IncludePolymorphicNode
        extends IncludeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IncludePolymorphicNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyArray4Node
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            IncludeRubyArray4Node(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.includeObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.includeObject(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(ArrayNodes.IncludeNode current) {
                return new IncludeRubyArray4Node((IncludeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyArray3Node
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            IncludeRubyArray3Node(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.includeFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.includeFloat(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(ArrayNodes.IncludeNode current) {
                return new IncludeRubyArray3Node((IncludeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyArray2Node
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            IncludeRubyArray2Node(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.includeLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.includeLongFixnum(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(ArrayNodes.IncludeNode current) {
                return new IncludeRubyArray2Node((IncludeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyArray1Node
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            IncludeRubyArray1Node(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.includeIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.includeIntegerFixnum(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(ArrayNodes.IncludeNode current) {
                return new IncludeRubyArray1Node((IncludeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyArray0Node
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            IncludeRubyArray0Node(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.includeNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.includeNull(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(ArrayNodes.IncludeNode current) {
                return new IncludeRubyArray0Node((IncludeBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IncludeUninitializedNode
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IncludeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IncludeUninitializedNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value;
                try {
                    value = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IncludeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IncludeBaseNode rootNode = (IncludeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IncludeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IncludeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        private static abstract class IncludeBaseNode
        extends ArrayNodes.IncludeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IncludeBaseNode next0;

            IncludeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IncludeBaseNode(IncludeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                IncludeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IncludeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IncludeUninitializedNode(this);
                    ((IncludeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IncludeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = IncludeBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (IncludeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IncludeUninitializedNode(this), (Node)new IncludePolymorphicNode(this), (DSLNode)((IncludeBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IncludeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (IncludeBaseNode)IncludeRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (IncludeBaseNode)IncludeRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return (IncludeBaseNode)IncludeRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return (IncludeBaseNode)IncludeRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (IncludeBaseNode)IncludeRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IncludeBaseNode otherCast = (IncludeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IncludeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
    public static final class EachWithIndexNodeFactory
    extends NodeFactoryBase<ArrayNodes.EachWithIndexNode> {
        private static EachWithIndexNodeFactory eachWithIndexNodeFactoryInstance;

        private EachWithIndexNodeFactory() {
            super(ArrayNodes.EachWithIndexNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.EachWithIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachWithIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.EachWithIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachWithIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.EachWithIndexNode> getInstance() {
            if (eachWithIndexNodeFactoryInstance == null) {
                eachWithIndexNodeFactoryInstance = new EachWithIndexNodeFactory();
            }
            return eachWithIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachWithIndexPolymorphicNode
        extends EachWithIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachWithIndexPolymorphicNode(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyProc.class ? this.arguments[1].executeRubyProc(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachWithIndexObjectUndefinedPlaceholderNode
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            EachWithIndexObjectUndefinedPlaceholderNode(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.eachWithIndexObject(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.eachWithIndexObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(ArrayNodes.EachWithIndexNode current) {
                return new EachWithIndexObjectUndefinedPlaceholderNode((EachWithIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachWithIndexObjectRubyProc3Node
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexObjectRubyProc3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachWithIndexObjectRubyProc3Node(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.eachWithIndexObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.eachWithIndexObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(ArrayNodes.EachWithIndexNode current) {
                return new EachWithIndexObjectRubyProc3Node((EachWithIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachWithIndexObjectRubyProc2Node
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexObjectRubyProc2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachWithIndexObjectRubyProc2Node(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.eachWithIndexDouble(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.eachWithIndexDouble(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(ArrayNodes.EachWithIndexNode current) {
                return new EachWithIndexObjectRubyProc2Node((EachWithIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachWithIndexObjectRubyProc1Node
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexObjectRubyProc1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachWithIndexObjectRubyProc1Node(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.eachWithIndexLong(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.eachWithIndexLong(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(ArrayNodes.EachWithIndexNode current) {
                return new EachWithIndexObjectRubyProc1Node((EachWithIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachWithIndexObjectRubyProc0Node
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexObjectRubyProc0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachWithIndexObjectRubyProc0Node(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.eachWithIndexInt(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.eachWithIndexInt(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(ArrayNodes.EachWithIndexNode current) {
                return new EachWithIndexObjectRubyProc0Node((EachWithIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachWithIndexRubyArrayRubyProcNode
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexRubyArrayRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachWithIndexRubyArrayRubyProcNode(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc"));
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.eachWithEmpty(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.eachWithEmpty(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(ArrayNodes.EachWithIndexNode current) {
                return new EachWithIndexRubyArrayRubyProcNode((EachWithIndexBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachWithIndexUninitializedNode
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachWithIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachWithIndexUninitializedNode(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachWithIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachWithIndexBaseNode rootNode = (EachWithIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachWithIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachWithIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        private static abstract class EachWithIndexBaseNode
        extends ArrayNodes.EachWithIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachWithIndexBaseNode next0;

            EachWithIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachWithIndexBaseNode(EachWithIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EachWithIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachWithIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachWithIndexUninitializedNode(this);
                    ((EachWithIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachWithIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EachWithIndexBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachWithIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachWithIndexUninitializedNode(this), (Node)new EachWithIndexPolymorphicNode(this), (DSLNode)((EachWithIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachWithIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                        if (ArrayGuards.isNull(arguments0ValueCast)) {
                            return (EachWithIndexBaseNode)EachWithIndexRubyArrayRubyProcNode.create0(this);
                        }
                        if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                            return (EachWithIndexBaseNode)EachWithIndexObjectRubyProc0Node.create0(this);
                        }
                        if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                            return (EachWithIndexBaseNode)EachWithIndexObjectRubyProc1Node.create0(this);
                        }
                        if (ArrayGuards.isFloat(arguments0ValueCast)) {
                            return (EachWithIndexBaseNode)EachWithIndexObjectRubyProc2Node.create0(this);
                        }
                        if (ArrayGuards.isObject(arguments0ValueCast)) {
                            return (EachWithIndexBaseNode)EachWithIndexObjectRubyProc3Node.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (EachWithIndexBaseNode)EachWithIndexObjectUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachWithIndexBaseNode otherCast = (EachWithIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachWithIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<ArrayNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(ArrayNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachPolymorphicNode
        extends EachBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachPolymorphicNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyProc.class ? this.arguments[1].executeRubyProc(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArrayRubyProc4Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArrayRubyProc4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArrayRubyProc4Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.eachObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.eachObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current) {
                return new EachRubyArrayRubyProc4Node((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArrayRubyProc3Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArrayRubyProc3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArrayRubyProc3Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.eachFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.eachFloat(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current) {
                return new EachRubyArrayRubyProc3Node((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArrayRubyProc2Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArrayRubyProc2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArrayRubyProc2Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.eachLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.eachLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current) {
                return new EachRubyArrayRubyProc2Node((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArrayRubyProc1Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArrayRubyProc1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArrayRubyProc1Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.eachIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.eachIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current) {
                return new EachRubyArrayRubyProc1Node((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArrayRubyProc0Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArrayRubyProc0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArrayRubyProc0Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.eachNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.eachNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current) {
                return new EachRubyArrayRubyProc0Node((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArrayUndefinedPlaceholderNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArrayUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            EachRubyArrayUndefinedPlaceholderNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.eachEnumerator(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.eachEnumerator(frameValue, arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current) {
                return new EachRubyArrayUndefinedPlaceholderNode((EachBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachUninitializedNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachUninitializedNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachBaseNode rootNode = (EachBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        private static abstract class EachBaseNode
        extends ArrayNodes.EachNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachBaseNode next0;

            EachBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachBaseNode(EachBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                EachBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachUninitializedNode(this);
                    ((EachUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = EachBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachUninitializedNode(this), (Node)new EachPolymorphicNode(this), (DSLNode)((EachBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (EachBaseNode)EachRubyArrayUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                        if (ArrayGuards.isNull(arguments0ValueCast)) {
                            return (EachBaseNode)EachRubyArrayRubyProc0Node.create0(this);
                        }
                        if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                            return (EachBaseNode)EachRubyArrayRubyProc1Node.create0(this);
                        }
                        if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                            return (EachBaseNode)EachRubyArrayRubyProc2Node.create0(this);
                        }
                        if (ArrayGuards.isFloat(arguments0ValueCast)) {
                            return (EachBaseNode)EachRubyArrayRubyProc3Node.create0(this);
                        }
                        if (ArrayGuards.isObject(arguments0ValueCast)) {
                            return (EachBaseNode)EachRubyArrayRubyProc4Node.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachBaseNode otherCast = (EachBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
    public static final class DeleteAtNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteAtNode> {
        private static DeleteAtNodeFactory deleteAtNodeFactoryInstance;

        private DeleteAtNodeFactory() {
            super(ArrayNodes.DeleteAtNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.DeleteAtNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return DeleteAtNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.DeleteAtNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
            return DeleteAtUninitializedNode.create0(context, sourceSection, array, index);
        }

        public static NodeFactory<ArrayNodes.DeleteAtNode> getInstance() {
            if (deleteAtNodeFactoryInstance == null) {
                deleteAtNodeFactoryInstance = new DeleteAtNodeFactory();
            }
            return deleteAtNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DeleteAtPolymorphicNode
        extends DeleteAtBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arrayPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> indexPolymorphicType;

            DeleteAtPolymorphicNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arrayValue = this.array.execute(frameValue);
                Object indexValue = this.index.execute(frameValue);
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arrayPolymorphicType = types[0];
                this.indexPolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtObjectInt5Node
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtObjectInt5Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtObjectInt5Node(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int indexValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int");
                }
                if (ArrayGuards.isNullOrEmpty(arrayValue)) {
                    return super.deleteAtNullOrEmpty(arrayValue, indexValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isNullOrEmpty] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    if (ArrayGuards.isNullOrEmpty(arrayValueCast)) {
                        return super.deleteAtNullOrEmpty(arrayValueCast, indexValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current) {
                return new DeleteAtObjectInt5Node((DeleteAtBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtObjectInt4Node
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtObjectInt4Node.class, new Class[]{DeleteAtObjectInt3Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtObjectInt4Node(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int indexValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int");
                }
                if (ArrayGuards.isObject(arrayValue)) {
                    return super.deleteAtObject(arrayValue, indexValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    if (ArrayGuards.isObject(arrayValueCast)) {
                        return super.deleteAtObject(arrayValueCast, indexValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current) {
                return new DeleteAtObjectInt4Node((DeleteAtBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtObjectInt3Node
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtObjectInt3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{DeleteAtObjectInt4Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtObjectInt3Node(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int indexValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int");
                }
                if (ArrayGuards.isObject(arrayValue)) {
                    try {
                        return super.deleteAtObjectInBounds(arrayValue, indexValue);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arrayValue, indexValue, "Thrown UnexpectedResultException");
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    if (ArrayGuards.isObject(arrayValueCast)) {
                        try {
                            return super.deleteAtObjectInBounds(arrayValueCast, indexValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arrayValue, indexValue, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current) {
                return new DeleteAtObjectInt3Node((DeleteAtBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtObjectInt2Node
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtObjectInt2Node.class, new Class[]{DeleteAtDoubleIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtObjectInt2Node(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int indexValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int");
                }
                if (ArrayGuards.isFloat(arrayValue)) {
                    return super.deleteAtFloat(arrayValue, indexValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    if (ArrayGuards.isFloat(arrayValueCast)) {
                        return super.deleteAtFloat(arrayValueCast, indexValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current) {
                return new DeleteAtObjectInt2Node((DeleteAtBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtDoubleIntNode
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{DeleteAtObjectInt2Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtDoubleIntNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value;
                try {
                    value = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int indexValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray"));
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int"));
                }
                if (ArrayGuards.isFloat(arrayValue)) {
                    try {
                        return super.deleteAtFloatInBounds(arrayValue, indexValue);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, indexValue, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isFloat] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    if (ArrayGuards.isFloat(arrayValueCast)) {
                        try {
                            return super.deleteAtFloatInBounds(arrayValueCast, indexValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arrayValue, indexValue, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current) {
                return new DeleteAtDoubleIntNode((DeleteAtBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtObjectInt1Node
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtObjectInt1Node.class, new Class[]{DeleteAtLongIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtObjectInt1Node(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int indexValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int");
                }
                if (ArrayGuards.isLongFixnum(arrayValue)) {
                    return super.deleteAtLongFixnum(arrayValue, indexValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    if (ArrayGuards.isLongFixnum(arrayValueCast)) {
                        return super.deleteAtLongFixnum(arrayValueCast, indexValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current) {
                return new DeleteAtObjectInt1Node((DeleteAtBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtLongIntNode
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{DeleteAtObjectInt1Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtLongIntNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value;
                try {
                    value = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int indexValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray"));
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int"));
                }
                if (ArrayGuards.isLongFixnum(arrayValue)) {
                    try {
                        return super.deleteAtLongFixnumInBounds(arrayValue, indexValue);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isLongFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    if (ArrayGuards.isLongFixnum(arrayValueCast)) {
                        try {
                            return super.deleteAtLongFixnumInBounds(arrayValueCast, indexValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arrayValue, indexValue, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current) {
                return new DeleteAtLongIntNode((DeleteAtBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtObjectInt0Node
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtObjectInt0Node.class, new Class[]{DeleteAtIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtObjectInt0Node(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int indexValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arrayValue)) {
                    return super.deleteAtIntegerFixnum(arrayValue, indexValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    if (ArrayGuards.isIntegerFixnum(arrayValueCast)) {
                        return super.deleteAtIntegerFixnum(arrayValueCast, indexValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current) {
                return new DeleteAtObjectInt0Node((DeleteAtBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtIntNode
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{DeleteAtObjectInt0Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtIntNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value;
                try {
                    value = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int indexValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object indexValue2 = this.index.execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray"));
                }
                try {
                    indexValue = this.index.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int"));
                }
                if (ArrayGuards.isIntegerFixnum(arrayValue)) {
                    try {
                        return super.deleteAtIntegerFixnumInBounds(arrayValue, indexValue);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                    if (ArrayGuards.isIntegerFixnum(arrayValueCast)) {
                        try {
                            return super.deleteAtIntegerFixnumInBounds(arrayValueCast, indexValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arrayValue, indexValue, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current) {
                return new DeleteAtIntNode((DeleteAtBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DeleteAtUninitializedNode
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DeleteAtUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
                super(context, sourceSection, array, index);
            }

            DeleteAtUninitializedNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arrayValue = this.array.execute(frameValue);
                Object indexValue = this.index.execute(frameValue);
                return this.executeUninitialized0(frameValue, arrayValue, indexValue);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arrayValue, indexValue);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
                DeleteAtBaseNode newNode = this.specialize0(arrayValue, indexValue);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DeleteAtBaseNode rootNode = (DeleteAtBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.index}, new Object[]{arrayValue, indexValue});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DeleteAtBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, indexValue);
            }

            static ArrayNodes.DeleteAtNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
                return new DeleteAtUninitializedNode(context, sourceSection, array, index);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        private static abstract class DeleteAtBaseNode
        extends ArrayNodes.DeleteAtNode
        implements DSLNode {
            @Node.Child
            protected RubyNode array;
            @Node.Child
            protected RubyNode index;
            @Node.Child
            protected DeleteAtBaseNode next0;

            DeleteAtBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
                super(context, sourceSection);
                this.array = array;
                this.index = super.coerceOtherToInt(index);
            }

            DeleteAtBaseNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arrayValue, Object indexValue, String reason) {
                String message;
                DeleteAtBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DeleteAtBaseNode newNode = this.specialize0(arrayValue, indexValue);
                if (newNode == null) {
                    newNode = new DeleteAtUninitializedNode(this);
                    ((DeleteAtUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DeleteAtBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DeleteAtBaseNode.createInfo0(reason, arrayValue, indexValue)))) == null) {
                    returnNode = (DeleteAtBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DeleteAtUninitializedNode(this), (Node)new DeleteAtPolymorphicNode(this), (DSLNode)((DeleteAtBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arrayValue, indexValue);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DeleteAtBaseNode specialize0(Object arrayValue, Object indexValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    if (ArrayGuards.isIntegerFixnum(arrayValueCast)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)DeleteAtIntNode.METADATA)) {
                            return (DeleteAtBaseNode)DeleteAtIntNode.create0(this);
                        }
                        return (DeleteAtBaseNode)DeleteAtObjectInt0Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arrayValueCast)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)DeleteAtLongIntNode.METADATA)) {
                            return (DeleteAtBaseNode)DeleteAtLongIntNode.create0(this);
                        }
                        return (DeleteAtBaseNode)DeleteAtObjectInt1Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arrayValueCast)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)DeleteAtDoubleIntNode.METADATA)) {
                            return (DeleteAtBaseNode)DeleteAtDoubleIntNode.create0(this);
                        }
                        return (DeleteAtBaseNode)DeleteAtObjectInt2Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arrayValueCast)) {
                        if (!DSLShare.isExcluded((Node)this, (DSLMetadata)DeleteAtObjectInt3Node.METADATA)) {
                            return (DeleteAtBaseNode)DeleteAtObjectInt3Node.create0(this);
                        }
                        return (DeleteAtBaseNode)DeleteAtObjectInt4Node.create0(this);
                    }
                    if (ArrayGuards.isNullOrEmpty(arrayValueCast)) {
                        return (DeleteAtBaseNode)DeleteAtObjectInt5Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.array = null;
                    this.index = null;
                } else {
                    DeleteAtBaseNode otherCast = (DeleteAtBaseNode)other;
                    this.array = otherCast.array;
                    this.index = otherCast.index;
                }
                this.next0 = newNext == null ? null : (DeleteAtBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arrayValue, Object indexValue) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arrayValue").append(" = ").append(arrayValue);
                    if (arrayValue != null) {
                        builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("indexValue").append(" = ").append(indexValue);
                    if (indexValue != null) {
                        builder.append(" (").append(indexValue.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteNode> {
        private static DeleteNodeFactory deleteNodeFactoryInstance;

        private DeleteNodeFactory() {
            super(ArrayNodes.DeleteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.DeleteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.DeleteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DeleteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.DeleteNode> getInstance() {
            if (deleteNodeFactoryInstance == null) {
                deleteNodeFactoryInstance = new DeleteNodeFactory();
            }
            return deleteNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DeletePolymorphicNode
        extends DeleteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DeletePolymorphicNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyArray2Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            DeleteRubyArray2Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isNullArray(arguments0Value)) {
                    return super.deleteNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNullArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isNullArray(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.deleteNull(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteNode create0(ArrayNodes.DeleteNode current) {
                return new DeleteRubyArray2Node((DeleteBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyArray1Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            DeleteRubyArray1Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.deleteObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.deleteObject(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteNode create0(ArrayNodes.DeleteNode current) {
                return new DeleteRubyArray1Node((DeleteBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyArray0Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            DeleteRubyArray0Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.deleteIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.deleteIntegerFixnum(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteNode create0(ArrayNodes.DeleteNode current) {
                return new DeleteRubyArray0Node((DeleteBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DeleteUninitializedNode
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DeleteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DeleteUninitializedNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DeleteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DeleteBaseNode rootNode = (DeleteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DeleteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DeleteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        private static abstract class DeleteBaseNode
        extends ArrayNodes.DeleteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DeleteBaseNode next0;

            DeleteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DeleteBaseNode(DeleteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason) {
                String message;
                DeleteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DeleteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DeleteUninitializedNode(this);
                    ((DeleteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DeleteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = DeleteBaseNode.createInfo0(reason, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DeleteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DeleteUninitializedNode(this), (Node)new DeletePolymorphicNode(this), (DSLNode)((DeleteBaseNode)this.copy()), (DSLNode)newNode, (String)message);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DeleteBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isNullArray(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteRubyArray2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DeleteBaseNode otherCast = (DeleteBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DeleteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ConcatNode.class)
    public static final class ConcatNodeFactory
    extends NodeFactoryBase<ArrayNodes.ConcatNode> {
        private static ConcatNodeFactory concatNodeFactoryInstance;

        private ConcatNodeFactory() {
            super(ArrayNodes.ConcatNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        public ArrayNodes.ConcatNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ConcatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ConcatNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode other) {
            return ConcatUninitializedNode.create0(context, sourceSection, array, other);
        }

        public static NodeFactory<ArrayNodes.ConcatNode> getInstance() {
            if (concatNodeFactoryInstance == null) {
                concatNodeFactoryInstance = new ConcatNodeFactory();
            }
            return concatNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConcatPolymorphicNode
        extends ConcatBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arrayPolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> otherPolymorphicType;

            ConcatPolymorphicNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arrayValue = this.array.execute(frameValue);
                Object otherValue = this.other.execute(frameValue);
                return this.next0.executeChained0(arrayValue, otherValue);
            }

            @Override
            public RubyArray executeConcat(RubyArray arrayValueEvaluated, RubyArray otherValueEvaluated) {
                RubyArray arrayValue = arrayValueEvaluated;
                RubyArray otherValue = otherValueEvaluated;
                return this.next0.executeChained0(arrayValue, otherValue);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arrayPolymorphicType = types[0];
                this.otherPolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(Object arrayValue, Object otherValue) {
                return this.next0.executeChained0(arrayValue, otherValue);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyArray5Node
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyArray5Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ConcatRubyArray5Node(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray otherValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(ex.getResult(), otherValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    otherValue = this.other.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(arrayValue, ex.getResult(), "Expected otherValue instanceof RubyArray");
                }
                return super.concat(arrayValue, otherValue);
            }

            @Override
            public RubyArray executeConcat(RubyArray arrayValueEvaluated, RubyArray otherValueEvaluated) {
                RubyArray arrayValue = arrayValueEvaluated;
                RubyArray otherValue = otherValueEvaluated;
                return super.concat(arrayValue, otherValue);
            }

            @Override
            protected RubyArray executeChained0(Object arrayValue, Object otherValue) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isRubyArray(otherValue)) {
                    RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                    RubyArray otherValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(otherValue);
                    return super.concat(arrayValueCast, otherValueCast);
                }
                return this.next0.executeChained0(arrayValue, otherValue);
            }

            static ArrayNodes.ConcatNode create0(ArrayNodes.ConcatNode current) {
                return new ConcatRubyArray5Node((ConcatBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyArray4Node
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ConcatRubyArray4Node(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray otherValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.array.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object otherValue2 = this.other.execute(frameValue);
                    return this.rewrite0(ex.getResult(), otherValue2, "Expected arrayValue instanceof RubyArray");
                }
                try {
                    otherValue = this.other.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(arrayValue, ex.getResult(), "Expected otherValue instanceof RubyArray");
                }
                if (ArrayGuards.areBothObject(arrayValue, otherValue)) {
                    return super.concatObject(arrayValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(arrayValue, otherValue, "One of guards [areBothObject] failed");
            }

            @Override
            public RubyArray executeConcat(RubyArray arrayValueEvaluated, RubyArray otherValueEvaluated) {
                RubyArray arrayValue = arrayValueEvaluated;
                RubyArray otherValue = otherValueEvaluated;
                if (ArrayGuards.areBothObject(arrayValue, otherValue)) {
                    return super.concatObject(arrayValue, otherValue);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(arrayValue, otherValue, "One of guards [areBothObject] failed");
            }

            @Override
            protected RubyArray executeChained0(Object arrayValue, Object otherValue) {
                RubyArray otherValueCast;
                RubyArray arrayValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isRubyArray(otherValue) && ArrayGuards.areBothObject(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), otherValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(otherValue))) {
                    return super.concatObject(arrayValueCast, otherValueCast);
                }
                return this.next0.executeChained0(arrayValue, otherValue);
            }

            static ArrayNodes.ConcatNode create0(ArrayNodes.ConcatNode current) {
                return new ConcatRubyArray4Node((ConcatBaseNode)current);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyArray3Node
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ConcatRubyArray3Node(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value;
                try {
                    value = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray otherValue;
                RubyArray arrayValue;
                try {
                    arrayValue = this.