/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.array.ArrayReadDenormalizedNode;
import org.jruby.truffle.nodes.array.ArrayReadDenormalizedNodeFactory;
import org.jruby.truffle.nodes.array.ArrayReadSliceDenormalizedNode;
import org.jruby.truffle.nodes.array.ArrayReadSliceDenormalizedNodeFactory;
import org.jruby.truffle.nodes.array.ArrayReadSliceNormalizedNode;
import org.jruby.truffle.nodes.array.ArrayReadSliceNormalizedNodeFactory;
import org.jruby.truffle.nodes.array.ArrayWriteDenormalizedNode;
import org.jruby.truffle.nodes.array.ArrayWriteDenormalizedNodeFactory;
import org.jruby.truffle.nodes.coerce.ToAryNodeFactory;
import org.jruby.truffle.nodes.coerce.ToIntNode;
import org.jruby.truffle.nodes.coerce.ToIntNodeFactory;
import org.jruby.truffle.nodes.core.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.ArrayCoreMethodNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.nodes.core.ArrayNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumLowerNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.methods.locals.ReadLevelVariableNodeFactory;
import org.jruby.truffle.nodes.objects.IsFrozenNode;
import org.jruby.truffle.nodes.objects.IsFrozenNodeFactory;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.NextException;
import org.jruby.truffle.runtime.control.RedoException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.util.ArrayUtils;
import org.jruby.util.ByteList;
import org.jruby.util.Memo;
import org.jruby.util.Pack;

@CoreClass(name="Array")
public abstract class ArrayNodes {

    @CoreMethod(names={"zip"}, required=1, argumentsAsArray=true)
    public static abstract class ZipNode
    extends ArrayCoreMethodNode {
        public ZipNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ZipNode(ZipNode prev) {
            super(prev);
        }

        @Specialization(guards={"isObject", "isOtherSingleIntegerFixnumArray"})
        public org.jruby.truffle.runtime.core.RubyArray zipObjectIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, Object[] others) {
            boolean areSameLength;
            org.jruby.truffle.runtime.core.RubyArray other = (org.jruby.truffle.runtime.core.RubyArray)others[0];
            Object[] a = (Object[])array.getStore();
            int[] b = (int[])other.getStore();
            int bLength = other.getSize();
            int zippedLength = array.getSize();
            Object[] zipped = new Object[zippedLength];
            boolean bl = areSameLength = bLength == zippedLength;
            if (areSameLength) {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{a[n], b[n]}, 2);
                }
            } else {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = n < bLength ? new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{a[n], b[n]}, 2) : new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{a[n], this.nil()}, 2);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), zipped, zippedLength);
        }

        @Specialization(guards={"isObject", "isOtherSingleObjectArray"})
        public org.jruby.truffle.runtime.core.RubyArray zipObjectObject(org.jruby.truffle.runtime.core.RubyArray array, Object[] others) {
            boolean areSameLength;
            org.jruby.truffle.runtime.core.RubyArray other = (org.jruby.truffle.runtime.core.RubyArray)others[0];
            Object[] a = (Object[])array.getStore();
            Object[] b = (Object[])other.getStore();
            int bLength = other.getSize();
            int zippedLength = array.getSize();
            Object[] zipped = new Object[zippedLength];
            boolean bl = areSameLength = bLength == zippedLength;
            if (areSameLength) {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{a[n], b[n]}, 2);
                }
            } else {
                for (int n = 0; n < zippedLength; ++n) {
                    zipped[n] = n < bLength ? new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{a[n], b[n]}, 2) : new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{a[n], this.nil()}, 2);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), zipped, zippedLength);
        }

        @Specialization(guards={"!isOtherSingleObjectArray"})
        public Object zipObjectObjectNotSingleObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object[] others) {
            return this.zipRuby(frame, others);
        }

        @Specialization(guards={"!isOtherSingleIntegerFixnumArray"})
        public Object zipObjectObjectNotSingleInteger(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object[] others) {
            return this.zipRuby(frame, others);
        }

        @Specialization(guards={"!isObject"})
        public Object zipObjectObjectNotObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object[] others) {
            return this.zipRuby(frame, others);
        }

        private Object zipRuby(VirtualFrame frame, Object[] others) {
            RubyBasicObject proc = RubyArguments.getBlock(frame.getArguments());
            if (proc == null) {
                proc = this.nil();
            }
            return this.ruby(frame, "zip_internal(*others, &block)", "others", new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), others, others.length), "block", proc);
        }
    }

    @CoreMethod(names={"unshift"}, argumentsAsArray=true, raiseIfFrozenSelf=true)
    public static abstract class UnshiftNode
    extends CoreMethodNode {
        public UnshiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UnshiftNode(UnshiftNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray unshift(org.jruby.truffle.runtime.core.RubyArray array, Object ... args) {
            UnshiftNode.notDesignedForCompilation();
            array.slowUnshift(args);
            return array;
        }
    }

    @CoreMethod(names={"sort"}, needsBlock=true)
    public static abstract class SortNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareDispatchNode;
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public SortNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareDispatchNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        public SortNode(SortNode prev) {
            super(prev);
            this.compareDispatchNode = prev.compareDispatchNode;
            this.yieldNode = prev.yieldNode;
        }

        @Specialization(guards={"isNull"})
        public org.jruby.truffle.runtime.core.RubyArray sortNull(org.jruby.truffle.runtime.core.RubyArray array, Object block) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }

        @ExplodeLoop
        @Specialization(guards={"isIntegerFixnum", "isSmall"})
        public org.jruby.truffle.runtime.core.RubyArray sortVeryShortIntegerFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder block) {
            int[] store = (int[])array.getStore();
            int[] newStore = new int[store.length];
            int size = array.getSize();
            for (int i = 0; i < org.jruby.truffle.runtime.core.RubyArray.ARRAYS_SMALL; ++i) {
                if (i >= size) continue;
                for (int j = i + 1; j < org.jruby.truffle.runtime.core.RubyArray.ARRAYS_SMALL; ++j) {
                    if (j >= size || this.castSortValue(this.compareDispatchNode.call(frame, store[j], "<=>", null, store[i])) >= 0) continue;
                    int temp = store[j];
                    store[j] = store[i];
                    store[i] = temp;
                }
                newStore[i] = store[i];
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), newStore, size);
        }

        @ExplodeLoop
        @Specialization(guards={"isLongFixnum", "isSmall"})
        public org.jruby.truffle.runtime.core.RubyArray sortVeryShortLongFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder block) {
            long[] store = (long[])array.getStore();
            long[] newStore = new long[store.length];
            int size = array.getSize();
            for (int i = 0; i < org.jruby.truffle.runtime.core.RubyArray.ARRAYS_SMALL; ++i) {
                if (i >= size) continue;
                for (int j = i + 1; j < org.jruby.truffle.runtime.core.RubyArray.ARRAYS_SMALL; ++j) {
                    if (j >= size || this.castSortValue(this.compareDispatchNode.call(frame, store[j], "<=>", null, store[i])) >= 0) continue;
                    long temp = store[j];
                    store[j] = store[i];
                    store[i] = temp;
                }
                newStore[i] = store[i];
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), newStore, size);
        }

        @Specialization(guards={"isObject", "isSmall"})
        public org.jruby.truffle.runtime.core.RubyArray sortVeryShortObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder block) {
            Object[] oldStore = (Object[])array.getStore();
            Object[] store = Arrays.copyOf(oldStore, oldStore.length);
            int size = array.getSize();
            for (int i = 1; i < size; ++i) {
                Object x = store[i];
                for (int j = i; j > 0 && this.castSortValue(this.compareDispatchNode.call(frame, store[j - 1], "<=>", null, x)) > 0; --j) {
                    store[j] = store[j - 1];
                }
                store[j] = x;
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), store, size);
        }

        @Specialization
        public Object sortUsingRubinius(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            return this.sortUsingRubinius(frame, array, (Object)block);
        }

        @Specialization(guards={"!isNull", "!isSmall"})
        public Object sortUsingRubinius(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object block) {
            if (block == UndefinedPlaceholder.INSTANCE) {
                return this.ruby(frame, "sorted = dup; Rubinius.privately { sorted.isort!(0, right) }; sorted", "right", array.getSize());
            }
            return this.ruby(frame, "sorted = dup; Rubinius.privately { sorted.isort_block!(0, right, block) }; sorted", "right", array.getSize(), "block", block);
        }

        private int castSortValue(Object value) {
            if (value instanceof Integer) {
                return (Integer)value;
            }
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("expecting a Fixnum to sort", this));
        }

        protected static boolean isSmall(org.jruby.truffle.runtime.core.RubyArray array) {
            return array.getSize() <= org.jruby.truffle.runtime.core.RubyArray.ARRAYS_SMALL;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends ArrayCoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization
        public int size(org.jruby.truffle.runtime.core.RubyArray array) {
            return array.getSize();
        }
    }

    @CoreMethod(names={"shift"}, raiseIfFrozenSelf=true, optional=1)
    public static abstract class ShiftNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;

        public ShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ShiftNode(ShiftNode prev) {
            super(prev);
        }

        public abstract Object executeShift(VirtualFrame var1, org.jruby.truffle.runtime.core.RubyArray var2, Object var3);

        @Specialization(guards={"isNullOrEmpty"})
        public Object shiftNil(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            return this.nil();
        }

        @Specialization(guards={"isIntegerFixnum"}, rewriteOn={UnexpectedResultException.class})
        public int shiftIntegerFixnumInBounds(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int[] store = (int[])array.getStore();
            int value = store[0];
            System.arraycopy(store, 1, store, 0, array.getSize() - 1);
            int[] filler = new int[1];
            System.arraycopy(filler, 0, store, array.getSize() - 1, 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"shiftIntegerFixnumInBounds"}, guards={"isIntegerFixnum"})
        public Object shiftIntegerFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int[] store = (int[])array.getStore();
            int value = store[0];
            System.arraycopy(store, 1, store, 0, array.getSize() - 1);
            int[] filler = new int[1];
            System.arraycopy(filler, 0, store, array.getSize() - 1, 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isLongFixnum"}, rewriteOn={UnexpectedResultException.class})
        public long shiftLongFixnumInBounds(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            long[] store = (long[])array.getStore();
            long value = store[0];
            System.arraycopy(store, 1, store, 0, array.getSize() - 1);
            long[] filler = new long[1];
            System.arraycopy(filler, 0, store, array.getSize() - 1, 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"shiftLongFixnumInBounds"}, guards={"isLongFixnum"})
        public Object shiftLongFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            long[] store = (long[])array.getStore();
            long value = store[0];
            System.arraycopy(store, 1, store, 0, array.getSize() - 1);
            long[] filler = new long[1];
            System.arraycopy(filler, 0, store, array.getSize() - 1, 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isFloat"}, rewriteOn={UnexpectedResultException.class})
        public double shiftFloatInBounds(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            double[] store = (double[])array.getStore();
            double value = store[0];
            System.arraycopy(store, 1, store, 0, array.getSize() - 1);
            double[] filler = new double[1];
            System.arraycopy(filler, 0, store, array.getSize() - 1, 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"shiftFloatInBounds"}, guards={"isFloat"})
        public Object shiftFloat(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            double[] store = (double[])array.getStore();
            double value = store[0];
            System.arraycopy(store, 1, store, 0, array.getSize() - 1);
            double[] filler = new double[1];
            System.arraycopy(filler, 0, store, array.getSize() - 1, 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isObject"})
        public Object shiftObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            Object[] store = (Object[])array.getStore();
            Object value = store[0];
            System.arraycopy(store, 1, store, 0, array.getSize() - 1);
            Object[] filler = new Object[1];
            System.arraycopy(filler, 0, store, array.getSize() - 1, 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isNullOrEmpty", "!isUndefinedPlaceholder(arguments[1])"})
        public Object shiftNilWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int n;
            if (object instanceof Integer && (Integer)object < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((n = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
        }

        @Specialization(guards={"isIntegerFixnum"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray popIntegerFixnumInBoundsWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            int[] store = (int[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(contains={"popIntegerFixnumInBoundsWithNum"}, guards={"isIntegerFixnum"})
        public Object popIntegerFixnumWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            int[] store = (int[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(guards={"isLongFixnum"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray shiftLongFixnumInBoundsWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            long[] store = (long[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(contains={"shiftLongFixnumInBoundsWithNum"}, guards={"isLongFixnum"})
        public Object shiftLongFixnumWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            long[] store = (long[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(guards={"isFloat"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray shiftFloatInBoundsWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            double[] store = (double[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(contains={"shiftFloatInBoundsWithNum"}, guards={"isFloat"})
        public Object shiftFloatWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            double[] store = (double[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(guards={"isObject"})
        public Object shiftObjectWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            Object[] store = (Object[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            Object[] filler = new Object[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(guards={"isIntegerFixnum", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray shiftIntegerFixnumInBoundsWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            int[] store = (int[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(contains={"shiftIntegerFixnumInBoundsWithNumObj"}, guards={"isIntegerFixnum", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object shiftIntegerFixnumWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            int[] store = (int[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            int[] filler = new int[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(guards={"isLongFixnum", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray shiftLongFixnumInBoundsWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            long[] store = (long[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(contains={"shiftLongFixnumInBoundsWithNumObj"}, guards={"isLongFixnum", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object shiftLongFixnumWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            long[] store = (long[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, numShift), numShift);
            long[] filler = new long[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(guards={"isFloat", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray shiftFloatInBoundsWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            double[] store = (double[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, array.getSize() - numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(contains={"shiftFloatInBoundsWithNumObj"}, guards={"isFloat", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object shiftFloatWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            double[] store = (double[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, array.getSize() - numShift), numShift);
            double[] filler = new double[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }

        @Specialization(guards={"isObject", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object shiftObjectWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numShift = array.getSize() < num ? array.getSize() : num;
            Object[] store = (Object[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, 0, array.getSize() - numShift), numShift);
            Object[] filler = new Object[numShift];
            System.arraycopy(store, numShift, store, 0, array.getSize() - numShift);
            System.arraycopy(filler, 0, store, array.getSize() - numShift, numShift);
            array.setStore(store, array.getSize() - numShift);
            return result;
        }
    }

    @CoreMethod(names={"select"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class SelectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public SelectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public SelectNode(SelectNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        @Specialization(guards={"isNull"})
        public Object selectNull(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object selectObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            Object selectedStore = this.arrayBuilder.start(array.getSize());
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Object value = store[n];
                    SelectNode.notDesignedForCompilation();
                    if (!this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object selectFixnumInteger(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int[] store = (int[])array.getStore();
            Object selectedStore = this.arrayBuilder.start(array.getSize());
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Integer value = store[n];
                    SelectNode.notDesignedForCompilation();
                    if (!this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    @CoreMethod(names={"replace"}, required=1, raiseIfFrozenSelf=true)
    @ImportGuards(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="other")})
    public static abstract class ReplaceNode
    extends RubyNode {
        public ReplaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReplaceNode(ReplaceNode prev) {
            super(prev);
        }

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToAry(RubyNode index) {
            return ToAryNodeFactory.create(this.getContext(), this.getSourceSection(), index);
        }

        @Specialization(guards={"isOtherNull"})
        public org.jruby.truffle.runtime.core.RubyArray replace(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setStore(null, 0);
            return array;
        }

        @Specialization(guards={"isOtherIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray replaceIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((int[])other.getStore(), other.getSize()), other.getSize());
            return array;
        }

        @Specialization(guards={"isOtherLongFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray replaceLongFixnum(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((long[])other.getStore(), other.getSize()), other.getSize());
            return array;
        }

        @Specialization(guards={"isOtherFloat"})
        public org.jruby.truffle.runtime.core.RubyArray replaceFloat(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((double[])other.getStore(), other.getSize()), other.getSize());
            return array;
        }

        @Specialization(guards={"isOtherObject"})
        public org.jruby.truffle.runtime.core.RubyArray replaceObject(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((Object[])other.getStore(), other.getSize()), other.getSize());
            return array;
        }
    }

    @CoreMethod(names={"reject!"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class RejectInPlaceNode
    extends YieldingCoreMethodNode {
        public RejectInPlaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RejectInPlaceNode(RejectInPlaceNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNullArray"})
        public Object rejectInPlaceNull(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            return this.nil();
        }

        @Specialization(guards={"isIntArray"})
        public Object rejectInPlaceInt(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int n;
            int[] store = (int[])array.getStore();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                int[] filler = new int[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                array.setStore(store, i);
                return array;
            }
            return this.nil();
        }

        @Specialization(guards={"isLongArray"})
        public Object rejectInPlaceLong(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int n;
            long[] store = (long[])array.getStore();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                long[] filler = new long[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                array.setStore(store, i);
                return array;
            }
            return this.nil();
        }

        @Specialization(guards={"isDoubleArray"})
        public Object rejectInPlaceDouble(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int n;
            double[] store = (double[])array.getStore();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                double[] filler = new double[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                array.setStore(store, i);
                return array;
            }
            return this.nil();
        }

        @Specialization(guards={"isObjectArray"})
        public Object rejectInPlaceObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int n;
            Object[] store = (Object[])array.getStore();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                Object[] filler = new Object[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                array.setStore(store, i);
                return array;
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"delete_if"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class DeleteIfNode
    extends YieldingCoreMethodNode {
        public DeleteIfNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DeleteIfNode(DeleteIfNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNullArray"})
        public Object rejectInPlaceNull(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            return array;
        }

        @Specialization(guards={"isIntArray"})
        public Object rejectInPlaceInt(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int n;
            int[] store = (int[])array.getStore();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                int[] filler = new int[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                array.setStore(store, i);
            }
            return array;
        }

        @Specialization(guards={"isLongArray"})
        public Object rejectInPlaceLong(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int n;
            long[] store = (long[])array.getStore();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                long[] filler = new long[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                array.setStore(store, i);
            }
            return array;
        }

        @Specialization(guards={"isDoubleArray"})
        public Object rejectInPlaceDouble(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int n;
            double[] store = (double[])array.getStore();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                double[] filler = new double[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                array.setStore(store, i);
            }
            return array;
        }

        @Specialization(guards={"isObjectArray"})
        public Object rejectInPlaceObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int n;
            Object[] store = (Object[])array.getStore();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                Object[] filler = new Object[n - i];
                System.arraycopy(filler, 0, store, i, n - i);
                array.setStore(store, i);
            }
            return array;
        }
    }

    @CoreMethod(names={"reject"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class RejectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public RejectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public RejectNode(RejectNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        @Specialization(guards={"isNull"})
        public Object selectNull(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object selectObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            Object selectedStore = this.arrayBuilder.start(array.getSize());
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Object value = store[n];
                    RejectNode.notDesignedForCompilation();
                    if (this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object selectFixnumInteger(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int[] store = (int[])array.getStore();
            Object selectedStore = this.arrayBuilder.start(array.getSize());
            int selectedSize = 0;
            int count = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    Integer value = store[n];
                    RejectNode.notDesignedForCompilation();
                    if (this.yieldIsTruthy(frame, block, value)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    public static abstract class PushOneNode
    extends ArrayCoreMethodNode {
        private final BranchProfile extendBranch = BranchProfile.create();

        public PushOneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PushOneNode(PushOneNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public org.jruby.truffle.runtime.core.RubyArray pushEmpty(org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            array.setStore(new Object[]{value}, 1);
            return array;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray pushIntegerFixnumIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, int value) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            int[] store = (int[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                array.setStore(store, array.getSize());
            }
            store[oldSize] = value;
            array.setStore(store, newSize);
            return array;
        }

        @Specialization(guards={"isIntegerFixnum", "!isInteger(arguments[1])"})
        public org.jruby.truffle.runtime.core.RubyArray pushIntegerFixnumObject(org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            Object[] newStore;
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            int[] oldStore = (int[])array.getStore();
            if (oldStore.length < newSize) {
                this.extendBranch.enter();
                newStore = ArrayUtils.box(oldStore, ArrayUtils.capacity(oldStore.length, newSize) - oldStore.length);
            } else {
                newStore = ArrayUtils.box(oldStore);
            }
            newStore[oldSize] = value;
            array.setStore(newStore, newSize);
            return array;
        }

        @Specialization(guards={"isObject"})
        public org.jruby.truffle.runtime.core.RubyArray pushObjectObject(org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            Object[] store = (Object[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                array.setStore(store, array.getSize());
            }
            store[oldSize] = value;
            array.setStore(store, newSize);
            return array;
        }
    }

    @CoreMethod(names={"push", "<<", "__append__"}, argumentsAsArray=true, raiseIfFrozenSelf=true)
    public static abstract class PushNode
    extends ArrayCoreMethodNode {
        private final BranchProfile extendBranch = BranchProfile.create();

        public PushNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PushNode(PushNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull", "isSingleIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray pushNullEmptySingleIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            array.setStore(new int[]{(Integer)values[0]}, 1);
            return array;
        }

        @Specialization(guards={"isNull", "isSingleLongFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray pushNullEmptySingleIntegerLong(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            array.setStore(new long[]{(Long)values[0]}, 1);
            return array;
        }

        @Specialization(guards={"isNull"})
        public org.jruby.truffle.runtime.core.RubyArray pushNullEmptyObjects(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            array.setStore(values, values.length);
            return array;
        }

        @Specialization(guards={"!isNull", "isEmpty"})
        public org.jruby.truffle.runtime.core.RubyArray pushEmptySingleIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            array.setStore(values, values.length);
            return array;
        }

        @Specialization(guards={"isIntegerFixnum", "isSingleIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray pushIntegerFixnumSingleIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            int[] store = (int[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            store[oldSize] = (Integer)values[0];
            array.setStore(store, newSize);
            return array;
        }

        @Specialization(guards={"isIntegerFixnum", "!isSingleIntegerFixnum", "!isSingleLongFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray pushIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            Object[] store;
            int oldSize = array.getSize();
            int newSize = oldSize + values.length;
            int[] oldStore = (int[])array.getStore();
            if (oldStore.length < newSize) {
                this.extendBranch.enter();
                store = ArrayUtils.box(oldStore, ArrayUtils.capacity(oldStore.length, newSize) - oldStore.length);
            } else {
                store = ArrayUtils.box(oldStore);
            }
            for (int n = 0; n < values.length; ++n) {
                store[oldSize + n] = values[n];
            }
            array.setStore(store, newSize);
            return array;
        }

        @Specialization(guards={"isLongFixnum", "isSingleIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray pushLongFixnumSingleIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            long[] store = (long[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            store[oldSize] = ((Integer)values[0]).intValue();
            array.setStore(store, newSize);
            return array;
        }

        @Specialization(guards={"isLongFixnum", "isSingleLongFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray pushLongFixnumSingleLongFixnum(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            long[] store = (long[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            store[oldSize] = (Long)values[0];
            array.setStore(store, newSize);
            return array;
        }

        @Specialization(guards={"isFloat"})
        public org.jruby.truffle.runtime.core.RubyArray pushFloat(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            if (array.getSize() != 0) {
                throw new UnsupportedOperationException();
            }
            array.setStore(values, values.length);
            return array;
        }

        @Specialization(guards={"isObject"})
        public org.jruby.truffle.runtime.core.RubyArray pushObject(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            int oldSize = array.getSize();
            int newSize = oldSize + values.length;
            Object[] store = (Object[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            for (int n = 0; n < values.length; ++n) {
                store[oldSize + n] = values[n];
            }
            array.setStore(store, newSize);
            return array;
        }

        protected boolean isSingleIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            return values.length == 1 && values[0] instanceof Integer;
        }

        protected boolean isSingleLongFixnum(org.jruby.truffle.runtime.core.RubyArray array, Object ... values) {
            return values.length == 1 && values[0] instanceof Long;
        }
    }

    @CoreMethod(names={"pop"}, raiseIfFrozenSelf=true, optional=1)
    public static abstract class PopNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;

        public PopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PopNode(PopNode prev) {
            super(prev);
            this.toIntNode = prev.toIntNode;
        }

        public abstract Object executePop(VirtualFrame var1, org.jruby.truffle.runtime.core.RubyArray var2, Object var3);

        @Specialization(guards={"isNullOrEmpty"})
        public Object popNil(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            return this.nil();
        }

        @Specialization(guards={"isIntegerFixnum"}, rewriteOn={UnexpectedResultException.class})
        public int popIntegerFixnumInBounds(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int[] store = (int[])array.getStore();
            int value = store[array.getSize() - 1];
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"popIntegerFixnumInBounds"}, guards={"isIntegerFixnum"})
        public Object popIntegerFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int[] store = (int[])array.getStore();
            int value = store[array.getSize() - 1];
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isLongFixnum"}, rewriteOn={UnexpectedResultException.class})
        public long popLongFixnumInBounds(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            long[] store = (long[])array.getStore();
            long value = store[array.getSize() - 1];
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"popLongFixnumInBounds"}, guards={"isLongFixnum"})
        public Object popLongFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            long[] store = (long[])array.getStore();
            long value = store[array.getSize() - 1];
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isFloat"}, rewriteOn={UnexpectedResultException.class})
        public double popFloatInBounds(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            double[] store = (double[])array.getStore();
            double value = store[array.getSize() - 1];
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"popFloatInBounds"}, guards={"isFloat"})
        public Object popFloat(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            double[] store = (double[])array.getStore();
            double value = store[array.getSize() - 1];
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isObject"})
        public Object popObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder undefinedPlaceholder) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            Object[] store = (Object[])array.getStore();
            Object value = store[array.getSize() - 1];
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isNullOrEmpty", "!isUndefinedPlaceholder(arguments[1])"})
        public Object popNilWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int n;
            if (object instanceof Integer && (Integer)object < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((n = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
        }

        @Specialization(guards={"isIntegerFixnum"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray popIntegerFixnumInBoundsWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            int[] store = (int[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(contains={"popIntegerFixnumInBoundsWithNum"}, guards={"isIntegerFixnum"})
        public Object popIntegerFixnumWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            int[] store = (int[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(guards={"isLongFixnum"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray popLongFixnumInBoundsWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            long[] store = (long[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(contains={"popLongFixnumInBoundsWithNum"}, guards={"isLongFixnum"})
        public Object popLongFixnumWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            long[] store = (long[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(guards={"isFloat"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray popFloatInBoundsWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) throws UnexpectedResultException {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            double[] store = (double[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(contains={"popFloatInBoundsWithNum"}, guards={"isFloat"})
        public Object popFloatWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            double[] store = (double[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(guards={"isObject"})
        public Object popObjectWithNum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int num) {
            if (num < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            Object[] store = (Object[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            Object[] filler = new Object[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(guards={"isIntegerFixnum", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray popIntegerFixnumInBoundsWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            int[] store = (int[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(contains={"popIntegerFixnumInBoundsWithNumObj"}, guards={"isIntegerFixnum", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object popIntegerFixnumWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            int[] store = (int[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            int[] filler = new int[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(guards={"isLongFixnum", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray popLongFixnumInBoundsWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            long[] store = (long[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(contains={"popLongFixnumInBoundsWithNumObj"}, guards={"isLongFixnum", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object popLongFixnumWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            long[] store = (long[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            long[] filler = new long[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(guards={"isFloat", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"}, rewriteOn={UnexpectedResultException.class})
        public org.jruby.truffle.runtime.core.RubyArray popFloatInBoundsWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) throws UnexpectedResultException {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            double[] store = (double[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(contains={"popFloatInBoundsWithNumObj"}, guards={"isFloat", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object popFloatWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            double[] store = (double[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            double[] filler = new double[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }

        @Specialization(guards={"isObject", "!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[1])"})
        public Object popObjectWithNumObj(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int num;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((num = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
            }
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.nil();
            }
            int numPop = array.getSize() < num ? array.getSize() : num;
            Object[] store = (Object[])array.getStore();
            org.jruby.truffle.runtime.core.RubyArray result = new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOfRange(store, array.getSize() - numPop, array.getSize()), numPop);
            Object[] filler = new Object[numPop];
            System.arraycopy(filler, 0, store, array.getSize() - numPop, numPop);
            array.setStore(store, array.getSize() - numPop);
            return result;
        }
    }

    @CoreMethod(names={"pack"}, required=1)
    public static abstract class PackNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toStringNode;

        public PackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PackNode(PackNode prev) {
            super(prev);
            this.toStringNode = prev.toStringNode;
        }

        @Specialization(guards={"arrayIsInts", "formatIsXN2000"})
        public org.jruby.truffle.runtime.core.RubyString packXN2000(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyString format) {
            int size = array.getSize();
            int[] store = (int[])array.getStore();
            byte[] bytes = new byte[1 + size * 4];
            for (int n = 0; n < size; ++n) {
                int value = store[n];
                int byteOffset = 1 + n * 4;
                bytes[byteOffset + 3] = (byte)(value >>> 24);
                bytes[byteOffset + 2] = (byte)(value >>> 16);
                bytes[byteOffset + 1] = (byte)(value >>> 8);
                bytes[byteOffset + 0] = (byte)value;
            }
            return new org.jruby.truffle.runtime.core.RubyString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(bytes));
        }

        @Specialization(guards={"arrayIsLongs", "formatIsLStar"})
        public org.jruby.truffle.runtime.core.RubyString packLStar(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyString format) {
            int size = array.getSize();
            long[] store = (long[])array.getStore();
            byte[] bytes = new byte[size * 4];
            for (int n = 0; n < size; ++n) {
                int value = (int)store[n];
                int byteOffset = n * 4;
                bytes[byteOffset + 3] = (byte)(value >>> 24);
                bytes[byteOffset + 2] = (byte)(value >>> 16);
                bytes[byteOffset + 1] = (byte)(value >>> 8);
                bytes[byteOffset + 0] = (byte)value;
            }
            return new org.jruby.truffle.runtime.core.RubyString(this.getContext().getCoreLibrary().getStringClass(), new ByteList(bytes));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public org.jruby.truffle.runtime.core.RubyString pack(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyString format) {
            PackNode.notDesignedForCompilation();
            Object[] objects = array.slowToArray();
            IRubyObject[] jrubyObjects = new IRubyObject[objects.length];
            for (int n = 0; n < objects.length; ++n) {
                Object result;
                if (objects[n] instanceof RubyNilClass || objects[n] instanceof Integer || objects[n] instanceof Long || objects[n] instanceof RubyBignum || objects[n] instanceof Double || objects[n] instanceof org.jruby.truffle.runtime.core.RubyString) {
                    jrubyObjects[n] = this.getContext().toJRuby(objects[n]);
                    continue;
                }
                if (this.toStringNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toStringNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), MissingBehavior.RETURN_MISSING));
                }
                if ((result = this.toStringNode.call(frame, objects[n], "to_str", null, new Object[0])) == DispatchNode.MISSING) {
                    throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(objects[n], "String", this));
                }
                if (result instanceof org.jruby.truffle.runtime.core.RubyString) {
                    jrubyObjects[n] = this.getContext().toJRuby((org.jruby.truffle.runtime.core.RubyString)result);
                    continue;
                }
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(objects[n], "String", this));
            }
            try {
                return this.getContext().toTruffle(Pack.pack((ThreadContext)this.getContext().getRuntime().getCurrentContext(), (Ruby)this.getContext().getRuntime(), (RubyArray)this.getContext().getRuntime().newArray(jrubyObjects), (RubyString)this.getContext().toJRuby(format)));
            }
            catch (RaiseException e) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().toTruffle(e.getException(), this));
            }
        }

        @Specialization(guards={"!isRubyString(arguments[1])"})
        public org.jruby.truffle.runtime.core.RubyString pack(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object format) {
            Object result;
            if (this.toStringNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toStringNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), MissingBehavior.RETURN_MISSING));
            }
            if ((result = this.toStringNode.call(frame, format, "to_str", null, new Object[0])) == DispatchNode.MISSING) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().typeErrorNoImplicitConversion(format, "String", this));
            }
            if (result instanceof org.jruby.truffle.runtime.core.RubyString) {
                return this.pack(frame, array, (org.jruby.truffle.runtime.core.RubyString)result);
            }
            throw new UnsupportedOperationException();
        }

        protected boolean arrayIsInts(org.jruby.truffle.runtime.core.RubyArray array) {
            return array.getStore() instanceof int[];
        }

        protected boolean arrayIsLongs(org.jruby.truffle.runtime.core.RubyArray array) {
            return array.getStore() instanceof long[];
        }

        protected boolean formatIsLStar(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyString format) {
            ByteList byteList = format.getByteList();
            if (!byteList.getEncoding().isAsciiCompatible()) {
                return false;
            }
            if (byteList.length() != 2) {
                return false;
            }
            byte[] bytes = byteList.unsafeBytes();
            return bytes[0] == 76 && bytes[1] == 42;
        }

        protected boolean formatIsXN2000(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyString format) {
            ByteList byteList = format.getByteList();
            if (!byteList.getEncoding().isAsciiCompatible()) {
                return false;
            }
            if (byteList.length() != 6) {
                return false;
            }
            byte[] bytes = byteList.unsafeBytes();
            return bytes[0] == 120 && bytes[1] == 78 && bytes[2] == 50 && bytes[3] == 48 && bytes[4] == 48 && bytes[5] == 48;
        }
    }

    public static class MinBlock {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MinBlock(RubyContext context) {
            CoreSourceSection sourceSection = new CoreSourceSection("Array", "min");
            this.frameDescriptor = new FrameDescriptor();
            this.frameSlot = this.frameDescriptor.addFrameSlot((Object)"minimum_memo");
            this.sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, Arity.NO_ARGUMENTS, "min", false, null, false);
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)new RubyRootNode(context, (SourceSection)sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MinBlockNodeFactory.create(context, (SourceSection)sourceSection, new RubyNode[]{ReadLevelVariableNodeFactory.create(context, (SourceSection)sourceSection, this.frameSlot, 1), new ReadPreArgumentNode(context, (SourceSection)sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR)})));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MinBlockNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MinBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public MinBlockNode(MinBlockNode prev) {
            super(prev);
            this.compareNode = prev.compareNode;
        }

        @Specialization
        public RubyNilClass min(VirtualFrame frame, Object minimumObject, Object value) {
            Memo minimum = (Memo)minimumObject;
            Object current = minimum.get();
            if (current == null || (Integer)this.compareNode.call(frame, value, "<=>", null, current) < 0) {
                minimum.set(value);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"min"})
    public static abstract class MinNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MinBlock minBlock;

        public MinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.minBlock = context.getCoreLibrary().getArrayMinBlock();
        }

        public MinNode(MinNode prev) {
            super(prev);
            this.eachNode = prev.eachNode;
            this.minBlock = prev.minBlock;
        }

        @Specialization
        public Object min(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array) {
            Memo minimum = new Memo();
            VirtualFrame minimumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(null, null, array, null, new Object[0]), this.minBlock.getFrameDescriptor());
            minimumClosureFrame.setObject(this.minBlock.getFrameSlot(), (Object)minimum);
            RubyProc block = new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, this.minBlock.getSharedMethodInfo(), this.minBlock.getCallTarget(), this.minBlock.getCallTarget(), this.minBlock.getCallTarget(), minimumClosureFrame.materialize(), null, array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (minimum.get() == null) {
                return this.nil();
            }
            return minimum.get();
        }
    }

    public static class MaxBlock {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MaxBlock(RubyContext context) {
            CoreSourceSection sourceSection = new CoreSourceSection("Array", "max");
            this.frameDescriptor = new FrameDescriptor();
            this.frameSlot = this.frameDescriptor.addFrameSlot((Object)"maximum_memo");
            this.sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, Arity.NO_ARGUMENTS, "max", false, null, false);
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)new RubyRootNode(context, (SourceSection)sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MaxBlockNodeFactory.create(context, (SourceSection)sourceSection, new RubyNode[]{ReadLevelVariableNodeFactory.create(context, (SourceSection)sourceSection, this.frameSlot, 1), new ReadPreArgumentNode(context, (SourceSection)sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR)})));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MaxBlockNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MaxBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public MaxBlockNode(MaxBlockNode prev) {
            super(prev);
            this.compareNode = prev.compareNode;
        }

        @Specialization
        public RubyNilClass max(VirtualFrame frame, Object maximumObject, Object value) {
            Memo maximum = (Memo)maximumObject;
            Object current = maximum.get();
            if (current == null || (Integer)this.compareNode.call(frame, value, "<=>", null, current) < 0) {
                maximum.set(value);
            }
            return this.nil();
        }
    }

    @CoreMethod(names={"max"})
    public static abstract class MaxNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MaxBlock maxBlock;

        public MaxNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.maxBlock = context.getCoreLibrary().getArrayMaxBlock();
        }

        public MaxNode(MaxNode prev) {
            super(prev);
            this.eachNode = prev.eachNode;
            this.maxBlock = prev.maxBlock;
        }

        @Specialization
        public Object max(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array) {
            Memo maximum = new Memo();
            VirtualFrame maximumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(null, null, array, null, new Object[0]), this.maxBlock.getFrameDescriptor());
            maximumClosureFrame.setObject(this.maxBlock.getFrameSlot(), (Object)maximum);
            RubyProc block = new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, this.maxBlock.getSharedMethodInfo(), this.maxBlock.getCallTarget(), this.maxBlock.getCallTarget(), this.maxBlock.getCallTarget(), maximumClosureFrame.materialize(), null, array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (maximum.get() == null) {
                return this.nil();
            }
            return maximum.get();
        }
    }

    @CoreMethod(names={"map!", "collect!"}, needsBlock=true, returnsEnumeratorIfNoBlock=true, raiseIfFrozenSelf=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class MapInPlaceNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayWriteDenormalizedNode writeNode;
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public MapInPlaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MapInPlaceNode(MapInPlaceNode prev) {
            super(prev);
            this.writeNode = prev.writeNode;
        }

        @Specialization(guards={"isNull"})
        public org.jruby.truffle.runtime.core.RubyArray mapInPlaceNull(org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object mapInPlaceFixnumInteger(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            int[] store = (int[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.writeNode.executeWrite(frame, array, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object mapInPlaceObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            Object[] store = (Object[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.writeNode.executeWrite(frame, array, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true, returnsEnumeratorIfNoBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public MapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public MapNode(MapNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        @Specialization(guards={"isNull"})
        public org.jruby.truffle.runtime.core.RubyArray mapNull(org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object mapIntegerFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int[] store = (int[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongFixnum"})
        public Object mapLongFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            long[] store = (long[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isFloat"})
        public Object mapFloat(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            double[] store = (double[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object mapObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }
    }

    @CoreMethod(names={"insert"}, required=1, raiseIfFrozenSelf=true, argumentsAsArray=true)
    public static abstract class InsertNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        private final BranchProfile tooSmallBranch = BranchProfile.create();

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InsertNode(InsertNode prev) {
            super(prev);
            this.toIntNode = prev.toIntNode;
        }

        @Specialization(guards={"isNull", "isIntIndexAndOtherSingleObjectArg"})
        public Object insertNull(org.jruby.truffle.runtime.core.RubyArray array, Object[] values) {
            InsertNode.notDesignedForCompilation();
            int index = (Integer)values[0];
            if (index < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            Object value = values[1];
            Object[] store = new Object[index + 1];
            Arrays.fill(store, this.nil());
            store[index] = value;
            array.setStore(store, array.getSize() + 1);
            return array;
        }

        @Specialization(guards={"isArgsLengthTwo"}, rewriteOn={ClassCastException.class, IndexOutOfBoundsException.class})
        public Object insert(org.jruby.truffle.runtime.core.RubyArray array, Object[] values) {
            int index = (Integer)values[0];
            int value = (Integer)values[1];
            int[] store = (int[])array.getStore();
            System.arraycopy(store, index, store, index + 1, array.getSize() - index);
            store[index] = value;
            array.setStore(store, array.getSize() + 1);
            return array;
        }

        @Specialization(contains={"insert", "insertNull"})
        public Object insertBoxed(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object[] values) {
            int normalizedIndex;
            int index;
            InsertNode.notDesignedForCompilation();
            if (values.length == 1) {
                return array;
            }
            if (values[0] instanceof Integer) {
                index = (Integer)values[0];
            } else {
                if (this.toIntNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
                }
                index = this.toIntNode.executeInt(frame, values[0]);
            }
            int valuesLength = values.length - 1;
            int n = normalizedIndex = index < 0 ? array.normalizeIndex(index) + 1 : array.normalizeIndex(index);
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "index " + index + " too small for array; minimum: " + Integer.toString(-array.getSize());
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            Object[] store = ArrayUtils.box(array.getStore());
            int newSize = normalizedIndex < array.getSize() ? array.getSize() + valuesLength : normalizedIndex + valuesLength;
            store = Arrays.copyOf(store, newSize);
            if (normalizedIndex >= array.getSize()) {
                for (int i = array.getSize(); i < normalizedIndex; ++i) {
                    store[i] = this.nil();
                }
            }
            int dest = normalizedIndex + valuesLength;
            int len = array.getSize() - normalizedIndex;
            if (normalizedIndex < array.getSize()) {
                System.arraycopy(store, normalizedIndex, store, dest, len);
            }
            System.arraycopy(values, 1, store, normalizedIndex, valuesLength);
            array.setStore(store, newSize);
            return array;
        }
    }

    @CoreMethod(names={"inject", "reduce"}, needsBlock=true, optional=1)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class InjectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode dispatch;

        public InjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.CALL_METHOD_MISSING);
        }

        public InjectNode(InjectNode prev) {
            super(prev);
            this.dispatch = prev.dispatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object injectIntegerFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object initial, RubyProc block) {
            int count = 0;
            int[] store = (int[])array.getStore();
            Object accumulator = initial;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.yield(frame, block, accumulator, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongFixnum"})
        public Object injectLongFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object initial, RubyProc block) {
            int count = 0;
            long[] store = (long[])array.getStore();
            Object accumulator = initial;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.yield(frame, block, accumulator, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isFloat"})
        public Object injectFloat(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object initial, RubyProc block) {
            int count = 0;
            double[] store = (double[])array.getStore();
            Object accumulator = initial;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.yield(frame, block, accumulator, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object injectObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object initial, RubyProc block) {
            int count = 0;
            Object[] store = (Object[])array.getStore();
            Object accumulator = initial;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    accumulator = this.yield(frame, block, accumulator, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return accumulator;
        }

        @Specialization(guards={"isNullArray"})
        public Object injectNull(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object initial, RubyProc block) {
            return initial;
        }

        @Specialization
        public Object inject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubySymbol symbol, UndefinedPlaceholder unused) {
            InjectNode.notDesignedForCompilation();
            Object[] store = array.slowToArray();
            if (store.length < 2) {
                throw new UnsupportedOperationException();
            }
            Object accumulator = this.dispatch.call(frame, store[0], symbol, null, store[1]);
            for (int n = 2; n < array.getSize(); ++n) {
                accumulator = this.dispatch.call(frame, accumulator, symbol, null, store[n]);
            }
            return accumulator;
        }
    }

    @CoreMethod(names={"initialize_copy"}, required=1, raiseIfFrozenSelf=true)
    @ImportGuards(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(value="self"), @NodeChild(value="from")})
    public static abstract class InitializeCopyNode
    extends RubyNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @CreateCast(value={"from"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeFactory.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isOtherNull"})
        public org.jruby.truffle.runtime.core.RubyArray initializeCopyNull(org.jruby.truffle.runtime.core.RubyArray self, org.jruby.truffle.runtime.core.RubyArray from) {
            if (self == from) {
                return self;
            }
            self.setStore(null, 0);
            return self;
        }

        @Specialization(guards={"isOtherIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray initializeCopyIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray self, org.jruby.truffle.runtime.core.RubyArray from) {
            if (self == from) {
                return self;
            }
            self.setStore(Arrays.copyOf((int[])from.getStore(), from.getSize()), from.getSize());
            return self;
        }

        @Specialization(guards={"isOtherLongFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray initializeCopyLongFixnum(org.jruby.truffle.runtime.core.RubyArray self, org.jruby.truffle.runtime.core.RubyArray from) {
            if (self == from) {
                return self;
            }
            self.setStore(Arrays.copyOf((long[])from.getStore(), from.getSize()), from.getSize());
            return self;
        }

        @Specialization(guards={"isOtherFloat"})
        public org.jruby.truffle.runtime.core.RubyArray initializeCopyFloat(org.jruby.truffle.runtime.core.RubyArray self, org.jruby.truffle.runtime.core.RubyArray from) {
            if (self == from) {
                return self;
            }
            self.setStore(Arrays.copyOf((double[])from.getStore(), from.getSize()), from.getSize());
            return self;
        }

        @Specialization(guards={"isOtherObject"})
        public org.jruby.truffle.runtime.core.RubyArray initializeCopyObject(org.jruby.truffle.runtime.core.RubyArray self, org.jruby.truffle.runtime.core.RubyArray from) {
            if (self == from) {
                return self;
            }
            self.setStore(Arrays.copyOf((Object[])from.getStore(), from.getSize()), from.getSize());
            return self;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, optional=2, raiseIfFrozenSelf=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class InitializeNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ToIntNode toIntNode;
        @Node.Child
        private CallDispatchHeadNode toAryNode;
        @Node.Child
        private KernelNodes.RespondToNode respondToToAryNode;
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
            this.toIntNode = prev.toIntNode;
            this.respondToToAryNode = prev.respondToToAryNode;
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isLong(arguments[1])", "!isUndefinedPlaceholder(arguments[1])", "!isRubyArray(arguments[1])"})
        public org.jruby.truffle.runtime.core.RubyArray initialize(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            int size;
            org.jruby.truffle.runtime.core.RubyArray copy = null;
            if (this.respondToToAryNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToAryNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            if (this.respondToToAryNode.doesRespondTo(frame, object, this.getContext().makeString("to_ary"), true)) {
                Object toAryResult;
                if (this.toAryNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.toAryNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
                }
                if ((toAryResult = this.toAryNode.call(frame, object, "to_ary", null, new Object[0])) instanceof org.jruby.truffle.runtime.core.RubyArray) {
                    copy = (org.jruby.truffle.runtime.core.RubyArray)toAryResult;
                }
            }
            if (copy != null) {
                return this.initialize(array, copy, UndefinedPlaceholder.INSTANCE, UndefinedPlaceholder.INSTANCE);
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((size = this.toIntNode.executeInt(frame, object)) < 0) {
                return this.initializeNegative(array, size, UndefinedPlaceholder.INSTANCE, UndefinedPlaceholder.INSTANCE);
            }
            return this.initialize(array, size, UndefinedPlaceholder.INSTANCE, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder size, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            return this.initialize(array, 0, this.nil(), block);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder size, UndefinedPlaceholder defaultValue, RubyProc block) {
            return this.initialize(array, 0, this.nil(), UndefinedPlaceholder.INSTANCE);
        }

        @Specialization(guards={"!isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, int size, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            return this.initialize(array, size, this.nil(), block);
        }

        @Specialization(guards={"isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initializeNegative(org.jruby.truffle.runtime.core.RubyArray array, int size, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"!isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, long size, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            if (size > Integer.MAX_VALUE) {
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("array size too big", this));
            }
            return this.initialize(array, (int)size, this.nil(), block);
        }

        @Specialization(guards={"isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initializeNegative(org.jruby.truffle.runtime.core.RubyArray array, long size, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"!isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, int size, int defaultValue, UndefinedPlaceholder block) {
            int[] store = new int[size];
            Arrays.fill(store, defaultValue);
            array.setStore(store, size);
            return array;
        }

        @Specialization(guards={"isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initializeNegative(org.jruby.truffle.runtime.core.RubyArray array, int size, int defaultValue, UndefinedPlaceholder block) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"!isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, int size, long defaultValue, UndefinedPlaceholder block) {
            long[] store = new long[size];
            Arrays.fill(store, defaultValue);
            array.setStore(store, size);
            return array;
        }

        @Specialization(guards={"isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initializeNegative(org.jruby.truffle.runtime.core.RubyArray array, int size, long defaultValue, UndefinedPlaceholder block) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"!isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, int size, double defaultValue, UndefinedPlaceholder block) {
            double[] store = new double[size];
            Arrays.fill(store, defaultValue);
            array.setStore(store, size);
            return array;
        }

        @Specialization(guards={"isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initializeNegative(org.jruby.truffle.runtime.core.RubyArray array, int size, double defaultValue, UndefinedPlaceholder block) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[2])", "!isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, int size, Object defaultValue, UndefinedPlaceholder block) {
            Object[] store = new Object[size];
            Arrays.fill(store, defaultValue);
            array.setStore(store, size);
            return array;
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[2])", "isNegative"})
        public org.jruby.truffle.runtime.core.RubyArray initializeNegative(org.jruby.truffle.runtime.core.RubyArray array, int size, Object defaultValue, UndefinedPlaceholder block) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isUndefinedPlaceholder(arguments[2])"})
        public org.jruby.truffle.runtime.core.RubyArray initialize(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object sizeObject, Object defaultValue, UndefinedPlaceholder block) {
            int size;
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((size = this.toIntNode.executeInt(frame, sizeObject)) < 0) {
                return this.initializeNegative(array, size, defaultValue, UndefinedPlaceholder.INSTANCE);
            }
            return this.initialize(array, size, defaultValue, UndefinedPlaceholder.INSTANCE);
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[2])", "!isNegative"})
        public Object initialize(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int size, Object defaultValue, RubyProc block) {
            return this.initialize(frame, array, size, UndefinedPlaceholder.INSTANCE, block);
        }

        @Specialization(guards={"!isUndefinedPlaceholder(arguments[2])", "isNegative"})
        public Object initializeNegative(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int size, Object defaultValue, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isNegative"})
        public Object initialize(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int size, UndefinedPlaceholder defaultValue, RubyProc block) {
            int n;
            Object store = this.arrayBuilder.start();
            int count = 0;
            try {
                for (n = 0; n < size; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count;
                    }
                    this.arrayBuilder.ensure(store, n + 1);
                    store = this.arrayBuilder.append(store, n, this.yield(frame, block, n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
                array.setStore(this.arrayBuilder.finish(store, n), n);
            }
            return array;
        }

        @Specialization(guards={"isNegative"})
        public Object initializeNegative(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int size, UndefinedPlaceholder defaultValue, RubyProc block) {
            CompilerDirectives.transferToInterpreter();
            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative array size", this));
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray copy, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            InitializeNode.notDesignedForCompilation();
            array.setStore(copy.slowToArray(), copy.getSize());
            return array;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray initialize(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray copy, UndefinedPlaceholder defaultValue, RubyProc block) {
            InitializeNode.notDesignedForCompilation();
            array.setStore(copy.slowToArray(), copy.getSize());
            return array;
        }
    }

    @CoreMethod(names={"include?"}, required=1)
    public static abstract class IncludeNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode;

        public IncludeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        public IncludeNode(IncludeNode prev) {
            super(prev);
            this.equalNode = prev.equalNode;
        }

        @Specialization(guards={"isNull"})
        public boolean includeNull(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            return false;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public boolean includeIntegerFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            int[] store = (int[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                Integer stored = store[n];
                IncludeNode.notDesignedForCompilation();
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isLongFixnum"})
        public boolean includeLongFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            long[] store = (long[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                Long stored = store[n];
                IncludeNode.notDesignedForCompilation();
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isFloat"})
        public boolean includeFloat(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            double[] store = (double[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                Double stored = store[n];
                IncludeNode.notDesignedForCompilation();
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isObject"})
        public boolean includeObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            Object[] store = (Object[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                Object stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value)) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"each_with_index"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class EachWithIndexNode
    extends YieldingCoreMethodNode {
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public EachWithIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachWithIndexNode(EachWithIndexNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public org.jruby.truffle.runtime.core.RubyArray eachWithEmpty(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object eachWithIndexInt(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int[] store = (int[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n], n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongFixnum"})
        public Object eachWithIndexLong(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            long[] store = (long[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n], n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isFloat"})
        public Object eachWithIndexDouble(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            double[] store = (double[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n], n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object eachWithIndexObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n], n);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        @Specialization
        public Object eachWithIndexObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder block) {
            return this.ruby(frame, "to_enum(:each_with_index)", new Object[0]);
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode toEnumNode;
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();
        private final RubySymbol eachSymbol;

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachSymbol = this.getContext().getSymbol("each");
        }

        public EachNode(EachNode prev) {
            super(prev);
            this.toEnumNode = prev.toEnumNode;
            this.eachSymbol = prev.eachSymbol;
        }

        @Specialization
        public Object eachEnumerator(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, UndefinedPlaceholder block) {
            if (this.toEnumNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toEnumNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            return this.toEnumNode.call(frame, array, "to_enum", null, this.eachSymbol);
        }

        @Specialization(guards={"isNull"})
        public Object eachNull(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            return this.nil();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object eachIntegerFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            int[] store = (int[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n]);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongFixnum"})
        public Object eachLongFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            long[] store = (long[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n]);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isFloat"})
        public Object eachFloat(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            double[] store = (double[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n]);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object eachObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            int count = 0;
            try {
                block6: for (int n = 0; n < array.getSize(); ++n) {
                    while (true) {
                        if (CompilerDirectives.inInterpreter()) {
                            ++count;
                        }
                        try {
                            this.yield(frame, block, store[n]);
                            continue block6;
                        }
                        catch (NextException e) {
                            this.nextProfile.enter();
                            continue block6;
                        }
                        catch (RedoException e) {
                            this.redoProfile.enter();
                            continue;
                        }
                        break;
                    }
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count);
                }
            }
            return array;
        }
    }

    @CoreMethod(names={"delete_at"}, required=1, raiseIfFrozenSelf=true)
    @ImportGuards(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="index")})
    public static abstract class DeleteAtNode
    extends RubyNode {
        private final BranchProfile tooSmallBranch = BranchProfile.create();
        private final BranchProfile beyondEndBranch = BranchProfile.create();

        public DeleteAtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DeleteAtNode(DeleteAtNode prev) {
            super(prev);
        }

        @CreateCast(value={"index"})
        public RubyNode coerceOtherToInt(RubyNode index) {
            return ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), index);
        }

        @Specialization(guards={"isIntegerFixnum"}, rewriteOn={UnexpectedResultException.class})
        public int deleteAtIntegerFixnumInBounds(org.jruby.truffle.runtime.core.RubyArray array, int index) throws UnexpectedResultException {
            int normalizedIndex = array.normalizeIndex(index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= array.getSize()) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            int[] store = (int[])array.getStore();
            int value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, array.getSize() - normalizedIndex - 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"deleteAtIntegerFixnumInBounds"}, guards={"isIntegerFixnum"})
        public Object deleteAtIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, int index) {
            DeleteAtNode.notDesignedForCompilation();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = array.getSize() + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= array.getSize()) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            int[] store = (int[])array.getStore();
            int value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, array.getSize() - normalizedIndex - 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isLongFixnum"}, rewriteOn={UnexpectedResultException.class})
        public long deleteAtLongFixnumInBounds(org.jruby.truffle.runtime.core.RubyArray array, int index) throws UnexpectedResultException {
            int normalizedIndex = array.normalizeIndex(index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= array.getSize()) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            long[] store = (long[])array.getStore();
            long value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, array.getSize() - normalizedIndex - 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"deleteAtLongFixnumInBounds"}, guards={"isLongFixnum"})
        public Object deleteAtLongFixnum(org.jruby.truffle.runtime.core.RubyArray array, int index) {
            DeleteAtNode.notDesignedForCompilation();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = array.getSize() + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= array.getSize()) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            long[] store = (long[])array.getStore();
            long value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, array.getSize() - normalizedIndex - 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isFloat"}, rewriteOn={UnexpectedResultException.class})
        public double deleteAtFloatInBounds(org.jruby.truffle.runtime.core.RubyArray array, int index) throws UnexpectedResultException {
            int normalizedIndex = array.normalizeIndex(index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= array.getSize()) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            double[] store = (double[])array.getStore();
            double value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, array.getSize() - normalizedIndex - 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"deleteAtFloatInBounds"}, guards={"isFloat"})
        public Object deleteAtFloat(org.jruby.truffle.runtime.core.RubyArray array, int index) {
            DeleteAtNode.notDesignedForCompilation();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = array.getSize() + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= array.getSize()) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            double[] store = (double[])array.getStore();
            double value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, array.getSize() - normalizedIndex - 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isObject"}, rewriteOn={UnexpectedResultException.class})
        public Object deleteAtObjectInBounds(org.jruby.truffle.runtime.core.RubyArray array, int index) throws UnexpectedResultException {
            int normalizedIndex = array.normalizeIndex(index);
            if (normalizedIndex < 0) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            if (normalizedIndex >= array.getSize()) {
                throw new UnexpectedResultException((Object)this.nil());
            }
            Object[] store = (Object[])array.getStore();
            Object value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, array.getSize() - normalizedIndex - 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(contains={"deleteAtObjectInBounds"}, guards={"isObject"})
        public Object deleteAtObject(org.jruby.truffle.runtime.core.RubyArray array, int index) {
            DeleteAtNode.notDesignedForCompilation();
            int normalizedIndex = index;
            if (normalizedIndex < 0) {
                normalizedIndex = array.getSize() + index;
            }
            if (normalizedIndex < 0) {
                this.tooSmallBranch.enter();
                return this.nil();
            }
            if (normalizedIndex >= array.getSize()) {
                this.beyondEndBranch.enter();
                return this.nil();
            }
            Object[] store = (Object[])array.getStore();
            Object value = store[normalizedIndex];
            System.arraycopy(store, normalizedIndex + 1, store, normalizedIndex, array.getSize() - normalizedIndex - 1);
            array.setStore(store, array.getSize() - 1);
            return value;
        }

        @Specialization(guards={"isNullOrEmpty"})
        public Object deleteAtNullOrEmpty(org.jruby.truffle.runtime.core.RubyArray array, int index) {
            return this.nil();
        }
    }

    @CoreMethod(names={"delete"}, required=1)
    public static abstract class DeleteNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode;
        @Node.Child
        private IsFrozenNode isFrozenNode;

        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        public DeleteNode(DeleteNode prev) {
            super(prev);
            this.equalNode = prev.equalNode;
            this.isFrozenNode = prev.isFrozenNode;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public Object deleteIntegerFixnum(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            int n;
            int[] store = (int[])array.getStore();
            Object found = this.nil();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                Integer stored = store[n];
                if (this.equalNode.executeSameOrEqual(frame, stored, value)) {
                    if (this.isFrozenNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeFactory.create(this.getContext(), this.getSourceSection(), null));
                    }
                    if (this.isFrozenNode.executeIsFrozen(array)) {
                        CompilerDirectives.transferToInterpreter();
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().frozenError(array.getLogicalClass().getName(), this));
                    }
                    found = store[n];
                    continue;
                }
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                array.setStore(store, i);
            }
            return found;
        }

        @Specialization(guards={"isObject"})
        public Object deleteObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            int n;
            Object[] store = (Object[])array.getStore();
            Object found = this.nil();
            int i = 0;
            for (n = 0; n < array.getSize(); ++n) {
                Object stored = store[n];
                if (this.equalNode.executeSameOrEqual(frame, stored, value)) {
                    if (this.isFrozenNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.isFrozenNode = (IsFrozenNode)this.insert(IsFrozenNodeFactory.create(this.getContext(), this.getSourceSection(), null));
                    }
                    if (this.isFrozenNode.executeIsFrozen(array)) {
                        CompilerDirectives.transferToInterpreter();
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().frozenError(array.getLogicalClass().getName(), this));
                    }
                    found = store[n];
                    continue;
                }
                if (i != n) {
                    store[i] = store[n];
                }
                ++i;
            }
            if (i != n) {
                array.setStore(store, i);
            }
            return found;
        }

        @Specialization(guards={"isNullArray"})
        public Object deleteNull(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object value) {
            return this.nil();
        }
    }

    @CoreMethod(names={"concat"}, required=1, raiseIfFrozenSelf=true)
    @ImportGuards(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="other")})
    public static abstract class ConcatNode
    extends RubyNode {
        public ConcatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConcatNode(ConcatNode prev) {
            super(prev);
        }

        public abstract org.jruby.truffle.runtime.core.RubyArray executeConcat(org.jruby.truffle.runtime.core.RubyArray var1, org.jruby.truffle.runtime.core.RubyArray var2);

        @CreateCast(value={"other"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeFactory.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"areBothNull"})
        public org.jruby.truffle.runtime.core.RubyArray concatNull(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            return array;
        }

        @Specialization(guards={"areBothIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray concatIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            ConcatNode.notDesignedForCompilation();
            int newSize = array.getSize() + other.getSize();
            int[] store = (int[])array.getStore();
            if (store.length < newSize) {
                store = Arrays.copyOf((int[])array.getStore(), ArrayUtils.capacity(store.length, newSize));
            }
            System.arraycopy(other.getStore(), 0, store, array.getSize(), other.getSize());
            array.setStore(store, newSize);
            return array;
        }

        @Specialization(guards={"areBothLongFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray concatLongFixnum(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            ConcatNode.notDesignedForCompilation();
            int newSize = array.getSize() + other.getSize();
            long[] store = (long[])array.getStore();
            if (store.length < newSize) {
                store = Arrays.copyOf((long[])array.getStore(), ArrayUtils.capacity(store.length, newSize));
            }
            System.arraycopy(other.getStore(), 0, store, array.getSize(), other.getSize());
            array.setStore(store, newSize);
            return array;
        }

        @Specialization(guards={"areBothFloat"})
        public org.jruby.truffle.runtime.core.RubyArray concatDouble(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            ConcatNode.notDesignedForCompilation();
            int newSize = array.getSize() + other.getSize();
            double[] store = (double[])array.getStore();
            if (store.length < newSize) {
                store = Arrays.copyOf((double[])array.getStore(), ArrayUtils.capacity(store.length, newSize));
            }
            System.arraycopy(other.getStore(), 0, store, array.getSize(), other.getSize());
            array.setStore(store, newSize);
            return array;
        }

        @Specialization(guards={"areBothObject"})
        public org.jruby.truffle.runtime.core.RubyArray concatObject(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            ConcatNode.notDesignedForCompilation();
            int size = array.getSize();
            int newSize = size + other.getSize();
            Object[] store = (Object[])array.getStore();
            if (newSize > store.length) {
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
            }
            System.arraycopy(other.getStore(), 0, store, size, other.getSize());
            array.setStore(store, newSize);
            return array;
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray concat(org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray other) {
            Object[] store;
            ConcatNode.notDesignedForCompilation();
            int newSize = array.getSize() + other.getSize();
            if (array.getStore() instanceof Object[]) {
                store = (Object[])array.getStore();
                if (store.length < newSize) {
                    store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                }
                ArrayUtils.copy(other.getStore(), store, array.getSize(), other.getSize());
            } else {
                store = new Object[newSize];
                ArrayUtils.copy(array.getStore(), store, 0, array.getSize());
                ArrayUtils.copy(other.getStore(), store, array.getSize(), other.getSize());
            }
            array.setStore(store, newSize);
            return array;
        }
    }

    @CoreMethod(names={"compact!"}, raiseIfFrozenSelf=true)
    public static abstract class CompactBangNode
    extends ArrayCoreMethodNode {
        public CompactBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompactBangNode(CompactBangNode prev) {
            super(prev);
        }

        @Specialization(guards={"!isObject"})
        public RubyNilClass compactNotObjects(org.jruby.truffle.runtime.core.RubyArray array) {
            return this.nil();
        }

        @Specialization(guards={"isObject"})
        public Object compactObjects(org.jruby.truffle.runtime.core.RubyArray array) {
            Object[] store = (Object[])array.getStore();
            int size = array.getSize();
            int m = 0;
            for (int n = 0; n < size; ++n) {
                if (store[n] == this.nil()) continue;
                store[m] = store[n];
                ++m;
            }
            array.setStore(store, m);
            if (m == size) {
                return this.nil();
            }
            return array;
        }
    }

    @CoreMethod(names={"compact"})
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class CompactNode
    extends ArrayCoreMethodNode {
        public CompactNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompactNode(CompactNode prev) {
            super(prev);
        }

        @Specialization(guards={"isIntArray"})
        public org.jruby.truffle.runtime.core.RubyArray compactInt(org.jruby.truffle.runtime.core.RubyArray array) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((int[])array.getStore(), array.getSize()), array.getSize());
        }

        @Specialization(guards={"isLongArray"})
        public org.jruby.truffle.runtime.core.RubyArray compactLong(org.jruby.truffle.runtime.core.RubyArray array) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((long[])array.getStore(), array.getSize()), array.getSize());
        }

        @Specialization(guards={"isDoubleArray"})
        public org.jruby.truffle.runtime.core.RubyArray compactDouble(org.jruby.truffle.runtime.core.RubyArray array) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((double[])array.getStore(), array.getSize()), array.getSize());
        }

        @Specialization(guards={"isObjectArray"})
        public Object compactObjects(org.jruby.truffle.runtime.core.RubyArray array) {
            Object[] store = (Object[])array.getStore();
            Object[] newStore = new Object[store.length];
            int size = array.getSize();
            int m = 0;
            for (int n = 0; n < size; ++n) {
                if (store[n] == this.nil()) continue;
                newStore[m] = store[n];
                ++m;
            }
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), newStore, m);
        }

        @Specialization(guards={"isNullArray"})
        public Object compactNull(org.jruby.truffle.runtime.core.RubyArray array) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
        }
    }

    @CoreMethod(names={"clear"}, raiseIfFrozenSelf=true)
    public static abstract class ClearNode
    extends ArrayCoreMethodNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClearNode(ClearNode prev) {
            super(prev);
        }

        @Specialization
        public org.jruby.truffle.runtime.core.RubyArray clear(org.jruby.truffle.runtime.core.RubyArray array) {
            array.setStore(array.getStore(), 0);
            return array;
        }
    }

    @CoreMethod(names={"at"}, required=1)
    @NodeChildren(value={@NodeChild(value="array"), @NodeChild(value="index")})
    public static abstract class AtNode
    extends RubyNode {
        @Node.Child
        private ArrayReadDenormalizedNode readNode;

        public AtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AtNode(AtNode prev) {
            super(prev);
            this.readNode = prev.readNode;
        }

        @CreateCast(value={"index"})
        public RubyNode coerceOtherToInt(RubyNode index) {
            return new FixnumLowerNode(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), index));
        }

        @Specialization
        public Object at(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int index) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNode = (ArrayReadDenormalizedNode)this.insert(ArrayReadDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.readNode.executeRead(frame, array, index);
        }
    }

    @CoreMethod(names={"[]="}, required=2, optional=1, lowerFixnumParameters={0}, raiseIfFrozenSelf=true)
    public static abstract class IndexSetNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private ArrayWriteDenormalizedNode writeNode;
        @Node.Child
        protected ArrayReadSliceDenormalizedNode readSliceNode;
        @Node.Child
        private PopNode popNode;
        @Node.Child
        private ToIntNode toIntNode;
        private final BranchProfile tooSmallBranch = BranchProfile.create();

        public IndexSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IndexSetNode(IndexSetNode prev) {
            super(prev);
            this.writeNode = prev.writeNode;
            this.readSliceNode = prev.readSliceNode;
            this.popNode = prev.popNode;
            this.toIntNode = prev.toIntNode;
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isIntegerFixnumRange(arguments[1])"})
        public Object set(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object indexObject, Object value, UndefinedPlaceholder unused) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            int index = this.toIntNode.executeInt(frame, indexObject);
            return this.set(frame, array, index, value, unused);
        }

        @Specialization
        public Object set(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int index, Object value, UndefinedPlaceholder unused) {
            int normalizedIndex = array.normalizeIndex(index);
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "index " + index + " too small for array; minimum: " + Integer.toString(-array.getSize());
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            if (this.writeNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.writeNode.executeWrite(frame, array, index, value);
        }

        @Specialization(guards={"!isRubyArray(arguments[3])", "!isUndefinedPlaceholder(arguments[3])", "!isInteger(arguments[2])"})
        public Object setObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int start, Object lengthObject, Object value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            int length = this.toIntNode.executeInt(frame, lengthObject);
            return this.setObject(frame, array, start, length, value);
        }

        @Specialization(guards={"!isRubyArray(arguments[3])", "!isUndefinedPlaceholder(arguments[3])", "!isInteger(arguments[1])"})
        public Object setObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object startObject, int length, Object value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            int start = this.toIntNode.executeInt(frame, startObject);
            return this.setObject(frame, array, start, length, value);
        }

        @Specialization(guards={"!isRubyArray(arguments[3])", "!isUndefinedPlaceholder(arguments[3])", "!isInteger(arguments[1])", "!isInteger(arguments[2])"})
        public Object setObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object startObject, Object lengthObject, Object value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            int length = this.toIntNode.executeInt(frame, lengthObject);
            int start = this.toIntNode.executeInt(frame, startObject);
            return this.setObject(frame, array, start, length, value);
        }

        @Specialization(guards={"!isRubyArray(arguments[3])", "!isUndefinedPlaceholder(arguments[3])"})
        public Object setObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int start, int length, Object value) {
            IndexSetNode.notDesignedForCompilation();
            if (length < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "negative length (" + length + ")";
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            int normalizedIndex = array.normalizeIndex(start);
            if (normalizedIndex < 0) {
                CompilerDirectives.transferToInterpreter();
                String errMessage = "index " + start + " too small for array; minimum: " + Integer.toString(-array.getSize());
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
            }
            int begin = array.normalizeIndex(start);
            if (begin < array.getSize() && length == 1) {
                if (this.writeNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                return this.writeNode.executeWrite(frame, array, begin, value);
            }
            if (array.getSize() > begin + length) {
                if (this.readSliceNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.readSliceNode = (ArrayReadSliceDenormalizedNode)this.insert(ArrayReadSliceDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                org.jruby.truffle.runtime.core.RubyArray endValues = (org.jruby.truffle.runtime.core.RubyArray)this.readSliceNode.executeReadSlice(frame, array, begin + length, array.getSize() - begin - length);
                if (this.writeNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                this.writeNode.executeWrite(frame, array, begin, value);
                Object[] endValuesStore = ArrayUtils.box(endValues.getStore());
                int i = begin + 1;
                for (Object obj : endValuesStore) {
                    this.writeNode.executeWrite(frame, array, i, obj);
                    ++i;
                }
            } else {
                this.writeNode.executeWrite(frame, array, begin, value);
            }
            if (this.popNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.popNode = (PopNode)this.insert(ArrayNodesFactory.PopNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
            }
            int popLength = length - 1 < array.getSize() ? length - 1 : array.getSize() - 1;
            for (int i = 0; i < popLength; ++i) {
                this.popNode.executePop(frame, array, UndefinedPlaceholder.INSTANCE);
            }
            return value;
        }

        @Specialization(guards={"!isInteger(arguments[1])"})
        public Object setOtherArray(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object startObject, int length, org.jruby.truffle.runtime.core.RubyArray value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            int start = this.toIntNode.executeInt(frame, startObject);
            return this.setOtherArray(frame, array, start, length, value);
        }

        @Specialization(guards={"!isInteger(arguments[2])"})
        public Object setOtherArray(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int start, Object lengthObject, org.jruby.truffle.runtime.core.RubyArray value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            int length = this.toIntNode.executeInt(frame, lengthObject);
            return this.setOtherArray(frame, array, start, length, value);
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isInteger(arguments[2])"})
        public Object setOtherArray(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object startObject, Object lengthObject, org.jruby.truffle.runtime.core.RubyArray value) {
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            int start = this.toIntNode.executeInt(frame, startObject);
            int length = this.toIntNode.executeInt(frame, lengthObject);
            return this.setOtherArray(frame, array, start, length, value);
        }

        @Specialization
        public Object setOtherArray(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int start, int length, org.jruby.truffle.runtime.core.RubyArray value) {
            block15: {
                Object[] endValuesStore;
                int popNum;
                Object[] values;
                int begin;
                block14: {
                    IndexSetNode.notDesignedForCompilation();
                    if (length < 0) {
                        CompilerDirectives.transferToInterpreter();
                        String errMessage = "negative length (" + length + ")";
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
                    }
                    int normalizedIndex = array.normalizeIndex(start);
                    if (normalizedIndex < 0) {
                        CompilerDirectives.transferToInterpreter();
                        String errMessage = "index " + start + " too small for array; minimum: " + Integer.toString(-array.getSize());
                        throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexError(errMessage, this));
                    }
                    begin = array.normalizeIndex(start);
                    if (value.getSize() == 0) {
                        int exclusiveEnd = begin + length;
                        Object[] store = ArrayUtils.box(array.getStore());
                        if (begin < 0) {
                            this.tooSmallBranch.enter();
                            CompilerDirectives.transferToInterpreter();
                            throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().indexTooSmallError("array", start, array.getSize(), this));
                        }
                        if (exclusiveEnd > array.getSize()) {
                            throw new UnsupportedOperationException();
                        }
                        System.arraycopy(store, exclusiveEnd, store, begin, array.getSize() - exclusiveEnd);
                        array.setStore(store, array.getSize() - length);
                        return value;
                    }
                    if (this.writeNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.writeNode = (ArrayWriteDenormalizedNode)this.insert(ArrayWriteDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
                    }
                    values = ArrayUtils.box(value.getStore());
                    if (value.getSize() != length && begin + length + 1 <= array.getSize()) break block14;
                    int i = begin;
                    for (Object obj : values) {
                        this.writeNode.executeWrite(frame, array, i, obj);
                        ++i;
                    }
                    break block15;
                }
                if (this.readSliceNode == null) {
                    CompilerDirectives.transferToInterpreter();
                    this.readSliceNode = (ArrayReadSliceDenormalizedNode)this.insert(ArrayReadSliceDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
                }
                int newLength = length + begin > array.getSize() ? begin + values.length : array.getSize() + values.length - length;
                int n = popNum = newLength < array.getSize() ? array.getSize() - newLength : 0;
                if (popNum > 0) {
                    if (this.popNode == null) {
                        CompilerDirectives.transferToInterpreter();
                        this.popNode = (PopNode)this.insert(ArrayNodesFactory.PopNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null}));
                    }
                    for (int i = 0; i < popNum; ++i) {
                        this.popNode.executePop(frame, array, UndefinedPlaceholder.INSTANCE);
                    }
                }
                int readLen = newLength - values.length - begin;
                org.jruby.truffle.runtime.core.RubyArray endValues = null;
                if (readLen > 0) {
                    endValues = (org.jruby.truffle.runtime.core.RubyArray)this.readSliceNode.executeReadSlice(frame, array, array.getSize() - readLen, readLen);
                }
                int i = begin;
                for (Object obj : values) {
                    this.writeNode.executeWrite(frame, array, i, obj);
                    ++i;
                }
                if (readLen <= 0) break block15;
                for (Object obj : endValuesStore = ArrayUtils.box(endValues.getStore())) {
                    this.writeNode.executeWrite(frame, array, i, obj);
                    ++i;
                }
            }
            return value;
        }

        @Specialization(guards={"!isRubyArray(arguments[2])"})
        public Object setRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyRange.IntegerFixnumRange range, Object other, UndefinedPlaceholder unused) {
            int normalizedEnd;
            int normalizedStart = array.normalizeIndex(range.getBegin());
            int n = normalizedEnd = range.doesExcludeEnd() ? array.normalizeIndex(range.getEnd()) - 1 : array.normalizeIndex(range.getEnd());
            if (normalizedEnd < 0) {
                normalizedEnd = -1;
            }
            int length = normalizedEnd - normalizedStart + 1;
            if (normalizedStart < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(range, (Node)this));
            }
            return this.setObject(frame, array, normalizedStart, length, other);
        }

        @Specialization(guards={"!areBothIntegerFixnum"})
        public Object setRangeArray(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyRange.IntegerFixnumRange range, org.jruby.truffle.runtime.core.RubyArray other, UndefinedPlaceholder unused) {
            int normalizedEnd;
            int normalizedStart = array.normalizeIndex(range.getBegin());
            if (normalizedStart < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().rangeError(range, (Node)this));
            }
            int n = normalizedEnd = range.doesExcludeEnd() ? array.normalizeIndex(range.getEnd()) - 1 : array.normalizeIndex(range.getEnd());
            if (normalizedEnd < 0) {
                normalizedEnd = -1;
            }
            int length = normalizedEnd - normalizedStart + 1;
            return this.setOtherArray(frame, array, normalizedStart, length, other);
        }

        @Specialization(guards={"areBothIntegerFixnum"})
        public Object setIntegerFixnumRange(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyRange.IntegerFixnumRange range, org.jruby.truffle.runtime.core.RubyArray other, UndefinedPlaceholder unused) {
            if (range.doesExcludeEnd()) {
                CompilerDirectives.transferToInterpreter();
                return this.setRangeArray(frame, array, range, other, unused);
            }
            int normalizedBegin = array.normalizeIndex(range.getBegin());
            int normalizedEnd = array.normalizeIndex(range.getEnd());
            if (normalizedEnd < 0) {
                normalizedEnd = -1;
            }
            if (normalizedBegin != 0 || normalizedEnd != array.getSize() - 1) {
                CompilerDirectives.transferToInterpreter();
                return this.setRangeArray(frame, array, range, other, unused);
            }
            array.setStore(Arrays.copyOf((int[])other.getStore(), other.getSize()), other.getSize());
            return other;
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1})
    public static abstract class IndexNode
    extends ArrayCoreMethodNode {
        @Node.Child
        protected ArrayReadDenormalizedNode readNode;
        @Node.Child
        protected ArrayReadSliceDenormalizedNode readSliceNode;
        @Node.Child
        protected ArrayReadSliceNormalizedNode readNormalizedSliceNode;
        @Node.Child
        protected CallDispatchHeadNode fallbackNode;

        public IndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IndexNode(IndexNode prev) {
            super(prev);
            this.readNode = prev.readNode;
            this.readSliceNode = prev.readSliceNode;
            this.readNormalizedSliceNode = prev.readNormalizedSliceNode;
            this.fallbackNode = prev.fallbackNode;
        }

        @Specialization
        public Object index(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int index, UndefinedPlaceholder undefined) {
            if (this.readNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNode = (ArrayReadDenormalizedNode)this.insert(ArrayReadDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
            }
            return this.readNode.executeRead(frame, array, index);
        }

        @Specialization
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, int start, int length) {
            if (length < 0) {
                return this.nil();
            }
            if (this.readSliceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readSliceNode = (ArrayReadSliceDenormalizedNode)this.insert(ArrayReadSliceDenormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.readSliceNode.executeReadSlice(frame, array, start, length);
        }

        @Specialization
        public Object slice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, RubyRange.IntegerFixnumRange range, UndefinedPlaceholder undefined) {
            int normalizedIndex = array.normalizeIndex(range.getBegin());
            if (normalizedIndex < 0 || normalizedIndex > array.getSize()) {
                return this.nil();
            }
            int end = array.normalizeIndex(range.getEnd());
            int exclusiveEnd = array.clampExclusiveIndex(range.doesExcludeEnd() ? end : end + 1);
            if (exclusiveEnd <= normalizedIndex) {
                return new org.jruby.truffle.runtime.core.RubyArray(array.getLogicalClass(), null, 0);
            }
            int length = exclusiveEnd - normalizedIndex;
            if (this.readNormalizedSliceNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.readNormalizedSliceNode = (ArrayReadSliceNormalizedNode)this.insert(ArrayReadSliceNormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null, null));
            }
            return this.readNormalizedSliceNode.executeReadSlice(frame, array, normalizedIndex, length);
        }

        @Specialization(guards={"!isInteger(arguments[1])", "!isIntegerFixnumRange(arguments[1])"})
        public Object fallbackIndex(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object a, UndefinedPlaceholder undefined) {
            return this.fallback(frame, array, org.jruby.truffle.runtime.core.RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), a));
        }

        @Specialization(guards={"!isIntegerFixnumRange(arguments[1])", "!isUndefinedPlaceholder(arguments[2])"})
        public Object fallbackSlice(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object a, Object b) {
            return this.fallback(frame, array, org.jruby.truffle.runtime.core.RubyArray.fromObjects(this.getContext().getCoreLibrary().getArrayClass(), a, b));
        }

        public Object fallback(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyArray args) {
            if (this.fallbackNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.fallbackNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
            }
            InternalMethod method = RubyArguments.getMethod(frame.getArguments());
            return this.fallbackNode.call(frame, array, "element_reference_fallback", null, this.getContext().makeString(method.getName()), args);
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0}, taintFromSelf=true)
    public static abstract class MulNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.RespondToNode respondToToStrNode;
        @Node.Child
        private ToIntNode toIntNode;

        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
            this.respondToToStrNode = prev.respondToToStrNode;
            this.toIntNode = prev.toIntNode;
        }

        @Specialization(guards={"isNull"})
        public org.jruby.truffle.runtime.core.RubyArray mulEmpty(org.jruby.truffle.runtime.core.RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            return new org.jruby.truffle.runtime.core.RubyArray(array.getLogicalClass());
        }

        @Specialization(guards={"isIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray mulIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            int[] store = (int[])array.getStore();
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            int[] newStore = new int[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return new org.jruby.truffle.runtime.core.RubyArray(array.getLogicalClass(), array.getAllocationSite(), newStore, newStoreLength);
        }

        @Specialization(guards={"isLongFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray mulLongFixnum(org.jruby.truffle.runtime.core.RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            long[] store = (long[])array.getStore();
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            long[] newStore = new long[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return new org.jruby.truffle.runtime.core.RubyArray(array.getLogicalClass(), array.getAllocationSite(), newStore, newStoreLength);
        }

        @Specialization(guards={"isFloat"})
        public org.jruby.truffle.runtime.core.RubyArray mulFloat(org.jruby.truffle.runtime.core.RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            double[] store = (double[])array.getStore();
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            double[] newStore = new double[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return new org.jruby.truffle.runtime.core.RubyArray(array.getLogicalClass(), array.getAllocationSite(), newStore, newStoreLength);
        }

        @Specialization(guards={"isObject"})
        public org.jruby.truffle.runtime.core.RubyArray mulObject(org.jruby.truffle.runtime.core.RubyArray array, int count) {
            if (count < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            Object[] store = (Object[])array.getStore();
            int storeLength = store.length;
            int newStoreLength = storeLength * count;
            Object[] newStore = new Object[newStoreLength];
            for (int n = 0; n < count; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return new org.jruby.truffle.runtime.core.RubyArray(array.getLogicalClass(), array.getAllocationSite(), newStore, newStoreLength);
        }

        @Specialization(guards={"isRubyString(arguments[1])"})
        public Object mulObject(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, org.jruby.truffle.runtime.core.RubyString string) {
            MulNode.notDesignedForCompilation();
            return this.ruby(frame, "join(sep)", "sep", string);
        }

        @Specialization(guards={"!isRubyString(arguments[1])"})
        public Object mulObjectCount(VirtualFrame frame, org.jruby.truffle.runtime.core.RubyArray array, Object object) {
            int count;
            MulNode.notDesignedForCompilation();
            if (this.respondToToStrNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.respondToToStrNode = (KernelNodes.RespondToNode)this.insert(KernelNodesFactory.RespondToNodeFactory.create(this.getContext(), this.getSourceSection(), new RubyNode[]{null, null, null}));
            }
            if (this.respondToToStrNode.doesRespondTo(frame, object, this.getContext().makeString("to_str"), false)) {
                return this.ruby(frame, "join(sep.to_str)", "sep", object);
            }
            if (this.toIntNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.toIntNode = (ToIntNode)this.insert(ToIntNodeFactory.create(this.getContext(), this.getSourceSection(), null));
            }
            if ((count = this.toIntNode.executeInt(frame, object)) < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new org.jruby.truffle.runtime.control.RaiseException(this.getContext().getCoreLibrary().argumentError("negative argument", this));
            }
            if (array.getStore() instanceof int[]) {
                return this.mulIntegerFixnum(array, count);
            }
            if (array.getStore() instanceof long[]) {
                return this.mulLongFixnum(array, count);
            }
            if (array.getStore() instanceof double[]) {
                return this.mulFloat(array, count);
            }
            if (array.getStore() == null) {
                return this.mulEmpty(array, count);
            }
            return this.mulObject(array, count);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    @ImportGuards(value={ArrayGuards.class})
    @NodeChildren(value={@NodeChild(value="a"), @NodeChild(value="b")})
    public static abstract class AddNode
    extends RubyNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
        }

        @CreateCast(value={"b"})
        public RubyNode coerceOtherToAry(RubyNode other) {
            return ToAryNodeFactory.create(this.getContext(), this.getSourceSection(), other);
        }

        @Specialization(guards={"isNull", "isOtherNull"})
        public org.jruby.truffle.runtime.core.RubyArray addNull(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
        }

        @Specialization(guards={"isObject", "isOtherNull"})
        public org.jruby.truffle.runtime.core.RubyArray addObjectNull(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((Object[])a.getStore(), a.getSize()), a.getSize());
        }

        @Specialization(guards={"areBothIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray addBothIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int combinedSize = a.getSize() + b.getSize();
            int[] combined = new int[combinedSize];
            System.arraycopy(a.getStore(), 0, combined, 0, a.getSize());
            System.arraycopy(b.getStore(), 0, combined, a.getSize(), b.getSize());
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"areBothLongFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray addBothLongFixnum(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int combinedSize = a.getSize() + b.getSize();
            long[] combined = new long[combinedSize];
            System.arraycopy(a.getStore(), 0, combined, 0, a.getSize());
            System.arraycopy(b.getStore(), 0, combined, a.getSize(), b.getSize());
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"areBothFloat"})
        public org.jruby.truffle.runtime.core.RubyArray addBothFloat(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int combinedSize = a.getSize() + b.getSize();
            double[] combined = new double[combinedSize];
            System.arraycopy(a.getStore(), 0, combined, 0, a.getSize());
            System.arraycopy(b.getStore(), 0, combined, a.getSize(), b.getSize());
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"areBothObject"})
        public org.jruby.truffle.runtime.core.RubyArray addBothObject(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int combinedSize = a.getSize() + b.getSize();
            Object[] combined = new Object[combinedSize];
            System.arraycopy(a.getStore(), 0, combined, 0, a.getSize());
            System.arraycopy(b.getStore(), 0, combined, a.getSize(), b.getSize());
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"isNull", "isOtherIntegerFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray addNullIntegerFixnum(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int size = b.getSize();
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((int[])b.getStore(), size), size);
        }

        @Specialization(guards={"isNull", "isOtherLongFixnum"})
        public org.jruby.truffle.runtime.core.RubyArray addNullLongFixnum(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int size = b.getSize();
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((long[])b.getStore(), size), size);
        }

        @Specialization(guards={"isNull", "isOtherObject"})
        public org.jruby.truffle.runtime.core.RubyArray addNullObject(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int size = b.getSize();
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((Object[])b.getStore(), size), size);
        }

        @Specialization(guards={"!isObject", "isOtherObject"})
        public org.jruby.truffle.runtime.core.RubyArray addOtherObject(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int combinedSize = a.getSize() + b.getSize();
            Object[] combined = new Object[combinedSize];
            System.arraycopy(ArrayUtils.box(a.getStore()), 0, combined, 0, a.getSize());
            System.arraycopy(b.getStore(), 0, combined, a.getSize(), b.getSize());
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"isObject", "!isOtherObject"})
        public org.jruby.truffle.runtime.core.RubyArray addObject(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int combinedSize = a.getSize() + b.getSize();
            Object[] combined = new Object[combinedSize];
            System.arraycopy(a.getStore(), 0, combined, 0, a.getSize());
            System.arraycopy(ArrayUtils.box(b.getStore()), 0, combined, a.getSize(), b.getSize());
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"isEmpty"})
        public org.jruby.truffle.runtime.core.RubyArray addEmpty(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int size = b.getSize();
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.box(b.getStore()), size);
        }

        @Specialization(guards={"isOtherEmpty"})
        public org.jruby.truffle.runtime.core.RubyArray addOtherEmpty(org.jruby.truffle.runtime.core.RubyArray a, org.jruby.truffle.runtime.core.RubyArray b) {
            int size = a.getSize();
            return new org.jruby.truffle.runtime.core.RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.box(a.getStore()), size);
        }
    }
}

