/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.util.ArrayUtils;

@ImportGuards(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class)})
public abstract class ArrayGetTailNode
extends RubyNode {
    final int index;

    public ArrayGetTailNode(RubyContext context, SourceSection sourceSection, int index) {
        super(context, sourceSection);
        this.index = index;
    }

    public ArrayGetTailNode(ArrayGetTailNode prev) {
        super(prev);
        this.index = prev.index;
    }

    @Specialization(guards={"isNull"})
    public RubyArray getTailNull(RubyArray array) {
        ArrayGetTailNode.notDesignedForCompilation();
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
    }

    @Specialization(guards={"isIntegerFixnum"})
    public RubyArray getTailIntegerFixnum(RubyArray array) {
        ArrayGetTailNode.notDesignedForCompilation();
        if (this.index >= array.getSize()) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((int[])array.getStore(), this.index, array.getSize()), array.getSize() - this.index);
    }

    @Specialization(guards={"isLongFixnum"})
    public RubyArray getTailLongFixnum(RubyArray array) {
        ArrayGetTailNode.notDesignedForCompilation();
        if (this.index >= array.getSize()) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((long[])array.getStore(), this.index, array.getSize()), array.getSize() - this.index);
    }

    @Specialization(guards={"isFloat"})
    public RubyArray getTailFloat(RubyArray array) {
        ArrayGetTailNode.notDesignedForCompilation();
        if (this.index >= array.getSize()) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((double[])array.getStore(), this.index, array.getSize()), array.getSize() - this.index);
    }

    @Specialization(guards={"isObject"})
    public RubyArray getTailObject(RubyArray array) {
        ArrayGetTailNode.notDesignedForCompilation();
        if (this.index >= array.getSize()) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }
        return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((Object[])array.getStore(), this.index, array.getSize()), array.getSize() - this.index);
    }
}

