/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.control.RescueNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;

public class RescueClassesNode
extends RescueNode {
    @Node.Children
    final RubyNode[] handlingClassNodes;

    public RescueClassesNode(RubyContext context, SourceSection sourceSection, RubyNode[] handlingClassNodes, RubyNode body) {
        super(context, sourceSection, body);
        this.handlingClassNodes = handlingClassNodes;
    }

    @Override
    @ExplodeLoop
    public boolean canHandle(VirtualFrame frame, RubyException exception) {
        RescueClassesNode.notDesignedForCompilation();
        RubyClass exceptionRubyClass = exception.getLogicalClass();
        for (RubyNode handlingClassNode : this.handlingClassNodes) {
            RubyClass handlingClass = (RubyClass)handlingClassNode.execute(frame);
            if (!ModuleOperations.assignableTo(exceptionRubyClass, handlingClass)) continue;
            return true;
        }
        return false;
    }
}

