/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.coerce.ToStrNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=ToStrNode.class)
public final class ToStrNodeFactory
extends NodeFactoryBase<ToStrNode> {
    private static ToStrNodeFactory instance;

    private ToStrNodeFactory() {
        super(ToStrNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public ToStrNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ToStrNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ToStrNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return ToStrUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<ToStrNode> getInstance() {
        if (instance == null) {
            instance = new ToStrNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ToStrNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ToStrPolymorphicNode
    extends ToStrBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        ToStrPolymorphicNode(ToStrBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyString value;
            try {
                value = this.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == RubyString.class ? this.child.executeRubyString(frameValue) : this.child.execute(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue, Object childValueEvaluated) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == RubyString.class ? RubyTypesGen.RUBYTYPES.expectRubyString(childValueEvaluated) : childValueEvaluated;
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected RubyString executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=ToStrNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToStrObjectNode
    extends ToStrBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToStrObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

        ToStrObjectNode(ToStrBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyString value;
            try {
                value = this.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue = this.child.execute(frameValue);
            if (!super.isRubyString(childValue)) {
                return super.coerceObject(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubyString] failed");
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue, Object childValueEvaluated) {
            Object childValue = childValueEvaluated;
            if (!super.isRubyString(childValue)) {
                return super.coerceObject(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubyString] failed");
        }

        @Override
        protected RubyString executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!super.isRubyString(childValue)) {
                return super.coerceObject(frameValue, childValue);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToStrNode create0(ToStrNode current) {
            return new ToStrObjectNode((ToStrBaseNode)current);
        }
    }

    @GeneratedBy(value=ToStrNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToStrRubyStringNode
    extends ToStrBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToStrRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

        ToStrRubyStringNode(ToStrBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyString value;
            try {
                value = this.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyString childValue;
            try {
                childValue = this.child.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyString");
            }
            return super.coerceRubyString(childValue);
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue, Object childValueEvaluated) {
            RubyString childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyString(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyString");
            }
            return super.coerceRubyString(childValue);
        }

        @Override
        protected RubyString executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyString(childValue)) {
                RubyString childValueCast = RubyTypesGen.RUBYTYPES.asRubyString(childValue);
                return super.coerceRubyString(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToStrNode create0(ToStrNode current) {
            return new ToStrRubyStringNode((ToStrBaseNode)current);
        }
    }

    @GeneratedBy(value=ToStrNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ToStrUninitializedNode
    extends ToStrBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToStrUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ToStrUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        ToStrUninitializedNode(ToStrBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyString value;
            try {
                value = this.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue, Object childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = childValueEvaluated;
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected RubyString executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected RubyString executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            ToStrBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ToStrBaseNode rootNode = (ToStrBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ToStrBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static ToStrNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new ToStrUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=ToStrNode.class)
    private static abstract class ToStrBaseNode
    extends ToStrNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected ToStrBaseNode next0;

        ToStrBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        ToStrBaseNode(ToStrBaseNode copy) {
            super(copy);
        }

        protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

        protected final RubyString rewrite0(VirtualFrame frameValue, Object childValue, String reason) {
            String message;
            ToStrBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ToStrBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new ToStrUninitializedNode(this);
                ((ToStrUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ToStrBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToStrBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (ToStrBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToStrUninitializedNode(this), (Node)new ToStrPolymorphicNode(this), (DSLNode)((ToStrBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ToStrBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyString(childValue)) {
                return (ToStrBaseNode)ToStrRubyStringNode.create0(this);
            }
            if (!super.isRubyString(childValue)) {
                return (ToStrBaseNode)ToStrObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((ToStrBaseNode)other).child;
            this.next0 = newNext == null ? null : (ToStrBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

