/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.coerce;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.coerce.ToAryNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=ToAryNode.class)
public final class ToAryNodeFactory
extends NodeFactoryBase<ToAryNode> {
    private static ToAryNodeFactory instance;

    private ToAryNodeFactory() {
        super(ToAryNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public ToAryNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ToAryNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ToAryNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return ToAryUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<ToAryNode> getInstance() {
        if (instance == null) {
            instance = new ToAryNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ToAryNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ToAryPolymorphicNode
    extends ToAryBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        ToAryPolymorphicNode(ToAryBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == RubyArray.class ? this.child.executeArray(frameValue) : this.child.execute(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=ToAryNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToAryObjectNode
    extends ToAryBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToAryObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

        ToAryObjectNode(ToAryBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue = this.child.execute(frameValue);
            if (!super.isRubyArray(childValue)) {
                return super.coerceObject(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubyArray] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!super.isRubyArray(childValue)) {
                return super.coerceObject(frameValue, childValue);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToAryNode create0(ToAryNode current) {
            return new ToAryObjectNode((ToAryBaseNode)current);
        }
    }

    @GeneratedBy(value=ToAryNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToAryRubyArrayNode
    extends ToAryBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToAryRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ToAryRubyArrayNode(ToAryBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray childValue;
            try {
                childValue = this.child.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyArray");
            }
            return super.coerceRubyArray(childValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(childValue)) {
                RubyArray childValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(childValue);
                return super.coerceRubyArray(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static ToAryNode create0(ToAryNode current) {
            return new ToAryRubyArrayNode((ToAryBaseNode)current);
        }
    }

    @GeneratedBy(value=ToAryNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ToAryUninitializedNode
    extends ToAryBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToAryUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ToAryUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        ToAryUninitializedNode(ToAryBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            ToAryBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ToAryBaseNode rootNode = (ToAryBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ToAryBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static ToAryNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new ToAryUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=ToAryNode.class)
    private static abstract class ToAryBaseNode
    extends ToAryNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected ToAryBaseNode next0;

        ToAryBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        ToAryBaseNode(ToAryBaseNode copy) {
            super(copy);
        }

        protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

        protected final RubyArray rewrite0(VirtualFrame frameValue, Object childValue, String reason) {
            String message;
            ToAryBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ToAryBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new ToAryUninitializedNode(this);
                ((ToAryUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ToAryBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToAryBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (ToAryBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToAryUninitializedNode(this), (Node)new ToAryPolymorphicNode(this), (DSLNode)((ToAryBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ToAryBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(childValue)) {
                return (ToAryBaseNode)ToAryRubyArrayNode.create0(this);
            }
            if (!super.isRubyArray(childValue)) {
                return (ToAryBaseNode)ToAryObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((ToAryBaseNode)other).child;
            this.next0 = newNext == null ? null : (ToAryBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

