/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.ToSNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyString;

@GeneratedBy(value=ToSNode.class)
public final class ToSNodeFactory
extends NodeFactoryBase<ToSNode> {
    private static ToSNodeFactory instance;

    private ToSNodeFactory() {
        super(ToSNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public ToSNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return ToSNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ToSNode create(RubyContext context, SourceSection sourceSection, RubyNode child0) {
        return ToSUninitializedNode.create0(context, sourceSection, child0);
    }

    public static NodeFactory<ToSNode> getInstance() {
        if (instance == null) {
            instance = new ToSNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ToSNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ToSPolymorphicNode
    extends ToSBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> child0PolymorphicType;

        ToSPolymorphicNode(ToSBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyString(frameValue);
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue) {
            Object child0Value;
            try {
                child0Value = this.child0PolymorphicType == RubyString.class ? this.child0.executeRubyString(frameValue) : this.child0.execute(frameValue);
            }
            catch (UnexpectedResultException ex) {
                this.child0PolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, child0Value);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.child0PolymorphicType = types[0];
        }

        @Override
        protected RubyString executeChained0(VirtualFrame frameValue, Object child0Value) {
            return this.next0.executeChained0(frameValue, child0Value);
        }
    }

    @GeneratedBy(value=ToSNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToSObject1Node
    extends ToSBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToSObject1Node.class, new Class[]{ToSObject0Node.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);

        ToSObject1Node(ToSBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyString(frameValue);
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue) {
            Object child0Value = this.child0.execute(frameValue);
            if (!super.isRubyString(child0Value)) {
                return super.toSFallback(frameValue, child0Value);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, child0Value, "One of guards [!isRubyString] failed");
        }

        @Override
        protected RubyString executeChained0(VirtualFrame frameValue, Object child0Value) {
            if (!super.isRubyString(child0Value)) {
                return super.toSFallback(frameValue, child0Value);
            }
            return this.next0.executeChained0(frameValue, child0Value);
        }

        static ToSNode create0(ToSNode current) {
            return new ToSObject1Node((ToSBaseNode)current);
        }
    }

    @GeneratedBy(value=ToSNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToSObject0Node
    extends ToSBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToSObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{ToSObject1Node.class}, new Class[]{Object.class}, 0, 0);

        ToSObject0Node(ToSBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyString(frameValue);
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue) {
            Object child0Value = this.child0.execute(frameValue);
            if (!super.isRubyString(child0Value)) {
                try {
                    return super.toS(frameValue, child0Value);
                }
                catch (UnexpectedResultException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.rewrite0(frameValue, child0Value, "Thrown UnexpectedResultException");
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, child0Value, "One of guards [!isRubyString] failed");
        }

        @Override
        protected RubyString executeChained0(VirtualFrame frameValue, Object child0Value) {
            if (!super.isRubyString(child0Value)) {
                try {
                    return super.toS(frameValue, child0Value);
                }
                catch (UnexpectedResultException rewriteEx) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    return this.rewrite0(frameValue, child0Value, "Thrown UnexpectedResultException");
                }
            }
            return this.next0.executeChained0(frameValue, child0Value);
        }

        static ToSNode create0(ToSNode current) {
            return new ToSObject0Node((ToSBaseNode)current);
        }
    }

    @GeneratedBy(value=ToSNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ToSRubyStringNode
    extends ToSBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToSRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyString.class}, 0, 0);

        ToSRubyStringNode(ToSBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyString(frameValue);
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue) {
            RubyString child0Value;
            try {
                child0Value = this.child0.executeRubyString(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected child0Value instanceof RubyString");
            }
            return super.toS(child0Value);
        }

        @Override
        protected RubyString executeChained0(VirtualFrame frameValue, Object child0Value) {
            if (RubyTypesGen.RUBYTYPES.isRubyString(child0Value)) {
                RubyString child0ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(child0Value);
                return super.toS(child0ValueCast);
            }
            return this.next0.executeChained0(frameValue, child0Value);
        }

        static ToSNode create0(ToSNode current) {
            return new ToSRubyStringNode((ToSBaseNode)current);
        }
    }

    @GeneratedBy(value=ToSNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ToSUninitializedNode
    extends ToSBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ToSUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ToSUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child0) {
            super(context, sourceSection, child0);
        }

        ToSUninitializedNode(ToSBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeRubyString(frameValue);
        }

        @Override
        public RubyString executeRubyString(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object child0Value = this.child0.execute(frameValue);
            return this.executeUninitialized0(frameValue, child0Value);
        }

        @Override
        protected RubyString executeChained0(VirtualFrame frameValue, Object child0Value) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, child0Value);
        }

        protected RubyString executeUninitialized0(VirtualFrame frameValue, Object child0Value) {
            ToSBaseNode newNode = this.specialize0(child0Value);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ToSBaseNode rootNode = (ToSBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child0}, new Object[]{child0Value});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ToSBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, child0Value);
        }

        static ToSNode create0(RubyContext context, SourceSection sourceSection, RubyNode child0) {
            return new ToSUninitializedNode(context, sourceSection, child0);
        }
    }

    @GeneratedBy(value=ToSNode.class)
    private static abstract class ToSBaseNode
    extends ToSNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child0;
        @Node.Child
        protected ToSBaseNode next0;

        ToSBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child0) {
            super(context, sourceSection);
            this.child0 = child0;
        }

        ToSBaseNode(ToSBaseNode copy) {
            super(copy);
        }

        protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

        protected final RubyString rewrite0(VirtualFrame frameValue, Object child0Value, String reason) {
            String message;
            ToSBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ToSBaseNode newNode = this.specialize0(child0Value);
            if (newNode == null) {
                newNode = new ToSUninitializedNode(this);
                ((ToSUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ToSBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ToSBaseNode.createInfo0(reason, child0Value)))) == null) {
                returnNode = (ToSBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToSUninitializedNode(this), (Node)new ToSPolymorphicNode(this), (DSLNode)((ToSBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, child0Value);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ToSBaseNode specialize0(Object child0Value) {
            if (RubyTypesGen.RUBYTYPES.isRubyString(child0Value)) {
                return (ToSBaseNode)ToSRubyStringNode.create0(this);
            }
            if (!super.isRubyString(child0Value)) {
                if (!DSLShare.isExcluded((Node)this, (DSLMetadata)ToSObject0Node.METADATA)) {
                    return (ToSBaseNode)ToSObject0Node.create0(this);
                }
                return (ToSBaseNode)ToSObject1Node.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child0 = other == null ? null : ((ToSBaseNode)other).child0;
            this.next0 = newNext == null ? null : (ToSBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object child0Value) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("child0Value").append(" = ").append(child0Value);
                if (child0Value != null) {
                    builder.append(" (").append(child0Value.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

