/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.SingleValueCastNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@GeneratedBy(value=SingleValueCastNode.class)
public final class SingleValueCastNodeFactory
extends NodeFactoryBase<SingleValueCastNode> {
    private static SingleValueCastNodeFactory instance;

    private SingleValueCastNodeFactory() {
        super(SingleValueCastNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public SingleValueCastNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return SingleValueCastNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static SingleValueCastNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return SingleValueCastUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<SingleValueCastNode> getInstance() {
        if (instance == null) {
            instance = new SingleValueCastNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=SingleValueCastNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class SingleValueCastPolymorphicNode
    extends SingleValueCastBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        SingleValueCastPolymorphicNode(SingleValueCastBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object childValue = this.child.execute(frameValue);
            return this.next0.executeChained0(childValue);
        }

        @Override
        public Object executeSingleValue(Object[] childValueEvaluated) {
            Object[] childValue = childValueEvaluated;
            return this.next0.executeChained0(childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected Object executeChained0(Object childValue) {
            return this.next0.executeChained0(childValue);
        }
    }

    @GeneratedBy(value=SingleValueCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SingleValueCastRubyArrayNode
    extends SingleValueCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingleValueCastRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

        SingleValueCastRubyArrayNode(SingleValueCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object[] childValue;
            try {
                childValue = this.child.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(ex.getResult(), "Expected childValue instanceof Object[]"));
            }
            if (!super.noArguments(childValue) && !super.singleArgument(childValue)) {
                return super.castMany(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(childValue, "One of guards [!noArguments, !singleArgument] failed"));
        }

        @Override
        public Object executeSingleValue(Object[] childValueEvaluated) {
            Object[] childValue = childValueEvaluated;
            if (!super.noArguments(childValue) && !super.singleArgument(childValue)) {
                return super.castMany(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(childValue, "One of guards [!noArguments, !singleArgument] failed");
        }

        @Override
        protected Object executeChained0(Object childValue) {
            Object[] childValueCast;
            if (RubyTypesGen.RUBYTYPES.isObjectArray(childValue) && !super.noArguments(childValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(childValue)) && !super.singleArgument(childValueCast)) {
                return super.castMany(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static SingleValueCastNode create0(SingleValueCastNode current) {
            return new SingleValueCastRubyArrayNode((SingleValueCastBaseNode)current);
        }
    }

    @GeneratedBy(value=SingleValueCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SingleValueCastObjectNode
    extends SingleValueCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingleValueCastObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

        SingleValueCastObjectNode(SingleValueCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object[] childValue;
            try {
                childValue = this.child.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(ex.getResult(), "Expected childValue instanceof Object[]");
            }
            if (super.singleArgument(childValue)) {
                return super.castSingle(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(childValue, "One of guards [singleArgument] failed");
        }

        @Override
        public Object executeSingleValue(Object[] childValueEvaluated) {
            Object[] childValue = childValueEvaluated;
            if (super.singleArgument(childValue)) {
                return super.castSingle(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(childValue, "One of guards [singleArgument] failed");
        }

        @Override
        protected Object executeChained0(Object childValue) {
            Object[] childValueCast;
            if (RubyTypesGen.RUBYTYPES.isObjectArray(childValue) && super.singleArgument(childValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(childValue))) {
                return super.castSingle(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static SingleValueCastNode create0(SingleValueCastNode current) {
            return new SingleValueCastObjectNode((SingleValueCastBaseNode)current);
        }
    }

    @GeneratedBy(value=SingleValueCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class SingleValueCastRubyNilClassNode
    extends SingleValueCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingleValueCastRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object[].class}, 0, 0);

        SingleValueCastRubyNilClassNode(SingleValueCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value;
            try {
                value = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            Object[] childValue;
            try {
                childValue = this.child.executeObjectArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(ex.getResult(), "Expected childValue instanceof Object[]"));
            }
            if (super.noArguments(childValue)) {
                return super.castNil(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(childValue, "One of guards [noArguments] failed"));
        }

        @Override
        public Object executeSingleValue(Object[] childValueEvaluated) {
            Object[] childValue = childValueEvaluated;
            if (super.noArguments(childValue)) {
                return super.castNil(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(childValue, "One of guards [noArguments] failed");
        }

        @Override
        protected Object executeChained0(Object childValue) {
            Object[] childValueCast;
            if (RubyTypesGen.RUBYTYPES.isObjectArray(childValue) && super.noArguments(childValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(childValue))) {
                return super.castNil(childValueCast);
            }
            return this.next0.executeChained0(childValue);
        }

        static SingleValueCastNode create0(SingleValueCastNode current) {
            return new SingleValueCastRubyNilClassNode((SingleValueCastBaseNode)current);
        }
    }

    @GeneratedBy(value=SingleValueCastNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class SingleValueCastUninitializedNode
    extends SingleValueCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(SingleValueCastUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        SingleValueCastUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        SingleValueCastUninitializedNode(SingleValueCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(childValue);
        }

        @Override
        public Object executeSingleValue(Object[] childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object[] childValue = childValueEvaluated;
            return this.executeUninitialized0(childValue);
        }

        @Override
        protected Object executeChained0(Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(childValue);
        }

        protected Object executeUninitialized0(Object childValue) {
            SingleValueCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                SingleValueCastBaseNode rootNode = (SingleValueCastBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((SingleValueCastBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(childValue);
        }

        static SingleValueCastNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new SingleValueCastUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=SingleValueCastNode.class)
    private static abstract class SingleValueCastBaseNode
    extends SingleValueCastNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected SingleValueCastBaseNode next0;

        SingleValueCastBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        SingleValueCastBaseNode(SingleValueCastBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(Object var1);

        protected final Object rewrite0(Object childValue, String reason) {
            String message;
            SingleValueCastBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            SingleValueCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new SingleValueCastUninitializedNode(this);
                ((SingleValueCastUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (SingleValueCastBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = SingleValueCastBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (SingleValueCastBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SingleValueCastUninitializedNode(this), (Node)new SingleValueCastPolymorphicNode(this), (DSLNode)((SingleValueCastBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final SingleValueCastBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isObjectArray(childValue)) {
                Object[] childValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(childValue);
                if (super.noArguments(childValueCast)) {
                    return (SingleValueCastBaseNode)SingleValueCastRubyNilClassNode.create0(this);
                }
                if (super.singleArgument(childValueCast)) {
                    return (SingleValueCastBaseNode)SingleValueCastObjectNode.create0(this);
                }
                if (!super.noArguments(childValueCast) && !super.singleArgument(childValueCast)) {
                    return (SingleValueCastBaseNode)SingleValueCastRubyArrayNode.create0(this);
                }
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((SingleValueCastBaseNode)other).child;
            this.next0 = newNext == null ? null : (SingleValueCastBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

