/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.NumericToFloatNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=NumericToFloatNode.class)
public final class NumericToFloatNodeFactory
extends NodeFactoryBase<NumericToFloatNode> {
    private static NumericToFloatNodeFactory instance;

    private NumericToFloatNodeFactory() {
        super(NumericToFloatNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, String.class, RubyNode.class}});
    }

    public NumericToFloatNode createNode(Object ... arguments) {
        if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof String) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
            return NumericToFloatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (String)arguments[2], (RubyNode)((Object)arguments[3]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static NumericToFloatNode create(RubyContext context, SourceSection sourceSection, String method, RubyNode child) {
        return NumericToFloatUninitializedNode.create0(context, sourceSection, method, child);
    }

    public static NodeFactory<NumericToFloatNode> getInstance() {
        if (instance == null) {
            instance = new NumericToFloatNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=NumericToFloatNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class NumericToFloatPolymorphicNode
    extends NumericToFloatBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        NumericToFloatPolymorphicNode(NumericToFloatBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value;
            try {
                value = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            Object childValue = this.child.execute(frameValue);
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public double executeFloat(VirtualFrame frameValue, RubyBasicObject childValueEvaluated) {
            RubyBasicObject childValue = childValueEvaluated;
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected double executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=NumericToFloatNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class NumericToFloatRubyBasicObjectNode
    extends NumericToFloatBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(NumericToFloatRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        NumericToFloatRubyBasicObjectNode(NumericToFloatBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value;
            try {
                value = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBasicObject childValue;
            try {
                childValue = this.child.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (super.isNumeric(frameValue, childValue)) {
                return super.castNumeric(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [isNumeric] failed");
        }

        @Override
        public double executeFloat(VirtualFrame frameValue, RubyBasicObject childValueEvaluated) {
            RubyBasicObject childValue = childValueEvaluated;
            if (super.isNumeric(frameValue, childValue)) {
                return super.castNumeric(frameValue, childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [isNumeric] failed");
        }

        @Override
        protected double executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue)) {
                RubyBasicObject childValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(childValue);
                if (super.isNumeric(frameValue, childValue)) {
                    return super.castNumeric(frameValue, childValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static NumericToFloatNode create0(NumericToFloatNode current) {
            return new NumericToFloatRubyBasicObjectNode((NumericToFloatBaseNode)current);
        }
    }

    @GeneratedBy(value=NumericToFloatNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class NumericToFloatUninitializedNode
    extends NumericToFloatBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(NumericToFloatUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        NumericToFloatUninitializedNode(RubyContext context, SourceSection sourceSection, String method, RubyNode child) {
            super(context, sourceSection, method, child);
        }

        NumericToFloatUninitializedNode(NumericToFloatBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value;
            try {
                value = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        public double executeFloat(VirtualFrame frameValue, RubyBasicObject childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyBasicObject childValue = childValueEvaluated;
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected double executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected double executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            NumericToFloatBaseNode newNode = this.specialize0(frameValue, childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                return super.fallback(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((NumericToFloatBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static NumericToFloatNode create0(RubyContext context, SourceSection sourceSection, String method, RubyNode child) {
            return new NumericToFloatUninitializedNode(context, sourceSection, method, child);
        }
    }

    @GeneratedBy(value=NumericToFloatNode.class)
    private static abstract class NumericToFloatBaseNode
    extends NumericToFloatNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected NumericToFloatBaseNode next0;

        NumericToFloatBaseNode(RubyContext context, SourceSection sourceSection, String method, RubyNode child) {
            super(context, sourceSection, method);
            this.child = child;
        }

        NumericToFloatBaseNode(NumericToFloatBaseNode copy) {
            super(copy);
        }

        protected abstract double executeChained0(VirtualFrame var1, Object var2);

        protected final double rewrite0(VirtualFrame frameValue, Object childValue, String reason) {
            String message;
            NumericToFloatBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            NumericToFloatBaseNode newNode = this.specialize0(frameValue, childValue);
            if (newNode == null) {
                newNode = new NumericToFloatUninitializedNode(this);
                ((NumericToFloatUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (NumericToFloatBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = NumericToFloatBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (NumericToFloatBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new NumericToFloatUninitializedNode(this), (Node)new NumericToFloatPolymorphicNode(this), (DSLNode)((NumericToFloatBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        protected final NumericToFloatBaseNode specialize0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue) && super.isNumeric(frameValue, childValue)) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return (NumericToFloatBaseNode)NumericToFloatRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((NumericToFloatBaseNode)other).child;
            this.next0 = newNext == null ? null : (NumericToFloatBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

