/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;

@NodeChildren(value={@NodeChild(value="value"), @NodeChild(value="receiver"), @NodeChild(value="other")})
public abstract class CmpIntNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode gtNode;
    @Node.Child
    private CallDispatchHeadNode ltNode;

    public CmpIntNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public CmpIntNode(CmpIntNode prev) {
        super(prev);
        this.gtNode = prev.gtNode;
        this.ltNode = prev.ltNode;
    }

    public abstract int executeCmpInt(VirtualFrame var1, Object var2, Object var3, Object var4);

    @Specialization
    public int cmpInt(int value, Object receiver, Object other) {
        if (value > 0) {
            return 1;
        }
        if (value < 0) {
            return -1;
        }
        return 0;
    }

    @Specialization
    public int cmpLong(long value, Object receiver, Object other) {
        if (value > 0L) {
            return 1;
        }
        if (value < 0L) {
            return -1;
        }
        return 0;
    }

    @Specialization
    public int cmpBignum(RubyBignum value, Object receiver, Object other) {
        return value.bigIntegerValue().signum();
    }

    @Specialization
    public int cmpNil(RubyNilClass value, Object receiver, Object other) {
        throw new RaiseException(this.getContext().getCoreLibrary().argumentError(String.format("comparison of %s with %s failed", this.getContext().getCoreLibrary().getLogicalClass(receiver).getName(), this.getContext().getCoreLibrary().getLogicalClass(other).getName()), this));
    }

    @Specialization(guards={"!isInteger(value)", "!isLong(value)", "!isRubyBignum(value)", "!isRubyNilClass(value)"})
    public int cmpObject(VirtualFrame frame, Object value, Object receiver, Object other) {
        if (this.gtNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.gtNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        if (this.gtNode.callBoolean(frame, value, ">", null, 0)) {
            return 1;
        }
        if (this.ltNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.ltNode = (CallDispatchHeadNode)this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext()));
        }
        if (this.ltNode.callBoolean(frame, value, "<", null, 0)) {
            return -1;
        }
        return 0;
    }
}

