/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyNilClass;

@GeneratedBy(value=BooleanCastNode.class)
public final class BooleanCastNodeFactory
extends NodeFactoryBase<BooleanCastNode> {
    private static BooleanCastNodeFactory instance;

    private BooleanCastNodeFactory() {
        super(BooleanCastNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class}});
    }

    public BooleanCastNode createNode(Object ... arguments) {
        if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
            return BooleanCastNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static BooleanCastNode create(RubyContext context, SourceSection sourceSection, RubyNode child) {
        return BooleanCastUninitializedNode.create0(context, sourceSection, child);
    }

    public static NodeFactory<BooleanCastNode> getInstance() {
        if (instance == null) {
            instance = new BooleanCastNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=BooleanCastNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class BooleanCastPolymorphicNode
    extends BooleanCastBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> childPolymorphicType;

        BooleanCastPolymorphicNode(BooleanCastBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.child.executeBoolean(frameValue)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(this.child.executeIntegerFixnum(frameValue)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(this.child.executeLongFixnum(frameValue)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(this.child.executeFloat(frameValue)) : (this.childPolymorphicType == RubyNilClass.class ? this.child.executeRubyNilClass(frameValue) : (this.childPolymorphicType == RubyBasicObject.class ? this.child.executeRubyBasicObject(frameValue) : this.child.execute(frameValue))))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue, Object childValueEvaluated) {
            Object childValue;
            try {
                childValue = this.childPolymorphicType == Boolean.TYPE ? Boolean.valueOf(RubyTypesGen.RUBYTYPES.expectBoolean(childValueEvaluated)) : (this.childPolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(childValueEvaluated)) : (this.childPolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(childValueEvaluated)) : (this.childPolymorphicType == Double.TYPE ? Double.valueOf(RubyTypesGen.RUBYTYPES.expectDouble(childValueEvaluated)) : (this.childPolymorphicType == RubyNilClass.class ? RubyTypesGen.RUBYTYPES.expectRubyNilClass(childValueEvaluated) : (this.childPolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(childValueEvaluated) : childValueEvaluated)))));
            }
            catch (UnexpectedResultException ex) {
                this.childPolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.childPolymorphicType = types[0];
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object childValue) {
            return this.next0.executeChained0(frameValue, childValue);
        }
    }

    @GeneratedBy(value=BooleanCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class BooleanCastRubyBasicObjectNode
    extends BooleanCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(BooleanCastRubyBasicObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyBasicObject.class}, 0, 0);

        BooleanCastRubyBasicObjectNode(BooleanCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            RubyBasicObject childValue;
            try {
                childValue = this.child.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (!super.isRubyNilClass(childValue)) {
                return super.doBasicObject(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubyNilClass] failed");
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue, Object childValueEvaluated) {
            RubyBasicObject childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyBasicObject");
            }
            if (!super.isRubyNilClass(childValue)) {
                return super.doBasicObject(childValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, childValue, "One of guards [!isRubyNilClass] failed");
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue)) {
                RubyBasicObject childValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(childValue);
                if (!super.isRubyNilClass(childValue)) {
                    return super.doBasicObject(childValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static BooleanCastNode create0(BooleanCastNode current) {
            return new BooleanCastRubyBasicObjectNode((BooleanCastBaseNode)current);
        }
    }

    @GeneratedBy(value=BooleanCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class BooleanCastDoubleNode
    extends BooleanCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(BooleanCastDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Double.TYPE}, 0, 0);

        BooleanCastDoubleNode(BooleanCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            double childValue;
            try {
                childValue = this.child.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof double");
            }
            return super.doFloat(childValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue, Object childValueEvaluated) {
            double childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectDouble(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof double");
            }
            return super.doFloat(childValue);
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                double childValueCast = RubyTypesGen.RUBYTYPES.asDouble(childValue);
                return super.doFloat(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static BooleanCastNode create0(BooleanCastNode current) {
            return new BooleanCastDoubleNode((BooleanCastBaseNode)current);
        }
    }

    @GeneratedBy(value=BooleanCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class BooleanCastLongNode
    extends BooleanCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(BooleanCastLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Long.TYPE}, 0, 0);

        BooleanCastLongNode(BooleanCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            long childValue;
            try {
                childValue = this.child.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof long");
            }
            return super.doLongFixnum(childValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue, Object childValueEvaluated) {
            long childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectLong(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof long");
            }
            return super.doLongFixnum(childValue);
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                long childValueCast = RubyTypesGen.RUBYTYPES.asLong(childValue);
                return super.doLongFixnum(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static BooleanCastNode create0(BooleanCastNode current) {
            return new BooleanCastLongNode((BooleanCastBaseNode)current);
        }
    }

    @GeneratedBy(value=BooleanCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class BooleanCastIntNode
    extends BooleanCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(BooleanCastIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Integer.TYPE}, 0, 0);

        BooleanCastIntNode(BooleanCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            int childValue;
            try {
                childValue = this.child.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof int");
            }
            return super.doIntegerFixnum(childValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue, Object childValueEvaluated) {
            int childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectInteger(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof int");
            }
            return super.doIntegerFixnum(childValue);
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                int childValueCast = RubyTypesGen.RUBYTYPES.asInteger(childValue);
                return super.doIntegerFixnum(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static BooleanCastNode create0(BooleanCastNode current) {
            return new BooleanCastIntNode((BooleanCastBaseNode)current);
        }
    }

    @GeneratedBy(value=BooleanCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class BooleanCastBooleanNode
    extends BooleanCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(BooleanCastBooleanNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Boolean.TYPE}, 0, 0);

        BooleanCastBooleanNode(BooleanCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            boolean childValue;
            try {
                childValue = this.child.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof boolean");
            }
            return super.doBoolean(childValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue, Object childValueEvaluated) {
            boolean childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectBoolean(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof boolean");
            }
            return super.doBoolean(childValue);
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                boolean childValueCast = RubyTypesGen.RUBYTYPES.asBoolean(childValue);
                return super.doBoolean(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static BooleanCastNode create0(BooleanCastNode current) {
            return new BooleanCastBooleanNode((BooleanCastBaseNode)current);
        }
    }

    @GeneratedBy(value=BooleanCastNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class BooleanCastRubyNilClassNode
    extends BooleanCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(BooleanCastRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyNilClass.class}, 0, 0);

        BooleanCastRubyNilClassNode(BooleanCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            RubyNilClass childValue;
            try {
                childValue = this.child.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyNilClass");
            }
            return super.doNil(childValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue, Object childValueEvaluated) {
            RubyNilClass childValue;
            try {
                childValue = RubyTypesGen.RUBYTYPES.expectRubyNilClass(childValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected childValue instanceof RubyNilClass");
            }
            return super.doNil(childValue);
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                RubyNilClass childValueCast = RubyTypesGen.RUBYTYPES.asRubyNilClass(childValue);
                return super.doNil(childValueCast);
            }
            return this.next0.executeChained0(frameValue, childValue);
        }

        static BooleanCastNode create0(BooleanCastNode current) {
            return new BooleanCastRubyNilClassNode((BooleanCastBaseNode)current);
        }
    }

    @GeneratedBy(value=BooleanCastNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class BooleanCastUninitializedNode
    extends BooleanCastBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(BooleanCastUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        BooleanCastUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection, child);
        }

        BooleanCastUninitializedNode(BooleanCastBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            return this.executeBoolean(frameValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = this.child.execute(frameValue);
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue, Object childValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object childValue = childValueEvaluated;
            return this.executeUninitialized0(frameValue, childValue);
        }

        @Override
        protected boolean executeChained0(VirtualFrame frameValue, Object childValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, childValue);
        }

        protected boolean executeUninitialized0(VirtualFrame frameValue, Object childValue) {
            BooleanCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                BooleanCastBaseNode rootNode = (BooleanCastBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.child}, new Object[]{childValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((BooleanCastBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, childValue);
        }

        static BooleanCastNode create0(RubyContext context, SourceSection sourceSection, RubyNode child) {
            return new BooleanCastUninitializedNode(context, sourceSection, child);
        }
    }

    @GeneratedBy(value=BooleanCastNode.class)
    private static abstract class BooleanCastBaseNode
    extends BooleanCastNode
    implements DSLNode {
        @Node.Child
        protected RubyNode child;
        @Node.Child
        protected BooleanCastBaseNode next0;

        BooleanCastBaseNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
            super(context, sourceSection);
            this.child = child;
        }

        BooleanCastBaseNode(BooleanCastBaseNode copy) {
            super(copy);
        }

        protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

        protected final boolean rewrite0(VirtualFrame frameValue, Object childValue, String reason) {
            String message;
            BooleanCastBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            BooleanCastBaseNode newNode = this.specialize0(childValue);
            if (newNode == null) {
                newNode = new BooleanCastUninitializedNode(this);
                ((BooleanCastUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (BooleanCastBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = BooleanCastBaseNode.createInfo0(reason, childValue)))) == null) {
                returnNode = (BooleanCastBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new BooleanCastUninitializedNode(this), (Node)new BooleanCastPolymorphicNode(this), (DSLNode)((BooleanCastBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, childValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final BooleanCastBaseNode specialize0(Object childValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyNilClass(childValue)) {
                return (BooleanCastBaseNode)BooleanCastRubyNilClassNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isBoolean(childValue)) {
                return (BooleanCastBaseNode)BooleanCastBooleanNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isInteger(childValue)) {
                return (BooleanCastBaseNode)BooleanCastIntNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isLong(childValue)) {
                return (BooleanCastBaseNode)BooleanCastLongNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isDouble(childValue)) {
                return (BooleanCastBaseNode)BooleanCastDoubleNode.create0(this);
            }
            if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(childValue) && !super.isRubyNilClass(childValue)) {
                return (BooleanCastBaseNode)BooleanCastRubyBasicObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.child = other == null ? null : ((BooleanCastBaseNode)other).child;
            this.next0 = newNext == null ? null : (BooleanCastBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object childValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("childValue").append(" = ").append(childValue);
                if (childValue != null) {
                    builder.append(" (").append(childValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

