/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.SplatCastNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;

@NodeChild(value="child")
public abstract class ArrayCastNode
extends RubyNode {
    private final SplatCastNode.NilBehavior nilBehavior;
    @Node.Child
    private CallDispatchHeadNode toArrayNode;

    public ArrayCastNode(RubyContext context, SourceSection sourceSection) {
        this(context, sourceSection, SplatCastNode.NilBehavior.NIL);
    }

    public ArrayCastNode(RubyContext context, SourceSection sourceSection, SplatCastNode.NilBehavior nilBehavior) {
        super(context, sourceSection);
        this.toArrayNode = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.RETURN_MISSING);
        this.nilBehavior = nilBehavior;
    }

    public ArrayCastNode(ArrayCastNode prev) {
        super(prev);
        this.toArrayNode = prev.toArrayNode;
        this.nilBehavior = prev.nilBehavior;
    }

    protected abstract RubyNode getChild();

    @Specialization
    public RubyNilClass cast(boolean value) {
        return this.nil();
    }

    @Specialization
    public RubyNilClass cast(int value) {
        return this.nil();
    }

    @Specialization
    public RubyNilClass cast(long value) {
        return this.nil();
    }

    @Specialization
    public RubyNilClass cast(double value) {
        return this.nil();
    }

    @Specialization
    public RubyNilClass cast(RubyBignum value) {
        return this.nil();
    }

    @Specialization
    public RubyArray cast(RubyArray array) {
        return array;
    }

    @Specialization
    public Object cast(RubyNilClass nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            }
            case ARRAY_WITH_NIL: {
                return RubyArray.fromObject(this.getContext().getCoreLibrary().getArrayClass(), this.nil());
            }
            case NIL: {
                return nil;
            }
        }
        CompilerAsserts.neverPartOfCompilation();
        throw new UnsupportedOperationException();
    }

    @Specialization(guards={"!isRubyNilClass", "!isRubyArray"})
    public Object cast(VirtualFrame frame, RubyBasicObject object) {
        ArrayCastNode.notDesignedForCompilation();
        Object result = this.toArrayNode.call(frame, object, "to_ary", null, new Object[0]);
        if (result == DispatchNode.MISSING) {
            return this.nil();
        }
        if (!(result instanceof RubyArray)) {
            CompilerDirectives.transferToInterpreter();
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorShouldReturn(object.toString(), "to_ary", "Array", this));
        }
        return result;
    }

    @Override
    public void executeVoid(VirtualFrame frame) {
        this.getChild().executeVoid(frame);
    }
}

