/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.array.ArrayReadDenormalizedNodeFactory;
import org.jruby.truffle.nodes.array.ArrayReadNormalizedNodeFactory;
import org.jruby.truffle.nodes.array.ArrayReadSliceDenormalizedNodeFactory;
import org.jruby.truffle.nodes.array.ArrayReadSliceNormalizedNodeFactory;
import org.jruby.truffle.nodes.literal.FixnumLiteralNode;
import org.jruby.truffle.runtime.RubyContext;

public abstract class PrimitiveArrayNodeFactory {
    public static RubyNode read(RubyContext context, SourceSection sourceSection, RubyNode array, int index) {
        FixnumLiteralNode.IntegerFixnumLiteralNode literalIndex = new FixnumLiteralNode.IntegerFixnumLiteralNode(context, sourceSection, index);
        if (index >= 0) {
            return ArrayReadNormalizedNodeFactory.create(context, sourceSection, array, literalIndex);
        }
        return ArrayReadDenormalizedNodeFactory.create(context, sourceSection, array, literalIndex);
    }

    public static RubyNode readSlice(RubyContext context, SourceSection sourceSection, RubyNode array, int start, int exclusiveEnd) {
        FixnumLiteralNode.IntegerFixnumLiteralNode literalStart = new FixnumLiteralNode.IntegerFixnumLiteralNode(context, sourceSection, start);
        FixnumLiteralNode.IntegerFixnumLiteralNode literalExclusiveEnd = new FixnumLiteralNode.IntegerFixnumLiteralNode(context, sourceSection, exclusiveEnd);
        if (start >= 0 && exclusiveEnd >= 0) {
            return ArrayReadSliceNormalizedNodeFactory.create(context, sourceSection, array, literalStart, literalExclusiveEnd);
        }
        return ArrayReadSliceDenormalizedNodeFactory.create(context, sourceSection, array, literalStart, literalExclusiveEnd);
    }
}

