/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.array.GeneralizeArrayNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=GeneralizeArrayNode.class)
public final class GeneralizeArrayNodeFactory
extends NodeFactoryBase<GeneralizeArrayNode> {
    private static GeneralizeArrayNodeFactory instance;

    private GeneralizeArrayNodeFactory() {
        super(GeneralizeArrayNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
    }

    public GeneralizeArrayNode createNode(Object ... arguments) {
        if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
            return GeneralizeArrayNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static GeneralizeArrayNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
        return GeneralizeArrayUninitializedNode.create0(context, sourceSection, array, requiredCapacity);
    }

    public static NodeFactory<GeneralizeArrayNode> getInstance() {
        if (instance == null) {
            instance = new GeneralizeArrayNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class GeneralizeArrayPolymorphicNode
    extends GeneralizeArrayBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> requiredCapacityPolymorphicType;

        GeneralizeArrayPolymorphicNode(GeneralizeArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object arrayValue = this.array.execute(frameValue);
            Object requiredCapacityValue = this.requiredCapacity.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public Object executeGeneralize(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            Integer requiredCapacityValue = requiredCapacityValueEvaluated;
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
            this.requiredCapacityPolymorphicType = types[1];
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class GeneralizeArrayRubyArray3Node
    extends GeneralizeArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(GeneralizeArrayRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        GeneralizeArrayRubyArray3Node(GeneralizeArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int requiredCapacityValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue2 = this.requiredCapacity.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), requiredCapacityValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                requiredCapacityValue = this.requiredCapacity.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected requiredCapacityValue instanceof int");
            }
            if (ArrayGuards.isDoubleArray(arrayValue)) {
                return super.generalizeDouble(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isDoubleArray] failed");
        }

        @Override
        public Object executeGeneralize(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int requiredCapacityValue = requiredCapacityValueEvaluated;
            if (ArrayGuards.isDoubleArray(arrayValue)) {
                return super.generalizeDouble(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isDoubleArray] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int requiredCapacityValueCast = RubyTypesGen.RUBYTYPES.asInteger(requiredCapacityValue);
                if (ArrayGuards.isDoubleArray(arrayValueCast)) {
                    return super.generalizeDouble(arrayValueCast, requiredCapacityValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static GeneralizeArrayNode create0(GeneralizeArrayNode current) {
            return new GeneralizeArrayRubyArray3Node((GeneralizeArrayBaseNode)current);
        }
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class GeneralizeArrayRubyArray2Node
    extends GeneralizeArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(GeneralizeArrayRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        GeneralizeArrayRubyArray2Node(GeneralizeArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int requiredCapacityValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue2 = this.requiredCapacity.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), requiredCapacityValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                requiredCapacityValue = this.requiredCapacity.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected requiredCapacityValue instanceof int");
            }
            if (ArrayGuards.isLongArray(arrayValue)) {
                return super.generalizeLong(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isLongArray] failed");
        }

        @Override
        public Object executeGeneralize(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int requiredCapacityValue = requiredCapacityValueEvaluated;
            if (ArrayGuards.isLongArray(arrayValue)) {
                return super.generalizeLong(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isLongArray] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int requiredCapacityValueCast = RubyTypesGen.RUBYTYPES.asInteger(requiredCapacityValue);
                if (ArrayGuards.isLongArray(arrayValueCast)) {
                    return super.generalizeLong(arrayValueCast, requiredCapacityValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static GeneralizeArrayNode create0(GeneralizeArrayNode current) {
            return new GeneralizeArrayRubyArray2Node((GeneralizeArrayBaseNode)current);
        }
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class GeneralizeArrayRubyArray1Node
    extends GeneralizeArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(GeneralizeArrayRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        GeneralizeArrayRubyArray1Node(GeneralizeArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int requiredCapacityValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue2 = this.requiredCapacity.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), requiredCapacityValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                requiredCapacityValue = this.requiredCapacity.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected requiredCapacityValue instanceof int");
            }
            if (ArrayGuards.isIntArray(arrayValue)) {
                return super.generalizeInt(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isIntArray] failed");
        }

        @Override
        public Object executeGeneralize(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int requiredCapacityValue = requiredCapacityValueEvaluated;
            if (ArrayGuards.isIntArray(arrayValue)) {
                return super.generalizeInt(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isIntArray] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int requiredCapacityValueCast = RubyTypesGen.RUBYTYPES.asInteger(requiredCapacityValue);
                if (ArrayGuards.isIntArray(arrayValueCast)) {
                    return super.generalizeInt(arrayValueCast, requiredCapacityValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static GeneralizeArrayNode create0(GeneralizeArrayNode current) {
            return new GeneralizeArrayRubyArray1Node((GeneralizeArrayBaseNode)current);
        }
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class GeneralizeArrayRubyArray0Node
    extends GeneralizeArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(GeneralizeArrayRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        GeneralizeArrayRubyArray0Node(GeneralizeArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            int requiredCapacityValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object requiredCapacityValue2 = this.requiredCapacity.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), requiredCapacityValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                requiredCapacityValue = this.requiredCapacity.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected requiredCapacityValue instanceof int");
            }
            if (ArrayGuards.isNullArray(arrayValue)) {
                return super.generalizeNull(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isNullArray] failed");
        }

        @Override
        public Object executeGeneralize(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int requiredCapacityValue = requiredCapacityValueEvaluated;
            if (ArrayGuards.isNullArray(arrayValue)) {
                return super.generalizeNull(arrayValue, requiredCapacityValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, requiredCapacityValue, "One of guards [isNullArray] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int requiredCapacityValueCast = RubyTypesGen.RUBYTYPES.asInteger(requiredCapacityValue);
                if (ArrayGuards.isNullArray(arrayValueCast)) {
                    return super.generalizeNull(arrayValueCast, requiredCapacityValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static GeneralizeArrayNode create0(GeneralizeArrayNode current) {
            return new GeneralizeArrayRubyArray0Node((GeneralizeArrayBaseNode)current);
        }
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class GeneralizeArrayUninitializedNode
    extends GeneralizeArrayBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(GeneralizeArrayUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        GeneralizeArrayUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
            super(context, sourceSection, array, requiredCapacity);
        }

        GeneralizeArrayUninitializedNode(GeneralizeArrayBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value;
            try {
                value = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            Object requiredCapacityValue = this.requiredCapacity.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        public Object executeGeneralize(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int requiredCapacityValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyArray arrayValue = arrayValueEvaluated;
            Integer requiredCapacityValue = requiredCapacityValueEvaluated;
            return this.executeUninitialized0(frameValue, arrayValue, requiredCapacityValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue, requiredCapacityValue);
        }

        protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue) {
            GeneralizeArrayBaseNode newNode = this.specialize0(arrayValue, requiredCapacityValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                GeneralizeArrayBaseNode rootNode = (GeneralizeArrayBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.requiredCapacity}, new Object[]{arrayValue, requiredCapacityValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((GeneralizeArrayBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        static GeneralizeArrayNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
            return new GeneralizeArrayUninitializedNode(context, sourceSection, array, requiredCapacity);
        }
    }

    @GeneratedBy(value=GeneralizeArrayNode.class)
    private static abstract class GeneralizeArrayBaseNode
    extends GeneralizeArrayNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected RubyNode requiredCapacity;
        @Node.Child
        protected GeneralizeArrayBaseNode next0;

        GeneralizeArrayBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode requiredCapacity) {
            super(context, sourceSection);
            this.array = array;
            this.requiredCapacity = requiredCapacity;
        }

        GeneralizeArrayBaseNode(GeneralizeArrayBaseNode copy) {
            super(copy);
        }

        protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

        protected final RubyArray rewrite0(VirtualFrame frameValue, Object arrayValue, Object requiredCapacityValue, String reason) {
            String message;
            GeneralizeArrayBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            GeneralizeArrayBaseNode newNode = this.specialize0(arrayValue, requiredCapacityValue);
            if (newNode == null) {
                newNode = new GeneralizeArrayUninitializedNode(this);
                ((GeneralizeArrayUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (GeneralizeArrayBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = GeneralizeArrayBaseNode.createInfo0(reason, arrayValue, requiredCapacityValue)))) == null) {
                returnNode = (GeneralizeArrayBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new GeneralizeArrayUninitializedNode(this), (Node)new GeneralizeArrayPolymorphicNode(this), (DSLNode)((GeneralizeArrayBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, arrayValue, requiredCapacityValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final GeneralizeArrayBaseNode specialize0(Object arrayValue, Object requiredCapacityValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(requiredCapacityValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                if (ArrayGuards.isNullArray(arrayValueCast)) {
                    return (GeneralizeArrayBaseNode)GeneralizeArrayRubyArray0Node.create0(this);
                }
                if (ArrayGuards.isIntArray(arrayValueCast)) {
                    return (GeneralizeArrayBaseNode)GeneralizeArrayRubyArray1Node.create0(this);
                }
                if (ArrayGuards.isLongArray(arrayValueCast)) {
                    return (GeneralizeArrayBaseNode)GeneralizeArrayRubyArray2Node.create0(this);
                }
                if (ArrayGuards.isDoubleArray(arrayValueCast)) {
                    return (GeneralizeArrayBaseNode)GeneralizeArrayRubyArray3Node.create0(this);
                }
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.array = null;
                this.requiredCapacity = null;
            } else {
                GeneralizeArrayBaseNode otherCast = (GeneralizeArrayBaseNode)other;
                this.array = otherCast.array;
                this.requiredCapacity = otherCast.requiredCapacity;
            }
            this.next0 = newNext == null ? null : (GeneralizeArrayBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object arrayValue, Object requiredCapacityValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("requiredCapacityValue").append(" = ").append(requiredCapacityValue);
                if (requiredCapacityValue != null) {
                    builder.append(" (").append(requiredCapacityValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

