/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.util.ArrayUtils;

@ImportGuards(value={ArrayGuards.class})
@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="requiredCapacity", type=RubyNode.class)})
public abstract class GeneralizeArrayNode
extends RubyNode {
    public GeneralizeArrayNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public GeneralizeArrayNode(GeneralizeArrayNode prev) {
        super(prev);
    }

    public abstract Object executeGeneralize(VirtualFrame var1, RubyArray var2, int var3);

    @Specialization(guards={"isNullArray"})
    public RubyArray generalizeNull(RubyArray array, int requiredCapacity) {
        array.setStore(new Object[requiredCapacity], array.getSize());
        return array;
    }

    @Specialization(guards={"isIntArray"})
    public RubyArray generalizeInt(RubyArray array, int requiredCapacity) {
        int[] intStore = (int[])array.getStore();
        array.setStore(ArrayUtils.box(intStore, requiredCapacity - intStore.length), array.getSize());
        return array;
    }

    @Specialization(guards={"isLongArray"})
    public RubyArray generalizeLong(RubyArray array, int requiredCapacity) {
        long[] intStore = (long[])array.getStore();
        array.setStore(ArrayUtils.box(intStore, requiredCapacity - intStore.length), array.getSize());
        return array;
    }

    @Specialization(guards={"isDoubleArray"})
    public RubyArray generalizeDouble(RubyArray array, int requiredCapacity) {
        double[] intStore = (double[])array.getStore();
        array.setStore(ArrayUtils.box(intStore, requiredCapacity - intStore.length), array.getSize());
        return array;
    }
}

