/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.array.ArrayWriteNormalizedNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;

@GeneratedBy(value=ArrayWriteNormalizedNode.class)
public final class ArrayWriteNormalizedNodeFactory
extends NodeFactoryBase<ArrayWriteNormalizedNode> {
    private static ArrayWriteNormalizedNodeFactory instance;

    private ArrayWriteNormalizedNodeFactory() {
        super(ArrayWriteNormalizedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
    }

    public ArrayWriteNormalizedNode createNode(Object ... arguments) {
        if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
            return ArrayWriteNormalizedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayWriteNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        return ArrayWriteNormalizedUninitializedNode.create0(context, sourceSection, array, index, value);
    }

    public static NodeFactory<ArrayWriteNormalizedNode> getInstance() {
        if (instance == null) {
            instance = new ArrayWriteNormalizedNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayWriteNormalizedPolymorphicNode
    extends ArrayWriteNormalizedBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> indexPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> valuePolymorphicType;

        ArrayWriteNormalizedPolymorphicNode(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object valueValue;
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            try {
                valueValue = this.valuePolymorphicType == Boolean.TYPE ? Boolean.valueOf(this.value.executeBoolean(frameValue)) : (this.valuePolymorphicType == Integer.TYPE ? Integer.valueOf(this.value.executeIntegerFixnum(frameValue)) : (this.valuePolymorphicType == Long.TYPE ? Long.valueOf(this.value.executeLongFixnum(frameValue)) : (this.valuePolymorphicType == Double.TYPE ? Double.valueOf(this.value.executeFloat(frameValue)) : (this.valuePolymorphicType == RubyBasicObject.class ? this.value.executeRubyBasicObject(frameValue) : this.value.execute(frameValue)))));
            }
            catch (UnexpectedResultException ex) {
                this.valuePolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, arrayValue, indexValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            Object valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            try {
                valueValue = this.valuePolymorphicType == Boolean.TYPE ? Boolean.valueOf(RubyTypesGen.RUBYTYPES.expectBoolean(valueValueEvaluated)) : (this.valuePolymorphicType == Integer.TYPE ? Integer.valueOf(RubyTypesGen.RUBYTYPES.expectInteger(valueValueEvaluated)) : (this.valuePolymorphicType == Long.TYPE ? Long.valueOf(RubyTypesGen.RUBYTYPES.expectLong(valueValueEvaluated)) : (this.valuePolymorphicType == Double.TYPE ? Double.valueOf(RubyTypesGen.RUBYTYPES.expectDouble(valueValueEvaluated)) : (this.valuePolymorphicType == RubyBasicObject.class ? RubyTypesGen.RUBYTYPES.expectRubyBasicObject(valueValueEvaluated) : valueValueEvaluated))));
            }
            catch (UnexpectedResultException ex) {
                this.valuePolymorphicType = Object.class;
                return this.next0.executeChained0(frameValue, arrayValue, indexValue, ex.getResult());
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
            this.indexPolymorphicType = types[1];
            this.valuePolymorphicType = types[2];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedObjectIntObject6Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedObjectIntObject6Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class}, 0, 0);

        ArrayWriteNormalizedObjectIntObject6Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue, "Expected indexValue instanceof int");
            }
            Object valueValue = this.value.execute(frameValue);
            if (ArrayGuards.isObjectArray(arrayValue) && !ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) && !ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeBeyondObject(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, !isInBounds, !isExtendingByOne] failed");
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            if (ArrayGuards.isObjectArray(arrayValue) && !ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) && !ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeBeyondObject(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, !isInBounds, !isExtendingByOne] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (ArrayGuards.isObjectArray(arrayValueCast) && !ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast) && !ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return super.writeBeyondObject(frameValue, arrayValueCast, indexValueCast, valueValue);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedObjectIntObject6Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedObjectIntObject5Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedObjectIntObject5Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class}, 0, 0);

        ArrayWriteNormalizedObjectIntObject5Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue, "Expected indexValue instanceof int");
            }
            Object valueValue = this.value.execute(frameValue);
            if (!(ArrayGuards.isObjectArray(arrayValue) || ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) || ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue))) {
                return super.writeBeyondPrimitive(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [!isObjectArray, !isInBounds, !isExtendingByOne] failed");
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            if (!(ArrayGuards.isObjectArray(arrayValue) || ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) || ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue))) {
                return super.writeBeyondPrimitive(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [!isObjectArray, !isInBounds, !isExtendingByOne] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (!(ArrayGuards.isObjectArray(arrayValueCast) || ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast) || ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValueCast, indexValueCast))) {
                    return super.writeBeyondPrimitive(frameValue, arrayValueCast, indexValueCast, valueValue);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedObjectIntObject5Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedInt5Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedInt5Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayWriteNormalizedInt5Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int"));
            }
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeObjectExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isExtendingByOne] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            int valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectInteger(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int");
            }
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeObjectExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isExtendingByOne] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                int valueValueCast = RubyTypesGen.RUBYTYPES.asInteger(valueValue);
                if (ArrayGuards.isObjectArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return super.writeObjectExtendByOne(frameValue, arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedInt5Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject1Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, RubyBasicObject.class}, 0, 0);

        ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject1Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBasicObject value;
            try {
                value = this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBasicObject valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof RubyBasicObject"));
            }
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isExtendingByOne] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyBasicObject valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof RubyBasicObject");
            }
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isExtendingByOne] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                RubyBasicObject valueValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(valueValue);
                if (ArrayGuards.isObjectArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return super.writeExtendByOne(frameValue, arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject1Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedDoubleIntDouble2Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedDoubleIntDouble2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Double.TYPE}, 0, 0);

        ArrayWriteNormalizedDoubleIntDouble2Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value;
            try {
                value = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof double"));
            }
            if (ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isDoubleArray, isExtendingByOne] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            double valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectDouble(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof double");
            }
            if (ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isDoubleArray, isExtendingByOne] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isDouble(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                double valueValueCast = RubyTypesGen.RUBYTYPES.asDouble(valueValue);
                if (ArrayGuards.isDoubleArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return super.writeExtendByOne(frameValue, arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedDoubleIntDouble2Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedLongIntLong3Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedLongIntLong3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE}, 0, 0);

        ArrayWriteNormalizedLongIntLong3Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value;
            try {
                value = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof long"));
            }
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isExtendingByOne] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            long valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectLong(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof long");
            }
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isExtendingByOne] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isLong(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                long valueValueCast = RubyTypesGen.RUBYTYPES.asLong(valueValue);
                if (ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return super.writeExtendByOne(frameValue, arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedLongIntLong3Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedInt4Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedInt4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayWriteNormalizedInt4Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int"));
            }
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOneIntIntoLong(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isExtendingByOne] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            int valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectInteger(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int");
            }
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOneIntIntoLong(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isExtendingByOne] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                int valueValueCast = RubyTypesGen.RUBYTYPES.asInteger(valueValue);
                if (ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return super.writeExtendByOneIntIntoLong(frameValue, arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedInt4Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedInt3Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedInt3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayWriteNormalizedInt3Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int"));
            }
            if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isIntArray, isExtendingByOne] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            int valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectInteger(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int");
            }
            if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isIntArray, isExtendingByOne] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                int valueValueCast = RubyTypesGen.RUBYTYPES.asInteger(valueValue);
                if (ArrayGuards.isIntArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return super.writeExtendByOne(frameValue, arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedInt3Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedBooleanIntBoolean2Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedBooleanIntBoolean2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Boolean.TYPE}, 0, 0);

        ArrayWriteNormalizedBooleanIntBoolean2Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof boolean"));
            }
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isExtendingByOne] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            boolean valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectBoolean(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof boolean");
            }
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValue, indexValue)) {
                return super.writeExtendByOne(frameValue, arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isExtendingByOne] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isBoolean(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                boolean valueValueCast = RubyTypesGen.RUBYTYPES.asBoolean(valueValue);
                if (ArrayGuards.isObjectArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return super.writeExtendByOne(frameValue, arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedBooleanIntBoolean2Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedObjectIntObject4Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedObjectIntObject4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class}, 0, 0);

        ArrayWriteNormalizedObjectIntObject4Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue, "Expected indexValue instanceof int");
            }
            Object valueValue = this.value.execute(frameValue);
            if (ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) && !super.isDouble(valueValue)) {
                return super.writeWithinDouble(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isDoubleArray, isInBounds, !isDouble] failed");
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            if (ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) && !super.isDouble(valueValue)) {
                return super.writeWithinDouble(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isDoubleArray, isInBounds, !isDouble] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && !super.isDouble(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (ArrayGuards.isDoubleArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithinDouble(arrayValueCast, indexValueCast, valueValue);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedObjectIntObject4Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedObjectIntObject3Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedObjectIntObject3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class}, 0, 0);

        ArrayWriteNormalizedObjectIntObject3Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue, "Expected indexValue instanceof int");
            }
            Object valueValue = this.value.execute(frameValue);
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) && !super.isInteger(valueValue) && !super.isLong(valueValue)) {
                return super.writeWithinLong(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isInBounds, !isInteger, !isLong] failed");
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) && !super.isInteger(valueValue) && !super.isLong(valueValue)) {
                return super.writeWithinLong(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isInBounds, !isInteger, !isLong] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && !super.isInteger(valueValue) && !super.isLong(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithinLong(arrayValueCast, indexValueCast, valueValue);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedObjectIntObject3Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedObjectIntObject2Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedObjectIntObject2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class}, 0, 0);

        ArrayWriteNormalizedObjectIntObject2Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue, "Expected indexValue instanceof int");
            }
            Object valueValue = this.value.execute(frameValue);
            if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) && !super.isInteger(valueValue) && !super.isLong(valueValue)) {
                return super.writeWithinInt(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isIntArray, isInBounds, !isInteger, !isLong] failed");
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue) && !super.isInteger(valueValue) && !super.isLong(valueValue)) {
                return super.writeWithinInt(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isIntArray, isInBounds, !isInteger, !isLong] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && !super.isInteger(valueValue) && !super.isLong(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (ArrayGuards.isIntArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithinInt(arrayValueCast, indexValueCast, valueValue);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedObjectIntObject2Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedLongIntLong2Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedLongIntLong2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE}, 0, 0);

        ArrayWriteNormalizedLongIntLong2Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value;
            try {
                value = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof long"));
            }
            if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithinInt(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isIntArray, isInBounds] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            long valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectLong(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof long");
            }
            if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithinInt(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isIntArray, isInBounds] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isLong(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                long valueValueCast = RubyTypesGen.RUBYTYPES.asLong(valueValue);
                if (ArrayGuards.isIntArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithinInt(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedLongIntLong2Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedObjectIntObject1Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedObjectIntObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class}, 0, 0);

        ArrayWriteNormalizedObjectIntObject1Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue, "Expected indexValue instanceof int");
            }
            Object valueValue = this.value.execute(frameValue);
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isInBounds] failed");
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isInBounds] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (ArrayGuards.isObjectArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithin(arrayValueCast, indexValueCast, valueValue);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedObjectIntObject1Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedDoubleIntDouble1Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedDoubleIntDouble1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Double.TYPE}, 0, 0);

        ArrayWriteNormalizedDoubleIntDouble1Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value;
            try {
                value = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof double"));
            }
            if (ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isDoubleArray, isInBounds] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            double valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectDouble(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof double");
            }
            if (ArrayGuards.isDoubleArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isDoubleArray, isInBounds] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isDouble(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                double valueValueCast = RubyTypesGen.RUBYTYPES.asDouble(valueValue);
                if (ArrayGuards.isDoubleArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithin(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedDoubleIntDouble1Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedLongIntLong1Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedLongIntLong1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE}, 0, 0);

        ArrayWriteNormalizedLongIntLong1Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value;
            try {
                value = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof long"));
            }
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isInBounds] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            long valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectLong(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof long");
            }
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isInBounds] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isLong(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                long valueValueCast = RubyTypesGen.RUBYTYPES.asLong(valueValue);
                if (ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithin(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedLongIntLong1Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedInt2Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedInt2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayWriteNormalizedInt2Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int"));
            }
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithinIntIntoLong(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isInBounds] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            int valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectInteger(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int");
            }
            if (ArrayGuards.isLongArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithinIntIntoLong(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isLongArray, isInBounds] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                int valueValueCast = RubyTypesGen.RUBYTYPES.asInteger(valueValue);
                if (ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithinIntIntoLong(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedInt2Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedInt1Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayWriteNormalizedInt1Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int"));
            }
            if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isIntArray, isInBounds] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            int valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectInteger(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int");
            }
            if (ArrayGuards.isIntArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isIntArray, isInBounds] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                int valueValueCast = RubyTypesGen.RUBYTYPES.asInteger(valueValue);
                if (ArrayGuards.isIntArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithin(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedInt1Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedBooleanIntBoolean1Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedBooleanIntBoolean1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Boolean.TYPE}, 0, 0);

        ArrayWriteNormalizedBooleanIntBoolean1Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof boolean"));
            }
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isInBounds] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            boolean valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectBoolean(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof boolean");
            }
            if (ArrayGuards.isObjectArray(arrayValue) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.writeWithin(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isObjectArray, isInBounds] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isBoolean(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                boolean valueValueCast = RubyTypesGen.RUBYTYPES.asBoolean(valueValue);
                if (ArrayGuards.isObjectArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return super.writeWithin(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedBooleanIntBoolean1Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedObjectIntObject0Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedObjectIntObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class}, 0, 0);

        ArrayWriteNormalizedObjectIntObject0Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue, "Expected indexValue instanceof int");
            }
            Object valueValue = this.value.execute(frameValue);
            if (ArrayGuards.isNullArray(arrayValue) && !ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNullBeyond(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, !isIndex0] failed");
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            if (ArrayGuards.isNullArray(arrayValue) && !ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNullBeyond(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, !isIndex0] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (ArrayGuards.isNullArray(arrayValueCast) && !ArrayWriteNormalizedBaseNode.isIndex0(arrayValueCast, indexValueCast)) {
                    return super.writeNullBeyond(arrayValueCast, indexValueCast, valueValue);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedObjectIntObject0Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject0Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, RubyBasicObject.class}, 0, 0);

        ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject0Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyBasicObject value;
            try {
                value = this.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyBasicObject executeRubyBasicObject(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyBasicObject valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeRubyBasicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof RubyBasicObject"));
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyBasicObject valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectRubyBasicObject(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof RubyBasicObject");
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isRubyBasicObject(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                RubyBasicObject valueValueCast = RubyTypesGen.RUBYTYPES.asRubyBasicObject(valueValue);
                if (ArrayGuards.isNullArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValueCast, indexValueCast)) {
                    return super.writeNull0(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject0Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedDoubleIntDouble0Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedDoubleIntDouble0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Double.TYPE}, 0, 0);

        ArrayWriteNormalizedDoubleIntDouble0Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value;
            try {
                value = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            double valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof double"));
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            double valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectDouble(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof double");
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isDouble(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                double valueValueCast = RubyTypesGen.RUBYTYPES.asDouble(valueValue);
                if (ArrayGuards.isNullArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValueCast, indexValueCast)) {
                    return super.writeNull0(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedDoubleIntDouble0Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedLongIntLong0Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedLongIntLong0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE}, 0, 0);

        ArrayWriteNormalizedLongIntLong0Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value;
            try {
                value = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            long valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof long"));
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            long valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectLong(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof long");
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isLong(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                long valueValueCast = RubyTypesGen.RUBYTYPES.asLong(valueValue);
                if (ArrayGuards.isNullArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValueCast, indexValueCast)) {
                    return super.writeNull0(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedLongIntLong0Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedInt0Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayWriteNormalizedInt0Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int"));
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            int valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectInteger(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof int");
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                int valueValueCast = RubyTypesGen.RUBYTYPES.asInteger(valueValue);
                if (ArrayGuards.isNullArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValueCast, indexValueCast)) {
                    return super.writeNull0(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedInt0Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteNormalizedBooleanIntBoolean0Node
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedBooleanIntBoolean0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Boolean.TYPE}, 0, 0);

        ArrayWriteNormalizedBooleanIntBoolean0Node(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            boolean value;
            try {
                value = this.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
            boolean valueValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue2 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue3 = this.value.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue3, "Expected indexValue instanceof int"));
            }
            try {
                valueValue = this.value.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof boolean"));
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectBoolean(this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed"));
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            boolean valueValue;
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            try {
                valueValue = RubyTypesGen.RUBYTYPES.expectBoolean(valueValueEvaluated);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected valueValue instanceof boolean");
            }
            if (ArrayGuards.isNullArray(arrayValue) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValue, indexValue)) {
                return super.writeNull0(arrayValue, indexValue, valueValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, valueValue, "One of guards [isNullArray, isIndex0] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isBoolean(valueValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                boolean valueValueCast = RubyTypesGen.RUBYTYPES.asBoolean(valueValue);
                if (ArrayGuards.isNullArray(arrayValueCast) && ArrayWriteNormalizedBaseNode.isIndex0(arrayValueCast, indexValueCast)) {
                    return super.writeNull0(arrayValueCast, indexValueCast, valueValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(ArrayWriteNormalizedNode current) {
            return new ArrayWriteNormalizedBooleanIntBoolean0Node((ArrayWriteNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayWriteNormalizedUninitializedNode
    extends ArrayWriteNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteNormalizedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayWriteNormalizedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
            super(context, sourceSection, array, index, value);
        }

        ArrayWriteNormalizedUninitializedNode(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            Object valueValue = this.value.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, valueValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            ArrayWriteNormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue, valueValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayWriteNormalizedBaseNode rootNode = (ArrayWriteNormalizedBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.index, rootNode.value}, new Object[]{arrayValue, indexValue, valueValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ArrayWriteNormalizedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteNormalizedNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
            return new ArrayWriteNormalizedUninitializedNode(context, sourceSection, array, index, value);
        }
    }

    @GeneratedBy(value=ArrayWriteNormalizedNode.class)
    private static abstract class ArrayWriteNormalizedBaseNode
    extends ArrayWriteNormalizedNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected RubyNode index;
        @Node.Child
        protected RubyNode value;
        @Node.Child
        protected ArrayWriteNormalizedBaseNode next0;

        ArrayWriteNormalizedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
            super(context, sourceSection);
            this.array = array;
            this.index = index;
            this.value = value;
        }

        ArrayWriteNormalizedBaseNode(ArrayWriteNormalizedBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

        protected final Object rewrite0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue, String reason) {
            String message;
            ArrayWriteNormalizedBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayWriteNormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue, valueValue);
            if (newNode == null) {
                newNode = new ArrayWriteNormalizedUninitializedNode(this);
                ((ArrayWriteNormalizedUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ArrayWriteNormalizedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ArrayWriteNormalizedBaseNode.createInfo0(reason, arrayValue, indexValue, valueValue)))) == null) {
                returnNode = (ArrayWriteNormalizedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ArrayWriteNormalizedUninitializedNode(this), (Node)new ArrayWriteNormalizedPolymorphicNode(this), (DSLNode)((ArrayWriteNormalizedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayWriteNormalizedBaseNode specialize0(Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (ArrayGuards.isNullArray(arrayValueCast)) {
                    if (RubyTypesGen.RUBYTYPES.isBoolean(valueValue) && ArrayWriteNormalizedNode.isIndex0(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedBooleanIntBoolean0Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(valueValue) && ArrayWriteNormalizedNode.isIndex0(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedInt0Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isLong(valueValue) && ArrayWriteNormalizedNode.isIndex0(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedLongIntLong0Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isDouble(valueValue) && ArrayWriteNormalizedNode.isIndex0(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedDoubleIntDouble0Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(valueValue) && ArrayWriteNormalizedNode.isIndex0(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject0Node.create0(this);
                    }
                    if (!ArrayWriteNormalizedNode.isIndex0(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedObjectIntObject0Node.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isBoolean(valueValue) && ArrayGuards.isObjectArray(arrayValueCast) && ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedBooleanIntBoolean1Node.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                    if (ArrayGuards.isIntArray(arrayValueCast) && ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedInt1Node.create0(this);
                    }
                    if (ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedInt2Node.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(valueValue) && ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedLongIntLong1Node.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(valueValue) && ArrayGuards.isDoubleArray(arrayValueCast) && ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedDoubleIntDouble1Node.create0(this);
                }
                if (ArrayGuards.isObjectArray(arrayValueCast) && ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedObjectIntObject1Node.create0(this);
                }
                if (ArrayGuards.isIntArray(arrayValueCast)) {
                    if (RubyTypesGen.RUBYTYPES.isLong(valueValue) && ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedLongIntLong2Node.create0(this);
                    }
                    if (ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast) && !super.isInteger(valueValue) && !super.isLong(valueValue)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedObjectIntObject2Node.create0(this);
                    }
                }
                if (ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast) && !super.isInteger(valueValue) && !super.isLong(valueValue)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedObjectIntObject3Node.create0(this);
                }
                if (ArrayGuards.isDoubleArray(arrayValueCast) && ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast) && !super.isDouble(valueValue)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedObjectIntObject4Node.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isBoolean(valueValue) && ArrayGuards.isObjectArray(arrayValueCast) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedBooleanIntBoolean2Node.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isInteger(valueValue)) {
                    if (ArrayGuards.isIntArray(arrayValueCast) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedInt3Node.create0(this);
                    }
                    if (ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedInt4Node.create0(this);
                    }
                }
                if (RubyTypesGen.RUBYTYPES.isLong(valueValue) && ArrayGuards.isLongArray(arrayValueCast) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedLongIntLong3Node.create0(this);
                }
                if (RubyTypesGen.RUBYTYPES.isDouble(valueValue) && ArrayGuards.isDoubleArray(arrayValueCast) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedDoubleIntDouble2Node.create0(this);
                }
                if (ArrayGuards.isObjectArray(arrayValueCast)) {
                    if (RubyTypesGen.RUBYTYPES.isRubyBasicObject(valueValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedRubyBasicObjectIntRubyBasicObject1Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(valueValue) && ArrayWriteNormalizedNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                        return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedInt5Node.create0(this);
                    }
                }
                if (!(ArrayGuards.isObjectArray(arrayValueCast) || ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast) || ArrayWriteNormalizedNode.isExtendingByOne(arrayValueCast, indexValueCast))) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedObjectIntObject5Node.create0(this);
                }
                if (ArrayGuards.isObjectArray(arrayValueCast) && !ArrayWriteNormalizedNode.isInBounds(arrayValueCast, indexValueCast) && !ArrayWriteNormalizedNode.isExtendingByOne(arrayValueCast, indexValueCast)) {
                    return (ArrayWriteNormalizedBaseNode)ArrayWriteNormalizedObjectIntObject6Node.create0(this);
                }
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.array = null;
                this.index = null;
                this.value = null;
            } else {
                ArrayWriteNormalizedBaseNode otherCast = (ArrayWriteNormalizedBaseNode)other;
                this.array = otherCast.array;
                this.index = otherCast.index;
                this.value = otherCast.value;
            }
            this.next0 = newNext == null ? null : (ArrayWriteNormalizedBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object arrayValue, Object indexValue, Object valueValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("indexValue").append(" = ").append(indexValue);
                if (indexValue != null) {
                    builder.append(" (").append(indexValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("valueValue").append(" = ").append(valueValue);
                if (valueValue != null) {
                    builder.append(" (").append(valueValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

