/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.array.ArrayWriteDenormalizedNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=ArrayWriteDenormalizedNode.class)
public final class ArrayWriteDenormalizedNodeFactory
extends NodeFactoryBase<ArrayWriteDenormalizedNode> {
    private static ArrayWriteDenormalizedNodeFactory instance;

    private ArrayWriteDenormalizedNodeFactory() {
        super(ArrayWriteDenormalizedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
    }

    public ArrayWriteDenormalizedNode createNode(Object ... arguments) {
        if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
            return ArrayWriteDenormalizedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayWriteDenormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
        return ArrayWriteDenormalizedUninitializedNode.create0(context, sourceSection, array, index, value);
    }

    public static NodeFactory<ArrayWriteDenormalizedNode> getInstance() {
        if (instance == null) {
            instance = new ArrayWriteDenormalizedNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayWriteDenormalizedNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayWriteDenormalizedPolymorphicNode
    extends ArrayWriteDenormalizedBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> indexPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> valuePolymorphicType;

        ArrayWriteDenormalizedPolymorphicNode(ArrayWriteDenormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            Object valueValue = this.value.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
            this.indexPolymorphicType = types[1];
            this.valuePolymorphicType = types[2];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }
    }

    @GeneratedBy(value=ArrayWriteDenormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayWriteDenormalizedRubyArrayObjectNode
    extends ArrayWriteDenormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteDenormalizedRubyArrayObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class}, 0, 0);

        ArrayWriteDenormalizedRubyArrayObjectNode(ArrayWriteDenormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, valueValue, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object valueValue = this.value.execute(frameValue);
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), valueValue, "Expected indexValue instanceof int");
            }
            Object valueValue = this.value.execute(frameValue);
            return super.write(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            return super.write(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                return super.write(frameValue, arrayValueCast, indexValueCast, valueValue);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteDenormalizedNode create0(ArrayWriteDenormalizedNode current) {
            return new ArrayWriteDenormalizedRubyArrayObjectNode((ArrayWriteDenormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayWriteDenormalizedNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayWriteDenormalizedUninitializedNode
    extends ArrayWriteDenormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayWriteDenormalizedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayWriteDenormalizedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
            super(context, sourceSection, array, index, value);
        }

        ArrayWriteDenormalizedUninitializedNode(ArrayWriteDenormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            Object valueValue = this.value.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        public Object executeWrite(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, Object valueValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            Object valueValue = valueValueEvaluated;
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, valueValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, valueValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue) {
            ArrayWriteDenormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue, valueValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayWriteDenormalizedBaseNode rootNode = (ArrayWriteDenormalizedBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.index, rootNode.value}, new Object[]{arrayValue, indexValue, valueValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ArrayWriteDenormalizedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        static ArrayWriteDenormalizedNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
            return new ArrayWriteDenormalizedUninitializedNode(context, sourceSection, array, index, value);
        }
    }

    @GeneratedBy(value=ArrayWriteDenormalizedNode.class)
    private static abstract class ArrayWriteDenormalizedBaseNode
    extends ArrayWriteDenormalizedNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected RubyNode index;
        @Node.Child
        protected RubyNode value;
        @Node.Child
        protected ArrayWriteDenormalizedBaseNode next0;

        ArrayWriteDenormalizedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode value) {
            super(context, sourceSection);
            this.array = array;
            this.index = index;
            this.value = value;
        }

        ArrayWriteDenormalizedBaseNode(ArrayWriteDenormalizedBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

        protected final Object rewrite0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object valueValue, String reason) {
            String message;
            ArrayWriteDenormalizedBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayWriteDenormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue, valueValue);
            if (newNode == null) {
                newNode = new ArrayWriteDenormalizedUninitializedNode(this);
                ((ArrayWriteDenormalizedUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ArrayWriteDenormalizedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ArrayWriteDenormalizedBaseNode.createInfo0(reason, arrayValue, indexValue, valueValue)))) == null) {
                returnNode = (ArrayWriteDenormalizedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ArrayWriteDenormalizedUninitializedNode(this), (Node)new ArrayWriteDenormalizedPolymorphicNode(this), (DSLNode)((ArrayWriteDenormalizedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, arrayValue, indexValue, valueValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayWriteDenormalizedBaseNode specialize0(Object arrayValue, Object indexValue, Object valueValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                return (ArrayWriteDenormalizedBaseNode)ArrayWriteDenormalizedRubyArrayObjectNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.array = null;
                this.index = null;
                this.value = null;
            } else {
                ArrayWriteDenormalizedBaseNode otherCast = (ArrayWriteDenormalizedBaseNode)other;
                this.array = otherCast.array;
                this.index = otherCast.index;
                this.value = otherCast.value;
            }
            this.next0 = newNext == null ? null : (ArrayWriteDenormalizedBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object arrayValue, Object indexValue, Object valueValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("indexValue").append(" = ").append(indexValue);
                if (indexValue != null) {
                    builder.append(" (").append(indexValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("valueValue").append(" = ").append(valueValue);
                if (valueValue != null) {
                    builder.append(" (").append(valueValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

