/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.array.ArrayReadSliceDenormalizedNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=ArrayReadSliceDenormalizedNode.class)
public final class ArrayReadSliceDenormalizedNodeFactory
extends NodeFactoryBase<ArrayReadSliceDenormalizedNode> {
    private static ArrayReadSliceDenormalizedNodeFactory instance;

    private ArrayReadSliceDenormalizedNodeFactory() {
        super(ArrayReadSliceDenormalizedNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class, RubyNode.class}});
    }

    public ArrayReadSliceDenormalizedNode createNode(Object ... arguments) {
        if (!(arguments.length != 5 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode) || arguments[4] != null && !(arguments[4] instanceof RubyNode))) {
            return ArrayReadSliceDenormalizedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]), (RubyNode)((Object)arguments[4]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayReadSliceDenormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
        return ArrayReadSliceDenormalizedUninitializedNode.create0(context, sourceSection, array, index, length);
    }

    public static NodeFactory<ArrayReadSliceDenormalizedNode> getInstance() {
        if (instance == null) {
            instance = new ArrayReadSliceDenormalizedNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayReadSliceDenormalizedNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayReadSliceDenormalizedPolymorphicNode
    extends ArrayReadSliceDenormalizedBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> indexPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> lengthPolymorphicType;

        ArrayReadSliceDenormalizedPolymorphicNode(ArrayReadSliceDenormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            Object lengthValue = this.length.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            Integer lengthValue = lengthValueEvaluated;
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
            this.indexPolymorphicType = types[1];
            this.lengthPolymorphicType = types[2];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }
    }

    @GeneratedBy(value=ArrayReadSliceDenormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadSliceDenormalizedRubyArrayIntNode
    extends ArrayReadSliceDenormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceDenormalizedRubyArrayIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

        ArrayReadSliceDenormalizedRubyArrayIntNode(ArrayReadSliceDenormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int lengthValue;
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                Object lengthValue2 = this.length.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, lengthValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object lengthValue3 = this.length.execute(frameValue);
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), lengthValue3, "Expected indexValue instanceof int");
            }
            try {
                lengthValue = this.length.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, indexValue, ex.getResult(), "Expected lengthValue instanceof int");
            }
            return super.read(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            int lengthValue = lengthValueEvaluated;
            return super.read(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                int lengthValueCast = RubyTypesGen.RUBYTYPES.asInteger(lengthValue);
                return super.read(frameValue, arrayValueCast, indexValueCast, lengthValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceDenormalizedNode create0(ArrayReadSliceDenormalizedNode current) {
            return new ArrayReadSliceDenormalizedRubyArrayIntNode((ArrayReadSliceDenormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadSliceDenormalizedNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayReadSliceDenormalizedUninitializedNode
    extends ArrayReadSliceDenormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadSliceDenormalizedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayReadSliceDenormalizedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
            super(context, sourceSection, array, index, length);
        }

        ArrayReadSliceDenormalizedUninitializedNode(ArrayReadSliceDenormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            Object lengthValue = this.length.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        public Object executeReadSlice(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated, int lengthValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            Integer lengthValue = lengthValueEvaluated;
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue, indexValue, lengthValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue) {
            ArrayReadSliceDenormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue, lengthValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayReadSliceDenormalizedBaseNode rootNode = (ArrayReadSliceDenormalizedBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.index, rootNode.length}, new Object[]{arrayValue, indexValue, lengthValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ArrayReadSliceDenormalizedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        static ArrayReadSliceDenormalizedNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
            return new ArrayReadSliceDenormalizedUninitializedNode(context, sourceSection, array, index, length);
        }
    }

    @GeneratedBy(value=ArrayReadSliceDenormalizedNode.class)
    private static abstract class ArrayReadSliceDenormalizedBaseNode
    extends ArrayReadSliceDenormalizedNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected RubyNode index;
        @Node.Child
        protected RubyNode length;
        @Node.Child
        protected ArrayReadSliceDenormalizedBaseNode next0;

        ArrayReadSliceDenormalizedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index, RubyNode length) {
            super(context, sourceSection);
            this.array = array;
            this.index = index;
            this.length = length;
        }

        ArrayReadSliceDenormalizedBaseNode(ArrayReadSliceDenormalizedBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

        protected final Object rewrite0(VirtualFrame frameValue, Object arrayValue, Object indexValue, Object lengthValue, String reason) {
            String message;
            ArrayReadSliceDenormalizedBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayReadSliceDenormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue, lengthValue);
            if (newNode == null) {
                newNode = new ArrayReadSliceDenormalizedUninitializedNode(this);
                ((ArrayReadSliceDenormalizedUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ArrayReadSliceDenormalizedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ArrayReadSliceDenormalizedBaseNode.createInfo0(reason, arrayValue, indexValue, lengthValue)))) == null) {
                returnNode = (ArrayReadSliceDenormalizedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ArrayReadSliceDenormalizedUninitializedNode(this), (Node)new ArrayReadSliceDenormalizedPolymorphicNode(this), (DSLNode)((ArrayReadSliceDenormalizedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, arrayValue, indexValue, lengthValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayReadSliceDenormalizedBaseNode specialize0(Object arrayValue, Object indexValue, Object lengthValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && RubyTypesGen.RUBYTYPES.isInteger(lengthValue)) {
                return (ArrayReadSliceDenormalizedBaseNode)ArrayReadSliceDenormalizedRubyArrayIntNode.create0(this);
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.array = null;
                this.index = null;
                this.length = null;
            } else {
                ArrayReadSliceDenormalizedBaseNode otherCast = (ArrayReadSliceDenormalizedBaseNode)other;
                this.array = otherCast.array;
                this.index = otherCast.index;
                this.length = otherCast.length;
            }
            this.next0 = newNext == null ? null : (ArrayReadSliceDenormalizedBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object arrayValue, Object indexValue, Object lengthValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("indexValue").append(" = ").append(indexValue);
                if (indexValue != null) {
                    builder.append(" (").append(indexValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("lengthValue").append(" = ").append(lengthValue);
                if (lengthValue != null) {
                    builder.append(" (").append(lengthValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

