/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.array.ArrayReadNormalizedNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@GeneratedBy(value=ArrayReadNormalizedNode.class)
public final class ArrayReadNormalizedNodeFactory
extends NodeFactoryBase<ArrayReadNormalizedNode> {
    private static ArrayReadNormalizedNodeFactory instance;

    private ArrayReadNormalizedNodeFactory() {
        super(ArrayReadNormalizedNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
    }

    public ArrayReadNormalizedNode createNode(Object ... arguments) {
        if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
            return ArrayReadNormalizedNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode)((Object)arguments[2]), (RubyNode)((Object)arguments[3]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayReadNormalizedNode create(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
        return ArrayReadNormalizedUninitializedNode.create0(context, sourceSection, array, index);
    }

    public static NodeFactory<ArrayReadNormalizedNode> getInstance() {
        if (instance == null) {
            instance = new ArrayReadNormalizedNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayReadNormalizedPolymorphicNode
    extends ArrayReadNormalizedBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;
        @CompilerDirectives.CompilationFinal
        private Class<?> indexPolymorphicType;

        ArrayReadNormalizedPolymorphicNode(ArrayReadNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
            this.indexPolymorphicType = types[1];
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadNormalizedRubyNilClassInt1Node
    extends ArrayReadNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadNormalizedRubyNilClassInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        ArrayReadNormalizedRubyNilClassInt1Node(ArrayReadNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value;
            try {
                value = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int"));
            }
            if (!ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.readOutOfBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [!isInBounds] failed"));
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            if (!ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue)) {
                return super.readOutOfBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [!isInBounds] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && !ArrayReadNormalizedBaseNode.isInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue))) {
                return super.readOutOfBounds(arrayValueCast, indexValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        static ArrayReadNormalizedNode create0(ArrayReadNormalizedNode current) {
            return new ArrayReadNormalizedRubyNilClassInt1Node((ArrayReadNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadNormalizedObjectIntNode
    extends ArrayReadNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadNormalizedObjectIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        ArrayReadNormalizedObjectIntNode(ArrayReadNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                return this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray");
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int");
            }
            if (ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return super.readObjectInBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isInBounds, isObjectArray] failed");
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            if (ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isObjectArray(arrayValue)) {
                return super.readObjectInBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isInBounds, isObjectArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && ArrayReadNormalizedBaseNode.isInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue)) && ArrayGuards.isObjectArray(arrayValueCast)) {
                return super.readObjectInBounds(arrayValueCast, indexValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        static ArrayReadNormalizedNode create0(ArrayReadNormalizedNode current) {
            return new ArrayReadNormalizedObjectIntNode((ArrayReadNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadNormalizedDoubleIntNode
    extends ArrayReadNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadNormalizedDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        ArrayReadNormalizedDoubleIntNode(ArrayReadNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            double value;
            try {
                value = this.executeFloat(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int"));
            }
            if (ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return super.readDoubleInBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isInBounds, isDoubleArray] failed"));
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            if (ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isDoubleArray(arrayValue)) {
                return super.readDoubleInBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isInBounds, isDoubleArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && ArrayReadNormalizedBaseNode.isInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue)) && ArrayGuards.isDoubleArray(arrayValueCast)) {
                return super.readDoubleInBounds(arrayValueCast, indexValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        static ArrayReadNormalizedNode create0(ArrayReadNormalizedNode current) {
            return new ArrayReadNormalizedDoubleIntNode((ArrayReadNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadNormalizedLongIntNode
    extends ArrayReadNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadNormalizedLongIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        ArrayReadNormalizedLongIntNode(ArrayReadNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            long value;
            try {
                value = this.executeLongFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int"));
            }
            if (ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isLongArray(arrayValue)) {
                return super.readLongInBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isInBounds, isLongArray] failed"));
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            if (ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isLongArray(arrayValue)) {
                return super.readLongInBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isInBounds, isLongArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && ArrayReadNormalizedBaseNode.isInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue)) && ArrayGuards.isLongArray(arrayValueCast)) {
                return super.readLongInBounds(arrayValueCast, indexValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        static ArrayReadNormalizedNode create0(ArrayReadNormalizedNode current) {
            return new ArrayReadNormalizedLongIntNode((ArrayReadNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadNormalizedIntNode
    extends ArrayReadNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadNormalizedIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        ArrayReadNormalizedIntNode(ArrayReadNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            int value;
            try {
                value = this.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int"));
            }
            if (ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isIntArray(arrayValue)) {
                return super.readIntInBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isInBounds, isIntArray] failed"));
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            if (ArrayReadNormalizedBaseNode.isInBounds(arrayValue, indexValue) && ArrayGuards.isIntArray(arrayValue)) {
                return super.readIntInBounds(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isInBounds, isIntArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            int indexValueCast;
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue) && ArrayReadNormalizedBaseNode.isInBounds(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue), indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue)) && ArrayGuards.isIntArray(arrayValueCast)) {
                return super.readIntInBounds(arrayValueCast, indexValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        static ArrayReadNormalizedNode create0(ArrayReadNormalizedNode current) {
            return new ArrayReadNormalizedIntNode((ArrayReadNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayReadNormalizedRubyNilClassInt0Node
    extends ArrayReadNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadNormalizedRubyNilClassInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

        ArrayReadNormalizedRubyNilClassInt0Node(ArrayReadNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyNilClass value;
            try {
                value = this.executeRubyNilClass(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value;
        }

        @Override
        public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
            int indexValue;
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                Object indexValue2 = this.index.execute(frameValue);
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), indexValue2, "Expected arrayValue instanceof RubyArray"));
            }
            try {
                indexValue = this.index.executeIntegerFixnum(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, ex.getResult(), "Expected indexValue instanceof int"));
            }
            if (ArrayGuards.isNullArray(arrayValue)) {
                return super.readNull(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isNullArray] failed"));
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            RubyArray arrayValue = arrayValueEvaluated;
            int indexValue = indexValueEvaluated;
            if (ArrayGuards.isNullArray(arrayValue)) {
                return super.readNull(arrayValue, indexValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, indexValue, "One of guards [isNullArray] failed");
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (ArrayGuards.isNullArray(arrayValueCast)) {
                    return super.readNull(arrayValueCast, indexValueCast);
                }
            }
            return this.next0.executeChained0(frameValue, arrayValue, indexValue);
        }

        static ArrayReadNormalizedNode create0(ArrayReadNormalizedNode current) {
            return new ArrayReadNormalizedRubyNilClassInt0Node((ArrayReadNormalizedBaseNode)current);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayReadNormalizedUninitializedNode
    extends ArrayReadNormalizedBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayReadNormalizedUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayReadNormalizedUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
            super(context, sourceSection, array, index);
        }

        ArrayReadNormalizedUninitializedNode(ArrayReadNormalizedBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            Object indexValue = this.index.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue, indexValue);
        }

        @Override
        public Object executeRead(VirtualFrame frameValue, RubyArray arrayValueEvaluated, int indexValueEvaluated) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            RubyArray arrayValue = arrayValueEvaluated;
            Integer indexValue = indexValueEvaluated;
            return this.executeUninitialized0(frameValue, arrayValue, indexValue);
        }

        @Override
        protected Object executeChained0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue, indexValue);
        }

        protected Object executeUninitialized0(VirtualFrame frameValue, Object arrayValue, Object indexValue) {
            ArrayReadNormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayReadNormalizedBaseNode rootNode = (ArrayReadNormalizedBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array, rootNode.index}, new Object[]{arrayValue, indexValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ArrayReadNormalizedBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue, indexValue);
        }

        static ArrayReadNormalizedNode create0(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
            return new ArrayReadNormalizedUninitializedNode(context, sourceSection, array, index);
        }
    }

    @GeneratedBy(value=ArrayReadNormalizedNode.class)
    private static abstract class ArrayReadNormalizedBaseNode
    extends ArrayReadNormalizedNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected RubyNode index;
        @Node.Child
        protected ArrayReadNormalizedBaseNode next0;

        ArrayReadNormalizedBaseNode(RubyContext context, SourceSection sourceSection, RubyNode array, RubyNode index) {
            super(context, sourceSection);
            this.array = array;
            this.index = index;
        }

        ArrayReadNormalizedBaseNode(ArrayReadNormalizedBaseNode copy) {
            super(copy);
        }

        protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

        protected final Object rewrite0(VirtualFrame frameValue, Object arrayValue, Object indexValue, String reason) {
            String message;
            ArrayReadNormalizedBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayReadNormalizedBaseNode newNode = this.specialize0(arrayValue, indexValue);
            if (newNode == null) {
                newNode = new ArrayReadNormalizedUninitializedNode(this);
                ((ArrayReadNormalizedUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ArrayReadNormalizedBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message = ArrayReadNormalizedBaseNode.createInfo0(reason, arrayValue, indexValue)))) == null) {
                returnNode = (ArrayReadNormalizedBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ArrayReadNormalizedUninitializedNode(this), (Node)new ArrayReadNormalizedPolymorphicNode(this), (DSLNode)((ArrayReadNormalizedBaseNode)this.copy()), (DSLNode)newNode, (String)message);
            }
            return returnNode.executeChained0(frameValue, arrayValue, indexValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayReadNormalizedBaseNode specialize0(Object arrayValue, Object indexValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && RubyTypesGen.RUBYTYPES.isInteger(indexValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                int indexValueCast = RubyTypesGen.RUBYTYPES.asInteger(indexValue);
                if (ArrayGuards.isNullArray(arrayValueCast)) {
                    return (ArrayReadNormalizedBaseNode)ArrayReadNormalizedRubyNilClassInt0Node.create0(this);
                }
                if (ArrayReadNormalizedNode.isInBounds(arrayValueCast, indexValueCast) && ArrayGuards.isIntArray(arrayValueCast)) {
                    return (ArrayReadNormalizedBaseNode)ArrayReadNormalizedIntNode.create0(this);
                }
                if (ArrayReadNormalizedNode.isInBounds(arrayValueCast, indexValueCast) && ArrayGuards.isLongArray(arrayValueCast)) {
                    return (ArrayReadNormalizedBaseNode)ArrayReadNormalizedLongIntNode.create0(this);
                }
                if (ArrayReadNormalizedNode.isInBounds(arrayValueCast, indexValueCast) && ArrayGuards.isDoubleArray(arrayValueCast)) {
                    return (ArrayReadNormalizedBaseNode)ArrayReadNormalizedDoubleIntNode.create0(this);
                }
                if (ArrayReadNormalizedNode.isInBounds(arrayValueCast, indexValueCast) && ArrayGuards.isObjectArray(arrayValueCast)) {
                    return (ArrayReadNormalizedBaseNode)ArrayReadNormalizedObjectIntNode.create0(this);
                }
                if (!ArrayReadNormalizedNode.isInBounds(arrayValueCast, indexValueCast)) {
                    return (ArrayReadNormalizedBaseNode)ArrayReadNormalizedRubyNilClassInt1Node.create0(this);
                }
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            if (other == null) {
                this.array = null;
                this.index = null;
            } else {
                ArrayReadNormalizedBaseNode otherCast = (ArrayReadNormalizedBaseNode)other;
                this.array = otherCast.array;
                this.index = otherCast.index;
            }
            this.next0 = newNext == null ? null : (ArrayReadNormalizedBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message, Object arrayValue, Object indexValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(", ").append("indexValue").append(" = ").append(indexValue);
                if (indexValue != null) {
                    builder.append(" (").append(indexValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message;
        }
    }
}

