/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.array;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.array.ArrayReadNormalizedNode;
import org.jruby.truffle.nodes.array.ArrayReadNormalizedNodeFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@NodeChildren(value={@NodeChild(value="array", type=RubyNode.class), @NodeChild(value="index", type=RubyNode.class)})
public abstract class ArrayReadDenormalizedNode
extends RubyNode {
    @Node.Child
    private ArrayReadNormalizedNode readNode;

    public ArrayReadDenormalizedNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public ArrayReadDenormalizedNode(ArrayReadDenormalizedNode prev) {
        super(prev);
        this.readNode = prev.readNode;
    }

    public abstract Object executeRead(VirtualFrame var1, RubyArray var2, int var3);

    @Specialization
    public Object read(VirtualFrame frame, RubyArray array, int index) {
        if (this.readNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.readNode = (ArrayReadNormalizedNode)this.insert(ArrayReadNormalizedNodeFactory.create(this.getContext(), this.getSourceSection(), null, null));
        }
        int normalizedIndex = array.normalizeIndex(index);
        return this.readNode.executeRead(frame, array, normalizedIndex);
    }
}

