/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.source.BytesDecoder;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.TruffleBridge;
import org.jruby.ast.RootNode;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.TopLevelRaiseHandler;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.ArrayNodesFactory;
import org.jruby.truffle.nodes.core.BasicObjectNodesFactory;
import org.jruby.truffle.nodes.core.BignumNodesFactory;
import org.jruby.truffle.nodes.core.BindingNodesFactory;
import org.jruby.truffle.nodes.core.ClassNodesFactory;
import org.jruby.truffle.nodes.core.CoreMethodNodeManager;
import org.jruby.truffle.nodes.core.EncodingConverterNodesFactory;
import org.jruby.truffle.nodes.core.EncodingNodesFactory;
import org.jruby.truffle.nodes.core.ExceptionNodesFactory;
import org.jruby.truffle.nodes.core.FalseClassNodesFactory;
import org.jruby.truffle.nodes.core.FiberNodesFactory;
import org.jruby.truffle.nodes.core.FixnumNodesFactory;
import org.jruby.truffle.nodes.core.FloatNodesFactory;
import org.jruby.truffle.nodes.core.HashNodesFactory;
import org.jruby.truffle.nodes.core.IntegerNodesFactory;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.MainNodesFactory;
import org.jruby.truffle.nodes.core.MatchDataNodesFactory;
import org.jruby.truffle.nodes.core.MathNodesFactory;
import org.jruby.truffle.nodes.core.MethodNodesFactory;
import org.jruby.truffle.nodes.core.ModuleNodesFactory;
import org.jruby.truffle.nodes.core.MutexNodesFactory;
import org.jruby.truffle.nodes.core.ObjectSpaceNodesFactory;
import org.jruby.truffle.nodes.core.ProcNodesFactory;
import org.jruby.truffle.nodes.core.ProcessNodesFactory;
import org.jruby.truffle.nodes.core.RangeNodesFactory;
import org.jruby.truffle.nodes.core.RegexpNodesFactory;
import org.jruby.truffle.nodes.core.SetTopLevelBindingNode;
import org.jruby.truffle.nodes.core.StringNodesFactory;
import org.jruby.truffle.nodes.core.SymbolNodesFactory;
import org.jruby.truffle.nodes.core.ThreadNodesFactory;
import org.jruby.truffle.nodes.core.TimeNodesFactory;
import org.jruby.truffle.nodes.core.TrueClassNodesFactory;
import org.jruby.truffle.nodes.core.TrufflePrimitiveNodesFactory;
import org.jruby.truffle.nodes.core.UnboundMethodNodesFactory;
import org.jruby.truffle.nodes.rubinius.ByteArrayNodesFactory;
import org.jruby.truffle.nodes.rubinius.PosixNodesFactory;
import org.jruby.truffle.nodes.rubinius.RubiniusTypeNodesFactory;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.backtrace.Backtrace;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.util.FileUtils;
import org.jruby.truffle.translator.NodeWrapper;
import org.jruby.truffle.translator.TranslatorDriver;
import org.jruby.util.cli.Options;

public class TruffleBridgeImpl
implements TruffleBridge {
    private final Ruby runtime;
    private final RubyContext truffleContext;

    public TruffleBridgeImpl(Ruby runtime) {
        assert (runtime != null);
        this.runtime = runtime;
        this.truffleContext = new RubyContext(runtime);
    }

    public void init() {
        if (((Boolean)Options.TRUFFLE_PRINT_RUNTIME.load()).booleanValue()) {
            this.runtime.getInstanceConfig().getError().println("jruby: using " + Truffle.getRuntime().getName());
        }
        RubyClass rubyObjectClass = this.truffleContext.getCoreLibrary().getObjectClass();
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, ArrayNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, BasicObjectNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, BindingNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, BignumNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, ClassNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, ExceptionNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, FalseClassNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, FiberNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, FixnumNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, FloatNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, HashNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, IntegerNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, KernelNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, MainNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, MatchDataNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, MathNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, ModuleNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, MutexNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, ObjectSpaceNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, ProcessNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, ProcNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, RangeNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, RegexpNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, StringNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, SymbolNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, ThreadNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, TrueClassNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, TrufflePrimitiveNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, EncodingNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, EncodingConverterNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, MethodNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, UnboundMethodNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, ByteArrayNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, TimeNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, PosixNodesFactory.getFactories());
        CoreMethodNodeManager.addCoreMethodNodes(rubyObjectClass, RubiniusTypeNodesFactory.getFactories());
        this.truffleContext.getCoreLibrary().initializeAfterMethodsAdded();
        for (IRubyObject arg : ((RubyArray)this.runtime.getObject().getConstant("ARGV")).toJavaArray()) {
            assert (arg != null);
            this.truffleContext.getCoreLibrary().getArgv().slowPush(this.truffleContext.makeString(arg.toString()));
        }
        org.jruby.truffle.runtime.core.RubyArray loadPath = (org.jruby.truffle.runtime.core.RubyArray)this.truffleContext.getCoreLibrary().getGlobalVariablesObject().getInstanceVariable("$:");
        String home = this.runtime.getInstanceConfig().getJRubyHome();
        ArrayList<String> excludedLibPaths = new ArrayList<String>();
        excludedLibPaths.add(new File(home, "lib/ruby/2.2/site_ruby").toString());
        excludedLibPaths.add(new File(home, "lib/ruby/shared").toString());
        excludedLibPaths.add(new File(home, "lib/ruby/stdlib").toString());
        for (IRubyObject path : ((RubyArray)this.runtime.getLoadService().getLoadPath()).toJavaArray()) {
            if (excludedLibPaths.contains(path.toString())) continue;
            loadPath.slowPush(this.truffleContext.makeString(new File(path.toString()).getAbsolutePath()));
        }
        loadPath.slowPush(this.truffleContext.makeString(new File(home, "lib/ruby/truffle/mri").toString()));
        for (String lib : Arrays.asList("rubysl-strscan", "rubysl-stringio", "rubysl-complex", "rubysl-date", "rubysl-pathname", "rubysl-tempfile", "rubysl-socket")) {
            loadPath.slowPush(this.truffleContext.makeString(new File(home, "lib/ruby/truffle/rubysl/" + lib + "/lib").toString()));
        }
        loadPath.slowPush(this.truffleContext.makeString(new File(home, "lib/ruby/truffle/shims").toString()));
        for (String requiredLibrary : this.truffleContext.getRuntime().getInstanceConfig().getRequiredLibraries()) {
            try {
                this.truffleContext.getFeatureManager().require(requiredLibrary, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (RaiseException e) {
                if (e.getRubyException().getLogicalClass() == this.truffleContext.getCoreLibrary().getLoadErrorClass()) {
                    throw this.truffleContext.getRuntime().newLoadError(e.getRubyException().getMessage().toString(), requiredLibrary);
                }
                throw e;
            }
        }
        if (this.truffleContext.getHooks() != null) {
            this.truffleContext.getHooks().afterInit(this.truffleContext);
        }
    }

    public Object execute(Object self, RootNode rootNode) {
        return this.execute(TranslatorDriver.ParserContext.TOP_LEVEL, self, null, rootNode);
    }

    public Object execute(TranslatorDriver.ParserContext parserContext, Object self, MaterializedFrame parentFrame, RootNode rootNode) {
        Source source;
        this.truffleContext.getCoreLibrary().getGlobalVariablesObject().getOperations().setInstanceVariable(this.truffleContext.getCoreLibrary().getGlobalVariablesObject(), "$0", this.truffleContext.toTruffle(this.runtime.getGlobalVariables().get("$0")));
        String inputFile = rootNode.getPosition().getFile();
        if (inputFile.equals("-e")) {
            source = Source.fromBytes((byte[])this.runtime.getInstanceConfig().inlineScript(), (String)"-e", (BytesDecoder)new BytesDecoder.UTF8BytesDecoder());
        } else {
            byte[] bytes = FileUtils.readAllBytesInterruptedly(this.truffleContext, inputFile);
            source = Source.fromBytes((byte[])bytes, (String)inputFile, (BytesDecoder)new BytesDecoder.UTF8BytesDecoder());
        }
        this.truffleContext.getFeatureManager().setMainScriptSource(source);
        this.truffleContext.load(source, null, new NodeWrapper(){

            @Override
            public RubyNode wrap(RubyNode node) {
                RubyContext context = node.getContext();
                SourceSection sourceSection = node.getSourceSection();
                return SequenceNode.sequence(context, sourceSection, new SetTopLevelBindingNode(context, sourceSection), new TopLevelRaiseHandler(context, sourceSection, node));
            }
        });
        return this.truffleContext.getCoreLibrary().getNilObject();
    }

    public Object toTruffle(IRubyObject object) {
        return this.truffleContext.toTruffle(object);
    }

    public void shutdown() {
        try {
            this.truffleContext.shutdown();
        }
        catch (RaiseException e) {
            RubyException rubyException = e.getRubyException();
            for (String line : Backtrace.DISPLAY_FORMATTER.format(e.getRubyException().getContext(), rubyException, rubyException.getBacktrace())) {
                System.err.println(line);
            }
        }
    }
}

