/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.prism.builder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.EUCJPEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.specific.Windows_31JEncoding;
import org.jruby.ParseResult;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyFloat;
import org.jruby.RubyKernel;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.Tuple;
import org.jruby.ir.builder.IRBuilder;
import org.jruby.ir.instructions.AsStringInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BNilInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BuildCompoundArrayInstr;
import org.jruby.ir.instructions.BuildSplatInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseRequiredKeywordArgumentError;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordsInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SearchModuleForConstInstr;
import org.jruby.ir.instructions.SetCapturedVarInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Boolean;
import org.jruby.ir.operands.BuiltinClass;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.MutableString;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.SymbolProc;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.Variable;
import org.jruby.parser.StaticScope;
import org.jruby.parser.StaticScopeFactory;
import org.jruby.prism.builder.LazyMethodDefinitionPrism;
import org.jruby.prism.parser.ParseResultPrism;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.CommonByteLists;
import org.jruby.util.DefinedMessage;
import org.jruby.util.KCode;
import org.jruby.util.KeyValuePair;
import org.jruby.util.RegexpOptions;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.cli.Options;
import org.prism.Nodes;

public class IRBuilderPrism
extends IRBuilder<Nodes.Node, Nodes.DefNode, Nodes.WhenNode, Nodes.RescueNode, Nodes.ConstantPathNode, Nodes.HashPatternNode> {
    byte[] source;
    Nodes.Source nodeSource;
    StaticScope staticScope;

    public IRBuilderPrism(IRManager manager, IRScope scope, IRBuilder parent, IRBuilder variableBuilder, Encoding encoding) {
        super(manager, scope, parent, variableBuilder, encoding);
        if (parent != null) {
            this.source = ((IRBuilderPrism)parent).source;
            this.nodeSource = ((IRBuilderPrism)parent).nodeSource;
        }
        this.staticScope = scope.getStaticScope();
        this.staticScope.setFile(scope.getFile());
    }

    public void setSourceFrom(IRBuilderPrism other) {
        if (other.nodeSource == null) {
            throw new RuntimeException("WETF");
        }
        this.nodeSource = other.nodeSource;
        this.source = other.source;
    }

    protected void hackPostExeSource(IRBuilder builder) {
        this.setSourceFrom((IRBuilderPrism)builder);
    }

    public void setSourceFrom(Nodes.Source nodeSource, byte[] source) {
        this.nodeSource = nodeSource;
        this.source = source;
    }

    public Operand build(ParseResult result) {
        this.executesOnce = false;
        this.source = ((ParseResultPrism)result).getSource();
        this.nodeSource = ((ParseResultPrism)result).getSourceNode();
        return this.build(((Nodes.ProgramNode)result.getAST()).statements);
    }

    protected Operand build(Nodes.Node node) {
        return this.build(null, node);
    }

    protected Operand build(Variable result, Nodes.Node node) {
        if (node == null) {
            return this.nil();
        }
        if (node.hasNewLineFlag()) {
            this.determineIfWeNeedLineNumber(this.getLine(node), true, false, node instanceof Nodes.DefNode);
        }
        if (node instanceof Nodes.AliasGlobalVariableNode) {
            return this.buildAliasGlobalVariable((Nodes.AliasGlobalVariableNode)node);
        }
        if (node instanceof Nodes.AliasMethodNode) {
            return this.buildAliasMethod((Nodes.AliasMethodNode)node);
        }
        if (node instanceof Nodes.AndNode) {
            return this.buildAnd((Nodes.AndNode)node);
        }
        if (node instanceof Nodes.ArrayNode) {
            return this.buildArray((Nodes.ArrayNode)node);
        }
        if (node instanceof Nodes.AssocSplatNode) {
            return this.buildAssocSplat(result, (Nodes.AssocSplatNode)node);
        }
        if (node instanceof Nodes.BackReferenceReadNode) {
            return this.buildBackReferenceRead(result, (Nodes.BackReferenceReadNode)node);
        }
        if (node instanceof Nodes.BeginNode) {
            return this.buildBegin((Nodes.BeginNode)node);
        }
        if (node instanceof Nodes.BlockArgumentNode) {
            return this.buildBlockArgument((Nodes.BlockArgumentNode)node);
        }
        if (node instanceof Nodes.BlockNode) {
            return this.buildBlock((Nodes.BlockNode)node);
        }
        if (node instanceof Nodes.BreakNode) {
            return this.buildBreak((Nodes.BreakNode)node);
        }
        if (node instanceof Nodes.CallNode) {
            return this.buildCall(result, (Nodes.CallNode)node, ((Nodes.CallNode)node).name);
        }
        if (node instanceof Nodes.CallAndWriteNode) {
            return this.buildCallAndWrite((Nodes.CallAndWriteNode)node);
        }
        if (node instanceof Nodes.CallOrWriteNode) {
            return this.buildCallOrWrite((Nodes.CallOrWriteNode)node);
        }
        if (node instanceof Nodes.CallOperatorWriteNode) {
            return this.buildCallOperatorWrite((Nodes.CallOperatorWriteNode)node);
        }
        if (node instanceof Nodes.CaseNode) {
            return this.buildCase((Nodes.CaseNode)node);
        }
        if (node instanceof Nodes.CaseMatchNode) {
            return this.buildCaseMatch((Nodes.CaseMatchNode)node);
        }
        if (node instanceof Nodes.ClassNode) {
            return this.buildClass((Nodes.ClassNode)node);
        }
        if (node instanceof Nodes.ClassVariableAndWriteNode) {
            return this.buildClassAndVariableWrite((Nodes.ClassVariableAndWriteNode)node);
        }
        if (node instanceof Nodes.ClassVariableOperatorWriteNode) {
            return this.buildClassVariableOperatorWrite((Nodes.ClassVariableOperatorWriteNode)node);
        }
        if (node instanceof Nodes.ClassVariableOrWriteNode) {
            return this.buildClassOrVariableWrite((Nodes.ClassVariableOrWriteNode)node);
        }
        if (node instanceof Nodes.ClassVariableReadNode) {
            return this.buildClassVariableRead(result, (Nodes.ClassVariableReadNode)node);
        }
        if (node instanceof Nodes.ClassVariableWriteNode) {
            return this.buildClassVariableWrite((Nodes.ClassVariableWriteNode)node);
        }
        if (node instanceof Nodes.ConstantAndWriteNode) {
            return this.buildConstantAndWrite((Nodes.ConstantAndWriteNode)node);
        }
        if (node instanceof Nodes.ConstantOperatorWriteNode) {
            return this.buildConstantOperatorWrite((Nodes.ConstantOperatorWriteNode)node);
        }
        if (node instanceof Nodes.ConstantOrWriteNode) {
            return this.buildConstantOrWrite((Nodes.ConstantOrWriteNode)node);
        }
        if (node instanceof Nodes.ConstantPathNode) {
            return this.buildConstantPath(result, (Nodes.ConstantPathNode)node);
        }
        if (node instanceof Nodes.ConstantPathAndWriteNode) {
            return this.buildConstantPathAndWrite((Nodes.ConstantPathAndWriteNode)node);
        }
        if (node instanceof Nodes.ConstantPathOperatorWriteNode) {
            return this.buildConstantPathOperatorWrite((Nodes.ConstantPathOperatorWriteNode)node);
        }
        if (node instanceof Nodes.ConstantPathOrWriteNode) {
            return this.buildConstantPathOrWrite((Nodes.ConstantPathOrWriteNode)node);
        }
        if (node instanceof Nodes.ConstantPathOrWriteNode) {
            return this.buildConstantOrWritePath((Nodes.ConstantPathOrWriteNode)node);
        }
        if (node instanceof Nodes.ConstantPathWriteNode) {
            return this.buildConstantWritePath((Nodes.ConstantPathWriteNode)node);
        }
        if (node instanceof Nodes.ConstantReadNode) {
            return this.buildConstantRead((Nodes.ConstantReadNode)node);
        }
        if (node instanceof Nodes.ConstantWriteNode) {
            return this.buildConstantWrite((Nodes.ConstantWriteNode)node);
        }
        if (node instanceof Nodes.DefNode) {
            return this.buildDef((Nodes.DefNode)node);
        }
        if (node instanceof Nodes.DefinedNode) {
            return this.buildDefined((Nodes.DefinedNode)node);
        }
        if (node instanceof Nodes.ElseNode) {
            return this.buildElse((Nodes.ElseNode)node);
        }
        if (node instanceof Nodes.EmbeddedVariableNode) {
            return this.build(((Nodes.EmbeddedVariableNode)node).variable);
        }
        if (node instanceof Nodes.FalseNode) {
            return this.fals();
        }
        if (node instanceof Nodes.FloatNode) {
            return this.buildFloat((Nodes.FloatNode)node);
        }
        if (node instanceof Nodes.FlipFlopNode) {
            return this.buildFlipFlop((Nodes.FlipFlopNode)node);
        }
        if (node instanceof Nodes.ForNode) {
            return this.buildFor((Nodes.ForNode)node);
        }
        if (node instanceof Nodes.ForwardingSuperNode) {
            return this.buildForwardingSuper(result, (Nodes.ForwardingSuperNode)node);
        }
        if (node instanceof Nodes.GlobalVariableAndWriteNode) {
            return this.buildGlobalVariableAndWrite((Nodes.GlobalVariableAndWriteNode)node);
        }
        if (node instanceof Nodes.GlobalVariableOperatorWriteNode) {
            return this.buildGlobalVariableOperatorWrite((Nodes.GlobalVariableOperatorWriteNode)node);
        }
        if (node instanceof Nodes.GlobalVariableOrWriteNode) {
            return this.buildGlobalVariableOrWrite((Nodes.GlobalVariableOrWriteNode)node);
        }
        if (node instanceof Nodes.GlobalVariableReadNode) {
            return this.buildGlobalVariableRead(result, (Nodes.GlobalVariableReadNode)node);
        }
        if (node instanceof Nodes.GlobalVariableWriteNode) {
            return this.buildGlobalVariableWrite((Nodes.GlobalVariableWriteNode)node);
        }
        if (node instanceof Nodes.HashNode) {
            return this.buildHash(((Nodes.HashNode)node).elements, this.containsVariableAssignment(node));
        }
        if (node instanceof Nodes.IfNode) {
            return this.buildIf(result, (Nodes.IfNode)node);
        }
        if (node instanceof Nodes.ImaginaryNode) {
            return this.buildImaginary((Nodes.ImaginaryNode)node);
        }
        if (node instanceof Nodes.ImplicitNode) {
            return this.build(((Nodes.ImplicitNode)node).value);
        }
        if (node instanceof Nodes.IndexAndWriteNode) {
            return this.buildIndexAndWrite((Nodes.IndexAndWriteNode)node);
        }
        if (node instanceof Nodes.IndexOrWriteNode) {
            return this.buildIndexOrWrite((Nodes.IndexOrWriteNode)node);
        }
        if (node instanceof Nodes.IndexOperatorWriteNode) {
            return this.buildIndexOperatorWrite((Nodes.IndexOperatorWriteNode)node);
        }
        if (node instanceof Nodes.InstanceVariableAndWriteNode) {
            return this.buildInstanceVariableAndWrite((Nodes.InstanceVariableAndWriteNode)node);
        }
        if (node instanceof Nodes.InstanceVariableOperatorWriteNode) {
            return this.buildInstanceVariableOperatorWrite((Nodes.InstanceVariableOperatorWriteNode)node);
        }
        if (node instanceof Nodes.InstanceVariableOrWriteNode) {
            return this.buildInstanceVariableOrWrite((Nodes.InstanceVariableOrWriteNode)node);
        }
        if (node instanceof Nodes.InstanceVariableReadNode) {
            return this.buildInstanceVariableRead((Nodes.InstanceVariableReadNode)node);
        }
        if (node instanceof Nodes.InstanceVariableWriteNode) {
            return this.buildInstanceVariableWrite((Nodes.InstanceVariableWriteNode)node);
        }
        if (node instanceof Nodes.IntegerNode) {
            return this.buildInteger((Nodes.IntegerNode)node);
        }
        if (node instanceof Nodes.InterpolatedMatchLastLineNode) {
            return this.buildInterpolatedMatchLastLine(result, (Nodes.InterpolatedMatchLastLineNode)node);
        }
        if (node instanceof Nodes.InterpolatedRegularExpressionNode) {
            return this.buildInterpolatedRegularExpression(result, (Nodes.InterpolatedRegularExpressionNode)node);
        }
        if (node instanceof Nodes.InterpolatedStringNode) {
            return this.buildInterpolatedString(result, (Nodes.InterpolatedStringNode)node);
        }
        if (node instanceof Nodes.InterpolatedSymbolNode) {
            return this.buildInterpolatedSymbol(result, (Nodes.InterpolatedSymbolNode)node);
        }
        if (node instanceof Nodes.InterpolatedXStringNode) {
            return this.buildInterpolatedXString(result, (Nodes.InterpolatedXStringNode)node);
        }
        if (node instanceof Nodes.KeywordHashNode) {
            return this.buildKeywordHash((Nodes.KeywordHashNode)node, new int[1]);
        }
        if (node instanceof Nodes.LambdaNode) {
            return this.buildLambda((Nodes.LambdaNode)node);
        }
        if (node instanceof Nodes.LocalVariableAndWriteNode) {
            return this.buildLocalAndVariableWrite((Nodes.LocalVariableAndWriteNode)node);
        }
        if (node instanceof Nodes.LocalVariableOperatorWriteNode) {
            return this.buildLocalVariableOperatorWrite((Nodes.LocalVariableOperatorWriteNode)node);
        }
        if (node instanceof Nodes.LocalVariableOrWriteNode) {
            return this.buildLocalOrVariableWrite((Nodes.LocalVariableOrWriteNode)node);
        }
        if (node instanceof Nodes.LocalVariableReadNode) {
            return this.buildLocalVariableRead((Nodes.LocalVariableReadNode)node);
        }
        if (node instanceof Nodes.LocalVariableWriteNode) {
            return this.buildLocalVariableWrite((Nodes.LocalVariableWriteNode)node);
        }
        if (node instanceof Nodes.MatchLastLineNode) {
            return this.buildMatchLastLine(result, (Nodes.MatchLastLineNode)node);
        }
        if (node instanceof Nodes.MatchPredicateNode) {
            return this.buildMatchPredicate((Nodes.MatchPredicateNode)node);
        }
        if (node instanceof Nodes.MatchRequiredNode) {
            return this.buildMatchRequired((Nodes.MatchRequiredNode)node);
        }
        if (node instanceof Nodes.MatchWriteNode) {
            return this.buildMatchWrite(result, (Nodes.MatchWriteNode)node);
        }
        if (node instanceof Nodes.MissingNode) {
            return this.buildMissing((Nodes.MissingNode)node);
        }
        if (node instanceof Nodes.ModuleNode) {
            return this.buildModule((Nodes.ModuleNode)node);
        }
        if (node instanceof Nodes.MultiWriteNode) {
            return this.buildMultiWriteNode((Nodes.MultiWriteNode)node);
        }
        if (node instanceof Nodes.NextNode) {
            return this.buildNext((Nodes.NextNode)node);
        }
        if (node instanceof Nodes.NilNode) {
            return this.nil();
        }
        if (node instanceof Nodes.NumberedReferenceReadNode) {
            return this.buildNumberedReferenceRead((Nodes.NumberedReferenceReadNode)node);
        }
        if (node instanceof Nodes.OrNode) {
            return this.buildOr((Nodes.OrNode)node);
        }
        if (node instanceof Nodes.ParenthesesNode) {
            return this.build(((Nodes.ParenthesesNode)node).body);
        }
        if (node instanceof Nodes.PinnedExpressionNode) {
            return this.build(((Nodes.PinnedExpressionNode)node).expression);
        }
        if (node instanceof Nodes.PinnedVariableNode) {
            return this.build(((Nodes.PinnedVariableNode)node).variable);
        }
        if (node instanceof Nodes.PostExecutionNode) {
            return this.buildPostExecution((Nodes.PostExecutionNode)node);
        }
        if (node instanceof Nodes.PreExecutionNode) {
            return this.buildPreExecution((Nodes.PreExecutionNode)node);
        }
        if (node instanceof Nodes.ProgramNode) {
            return this.buildProgram((Nodes.ProgramNode)node);
        }
        if (node instanceof Nodes.RangeNode) {
            return this.buildRange((Nodes.RangeNode)node);
        }
        if (node instanceof Nodes.RationalNode) {
            return this.buildRational((Nodes.RationalNode)node);
        }
        if (node instanceof Nodes.RedoNode) {
            return this.buildRedo((Nodes.RedoNode)node);
        }
        if (node instanceof Nodes.RegularExpressionNode) {
            return this.buildRegularExpression((Nodes.RegularExpressionNode)node);
        }
        if (node instanceof Nodes.RescueModifierNode) {
            return this.buildRescueModifier((Nodes.RescueModifierNode)node);
        }
        if (node instanceof Nodes.RetryNode) {
            return this.buildRetry((Nodes.RetryNode)node);
        }
        if (node instanceof Nodes.ReturnNode) {
            return this.buildReturn((Nodes.ReturnNode)node);
        }
        if (node instanceof Nodes.SelfNode) {
            return this.buildSelf();
        }
        if (node instanceof Nodes.SingletonClassNode) {
            return this.buildSingletonClass((Nodes.SingletonClassNode)node);
        }
        if (node instanceof Nodes.SourceEncodingNode) {
            return this.buildSourceEncoding();
        }
        if (node instanceof Nodes.SourceFileNode) {
            return this.buildSourceFile();
        }
        if (node instanceof Nodes.SourceLineNode) {
            return this.buildSourceLine(node);
        }
        if (node instanceof Nodes.SplatNode) {
            return this.buildSplat((Nodes.SplatNode)node);
        }
        if (node instanceof Nodes.StatementsNode) {
            return this.buildStatements((Nodes.StatementsNode)node);
        }
        if (node instanceof Nodes.StringNode) {
            return this.buildString((Nodes.StringNode)node);
        }
        if (node instanceof Nodes.SuperNode) {
            return this.buildSuper(result, (Nodes.SuperNode)node);
        }
        if (node instanceof Nodes.SymbolNode) {
            return this.buildSymbol((Nodes.SymbolNode)node);
        }
        if (node instanceof Nodes.TrueNode) {
            return this.tru();
        }
        if (node instanceof Nodes.UndefNode) {
            return this.buildUndef((Nodes.UndefNode)node);
        }
        if (node instanceof Nodes.UnlessNode) {
            return this.buildUnless(result, (Nodes.UnlessNode)node);
        }
        if (node instanceof Nodes.UntilNode) {
            return this.buildUntil((Nodes.UntilNode)node);
        }
        if (node instanceof Nodes.WhileNode) {
            return this.buildWhile((Nodes.WhileNode)node);
        }
        if (node instanceof Nodes.XStringNode) {
            return this.buildXString(result, (Nodes.XStringNode)node);
        }
        if (node instanceof Nodes.YieldNode) {
            return this.buildYield(result, (Nodes.YieldNode)node);
        }
        throw new RuntimeException("Unhandled Node type: " + node);
    }

    private Operand buildCallOperatorWrite(Nodes.CallOperatorWriteNode node) {
        return this.buildOpAsgn(node.receiver, node.value, node.read_name, node.write_name, node.binary_operator, node.isSafeNavigation());
    }

    private Operand buildImaginary(Nodes.ImaginaryNode node) {
        return new Complex((ImmutableLiteral)this.build(node.numeric));
    }

    private Operand buildAliasGlobalVariable(Nodes.AliasGlobalVariableNode node) {
        return this.buildVAlias(this.globalVariableName(node.new_name), this.globalVariableName(node.old_name));
    }

    private Operand buildAliasMethod(Nodes.AliasMethodNode node) {
        return this.buildAlias(this.build(node.new_name), this.build(node.old_name));
    }

    private Operand buildAnd(Nodes.AndNode node) {
        return this.buildAnd(this.build(node.left), () -> this.build(node.right), this.binaryType(node.left));
    }

    private Operand[] buildArguments(Nodes.ArgumentsNode node) {
        return node == null ? Operand.EMPTY_ARRAY : this.buildNodeList(node.arguments);
    }

    private Operand buildAssocSplat(Variable result, Nodes.AssocSplatNode node) {
        return this.build(result, node.value);
    }

    private Operand[] buildNodeList(Nodes.Node[] list) {
        if (list == null || list.length == 0) {
            return Operand.EMPTY_ARRAY;
        }
        Operand[] args = new Operand[list.length];
        for (int i = 0; i < list.length; ++i) {
            args[i] = this.build(list[i]);
        }
        return args;
    }

    private Operand buildArgumentsAsArgument(Nodes.ArgumentsNode node) {
        Operand[] args = this.buildArguments(node);
        return args.length == 0 ? this.nil() : (args.length == 1 ? args[0] : new Array(args));
    }

    private Operand buildArray(Nodes.ArrayNode node) {
        Nodes.Node[] children = node.elements;
        Operand[] elts = new Operand[children.length];
        Variable result = this.temp();
        int splatIndex = -1;
        Operand keywordRestSplat = null;
        for (int i = 0; i < children.length; ++i) {
            Nodes.Node child = children[i];
            if (child instanceof Nodes.SplatNode) {
                int length = i - splatIndex - 1;
                if (length == 0) {
                    if (splatIndex == -1) {
                        this.copy(result, (Operand)new Array());
                    }
                    this.addResultInstr((ResultInstr)new BuildCompoundArrayInstr(result, (Operand)result, this.build(((Nodes.SplatNode)child).expression), false, false));
                } else {
                    Operand[] lhs = new Operand[length];
                    System.arraycopy(elts, splatIndex + 1, lhs, 0, length);
                    if (splatIndex == -1) {
                        this.copy(result, (Operand)new Array(lhs));
                    } else {
                        this.addResultInstr((ResultInstr)new BuildCompoundArrayInstr(result, (Operand)result, (Operand)new Array(lhs), false, false));
                    }
                    this.addResultInstr((ResultInstr)new BuildCompoundArrayInstr(result, (Operand)result, this.build(((Nodes.SplatNode)child).expression), false, false));
                }
                splatIndex = i;
                continue;
            }
            elts[i] = child instanceof Nodes.KeywordHashNode ? (keywordRestSplat = this.build(child)) : this.build(child);
        }
        if (keywordRestSplat != null) {
            Variable test = this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_HASH_EMPTY, new Operand[]{keywordRestSplat}));
            this.if_else((Operand)test, (Operand)this.tru(), () -> this.copy(result, (Operand)new Array(IRBuilderPrism.removeArg((Operand[])elts))), () -> this.copy(result, (Operand)new Array(elts)));
            return result;
        }
        if (splatIndex == -1) {
            return this.copy(result, (Operand)new Array(elts));
        }
        int length = children.length - splatIndex - 1;
        if (length > 0) {
            Operand[] rhs = new Operand[length];
            System.arraycopy(elts, splatIndex + 1, rhs, 0, length);
            this.addResultInstr((ResultInstr)new BuildCompoundArrayInstr(result, (Operand)result, (Operand)new Array(rhs), false, false));
        }
        return result;
    }

    protected void buildAssignment(Nodes.Node node, Operand rhsVal) {
        if (node == null) {
            return;
        }
        if (node instanceof Nodes.CallTargetNode) {
            this.buildAttrAssignAssignment(((Nodes.CallTargetNode)node).receiver, ((Nodes.CallTargetNode)node).name, Nodes.Node.EMPTY_ARRAY, rhsVal);
        } else if (node instanceof Nodes.IndexTargetNode) {
            Nodes.Node[] arguments = ((Nodes.IndexTargetNode)node).arguments == null ? Nodes.Node.EMPTY_ARRAY : ((Nodes.IndexTargetNode)node).arguments.arguments;
            this.buildAttrAssignAssignment(((Nodes.IndexTargetNode)node).receiver, this.symbol("[]="), arguments, rhsVal);
        } else if (node instanceof Nodes.ClassVariableTargetNode) {
            this.addInstr((Instr)new PutClassVariableInstr(this.classVarDefinitionContainer(), ((Nodes.ClassVariableTargetNode)node).name, rhsVal));
        } else if (node instanceof Nodes.ConstantPathTargetNode) {
            Operand parent = this.buildModuleParent(((Nodes.ConstantPathTargetNode)node).parent);
            RubySymbol name = ((Nodes.ConstantPathTargetNode)node).name;
            this.addInstr((Instr)new PutConstInstr(parent, name, rhsVal));
        } else if (node instanceof Nodes.ConstantTargetNode) {
            this.addInstr((Instr)new PutConstInstr((Operand)this.getCurrentModuleVariable(), ((Nodes.ConstantTargetNode)node).name, rhsVal));
        } else if (node instanceof Nodes.LocalVariableTargetNode) {
            Nodes.LocalVariableTargetNode variable = (Nodes.LocalVariableTargetNode)node;
            this.copy((Variable)this.getLocalVariable(variable.name, variable.depth), rhsVal);
        } else if (node instanceof Nodes.GlobalVariableTargetNode) {
            this.addInstr((Instr)new PutGlobalVarInstr(((Nodes.GlobalVariableTargetNode)node).name, rhsVal));
        } else if (node instanceof Nodes.InstanceVariableTargetNode) {
            this.addInstr((Instr)new PutFieldInstr((Operand)this.buildSelf(), ((Nodes.InstanceVariableTargetNode)node).name, rhsVal));
        } else if (node instanceof Nodes.MultiTargetNode) {
            Variable rhs = this.addResultInstr((ResultInstr)new ToAryInstr(this.temp(), rhsVal));
            this.buildMultiAssignment(((Nodes.MultiTargetNode)node).lefts, ((Nodes.MultiTargetNode)node).rest, ((Nodes.MultiTargetNode)node).rights, (Operand)rhs);
        } else if (node instanceof Nodes.MultiWriteNode) {
            Variable rhs = this.addResultInstr((ResultInstr)new ToAryInstr(this.temp(), rhsVal));
            this.buildMultiAssignment(((Nodes.MultiWriteNode)node).lefts, ((Nodes.MultiWriteNode)node).rest, ((Nodes.MultiWriteNode)node).rights, (Operand)rhs);
        } else if (node instanceof Nodes.RequiredParameterNode) {
            Nodes.RequiredParameterNode variable = (Nodes.RequiredParameterNode)node;
            this.copy((Variable)this.getLocalVariable(variable.name, 0), rhsVal);
        } else if (node instanceof Nodes.SplatNode) {
            this.buildSplat(rhsVal);
        } else {
            throw this.notCompilable("Can't build assignment node", node);
        }
    }

    private Operand buildModuleParent(Nodes.Node parent) {
        return parent == null ? this.getCurrentModuleVariable() : this.build(parent);
    }

    protected Operand[] buildAttrAssignCallArgs(Nodes.Node argsNode, Operand[] rhs, boolean containsAssignment) {
        Operand[] args = this.buildCallArgs(argsNode, new int[]{0});
        rhs[0] = args[args.length - 1];
        return args;
    }

    public Operand buildAttrAssignAssignment(Nodes.Node receiver, RubySymbol name, Nodes.Node[] arguments, Operand value) {
        Operand obj = this.build(receiver);
        int[] flags = new int[]{0};
        Operand[] args = this.buildCallArgsArray(arguments, flags);
        args = IRBuilderPrism.addArg((Operand[])args, (Operand)value);
        this.addInstr((Instr)AttrAssignInstr.create((IRScope)this.scope, (Operand)obj, (RubySymbol)name, (Operand[])args, (int)flags[0], (boolean)this.scope.maybeUsingRefinements()));
        return value;
    }

    private Operand buildBackReferenceRead(Variable result, Nodes.BackReferenceReadNode node) {
        return this.buildGlobalVar(result, node.name);
    }

    private Operand buildBreak(Nodes.BreakNode node) {
        return this.buildBreak(() -> node.arguments == null ? this.nil() : this.buildYieldArgs(node.arguments.arguments, new int[1]), this.getLine(node));
    }

    private Operand buildBegin(Nodes.BeginNode node) {
        if (node.rescue_clause != null) {
            Nodes.RescueNode rescue = node.rescue_clause;
            Nodes.StatementsNode ensureBody = node.ensure_clause != null ? node.ensure_clause.statements : null;
            return this.buildEnsureInternal(node.statements, node.else_clause, rescue.exceptions, rescue.statements, rescue.consequent, false, ensureBody, true, rescue.reference);
        }
        if (node.ensure_clause != null) {
            Nodes.EnsureNode ensure = node.ensure_clause;
            return this.buildEnsureInternal(node.statements, null, null, null, null, false, ensure.statements, false, null);
        }
        return this.build(node.statements);
    }

    private Operand buildBlock(Nodes.BlockNode node) {
        StaticScope staticScope = this.createStaticScopeFrom(node.locals, StaticScope.Type.BLOCK);
        Signature signature = this.calculateSignature(node.parameters);
        staticScope.setSignature(signature);
        return this.buildIter(node.parameters, node.body, staticScope, signature, this.getLine(node), this.getEndLine(node));
    }

    protected Variable receiveBlockArg(Variable v, Operand argsArray, int argIndex, boolean isSplat) {
        if (argsArray != null) {
            if (isSplat) {
                this.addInstr((Instr)new RestArgMultipleAsgnInstr(v, argsArray, argIndex));
            } else {
                this.addInstr((Instr)new ReqdArgMultipleAsgnInstr(v, argsArray, argIndex));
            }
        } else {
            Variable keywords = this.copy((Operand)UndefinedValue.UNDEFINED);
            this.addInstr((Instr)(isSplat ? new ReceiveRestArgInstr(v, keywords, argIndex, argIndex) : new ReceivePreReqdArgInstr(v, keywords, argIndex)));
        }
        return v;
    }

    protected void receiveForArgs(Nodes.Node node) {
        Variable keywords = this.copy(this.temp(), (Operand)UndefinedValue.UNDEFINED);
        if (node instanceof Nodes.MultiTargetNode) {
            this.buildBlockArgsAssignment(node, null, 0, false);
        } else if (node instanceof Nodes.ClassVariableTargetNode || node instanceof Nodes.LocalVariableTargetNode || node instanceof Nodes.InstanceVariableTargetNode || node instanceof Nodes.ConstantTargetNode) {
            this.receivePreArg(node, keywords, 0);
        } else {
            throw this.notCompilable("missing arg processing for `for`", node);
        }
    }

    private ArgumentDescriptor[] parametersToArgumentDescriptors(Nodes.NumberedParametersNode node) {
        ArgumentDescriptor[] descriptors = new ArgumentDescriptor[node.maximum];
        for (int i = 0; i < node.maximum; ++i) {
            descriptors[i] = new ArgumentDescriptor(ArgumentType.req, this.symbol("_" + (i + 1)));
        }
        return descriptors;
    }

    public void receiveBlockArgs(Nodes.Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof Nodes.NumberedParametersNode) {
            Nodes.NumberedParametersNode params = (Nodes.NumberedParametersNode)node;
            ((IRClosure)this.scope).setArgumentDescriptors(this.parametersToArgumentDescriptors((Nodes.NumberedParametersNode)node));
            Variable keywords = this.addResultInstr((ResultInstr)new ReceiveKeywordsInstr(this.temp(), true, true));
            for (int i = 0; i < params.maximum; ++i) {
                RubySymbol name = this.symbol("_" + (i + 1));
                this.addInstr((Instr)new ReceivePreReqdArgInstr(this.argumentResult(name), keywords, i));
            }
            this.addInstr((Instr)new CheckArityInstr(params.maximum, 0, false, params.maximum, (Operand)keywords));
        } else {
            this.buildParameters(((Nodes.BlockParametersNode)node).parameters);
            ((IRClosure)this.scope).setArgumentDescriptors(this.createArgumentDescriptor());
        }
    }

    private void buildBlockArgsAssignment(Nodes.Node node, Operand argsArray, int argIndex, boolean isSplat) {
        if (node instanceof Nodes.CallNode) {
            this.buildAttrAssignAssignment(((Nodes.CallNode)node).receiver, ((Nodes.CallNode)node).name, ((Nodes.CallNode)node).arguments.arguments, (Operand)this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat));
        } else if (node instanceof Nodes.LocalVariableTargetNode) {
            Nodes.LocalVariableTargetNode lvar = (Nodes.LocalVariableTargetNode)node;
            this.receiveBlockArg((Variable)this.getLocalVariable(lvar.name, lvar.depth), argsArray, argIndex, isSplat);
        } else if (node instanceof Nodes.ClassVariableTargetNode) {
            this.addInstr((Instr)new PutClassVariableInstr(this.classVarDefinitionContainer(), ((Nodes.ClassVariableTargetNode)node).name, (Operand)this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat)));
        } else if (node instanceof Nodes.ConstantTargetNode) {
            this.putConstant(((Nodes.ConstantTargetNode)node).name, (Operand)this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat));
        } else if (node instanceof Nodes.GlobalVariableTargetNode) {
            this.addInstr((Instr)new PutGlobalVarInstr(((Nodes.GlobalVariableTargetNode)node).name, (Operand)this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat)));
        } else if (node instanceof Nodes.InstanceVariableTargetNode) {
            this.addInstr((Instr)new PutFieldInstr((Operand)this.buildSelf(), ((Nodes.InstanceVariableTargetNode)node).name, (Operand)this.receiveBlockArg(this.temp(), argsArray, argIndex, isSplat)));
        } else if (node instanceof Nodes.MultiTargetNode) {
            Nodes.MultiTargetNode multi = (Nodes.MultiTargetNode)node;
            for (int i = 0; i < multi.lefts.length; ++i) {
                this.buildBlockArgsAssignment(multi.lefts[i], null, i, false);
            }
            int postIndex = multi.lefts.length;
            if (multi.rest != null) {
                this.buildBlockArgsAssignment(multi.rest, null, postIndex, true);
                ++postIndex;
            }
            for (int i = 0; i < multi.rights.length; ++i) {
                this.buildBlockArgsAssignment(multi.rights[i], null, postIndex + i, false);
            }
        } else if (!(node instanceof Nodes.SplatNode) && !(node instanceof Nodes.ImplicitRestNode)) {
            throw this.notCompilable("Can't build assignment node", node);
        }
    }

    private Operand buildBlockArgument(Nodes.BlockArgumentNode node) {
        if (node.expression instanceof Nodes.SymbolNode && !this.scope.maybeUsingRefinements()) {
            return new SymbolProc(this.symbol((Nodes.SymbolNode)node.expression));
        }
        if (node.expression == null) {
            return this.getYieldClosureVariable();
        }
        return this.build(node.expression);
    }

    private Operand buildCall(Variable resultArg, Nodes.CallNode node, RubySymbol name) {
        return this.buildCall(resultArg, node, name, null, null);
    }

    protected Operand buildLazyWithOrder(Nodes.CallNode node, Label lazyLabel, Label endLabel, boolean preserveOrder) {
        Operand value = this.buildCall(null, node, node.name, lazyLabel, endLabel);
        return preserveOrder ? this.copy(value) : value;
    }

    private Operand buildCall(Variable resultArg, Nodes.CallNode node, RubySymbol name, Label lazyLabel, Label endLabel) {
        Variable result;
        Variable variable = result = resultArg == null ? this.temp() : resultArg;
        if (node.isVariableCall()) {
            return this._call(result, CallType.VARIABLE, (Operand)this.buildSelf(), name, new Operand[0]);
        }
        CallType callType = this.determineCallType(node.receiver);
        String id = name.idString();
        if (node.isAttributeWrite()) {
            return this.buildAttrAssign(result, node.receiver, node.arguments, node.block, node.name, node.isSafeNavigation(), this.containsVariableAssignment(node));
        }
        if (callType != CallType.FUNCTIONAL && ((java.lang.Boolean)Options.IR_STRING_FREEZE.load()).booleanValue() && node.receiver instanceof Nodes.StringNode && (id.equals("freeze") || id.equals("-@"))) {
            return new FrozenString(this.bytelistFrom((Nodes.StringNode)node.receiver), 0, this.scope.getFile(), this.getLine(node.receiver));
        }
        if (node.isSafeNavigation() && lazyLabel == null) {
            lazyLabel = this.getNewLabel();
            endLabel = this.getNewLabel();
        }
        Object receiver = callType == CallType.FUNCTIONAL ? this.buildSelf() : (node.receiver instanceof Nodes.CallNode && ((Nodes.CallNode)node.receiver).isSafeNavigation() ? this.buildLazyWithOrder((Nodes.CallNode)node.receiver, lazyLabel, endLabel, true) : this.buildWithOrder(node.receiver, true));
        if (node.isSafeNavigation()) {
            this.addInstr((Instr)new BNilInstr(lazyLabel, (Operand)receiver));
        }
        this.createCall(result, (Operand)receiver, callType, name, node.arguments, node.block, this.getLine(node), node.hasNewLineFlag());
        if (node.isSafeNavigation()) {
            this.addInstr((Instr)new JumpInstr(endLabel));
            this.addInstr((Instr)new LabelInstr(lazyLabel));
            this.addInstr((Instr)new CopyInstr(result, (Operand)this.nil()));
            this.addInstr((Instr)new LabelInstr(endLabel));
        }
        return result;
    }

    private Operand buildCallAndWrite(Nodes.CallAndWriteNode node) {
        return this.buildOpAsgn(node.receiver, node.value, node.read_name, node.write_name, this.symbol(CommonByteLists.AMPERSAND_AMPERSAND), node.isSafeNavigation());
    }

    protected Operand[] buildCallArgs(Nodes.Node args, int[] flags) {
        return this.buildCallArgsArray(((Nodes.ArgumentsNode)args).arguments, flags);
    }

    protected Operand[] buildCallArgsArray(Nodes.Node[] children, int[] flags) {
        int numberOfArgs = children.length;
        if (numberOfArgs > 0 && children[numberOfArgs - 1] instanceof Nodes.BlockArgumentNode) {
            Nodes.Node[] temp = children;
            children = new Nodes.Node[--numberOfArgs];
            System.arraycopy(temp, 0, children, 0, numberOfArgs);
        }
        Operand[] builtArgs = new Operand[numberOfArgs];
        boolean hasAssignments = this.containsVariableAssignment(children);
        for (int i = 0; i < numberOfArgs; ++i) {
            Nodes.Node child = children[i];
            if (child instanceof Nodes.SplatNode) {
                flags[0] = flags[0] | 1;
                builtArgs[i] = new Splat((Operand)this.addResultInstr((ResultInstr)new BuildSplatInstr(this.temp(), this.build(((Nodes.SplatNode)child).expression), true)));
                continue;
            }
            if (child instanceof Nodes.KeywordHashNode && i == numberOfArgs - 1) {
                builtArgs[i] = this.buildCallKeywordArguments((Nodes.KeywordHashNode)children[i], flags);
                continue;
            }
            if (child instanceof Nodes.ForwardingArgumentsNode) {
                Operand rest = this.buildSplat((Operand)this.getLocalVariable(this.symbol(CommonByteLists.FWD_REST), this.scope.getStaticScope().isDefined("*")));
                LocalVariable kwRest = this.getLocalVariable(this.symbol(CommonByteLists.FWD_KWREST), this.scope.getStaticScope().isDefined("**"));
                Variable check = this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.HASH_CHECK, new Operand[]{kwRest}));
                Variable ary = this.addResultInstr((ResultInstr)new BuildCompoundArrayInstr(this.temp(), rest, (Operand)check, true, true));
                builtArgs[i] = new Splat(this.buildSplat((Operand)ary));
                flags[0] = flags[0] | 7;
                continue;
            }
            builtArgs[i] = this.buildWithOrder(children[i], hasAssignments);
        }
        return builtArgs;
    }

    protected Operand buildCallKeywordArguments(Nodes.KeywordHashNode node, int[] flags) {
        flags[0] = flags[0] | 2;
        if (this.hasOnlyRestKwargs(node.elements)) {
            return this.buildRestKeywordArgs(node, flags);
        }
        return this.buildHash(node.elements, this.containsVariableAssignment(node.elements));
    }

    private Operand buildCallOrWrite(Nodes.CallOrWriteNode node) {
        return this.buildOpAsgn(node.receiver, node.value, node.read_name, node.write_name, this.symbol(CommonByteLists.OR_OR), node.isSafeNavigation());
    }

    private Operand buildCase(Nodes.CaseNode node) {
        return this.buildCase(node.predicate, node.conditions, node.consequent);
    }

    private Operand buildCaseMatch(Nodes.CaseMatchNode node) {
        return this.buildPatternCase(node.predicate, node.conditions, node.consequent);
    }

    private Operand buildClass(Nodes.ClassNode node) {
        return this.buildClass(this.determineBaseName(node.constant_path), node.superclass, node.constant_path, node.body, this.createStaticScopeFrom(node.locals, StaticScope.Type.LOCAL), this.getLine(node), this.getEndLine(node));
    }

    private Operand buildClassVariableOperatorWrite(Nodes.ClassVariableOperatorWriteNode node) {
        Operand lhs = this.buildClassVar(this.temp(), node.name);
        Operand rhs = this.build(node.value);
        Variable value = this.call(this.temp(), lhs, node.binary_operator, new Operand[]{rhs});
        this.addInstr((Instr)new PutClassVariableInstr(this.classVarDefinitionContainer(), node.name, (Operand)value));
        return value;
    }

    private Operand buildInstanceVariableOperatorWrite(Nodes.InstanceVariableOperatorWriteNode node) {
        Operand lhs = this.buildInstVar(node.name);
        Operand rhs = this.build(node.value);
        Variable value = this.call(this.temp(), lhs, node.binary_operator, new Operand[]{rhs});
        this.addInstr((Instr)new PutFieldInstr((Operand)this.buildSelf(), node.name, (Operand)value));
        return value;
    }

    private Operand buildLocalVariableOperatorWrite(Nodes.LocalVariableOperatorWriteNode node) {
        int depth = this.staticScope.isDefined(node.name.idString()) >> 16;
        LocalVariable lhs = this.getLocalVariable(node.name, depth);
        Operand rhs = this.build(node.value);
        Variable value = this.call((Variable)lhs, (Operand)lhs, node.binary_operator, new Operand[]{rhs});
        return value;
    }

    private Operand buildClassAndVariableWrite(Nodes.ClassVariableAndWriteNode node) {
        return this.buildOpAsgnAnd(() -> this.addResultInstr((ResultInstr)new GetClassVariableInstr(this.temp(), this.classVarDefinitionContainer(), node.name)), () -> this.buildClassVarAsgn(node.name, node.value));
    }

    private Operand buildClassOrVariableWrite(Nodes.ClassVariableOrWriteNode node) {
        return this.buildOpAsgnOrWithDefined(node, result -> this.addInstr((Instr)new GetClassVariableInstr((Variable)result, this.classVarDefinitionContainer(), node.name)), () -> this.buildClassVarAsgn(node.name, node.value));
    }

    private Operand buildClassVariableRead(Variable result, Nodes.ClassVariableReadNode node) {
        return this.buildClassVar(result, node.name);
    }

    private Operand buildClassVariableWrite(Nodes.ClassVariableWriteNode node) {
        return this.buildClassVarAsgn(node.name, node.value);
    }

    protected Operand buildColon2ForConstAsgnDeclNode(Nodes.Node lhs, Variable valueResult, boolean constMissing) {
        Variable leftModule = this.temp();
        Nodes.ConstantPathNode colon2Node = (Nodes.ConstantPathNode)lhs;
        RubySymbol name = this.symbol(this.determineBaseName(colon2Node));
        Object leftValue = colon2Node.parent == null ? this.getManager().getObjectClass() : this.build(colon2Node.parent);
        this.copy(leftModule, (Operand)leftValue);
        this.addInstr((Instr)new SearchModuleForConstInstr(valueResult, (Operand)leftModule, name, false, constMissing));
        return leftModule;
    }

    private Operand buildConstantAndWrite(Nodes.ConstantAndWriteNode node) {
        return this.buildOpAsgnAnd(() -> this.addResultInstr((ResultInstr)new SearchConstInstr(this.temp(), (Operand)CurrentScope.INSTANCE, node.name, false)), () -> this.putConstant(node.name, this.build(node.value)));
    }

    private Operand buildConstantOperatorWrite(Nodes.ConstantOperatorWriteNode node) {
        Operand lhs = this.searchConst(this.temp(), node.name);
        Operand rhs = this.build(node.value);
        Variable value = this.call(this.temp(), lhs, node.binary_operator, new Operand[]{rhs});
        this.putConstant((Operand)this.buildSelf(), node.name, (Operand)value);
        return value;
    }

    private Operand buildConstantOrWrite(Nodes.ConstantOrWriteNode node) {
        return this.buildOpAsgnOrWithDefined(node, result -> this.addInstr((Instr)new SearchConstInstr((Variable)result, (Operand)CurrentScope.INSTANCE, node.name, false)), () -> this.putConstant(node.name, this.build(node.value)));
    }

    private Operand buildConstantOrWritePath(Nodes.ConstantPathOrWriteNode node) {
        RubySymbol name = node.target.name;
        Variable result = this.temp();
        Label falseCheck = this.getNewLabel();
        Label done = this.getNewLabel();
        Label assign = this.getNewLabel();
        BuiltinClass module = node.target.parent == null ? this.getManager().getObjectClass() : this.build(node.target.parent);
        this.searchModuleForConstNoFrills(result, (Operand)module, name);
        this.addInstr((Instr)BNEInstr.create((Label)falseCheck, (Operand)result, (Operand)UndefinedValue.UNDEFINED));
        this.addInstr((Instr)new JumpInstr(assign));
        this.addInstr((Instr)new LabelInstr(falseCheck));
        this.addInstr((Instr)BNEInstr.create((Label)done, (Operand)result, (Operand)this.fals()));
        this.addInstr((Instr)new LabelInstr(assign));
        Operand rhsValue = this.build(node.value);
        this.copy(result, rhsValue);
        this.addInstr((Instr)new PutConstInstr((Operand)module, name, rhsValue));
        this.addInstr((Instr)new LabelInstr(done));
        return result;
    }

    private Operand buildConstantPath(Variable result, Nodes.ConstantPathNode node) {
        return this.buildConstantPath(result, node.name, node.parent);
    }

    private Operand buildConstantPath(Variable result, RubySymbol name, Nodes.Node parent) {
        BuiltinClass where = parent == null ? this.getManager().getObjectClass() : this.build(parent);
        return this.searchModuleForConst(result, (Operand)where, name);
    }

    private Operand buildConstantPathAndWrite(Nodes.ConstantPathAndWriteNode node) {
        return this.buildOpAsgnConstDeclAnd(node.target, node.value, this.symbol(this.determineBaseName(node.target)));
    }

    private Operand buildConstantPathOperatorWrite(Nodes.ConstantPathOperatorWriteNode node) {
        return this.buildOpAsgnConstDecl(node.target, node.value, node.binary_operator);
    }

    private Operand buildConstantPathOrWrite(Nodes.ConstantPathOrWriteNode node) {
        return this.buildOpAsgnConstDeclOr(node.target, node.value, this.symbol(this.determineBaseName(node.target)));
    }

    private Operand buildConstantRead(Nodes.ConstantReadNode node) {
        return this.addResultInstr((ResultInstr)new SearchConstInstr(this.temp(), (Operand)CurrentScope.INSTANCE, node.name, false));
    }

    private Operand buildConstantWrite(Nodes.ConstantWriteNode node) {
        return this.putConstant(node.name, this.build(node.value));
    }

    private Operand buildConstantWritePath(Nodes.ConstantPathWriteNode node) {
        return this.buildConstantWritePath(node.target, this.build(node.value));
    }

    private Operand buildConstantWritePath(Nodes.ConstantPathNode path, Operand value) {
        return this.putConstant(this.buildModuleParent(path.parent), path.name, value);
    }

    private Operand buildDef(Nodes.DefNode node) {
        StaticScope staticScope = this.createStaticScopeFrom(node.locals, StaticScope.Type.LOCAL);
        staticScope.setSignature(IRBuilderPrism.calculateSignature(node.parameters));
        LazyMethodDefinitionPrism def = new LazyMethodDefinitionPrism(this.source, this.nodeSource, this.encoding, node);
        if (node.receiver == null) {
            return this.buildDefn(this.defineNewMethod(def, node.name.getBytes(), this.getLine(node), staticScope, true));
        }
        return this.buildDefs(node.receiver, this.defineNewMethod(def, node.name.getBytes(), this.getLine(node), staticScope, false));
    }

    private Operand buildDefined(Nodes.DefinedNode node) {
        return this.buildGetDefinition(node.value);
    }

    private Operand buildElse(Nodes.ElseNode node) {
        return this.buildStatements(node.statements);
    }

    private Operand buildFlipFlop(Nodes.FlipFlopNode node) {
        return this.buildFlip(node.left, node.right, node.isExcludeEnd());
    }

    private Operand buildFloat(Nodes.FloatNode node) {
        String number = this.bytelistFrom(node).toString();
        IRubyObject fl = RubyKernel.new_float((ThreadContext)this.getManager().getRuntime().getCurrentContext(), (IRubyObject)this.getManager().getRuntime().newString(number), (boolean)false);
        return new Float(((RubyFloat)fl).getDoubleValue());
    }

    private Operand buildFor(Nodes.ForNode node) {
        return this.buildFor(node.collection, node.index, node.statements, this.scope.getStaticScope(), this.calculateSignatureFor(node.index), this.getLine(node), this.getEndLine(node));
    }

    private Operand buildForwardingSuper(Variable result, Nodes.ForwardingSuperNode node) {
        return this.buildZSuper(result, node.block);
    }

    public Operand buildGetArgumentDefinition(Nodes.ArgumentsNode node, String type) {
        if (node == null) {
            return new MutableString(type);
        }
        FrozenString rv = new FrozenString(type);
        boolean failPathReqd = false;
        Label failLabel = this.getNewLabel();
        for (Nodes.Node arg : node.arguments) {
            Operand def = this.buildGetDefinition(arg);
            if (def == this.nil()) {
                rv = this.nil();
                break;
            }
            if (def.hasKnownValue()) continue;
            failPathReqd = true;
            this.addInstr(IRBuilderPrism.createBranch((Operand)def, (Operand)this.nil(), (Label)failLabel));
        }
        return failPathReqd ? this.buildDefnCheckIfThenPaths(failLabel, (Operand)rv) : rv;
    }

    protected Operand buildGetDefinition2(Nodes.Node node) {
        if (node instanceof Nodes.ClassVariableOrWriteNode) {
            return this.buildClassVarGetDefinition(((Nodes.ClassVariableOrWriteNode)node).name);
        }
        if (node instanceof Nodes.GlobalVariableOrWriteNode) {
            return this.buildGlobalVarGetDefinition(((Nodes.GlobalVariableOrWriteNode)node).name);
        }
        if (node instanceof Nodes.ConstantOrWriteNode) {
            return this.buildConstantGetDefinition(((Nodes.ConstantOrWriteNode)node).name);
        }
        return this.buildGetDefinition(node);
    }

    protected Operand buildGetDefinition(Nodes.Node node) {
        if (node == null) {
            return new FrozenString("expression");
        }
        if (node instanceof Nodes.ClassVariableWriteNode || node instanceof Nodes.ClassVariableAndWriteNode || node instanceof Nodes.ClassVariableOperatorWriteNode || node instanceof Nodes.ClassVariableOrWriteNode || node instanceof Nodes.ConstantAndWriteNode || node instanceof Nodes.ConstantOrWriteNode || node instanceof Nodes.ConstantPathWriteNode || node instanceof Nodes.ConstantWriteNode || node instanceof Nodes.InstanceVariableAndWriteNode || node instanceof Nodes.InstanceVariableOrWriteNode || node instanceof Nodes.InstanceVariableOperatorWriteNode || node instanceof Nodes.LocalVariableWriteNode || node instanceof Nodes.LocalVariableAndWriteNode || node instanceof Nodes.LocalVariableOrWriteNode || node instanceof Nodes.LocalVariableOperatorWriteNode || node instanceof Nodes.ConstantOperatorWriteNode || node instanceof Nodes.GlobalVariableOrWriteNode || node instanceof Nodes.GlobalVariableAndWriteNode || node instanceof Nodes.GlobalVariableWriteNode || node instanceof Nodes.GlobalVariableOperatorWriteNode || node instanceof Nodes.MultiWriteNode || node instanceof Nodes.InstanceVariableWriteNode || node instanceof Nodes.IndexAndWriteNode || node instanceof Nodes.IndexOrWriteNode || node instanceof Nodes.IndexOperatorWriteNode || node instanceof Nodes.CallAndWriteNode || node instanceof Nodes.CallOrWriteNode || node instanceof Nodes.CallOperatorWriteNode) {
            return new FrozenString(DefinedMessage.ASSIGNMENT.getText());
        }
        if (node instanceof Nodes.OrNode || node instanceof Nodes.AndNode || node instanceof Nodes.InterpolatedRegularExpressionNode || node instanceof Nodes.InterpolatedStringNode) {
            return new FrozenString(DefinedMessage.EXPRESSION.getText());
        }
        if (node instanceof Nodes.ParenthesesNode) {
            if (((Nodes.ParenthesesNode)node).body instanceof Nodes.StatementsNode) {
                Nodes.StatementsNode statements = (Nodes.StatementsNode)((Nodes.ParenthesesNode)node).body;
                switch (statements.body.length) {
                    case 0: {
                        return this.nil();
                    }
                    case 1: {
                        return this.buildGetDefinition(statements.body[0]);
                    }
                }
            }
            return new FrozenString(DefinedMessage.EXPRESSION.getText());
        }
        if (node instanceof Nodes.FalseNode) {
            return new FrozenString(DefinedMessage.FALSE.getText());
        }
        if (node instanceof Nodes.LocalVariableReadNode) {
            return new FrozenString(DefinedMessage.LOCAL_VARIABLE.getText());
        }
        if (node instanceof Nodes.MatchPredicateNode || node instanceof Nodes.MatchRequiredNode) {
            return new FrozenString(DefinedMessage.METHOD.getText());
        }
        if (node instanceof Nodes.NilNode) {
            return new FrozenString(DefinedMessage.NIL.getText());
        }
        if (node instanceof Nodes.SelfNode) {
            return new FrozenString(DefinedMessage.SELF.getText());
        }
        if (node instanceof Nodes.TrueNode) {
            return new FrozenString(DefinedMessage.TRUE.getText());
        }
        if (node instanceof Nodes.StatementsNode) {
            Nodes.Node[] array = ((Nodes.StatementsNode)node).body;
            Label undefLabel = this.getNewLabel();
            Label doneLabel = this.getNewLabel();
            Variable tmpVar = this.temp();
            for (Nodes.Node elt : array) {
                Operand result = this.buildGetDefinition(elt);
                this.addInstr(IRBuilderPrism.createBranch((Operand)result, (Operand)this.nil(), (Label)undefLabel));
            }
            this.addInstr((Instr)new CopyInstr(tmpVar, (Operand)new FrozenString(DefinedMessage.EXPRESSION.getText())));
            this.addInstr((Instr)new JumpInstr(doneLabel));
            this.addInstr((Instr)new LabelInstr(undefLabel));
            this.addInstr((Instr)new CopyInstr(tmpVar, (Operand)this.nil()));
            this.addInstr((Instr)new LabelInstr(doneLabel));
            return tmpVar;
        }
        if (node instanceof Nodes.GlobalVariableReadNode) {
            return this.buildGlobalVarGetDefinition(((Nodes.GlobalVariableReadNode)node).name);
        }
        if (node instanceof Nodes.BackReferenceReadNode) {
            return this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_BACKREF, new Operand[]{new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
        }
        if (node instanceof Nodes.NumberedReferenceReadNode) {
            return this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_NTH_REF, new Operand[]{this.fix(((Nodes.NumberedReferenceReadNode)node).number), new FrozenString(DefinedMessage.GLOBAL_VARIABLE.getText())}));
        }
        if (node instanceof Nodes.InstanceVariableReadNode) {
            return this.buildInstVarGetDefinition(((Nodes.InstanceVariableReadNode)node).name);
        }
        if (node instanceof Nodes.InstanceVariableOrWriteNode) {
            return this.buildInstVarGetDefinition(((Nodes.InstanceVariableOrWriteNode)node).name);
        }
        if (node instanceof Nodes.ClassVariableReadNode) {
            return this.buildClassVarGetDefinition(((Nodes.ClassVariableReadNode)node).name);
        }
        if (node instanceof Nodes.SuperNode) {
            Label undefLabel = this.getNewLabel();
            Variable tmpVar = this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{this.buildSelf(), new FrozenString(DefinedMessage.SUPER.getText())}));
            this.addInstr(IRBuilderPrism.createBranch((Operand)tmpVar, (Operand)this.nil(), (Label)undefLabel));
            Operand superDefnVal = this.buildGetArgumentDefinition(((Nodes.SuperNode)node).arguments, DefinedMessage.SUPER.getText());
            return this.buildDefnCheckIfThenPaths(undefLabel, superDefnVal);
        }
        if (node instanceof Nodes.ForwardingSuperNode) {
            return this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{this.buildSelf(), new FrozenString(DefinedMessage.SUPER.getText())}));
        }
        if (node instanceof Nodes.CallNode) {
            final Nodes.CallNode call = (Nodes.CallNode)node;
            if (call.receiver == null && call.arguments == null) {
                return this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{this.buildSelf(), new FrozenString(call.name), this.fals(), new FrozenString(DefinedMessage.METHOD.getText())}));
            }
            String type = DefinedMessage.METHOD.getText();
            if (call.receiver == null) {
                Label undefLabel = this.getNewLabel();
                Variable tmpVar = this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{this.buildSelf(), new Symbol(call.name), this.fals(), new FrozenString(DefinedMessage.METHOD.getText())}));
                this.addInstr(IRBuilderPrism.createBranch((Operand)tmpVar, (Operand)this.nil(), (Label)undefLabel));
                Operand argsCheckDefn = this.buildGetArgumentDefinition(((Nodes.CallNode)node).arguments, type);
                return this.buildDefnCheckIfThenPaths(undefLabel, argsCheckDefn);
            }
            IRBuilder.CodeBlock protectedCode = new IRBuilder.CodeBlock(){

                public Operand run() {
                    Label undefLabel = IRBuilderPrism.this.getNewLabel();
                    Operand receiverDefn = IRBuilderPrism.this.buildGetDefinition(call.receiver);
                    IRBuilderPrism.this.addInstr(IRBuilder.createBranch((Operand)receiverDefn, (Operand)IRBuilderPrism.this.nil(), (Label)undefLabel));
                    Variable tmpVar = IRBuilderPrism.this.temp();
                    IRBuilderPrism.this.addInstr((Instr)new RuntimeHelperCall(tmpVar, RuntimeHelperCall.Methods.IS_DEFINED_CALL, new Operand[]{IRBuilderPrism.this.build(call.receiver), new Symbol(call.name), new FrozenString(DefinedMessage.METHOD.getText())}));
                    return IRBuilderPrism.this.buildDefnCheckIfThenPaths(undefLabel, (Operand)tmpVar);
                }
            };
            return this.protectCodeWithRescue(protectedCode, () -> this.nil());
        }
        if (node instanceof Nodes.YieldNode) {
            return this.buildDefinitionCheck((ResultInstr)new BlockGivenInstr(this.temp(), (Operand)this.getYieldClosureVariable()), DefinedMessage.YIELD.getText());
        }
        if (node instanceof Nodes.SuperNode) {
            return this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{this.buildSelf(), new FrozenString(DefinedMessage.SUPER.getText())}));
        }
        if (node instanceof Nodes.ConstantReadNode) {
            return this.buildConstantGetDefinition(((Nodes.ConstantReadNode)node).name);
        }
        if (node instanceof Nodes.ConstantPathNode) {
            Nodes.ConstantPathNode path = (Nodes.ConstantPathNode)node;
            RubySymbol name = path.name;
            Variable errInfo = this.temp();
            this.addInstr((Instr)new GetErrorInfoInstr(errInfo));
            IRBuilder.CodeBlock protectedCode = () -> {
                if (path.parent == null) {
                    return this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.IS_DEFINED_CONSTANT_OR_METHOD, new Operand[]{this.getManager().getObjectClass(), new FrozenString(name), new FrozenString(DefinedMessage.CONSTANT.getText()), new FrozenString(DefinedMessage.METHOD.getText())}));
                }
                Label bad = this.getNewLabel();
                Label done = this.getNewLabel();
                Variable result = this.temp();
                Operand test = this.buildGetDefinition(path.parent);
                this.addInstr(IRBuilderPrism.createBranch((Operand)test, (Operand)this.nil(), (Label)bad));
                Operand lhs = this.build(path.parent);
                this.addInstr((Instr)new RuntimeHelperCall(result, RuntimeHelperCall.Methods.IS_DEFINED_CONSTANT_OR_METHOD, new Operand[]{lhs, new FrozenString(name), new FrozenString(DefinedMessage.CONSTANT.getText()), new FrozenString(DefinedMessage.METHOD.getText())}));
                this.addInstr((Instr)new JumpInstr(done));
                this.addInstr((Instr)new LabelInstr(bad));
                this.addInstr((Instr)new CopyInstr(result, (Operand)this.nil()));
                this.addInstr((Instr)new LabelInstr(done));
                return result;
            };
            return this.protectCodeWithRescue(protectedCode, () -> {
                this.addInstr((Instr)new RestoreErrorInfoInstr((Operand)errInfo));
                return this.nil();
            });
        }
        if (node instanceof Nodes.ArrayNode) {
            Nodes.ArrayNode array = (Nodes.ArrayNode)node;
            Label undefLabel = this.getNewLabel();
            Label doneLabel = this.getNewLabel();
            Variable tmpVar = this.temp();
            for (Nodes.Node elt : array.elements) {
                Operand result = this.buildGetDefinition(elt);
                this.addInstr(IRBuilderPrism.createBranch((Operand)result, (Operand)this.nil(), (Label)undefLabel));
            }
            this.addInstr((Instr)new CopyInstr(tmpVar, (Operand)new FrozenString(DefinedMessage.EXPRESSION.getText())));
            this.addInstr((Instr)new JumpInstr(doneLabel));
            this.addInstr((Instr)new LabelInstr(undefLabel));
            this.addInstr((Instr)new CopyInstr(tmpVar, (Operand)this.nil()));
            this.addInstr((Instr)new LabelInstr(doneLabel));
            return tmpVar;
        }
        return new FrozenString("expression");
    }

    private Operand buildGlobalVariableRead(Variable result, Nodes.GlobalVariableReadNode node) {
        return this.buildGlobalVar(result, node.name);
    }

    private Operand buildGlobalVariableOperatorWrite(Nodes.GlobalVariableOperatorWriteNode node) {
        Operand lhs = this.buildGlobalVar(this.temp(), node.name);
        Operand rhs = this.build(node.value);
        Variable value = this.call(this.temp(), lhs, node.binary_operator, new Operand[]{rhs});
        this.addInstr((Instr)new PutGlobalVarInstr(node.name, (Operand)value));
        return value;
    }

    private Operand buildGlobalVariableAndWrite(Nodes.GlobalVariableAndWriteNode node) {
        return this.buildOpAsgnAnd(() -> this.buildGlobalVar(this.temp(), node.name), () -> this.buildGlobalAsgn(node.name, node.value));
    }

    private Operand buildGlobalVariableOrWrite(Nodes.GlobalVariableOrWriteNode node) {
        return this.buildOpAsgnOrWithDefined(node, result -> this.buildGlobalVar((Variable)result, node.name), () -> this.buildGlobalAsgn(node.name, node.value));
    }

    private Operand buildGlobalVariableWrite(Nodes.GlobalVariableWriteNode node) {
        return this.buildGlobalAsgn(node.name, node.value);
    }

    private Operand buildHash(Nodes.Node[] elements, boolean hasAssignments) {
        ArrayList<KeyValuePair> args = new ArrayList<KeyValuePair>();
        HashSet<Object> keysHack = new HashSet<Object>();
        Variable hash = null;
        Boolean duplicateCheck = this.fals();
        for (Nodes.Node pair : elements) {
            if (pair instanceof Nodes.AssocNode) {
                Operand keyOperand;
                Nodes.Node key = ((Nodes.AssocNode)pair).key;
                if (key instanceof Nodes.StringNode) {
                    keyOperand = this.buildFrozenString((Nodes.StringNode)key);
                    String hack = ((FrozenString)keyOperand).getByteList().toString();
                    if (!keysHack.add(hack)) {
                        this.getManager().getRuntime().getWarnings().warn("key \"" + hack + "\" is duplicated and overwritten on line " + (this.getLine(key) + 1));
                    }
                } else {
                    double hack;
                    keyOperand = this.build(key);
                    if (keyOperand instanceof Symbol) {
                        String hack2 = ((Symbol)keyOperand).getString();
                        if (!keysHack.add(hack2)) {
                            this.getManager().getRuntime().getWarnings().warn("key :" + hack2 + " is duplicated and overwritten on line " + (this.getLine(key) + 1));
                        }
                    } else if (keyOperand instanceof Fixnum) {
                        long hack3 = ((Fixnum)keyOperand).value;
                        if (!keysHack.add(new Long(hack3))) {
                            this.getManager().getRuntime().getWarnings().warn("key " + hack3 + " is duplicated and overwritten on line " + (this.getLine(key) + 1));
                        }
                    } else if (keyOperand instanceof Float && !keysHack.add(new Double(hack = ((Float)keyOperand).value))) {
                        this.getManager().getRuntime().getWarnings().warn("key " + hack + " is duplicated and overwritten on line " + (this.getLine(key) + 1));
                    }
                }
                args.add(new KeyValuePair((Object)keyOperand, (Object)this.buildWithOrder(((Nodes.AssocNode)pair).value, hasAssignments)));
                continue;
            }
            Nodes.AssocSplatNode assoc = (Nodes.AssocSplatNode)pair;
            boolean isLiteral = assoc.value instanceof Nodes.HashNode;
            Boolean boolean_ = duplicateCheck = isLiteral ? this.tru() : this.fals();
            if (hash == null) {
                hash = this.copy((Operand)new Hash(args));
                args = new ArrayList();
            } else if (!args.isEmpty()) {
                this.addInstr((Instr)new RuntimeHelperCall(hash, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash, new Hash(args), duplicateCheck}));
                args = new ArrayList();
            }
            Operand splat = this.buildWithOrder(assoc.value, hasAssignments);
            this.addInstr((Instr)new RuntimeHelperCall(hash, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash, splat, duplicateCheck}));
        }
        if (hash == null) {
            hash = this.copy((Operand)new Hash(args));
        } else if (!args.isEmpty()) {
            this.addInstr((Instr)new RuntimeHelperCall(hash, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash, new Hash(args), duplicateCheck}));
        }
        return hash;
    }

    private Operand buildIf(Variable result, Nodes.IfNode node) {
        return this.buildConditional(result, node.predicate, node.statements, node.consequent);
    }

    private Operand buildIndexAndWrite(Nodes.IndexAndWriteNode node) {
        return this.buildOpElementAsgnWith(node.receiver, node.arguments, node.block, node.value, this.fals());
    }

    private Operand buildIndexOperatorWrite(Nodes.IndexOperatorWriteNode node) {
        return this.buildOpElementAsgnWithMethod(node.receiver, node.arguments, node.block, node.value, node.binary_operator);
    }

    private Operand buildIndexOrWrite(Nodes.IndexOrWriteNode node) {
        return this.buildOpElementAsgnWith(node.receiver, node.arguments, node.block, node.value, this.tru());
    }

    private Operand buildInstanceVariableRead(Nodes.InstanceVariableReadNode node) {
        return this.buildInstVar(node.name);
    }

    private Operand buildInstanceVariableAndWrite(Nodes.InstanceVariableAndWriteNode node) {
        return this.buildOpAsgnAnd(() -> this.addResultInstr((ResultInstr)new GetFieldInstr(this.temp(), (Operand)this.buildSelf(), node.name, false)), () -> this.buildInstAsgn(node.name, node.value));
    }

    private Operand buildInstanceVariableOrWrite(Nodes.InstanceVariableOrWriteNode node) {
        return this.buildOpAsgnOr(() -> this.addResultInstr((ResultInstr)new GetFieldInstr(this.temp(), (Operand)this.buildSelf(), node.name, false)), () -> this.buildInstAsgn(node.name, node.value));
    }

    private Operand buildInstanceVariableWrite(Nodes.InstanceVariableWriteNode node) {
        return this.buildInstAsgn(node.name, node.value);
    }

    private Operand buildInteger(Nodes.IntegerNode node) {
        ByteList value = this.bytelistFrom(node);
        int base = node.isDecimal() ? 10 : (node.isOctal() ? 8 : (node.isHexadecimal() ? 16 : 2));
        int length = value.length();
        ByteList sanitizedValue = new ByteList(length);
        for (int i = 0; i < length; ++i) {
            int c = value.get(i);
            if (c == 95) continue;
            sanitizedValue.append(c);
        }
        IRubyObject number = RubyNumeric.str2inum((Ruby)this.getManager().runtime, (RubyString)this.getManager().getRuntime().newString(sanitizedValue), (int)base, (boolean)false, (boolean)false);
        return number instanceof RubyBignum ? new Bignum(((RubyBignum)number).getBigIntegerValue()) : this.fix(RubyNumeric.fix2long((IRubyObject)number));
    }

    private Operand buildInterpolatedMatchLastLine(Variable result, Nodes.InterpolatedMatchLastLineNode node) {
        return this.buildDRegex(result, node.parts, this.calculateRegexpOptions(node.flags));
    }

    private Operand buildInterpolatedRegularExpression(Variable result, Nodes.InterpolatedRegularExpressionNode node) {
        return this.buildDRegex(result, node.parts, this.calculateRegexpOptions(node.flags));
    }

    protected Operand buildDRegex(Variable result, Nodes.Node[] children, RegexpOptions options) {
        Object[] pieces;
        if (children.length == 1) {
            pieces = new Nodes.Node[children.length + 1];
            pieces[0] = new Nodes.StringNode(0, CommonByteLists.EMPTY.bytes(), 0, 0);
            pieces[1] = children[0];
        } else {
            pieces = children;
        }
        return super.buildDRegex(result, pieces, options);
    }

    private RegexpOptions calculateRegexpOptions(short flags) {
        RegexpOptions options = new RegexpOptions();
        options.setMultiline(Nodes.RegularExpressionFlags.isMultiLine(flags));
        options.setIgnorecase(Nodes.RegularExpressionFlags.isIgnoreCase(flags));
        options.setExtended(Nodes.RegularExpressionFlags.isExtended(flags));
        options.setOnce(Nodes.RegularExpressionFlags.isOnce(flags));
        if (Nodes.RegularExpressionFlags.isAscii8bit(flags)) {
            options.setEncodingNone(Nodes.RegularExpressionFlags.isAscii8bit(flags));
            options.setExplicitKCode(KCode.NONE);
        } else if (Nodes.RegularExpressionFlags.isUtf8(flags)) {
            options.setExplicitKCode(KCode.UTF8);
            options.setFixed(true);
        } else if (Nodes.RegularExpressionFlags.isEucJp(flags)) {
            options.setExplicitKCode(KCode.EUC);
            options.setFixed(true);
        } else if (Nodes.RegularExpressionFlags.isWindows31j(flags)) {
            options.setExplicitKCode(KCode.SJIS);
            options.setFixed(true);
        }
        return options;
    }

    private Operand buildInterpolatedString(Variable result, Nodes.InterpolatedStringNode node) {
        return this.buildDStr(result, node.parts, this.getEncoding(), false, this.getLine(node));
    }

    private Operand buildInterpolatedSymbol(Variable result, Nodes.InterpolatedSymbolNode node) {
        return this.buildDSymbol(result, node.parts, this.getEncoding(), this.getLine(node));
    }

    private Operand buildInterpolatedXString(Variable result, Nodes.InterpolatedXStringNode node) {
        return this.buildDXStr(result, node.parts, this.getEncoding(), this.getLine(node));
    }

    private Operand buildKeywordHash(Nodes.KeywordHashNode node, int[] flags) {
        flags[0] = flags[0] | 2;
        ArrayList<KeyValuePair> args = new ArrayList<KeyValuePair>();
        boolean hasAssignments = this.containsVariableAssignment(node);
        Variable hash = null;
        Boolean duplicateCheck = this.fals();
        if (node.elements.length == 1 && node.elements[0] instanceof Nodes.AssocSplatNode) {
            flags[0] = flags[0] | 4;
            Operand splat = this.buildWithOrder(((Nodes.AssocSplatNode)node.elements[0]).value, hasAssignments);
            return this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.HASH_CHECK, new Operand[]{splat}));
        }
        for (Nodes.Node pair : node.elements) {
            if (pair instanceof Nodes.AssocNode) {
                Operand keyOperand = this.build(((Nodes.AssocNode)pair).key);
                args.add(new KeyValuePair((Object)keyOperand, (Object)this.buildWithOrder(((Nodes.AssocNode)pair).value, hasAssignments)));
                continue;
            }
            flags[0] = flags[0] | 4;
            Nodes.AssocSplatNode assoc = (Nodes.AssocSplatNode)pair;
            boolean isLiteral = assoc.value instanceof Nodes.HashNode;
            Boolean boolean_ = duplicateCheck = isLiteral ? this.tru() : this.fals();
            if (hash == null) {
                hash = this.copy((Operand)new Hash(args));
                args = new ArrayList();
            } else if (!args.isEmpty()) {
                this.addInstr((Instr)new RuntimeHelperCall(hash, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash, new Hash(args), duplicateCheck}));
                args = new ArrayList();
            }
            Operand splat = this.buildWithOrder(assoc.value, hasAssignments);
            this.addInstr((Instr)new RuntimeHelperCall(hash, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash, splat, duplicateCheck}));
        }
        if (hash == null) {
            hash = this.copy((Operand)new Hash(args));
        } else if (!args.isEmpty()) {
            this.addInstr((Instr)new RuntimeHelperCall(hash, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{hash, new Hash(args), duplicateCheck}));
        }
        return hash;
    }

    private Operand buildLambda(Nodes.LambdaNode node) {
        StaticScope staticScope = this.createStaticScopeFrom(node.locals, StaticScope.Type.BLOCK);
        Signature signature = this.calculateSignature(node.parameters);
        staticScope.setSignature(signature);
        return this.buildLambda(node.parameters, node.body, staticScope, signature, this.getLine(node));
    }

    private Operand buildLocalVariableRead(Nodes.LocalVariableReadNode node) {
        return this.getLocalVariable(node.name, node.depth);
    }

    private Operand buildLocalAndVariableWrite(Nodes.LocalVariableAndWriteNode node) {
        return this.buildOpAsgnAnd(() -> this.getLocalVariable(node.name, node.depth), () -> this.buildLocalVariableAssign(node.name, node.depth, node.value));
    }

    private Operand buildLocalOrVariableWrite(Nodes.LocalVariableOrWriteNode node) {
        return this.buildOpAsgnOr(() -> this.getLocalVariable(node.name, node.depth), () -> this.buildLocalVariableAssign(node.name, node.depth, node.value));
    }

    private Operand buildLocalVariableWrite(Nodes.LocalVariableWriteNode node) {
        return this.buildLocalVariableAssign(node.name, node.depth, node.value);
    }

    private Operand buildMatchLastLine(Variable result, Nodes.MatchLastLineNode node) {
        return this.buildMatch(result, (Operand)new Regexp(new ByteList(node.unescaped, this.getRegexpEncoding(node.unescaped, node.flags)), this.calculateRegexpOptions(node.flags)));
    }

    private Operand buildMatchPredicate(Nodes.MatchPredicateNode node) {
        Variable result = this.copy((Operand)this.tru());
        this.buildPatternMatch(result, (Operand)this.copy((Operand)this.nil()), this.copy((Operand)this.nil()), node.pattern, this.build(node.value), false, true, this.copy((Operand)this.nil()));
        return result;
    }

    private Operand buildMatchRequired(Nodes.MatchRequiredNode node) {
        return this.buildPatternCase(node.value, new Nodes.Node[]{new Nodes.InNode(node.pattern, null, 0, 0)}, null);
    }

    private Operand buildMatchWrite(Variable result, Nodes.MatchWriteNode node) {
        Operand receiver = this.build(node.call.receiver);
        Operand value = this.build(node.call.arguments.arguments[0]);
        if (result == null) {
            result = this.temp();
        }
        this.addInstr((Instr)new MatchInstr(this.scope, result, receiver, value));
        for (int i = 0; i < node.targets.length; ++i) {
            Nodes.LocalVariableTargetNode target = node.targets[i];
            this.addInstr((Instr)new SetCapturedVarInstr((Variable)this.getLocalVariable(target.name, target.depth), (Operand)result, target.name));
        }
        return result;
    }

    private Operand buildMissing(Nodes.MissingNode node) {
        System.out.println("uh oh");
        return this.nil();
    }

    private Operand buildModule(Nodes.ModuleNode node) {
        return this.buildModule(this.determineBaseName(node.constant_path), node.constant_path, node.body, this.createStaticScopeFrom(node.locals, StaticScope.Type.LOCAL), this.getLine(node), this.getEndLine(node));
    }

    private Operand buildMultiWriteNode(Nodes.MultiWriteNode node) {
        Variable value = this.getValueInTemporaryVariable(this.build(node.value));
        Variable rhs = node.value instanceof Nodes.ArrayNode ? value : this.addResultInstr((ResultInstr)new ToAryInstr(this.temp(), (Operand)value));
        this.buildMultiAssignment(node.lefts, node.rest, node.rights, (Operand)rhs);
        return value;
    }

    private void buildMultiAssignment(Nodes.Node[] pre, Nodes.Node rest, Nodes.Node[] post, Operand values) {
        ArrayList<Tuple> assigns = new ArrayList<Tuple>();
        for (int i = 0; i < pre.length; ++i) {
            assigns.add(new Tuple((Object)pre[i], (Object)this.addResultInstr((ResultInstr)new ReqdArgMultipleAsgnInstr(this.temp(), values, i))));
        }
        if (rest != null) {
            if (rest instanceof Nodes.SplatNode) {
                Nodes.Node realTarget = ((Nodes.SplatNode)rest).expression;
                assigns.add(new Tuple((Object)realTarget, (Object)this.addResultInstr((ResultInstr)new RestArgMultipleAsgnInstr(this.temp(), values, 0, pre.length, post.length))));
            } else {
                assigns.add(new Tuple(null, (Object)this.addResultInstr((ResultInstr)new RestArgMultipleAsgnInstr(this.temp(), values, 0, pre.length, post.length))));
            }
        }
        for (int j = 0; j < post.length; ++j) {
            assigns.add(new Tuple((Object)post[j], (Object)this.addResultInstr((ResultInstr)new ReqdArgMultipleAsgnInstr(this.temp(), values, j, pre.length, post.length))));
        }
        for (Tuple assign : assigns) {
            this.buildAssignment((Nodes.Node)assign.a, (Operand)assign.b);
        }
    }

    private Operand buildNext(Nodes.NextNode node) {
        return this.buildNext(this.buildArgumentsAsArgument(node.arguments), this.getLine(node));
    }

    private Operand buildNumberedReferenceRead(Nodes.NumberedReferenceReadNode node) {
        return this.buildNthRef(node.number);
    }

    private Operand buildOr(Nodes.OrNode node) {
        return this.buildOr(this.build(node.left), () -> this.build(node.right), this.binaryType(node.left));
    }

    private void buildParameters(Nodes.ParametersNode parameters) {
        if (parameters == null) {
            Variable keywords = this.addResultInstr((ResultInstr)new ReceiveKeywordsInstr(this.temp(), false, false));
            this.buildArity(false, false, (Operand)keywords, 0, -1, 0);
            return;
        }
        if (parameters.keyword_rest instanceof Nodes.ForwardingParameterNode) {
            Variable keywords = this.addResultInstr((ResultInstr)new ReceiveKeywordsInstr(this.temp(), true, true));
            this.receiveNonBlockArgs(parameters, keywords, true);
            RubySymbol restName = this.symbol(CommonByteLists.FWD_REST);
            RubySymbol kwrestName = this.symbol(CommonByteLists.FWD_KWREST);
            RubySymbol blockName = this.symbol(CommonByteLists.FWD_BLOCK);
            this.addInstr((Instr)new ReceiveRestArgInstr(this.argumentResult(restName), keywords, parameters.requireds.length, parameters.requireds.length));
            this.addInstr((Instr)new ReceiveKeywordRestArgInstr(this.argumentResult(kwrestName), keywords));
            Variable blockVar = this.argumentResult(blockName);
            Variable tmp = this.addResultInstr((ResultInstr)new LoadImplicitClosureInstr(this.temp()));
            this.addInstr((Instr)new ReifyClosureInstr(blockVar, tmp));
            this.addArgumentDescription(ArgumentType.rest, restName);
            this.addArgumentDescription(ArgumentType.keyrest, kwrestName);
            this.addArgumentDescription(ArgumentType.block, blockName);
            return;
        }
        boolean hasRest = parameters.rest != null;
        boolean hasKeywords = parameters.keywords.length != 0 || parameters.keyword_rest != null;
        Variable keywords = this.addResultInstr((ResultInstr)new ReceiveKeywordsInstr(this.temp(), hasRest, hasKeywords));
        if (parameters.keyword_rest instanceof Nodes.NoKeywordsParameterNode) {
            this.if_not((Operand)keywords, (Operand)UndefinedValue.UNDEFINED, () -> this.addRaiseError("ArgumentError", "no keywords accepted"));
        }
        this.receiveNonBlockArgs(parameters, keywords, hasKeywords);
        if (hasKeywords) {
            int keywordsCount = parameters.keywords.length;
            Nodes.Node[] kwArgs = parameters.keywords;
            for (int i = 0; i < keywordsCount; ++i) {
                if (kwArgs[i] instanceof Nodes.OptionalKeywordParameterNode) {
                    this.buildKeywordParameter(keywords, ((Nodes.OptionalKeywordParameterNode)kwArgs[i]).name, ((Nodes.OptionalKeywordParameterNode)kwArgs[i]).value);
                    continue;
                }
                this.buildKeywordParameter(keywords, ((Nodes.RequiredKeywordParameterNode)kwArgs[i]).name, null);
            }
        }
        if (parameters.keyword_rest != null && parameters.keyword_rest instanceof Nodes.KeywordRestParameterNode) {
            ArgumentType type;
            RubySymbol key = ((Nodes.KeywordRestParameterNode)parameters.keyword_rest).name;
            if (key == null) {
                key = this.symbol(CommonByteLists.STAR_STAR);
                type = ArgumentType.anonkeyrest;
            } else {
                type = ArgumentType.keyrest;
            }
            this.addArgumentDescription(type, key);
            this.addInstr((Instr)new ReceiveKeywordRestArgInstr((Variable)this.getNewLocalVariable(key, 0), keywords));
        }
        this.receiveBlockArg(parameters.block);
        int preCount = parameters.requireds.length;
        int optCount = parameters.optionals.length;
        int keywordsCount = parameters.keywords.length;
        int postCount = parameters.posts.length;
        int keyRest = parameters.keyword_rest == null ? -1 : preCount + optCount + postCount + keywordsCount;
        int requiredCount = preCount + postCount;
        this.buildArity(hasRest, hasKeywords, (Operand)keywords, optCount, keyRest, requiredCount);
    }

    private void buildArity(boolean hasRest, boolean hasKeywords, Operand keywords, int optCount, int keyRest, int requiredCount) {
        if (this.scope instanceof IRMethod) {
            this.addInstr((Instr)new CheckArityInstr(requiredCount, optCount, hasRest, keyRest, keywords));
        } else if (this.scope instanceof IRClosure && hasKeywords) {
            this.addInstr((Instr)new CheckArityInstr(requiredCount, optCount, hasRest, keyRest, keywords));
        }
    }

    private void buildKeywordParameter(Variable keywords, RubySymbol key, Nodes.Node value) {
        boolean isOptional = value != null;
        this.addKeyArgDesc(key, isOptional);
        this.label("kw_param_end", end -> {
            LocalVariable av = this.getNewLocalVariable(key, 0);
            this.addInstr((Instr)new ReceiveKeywordArgInstr((Variable)av, keywords, key));
            this.addInstr((Instr)BNEInstr.create((Label)end, (Operand)av, (Operand)UndefinedValue.UNDEFINED));
            if (isOptional) {
                this.addInstr((Instr)new CopyInstr((Variable)av, (Operand)this.nil()));
                this.copy((Variable)av, this.build(value));
            } else {
                this.addInstr((Instr)new RaiseRequiredKeywordArgumentError(key));
            }
        });
    }

    private Operand buildPostExecution(Nodes.PostExecutionNode node) {
        return this.buildPostExe(node.statements, this.getLine(node));
    }

    private Operand buildPreExecution(Nodes.PreExecutionNode node) {
        return this.buildPreExe(node.statements);
    }

    private Operand buildRational(Nodes.RationalNode node) {
        if (node.numeric instanceof Nodes.FloatNode) {
            BigDecimal bd = new BigDecimal(this.bytelistFrom(node.numeric).toString());
            BigDecimal denominator = BigDecimal.ONE.scaleByPowerOfTen(bd.scale());
            BigDecimal numerator = bd.multiply(denominator);
            try {
                return new Rational((ImmutableLiteral)this.fix(numerator.longValueExact()), (ImmutableLiteral)this.fix(denominator.longValueExact()));
            }
            catch (ArithmeticException ae) {
                return new Rational((ImmutableLiteral)new Bignum(numerator.toBigIntegerExact()), (ImmutableLiteral)new Bignum(denominator.toBigIntegerExact()));
            }
        }
        return new Rational((ImmutableLiteral)this.build(node.numeric), (ImmutableLiteral)this.fix(1L));
    }

    private Operand buildRange(Nodes.RangeNode node) {
        return this.buildRange(node.left, node.right, node.isExcludeEnd());
    }

    private Operand buildRedo(Nodes.RedoNode node) {
        return this.buildRedo(this.getLine(node));
    }

    private Operand buildRegularExpression(Nodes.RegularExpressionNode node) {
        return new Regexp(new ByteList(node.unescaped, this.getRegexpEncoding(node.unescaped, node.flags)), this.calculateRegexpOptions(node.flags));
    }

    private Encoding hackRegexpEncoding(byte[] data) {
        int i;
        int len;
        Encoding encoding = this.getEncoding();
        int length = data.length;
        for (i = 0; i < length && (len = encoding.length(data, i, length)) != -1; i += len) {
        }
        if (i == length) {
            return encoding;
        }
        return ASCIIEncoding.INSTANCE;
    }

    private Operand buildRescueModifier(Nodes.RescueModifierNode node) {
        return this.buildEnsureInternal(node.expression, null, null, node.rescue_expression, null, true, null, true, null);
    }

    private Operand buildRetry(Nodes.RetryNode node) {
        return this.buildRetry(this.getLine(node));
    }

    private Operand buildReturn(Nodes.ReturnNode node) {
        if (this.isTopLevel() && node.arguments != null) {
            this.scope.getManager().getRuntime().getWarnings().warn(this.getFileName(), this.getLine(node) + 1, "argument of top-level return is ignored");
        }
        Nil args = node.arguments == null ? this.nil() : this.buildYieldArgs(node.arguments.arguments, new int[1]);
        return this.buildReturn((Operand)args, this.getLine(node));
    }

    private Operand buildRestKeywordArgs(Nodes.KeywordHashNode keywordArgs, int[] flags) {
        flags[0] = flags[0] | 4;
        Nodes.Node[] pairs = keywordArgs.elements;
        boolean containsVariableAssignment = this.containsVariableAssignment(keywordArgs);
        if (pairs.length == 1) {
            Operand splat = this.buildWithOrder(((Nodes.AssocSplatNode)pairs[0]).value, containsVariableAssignment);
            return this.addResultInstr((ResultInstr)new RuntimeHelperCall(this.temp(), RuntimeHelperCall.Methods.HASH_CHECK, new Operand[]{splat}));
        }
        Variable splatValue = this.copy((Operand)new Hash(new ArrayList()));
        for (int i = 0; i < pairs.length; ++i) {
            Operand splat = this.buildWithOrder(pairs[i], containsVariableAssignment);
            this.addInstr((Instr)new RuntimeHelperCall(splatValue, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{splatValue, splat, this.fals()}));
        }
        return splatValue;
    }

    private Operand buildSingletonClass(Nodes.SingletonClassNode node) {
        return this.buildSClass(node.expression, node.body, this.createStaticScopeFrom(node.locals, StaticScope.Type.LOCAL), this.getLine(node), this.getEndLine(node));
    }

    private Operand buildSourceEncoding() {
        return this.buildEncoding(this.getEncoding());
    }

    private Operand buildSourceFile() {
        return new FrozenString(this.scope.getFile());
    }

    private Operand buildSourceLine(Nodes.Node node) {
        return this.fix(this.getLine(node) + 1);
    }

    private Operand buildSplat(Nodes.SplatNode node) {
        return this.buildSplat(this.build(node.expression));
    }

    private Operand buildSplat(Operand value) {
        return this.addResultInstr((ResultInstr)new BuildSplatInstr(this.temp(), value, true));
    }

    private Operand buildString(Nodes.StringNode node) {
        if (node.isFrozen()) {
            return new FrozenString(this.bytelistFrom(node), 0, this.scope.getFile(), this.getLine(node));
        }
        return this.copy(this.temp(), (Operand)new MutableString(this.bytelistFrom(node), 0, this.scope.getFile(), this.getLine(node)));
    }

    private Operand buildFrozenString(Nodes.StringNode node) {
        return new FrozenString(this.bytelistFrom(node), 0, this.scope.getFile(), this.getLine(node));
    }

    private Operand buildSuper(Variable result, Nodes.SuperNode node) {
        return this.buildSuper(result, node.block, node.arguments, this.getLine(node), node.hasNewLineFlag());
    }

    private Operand buildSymbol(Nodes.SymbolNode node) {
        return new Symbol(this.symbol(node));
    }

    private Operand buildUndef(Nodes.UndefNode node) {
        Nil last = this.nil();
        for (Operand name : this.buildNodeList(node.names)) {
            last = this.buildUndef(name);
        }
        return last;
    }

    private Operand buildUnless(Variable result, Nodes.UnlessNode node) {
        return this.buildConditional(result, node.predicate, node.consequent, node.statements);
    }

    private Operand buildUntil(Nodes.UntilNode node) {
        return this.buildConditionalLoop(node.predicate, node.statements, false, !node.isBeginModifier());
    }

    private void buildWhenSplatValues(Variable eqqResult, Nodes.Node node, Operand testValue, Label bodyLabel, Set<IRubyObject> seenLiterals) {
        if (node instanceof Nodes.StatementsNode) {
            this.buildWhenValues(eqqResult, ((Nodes.StatementsNode)node).body, testValue, bodyLabel, seenLiterals);
        } else if (node instanceof Nodes.SplatNode) {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, node, seenLiterals, true);
        } else {
            this.buildWhenValue(eqqResult, testValue, bodyLabel, node, seenLiterals, true);
        }
    }

    private Operand buildWhile(Nodes.WhileNode node) {
        return this.buildConditionalLoop(node.predicate, node.statements, true, !node.isBeginModifier());
    }

    protected boolean alwaysFalse(Nodes.Node node) {
        return false;
    }

    protected boolean alwaysTrue(Nodes.Node node) {
        return false;
    }

    protected Nodes.Node[] exceptionNodesFor(Nodes.RescueNode node) {
        return node.exceptions;
    }

    protected Nodes.Node bodyFor(Nodes.RescueNode node) {
        return node.statements;
    }

    protected Nodes.RescueNode optRescueFor(Nodes.RescueNode node) {
        return node.consequent;
    }

    protected boolean isSideEffectFree(Nodes.Node node) {
        return false;
    }

    protected boolean isErrorInfoGlobal(Nodes.Node body) {
        return false;
    }

    protected int dynamicPiece(Operand[] pieces, int i, Nodes.Node pieceNode, Encoding encoding) {
        Object piece;
        int estimatedSize;
        block4: {
            estimatedSize = 4;
            while (true) {
                if (pieceNode instanceof Nodes.StringNode) {
                    ByteList data = encoding == null ? this.bytelistFrom((Nodes.StringNode)pieceNode) : new ByteList(((Nodes.StringNode)pieceNode).unescaped, encoding);
                    piece = ((Nodes.StringNode)pieceNode).isFrozen() ? new FrozenString(data, 0, this.scope.getFile(), this.getLine(pieceNode)) : new MutableString(data, 0, this.scope.getFile(), this.getLine(pieceNode));
                    estimatedSize += data.realSize();
                    break block4;
                }
                if (!(pieceNode instanceof Nodes.EmbeddedStatementsNode)) break;
                if (this.scope.maybeUsingRefinements()) {
                    Variable result = this.temp();
                    this.addInstr((Instr)new AsStringInstr(this.scope, result, this.build(((Nodes.EmbeddedStatementsNode)pieceNode).statements), this.scope.maybeUsingRefinements()));
                    piece = result;
                    break block4;
                }
                pieceNode = ((Nodes.EmbeddedStatementsNode)pieceNode).statements;
            }
            piece = this.build(pieceNode);
        }
        if (piece instanceof MutableString) {
            piece = ((MutableString)piece).frozenString;
        }
        pieces[i] = piece == null ? this.nil() : piece;
        return estimatedSize;
    }

    protected void receiveBlockArg(Nodes.Node node) {
        Nodes.BlockParameterNode blockArg = (Nodes.BlockParameterNode)node;
        if (blockArg != null) {
            RubySymbol name = blockArg.name == null ? this.symbol(CommonByteLists.FWD_BLOCK) : blockArg.name;
            Variable blockVar = this.argumentResult(name);
            this.addArgumentDescription(ArgumentType.block, name);
            Variable tmp = this.temp();
            this.addInstr((Instr)new LoadImplicitClosureInstr(tmp));
            this.addInstr((Instr)new ReifyClosureInstr(blockVar, tmp));
        }
    }

    protected void receiveNonBlockArgs(Nodes.ParametersNode args, Variable keywords, boolean hasKeywords) {
        int preCount = args.requireds.length;
        int optCount = args.optionals.length;
        boolean hasRest = args.rest != null;
        int postCount = args.posts.length;
        int requiredCount = preCount + postCount;
        int argIndex = 0;
        Nodes.Node[] pres = args.requireds;
        int i = 0;
        while (i < preCount) {
            this.receivePreArg(pres[i], keywords, argIndex);
            ++i;
            ++argIndex;
        }
        Nodes.OptionalParameterNode[] opts = args.optionals;
        if (optCount > 0) {
            int j = 0;
            while (j < optCount) {
                Label variableAssigned = this.getNewLabel();
                Nodes.OptionalParameterNode optArg = opts[j];
                RubySymbol argName = optArg.name;
                Variable argVar = this.argumentResult(argName);
                this.addArgumentDescription(ArgumentType.opt, argName);
                this.addInstr((Instr)new ReceiveOptArgInstr(argVar, keywords, j, requiredCount, preCount));
                this.addInstr((Instr)BNEInstr.create((Label)variableAssigned, (Operand)argVar, (Operand)UndefinedValue.UNDEFINED));
                this.copy(argVar, (Operand)this.nil());
                this.copy(argVar, this.build(optArg.value));
                this.addInstr((Instr)new LabelInstr(variableAssigned));
                ++j;
                ++argIndex;
            }
        }
        if (hasRest) {
            RubySymbol argName;
            if (args.rest instanceof Nodes.RestParameterNode) {
                Nodes.RestParameterNode restArg = (Nodes.RestParameterNode)args.rest;
                if (restArg.name == null) {
                    argName = this.symbol("*");
                    this.addArgumentDescription(ArgumentType.anonrest, argName);
                } else {
                    argName = restArg.name;
                    this.addArgumentDescription(ArgumentType.rest, argName);
                }
            } else {
                argName = null;
            }
            this.addInstr((Instr)new ReceiveRestArgInstr(this.argumentResult(argName), keywords, argIndex, requiredCount + optCount));
        }
        Nodes.Node[] posts = args.posts;
        for (int i2 = 0; i2 < postCount; ++i2) {
            this.receivePostArg(posts[i2], keywords, i2, preCount, optCount, hasRest, postCount);
        }
    }

    public void receivePreArg(Nodes.Node node, Variable keywords, int argIndex) {
        if (node instanceof Nodes.RequiredParameterNode) {
            RubySymbol name = ((Nodes.RequiredParameterNode)node).name;
            this.addArgumentDescription(ArgumentType.req, name);
            this.addInstr((Instr)new ReceivePreReqdArgInstr(this.argumentResult(name), keywords, argIndex));
        } else if (node instanceof Nodes.MultiTargetNode) {
            Variable v = this.temp();
            this.addInstr((Instr)new ReceivePreReqdArgInstr(v, keywords, argIndex));
            this.addArgumentDescription(ArgumentType.anonreq, null);
            Variable rhs = this.addResultInstr((ResultInstr)new ToAryInstr(this.temp(), (Operand)v));
            this.buildMultiAssignment(((Nodes.MultiTargetNode)node).lefts, ((Nodes.MultiTargetNode)node).rest, ((Nodes.MultiTargetNode)node).rights, (Operand)rhs);
        } else if (node instanceof Nodes.ClassVariableTargetNode) {
            Variable v = this.temp();
            this.addInstr((Instr)new ReceivePreReqdArgInstr(v, keywords, argIndex));
            this.addInstr((Instr)new PutClassVariableInstr(this.classVarDefinitionContainer(), ((Nodes.ClassVariableTargetNode)node).name, (Operand)v));
        } else if (node instanceof Nodes.ConstantTargetNode) {
            Variable v = this.temp();
            this.addInstr((Instr)new ReceivePreReqdArgInstr(v, keywords, argIndex));
            this.putConstant(((Nodes.ConstantTargetNode)node).name, (Operand)v);
        } else if (node instanceof Nodes.InstanceVariableTargetNode) {
            Variable v = this.temp();
            this.addInstr((Instr)new ReceivePreReqdArgInstr(v, keywords, argIndex));
            this.addInstr((Instr)new PutFieldInstr((Operand)this.buildSelf(), ((Nodes.InstanceVariableTargetNode)node).name, (Operand)v));
        } else if (node instanceof Nodes.LocalVariableTargetNode) {
            LocalVariable v = this.getLocalVariable(((Nodes.LocalVariableTargetNode)node).name, ((Nodes.LocalVariableTargetNode)node).depth);
            this.addInstr((Instr)new ReceivePreReqdArgInstr((Variable)v, keywords, argIndex));
        } else {
            throw this.notCompilable("Can't build required parameter node", node);
        }
    }

    public void receivePostArg(Nodes.Node node, Variable keywords, int argIndex, int preCount, int optCount, boolean hasRest, int postCount) {
        if (node instanceof Nodes.RequiredParameterNode) {
            RubySymbol argName = ((Nodes.RequiredParameterNode)node).name;
            this.addArgumentDescription(ArgumentType.req, argName);
            this.addInstr((Instr)new ReceivePostReqdArgInstr(this.argumentResult(argName), keywords, argIndex, preCount, optCount, hasRest, postCount));
        } else if (node instanceof Nodes.MultiTargetNode) {
            Variable v = this.temp();
            this.addInstr((Instr)new ReceivePostReqdArgInstr(v, keywords, argIndex, preCount, optCount, hasRest, postCount));
            this.addArgumentDescription(ArgumentType.anonreq, null);
            Variable tmp = this.temp();
            this.addInstr((Instr)new ToAryInstr(tmp, (Operand)v));
            this.buildMultiAssignment(((Nodes.MultiTargetNode)node).lefts, ((Nodes.MultiTargetNode)node).rest, ((Nodes.MultiTargetNode)node).rights, (Operand)tmp);
        } else {
            throw this.notCompilable("Can't build required parameter node", node);
        }
    }

    private void addKeyArgDesc(RubySymbol key, boolean isOptional) {
        this.addArgumentDescription(isOptional ? ArgumentType.key : ArgumentType.keyreq, key);
    }

    private Operand buildProgram(Nodes.ProgramNode node) {
        return this.build(node.statements);
    }

    private Operand buildStatements(Nodes.StatementsNode node) {
        if (node == null) {
            return this.nil();
        }
        Nil result = null;
        for (Nodes.Node child : node.body) {
            result = this.build(child);
        }
        return result == null ? this.nil() : result;
    }

    protected void buildWhenArgs(Nodes.WhenNode whenNode, Operand testValue, Label bodyLabel, Set<IRubyObject> seenLiterals) {
        Variable eqqResult = this.temp();
        Nodes.Node[] exprNodes = whenNode.conditions;
        if (exprNodes.length == 1) {
            if (exprNodes[0] instanceof Nodes.SplatNode) {
                this.buildWhenSplatValues(eqqResult, exprNodes[0], testValue, bodyLabel, seenLiterals);
            } else {
                this.buildWhenValue(eqqResult, testValue, bodyLabel, exprNodes[0], seenLiterals, false);
            }
        } else {
            for (Nodes.Node value : exprNodes) {
                this.buildWhenValue(eqqResult, testValue, bodyLabel, value, seenLiterals, value instanceof Nodes.SplatNode);
            }
        }
    }

    private Operand buildXString(Variable result, Nodes.XStringNode node) {
        ByteList value = new ByteList(node.unescaped, this.getEncoding());
        int codeRange = StringSupport.codeRangeScan((Encoding)value.getEncoding(), (ByteList)value);
        return this.fcall(result, (Operand)this.buildSelf(), "`", new Operand[]{new FrozenString(value, codeRange, this.scope.getFile(), this.getLine(node))});
    }

    Operand buildYield(Variable aResult, Nodes.YieldNode node) {
        IRScope hardScope;
        if (aResult == null) {
            aResult = this.temp();
        }
        if ((hardScope = this.scope.getNearestNonClosurelikeScope()) instanceof IRScriptBody || hardScope instanceof IRModuleBody) {
            this.throwSyntaxError(this.getLine(node), "Invalid yield");
        }
        Variable result = aResult;
        int[] flags = new int[]{0};
        boolean unwrap = true;
        if (node.arguments != null && node.arguments.arguments != null && node.arguments.arguments.length == 1 && !(node.arguments.arguments[0] instanceof Nodes.KeywordHashNode) && !(node.arguments.arguments[0] instanceof Nodes.SplatNode)) {
            unwrap = false;
        }
        Operand value = this.buildYieldArgs(node.arguments != null ? node.arguments.arguments : null, flags);
        this.addInstr((Instr)new YieldInstr(result, (Operand)this.getYieldClosureVariable(), value, flags[0], unwrap));
        return result;
    }

    Operand buildYieldArgs(Nodes.Node[] args, int[] flags) {
        if (args == null) {
            return UndefinedValue.UNDEFINED;
        }
        if (args.length == 1) {
            if (args[0] instanceof Nodes.SplatNode) {
                flags[0] = flags[0] | 1;
                return new Splat(this.buildSplat((Nodes.SplatNode)args[0]));
            }
            if (args[0] instanceof Nodes.KeywordHashNode) {
                return this.buildKeywordHash((Nodes.KeywordHashNode)args[0], flags);
            }
            return this.build(args[0]);
        }
        int lastSplat = -1;
        Operand[] operands = new Operand[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof Nodes.SplatNode) {
                if (lastSplat != -1) {
                    operands[i] = this.twoArgs(operands, lastSplat, i, this.buildSplat((Nodes.SplatNode)args[i]), flags);
                } else {
                    flags[0] = flags[0] | 1;
                    operands[i] = i == 0 ? this.buildSplat((Nodes.SplatNode)args[i]) : this.catArgs(operands, 0, i, this.buildSplat((Nodes.SplatNode)args[i]), flags);
                }
                lastSplat = i;
                continue;
            }
            operands[i] = args[i] instanceof Nodes.KeywordHashNode ? this.buildKeywordHash((Nodes.KeywordHashNode)args[i], flags) : this.build(args[i]);
        }
        if (lastSplat != -1) {
            if (lastSplat == args.length - 1) {
                return operands[lastSplat];
            }
            return this.pushArgs(operands, lastSplat, args.length, flags);
        }
        return new Array(operands);
    }

    private Operand twoArgs(Operand[] operands, int lastSplat, int newSplat, Operand newSplatValue, int[] flags) {
        Operand lhs = this.pushArgs(operands, lastSplat, newSplat, flags);
        return this.addResultInstr((ResultInstr)new BuildCompoundArrayInstr(this.temp(), lhs, newSplatValue, false, (flags[0] & 4) != 0));
    }

    private Operand pushArgs(Operand[] operands, int lastSplat, int newSplat, int[] flags) {
        int length = newSplat - lastSplat - 1;
        if (length == 0) {
            return operands[lastSplat];
        }
        Object rhs = length == 1 && (flags[0] & 4) != 0 ? operands[lastSplat + 1] : IRBuilderPrism.subArray(operands, lastSplat + 1, length);
        return this.addResultInstr((ResultInstr)new BuildCompoundArrayInstr(this.temp(), operands[lastSplat], (Operand)rhs, (flags[0] & 4) != 0, (flags[0] & 4) != 0));
    }

    private Operand catArgs(Operand[] args, int start, int length, Operand splat, int[] flags) {
        Array lhs = IRBuilderPrism.subArray(args, start, length);
        return this.addResultInstr((ResultInstr)new BuildCompoundArrayInstr(this.temp(), (Operand)lhs, splat, false, (flags[0] & 4) != 0));
    }

    private static Array subArray(Operand[] args, int start, int length) {
        Operand[] elts = new Operand[length];
        System.arraycopy(args, start, elts, 0, length);
        Array lhs = new Array(elts);
        return lhs;
    }

    protected boolean containsVariableAssignment(Nodes.Node node) {
        return node instanceof Nodes.LocalVariableWriteNode || node instanceof Nodes.LocalVariableOperatorWriteNode || node instanceof Nodes.LocalVariableAndWriteNode || node instanceof Nodes.LocalVariableOrWriteNode || node instanceof Nodes.InstanceVariableWriteNode || node instanceof Nodes.InstanceVariableOperatorWriteNode || node instanceof Nodes.InstanceVariableAndWriteNode || node instanceof Nodes.InstanceVariableOrWriteNode || node instanceof Nodes.GlobalVariableWriteNode || node instanceof Nodes.GlobalVariableOperatorWriteNode || node instanceof Nodes.GlobalVariableAndWriteNode || node instanceof Nodes.GlobalVariableOrWriteNode || node instanceof Nodes.ClassVariableWriteNode || node instanceof Nodes.ClassVariableOperatorWriteNode || node instanceof Nodes.ClassVariableAndWriteNode || node instanceof Nodes.ClassVariableOrWriteNode;
    }

    boolean containsVariableAssignment(Nodes.Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            if (!this.containsVariableAssignment(nodes[i])) continue;
            return true;
        }
        return false;
    }

    protected Operand frozen_string(Nodes.Node node) {
        return this.buildString((Nodes.StringNode)node);
    }

    protected Operand getContainerFromCPath(Nodes.Node node) {
        if (node instanceof Nodes.ConstantReadNode) {
            return this.findContainerModule();
        }
        if (node instanceof Nodes.ConstantPathNode) {
            Nodes.ConstantPathNode path = (Nodes.ConstantPathNode)node;
            if (path.parent == null) {
                return this.getManager().getObjectClass();
            }
            return this.build(path.parent);
        }
        throw this.notCompilable("Unsupported node in module path", node);
    }

    protected Variable buildPatternEach(Label testEnd, Variable result, Operand original, Variable deconstructed, Operand value, Nodes.Node exprNodes, boolean inAlternation, boolean isSinglePattern, Variable errorString) {
        if (exprNodes instanceof Nodes.StatementsNode && ((Nodes.StatementsNode)exprNodes).body.length == 1) {
            this.buildPatternEach(testEnd, result, original, deconstructed, value, ((Nodes.StatementsNode)exprNodes).body[0], inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof Nodes.ArrayPatternNode) {
            Nodes.ArrayPatternNode node = (Nodes.ArrayPatternNode)exprNodes;
            this.buildArrayPattern(testEnd, result, deconstructed, node.constant, node.requireds, node.rest, node.posts, value, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof Nodes.CapturePatternNode) {
            this.buildPatternEach(testEnd, result, original, deconstructed, value, ((Nodes.CapturePatternNode)exprNodes).value, inAlternation, isSinglePattern, errorString);
            this.buildAssignment(((Nodes.CapturePatternNode)exprNodes).target, value);
        } else if (exprNodes instanceof Nodes.HashPatternNode) {
            Nodes.HashPatternNode node = (Nodes.HashPatternNode)exprNodes;
            Object[] keys = this.getKeys(node);
            this.buildHashPattern(testEnd, result, deconstructed, node.constant, node, keys, node.rest, value, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof Nodes.FindPatternNode) {
            this.getManager().getRuntime().getWarnings().warnExperimental(this.getFileName(), this.getLine(exprNodes) + 1, "Find pattern is experimental, and the behavior may change in future versions of Ruby!");
            Nodes.FindPatternNode node = (Nodes.FindPatternNode)exprNodes;
            this.buildFindPattern(testEnd, result, deconstructed, node.constant, node.left, node.requireds, node.right, value, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof Nodes.IfNode) {
            Nodes.IfNode node = (Nodes.IfNode)exprNodes;
            this.buildPatternEachIf(result, original, deconstructed, value, node.predicate, node.statements, node.consequent, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof Nodes.UnlessNode) {
            Nodes.UnlessNode node = (Nodes.UnlessNode)exprNodes;
            this.buildPatternEachIf(result, original, deconstructed, value, node.predicate, node.consequent, node.statements, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof Nodes.LocalVariableTargetNode) {
            this.buildPatternLocal((Nodes.LocalVariableTargetNode)exprNodes, value, inAlternation);
        } else if (exprNodes instanceof Nodes.ImplicitNode) {
            this.buildPatternEach(testEnd, result, original, deconstructed, value, ((Nodes.ImplicitNode)exprNodes).value, inAlternation, isSinglePattern, errorString);
        } else if (exprNodes instanceof Nodes.AssocSplatNode) {
            Nodes.AssocSplatNode node = (Nodes.AssocSplatNode)exprNodes;
            this.buildPatternLocal((Nodes.LocalVariableTargetNode)node.value, value, inAlternation);
        } else if (!(exprNodes instanceof Nodes.ImplicitRestNode)) {
            if (exprNodes instanceof Nodes.SplatNode) {
                this.buildAssignment(((Nodes.SplatNode)exprNodes).expression, value);
            } else if (exprNodes instanceof Nodes.AlternationPatternNode) {
                this.buildPatternOr(testEnd, original, result, deconstructed, value, ((Nodes.AlternationPatternNode)exprNodes).left, ((Nodes.AlternationPatternNode)exprNodes).right, isSinglePattern, errorString);
            } else {
                Operand expression = this.build(exprNodes);
                boolean needsSplat = exprNodes instanceof Nodes.AssocSplatNode;
                this.addInstr((Instr)new EQQInstr(this.scope, result, expression, value, needsSplat, this.scope.maybeUsingRefinements()));
            }
        }
        return result;
    }

    private Encoding getRegexpEncoding(byte[] bytes, short flags) {
        Encoding encoding = this.getRegexpEncodingFromOptions(flags);
        return encoding == null ? this.hackRegexpEncoding(bytes) : encoding;
    }

    private Encoding getRegexpEncodingFromOptions(short flags) {
        return Nodes.RegularExpressionFlags.isAscii8bit(flags) ? ASCIIEncoding.INSTANCE : (Nodes.RegularExpressionFlags.isUtf8(flags) ? UTF8Encoding.INSTANCE : (Nodes.RegularExpressionFlags.isEucJp(flags) ? EUCJPEncoding.INSTANCE : (Nodes.RegularExpressionFlags.isWindows31j(flags) ? Windows_31JEncoding.INSTANCE : null)));
    }

    private Nodes.Node[] getKeys(Nodes.HashPatternNode node) {
        int i;
        int length = node.elements.length;
        Nodes.Node[] keys = new Nodes.Node[length];
        for (i = 0; i < length && node.elements[i] instanceof Nodes.AssocNode; ++i) {
            Nodes.AssocNode assoc = node.elements[i];
            keys[i] = assoc.key;
        }
        if (i != length) {
            Nodes.Node[] newKeys = new Nodes.Node[i];
            System.arraycopy(keys, 0, newKeys, 0, i);
            return newKeys;
        }
        return keys;
    }

    void buildPatternLocal(Nodes.LocalVariableTargetNode node, Operand value, boolean inAlternation) {
        this.buildPatternLocal(value, node.name, this.getLine(node), node.depth, inAlternation);
    }

    protected void buildAssocs(Label testEnd, Operand original, Variable result, Nodes.HashPatternNode assocs, boolean inAlteration, boolean isSinglePattern, Variable errorString, boolean hasRest, Variable d) {
        for (Nodes.AssocNode node : assocs.elements) {
            if (!(node instanceof Nodes.AssocNode)) continue;
            Operand key = this.build(node.key);
            this.call(result, (Operand)d, "key?", new Operand[]{key});
            this.cond_ne(testEnd, (Operand)result, (Operand)this.tru());
            String method = hasRest ? "delete" : "[]";
            Variable value = this.call(this.temp(), (Operand)d, method, new Operand[]{key});
            Nodes.Node valueNode = node.value;
            if (valueNode == null) {
                Nodes.Node keyHack = node.key;
                RubySymbol name = null;
                if (keyHack instanceof Nodes.SymbolNode) {
                    name = this.symbol((Nodes.SymbolNode)keyHack);
                } else {
                    this.throwSyntaxError(this.getLine(node), "what else is in this");
                }
                this.buildPatternLocal((Operand)value, name, this.getLine(node), 0, inAlteration);
            } else {
                this.buildPatternEach(testEnd, result, original, this.copy((Operand)this.nil()), (Operand)value, node.value, inAlteration, isSinglePattern, errorString);
            }
            this.cond_ne(testEnd, (Operand)result, (Operand)this.tru());
        }
    }

    protected boolean isNilRest(Nodes.Node rest) {
        return rest instanceof Nodes.NoKeywordsParameterNode;
    }

    protected Nodes.Node getInExpression(Nodes.Node node) {
        return ((Nodes.InNode)node).pattern;
    }

    protected Nodes.Node getInBody(Nodes.Node node) {
        return ((Nodes.InNode)node).statements;
    }

    protected boolean isBareStar(Nodes.Node node) {
        return node instanceof Nodes.AssocSplatNode && ((Nodes.AssocSplatNode)node).value == null;
    }

    private int getEndLine(Nodes.Node node) {
        int endOffset = node.endOffset();
        if (endOffset >= this.nodeSource.bytes.length) {
            endOffset = this.nodeSource.bytes.length - 1;
        }
        return this.nodeSource.line(endOffset) - 1;
    }

    protected int getLine(Nodes.Node node) {
        int line = this.nodeSource.line(node.startOffset);
        return line - 1;
    }

    public LocalVariable getLocalVariable(RubySymbol name, int scopeDepth) {
        int depth = this.scope.correctVariableDepthForForLoopsForEncoding(scopeDepth);
        return this.scope.getLocalVariable(name, depth);
    }

    protected IRubyObject getWhenLiteral(Nodes.Node node) {
        Ruby runtime = this.scope.getManager().getRuntime();
        if (node instanceof Nodes.IntegerNode) {
            return null;
        }
        if (node instanceof Nodes.FloatNode) {
            return null;
        }
        if (node instanceof Nodes.ImaginaryNode) {
            return null;
        }
        if (node instanceof Nodes.RationalNode) {
            return null;
        }
        if (node instanceof Nodes.NilNode) {
            return runtime.getNil();
        }
        if (node instanceof Nodes.TrueNode) {
            return runtime.getTrue();
        }
        if (node instanceof Nodes.FalseNode) {
            return runtime.getFalse();
        }
        if (node instanceof Nodes.SymbolNode) {
            return this.symbol((Nodes.SymbolNode)node);
        }
        if (node instanceof Nodes.StringNode) {
            return runtime.newString(this.bytelistFrom((Nodes.StringNode)node));
        }
        return null;
    }

    protected boolean isLiteralString(Nodes.Node node) {
        return node instanceof Nodes.StringNode;
    }

    protected boolean needsDefinitionCheck(Nodes.Node node) {
        return !(node instanceof Nodes.ClassVariableWriteNode) && !(node instanceof Nodes.ConstantPathWriteNode) && !(node instanceof Nodes.LocalVariableWriteNode) && !(node instanceof Nodes.LocalVariableReadNode) && !(node instanceof Nodes.FalseNode) && !(node instanceof Nodes.GlobalVariableWriteNode) && !(node instanceof Nodes.MatchRequiredNode) && !(node instanceof Nodes.MatchPredicateNode) && !(node instanceof Nodes.NilNode) && !(node instanceof Nodes.SelfNode) && !(node instanceof Nodes.TrueNode);
    }

    protected void receiveMethodArgs(Nodes.DefNode defNode) {
        this.buildParameters(defNode.parameters);
    }

    protected Operand setupCallClosure(Nodes.Node args, Nodes.Node block) {
        if (block == null) {
            if (args != null && this.isForwardingArguments(args)) {
                return this.getLocalVariable(this.symbol(CommonByteLists.FWD_BLOCK), this.scope.getStaticScope().isDefined("&"));
            }
            return NullBlock.INSTANCE;
        }
        if (block instanceof Nodes.BlockNode) {
            return this.build(block);
        }
        if (block instanceof Nodes.BlockArgumentNode) {
            return this.buildBlockArgument((Nodes.BlockArgumentNode)block);
        }
        throw this.notCompilable("Encountered unexpected block node", block);
    }

    private boolean isForwardingArguments(Nodes.Node args) {
        for (Nodes.Node child : ((Nodes.ArgumentsNode)args).arguments) {
            if (!(child instanceof Nodes.ForwardingArgumentsNode)) continue;
            return true;
        }
        return false;
    }

    private ByteList bytelistFrom(Nodes.StringNode node) {
        ASCIIEncoding encoding = node.isForcedBinaryEncoding() ? ASCIIEncoding.INSTANCE : (node.isForcedUtf8Encoding() ? UTF8Encoding.INSTANCE : this.getEncoding());
        return new ByteList(node.unescaped, (Encoding)encoding);
    }

    private ByteList bytelistFrom(Nodes.Node node) {
        return new ByteList(this.source, node.startOffset, node.length);
    }

    public static Signature calculateSignature(Nodes.ParametersNode parameters) {
        if (parameters == null) {
            return Signature.NO_ARGUMENTS;
        }
        int pre = parameters.requireds.length;
        int opt = parameters.optionals.length;
        int post = parameters.posts.length;
        int keywords = parameters.keywords.length;
        Signature.Rest rest = parameters.rest == null ? Signature.Rest.NONE : (parameters.rest instanceof Nodes.ImplicitRestNode ? Signature.Rest.ANON : Signature.Rest.NORM);
        int requiredKeywords = 0;
        if (keywords > 0) {
            for (int i = 0; i < parameters.keywords.length; ++i) {
                if (!(parameters.keywords[i] instanceof Nodes.RequiredKeywordParameterNode)) continue;
                ++requiredKeywords;
            }
        }
        int keywordRestIndex = parameters.keyword_rest == null ? -1 : pre + opt + post + keywords;
        return Signature.from((int)pre, (int)opt, (int)post, (int)keywords, (int)requiredKeywords, (Signature.Rest)rest, (int)keywordRestIndex);
    }

    private Signature calculateSignature(Nodes.Node parameters) {
        if (parameters == null) {
            return Signature.NO_ARGUMENTS;
        }
        if (parameters instanceof Nodes.BlockParametersNode) {
            return IRBuilderPrism.calculateSignature(((Nodes.BlockParametersNode)parameters).parameters);
        }
        if (parameters instanceof Nodes.NumberedParametersNode) {
            return Signature.from((int)((Nodes.NumberedParametersNode)parameters).maximum, (int)0, (int)0, (int)0, (int)0, (Signature.Rest)Signature.Rest.NONE, (int)-1);
        }
        throw this.notCompilable("Unknown signature for block parameters", parameters);
    }

    private Signature calculateSignatureFor(Nodes.Node node) {
        if (node instanceof Nodes.MultiTargetNode) {
            Nodes.MultiTargetNode multi = (Nodes.MultiTargetNode)node;
            Signature.Rest rest = multi.rest != null ? Signature.Rest.NORM : Signature.Rest.NONE;
            return Signature.from((int)multi.lefts.length, (int)0, (int)multi.rights.length, (int)0, (int)0, (Signature.Rest)rest, (int)-1);
        }
        return Signature.from((int)1, (int)0, (int)0, (int)0, (int)0, (Signature.Rest)Signature.Rest.NONE, (int)-1);
    }

    public StaticScope createStaticScopeFrom(RubySymbol[] tokens, StaticScope.Type type) {
        return IRBuilderPrism.createStaticScopeFrom(this.staticScope.getFile(), tokens, type, this.staticScope);
    }

    public static StaticScope createStaticScopeFrom(String fileName, RubySymbol[] tokens, StaticScope.Type type, StaticScope parent) {
        String[] strings = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            strings[i] = tokens[i].idString();
        }
        return StaticScopeFactory.newStaticScope((StaticScope)parent, (StaticScope.Type)type, (String)fileName, (String[])strings, (int)-1);
    }

    private ByteList determineBaseName(Nodes.Node node) {
        if (node instanceof Nodes.ConstantReadNode) {
            return ((Nodes.ConstantReadNode)node).name.getBytes();
        }
        if (node instanceof Nodes.ConstantPathNode) {
            return ((Nodes.ConstantPathNode)node).name.getBytes();
        }
        throw this.notCompilable("Unsupported node in module path", node);
    }

    private CallType determineCallType(Nodes.Node node) {
        return node == null || node instanceof Nodes.SelfNode ? CallType.FUNCTIONAL : CallType.NORMAL;
    }

    protected boolean canBeLazyMethod(Nodes.DefNode node) {
        return true;
    }

    private RubySymbol globalVariableName(Nodes.Node node) {
        if (node instanceof Nodes.GlobalVariableReadNode) {
            return ((Nodes.GlobalVariableReadNode)node).name;
        }
        if (node instanceof Nodes.BackReferenceReadNode) {
            return ((Nodes.BackReferenceReadNode)node).name;
        }
        if (node instanceof Nodes.NumberedReferenceReadNode) {
            return this.symbol("$" + ((Nodes.NumberedReferenceReadNode)node).number);
        }
        throw this.notCompilable("Unknown global variable type", node);
    }

    private NotCompilableException notCompilable(String message, Nodes.Node node) {
        int line = this.scope.getLine() + 1;
        String loc = this.scope.getFile() + ":" + line;
        String what = node != null ? node.getClass().getSimpleName() + " - " + loc : loc;
        return new NotCompilableException(message + " (" + what + ").");
    }

    private boolean hasOnlyRestKwargs(Nodes.Node[] elements) {
        for (Nodes.Node element : elements) {
            if (element instanceof Nodes.AssocSplatNode) continue;
            return false;
        }
        return true;
    }

    protected Operand putConstant(Nodes.ConstantPathNode path, Operand value) {
        return this.putConstant(this.buildModuleParent(path.parent), path.name, value);
    }

    protected RubySymbol symbol(Nodes.SymbolNode node) {
        short flags = node.flags;
        Object encoding = Nodes.SymbolFlags.isForcedUsAsciiEncoding(flags) ? USASCIIEncoding.INSTANCE : (Nodes.SymbolFlags.isForcedUtf8Encoding(flags) ? UTF8Encoding.INSTANCE : (Nodes.SymbolFlags.isForcedBinaryEncoding(flags) ? ASCIIEncoding.INSTANCE : this.getEncoding()));
        ByteList bytelist = new ByteList(node.unescaped, (Encoding)encoding);
        if (RubyString.scanForCodeRange((ByteList)bytelist) == 48) {
            Ruby runtime = this.getManager().getRuntime();
            throw runtime.newSyntaxError(RubyStringBuilder.str((Ruby)runtime, (String)("invalid symbol in encoding " + this.getEncoding() + " :\""), (IRubyObject)RubyStringBuilder.inspectIdentifierByteList((Ruby)runtime, (ByteList)bytelist), (String)"\""));
        }
        return this.symbol(bytelist);
    }

    protected Nodes.Node referenceFor(Nodes.RescueNode node) {
        return node.reference;
    }

    protected Nodes.Node whenBody(Nodes.WhenNode arm) {
        return arm.statements;
    }

    protected Operand buildOpAsgnOrWithDefined(Nodes.Node definitionNode, IRBuilder.VoidCodeBlockOne getter, IRBuilder.CodeBlock setter) {
        Label existsDone = this.getNewLabel();
        Label done = this.getNewLabel();
        Operand def = this.buildGetDefinition2(definitionNode);
        Variable result = def instanceof Variable ? (Variable)def : this.copy(this.temp(), def);
        this.addInstr(IRBuilderPrism.createBranch((Operand)result, (Operand)this.nil(), (Label)existsDone));
        getter.run((Operand)result);
        this.addInstr((Instr)new LabelInstr(existsDone));
        this.addInstr(IRBuilderPrism.createBranch((Operand)result, (Operand)this.getManager().getTrue(), (Label)done));
        Operand value = setter.run();
        this.copy(result, value);
        this.addInstr((Instr)new LabelInstr(done));
        return result;
    }
}

