/*
 * Decompiled with CFR 0.152.
 */
package org.prism;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class ParsingOptions {
    public static byte[] serialize(byte[] filepath, int line, byte[] encoding, boolean frozenStringLiteral, SyntaxVersion version, byte[][][] scopes) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ParsingOptions.write(output, ParsingOptions.serializeInt(filepath.length));
        ParsingOptions.write(output, filepath);
        ParsingOptions.write(output, ParsingOptions.serializeInt(line));
        ParsingOptions.write(output, ParsingOptions.serializeInt(encoding.length));
        ParsingOptions.write(output, encoding);
        if (frozenStringLiteral) {
            output.write(1);
        } else {
            output.write(0);
        }
        output.write(version.getValue());
        ParsingOptions.write(output, ParsingOptions.serializeInt(scopes.length));
        for (byte[][] scope : scopes) {
            ParsingOptions.write(output, ParsingOptions.serializeInt(scope.length));
            for (byte[] local : scope) {
                ParsingOptions.write(output, ParsingOptions.serializeInt(local.length));
                ParsingOptions.write(output, local);
            }
        }
        return output.toByteArray();
    }

    private static void write(ByteArrayOutputStream output, byte[] bytes) {
        output.write(bytes, 0, bytes.length);
    }

    private static byte[] serializeInt(int n) {
        ByteBuffer buffer = ByteBuffer.allocate(4).order(ByteOrder.nativeOrder());
        buffer.putInt(n);
        return buffer.array();
    }

    public static enum SyntaxVersion {
        LATEST(0),
        V3_3_0(1);

        private final int value;

        private SyntaxVersion(int value) {
            this.value = value;
        }

        public byte getValue() {
            return (byte)this.value;
        }
    }
}

