/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.ivars;

import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.runtime.ivars.VariableAccessor;

public class SynchronizedVariableAccessor
extends VariableAccessor {
    public SynchronizedVariableAccessor(RubyClass realClass, String name2, int index2, int classId) {
        super(realClass, name2, index2, classId);
    }

    @Override
    public void set(Object object, Object value2) {
        ((RubyBasicObject)object).ensureInstanceVariablesSettable();
        SynchronizedVariableAccessor.setVariable((RubyBasicObject)object, this.realClass, this.index, value2);
    }

    public static void setVariableChecked(RubyBasicObject self2, RubyClass realClass, int index2, Object value2) {
        self2.ensureInstanceVariablesSettable();
        SynchronizedVariableAccessor.setVariable(self2, realClass, index2, value2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setVariable(RubyBasicObject self2, RubyClass realClass, int index2, Object value2) {
        RubyBasicObject rubyBasicObject = self2;
        synchronized (rubyBasicObject) {
            SynchronizedVariableAccessor.ensureTable((RubyBasicObject)self2, (RubyClass)realClass, (int)index2)[index2] = value2;
        }
    }

    private static Object[] ensureTable(RubyBasicObject self2, RubyClass realClass, int index2) {
        Object[] currentTable = self2.varTable;
        if (currentTable == null) {
            return SynchronizedVariableAccessor.createTable(self2, realClass);
        }
        if (currentTable.length <= index2) {
            return SynchronizedVariableAccessor.growTable(self2, realClass, currentTable);
        }
        return currentTable;
    }

    private static Object[] createTable(RubyBasicObject self2, RubyClass realClass) {
        self2.varTable = new Object[realClass.getVariableTableSizeWithExtras()];
        return self2.varTable;
    }

    private static Object[] growTable(RubyBasicObject self2, RubyClass realClass, Object[] currentTable) {
        Object[] newTable = new Object[realClass.getVariableTableSizeWithExtras()];
        System.arraycopy(currentTable, 0, newTable, 0, currentTable.length);
        self2.varTable = newTable;
        return newTable;
    }
}

