/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.embed.internal;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jruby.embed.internal.LocalContext;

class ThreadLocalContext {
    private final ConcurrentHashMap<LocalContextCleaningAction, Object> contextRefs = new ConcurrentHashMap();
    private final Supplier<LocalContext> localContextFactory;
    private final Cleaner cleaner = new Cleaner();
    private volatile ThreadLocal<AtomicReference<LocalContextCleaningAction>> contextHolder = new ThreadLocal<AtomicReference<LocalContextCleaningAction>>(){

        @Override
        protected AtomicReference<LocalContextCleaningAction> initialValue() {
            LocalContextCleaningAction ctx = new LocalContextCleaningAction(ThreadLocalContext.this.contextRefs, (LocalContext)ThreadLocalContext.this.localContextFactory.get());
            AtomicReference<LocalContextCleaningAction> ref = new AtomicReference<LocalContextCleaningAction>(ctx);
            ctx.register(ref, ThreadLocalContext.this.cleaner);
            if (ThreadLocalContext.this.contextHolder == null) {
                ctx.run();
            }
            return ref;
        }
    };

    public ThreadLocalContext(Supplier<LocalContext> localContextFactory) {
        this.localContextFactory = localContextFactory;
    }

    public LocalContext get() {
        return (LocalContext)this.contextHolder.get().get().get();
    }

    public void terminate() {
        this.cleaner.interrupt();
        this.contextHolder = null;
        for (LocalContextCleaningAction ref : this.contextRefs.keySet()) {
            ref.run();
        }
    }

    private static class Cleaner
    extends Thread {
        private final ReferenceQueue<AtomicReference<LocalContextCleaningAction>> q = new ReferenceQueue();

        public Cleaner() {
            this.setName("JRuby-ThreadLocalContext-Cleaner-" + this.getId());
            this.setDaemon(true);
            this.start();
        }

        @Override
        public void run() {
            while (!Cleaner.interrupted()) {
                Reference<AtomicReference<LocalContextCleaningAction>> cleanable;
                try {
                    cleanable = this.q.remove();
                }
                catch (InterruptedException e) {
                    break;
                }
                ((CleanerReference)cleanable).cleanup.run();
            }
        }
    }

    private static class CleanerReference
    extends PhantomReference<AtomicReference<LocalContextCleaningAction>> {
        private Runnable cleanup;

        public CleanerReference(AtomicReference<LocalContextCleaningAction> referent, ReferenceQueue<AtomicReference<LocalContextCleaningAction>> q, Runnable cleanup) {
            super(referent, q);
            this.cleanup = cleanup;
        }
    }

    static class LocalContextCleaningAction
    extends AtomicReference<LocalContext>
    implements Runnable {
        private static final long serialVersionUID = 1L;
        private final ConcurrentHashMap<LocalContextCleaningAction, Object> contextRefs;
        private CleanerReference phantomReference;

        private LocalContextCleaningAction(ConcurrentHashMap<LocalContextCleaningAction, Object> contextRefs, LocalContext context) {
            super(context);
            this.contextRefs = contextRefs;
            contextRefs.put(this, this);
        }

        @Override
        public void run() {
            LocalContext lc = this.getAndSet(null);
            if (lc != null) {
                lc.remove();
            }
            this.contextRefs.remove(this);
        }

        private void register(AtomicReference<LocalContextCleaningAction> ref, Cleaner cleaner) {
            this.phantomReference = new CleanerReference(ref, cleaner.q, this);
        }
    }
}

